<?php
/**
 * perintah : /odojrekap <text>
 * perintah untuk melihat rekap ALL unit
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;

class OdojrekapCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'odojrekap';

    /**
     * @var string
     */
    protected $description = 'Odoj rekap all unit Command';

    /**
     * @var string
     */
    protected $usage = '/odojrekap <text>';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {
        $message = $this->getMessage();
        $chat_id = $message->getChat()->getId();
        $user_id = $message->getFrom()->getId();
        $command = strtolower(DB::clearDoubleSpace($message->getText(true)));

        //Send chat action
        Request::sendChatAction([
            'chat_id' => $chat_id,
            'action'  => 'typing',
        ]);

        # saring user yang aktif saja yang dilayani
        if ($result = DB::getPdo()->query("SELECT is_odoj, status, id_jabatan FROM am_user WHERE id='" .$user_id. "' AND status='1'" )) {
            $result = $result->fetchAll();
            $is_odoj = $result[0]['is_odoj'];
            $status = $result[0]['status'];
            $id_jabatan = $result[0]['id_jabatan'];

            if ($status == 1) {

                # cek perintah benar ga formatnya
                $exp = explode(" ",$command);
                $list_val = array_search('list', $exp);
                $perintah_list = $exp[$list_val+1];

                # cek apakah group odoj yang di cari ditentukan (perintah ini bisa dilakukan oleh root atau user tertentu)
                # perintahnya : odoj list rekak nomor_group
                // $proses_lanjut = true;
                // $index_terakhir = count($exp)-1;

                // if (self::cekIsGroupOdoj($exp[$index_terakhir]) != null) {
                //     if (DB::cekAksesMenu('odojrekap', '',$user_id) == true) {
                //         $id_group_odoj = self::cekIsGroupOdoj($exp[$index_terakhir]);
                //         unset($exp[$index_terakhir]);

                //     }else{
                //         $proses_lanjut = false;
                //     }
                // }

                if (DB::cekAksesMenu('odojrekap', $id_jabatan, $user_id) == true) {

                    # jika ada parameter tanggal pencarian
                    if (isset($exp[2])) {
                        # jika pencarian ada parameter tanggal dari -- tanggal sampai
                        if (isset($exp[3])) {
                            if (DB::cekFormatTanggal($exp[1]) === True AND DB::cekFormatTanggal($exp[2]) === True) {
                                $tanggal_dari = DB::getDateDB($exp[1]);
                                $tanggal_sampai = DB::getDateDB($exp[2]);

                                $tgl_dari = str_replace("-","",$tanggal_dari);
                                $tgl_sampai = str_replace("-","",$tanggal_sampai);

                                if ($tgl_sampai >= $tgl_dari) {
                                    # ambil data list odoj REKAP
                                    $text = self::getList($id_group_odoj, $tanggal_dari, $tanggal_sampai);

                                }else{
                                    $text = "⛔️ *ERROR:* _Format periode salah!_";
                                    $text .= "\n\nKetik: `odoj tanggal_dari tanggal_sampai rekap`";
                                }

                            }else{
                                $text = "⛔️ *ERROR:* _Format tanggal salah!_";
                                $text .= "\n\nContoh: `odoj 24-Oct-2018 30-Oct-2018 rekap`";
                            }
                        }else{
                            if (DB::cekFormatTanggal($exp[1]) === True) {
                                $tanggal_sampai = DB::getDateDB($exp[1]);
                                $tanggal_dari = $tanggal_sampai;

                                # ambil data list odoj
                                $text = self::getList($id_group_odoj, $tanggal_dari, $tanggal_sampai);

                            }elseif (DB::cekFormatBulan($exp[1]) === True) {
                            	$bulan = DB::getBulanDB($exp[1]);
                            	$tanggal_dari = $bulan . '-01';
                            	$tanggal_sampai = date('Y-m-t', strtotime($tanggal_dari));

                            	$text = self::getList($id_group_odoj, $tanggal_dari, $tanggal_sampai);
                            }
                            else{
                                $text = "⛔️ *ERROR:* _Format periode salah!_";
                                $text .= "\n\nContoh: `odoj Oct rekap`\n";
                                $text .= "\n\nContoh: `odoj Oct-2017 rekap`\n";
                                $text .= "\n\nContoh: `odoj 21-Oct-2018 rekap`\n";
                            }                
                        }

                    }else{
                        # cek dulu deadlinenya, sesuaikan tanggal list dengan tanggal deadline
                        $tanggal_sampai = DB::getTzJakarta('Date');
                        $tanggal_dari = substr($tanggal_sampai,0 , 7) . '-01';

                        # ambil data list odoj
                        $text = self::getList($id_group_odoj, $tanggal_dari, $tanggal_sampai);
                    }
                }else{
                    $text = "⛔️ *ERROR:* _Maaf, anda tidak mempunyai akses ke perintah ini._";  
                }

            }else{
                $text = "⛔️ *ERROR:* _Maaf, anda tidak terdaftar sebagai Santri Karya Daaruttauhiid._";  
            }
        }else{
            $text = "⛔️ *ERROR:* _Maaf, server sedang gangguan!_";
        }


        $data = [
            'chat_id' => $chat_id,
            'text'    => $text,
            'parse_mode' => 'Markdown'
        ];

        return Request::sendMessage($data);
    }

    public static function getList($id_group_odoj, $tanggal_dari, $tanggal_sampai)
    {
        
        # HEADER
        # bismillah
        $text = "o  ⁠⁠⁠بِسْـــــــــمِ اللهِ الرَّحْمَٰنِ الرَّحِيْمِ    o \n\n";
        $text .= "*REKAPITULASI ODOJ DAARUT TAUHIID* \n";
        

        # periode
        $tahun_tanggal_dari = date("Y", strtotime($tanggal_dari));
        $tahun_tanggal_sampai = date("Y", strtotime($tanggal_sampai));
        $bulan_tanggal_dari = date("m", strtotime($tanggal_dari));
        $bulan_tanggal_sampai = date("m", strtotime($tanggal_sampai));

        if ($tahun_tanggal_dari==$tahun_tanggal_sampai && $bulan_tanggal_dari==$bulan_tanggal_sampai) {
            $tanggal_dari_masehi = date("j", strtotime($tanggal_dari));
        }elseif ($tahun_tanggal_dari==$tahun_tanggal_sampai) {
            $tanggal_dari_masehi = date("j M", strtotime($tanggal_dari));
        }else{
            $tanggal_dari_masehi = date("j M Y", strtotime($tanggal_dari));
        }

        $tanggal_sampai_masehi = date("j M Y", strtotime($tanggal_sampai));
        $text .= "Periode : " . $tanggal_dari_masehi . ' - '. $tanggal_sampai_masehi;

        $text .= "\n\n";

        # ambil data dari table am_odoj
        //if ($result = DB::getPdo()->query("SELECT id_unit, COUNT(if(is_kholas=='1' || is_kholas=='2', 1, 0)) AS kholas FROM `am_odoj` WHERE tanggal_tugas>='$tanggal_dari' AND tanggal_tugas<='$tanggal_sampai' GROUP BY id_unit ")) {
        if ($result = DB::getPdo()->query("SELECT am_unit.nama_unit, COUNT(if(am_odoj.is_kholas='1' || am_odoj.is_kholas='2', 1, NULL)) AS kholas, COUNT(*) as jumlah FROM am_odoj JOIN am_unit ON am_odoj.id_unit=am_unit.id_unit WHERE am_odoj.tanggal_tugas>='$tanggal_dari' AND am_odoj.tanggal_tugas<='$tanggal_sampai' GROUP BY am_odoj.id_unit ORDER BY kholas ASC ")) {
            $result = $result->fetchAll();
            foreach ($result as $key) {
            	$unit = trim($key[0]);
            	$kholas = $key[1];
            	$jumlah_tugas = $key[2];
            	$belum_kholas = $jumlah_tugas - $kholas;
            	$persen_kholas = $kholas / $jumlah_tugas * 100;
            	$str_persen_kholas = number_format($persen_kholas). '%';

            	$text .= "✅ `" . str_pad($kholas,3) . "` ❎ `" . str_pad($belum_kholas,3) . "` 📖 `" . str_pad($jumlah_tugas, 3) . "` 📊 `" . str_pad($str_persen_kholas,4) ."` " . $unit . " \n";

            	# menghitung jumlah total
            	$total_kholas += $kholas;
            	$total_belum_kholas += $belum_kholas;
            	$total_jumlah_tugas += $jumlah_tugas;
            }

            $total_persen_kholas = $total_kholas / $total_jumlah_tugas * 100;
            $total_str_persen_kholas = number_format($total_persen_kholas). '%';

       		$text .= "------------------------------------------------------------\n";
        	$text .= "✅ `" . str_pad($total_kholas,3) . "` ❎ `" . str_pad($total_belum_kholas,3) . "` 📖 `" . str_pad($total_jumlah_tugas, 3) . "` 📊 `" . str_pad($total_str_persen_kholas,4) ."` TOTAL \n";
           
        } 

        $text .= "\n _\"Tetaplah Istiqomah, Insya Allah Jannah\"_";
        
        
        return $text;

    }

}