<?php
/**
 * perintah : /odojlist <text>
 * perintah untuk melihat daftar odoj 
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;

class OdojmemberCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'odojmember';

    /**
     * @var string
     */
    protected $description = 'Odoj list member Command';

    /**
     * @var string
     */
    protected $usage = '/odojmember <text>';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {
        $message = $this->getMessage();
        $chat_id = $message->getChat()->getId();
        $user_id = $message->getFrom()->getId();
        $command = strtolower(DB::clearDoubleSpace($message->getText(true)));
        $text = '';
        $i = 1;

        # saring user yang ikut ODOJ saja yang dilayani
        if ($result = DB::getPdo()->query("SELECT is_odoj, status FROM am_user WHERE id='" .$user_id. "' AND is_odoj='1' AND status='1'" )) {
            $result = $result->fetchAll();
            $is_odoj = $result[0]['is_odoj'];
            $status = $result[0]['status'];
            if ($is_odoj == 1 AND $status == 1) {
                if ($result = DB::getPdo()->query("SELECT nama FROM am_user WHERE is_odoj='1' AND status='1' AND id_group_odoj='0' ORDER BY nama ASC" )) {
                    $result = $result->fetchAll();
                    $text .= "*Daftar Member Baru*\n\n";
                    foreach ($result as $key) {
                        $text .= $i++ . ". " . $key[0] . "\n";
                    }
                }

            }else{
                $text = "⛔️ *ERROR:* _Maaf, anda tidak mengikuti program ODOJ._";  
            }
        }else{
            $text = "⛔️ *ERROR:* _Maaf, server sedang gangguan!_";
        }


        $data = [
            'chat_id' => $chat_id,
            'text'    => $text,
            'parse_mode' => 'Markdown'
        ];

        return Request::sendMessage($data);
    }
}