<?php
/**
 * perintah : /odojlist <text>
 * perintah untuk melihat daftar odoj 
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;

class OdojlistrekapmingguanCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'odojlistrekapmingguan';

    /**
     * @var string
     */
    protected $description = 'Odoj list reakap mingguan Command';

    /**
     * @var string
     */
    protected $usage = '/odojlistrekapmingguan <text>';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {
        $message = $this->getMessage();
        $chat_id = $message->getChat()->getId();
        $user_id = $message->getFrom()->getId();
        $command = strtolower(DB::clearDoubleSpace($message->getText(true)));

        //Send chat action
        Request::sendChatAction([
            'chat_id' => $chat_id,
            'action'  => 'typing',
        ]);

        # saring user yang ikut ODOJ saja yang dilayani
        if ($result = DB::getPdo()->query("SELECT is_odoj, status, id_jabatan FROM am_user WHERE id='" .$user_id. "' AND is_odoj='1' AND status='1'" )) {
            $result = $result->fetchAll();
            $is_odoj = $result[0]['is_odoj'];
            $status = $result[0]['status'];
            $id_jabatan = $result[0]['id_jabatan'];

            if ($is_odoj == 1 AND $status == 1) {

                # ambil id group odoj user
                $deadline = '00:00:00';
                if ($result = DB::getPdo()->query('SELECT am_group_odoj.deadline, am_user.id_group_odoj FROM am_user JOIN am_group_odoj ON am_user.id_group_odoj=am_group_odoj.id_group_odoj  WHERE am_user.id='. $user_id)) {
                    $result = $result->fetchAll();
                    $deadline = $result[0]['deadline'];
                    $id_group_odoj = $result[0]['id_group_odoj'];
                }

                # cek perintah benar ga formatnya
                $exp = explode(" ",$command);
                $list_val = array_search('list', $exp);
                $perintah_list = $exp[$list_val+1];

                # cek apakah group odoj yang di cari ditentukan (perintah ini bisa dilakukan oleh root atau user tertentu)
                # perintahnya : odoj list rekak nomor_group
                $proses_lanjut = true;
                $index_terakhir = count($exp)-1;

                if (self::cekIsGroupOdoj($exp[$index_terakhir]) != null) {
                    if (DB::cekAksesMenu('odojlistrekapmingguan', $id_jabatan,'') == true) {
                        $id_group_odoj = self::cekIsGroupOdoj($exp[$index_terakhir]);
                        unset($exp[$index_terakhir]);

                    }else{
                        $proses_lanjut = false;
                    }
                }

                if ($proses_lanjut == true) {

                    # jika ada parameter tanggal pencarian
                    if (isset($exp[3])) {
                        # jika pencarian ada parameter tanggal dari -- tanggal sampai
                        if (isset($exp[4])) {
                            if (DB::cekFormatTanggal($exp[1]) === True AND DB::cekFormatTanggal($exp[2]) === True) {
                                $tanggal_dari = DB::getDateDB($exp[1]);
                                $tanggal_sampai = DB::getDateDB($exp[2]);

                                $tgl_dari = str_replace("-","",$tanggal_dari);
                                $tgl_sampai = str_replace("-","",$tanggal_sampai);

                                if ($tgl_sampai >= $tgl_dari) {
                                    # ambil data list odoj
                                    $text = self::getList($id_group_odoj, $tanggal_dari, $tanggal_sampai, $perintah_list);

                                }else{
                                    $text = "⛔️ *ERROR:* _Format tanggal salah!_";
                                    $text .= "\n\nKetik: `odoj tanggal_dari tanggal_sampai list ".$perintah_list."`";
                                }

                            }else{
                                $text = "⛔️ *ERROR:* _Format tanggal salah!_";
                                $text .= "\n\nContoh: `odoj 24-Oct-2018 30-Oct-2018 list ".$perintah_list."`";
                            }
                        }else{
                            if (DB::cekFormatTanggal($exp[1]) === True) {
                                $tanggal_sampai = DB::getDateDB($exp[1]);
                                $tanggal_dari = date('Y-m-d', strtotime("-6 day", strtotime($tanggal_sampai)));

                                # ambil data list odoj
                                $text = self::getList($id_group_odoj, $tanggal_dari, $tanggal_sampai, $perintah_list);

                            }else{
                                $text = "⛔️ *ERROR:* _Format tanggal salah!_";
                                $text .= "\n\nContoh: `odoj 25-Oct-2018 list ".$perintah_list."`";
                            }                
                        }

                    }else{
                        # cek dulu deadlinenya, sesuaikan tanggal list dengan tanggal deadline
                        $tanggal_sampai = DB::getTzJakarta('Date');
                        $tanggal_dari = date('Y-m-d', strtotime("-6 day", strtotime($tanggal_sampai)));


                        # ambil data list odoj
                        $text = self::getList($id_group_odoj, $tanggal_dari, $tanggal_sampai, $perintah_list);
                    }
                }

            }else{
                $text = "⛔️ *ERROR:* _Maaf, anda tidak mengikuti program ODOJ._";  
            }
        }else{
            $text = "⛔️ *ERROR:* _Maaf, server sedang gangguan!_";
        }


        $data = [
            'chat_id' => $chat_id,
            'text'    => $text,
            'parse_mode' => 'Markdown'
        ];

        return Request::sendMessage($data);
    }

    public static function getList($id_group_odoj, $tanggal_dari, $tanggal_sampai, $rekap_mingguan)
    {

        # ambil data seting group odoj
        if ($result = DB::getPdo()->query('SELECT * FROM `am_group_odoj` WHERE id_group_odoj='. $id_group_odoj)) {
            $result = $result->fetchAll();

            $nomor_group    = $result[0]['nomor_group'];
            $nama_team      = $result[0]['nama_team'];
            $admin          = $result[0]['admin']; 
            $pj             = $result[0]['pj'];
            $deadline       = $result[0]['deadline'];
            $panggilan      = $result[0]['panggilan'];
            $juz_mode       = $result[0]['juz_mode'];
            $star           = $result[0]['star']; 
            $noreport       = $result[0]['noreport']; 
            $reward         = $result[0]['reward'];
            $reward_start_time = $result[0]['reward_start_time'];
            $reward_end_time = $result[0]['reward_end_time'];
            $icon           = $result[0]['icon'];
            $header         = $result[0]['header'];
            $footer         = $result[0]['footer']; 
            $view_message   = $result[0]['view_message']; 
            $sort           = $result[0]['sort']; 
        }  
        
        // membuat text laporan list odoj
        
        # HEADER
        # bismillah
        $text = "o  ⁠⁠⁠بِسْـــــــــمِ اللهِ الرَّحْمَٰنِ الرَّحِيْمِ    o \n\n";
        
        # Header Judul
        $arr_header = json_decode($header, true);
        foreach ($arr_header as $k => $v){
            $text .=  $v ."\n"; 
        }

        # periode
        $tahun_tanggal_dari = date("Y", strtotime($tanggal_dari));
        $tahun_tanggal_sampai = date("Y", strtotime($tanggal_dari));

        if ($tahun_tanggal_dari == $tahun_tanggal_sampai) {
            $tanggal_dari_masehi = date("j M", strtotime($tanggal_dari));
        }else{
            $tanggal_dari_masehi = date("j M Y", strtotime($tanggal_dari));
        }

        $tanggal_sampai_masehi = date("j M Y", strtotime($tanggal_sampai));
        $text .= "Periode : " . $tanggal_dari_masehi . ' - '. $tanggal_sampai_masehi;

        $text .= "\n";
        
        # reward
        if ($rekap_mingguan == 'rekap') {
            $arr_view_message = json_decode($view_message, true);
            if ($arr_view_message['show_reward_list'] == '1') {
                $text .= "\n";
                $arr_reward = json_decode($reward, true);
                $arr_reward_start_time = json_decode($reward_start_time, true);
                $arr_reward_end_time = json_decode($reward_end_time, true);

                for ($i=1; $i < count($arr_reward) ; $i++) { 
                     $text .=  $arr_reward_start_time[$i] . " - " . $arr_reward_end_time[$i] . " = " . $arr_reward[$i] . "\n"; 
                }
            }
        }

        # data list odoj
        $text .= "\n";
        $list_odoj = self::getListOdoj($id_group_odoj, $tanggal_dari, $tanggal_sampai, $rekap_mingguan, $nama_team);
        $text .= $list_odoj;

        # footer
    //    $text .= "\n";
        $arr_footer = json_decode($footer, true);
        foreach ($arr_footer as $k => $v){
            $text .=  $v ."\n"; 
        }
        
        return $text;

    }

    public static function getListOdoj($id_group_odoj, $tanggal_dari, $tanggal_sampai, $rekap_mingguan, $nama_team){

        # ambil icon kholas dll
        if ($result = DB::getPdo()->query("SELECT icon, noreport, panggilan FROM am_group_odoj WHERE id_group_odoj='". $id_group_odoj . "'")) {
            $result = $result->fetchAll();
            $icon_kholas = json_decode($result[0]['icon'], true);
            $icon_noreport = json_decode($result[0]['noreport'], true);
            $panggilan = $result[0]['panggilan'];
        }


        $text = "";
        $nama_anggota = '';
        $jumlah_kholas = 0;
        $jumlah_op = 0;
        $jumlah_nilai_reward = 0;
        $arr_tanggal_tugas = array();
        $arr_member_team = array();

        # keluarkan semua data dari database
        if ($result = DB::getPdo()->query("SELECT am_user.nama, am_odoj.juz, am_odoj.is_kholas, am_odoj.noreport, am_odoj.reward, am_odoj.tanggal_tugas, am_odoj.id_user, am_odoj.nilai_reward, am_odoj.team FROM am_odoj JOIN am_user ON am_odoj.id_user=am_user.id WHERE am_odoj.id_group_odoj='". $id_group_odoj . "' AND am_odoj.tanggal_tugas>='" .$tanggal_dari. "' AND   am_odoj.tanggal_tugas<='" .$tanggal_sampai. "' ORDER BY id_user ASC, tanggal_tugas")) {
            $result = $result->fetchAll();
            foreach ($result as $key) {
                # membuat array tanggal tugas, untuk perulangan data di array rekao
                $tanggal_tugas = $key[5];
                if (in_array($tanggal_tugas, $arr_tanggal_tugas)) {
                    # tanggal sudah ada jangan di masukan array
                }else{
                    $arr_tanggal_tugas[] = $tanggal_tugas;
                }
                
                # menyimpan array peringkat dan nama anggota 
                if ($nama_anggota != $key[0] AND $nama_anggota != '') {
                    
                    # membuat peringkat berdasarkan jumlah kholas dan jumlah nilai reward
                    if ($jumlah_kholas != 0 AND $jumlah_op != 0) {
                        $peringkat = $jumlah_kholas.$jumlah_op.$jumlah_nilai_reward;
                    }elseif($jumlah_kholas != 0){
                        $peringkat = $jumlah_kholas.'0'.$jumlah_nilai_reward;
                    }elseif($jumlah_op != 0){
                        $peringkat = $jumlah_op.$jumlah_nilai_reward;
                    }else{
                        $peringkat = 0;
                    }
                    
                    $arr_peringkat[$id_user] = $peringkat;
                    $arr_anggota[$id_user] = $nama_anggota;

                    $jumlah_kholas = 0;
                    $jumlah_op = 0;
                    $jumlah_nilai_reward = 0;
                }

                $nama_anggota = $key[0];
                $id_user = $key[6];

                # jika kholas atau tarjim maka dihitung jumlahnya
                if ($key[2] == 1 OR $key[2] == 2) {
                    $jumlah_kholas++;
                }elseif ($key[2] == 3) {
                    $jumlah_op++;
                }

                # jumlahkan juga nilai rewardnya
                $jumlah_nilai_reward += $key[7];

                # mencari icon 
                $juz = $key[1];
                $noreport = $key[3];
                $is_kholas = $key[2];

                if ($noreport != '') {

                    if ($noreport >= count($icon_noreport)) {
                        $noreport = count($icon_noreport)-1;
                    }

                    $icon = $icon_noreport[$noreport];

                }else{

                    if ($rekap_mingguan == 'rekap') {
                        # jika otw 
                        if ($is_kholas == 3) {
                            $icon = $icon_kholas[$is_kholas];
                        }else{
                            $icon = $key[4];
                        }
                        
                    }elseif($rekap_mingguan == 'mingguan'){
                        $icon = $icon_kholas[$is_kholas];
                    }

                }

                # simpan array icon icon 
                $arr_rekap[$id_user][$tanggal_tugas] = $icon;
                # simpan data team 
                $arr_member_team[$id_user] = $key[8];

            }


            # membuat peringkat berdasarkan jumlah kholas dan jumlah nilai reward yang terakhir ditambahkan
            if ($jumlah_kholas != 0 AND $jumlah_op != 0) {
                $peringkat = $jumlah_kholas.$jumlah_op.$jumlah_nilai_reward;
            }elseif($jumlah_kholas != 0){
                $peringkat = $jumlah_kholas.'0'.$jumlah_nilai_reward;
            }elseif($jumlah_op != 0){
                $peringkat = $jumlah_op.$jumlah_nilai_reward;
            }else{
                $peringkat = 0;
            }
            
            $arr_peringkat[$id_user] = $peringkat;
            $arr_anggota[$id_user] = $nama_anggota;

            # membuat data rekap
            # di sort array peringkat dari yang peringkat besar ke kecil
            arsort($arr_peringkat);
            asort($arr_tanggal_tugas);

            #mencari data team
            if ($hasil = DB::getPdo()->query("SELECT am_odoj.team FROM am_odoj WHERE id_group_odoj='". $id_group_odoj . "' AND am_odoj.tanggal_tugas>='" .$tanggal_dari. "' AND   am_odoj.tanggal_tugas<='" .$tanggal_sampai. "' GROUP BY team ORDER BY team ASC")) {
                $hasil = $hasil->fetchAll();
                foreach ($hasil as $key) {
                    $team[] = $key[0];
                }
            }

            # tampilkan berdasarkan team
            $nama_team = json_decode($nama_team, true);
            foreach ($team as $keyteam => $val) {
                if (count($team)>1) {
                    $text .= $nama_team['sebutan'] . " " . $nama_team[$keyteam+1] . "\n\n";
                }
            
                foreach ($arr_peringkat as $key => $value) {
                    $id_user = $key;
                    if ($arr_member_team[$id_user] == $val) {

                        foreach ($arr_tanggal_tugas as $key => $tgl) {
                            if (isset($arr_rekap[$id_user][$tgl])) {
                                $text .= $arr_rekap[$id_user][$tgl];
                            }else{
                                $text .= ⛔;
                            }
                            
                        }
                        $text .= " ".$panggilan." ".$arr_anggota[$id_user];
                        $text .= "\n";
                    }
                }
                $text .= "\n";
            }
            
        }

        return $text;
    } 


    public static function cekIsGroupOdoj($nomor_group){
        if ($result = DB::getPdo()->query("SELECT id_group_odoj FROM am_group_odoj WHERE nomor_group='". $nomor_group ."' ")) {
            $result = $result->fetchAll();
            if ($result) {
                return $result[0]['id_group_odoj'];
            }else{
                return null;
            }
        }else{
            return null;
        }        
    }  

}
