<?php
/**
 * perintah : /odojganti <text>
 * perintah untuk ganti parameter odoj
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;
use PDO;

class OdojgantiCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'odojganti';

    /**
     * @var string
     */
    protected $description = 'Odoj ganti Command';

    /**
     * @var string
     */
    protected $usage = '/odojganti <text>';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {
        $message = $this->getMessage();
        $chat_id = $message->getChat()->getId();
        $user_id = $message->getFrom()->getId();
        $command = DB::clearDoubleSpace($message->getText(true));

        //Send chat action
        Request::sendChatAction([
            'chat_id' => $chat_id,
            'action'  => 'typing',
        ]);

        # saring user yang ikut ODOJ saja yang dilayani
        if ($result = DB::getPdo()->query("SELECT is_odoj, status FROM am_user WHERE id='" .$user_id. "' AND is_odoj='1' AND status='1'" )) {
            $result = $result->fetchAll();
            $is_odoj = $result[0]['is_odoj'];
            $status = $result[0]['status'];
            if ($is_odoj == 1 AND $status == 1) {

                # saring juga user harus admin
                // if ($result = DB::getPdo()->query("SELECT am_user.id_group_odoj FROM am_user JOIN am_group_odoj ON am_user.id_group_odoj=am_group_odoj.id_group_odoj  WHERE am_user.id='" . $user_id . "' AND admin='" . $user_id . "'")) {
                //     $result = $result->fetchAll();
                
               if ($result = DB::getPdo()->query("SELECT id_group_odoj FROM am_group_odoj  WHERE id_group_telegram='" . $chat_id . "' AND admin='" . $user_id . "'")) {
                    $result = $result->fetchAll();
                    $id_group_odoj = $result[0]['id_group_odoj'];
                    if ($result) {
                        # proses update odoj
                        $text = self::updateGroupOdoj($command, $id_group_odoj);

                    }else{
                        $text = "⛔️ *ERROR:* _Maaf, kamu bukan admin program ODOJ._\n";  
                    //    $text .= "⚠️ Perintah harus dikirim dari group!!!"; 
                    }
                }

            }else{
                $text = "⛔️ *ERROR:* _Maaf, kamu tidak mengikuti program ODOJ._";  
            }
        }else{
            $text = "⛔️ *ERROR:* _Maaf, server sedang gangguan!_";
        }

        $data = [
            'chat_id' => $chat_id,
            'text'    => $text,
            'parse_mode' => 'Markdown'
        ];

        return Request::sendMessage($data);
    }


    public static function updateGroupOdoj($command, $id_group_odoj)
    {
        # cek perintah berdasarkan format
        $exp = explode(" ",$command);

        # jika ada parameter ganti maka proses
        # 
        if (isset($exp[2])) {
            # cek dulu parameternya gantinya
            $parameter = self::getParameterGanti($command, $id_group_odoj);
            if ( $parameter != '0') {
                $param = $parameter['parameter'];
                $value = $parameter['value'];

                $hasil = self::prosesGanti($param, $value, $id_group_odoj);

            }else{
                $arr_parameter['error'] = self::getError('salah parameter');               
            }
        }else{
            # disini bagian kalo tidak ada parameter yang dimasukan
            $arr_parameter['error'] = self::getError('no parameter'); 
        }

        if (!isset($arr_parameter['error'])) {
            $text = $hasil;
            
            // $hasil = self::prosesLapor($arr_parameter['nama'], $arr_parameter['juz'], $arr_parameter['tanggal_tugas'], $arr_parameter['tanggal_kholas'], $arr_parameter['waktu_kholas'], $arr_parameter['is_kholas'], $id_group_odoj); 
            // if ($hasil['successful'] == '1') {

            //     $text = self::getLaporan($hasil['user_id'], $hasil['tanggal_tugas']);
                
            // }else{
            //     $text = $hasil;
            // }
        }else{
            $text = $arr_parameter['error'];
        }

        return $text;

    } 

    public static function getParameterGanti($command, $id_group_odoj)
    {
    	# ambil kata ketiga dari command
    	$exp = explode(" ",$command);
    	$jml_karakter = strlen($command);
    	$parameter = substr($command, 11, $jml_karakter);
    	//$parameter = $exp[2];

        $arr_parameter = array('group', 'admin', 'panggilan', 'team', 'juz', 'deadline', 'header', 'footer', 'pj', 'start', 'noreport', 'reward', 'icon', 'sort');

        $jml_karakter = strlen($parameter);
        $tagar = substr($parameter, 0, 1);
        $tikoma = substr($parameter, $jml_karakter-1, 1);

        if ($tagar == '#' AND $tikoma == ';') {
            # ambil parameter
            $parameter = str_replace("#", "", $parameter);
            $parameter = str_replace(";", "", $parameter);
            $exp = explode("=", $parameter);

            if (in_array($exp[0], $arr_parameter) AND $exp[1]!='') {
                # kirim jika benar
                $arr_hasil['parameter'] = $exp[0];
                $arr_hasil['value'] = $exp[1];

                return $arr_hasil;
            }else{
                return '0';
            }            
        }else{
        	# ambil nama fulan dari command
        	$command = str_replace(";", "", $command);
        	$samadengan = strpos($command, "=");
        	if ($samadengan) {
        		$exp = explode("=", $command);
        	}else{
        		$exp[0] = '';
        	}
            
            if ($exp[0]!='') {
            	$pecah = explode(" ", $exp[0]);

	            for ($i=2; $i <= count($pecah) ; $i++) { 
	            	$nama = $nama.' '.$pecah[$i];
	            }

	            $nama_anggota = trim($nama);

	            if ($result = DB::getPdo()->query("SELECT id FROM am_user WHERE nama='". $nama_anggota ."' AND status='1' AND is_odoj ='1' ")) {
	                $result = $result->fetchAll();
	                if ($result) {
	                	$value = str_replace(";", "", $exp[1]);
	                	$arr_hasil['parameter'] = $result[0]['id'];
	                	$arr_hasil['value'] = $value;

	                	return $arr_hasil;
	                }else{
	                	return '0';
	                }
	            }else{
	            	return '0';
	            }
            }else{
            	return '0';
            }
        }
    }


	public static function prosesGanti($parameter, $value, $id_group_odoj)
    {
    	switch ($parameter) {
    		case 'group':
    			if (preg_match("/^[0-9]*$/",$value) AND strlen($value) <= 10) { 
    				$result_update = self::prosesUpdate('nomor_group', $value, $id_group_odoj);
    			}else{
    				$result_update = false;
    				$error = "Hanya angka yang diijinkan, maksimal 10 karakter";
    			}

    			break;

    		case 'admin':
    			$exp = explode(",", $value);

    			if (count($exp) == 3 AND $exp[0]!=NULL AND preg_match("/^[0-2]*$/",$exp[1]) AND $exp[2]!=NULL) {

	    			$arr_admin['nama'] = $exp[0];
	    			$arr_admin['mode'] = $exp[1];
	    			$arr_admin['tulisan'] = $exp[2];

	    			$admin = json_encode($arr_admin, JSON_UNESCAPED_UNICODE);
	    			$result_update = self::prosesUpdate('admin_show', $admin, $id_group_odoj);
	    			if ($result_update == false) {
	    				$error = "Gagal update Admin";
	    			}
    			}else{
    				$error = "Format salah, silakan cek kembali!";
    			}

    			break;

    		case 'panggilan':
    			if (preg_match("/^[a-zA-Z.]*$/",$value) AND strlen($value) <= 10) { 
    				$result_update = self::prosesUpdate($parameter, $value, $id_group_odoj);
    			}else{
    				$result_update = false;
    				$error = "Hanya huruf dan titik yang diijinkan, maksimal 10 karakter";
    			}

    			break;
    			
    		case 'team':
    			$exp = explode(",", $value);

    			$arr_team['sebutan'] = $exp[0];
    			for ($i=1; $i < count($exp); $i++) { 
    				$pecah = explode("|", $exp[$i]);
    				$arr_team[$i] = $pecah[0];
    				$arr_korteam[$i] = $pecah[1];
    			}

    			$team = json_encode($arr_team, JSON_UNESCAPED_UNICODE);
    			$result_update = self::prosesUpdate('nama_team', $team, $id_group_odoj);

    			$korteam = json_encode($arr_korteam, JSON_UNESCAPED_UNICODE);
    			$result_update = self::prosesUpdate("kordinator_team", $korteam, $id_group_odoj);

    			if ($result_update == false) {
    				$error = "Gagal update noreport";
    			}

    			break;

    		case 'juz':
    			$exp = explode(",", $value);

    			if (count($exp) == 2 AND preg_match("/^[0-2]*$/",$exp[1])) {

	    			$arr_juz['text'] = $exp[0];
	    			$arr_juz['mode'] = $exp[1];

	    			$juz = json_encode($arr_juz, JSON_UNESCAPED_UNICODE);
	    			$result_update = self::prosesUpdate($parameter, $juz, $id_group_odoj);
	    			if ($result_update == false) {
	    				$error = "Gagal update Juz";
	    			}
    			}else{
    				$error = "Format value = icon/text,mode";
    			}

    			break;
    			
    		case 'deadline':
    			if (DB::cekFormatWaktu($value) === true) {
    				$result_update = self::prosesUpdate($parameter, $value, $id_group_odoj);
    			}else{
    				$result_update = false;
    				$error = "Format waktu salah";
    			}

    			break;

    		case 'header':
    			$exp = explode("|", $value);
    			$i = 1;
    			foreach ($exp as $key => $value) {
    				$arr_header[$i] = $value;
    				$i++;
    			}

    			$header = json_encode($arr_header, JSON_UNESCAPED_UNICODE);
    			$result_update = self::prosesUpdate($parameter, $header, $id_group_odoj);
    			if ($result_update == false) {
    				$error = "Gagal update header";
    			}
    			
    			break;
    			
    		case 'footer':
    			$exp = explode("|", $value);
    			$i = 1;
    			foreach ($exp as $key => $value) {
    				$arr_footer[$i] = $value;
    				$i++;
    			}
    			
    			$footer = json_encode($arr_footer, JSON_UNESCAPED_UNICODE);
    			$result_update = self::prosesUpdate($parameter, $footer, $id_group_odoj);
    			if ($result_update == false) {
    				$error = "Gagal update footer";
    			}

    			break;

    		case 'pj':
                # ambil value cek
                if ($result = DB::getPdo()->query("SELECT id FROM am_user WHERE nama='" . $value . "' AND is_odoj='1' AND status='1'AND id_group_odoj='".$id_group_odoj."' ")) {
                    $result = $result->fetchAll();
                    if (isset($result[0]['id'])) {
                        $user_id = $result[0]['id'];
                    }   
                } 

    			if ($value >= 1 AND $value <= 30) {
	    			$arr_pj['juz'] = $value;

	    			$pj = json_encode($arr_pj, JSON_UNESCAPED_UNICODE);
	    			$result_update = self::prosesUpdate($parameter, $pj, $id_group_odoj);
	    			if ($result_update == false) {
	    				$error = "Gagal update PJ";
	    			}
    			}elseif($user_id != null){
    				$arr_pj['nama'] = $user_id;

	    			$pj = json_encode($arr_pj, JSON_UNESCAPED_UNICODE);
	    			$result_update = self::prosesUpdate($parameter, $pj, $id_group_odoj);
	    			if ($result_update == false) {
	    				$error = "Gagal update PJ";
	    			}
    			}else{
    				$result_update = false;
    				$error = "Data PJ tidak benar!";
    			}

    			break;

    		case 'start':
    			
    			$exp = explode(",", $value);

    			if (count($exp) == 3 AND DB::cekFormatTanggal($exp[0]) === True AND preg_match("/^[0-2]*$/",$exp[1]) AND $exp[2]!=NULL) {

	    			$arr_start['tgl_awal_odoj'] = DB::getDateDB($exp[0]);
	    			$arr_start['tanda'] = $exp[1];
	    			$arr_start['istilah'] = $exp[2];

	    			$start = json_encode($arr_start, JSON_UNESCAPED_UNICODE);
	    			$result_update = self::prosesUpdate($parameter, $start, $id_group_odoj);
	    			if ($result_update == false) {
	    				$error = "Gagal update Start";
	    			}
    			}else{
    				$error = "Format salah, silakan cek kembali!";
    			}

    			break;

    		case 'noreport':
    			$exp = explode(",", $value);

    			foreach ($exp as $key => $value) {
    				$arr_noreport[] = $value;
    			}

    			$noreport = json_encode($arr_noreport, JSON_UNESCAPED_UNICODE);
    			$result_update = self::prosesUpdate($parameter, $noreport, $id_group_odoj);
    			if ($result_update == false) {
    				$error = "Gagal update noreport";
    			}

    			break;
    			
    		case 'reward':
    			# cari deadline untuk waktu star time petama
                $deadline = '00:00:00';
                if ($result = DB::getPdo()->query('SELECT deadline FROM am_group_odoj WHERE id_group_odoj='. $id_group_odoj)) {
                    $result = $result->fetchAll();
                    $deadline = $result[0]['deadline'];
                } 

	    		$timestamp = strtotime('2018-11-03 ' . substr($deadline, 0, 5));
	    		$arr_reward_start_time[1] = date('H:i', strtotime('+1 minute', $timestamp));

    			# bagi komand berdasarkan koma
    			$exp = explode(",", $value);

    			$status_value = TRUE;
    			$i = 1;
    			$error = '';
    			foreach($exp as $key => $value) { 
    				# pisahkan antara waktu terakhir dengan reward
    				$pecah = explode("-", $value);

    				if ($pecah[0]=='d') {
    					$arr_reward['d'] = $pecah[1];
    				}else{
	    				$arr_reward[$i] = $pecah[1];

	    				# cari waktu terakhir
	    				$waktu_akhir = $pecah[0];
	    				if (strlen($waktu) <= 2) {
	    					$waktu_akhir = sprintf("%02s",$waktu_akhir) . ":00";
	    				}
	    				if (DB::cekFormatWaktu($waktu_akhir) === TRUE) {
	    					$arr_reward_end_time[$i] = $waktu_akhir;

	    					if ($i < count($exp)-1) {
	    						$timestamp = strtotime('2018-11-03 ' . $waktu_akhir);
	    						$arr_reward_start_time[$i+1] = date('H:i', strtotime('+1 minute', $timestamp));
	    					}

	    					$i++;
	    				}else{
	    					$status_value = FALSE;
	    				}
	    				
    				}
    			}

    			if ($status_value == TRUE) {
	    			$reward_start_time = json_encode($arr_reward_start_time, JSON_UNESCAPED_UNICODE);
	    			$result_update = self::prosesUpdate('reward_start_time', $reward_start_time, $id_group_odoj);

	    			$reward_end_time = json_encode($arr_reward_end_time, JSON_UNESCAPED_UNICODE);
	    			$result_update = self::prosesUpdate("reward_end_time", $reward_end_time, $id_group_odoj);

	    			$reward = json_encode($arr_reward, JSON_UNESCAPED_UNICODE);
	    			$result_update = self::prosesUpdate("reward", $reward, $id_group_odoj);

	    			if ($result_update == false) {
	    				$error = "Gagal update noreport";
	    			}
    			}else{
    				$result_update = false;
    				$error .= "Format waktu salah, silakan cek kembali!";
    			}

    			break;

    		case 'icon':
    			$exp = explode(",", $value);
    			if (count($exp) == 3 AND $exp[0]!='' AND $exp[1]!='' AND $exp[2]!='') {
	    			$i = 1;
	    			foreach ($exp as $key => $value) {
	    				$arr_icon[$i] = $value;
	    				$i++;
	    			}

	    			$icon = json_encode($arr_icon, JSON_UNESCAPED_UNICODE);
	    			$result_update = self::prosesUpdate($parameter, $icon, $id_group_odoj);
	    			if ($result_update == false) {
	    				$error = "Gagal update icon";
	    			}
    			}else{
    				$result_update == false;
    				$error = "Jumlah icon harus 3, dipisahkan dengan koma, urutannya adalah: tanda untuk kholas, tanda untuk tasmi/tarjim, tanda on-progress.
";
    			}
    			
    			break;
    			
    		case 'sort':
    			if (preg_match("/^[0-1]*$/",$value) AND strlen($value) <= 10) { 
    				$result_update = self::prosesUpdate($parameter, $value, $id_group_odoj);
    			}else{
    				$result_update = false;
    				$error = "Hanya angka 0 dan 1 yang diijinkan";
    			}

    			break;

    		default:
    			$exp = explode(",", $value);
    			$juz = $exp[0];
    			$team = $exp[1];

                # ganti team default yg tidak dibagi team (team diisi 0) ke 1
                if ($team == '0') {
                    $team = '1';
                }

    			# cek dulu deadlinenya, sesuaikan tanggal tugas dengan tanggal deadline
                $date_cari = DB::getTzJakarta('Date');
                $time_cari = DB::getTzJakarta('Time');
                $time_cari = (int) preg_replace('/\D/', '', $time_cari);

                $deadline = '00:00:00';
                if ($data = DB::getPdo()->query('SELECT deadline FROM am_group_odoj WHERE id_group_odoj='. $id_group_odoj)) {
                    $data = $data->fetchAll();
                    $deadline = $data[0]['deadline'];
                }

                $deadline = (int) preg_replace('/\D/', '', $deadline);
                if($time_cari > $deadline AND $deadline != 0){
                    # jika waktu cari lebih dari deadline dan deadline tidak sama dengan jam 00:00, maka tanggal tugas tanggal besoknya
                    $tanggal_tugas = date('Y-m-d', strtotime("+1 day", strtotime($date_cari)));
                }else{
                    # waktu pencarian kurang dari waktu deadline, maka tanggal tugas sesuai dengan tanggal pencarian
                    $tanggal_tugas = $date_cari;
                }

    			if ($value == '') {
    				# UPDATE user odoj
    				$result_update = self::prosesUpdateUser($parameter, '0', '0');
    				# hapus data odoj hari itu
			    //    $where_fields_values = ['id_user'=> $parameter, 'tanggal_tugas'=>$tanggal_tugas];
			        $result_update = DB::delete_odoj('am_odoj', $parameter, $tanggal_tugas);

    			}elseif ($juz>=1 AND $juz<=30 AND $team>=1 AND $team<=50) {

	    			if ($result = DB::getPdo()->query("SELECT id_group_odoj FROM am_user WHERE id='". $parameter ."' ")) {
	            		$result = $result->fetchAll();
	            		$id_group_odoj_param = $result[0]['id_group_odoj'];
	            		if ($id_group_odoj_param == '0') {
	            			# kondisi kalo si user param itu belum di bagi gruop, maka proses bagi group sama masukin tugas odoj ke list
	            			$result_update = self::prosesUpdateUser($parameter, $team, $id_group_odoj);


	            			$insert_odoj = DB::insert_odoj($parameter, $juz, $tanggal_tugas, '0000-00-00', '00:00:00', '0', $id_group_odoj, $team, '', '','0');

	            		}else{
	            			# update data user berdasarkan team yang di kirim
	            			$result_update = self::prosesUpdateUser($parameter, $team, $id_group_odoj);
	            			# update odoj berdasarkan jus
					        $updated_at = DB::getTzJakarta('DateTime');
					        $fields_values = ['juz'=>$juz, 'team'=>$team, 'updated_at'=>$updated_at];
					        $where_fields_values = ['id_user'=> $parameter, 'tanggal_tugas'=>$tanggal_tugas];
					        $result_update = DB::update('am_odoj', $fields_values, $where_fields_values);		
	            		}
	        		}

    			}else{
     				$result_update = false;
    				$error = "Format juz atau team salah ".$value;   				
    			}

    		//	$result_update = false;
    			break;
    	}

        if ($result_update == true) {
            // $sukses['successful'] = '1';
            // $sukses['user_id'] = $user_id;
            // $sukses['tanggal_tugas'] = $tanggal_tugas;

            // $hasil = $sukses;
            $hasil = "✅️ *SUCCESS:* _Proses berhasil!_";
        }else{
            $hasil = "⛔️ *ERROR:* _" . $error . "_";
        }

        return $hasil;
    }

	public static function prosesUpdate($parameter, $value, $id_group_odoj)
    {
        $updated_at = DB::getTzJakarta('DateTime');
        $fields_values = [$parameter=>$value, 'updated_at'=>$updated_at];
        $where_fields_values = ['id_group_odoj'=> $id_group_odoj];
        $result_update = DB::update('am_group_odoj', $fields_values, $where_fields_values);		
    	
        return $result_update;
    }

	public static function prosesUpdateUser($id, $team, $id_group_odoj)
    {
        $updated_at = DB::getTzJakarta('DateTime');
        $fields_values = ['id_group_odoj'=>$id_group_odoj, 'team'=>$team, 'updated_at'=>$updated_at];
        $where_fields_values = ['id'=> $id];
        $result_update = DB::update('am_user', $fields_values, $where_fields_values);		
    	
        return $result_update;
    }

    public static function DeleteOdoj($id_user, $tanggal_tugas)
    {
        if (!DB::isDbConnected()) {
            return false;
        }

        try {
            $sth = self::$pdo->prepare("
                DELETE FROM am_odoj WHERE id='". $id_user ."' AND tanggal_tugas='" . $tanggal_tugas . "' 
            ");

            return $sth->execute();
        } catch (Exception $e) {
            throw new TelegramException($e->getMessage());
        }
    }

    public static function getError($parameter_null)
    {
        switch ($parameter_null) {
            case 'no parameter':
                $text = "⛔️ *ERROR:* _Parameter tidak ditemukan!_";
                $text .= "\n\nContoh: `odoj ganti #param=value`";  
                break;

            case 'salah parameter':
                $text = "⛔️ *ERROR:* _Parameter yang dimasukan salah!_";
                break;

            case 'juz salah':
                $text = "⛔️ *ERROR:* _Parameter juz salah!_";
                $text .= "\n\nContoh: `odoj lapor fulan juz 7`";  
                break;

            case 'tanggal_kholas salah':
                $text = "⛔️ *ERROR:* _Parameter tanggal kholas salah!_";
                $text .= "\n\nContoh: `odoj lapor fulan juz 7 15-oct-2018 22.30`";  
                break;

            case 'waktu_kholas salah':
                $text = "⛔️ *ERROR:* _Parameter waktu kholas salah!_";
                $text .= "\n\nContoh: `odoj lapor fulan juz 7 jam 22.30`";  
                break;

            case 'nama':
                $text = "⛔️ *ERROR:* _Parameter nama tidak ditemukan_";
                break;
            
            default:
                $text = "⛔️ *ERROR:* __";
                break;
        }

        return $text;

    }
}
