<?php
/**
 * perintah : /odojbatal <text>
 * perintah untuk membatalkan laporan odoj
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;

class OdojbatalCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'odojbatal';

    /**
     * @var string
     */
    protected $description = 'Odoj batal Command';

    /**
     * @var string
     */
    protected $usage = '/odojbatal <text>';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {
        $message = $this->getMessage();
        $chat_id = $message->getChat()->getId();
        $user_id = $message->getFrom()->getId();
        $command = strtolower(DB::clearDoubleSpace($message->getText(true)));

        //Send chat action
        Request::sendChatAction([
            'chat_id' => $chat_id,
            'action'  => 'typing',
        ]);

        # saring user yang ikut ODOJ saja yang dilayani
        if ($result = DB::getPdo()->query("SELECT is_odoj, status FROM am_user WHERE id='" .$user_id. "' AND is_odoj='1' AND status='1'" )) {
            $result = $result->fetchAll();
            $is_odoj = $result[0]['is_odoj'];
            $status = $result[0]['status'];
            if ($is_odoj == 1 AND $status == 1) {

                # ambil id group odoj user
                if ($result = DB::getPdo()->query('SELECT am_group_odoj.deadline, am_user.id_group_odoj FROM am_user JOIN am_group_odoj ON am_user.id_group_odoj=am_group_odoj.id_group_odoj  WHERE am_user.id='. $user_id)) {
                    $result = $result->fetchAll();
                    $id_group_odoj = $result[0]['id_group_odoj'];
                }

                # proses update odoj
                $text = self::batalOdoj($command, $id_group_odoj);

            }
        }else{
            $text = "⛔️ *ERROR:* _Maaf, server sedang gangguan!_";
        }

        $data = [
            'chat_id' => $chat_id,
            'text'    => $text,
            'parse_mode' => 'Markdown'
        ];

        return Request::sendMessage($data);
    }


    public static function batalOdoj($command, $id_group_odoj)
    {
        # cek perintah berdasarkan format
        $exp = explode(" ",$command);

        # cari parameter nama
        $batal_val = array_search('batal', $exp);

        $nama = '';
        if ($batal_val !== false) {
            for ($i=$batal_val+1; $i <= count($exp); $i++) { 
                $nama .= $exp[$i] .' ';
            }
        }

        # jika ada parameter tanggal pencarian
        # perintah : odoj 20-okt-2018 batal fulan --> masuk sini
        if (isset($exp[1]) AND $exp[1] != 'batal' AND isset($exp[3])) {
            # cek dulu format tanggalnya
            # format diijinkan 1-1-2018 / 1-oct-2018
            if (DB::cekFormatTanggal($exp[1]) === True) {
                $tanggal_tugas = DB::getDateDB($exp[1]);


                $text = self::prosesBatal($nama, $tanggal_tugas, $id_group_odoj);  
                //$text = 'FORMAT TGL BENR';
            }else{
                $text = self::getError('tanggal');               
            }
        }elseif(isset($exp[2])){
            # disini bagian kalo perintahnya odoj batal fulan
            $tanggal_tugas = DB::getTzJakarta('Date');

            $text= self::prosesBatal($nama, $tanggal_tugas, $id_group_odoj);

        //    $text = 'FORMAT BENR';
        }else{
             $text = self::getError('no fulan');
        }

        return $text;

    }    

    public static function prosesBatal($nama, $tanggal_tugas, $id_group_odoj)
    {
        # cek dulu apakah datanya ada ga untuk tanggal tugas sekian atas nama tersebut
        if ($result = DB::getPdo()->query("SELECT id_user, juz, tanggal_tugas, is_kholas FROM am_odoj JOIN am_user ON am_odoj.id_user=am_user.id WHERE LOWER(am_user.nama)='" .$nama. "' AND tanggal_tugas='". $tanggal_tugas ."' AND am_odoj.id_group_odoj='".$id_group_odoj."' " )) {
            $result = $result->fetchAll();
            if ($result) {
                $user_id = $result[0]['id_user'];
                // $hasil = 'data ada';

                # update data odoj 
                $updated_at = DB::getTzJakarta('DateTime');
                $fields_values = ['tanggal_kholas'=>'0000:00:00', 'waktu_kholas'=>'00:00:00', 'is_kholas'=>'0', 'noreport'=>'0', 'reward'=>'', 'updated_at'=>$updated_at];
                $where_fields_values = ['id_user'=> $user_id, 'tanggal_tugas'=>$tanggal_tugas];
                $result_update = DB::update('am_odoj', $fields_values, $where_fields_values);

                if ($result_update == true) {
                    $tanggal = date("j M Y", strtotime($tanggal_tugas));
                    $hasil = " Batal odoj berhasil.\n";
                    $hasil .= $nama.", ".$tanggal." juz ".$result[0]['juz']." dibatalkan. \n";
                    $hasil .= "═══════════════════════";
                }else{
                    $hasil = "⛔️ *ERROR:* _Lapor odoj gagal!_";
                }


            }else{
                # ambil user id sambil cek nama nya
                $hasil = "⛔️ *ERROR:* _Anggota dengan nama ".$nama." tidak ditemukan!_";
            }

        }else{
            $hasil = self::getError('server error');
        }
        
    //    $hasil = 'masuk fungsi';
        return $hasil;

    }  

    public static function getError($parameter_null)
    {
        switch ($parameter_null) {
            case 'tanggal':
                $text = "⛔️ *ERROR:* _Format tanggal salah!_";
                $text .= "\n\nContoh: `odoj 25-Oct-2018 batal fulan`";  
                break;

            case 'no fulan':
                $text = "⛔️ *ERROR:* _Parameter nama anggota tidak ditemukan!_";
                $text .= "\n\nContoh: `odoj batal fulan`";  
                break;

            case 'server error':
                $text = "⛔️ *ERROR:* _Maaf, server sedang gangguan!_";
                break;

            case 'tanggal_kholas salah':
                $text = "⛔️ *ERROR:* _Parameter tanggal kholas salah!_";
                $text .= "\n\nContoh: `odoj lapor fulan juz 7 15-oct-2018 22.30`";  
                break;

            case 'waktu_kholas salah':
                $text = "⛔️ *ERROR:* _Parameter waktu kholas salah!_";
                $text .= "\n\nContoh: `odoj lapor fulan juz 7 jam 22.30`";  
                break;

            case 'nama':
                $text = "⛔️ *ERROR:* _Parameter nama tidak ditemukan_";
                break;
            
            default:
                $text = "⛔️ *ERROR:* __";
                break;
        }

        return $text;

    }

}