<?php
/**
 * Ini merupakan perintah untuk daftar anggota Bot
 * Disimpan di tabel am_user
 * Gunakan /daftar untuk menggunakan perintah ini
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Conversation;
use Longman\TelegramBot\Entities\Keyboard;
use Longman\TelegramBot\Entities\KeyboardButton;
use Longman\TelegramBot\Entities\PhotoSize;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;
use PDO;


class DaftarCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'daftar';

    /**
     * @var string
     */
    protected $description = 'Daftar anggota Bot Daarut Tauhiid';

    /**
     * @var string
     */
    protected $usage = '/daftar';

    /**
     * @var string
     */
    protected $version = '0.3.0';

    /**
     * @var bool
     */
    protected $need_mysql = true;

    /**
     * @var bool
     */
    protected $private_only = true;

    /**
     * Conversation Object
     *
     * @var \Longman\TelegramBot\Conversation
     */
    protected $conversation;

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {
        $message = $this->getMessage();

        $chat    = $message->getChat();
        $user    = $message->getFrom();
        $text    = trim($message->getText(true));
        $chat_id = $chat->getId();
        $user_id = $user->getId();
        $first_name = $user->getFirstName();
        $last_name  = $user->getLastName();
        $username   = $user->getUsername();

        # data pendaftar yang akan dikirim di awal
        $data_daftar = ['user_id' => $user_id, 'first_name' => $first_name, 'last_name' => $last_name, 'username' => $username];

        # cek data anggota Bot di tabel am_user
        $state_am_user = 0;
        $am_user = DB::getPdo()->query('SELECT * FROM `am_user` JOIN am_unit ON am_user.id_unit=am_unit.id_unit WHERE `id` = ' . $user_id);
        $am_user = $am_user->fetchAll();
        if (isset($am_user[0]['state'])) {
            # kondisi kalo user sudah daftar
            $state_am_user = $am_user[0]['state'];
        }else{
            # kondisi kalo user belum daftar
            $input = DB::insert_am_user($data_daftar);
        }

        //Preparing Response
        $data = [
            'chat_id' => $chat_id,
        ];

        if ($chat->isGroupChat() || $chat->isSuperGroup()) {
            //reply to message id is applied by default
            //Force reply is applied by default so it can work with privacy on
            $data['reply_markup'] = Keyboard::forceReply(['selective' => true]);
        }

        //Conversation start
        $this->conversation = new Conversation($user_id, $chat_id, $this->getName());

        $notes = &$this->conversation->notes;
        !is_array($notes) && $notes = [];

        //cache data from the tracking session if any
        $state = 0;
        if (isset($notes['state'])) {
            $state = $notes['state'];
        }
        # jika sudah mendaftar maka langsung ke case 5
        if ($state_am_user == 4) {
            $state = 6;
        }

        $result = Request::emptyResponse();


        //State machine
        //Entrypoint of the machine state if given by the track
        //Every time a step is achieved the track is updated
        switch ($state) {
            case 0:
                if ($text === '') {
                    $notes['state'] = 0;
                    $this->conversation->update();

                    $data['text']         = 'Masukan Nama :';
                    $data['reply_markup'] = Keyboard::remove(['selective' => true]);

                    $result = Request::sendMessage($data);
                    break;
                }

                # update nama table am_user
                $fields_values = ['nama'=>$text];
                $where_fields_values = ['id'=> $user_id];
                $result_update = DB::update('am_user', $fields_values, $where_fields_values);

                $notes['nama'] = $text;
                $text          = '';

            case 1:
                if ($text === '' || !is_numeric($text)) {
                    $notes['state'] = 1;
                    $this->conversation->update();

                    $data['text'] = "Masukan NIK (Nomor Induk Karyawan) :\n _Isi 0 jika belum mempunyai NIK_";
                    $data['parse_mode'] = 'MARKDOWN';
                    if ($text !== '') {
                        $data['text'] = 'Masukan NIK, harus berupa angka :';
                    }

                    $result = Request::sendMessage($data);
                    break;
                }

                # update nrp table am_user
                $fields_values = ['nrp'=> $text, 'state'=> 1];
                $where_fields_values = ['id'=> $user_id];
                $result_update = DB::update('am_user', $fields_values, $where_fields_values);

                $notes['nrp'] = $text;
                $text         = '';

            // no break
            case 2:
                if ($text === '' || !in_array($text, ['L', 'P'], true)) {
                    $notes['state'] = 2;
                    $this->conversation->update();

                    $data['reply_markup'] = (new Keyboard(['L', 'P']))
                        ->setResizeKeyboard(true)
                        ->setOneTimeKeyboard(true)
                        ->setSelective(true);

                    $data['text'] = 'Pilih jenis kelamin :';
                    if ($text !== '') {
                        $data['text'] = 'Pilih jenis kelamin, silakan pilih tombol di keyboard :';
                    }

                    $result = Request::sendMessage($data);
                    break;
                }

                # update jenis kelamin table am_user
                $fields_values = ['jenis_kelamin'=> $text, 'state'=> 2];
                $where_fields_values = ['id'=> $user_id];
                $result_update = DB::update('am_user', $fields_values, $where_fields_values);

                $notes['jenis_kelamin'] = $text;
                $text         = '';

            // no break
            case 3:
                if ($text === '' || !is_numeric($text) || $text < 1 || $text > self::getIdUnitTerakhir()) {
                    $notes['state'] = 3;
                    $this->conversation->update();

                    $data['text'] = "Pilih Unit : \n\n" . self::getUnit() . "\n Kirimkan nomor sesuai pilihan unit!";
                    if ($text !== '') {
                        $data['text'] = 'Pilih unit, silakan kirim Nomor sesuai Unit :';
                    }

                    $result = Request::sendMessage($data);
                    break;
                }

                # update jenis kelamin table am_user
                $fields_values = ['id_unit'=> $text, 'state'=> 3];
                $where_fields_values = ['id'=> $user_id];
                $result_update = DB::update('am_user', $fields_values, $where_fields_values);

                $notes['id_unit'] = $text;
                $text         = '';

            // no break
            case 4:
                if ($text === '' || !in_array($text, ['Ya', 'Tidak'], true)) {
                    $notes['state'] = 4;
                    $this->conversation->update();

                    $data['reply_markup'] = (new Keyboard(
                        ['1' => 'Ya'],['0' => 'Tidak']))
                        ->setResizeKeyboard(true)
                        ->setOneTimeKeyboard(true)
                        ->setSelective(true);

                    $data['text'] = 'Apakah mengikuti program ODOJ :';
                    if ($text !== '') {
                        $data['text'] = 'Pilih jawaban anda di keyboard :';
                    }

                    $result = Request::sendMessage($data);
                    break;
                }

                if ($text == 'Ya') {
                    $text = '1';
                }else{
                    $text = '0';
                }

                # update odoj tidaknya table am_user
                $fields_values = ['is_odoj'=> $text, 'state'=> 4];
                $where_fields_values = ['id'=> $user_id];
                $result_update = DB::update('am_user', $fields_values, $where_fields_values);

                $notes['is_odoj'] = $text;
            //    $text         = '';

            // no break
            case 5:
                
                if ($am_user[0]['is_odoj'] == '1') {
                    $odoj = 'Ya';
                }else{
                    $odoj = 'Tidak';
                }

                $text = "✅ Pendaftaran Selesai.\n\n";
                $data['text'] = $text;
                $result = Request::sendMessage($data);

                $text = "*Data Pendaftar*\n";
                $text .= "---------------\n";
                $text .= "Nama : " . $am_user[0]['nama'] . "\n";
                $text .= "NIK : " . $am_user[0]['nrp'] . "\n";
                $text .= "Jenis Kelamin : " . $am_user[0]['jenis_kelamin'] . "\n";
                $text .= "Unit : " . $am_user[0]['nama_unit'] . "\n";
                $text .= "Program ODOJ : " . $odoj . "\n";
                $data['text'] = $text;
                $data['parse_mode'] = 'MARKDOWN';
                $data['reply_markup'] = Keyboard::remove(['selective' => true]);
                $this->conversation->stop();

                $result = Request::sendMessage($data);
                break;

            case 6:
                
                if ($am_user[0]['is_odoj'] == 1) {
                    $odoj = 'Ya';
                }else{
                    $odoj = 'Tidak';
                }

                $text = "⛔️ Anda sudah terdaftar.\n\n";
                $data['text'] = $text;
                $result = Request::sendMessage($data);

                $text = "*Data Pendaftar*\n";
                $text .= "-------------------------\n";
                $text .= "Nama : " . $am_user[0]['nama'] . "\n";
                $text .= "NIK : " . $am_user[0]['nrp'] . "\n";
                $text .= "Jenis Kelamin : " . $am_user[0]['jenis_kelamin'] . "\n";
                $text .= "Unit : " . $am_user[0]['nama_unit'] . "\n";
                $text .= "Program ODOJ : " . $odoj. "\n";
                $data['text'] = $text;
                $data['parse_mode'] = 'MARKDOWN';
                $this->conversation->stop();

                $result = Request::sendMessage($data);
                break;
        }

        return $result;
    }

    public static function getUnit()
    {
        $list_unit = '';
        # ambil data seting group odoj
        if ($result = DB::getPdo()->query('SELECT id_unit, nama_unit FROM `am_unit` ORDER BY id_unit ASC')) {
            $result = $result->fetchAll();
            foreach ($result as $key) {
                $list_unit .= $key[0] . ". " . $key[1] . "\n"; 
            }

            return $list_unit;
        }
    }

    public static function getIdUnitTerakhir()
    {
        # ambil data seting group odoj
        if ($result = DB::getPdo()->query('SELECT id_unit FROM `am_unit` ORDER BY id_unit DESC LIMIT 1')) {
            $result = $result->fetchAll();

            return $result[0]['id_unit'];
        }
    }

}
