<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands\SystemCommands;

use Longman\TelegramBot\Commands\SystemCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\Commands\AdminCommands\CategoryCommand;
use Longman\TelegramBot\DB;

/**
 * Callback query command
 *
 * This command handles all callback queries sent via inline keyboard buttons.
 *
 * @see InlinekeyboardCommand.php
 */
class CallbackqueryCommand extends SystemCommand
{
    /**
     * @var string
     */
    protected $name = 'callbackquery';

    /**
     * @var string
     */
    protected $description = 'Reply to callback query';

    /**
     * @var string
     */
    protected $version = '1.1.1';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {
        // $callback_query    = $this->getCallbackQuery();
        // $callback_query_id = $callback_query->getId();
        // $callback_data     = $callback_query->getData();

        // $data = [
        //     'callback_query_id' => $callback_query_id,
        //     'text'              => 'Hello World!',
        //     'show_alert'        => $callback_data === 'thumb up',
        //     'cache_time'        => 5,
        // ];

        // return Request::answerCallbackQuery($data);
        


        // tes aja
        $update         = $this->getUpdate();
        $callback_query = $update->getCallbackQuery();
        $callback_data  = $callback_query->getData();

        // Only do something for the 'category' selection.
        if (strpos($callback_data, 'category_') !== 0) {
            return Request::emptyResponse();
        }

        // Get the real category from the callback_data.
        $category = substr($callback_data, strlen('category_'));

                        # update table am_user
                $fields_values = ['nama'=> 'apip update'];
                $where_fields_values = ['id'=> '128518319'];
                $result_update = DB::update('am_user', $fields_values, $where_fields_values);

        return Request::editMessageText([
            'chat_id'    => $callback_query->getMessage()->getChat()->getId(),
            'message_id' => $callback_query->getMessage()->getMessageId(),
            'text'       => CategoryCommand::$categories[$category],
            'reply_markup' => CategoryCommand::getMyInlineKeyboard(),
        ]);





    }
}
