<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands;

use Longman\TelegramBot\Request;

abstract class SystemCommand extends Command
{
    /**
     * A system command just executes
     *
     * Although system commands should just work and return a successful ServerResponse,
     * each system command can override this method to add custom functionality.
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     */
    public function execute()
    {
        // $message = $this->getMessage();
        // $chat_id = $message->getChat()->getId();
        // $user_id = $message->getFrom()->getId();
        // $nama    = $message->getFrom()->getFirstName();
        // Request::sendMessage([
        //     'chat_id'   => $chat_id,
        //     'text'      => "Hello $nama! ID Anda adalah $user_id"
        // ]);
        //System command, return empty ServerResponse by default
        return Request::emptyResponse();
        //return parent::execute();
    }
}
