<?php
/**
 * perintah : /odojlist <text>
 * perintah untuk melihat daftar odoj 
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;

class OdojlistCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'odojlist';

    /**
     * @var string
     */
    protected $description = 'Odoj list Command';

    /**
     * @var string
     */
    protected $usage = '/odojlist <text>';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {
        $message = $this->getMessage();
        $chat_id = $message->getChat()->getId();
        $user_id = $message->getFrom()->getId();
        $command = strtolower(DB::clearDoubleSpace($message->getText(true)));

        //Send chat action
        Request::sendChatAction([
            'chat_id' => $chat_id,
            'action'  => 'typing',
        ]);

        # saring user yang ikut ODOJ saja yang dilayani
        if ($result = DB::getPdo()->query("SELECT is_odoj, status FROM am_user WHERE id='" .$user_id. "' AND is_odoj='1' AND status='1'" )) {
            $result = $result->fetchAll();
            $is_odoj = $result[0]['is_odoj'];
            $status = $result[0]['status'];
            if ($is_odoj == 1 AND $status == 1) {

                # ambil id group odoj user
                $deadline = '00:00:00';
                if ($result = DB::getPdo()->query('SELECT am_group_odoj.deadline FROM am_user JOIN am_group_odoj ON am_user.id_group_odoj=am_group_odoj.id_group_odoj  WHERE am_user.id='. $user_id)) {
                    $result = $result->fetchAll();
                    $deadline = $result[0]['deadline'];
                }

                # cek perintah benar ga formatnya
                $exp = explode(" ",$command);

                # jika ada parameter tanggal pencarian
                if (isset($exp[2])) {
                    # jika pencarian pake kata-kata
                    if (isset($exp[3])) {
                        if ($exp[1] == 'kemarin' AND $exp[2] == 'lusa') {
                            $date_cari = DB::getTzJakarta('Date');
                            $tanggal = date('Y-m-d', strtotime("-2 day", strtotime($date_cari)));
                            # ambil data list odoj
                            $text = self::getList($user_id, $tanggal);

                        }elseif($exp[1] == 'besok' AND $exp[2] == 'lusa') {
                            $date_cari = DB::getTzJakarta('Date');
                            $tanggal = date('Y-m-d', strtotime("+2 day", strtotime($date_cari)));
                            # ambil data list odoj
                            $text = self::getList($user_id, $tanggal);

                        }else{
                            $text = "⛔️ *ERROR:* _Format tanggal salah!_";
                            $text .= "\n\nContoh: `odoj 25-Oct-2018 list`";
                        }
                    }else{
                        if ($exp[1] == 'kemarin') {
                            $date_cari = DB::getTzJakarta('Date');
                            $tanggal = date('Y-m-d', strtotime("-1 day", strtotime($date_cari)));
                            # ambil data list odoj
                            $text = self::getList($user_id, $tanggal);

                        }elseif ($exp[1] == 'besok') {
                            $date_cari = DB::getTzJakarta('Date');
                            $tanggal = date('Y-m-d', strtotime("+1 day", strtotime($date_cari)));
                            # ambil data list odoj
                            $text = self::getList($user_id, $tanggal);

                        }elseif ($exp[1] == 'hariini' OR $exp[1] == 'sekarang' OR $exp[1] == 'now') {
                            $tanggal = DB::getTzJakarta('Date');
                            # ambil data list odoj
                            $text = self::getList($user_id, $tanggal);

                        }elseif (DB::cekFormatTanggal($exp[1]) === True) {
                            $tanggal = DB::getDateDB($exp[1]);
                            # ambil data list odoj
                            $text = self::getList($user_id, $tanggal);

                        }else{
                            $text = "⛔️ *ERROR:* _Format tanggal salah!_";
                            $text .= "\n\nContoh: `odoj 25-Oct-2018 list`";
                        }                
                    }

                }else{
                    # cek dulu deadlinenya, sesuaikan tanggal list dengan tanggal deadline
                    $date_cari = DB::getTzJakarta('Date');
                    $time_cari = DB::getTzJakarta('Time');
                    $time_cari = (int) preg_replace('/\D/', '', $time_cari);
                    $deadline = (int) preg_replace('/\D/', '', $deadline);
                    if($time_cari > $deadline AND $deadline != 0){
                        # jika waktu cari lebih dari deadline dan deadline tidak sama dengan jam 00:00, maka tanggal list tanggal besoknya
                        $tanggal = date('Y-m-d', strtotime("+1 day", strtotime($date_cari)));
                    }else{
                        # waktu pencarian kurang dari waktu deadline, maka tanggal list sesuai dengan tanggal pencarian
                        $tanggal = $date_cari;
                    }

                    # ambil data list odoj
                    $text = self::getList($user_id, $tanggal);
                }

            }else{
                $text = "⛔️ *ERROR:* _Maaf, anda tidak mengikuti program ODOJ._";  
            }
        }else{
            $text = "⛔️ *ERROR:* _Maaf, server sedang gangguan!_";
        }


        $data = [
            'chat_id' => $chat_id,
            'text'    => $text,
            'parse_mode' => 'Markdown'
        ];

        return Request::sendMessage($data);
    }

    public static function getList($user_id, $tanggal)
    {
        # ambil id group odoj user
        $id_group_odoj = 0;
        if ($result = DB::getPdo()->query('SELECT id_group_odoj FROM `am_user` WHERE id='. $user_id)) {
            $result = $result->fetchAll();
            $id_group_odoj = $result[0]['id_group_odoj'];
        }

        # ambil data seting group odoj
        if ($result = DB::getPdo()->query('SELECT * FROM `am_group_odoj` WHERE id_group_odoj='. $id_group_odoj)) {
            $result = $result->fetchAll();

            $nomor_group    = $result[0]['nomor_group'];
            $nama_team      = $result[0]['nama_team'];
            $admin          = $result[0]['admin']; 
            $pj             = $result[0]['pj'];
            $deadline       = $result[0]['deadline'];
            $panggilan      = $result[0]['panggilan'];
            $juz            = $result[0]['juz'];
            $star           = $result[0]['star']; 
            $noreport       = $result[0]['noreport']; 
            $reward         = $result[0]['reward'];
            $reward_start_time = $result[0]['reward_start_time'];
            $reward_end_time = $result[0]['reward_end_time'];
            $icon           = $result[0]['icon'];
            $header         = $result[0]['header'];
            $footer         = $result[0]['footer']; 
            $view_message   = $result[0]['view_message']; 
            $sort           = $result[0]['sort']; 
        }  
        
        // membuat text laporan list odoj
        
        # HEADER
        # bismillah
        $text = "o  ⁠⁠⁠بِسْـــــــــمِ اللهِ الرَّحْمَٰنِ الرَّحِيْمِ    o \n\n";
        
        # Header Judul
        $arr_header = json_decode($header, true);
        foreach ($arr_header as $k => $v){
            $text .=  $v ."\n"; 
        }

        $hari_indo = DB::hari_indo(date("D", strtotime($tanggal)));
        $tanggal_masehi = date("j M Y", strtotime($tanggal));
        $text .= "Periode : " . $hari_indo . ', '. $tanggal_masehi;

        # reward
        $arr_view_message = json_decode($view_message, true);
        if ($arr_view_message['show_reward_list'] == '1') {
            $text .= "\n\n";

            $arr_reward = json_decode($reward, true);
            $arr_reward_start_time = json_decode($reward_start_time, true);
            $arr_reward_end_time = json_decode($reward_end_time, true);

            for ($i=1; $i < count($arr_reward) ; $i++) { 
                 $text .=  $arr_reward_start_time[$i] . " - " . $arr_reward_end_time[$i] . " = " . $arr_reward[$i] . "\n"; 
            }
        }

        # noreport
        $arr_icon = json_decode($icon, true);
        //$text .=  "\n" .  $arr_icon[0] . ' : Belum lapor'; 

        $no_noreport = 0;
        $arr_noreport = json_decode($noreport, true);
        foreach ($arr_noreport as $key => $value){
            if ($no_noreport == 0) {
                $text .=  "\n" .  $value . ' : Belum lapor '; 
            }else{
                $text .=  "\n" .  $value . ' : Tidak lapor ' .$no_noreport.'x'; 
            }
            $no_noreport++;
        }
        $text .= ' dst';

        # data list odoj
        $list_odoj = self::getListOdoj($id_group_odoj, $tanggal, $juz, $nama_team, $sort);
        $text .= $list_odoj;

        # resume kholas
        $jumlah_kholas = 0;
        if ($result = DB::getPdo()->query("SELECT COUNT(id_user) as jumlah_kholas FROM am_odoj WHERE id_group_odoj='". $id_group_odoj ."' AND tanggal_tugas='" .$tanggal. "' AND is_kholas !='0' AND is_kholas !='3'")) {
            $result = $result->fetchAll();

            $jumlah_kholas = $result[0]['jumlah_kholas'];
        }

        $jumlah_anggota_hari_cari = 0;
        if ($result = DB::getPdo()->query("SELECT COUNT(id_user) as jumlah_anggota_hari_cari FROM am_odoj WHERE id_group_odoj='". $id_group_odoj ."' AND tanggal_tugas='" .$tanggal. "'")) {
            $result = $result->fetchAll();

            $jumlah_anggota_hari_cari = $result[0]['jumlah_anggota_hari_cari'];
        }

        $belum_lapor = $jumlah_anggota_hari_cari - $jumlah_kholas;

                # ambil array juz
        $juz = json_decode($juz, true);
        $arrayJuz = self::getIconJuz($juz['mode']);
        $juz_icon = $juz['text'];

        $text .= $juz_icon . $arr_icon[1] ." Kholas : " . $jumlah_kholas;
        $text .= "\nBELUM LAPOR = " . $belum_lapor . " (Total ". $jumlah_anggota_hari_cari .")";

        # mencari nama PJ
        $PJ = '';
        $pj = json_decode($pj, true);
        
        if (isset($pj['nama'])) {
            $pj = $pj['nama'];
            if ($result = DB::getPdo()->query('SELECT am_user.nama FROM `am_user` WHERE id='. $pj)) {
                $result = $result->fetchAll();
                $PJ = $result[0]['nama'];
            }

        }elseif(isset($pj['juz'])){
            if ($result = DB::getPdo()->query("SELECT am_user.nama FROM am_odoj JOIN am_user ON am_odoj.id_user=am_user.id WHERE am_odoj.id_group_odoj='". $id_group_odoj . "' AND am_odoj.tanggal_tugas='" .$tanggal. "' AND am_odoj.juz='" . $pj['juz'] . "' ")) {
                $result = $result->fetchAll();
                foreach ($result as $key) {
                    $PJ = $key[0];
                }
            }            
        }

        $text .= "\nPJ : " . $PJ;

        # footer
        $text .= "\n\n";
        $arr_footer = json_decode($footer, true);
        foreach ($arr_footer as $k => $v){
            $text .=  $v ."\n"; 
        }

        $text .= "\nKetik : odoj lapor nama juz x \n";
        $text .= "untuk update secara otomatis. List harian berubah otomatis pada jam ". substr($deadline, 0, 5) .".";
        
        return $text;

    }

    public static function getListOdoj($id_group_odoj, $tanggal, $juz, $nama_team, $sort){
        # pilihan sorting menu
        if ($sort == 0) {
            $sort = 'am_odoj.juz';
        }else{
            $sort = 'am_user.nama';
        }

        # tanggal server
        $tanggal_server = DB::getTzJakarta("Date");


        # ambil array juz
        $juz = json_decode($juz, true);
        $arrayJuz = self::getIconJuz($juz['mode']);
        $juz_icon = $juz['text'];

        # ambil icon kholas, icon noreport, panggilan
        # ambil 
        if ($result = DB::getPdo()->query("SELECT icon, noreport, panggilan FROM am_group_odoj WHERE id_group_odoj='". $id_group_odoj . "'")) {
            $result = $result->fetchAll();
            $icon_kholas = json_decode($result[0]['icon'], true);
            $icon_noreport = json_decode($result[0]['noreport'], true);
            $panggilan = $result[0]['panggilan'];
        }

        $text = "\n\n";

        if ($hasil = DB::getPdo()->query("SELECT am_odoj.team FROM am_odoj WHERE id_group_odoj='". $id_group_odoj . "' AND tanggal_tugas='" .$tanggal. "' GROUP BY team ORDER BY team ASC")) {
            $hasil = $hasil->fetchAll();
            foreach ($hasil as $key) {
                $team[] = $key[0];
            }
        }

        $nama_team = json_decode($nama_team, true);
        foreach ($team as $key => $value) {
            if (count($team)>1) {
                $text .= $nama_team['sebutan'] . " " . $nama_team[$key+1] . "\n\n";
            }

            if ($result = DB::getPdo()->query("SELECT am_user.nama, am_odoj.juz, am_odoj.is_kholas, am_odoj.noreport, am_odoj.reward FROM am_odoj JOIN am_user ON am_odoj.id_user=am_user.id WHERE am_odoj.id_group_odoj='". $id_group_odoj . "' AND am_odoj.tanggal_tugas='" .$tanggal. "' AND am_odoj.team='" . $value . "' ORDER BY ". $sort)) {
                $result = $result->fetchAll();
                foreach ($result as $key) {
                    $juz = $key[1];
                    $noreport = $key[3];
                    $is_kholas = $key[2];

                    if ($noreport != '') {
                        if ($noreport >= count($icon_noreport)) {
                            $noreport = count($icon_noreport)-1;
                        }
                        $text .= $juz_icon . $arrayJuz[$juz] ." ". $icon_noreport[$noreport] ." ". $panggilan." ". $key[0] ." ". $key[4] ."\n";
                    }else{
                        $text .= $juz_icon . $arrayJuz[$juz] ." ". $icon_kholas[$is_kholas] ." ". $panggilan." ". $key[0] ." ". $key[4] ."\n";
                    }
                }

            }
            $text .= "\n";
        }

        return $text;
    } 


    public static function getIconJuz($juz_mode){
        # pilihan juz mode
        if ($juz_mode == 0) {
            for ($i=1; $i <= 30 ; $i++) { 
                $arrayJuz[$i] = $i;
            }

        }elseif($juz_mode == 1){
            $arrayJuz[1] = '0️⃣1️⃣';
            $arrayJuz[2] = '0️⃣2️⃣';
            $arrayJuz[3] = '0️⃣3️⃣';
            $arrayJuz[4] = '0️⃣4️⃣';
            $arrayJuz[5] = '0️⃣5️⃣';
            $arrayJuz[6] = '0️⃣6️⃣';
            $arrayJuz[7] = '0️⃣7️⃣';
            $arrayJuz[8] = '0️⃣8️⃣';
            $arrayJuz[9] = '0️⃣9️⃣';
            $arrayJuz[10] = '1️⃣0️⃣';
            $arrayJuz[11] = '1️⃣1️⃣';
            $arrayJuz[12] = '1️⃣2️⃣';
            $arrayJuz[13] = '1️⃣3️⃣';
            $arrayJuz[14] = '1️⃣4️⃣';
            $arrayJuz[15] = '1️⃣5️⃣';
            $arrayJuz[16] = '1️⃣6️⃣';
            $arrayJuz[17] = '1️⃣7️⃣';
            $arrayJuz[18] = '1️⃣8️⃣';
            $arrayJuz[19] = '1️⃣9️⃣';
            $arrayJuz[20] = '2️⃣0️⃣';
            $arrayJuz[21] = '2️⃣1️⃣';
            $arrayJuz[22] = '2️⃣2️⃣';
            $arrayJuz[23] = '2️⃣3️⃣';
            $arrayJuz[24] = '2️⃣4️⃣';
            $arrayJuz[25] = '2️⃣5️⃣';
            $arrayJuz[26] = '2️⃣6️⃣';
            $arrayJuz[27] = '2️⃣7️⃣';
            $arrayJuz[28] = '2️⃣8️⃣';
            $arrayJuz[29] = '2️⃣9️⃣';
            $arrayJuz[30] = '3️⃣0️⃣';
        }else{
            $arrayJuz[1] = 'ⓞ①';
            $arrayJuz[2] = 'ⓞ②';
            $arrayJuz[3] = 'ⓞ③';
            $arrayJuz[4] = 'ⓞ④';
            $arrayJuz[5] = 'ⓞ⑤';
            $arrayJuz[6] = 'ⓞ⑥';
            $arrayJuz[7] = 'ⓞ⑦';
            $arrayJuz[8] = 'ⓞ⑧';
            $arrayJuz[9] = 'ⓞ⑨';
            $arrayJuz[10] = '①ⓞ';
            $arrayJuz[11] = '①①';
            $arrayJuz[12] = '①②';
            $arrayJuz[13] = '①③';
            $arrayJuz[14] = '①④';
            $arrayJuz[15] = '①⑤';
            $arrayJuz[16] = '①⑥';
            $arrayJuz[17] = '①⑦';
            $arrayJuz[18] = '①⑧';
            $arrayJuz[19] = '①⑨';
            $arrayJuz[20] = '②ⓞ';
            $arrayJuz[21] = '②①';
            $arrayJuz[22] = '②②';
            $arrayJuz[23] = '②③';
            $arrayJuz[24] = '②④';
            $arrayJuz[25] = '②⑤';
            $arrayJuz[26] = '②⑥';
            $arrayJuz[27] = '②⑦';
            $arrayJuz[28] = '②⑧';
            $arrayJuz[29] = '②⑨';
            $arrayJuz[30] = '③ⓞ';
        }

        return $arrayJuz;
    }  

}
