<?php
/**
 * perintah : /odojlapor <text>
 * perintah untuk lapor odoj odoj 
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;

class OdojlaporCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'odojlapor';

    /**
     * @var string
     */
    protected $description = 'Odoj lapor Command';

    /**
     * @var string
     */
    protected $usage = '/odojlapor <text>';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {
        $message = $this->getMessage();
        $chat_id = $message->getChat()->getId();
        $user_id = $message->getFrom()->getId();
        $command = strtolower(DB::clearDoubleSpace($message->getText(true)));

        //Send chat action
        Request::sendChatAction([
            'chat_id' => $chat_id,
            'action'  => 'typing',
        ]);

        # saring user yang ikut ODOJ saja yang dilayani
        if ($result = DB::getPdo()->query("SELECT is_odoj, status FROM am_user WHERE id='" .$user_id. "' AND is_odoj='1' AND status='1'" )) {
            $result = $result->fetchAll();
            $is_odoj = $result[0]['is_odoj'];
            $status = $result[0]['status'];
            if ($is_odoj == 1 AND $status == 1) {

                # ambil id group odoj user
                $deadline = '00:00:00';
                if ($result = DB::getPdo()->query('SELECT am_group_odoj.deadline, am_user.id_group_odoj FROM am_user JOIN am_group_odoj ON am_user.id_group_odoj=am_group_odoj.id_group_odoj  WHERE am_user.id='. $user_id)) {
                    $result = $result->fetchAll();
                    $deadline = $result[0]['deadline'];
                    $id_group_odoj = $result[0]['id_group_odoj'];
                }

                # proses update odoj
                $text = self::updateOdoj($command, $id_group_odoj, $deadline);

            }else{
                $text[] = "⛔️ *ERROR:* _Maaf, anda tidak mengikuti program ODOJ._";  
            }
        }else{
            $text[] = "⛔️ *ERROR:* _Maaf, server sedang gangguan!_";
        }

        foreach ($text as $key => $value) {
            $data = [
                'chat_id' => $chat_id,
                'text'    => $value,
                'parse_mode' => 'Markdown'
            ];

            Request::sendMessage($data);
        }

    }


    public static function updateOdoj($command, $id_group_odoj, $deadline)
    {
        # buat variable untuk perintah didepan, yaitu odoj lapor atau odoj tanggal lapor
        $odojlaporCommand = '';
        # pisakan perintah by enter, barangkali menggunakan banyak perintah sekali kirim
        $ListCommand = preg_split('/\r\n|\r|\n/', $command);
        foreach ($ListCommand as $key => $valCommand) {

            # cek perintah berdasarkan format
            if ($odojlaporCommand == '') {
                $exp = explode(" ", $valCommand);
            }else{
                $valCommand = $odojlaporCommand . ' ' . $valCommand;
                $exp = explode(" ", $valCommand);
            }
            
            # jika ada parameter tanggal pencarian
            # perintah : odoj 20-okt-2018 lapor --> masuk sini
            if (isset($exp[1]) AND $exp[1] != 'lapor') {
                # cek dulu format tanggalnya
                # format diijinkan 1-1-2018 / 1-oct-2018
                if (DB::cekFormatTanggal($exp[1]) === True) {
                    $tanggal_tugas = DB::getDateDB($exp[1]);
                    $odojlaporCommand = 'odoj ' . $exp[1] . ' lapor';
                    $arr_parameter = self::getParameter($valCommand, $tanggal_tugas);  

                }else{
                    $arr_parameter['error'] = self::getError('tanggal');               
                }
            }else{
                $odojlaporCommand = 'odoj lapor';
                # disini bagian kalo perintahnya odoj lapor bla bla bla
                # cek dulu deadlinenya, sesuaikan tanggal list dengan tanggal deadline
                $date_cari = DB::getTzJakarta('Date');
                $time_cari = DB::getTzJakarta('Time');
                $time_cari = (int) preg_replace('/\D/', '', $time_cari);
                $deadline = (int) preg_replace('/\D/', '', $deadline);
                if($time_cari > $deadline AND $deadline != 0){
                    # jika waktu cari lebih dari deadline dan deadline tidak sama dengan jam 00:00, maka tanggal lapor tanggal besoknya
                    $tanggal_tugas = date('Y-m-d', strtotime("+1 day", strtotime($date_cari)));
                }else{
                    # waktu pencarian kurang dari waktu deadline, maka tanggal list sesuai dengan tanggal pencarian
                    $tanggal_tugas = $date_cari;
                }

                $arr_parameter = self::getParameter($valCommand, $tanggal_tugas);  

            }

            if (!isset($arr_parameter['error'])) {
                $boleh_lapor = TRUE;
                # ambil data seting group odoj untuk mencari settingan berapa hari laporan tela dan berapa hari laporan majunya
                if ($result = DB::getPdo()->query('SELECT laporan_telat, laporan_maju FROM `am_group_odoj` WHERE id_group_odoj='. $id_group_odoj)) {
                    $result = $result->fetchAll();

                    $laporan_telat    = $result[0]['laporan_telat'];
                    $laporan_maju      = $result[0]['laporan_maju'];
                } 

                # cari tanggal lapor real
                $tanggal_lapor = DB::getTzJakarta('Date');

                $tanggal_lapor_int = preg_replace('/[^0-9]/', '', $tanggal_lapor);
                $tanggal_tugas_int = preg_replace('/[^0-9]/', '', $arr_parameter['tanggal_tugas']);

                # jika laporan telat, cek dengan nilai maksimal laporan telat
                if ($tanggal_lapor_int > $tanggal_tugas_int) {
                    $selilih_hari_telat = DB::get_selisih_hari($tanggal_lapor, $arr_parameter['tanggal_tugas']);
                    if ($selilih_hari_telat > $laporan_telat) {
                        $boleh_lapor = FALSE;
                    }
                # jika laporan maju, cek dengan nilai maksimal laporan maju
                }elseif($tanggal_lapor_int < $tanggal_tugas_int){
                    $selilih_hari_maju = DB::get_selisih_hari($tanggal_lapor, $arr_parameter['tanggal_tugas']);
                    if ($selilih_hari_maju > $laporan_maju) {
                        $boleh_lapor = FALSE;
                    }
                }

                #jika laporan masih dalam jangkauan bisa lapor maka proses lanjutkan
                if ($boleh_lapor === TRUE) {
                    $hasil = self::prosesLapor($arr_parameter['nama'], $arr_parameter['juz'], $arr_parameter['tanggal_tugas'], $arr_parameter['tanggal_kholas'], $arr_parameter['waktu_kholas'], $arr_parameter['is_kholas'], $id_group_odoj); 
                    if ($hasil['successful'] == '1') {

                        $text[] = self::getLaporan($hasil['user_id'], $hasil['tanggal_tugas']);
                        
                    }else{
                        $text[] = $hasil;
                    }
                }else{
                    $text[] = "⛔️ *ERROR:* _Maaf, tanggal lapor melebihi batas ketentuan._";  
                }

            }else{
                $text[] = $arr_parameter['error'];
            }

        }

        return $text;

    }        

    public static function getLaporan($user_id, $tanggal_tugas)
    {
        if ($result = DB::getPdo()->query("SELECT am_group_odoj.view_message, am_user.nama, am_odoj.is_kholas, am_odoj.juz, am_odoj.id_group_odoj FROM am_odoj JOIN am_group_odoj ON am_odoj.id_group_odoj=am_group_odoj.id_group_odoj JOIN am_user ON am_odoj.id_user=am_user.id WHERE am_odoj.id_user='" .$user_id. "' AND tanggal_tugas='". $tanggal_tugas ."' " )) {
            $result = $result->fetchAll();
            # ambil nama sesuai nama user
            $nama = $result[0]['nama'];
            # ambil keterangan kholas
            if ($result[0]['is_kholas'] == '1') {
                $is_kholas = 'kholas';
            }elseif ($result[0]['is_kholas'] == '2') {
                $is_kholas = 'tarjim/tasmi/murattal';
            }else{
                $is_kholas = 'on progress';
            }
            # ambil juz
            $juz = $result[0]['juz'];

            # ambil footenote
            

            $jumlah_kholas = 0;
            $id_group_odoj = $result[0]['id_group_odoj'];
            if ($result = DB::getPdo()->query("SELECT COUNT(id_user) as jumlah_kholas FROM am_odoj WHERE id_group_odoj='". $id_group_odoj ."' AND tanggal_tugas='" .$tanggal_tugas. "' AND is_kholas !='0' AND is_kholas !='3'")) {
                $result = $result->fetchAll();

                $jumlah_kholas = $result[0]['jumlah_kholas'];
            }

            $laporan = "Laporan sudah dicatat.\n";
            $laporan .= $nama.", ".$is_kholas." juz ".$juz."\n";
            $laporan .= "Total ".$jumlah_kholas." member sudah lapor\n";
            $laporan .= "═══════════════════════";

        }
        //$nama = 'berhasil';

        return $laporan;
    }

    public static function getParameter($command = null, $tanggal_tugas = null)
    {
        $comm = explode(" ",$command);
        $arr_parameter = array();
        $parameter_error = 'tidak error';

        # cari parameter nama
        $lapor_val = array_search('lapor', $comm);
        $juz_val = array_search('juz', $comm);

        $param_nama = '';
        if ($juz_val !== false) {
            for ($i=$lapor_val+1; $i < $juz_val; $i++) { 
                $param_nama .= $comm[$i] .' ';
            }
            $arr_parameter['nama'] = $param_nama;
        }else{
            $parameter_error = self::getError('juz'); 
        }

        # cari juz
        if (isset($comm[$juz_val+1])) {
            $juz_string = $comm[$juz_val+1];
            $juz = (int) $juz_string;
            if (strlen($juz) <= 2 AND $juz <= 30 AND $juz != 0)  {
               $arr_parameter['juz'] = $juz;
            }else{
                $parameter_error = self::getError('juz salah');
            }
        }else{
            $parameter_error = self::getError('juz salah');
        }

        # cari tanggal tugas
        $arr_parameter['tanggal_tugas'] = $tanggal_tugas ?: DB::getTzJakarta('Date');

        # cari parameter kholas tarjim otw
        $arr_parameter['is_kholas'] = 1;
        if (isset($comm[$juz_val+2])) {
            $is_kholas = $comm[$juz_val+2];
            if ($is_kholas == 'tarjim' OR $is_kholas == 'tasmi' OR $is_kholas == 'murattal') {
                $arr_parameter['is_kholas'] = 2;
                $juz_val = $juz_val + 1;
            }elseif($is_kholas == 'sedang baca' OR $is_kholas == 'otw' OR $is_kholas == 'on progress'){
                $arr_parameter['is_kholas'] = 3;
                $juz_val = $juz_val + 1;
            }elseif($is_kholas == 'kholas'){
                $juz_val = $juz_val + 1;
            }
        }

        # cari tanggal kholas
        if (isset($comm[$juz_val+2]) AND isset($comm[$juz_val+3])) {
            $tanggal_kholas = $comm[$juz_val+2];
            if (DB::cekFormatTanggal($tanggal_kholas) === True AND DB::cekFormatWaktu($comm[$juz_val+3]) === true) {
                $arr_parameter['tanggal_kholas'] = DB::getDateDB($tanggal_kholas);
                $arr_parameter['waktu_kholas'] = DB::getTimeDB($comm[$juz_val+3]);
            }elseif($tanggal_kholas == 'kemarin' && $comm[$juz_val+3] == 'jam' && DB::cekFormatWaktu($comm[$juz_val+4]) === true){
                $tgl_sekarang = DB::getTzJakarta('Date');
                $tgl_kemarin = date('Y-m-d', strtotime("-1 day", strtotime($tgl_sekarang)));
                $arr_parameter['tanggal_kholas'] = $tgl_kemarin;
                $arr_parameter['waktu_kholas'] = DB::getTimeDB($comm[$juz_val+4]);
            }elseif ($tanggal_kholas != 'jam') {
                $parameter_error = self::getError('tanggal_kholas salah');
            }
        }

        #cari parameter jam
        $jam_val = array_search('jam', $comm);

        if ($jam_val !== false) {
            if (isset($comm[$jam_val+1])) {
                if (DB::cekFormatWaktu($comm[$jam_val+1]) === true) {
                    if (!isset($arr_parameter['waktu_kholas'])) {
                        $arr_parameter['waktu_kholas'] = DB::getTimeDB($comm[$jam_val+1]);
                    }
                }
            }else{
                $parameter_error = self::getError('waktu_kholas salah');
            }
        }
       

        # jika tanggal kholas dan waktu belum terdefinisi maka isi default
        if ($arr_parameter['tanggal_kholas'] == '') {
           $arr_parameter['tanggal_kholas'] = DB::getTzJakarta('Date');
        }
        
        if ($arr_parameter['waktu_kholas'] == '') {
            $arr_parameter['waktu_kholas'] = DB::getTzJakarta('Time');
        } 

        # return paramter
        if ($parameter_error == 'tidak error') {
            return $arr_parameter;
        }else{
            $arr_parameter['error'] = $parameter_error;
            return $arr_parameter;
        }
    }  

    public static function prosesLapor($nama, $juz, $tanggal_tugas, $tanggal_kholas, $waktu_kholas, $is_kholas, $id_group_odoj)
    {
        # cek dulu apakah datanya ada ga untuk tanggal tugas sekian atas nama tersebut
        if ($result = DB::getPdo()->query("SELECT juz, tanggal_tugas, is_kholas FROM am_odoj JOIN am_user ON am_odoj.id_user=am_user.id WHERE LOWER(am_user.nama)='" .$nama. "' AND tanggal_tugas='". $tanggal_tugas ."' AND am_odoj.id_group_odoj='".$id_group_odoj."' " )) {
            $result = $result->fetch();
            if ($result) {
                // $hasil = 'data ada';

                if ($result = DB::getPdo()->query("SELECT id_user, juz, tanggal_tugas, is_kholas FROM am_odoj JOIN am_user ON am_odoj.id_user=am_user.id WHERE LOWER(am_user.nama)='" .$nama. "' AND juz='". $juz ."' AND tanggal_tugas='". $tanggal_tugas ."' AND am_odoj.id_group_odoj='".$id_group_odoj."' " )) {
                    $result = $result->fetchAll();
                    if ($result) {
                        # cek apakah sudah lapor ato belum, tandanya yang belum lapor is_kholas masih 0
                        # proses jika status masih belum kholas, artinya yang status 3 / otw masih bisa di apdet tanpa error
                        if ($result[0]['is_kholas'] != '1') {   
                            $user_id = $result[0]['id_user'];

                            if ($is_kholas == '1' OR $is_kholas == '2') {
                                $reward = self::getReward($id_group_odoj, $tanggal_tugas, $tanggal_kholas, $waktu_kholas);
                            }else{
                                $reward['icon'] = '';
                                $reward['nilai'] = '';
                            }

                            # update data odoj 
                            $updated_at = DB::getTzJakarta('DateTime');
                            $fields_values = ['tanggal_kholas'=>$tanggal_kholas, 'waktu_kholas'=>$waktu_kholas, 'is_kholas'=>$is_kholas, 'noreport'=>'', 'reward'=>$reward['icon'], 'nilai_reward'=>$reward['nilai'], 'updated_at'=>$updated_at];
                            $where_fields_values = ['id_user'=> $user_id, 'tanggal_tugas'=>$tanggal_tugas];
                            $result_update = DB::update('am_odoj', $fields_values, $where_fields_values);

                            if ($result_update == true) {
                                $sukses['successful'] = '1';
                                $sukses['user_id'] = $user_id;
                                $sukses['tanggal_tugas'] = $tanggal_tugas;

                                $hasil = $sukses;
                            }else{
                                $hasil = "⛔️ *ERROR:* _Lapor odoj gagal!_";
                            }

                        }else{
                            $hasil = "⛔️ *ERROR:* _Kamu sudah lapor!_";
                            $hasil .= "\n\nKetik: `odoj batal fulan` untuk membatalkan laporan";  
                        }
                        
                    }else{
                        $hasil = "⛔️ *ERROR:* _Maaf, data tidak ditemukan!_";
                    }

                }


            }else{
                # ambil user id sambil cek nama nya
                if ($result = DB::getPdo()->query("SELECT id,,id_unit, team FROM am_user WHERE LOWER(nama)='" .$nama. "' AND is_odoj='1' AND status='1'AND id_group_odoj='".$id_group_odoj."' ")) {
                    $result = $result->fetchAll();
                    if (isset($result[0]['id'])) {
                        $user_id = $result[0]['id'];
                        $id_unit = $result[0]['id_unit'];
                        $team = $result[0]['team'];
                        # kalo data tidak ditemukan, maka proses insert data baru
                        # ambil reward
                        if ($is_kholas == '1' OR $is_kholas == '2') {
                            $reward = self::getReward($id_group_odoj, $tanggal_tugas, $tanggal_kholas, $waktu_kholas);
                        }else{
                            $reward['icon'] = '';
                            $reward['nilai'] = '';
                        }

                        $insert_odoj = DB::insert_odoj($user_id, $juz, $tanggal_tugas, $tanggal_kholas, $waktu_kholas, $is_kholas, $id_group_odoj, $team, $reward['icon'], $reward['nilai'], '', $id_unit);
                        if ($insert_odoj === true) {
                            $sukses['successful'] = '1';
                            $sukses['user_id'] = $user_id;
                            $sukses['tanggal_tugas'] = $tanggal_tugas;

                            $hasil = $sukses;
                        }else{
                            $hasil = "⛔️ *ERROR:* _Lapor odoj gagal XXX!_".$team;
                        }

                    }else{
                        $hasil = "⛔️ *ERROR:* _Maaf, data tidak ditemukan!_";
                    }
                    
                } 
               // $hasil = "⛔️ *ERROR:* _Maaf, data tidak ditemukan!_";
            }

        }else{
            $hasil = "⛔️ *ERROR:* _Maaf, server sedang gangguan!_";
        }
        
    //    $hasil = 'masuk fungsi';
        return $hasil;

    }  

    public static function getReward($id_group_odoj, $tanggal_tugas, $tanggal_kholas, $waktu_kholas)
    {
        # ambil data seting group odoj
        if ($result = DB::getPdo()->query('SELECT * FROM `am_group_odoj` WHERE id_group_odoj='. $id_group_odoj)) {
            $result = $result->fetchAll();
            $deadline = $result[0]['deadline'];
            $arr_reward = json_decode($result[0]['reward'], true);
            $reward_start_time = json_decode($result[0]['reward_start_time'], true);
            $reward_end_time = json_decode($result[0]['reward_end_time'], true); 

            $waktu_kholas = substr($waktu_kholas, 0, 5);
            $waktu_kholas = str_replace(":", "", $waktu_kholas);
            $tanggal_kholas = str_replace("-", "", $tanggal_kholas);

            # buat array start time dan end time berdasarkan tanggal darn wktu
            # c: 201810012330 
            $hari = 1;
            for ($i=1; $i < count($arr_reward) ; $i++) { 
                $reward_start_time_val = str_replace(":", "", $reward_start_time[$i]);
                $reward_end_time_val = str_replace(":", "", $reward_end_time[$i]);

                if ($reward_start_time_val >= '1600' AND $hari == '1') {
                    $tanggal = date('Y-m-d', strtotime("-1 day", strtotime($tanggal_tugas)));
                    $tanggal_val = str_replace("-", "", $tanggal);
                }else{
                     $tanggal_val = str_replace("-", "", $tanggal_tugas);
                     $hari++;
                }

                $start_val = $tanggal_val.$reward_start_time_val;
                $rank_start[$i] = $start_val;
                
                if ($reward_end_time_val >= '1600' AND $hari == '1') {
                    $tanggal = date('Y-m-d', strtotime("-1 day", strtotime($tanggal_tugas)));
                    $tanggal_val = str_replace("-", "", $tanggal);
                }else{
                     $tanggal_val = str_replace("-", "", $tanggal_tugas);
                     $hari++;
                }

                $end_val = $tanggal_val.$reward_end_time_val;
                $rank_end[$i] = $end_val;
            }

            # bandingkan waktu kholas dan array rank reward
            $rank_terakhir = count($rank_end);
            $kholas = $tanggal_kholas.$waktu_kholas;
            if ($kholas < $rank_start['1']) {
                $reward['icon'] = $arr_reward['1'];
                $reward['nilai'] = 24;
            }elseif($kholas > $rank_end[$rank_terakhir]){
                $reward['icon'] = $arr_reward['d'];
                $reward['nilai'] = 24 - $rank_terakhir;
            }else{
                for ($i=1; $i <= count($rank_start) ; $i++) { 
                //    $reward .= $rank_start[$i] . " " .$rank_end[$i]."\n";
                    if ($kholas >= $rank_start[$i] AND $kholas <= $rank_end[$i]) {
                        $reward['icon'] = $arr_reward[$i];
                        $reward['nilai'] = 24 - $i + 1;
                        break;
                    }
                }
            }


            return $reward;
        }
    }

    public static function getError($parameter_null)
    {
        switch ($parameter_null) {
            case 'tanggal':
                $text = "⛔️ *ERROR:* _Format tanggal salah!_";
                $text .= "\n\nContoh: `odoj 25-Oct-2018 lapor fulan juz 7`";  
                break;

            case 'juz':
                $text = "⛔️ *ERROR:* _Parameter juz tidak ditemukan!_";
                $text .= "\n\nContoh: `odoj lapor fulan juz 7`";  
                break;

            case 'juz salah':
                $text = "⛔️ *ERROR:* _Parameter juz salah!_";
                $text .= "\n\nContoh: `odoj lapor fulan juz 7`";  
                break;

            case 'tanggal_kholas salah':
                $text = "⛔️ *ERROR:* _Parameter tanggal kholas salah!_";
                $text .= "\n\nContoh: `odoj lapor fulan juz 7 15-oct-2018 22.30`";  
                break;

            case 'waktu_kholas salah':
                $text = "⛔️ *ERROR:* _Parameter waktu kholas salah!_";
                $text .= "\n\nContoh: `odoj lapor fulan juz 7 jam 22.30`";  
                break;

            case 'nama':
                $text = "⛔️ *ERROR:* _Parameter nama tidak ditemukan_";
                break;
            
            default:
                $text = "⛔️ *ERROR:* __";
                break;
        }

        return $text;

    }
}
