<?php
/**
 * perintah : /odojhel 
 * perintah untuk menampilkan perintah help atau help admin
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;

class OdojhelpCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'odojhelp';

    /**
     * @var string
     */
    protected $description = 'Odoj help Command';

    /**
     * @var string
     */
    protected $usage = '/odojhelp <text>';

    /**
     * @var string
     */
    protected $version = '1.1.0';


    public function execute()
    {
        $message = $this->getMessage();
        $chat_id = $message->getChat()->getId();
        $user_id = $message->getFrom()->getId();
        $command = strtolower(DB::clearDoubleSpace($message->getText(true)));

        # saring user yang ikut ODOJ saja yang dilayani
        if ($result = DB::getPdo()->query("SELECT is_odoj, status FROM am_user WHERE id='" .$user_id. "' AND is_odoj='1' AND status='1'" )) {
            $result = $result->fetchAll();
            $is_odoj = $result[0]['is_odoj'];
            $status = $result[0]['status'];
            if ($is_odoj == 1 AND $status == 1) {

                # cek perintah help
                $exp = explode(" ", $command);

                # perintah untuk odoj help admin
                if (isset($exp[2]) AND $exp[2] == 'admin') {
                    $text = "*Perintah lanjutan untuk yang mau mengubah-ubah tampilan laporan harian.*\n\n";
                    $text .= "`odoj ganti nama=juz,tim;`\n";
                    $text .= "- contoh: odoj ganti Fulan=17,1 \n";
                    $text .= "- menambah atau merubah data untuk member bernama Fulan menjadi juz 17 dan
   Jika group tidak dibagi dalam tim, maka tim diganti dengan angka 0. \n";
                    $text .= "- untuk melihat data Member yang sudah mendaftar ketik : `odoj member` \n\n";

                    $text .= "`odoj ganti #parameter=value;` \n\n";

                    $text .= "Parameter yang dikenal : \n\n";

                    // $text .= "#group=nomorgroup \n";
                    // $text .= "- contoh: odoj ganti #group=1234; \n";
                    // $text .= "-  merubah id group ODOJ menjadi 1234 \n\n";

                    // $text .= "#admin=nama,mode,tulisan; \n";
                    // $text .= "- contoh: odoj ganti #admin=Fulan,1,Admin; \n";
                    // $text .= "- menampilkan nama admin di bawah tanggal (mode=1) atau di footer (mode=2). \n\n";

                    $text .= "#pj=juz/nama; \n";
                    $text .= "- contoh: odoj ganti #juz=1; \n";
                    $text .= "- mengganti aturan yang menjadi PJ, di contoh adalah yang dapet juz 1. \n\n";

                    $text .= "#panggilan=nnn; \n";
                    $text .= "- contoh: odoj ganti #panggilan=Akh; \n";
                    $text .= "- menambah Akh di depan semua nama di laporan harian. \n\n";

                    $text .= "#team=sebutanTim,namatim1,namatim2; \n";
                    $text .= "- contoh: #team=Kelompok,Satu,Dua,Tiga; \n";
                    $text .= "- mengubah penyebutan Tim 1, Tim 2, dst menjadi (misalnya dalam contoh diatas) Kelompok Satu, Kelompok Dua, dst \n\n";

                    $text .= "#juz=icon/text,mode; \n";
                    $text .= "- contoh: #juz=Juz ,0; \n";
                    $text .= "- mengubah tampilan tulisan juz. mode=0 artinya tulisan biasa (01,02,03 dst), mode=1 menggunakan gambar angka. \n\n";

                    $text .= "#deadline=jamgantilaporan; \n";
                    $text .= "- contoh: odoj ganti #deadline=20.00; \n";
                    $text .= "- merubah waktu list berganti otomatis (menjadi jam 21:00). Jadi kalau perintah odoj list dikirimkan setelah jam 20:00 akan tampil list untuk besok. \n\n";

                    $text .= "#header=textuntukheader; \n";
                    $text .= "- contoh: odoj ganti #header=LAPORAN TILAWAH GROUP 1234; \n";
                    $text .= "- merubah tulisan di judul laporan harian, setelah kalimat bismillah. Kalau mau menambahkan ENTER, gunakan tanda | \n\n";

                    $text .= "#footer=textuntukfooter; \n";
                    $text .= "- contoh: odoj ganti #footer=TETAP SEMANGAT TILAWAH SETIAP HARI !;  \n";
                    $text .= "- merubah tulisan di akhir laporan. Ganti ENTER dengan tanda | \n\n";

                    $text .= "#start=tgl awal odoj,tanda,istilah; \n";
                    $text .= "- contoh: odoj ganti #start=1-2-2015,1,Hari ke-; \n";
                    $text .= "- menentukan tanggal awal group ODOJ. Jika tanda=1, akan ditampilkan tulisan Putaran: x sebelum tanggal,
   jika tanda=2, tulisan Putaran: x ditampilkan sesudah tanggal, tanda=0, tulisan Putaran tidak ditampilkan. \n\n";

                    $text .= "#noreport=a,b,c,d; \n";
                    $text .= "- contoh: odoj ganti #noreport=⚪️,🔵,🔴; \n";
                    $text .= "- merubah tanda untuk member yang belum lapor (a), tidak lapor 1x (b), 2x (c), 3x (d) dan seterusnya. \n";
                    $text .= "- Tanda boleh sampai berapa-pun, dipisah koma (belum lapor,tidak lapor 1x,2x,3x ... dan seterusnya). \n\n";

                    $text .= "#reward=b1-r1,b2-r2,b3-r3; \n";
                    $text .= "- contoh: odoj ganti #reward=06-🐪,13-🐄,18-🐏,d-🐓; \n";
                    $text .= "- merubah tanda reward untuk member yang kholas sebelum jam tertentu. \n";
                    $text .= "  b1 = batas akhir jam pertama\n";
                    $text .= "  r1 = reward batas pertama\n";
                    $text .= "  b2 = batas akhir jam kedua\n";
                    $text .= "  r2 = reward batas kedua\n";
                    $text .= "  dst ...\n";
                    $text .= "  Batas boleh berapa-pun, batas terakhir tidak akan ditampilkan, digunakan untuk yang melebihi batas waktu.\n\n";

                    $text .= "#icon=icon kholas,icon tarjim,icon progress; \n";
                    $text .= "- merubah tanda untuk kholas, tasmi/tarjim (khusus akhwat), dan tanda on-progress. \n";
                    $text .= "- contoh: odoj ganti #icon=✅,🚺,🔄; \n\n";

                    $text .= "#sort=0|1; \n";
                    $text .= "- untuk merubah urutan nama di list harian. \n";
                    $text .= "- Contoh : odoj ganti #sort=1; untuk menampilkan list urut berdasarkan abjad nama. By default, tampilan list akan diurut berdasarkan juz (di dalam setiap tim). \n\n";

                }else{
                    # perintah : odoj help ( help bagi member user)
                    $text = "*Perintah yang dikenal*\n\n";

                    $text .= "`odoj help` : menampilkan tulisan ini\n";
                    $text .= "`odoj help admin` : menampilkan bantuan lebih lanjut\n";
                //    $text .= "`odoj doa` : menampilkan doa penutup \n";
                    $text .= "`odoj list` : menampilkan list harian. \n";
                    $text .= "`odoj tgl list` : menampilkan list tanggal tgl \n";
                    $text .= "`odoj list rekap` : menampilkan rekap mingguan \n";
                    $text .= "`odoj list mingguan` : rekap mingguan (tanpa reward) \n";
                    $text .= "`odoj <bln> rekap` : rekap semua unit \n\n";

                    $text .= "`odoj <tgl> lapor nama juz x` \n";
                    $text .= "- lapor untuk nama di juz x kholas sekarang. \n";
                    $text .= "- contoh: odoj lapor fulan juz 15 \n";
                    $text .= "- contoh: odoj 9-oct-2018 lapor fulan juz 16 \n\n";

                    $text .= "`odoj <tgl> lapor nama juz x jam hh:mm` \n";
                    $text .= "- lapor sudah kholas juz x kholas jam hh:mm. \n";
                    $text .= "- contoh: odoj lapor fulan juz 17 jam 07:00 \n\n";

                    $text .= "`odoj <tgl> lapor nama juz x kemarin hh:mm` \n";
                    $text .= "- lapor sudah kholas juz x kemarin jam hh:mm. \n";
                    $text .= "- contoh: odoj lapor fulan juz 17 kemarin jam 20:30 \n\n";

                    $text .= "`odoj <tgl> batal nama` \n";
                    $text .= "- membatalkan laporan kholas \n";
                    $text .= "- contoh: odoj batal fulan \n\n";

                //    $text .= "`odoj <tgl> status <belum>` : menampilkan member yang sudah/belum lapor saja \n";
                    // $text .= "`odoj tgl_odoj lapor nama juz x kholas tgl_kholas jam_kholas` \n";
                    // $text .= "🔹`tgl_odoj` adalah tanggal jatah juz, atau tanggal list harian yang ingin diproses. Jika tanggal ini dikosongi, maka laporan akan mengacu ke jatah juz yang muncul di laporan harian. Tanggal bisa ditulis dalam format : `1-oct-2018` atau 1-10-2018 atau kata-kata : kemarin, hariini, sekarang, besok, dsb \n";
                    // $text .= "🔹`tgl_kholas` adalah tanggal kapan kita kholas. Jika tanggal ini dikosong, maka yang digunakan adalah tanggal hari itu. Format tanggal seperti yang berlaku untuk tgl odoj \n";
                    // $text .= "`🔹jam_kholas` adalah jam kapan kita kholas. Jika dikosongi maka yang digunakan adalah jam saat itu. Format jam bisa hh atau hh:mm atau hh.mm. \n";
                    // $text .= "`odoj <tgl> lapor nama juz x` : melaporkan status kholas/selesai untuk member nama dengan `jatah` juz x menggunakan jam laporan saat ini. Kosongi bagian tanggal jika yang dilaporkan adalah jatah juz hari ini. Jika yang dilaporkan bukan hari ini, maka tanggal harus diisi, misalnya kemarin, atau besok. \n";
                    // $text .= "`odoj <tgl> lapor nama juz x jam hh:mm` : lapor sudah kholas juz x dengan jam kholas pada hh:mm \n";
                    // $text .= "`odoj <tgl> lapor nama juz x kemarin jam hh:mm` : lapor sudah kholas juz x kemarin jam hh:mm \n";
                    // $text .= "`odoj <tgl> batal nama` : membatalkan laporan kholas \n";
                    $text .= " \n";


                }

                

            }else{
                $text = "⛔️ *ERROR:* _Maaf, anda tidak mengikuti program ODOJ._";  
            }

        }else{
            $text = "⛔️ *ERROR:* _Maaf, server sedang gangguan!_";
        }

        $data = [
            'chat_id' => $chat_id,
            'text'    => $text,
            'parse_mode' => 'Markdown'
        ];

        return Request::sendMessage($data);
    }

}