<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;

/**
 * User "/echo" command
 *
 * Simply echo the input back to the user.
 */
class CobalagiCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'cobalagi';

    /**
     * @var string
     */
    protected $description = 'Show text';

    /**
     * @var string
     */
    protected $usage = '/cobalagi <text>';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {
        $message = $this->getMessage();
        $chat_id = $message->getChat()->getId();
        $text    = trim($message->getText(true));

        // $exp = explode(" ",$text);

        // $code_ganti = $exp[0]; 
        // $value = $exp[1];
        // $exp_val = explode("=",$value);

        // $text = $exp_val[1];

        // if ($text === '') {
        //     $text = 'Command usage: ' . $this->getUsage();
        // }

        # insert
        //     $a = array('belum_lapor'=> ⚪, '1x' => ⚫, '2x' => 🔴);
        // $coba_json = json_encode($a);
        // $points = DB::insert_coba($coba_json);
        

        # update
            // edit data di table
            $a = array('belum_lapor'=> $text);
            $coba_json = json_encode($a, JSON_UNESCAPED_UNICODE);

        $fields_values = ['nama_coba'=>$coba_json];
        $where_fields_values = ['id_coba'=>'3'];
        if ($result1 = DB::update('coba', $fields_values, $where_fields_values)) {
            $points = 1;
        }

        if ($result = DB::getPdo()->query('SELECT * FROM `coba` WHERE id_coba=3 ')) {
            $result = $result->fetchAll();
            // foreach ($result as $key) {
            //      $points = $key[1];
            // }
            $point = $result[0]['nama_coba'];
        }

        $text = 'hai';
        $arr = json_decode($point, true);
        foreach ($arr as $k=>$v){
            $text .=  $v; 
        }

        $data = [
            'chat_id' => $chat_id,
            'parse_mode' => 'markdown',
            'text'    => $text,
        ];

        return Request::sendMessage($data);
    }
}
