<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;



/**
 * User "/echo" command
 *
 * Simply echo the input back to the user.
 */
class CobaCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'coba';

    /**
     * @var string
     */
    protected $description = 'Show text';

    /**
     * @var string
     */
    protected $usage = '/coba <text>';

    /**
     * @var string
     */
    protected $version = '1.1.0';

//     $mysql_external = [
//    'host'     => 'localhost',
//    'user'     => 'berkahgl',
//    'password' => 'Sha1&Md5',
//    'database' => 'berkahgl_demo',
// ];

//protected $name = 'points';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {

        //$telegram->enableExternalMySql($mysql_external);

        $message = $this->getMessage();
        $chat_id = $message->getChat()->getId();
        $text    = trim($message->getText(true));

        if ($text === '') {
            $text = 'Command usage: ' . $this->getUsage();
        }

        $skuList = preg_split('/\r\n|\r|\n/', $text);

        $text = '';
        foreach ($skuList as $key => $value) {
            $text .= $value . "\n" . $chat_id;
        }

        $text = DB::getTzJakarta('DateTime');

        $data = [
            'chat_id' => $chat_id,
            'text'    => $text,
        ];

        return Request::sendMessage($data);
        
    

    // $message = $this->getMessage();
    // $message_id = $message->getMessageId();
    // $chat_id = $message->getChat()->getId();
    // $user_id = $message->getFrom()->getId();

    //$points = 0;
    // if ($result = DB::getPdo()->query('SELECT * FROM `coba` ')) {
    //     $result = $result->fetchAll();
    //     foreach ($result as $key) {
    //          $points = $key[1];
    //     }
    //     //$points = $result[1]['nama_coba'];
    // }
    // 
    // edit data di table
    // $fields_values = ['id_coba'=>'1'];
    // $where_fields_values = ['id_coba'=>'4'];
    // if ($result = DB::update('coba', $fields_values, $where_fields_values)) {
    //     $points = 1;
    // }


    //$points = DB::insert_coba($coba_json);

    //     $ch = curl_init(); 
    // // set url 
    // curl_setopt($ch, CURLOPT_URL, "http://core.nizzam.net/public/tadarus/128518319?nik=890315120112");
    // // return the transfer as a string 
    // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
    // // $text contains the output string 
    // $hasil = curl_exec($ch); 
    // // tutup curl 
    // curl_close($ch);  

    // $data = [];
    // $data['chat_id'] = $chat_id;
    // $data['reply_to_message_id'] = $message_id;
    // $data['parse_mode'] = 'markdown';
    // $data['text'] = 'You have *' . $points . '* _points_.';




    // return Request::sendMessage($data);
    }
}
