<?php

namespace Longman\TelegramBot\Commands\AdminCommands;

use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Entities\InlineKeyboard;
use Longman\TelegramBot\Entities\InlineKeyboardButton;
use Longman\TelegramBot\Request;

class CategoryCommand extends UserCommand
{
    protected $name = 'category';
    protected $description = 'Choose a category, inline.';
    protected $usage = '/category';
    protected $version = '1.0.0';

    /** @var array Inline button categories (can also be dynamically generated) */
    public static $categories = [
        'apple'  => 'Yay, an apple!',
        'orange' => 'Sweetness...',
        'cherry' => 'A cherry on top.',
    ];

    public function execute()
    {
        $keyboard_buttons = [];
        foreach (self::$categories as $key => $value) {
            $keyboard_buttons[] = new InlineKeyboardButton([
                'text'          => ucfirst($key),
                'callback_data' => 'category_' . $key,
            ]);
        }
        $data = [
            'chat_id'      => $this->getMessage()->getChat()->getId(),
            'text'         => 'Choose a category:',
            'reply_markup' => new InlineKeyboard($keyboard_buttons),
        ];

        return Request::sendMessage($data);
    }

    public static function getMyInlineKeyboard()
    {
        $keyboard_buttons = [];
        foreach (self::$categories as $key => $value) {
            $keyboard_buttons[] = new InlineKeyboardButton([
                'text'          => ucfirst($key),
                'callback_data' => 'category_' . $key,
            ]);
        }
        return new InlineKeyboard($keyboard_buttons);
    }

}