<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands\SystemCommands;

use Longman\TelegramBot\Commands\SystemCommand;
use Longman\TelegramBot\Conversation;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\DB;

/**
 * Generic message command
 *
 * Gets executed when any type of message is sent.
 */
class GenericmessageCommand extends SystemCommand
{
    /**
     * @var string
     */
    protected $name = 'genericmessage';

    /**
     * @var string
     */
    protected $description = 'Handle generic message';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * @var bool
     */
    protected $need_mysql = true;

    /**
     * Command execute method if MySQL is required but not available
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function executeNoDb()
    {
        // Do nothing
        return Request::emptyResponse();
    }

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {

        $message = $this->getMessage();
        $text    = DB::clearDoubleSpace($message->getText(true));
        $command = explode(" ", $text);

        # ---------------------------------------------------------------------- #
        # --------------------------- COMMAND ODOJ ----------------------------- #
        # ---------------------------------------------------------------------- #

        # command odoj list
        # membaca command dimana kata pertama harus odoj, kata ke-2 atau terakhir harus list
        $odoj_list_command = strtolower($command[0]) .' '. strtolower($command[count($command)-1]);

        # membaca command odoj list mingguan atau odoj list rekap
        $odoj_list_rekap_mingguan_command = strtolower($command[0]) .' '. strtolower($command[count($command)-2]) .' '. strtolower($command[count($command)-1]);

        # membaca command odoj list mingguan atau odoj list rekap by nomor group
        $odoj_list_rekap_mingguan_group_command = strtolower($command[0]) .' '. strtolower($command[count($command)-3]) .' '. strtolower($command[count($command)-2]);

        # command odoj lapor
        # membaca command dimana kata pertama harus odoj, kata ke-2 atau terakhir ketiga harus kata lapor
        $odoj_lapor_command1 = strtolower($command[0]). ' ' . strtolower($command[1]); 
        $odoj_lapor_command2 = strtolower($command[0]). ' ' . strtolower($command[2]); 

        # command odoj batal
        # membaca command dimana kata pertama harus odoj, kata ke-2 atau terakhir ketiga harus kata batal
        $odoj_batal_command1 = strtolower($command[0]). ' ' . strtolower($command[1]); 
        $odoj_batal_command2 = strtolower($command[0]). ' ' . strtolower($command[2]); 

        # command odoj help atau odoj help admin
        # membaca command dimana kata pertama harus odoj, kata ke-2 harus help 
        $odoj_help_command = strtolower($command[0]). ' ' . strtolower($command[1]); 

        # command odoj ganti 
        # membaca command dimana kata pertama harus odoj, kata ke-2 harus ganti
        $odoj_ganti_command = strtolower($command[0]). ' ' . strtolower($command[1]); 

        # command odoj list member yang belum di bagi group
        # membaca command dimana kata pertama harus odoj, kata ke-2 harus member
        $odoj_member_command = strtolower($command[0]). ' ' . strtolower($command[1]); 

        # command odoj list rekap all unit
        # membaca command dimana kata pertama harus odoj, kata ke-2 harus rekap
        $odoj_rekap_command = strtolower($command[0]). ' ' . strtolower($command[count($command)-1]); 
        # ========================= End Command Odoj ========================== #

        //If a conversation is busy, execute the conversation command after handling the message
        $conversation = new Conversation(
            $this->getMessage()->getFrom()->getId(),
            $this->getMessage()->getChat()->getId()
        );

        //Fetch conversation command if it exists and execute it
        if ($conversation->exists() && ($command = $conversation->getCommand())) {
            return $this->telegram->executeCommand($command);
        }

        if ($odoj_lapor_command1 == 'odoj lapor' OR $odoj_lapor_command2 == 'odoj lapor') {
            return $this->telegram->executeCommand('odojlapor');
        }elseif ($odoj_list_rekap_mingguan_command == 'odoj list rekap' OR $odoj_list_rekap_mingguan_command == 'odoj list mingguan' OR $odoj_list_rekap_mingguan_group_command == 'odoj list rekap' OR $odoj_list_rekap_mingguan_group_command == 'odoj list mingguan') {
            return $this->telegram->executeCommand('odojlistrekapmingguan');
        }elseif ($odoj_list_command == 'odoj list') {
            return $this->telegram->executeCommand('odojlist');
        }elseif ($odoj_batal_command1 == 'odoj batal' OR $odoj_batal_command2 == 'odoj batal') {
            return $this->telegram->executeCommand('odojbatal');
        }elseif ($odoj_help_command == 'odoj help') {
            return $this->telegram->executeCommand('odojhelp');
        }elseif ($odoj_ganti_command == 'odoj ganti') {
            return $this->telegram->executeCommand('odojganti');
        }elseif ($odoj_member_command == 'odoj member') {
            return $this->telegram->executeCommand('odojmember');
        }elseif ($odoj_rekap_command == 'odoj rekap') {
            return $this->telegram->executeCommand('odojrekap');
        }
        

        return Request::emptyResponse();
    }
}
