<?php
$this->load->view("template/timePicker");
?>

<div class="box">
    <div class="box-header with-border">
        <h4>Shift Kerja</h4>
        <div class="box-tools pull-right">
            <button class="btn btn-box-tool" type="button" data-widget="collapse"><i class="fa fa-minus"></i></button>
        </div>
    </div>
    <div class="box-body">
        <form action="" method="POST" id="myform" class="form-horizontal" role="form">
            <div class="form-group">
                <label for="" class="col-sm-3">Divisi</label>
                <div class="col-sm-5">
                    <select name="id_sekolah" id="id_sekolah" class="form-control select2" required>
                        <option value="">-- Pilih Divisi --</option>
                        <?php foreach ($divisi as $dv) { ?>
                            <option value="<?= $dv->id_sekolah ?>"><?= $dv->nama ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <!-- end of fomr-group -->
            <div class="form-group">
                <label for="" class="col-sm-3">Nama Shift</label>
                <div class="col-sm-5">
                    <input type="text" name="nama_shift_kerja" id="nama_shift_kerja" class="form-control" required>
                </div>
            </div>
            <!-- end of form-group -->

            <div class="form-group">
                <label for="" class="col-sm-3">Jam Masuk Kerja</label>
                <div class="col-sm-5">
                    <div class="bootstrap-timepicker">
                        <input type="text" name="jam_kerja_in" id="jam_kerja_in" class="form-control timepicker">
                    </div>
                </div>
            </div>
            <!-- end of form-group -->

            <div class="form-group">
                <label for="" class="col-sm-3">Jam Keluar Kerja</label>
                <div class="col-sm-5">
                    <div class="bootstrap-timepicker">
                        <input type="text" name="jam_kerja_out" id="jam_kerja_out" class="form-control timepicker">
                    </div>
                </div>
            </div>
            <!-- end of form-group -->

            <div class="form-group">
                <label for="" class="col-sm-3">Waktu Finger Masuk Minimal</label>
                <div class="col-sm-5">
                    <div class="bootstrap-timepicker">
                        <input type="text" name="scan_in_min" id="scan_in_min" class="form-control timepicker">
                    </div>
                </div>
            </div>
            <!-- end of form-group -->

            <div class="form-group">
                <label for="" class="col-sm-3">Waktu Finger Masuk Maximal</label>
                <div class="col-sm-5">
                    <div class="bootstrap-timepicker">
                        <input type="text" name="scan_in_max" id="scan_in_max" class="form-control timepicker">
                    </div>
                </div>
            </div>
            <!-- end of form-group -->

            <div class="form-group">
                <label for="" class="col-sm-3">Waktu Finger Keluar Minimal</label>
                <div class="col-sm-5">
                    <div class="bootstrap-timepicker">
                        <input type="text" name="scan_out_min" id="scan_out_min" class="form-control timepicker">
                    </div>
                </div>
            </div>
            <!-- end of form-group -->

            <div class="form-group">
                <label for="" class="col-sm-3">Waktu Finger Keluar Maximal</label>
                <div class="col-sm-5">
                    <div class="bootstrap-timepicker">
                        <input type="text" name="scan_out_max" id="scan_out_max" class="form-control timepicker">
                    </div>
                </div>
            </div>
            <!-- end of form-group -->

            <div class="form-group">
                <label for="" class="col-sm-3">Durasi Jam Kerja</label>
                <div class="col-sm-5">
                    <input type="number" name="durasi_kerja" id="durasi_kerja" class="form-control">
                </div>
            </div>
            <!-- end of form-group -->

            <div class="form-group">
                <label for="" class="col-sm-3"></label>
                <div class="col-sm-5">
                    <button class="btn btn-primary pull-right btn-block" onclick="simpan()" type="button">Simpan</button>
                </div>
            </div>
            <!-- end of form-group -->
        </form>


    </div>
</div>

<script>
    var OVERLAY = "<div class='overlay'>" +
        "<i class='fa fa-refresh fa-spin'></i>" +
        "</div>";
    var ALERT_SUCCESS = "<div class='alert alert-success'>" +
        "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>" +
        "<strong>Berhasil!</strong> Data berhasil disimpan ..." +
        "</div>";
    var ALERT_GAGAL = "<div class='alert alert-danger'>" +
        "<button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>" +
        "<strong>Gagal!</strong> Data gagal disimpan ..." +
        "</div>";

    //Select2
    $(".select2").select2();
    //Timepicker
    $('.timepicker').timepicker({
        showInputs: false,
        defaultTime: '00:00',
        showMeridian: false,
    });

    function simpan() {
        var form = document.getElementById("myform");
        var form2 = $("#myform");
        var content = $(".content");
        var data = form2.serialize();
        
        $.ajax({
            url: "<?= base_url("spo/simpan_shift_kerja") ?>",
            data: data,
            type: "post",
            beforeSend: function() {
                $(".box").append(OVERLAY);
            },
            success: function(e) {
                $(".overlay").remove();
              
                if (e == "0") {
                    content.prepend(ALERT_GAGAL);
                    $('.alert').delay(3000).slideUp("slow");
                } else {
                    content.prepend(ALERT_SUCCESS);
                    $('.alert').delay(3000).slideUp("slow");
                }
            }
        });

    }

    function validasi() {
        var form2 = $("#myform");
        form2.validate({

            rules: {
                nama_shift_kerja: {
                    required: true
                }
            },
            messages: {
                nama_shift_kerja: "Just check the box<h5 class='text-danger'>You aren't going to read the EULA</h5>"
            },
            tooltip_options: {
                
                nama_shift_kerja: {
                    placement: 'right',
                    html: true
                }
            },

        });
    }
</script>