<?php 
    if ($this->session->flashdata('sukses')) { ?>
	    <div class="alert alert-success alert-dismissible">
	        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
	        <h4><i class="icon fa fa-check"></i> Tersimpan</h4>
	        <?php echo $this->session->flashdata('sukses');?>
	    </div>
	    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
	    <div class="alert alert-danger alert-dismissible">
	        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
	        <h4><i class="icon fa fa-times"></i> Data gagal disimpan</h4>
	        <?php echo $this->session->flashdata('gagal');?>
	    </div>
	    <?php
    }
?>


<div class="col-md-20">
  	<div class="box box-info"> 
        <div class="box-header with-border">
      		<h3 class="box-title">Input Predikat Keterampilan</h3>
        </div>
    	<form action="<?php echo base_url('raport/predikat_keterampilan'); ?>" method="post" class="form-horizontal">
			<div class="box-body">
				<div class="form-group">
			        <label class="col-sm-1 col-md-2">Batas Nilai</label> 
			        <div class="col-sm-1 col-md-2">
			            <input type="text" name="nilai_min" class="form-control" placeholder="Batas Minimal" required="true"> s.d
			            <input type="text" name="nilai_max" class="form-control" placeholder="Batas Maksimal" required="true">
			        </div>
			    </div>
			    <div class="form-group">
			        <label class="col-sm-1 col-md-2">Predikat</label> 
			        <div class="col-sm-1 col-md-3">
			            <input type="text" name="predikat" class="form-control" required="true">
			        </div>
			    </div>
			    <div class="form-group">
			        <label class="col-sm-1 col-md-2">Deskripsi</label> 
			        <div class="col-sm-1 col-md-4">
			            <textarea name="deskripsi" required="true" rows="5" cols="37"></textarea>
			        </div>
			    </div>
			    <div class="form-group">
			        <label class="col-sm-1 col-md-2">Kurikulum</label> 
			        <div class="col-sm-1 col-md-3">
			            <select name="kurikulum" required="true" class="form-control select2">
			            	<option value="">Pilih</option>
			            	<?php 
			            	foreach ($kurikulum as $k){
			            		echo "<option value='$k->id_kurikulum'>$k->nama_kurikulum</option>";
			            	}
			            	?>
			            </select>
			        </div>
			    </div>
			</div>
            <div class="box-footer">
            	<div class="form-group col-sm-1 col-md-4">
	                <button type="submit" class="btn btn-success">Simpan</button>
	                <button type="reset" class="btn btn-danger">Reset</button>
	            </div>
            </div>
        </form>
    </div>
</div>

<div class="col-md-20">
  	<div class="box box-info"> 
		<div class="box-body">
			<table class="table table-borderred table-hover table-responsive" rules='all' id="datatablefull">
				<thead>
					<tr>
						<th>No</th>
						<th>Nilai</th>
						<th>Predikat</th>
						<th>Deskripsi</th>
						<th>Kurikulum</th>
					</tr>
				</thead>
				<tbody>
				<?php 
					foreach ($r_predikat as $p){
						$no++;
						echo "<tr>
							<td>$no</td>
							<td>$p->nilai_min s.d $p->nilai_max</td>
							<td>$p->predikat</td>
							<td>$p->deskripsi</td>
							<td>".all("sekolah_kurikulum", "id_kurikulum", $p->kurikulum, "nama_kurikulum")."</td>
						</tr>";
					}
				?>
				</tbody>
			</table>
		</div>
	</div>
</div>