<?php 
    if ($this->session->flashdata('sukses')){ ?>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h4><i class="icon fa fa-check"></i> Tersimpan</h4>
            <?php echo $this->session->flashdata('sukses');?>
        </div>
        <?php
    }elseif ($this->session->flashdata('gagal')){ ?>
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h4><i class="icon fa fa-times"></i> Data gagal disimpan</h4>
            <?php echo $this->session->flashdata('gagal');?>
        </div>
        <?php
    }
?>


<div class="box box-info table-responsive">
	<div class="box-header with-border"><h3 class="box-title">PENGAJUAN KASBON KARYAWAN</h3></div>
	<form action="<?php echo base_url('pinjaman_kary/ajuan_kasbon'); ?>" method="post" class="form-horizontal">
		<div class="box-body">
			<div class="form-group">
				<label class="col-sm-1 col-md-2">Nominal</label>
				<div class="col-sm-10 col-md-3">
					<input class='form-control col-md-2' type='text' name='nominal' onkeypress='return isNumberKey(event)' onkeydown='return numbersonly(this, event);' onkeyup='javascript:tandaPemisahTitik(this);' required="true">
				</div>
			</div>
			<div class="form-group">
				<label class="col-sm-1 col-md-2">Keterangan</label>
				<div class="col-sm-10 col-md-3">
					<textarea class="form-control" rows="4" cols="20" name="ket" required="true"></textarea>
				</div>
			</div>
		</div>
		<div class="box-footer">
		    <div class="form-group col-sm-1 col-md-10">
			    <button type="submit" class="btn btn-success">Simpan</button>
			    <button type="reset" class="btn btn-danger">Reset</button>
			</div>
		</div>
	</form>



	<div class="box-body table-responsive">
		<table class="table table-borderred table-hover" rules='all' id="datatablefull">
			<thead>
				<tr>
					<th>No</th>
					<th>Tahun Akademik</th>
					<th>Tanggal</th>
					<th>NRP</th>
					<th>Nama</th>
					<th>Divisi</th>
					<th>Nominal Ajuan</th>
					<th>Keterangan</th>
					<th>Status</th>
					<th>Nominal ACC</th>
					<th>Alasan</th>
				</tr>
			</thead>
			<tbody>
			<?php 
				foreach ($ajuan_pinj as $ap) {
					$no++;
					echo "<tr>
						<td>$no</td>
						<td>".all("tahun_akademik", "id_tahun", $ap->id_tahun, "periode")."</td>
						<td>".tgl_indo($ap->tanggal)."</td>
						<td>$ap->nrp_ajuan</td>
						<td>".all("pegawai", "nrp", $ap->nrp_ajuan, "nama")."</td>
						<td>".all("sekolah", "id_sekolah", $ap->id_sekolah, "nama")."</td>
						<td>".number_format($ap->jumlah_ajuan)."</td>
						<td>$ap->ket</td>
						<td>$ap->approve3</td>
						<td>".number_format($ap->jumlah_acc)."</td>
						<td>".all("approval_history", "id_ap", $ap->id_ajuan_piutangkary, "keterangan")."</td>
					</tr>";
				}
			?>
			</tbody>
		</table>
	</div>
</div>

