<?php 
    if ($this->session->flashdata('sukses')) { ?>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h4><i class="icon fa fa-check"></i> Tersimpan</h4>
            <?php echo $this->session->flashdata('sukses');?>
        </div>
        <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h4><i class="icon fa fa-times"></i> Data gagal disimpan</h4>
            <?php echo $this->session->flashdata('gagal');?>
        </div>
        <?php
    }
?>


<div class="box box-info table-responsive">
	<div class="box-header with-border"><h3 class="box-title">APPROVAL KASBON KARYAWAN</h3></div>
	<div class="box-body">
		<table class="table table-borderred table-hover" rules='all' id="datatablefull">
			<thead>
				<tr>
					<th>No</th>
					<th>Tahun Akademik</th>
					<th>Tanggal</th>
					<th>NRP</th>
					<th>Nama</th>
					<th>Divisi</th>
					<th>Nominal Ajuan</th>
					<th>Keterangan</th>
					<th>Status</th>
				</tr>
			</thead>
			<tbody>
			<?php 
				foreach ($ajuan_pinj as $ap) {
					$no++;
					echo "<tr>
						<td>$no</td>
						<td>".all("tahun_akademik", "id_tahun", $ap->id_tahun, "periode")."</td>
						<td>".tgl_indo($ap->tanggal)."</td>
						<td>$ap->nrp_ajuan</td>
						<td>".all("pegawai", "nrp", $ap->nrp_ajuan, "nama")."</td>
						<td>".all("sekolah", "id_sekolah", $ap->id_sekolah, "nama")."</td>
						<td>".number_format($ap->jumlah_ajuan)."</td>
						<td>$ap->ket</td>"; 
						?>
						<td>
						<form action="<?php echo base_url('pinjaman_kary/approval_ajuan_kasbon'); ?>" method="post" class="form-horizontal" name='a'>
							<button type="button" class="btn btn-default" data-toggle="modal" data-target="#modal-default"><i class='fa fa-check'></i></button>
							<div class="modal fade" id="modal-default">
								<div class="modal-dialog">
							        <div class="modal-content">
										<input type="hidden" name="id_ajuan_kasbon" value="<?php echo $ap->id_ajuan_kasbon; ?>">
										<input type="hidden" name="ket" value="A">
										<div class="modal-header">
										    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
										        <span aria-hidden="true">&times;</span>
										    </button>
										    <h4 class="modal-title">Approval Pengajuan Kasbon</h4>
										</div>
										<div class="modal-body">
											<div class="form-group">
												<label class="col-sm-1 col-md-5" class="form-control">Karyawan</label>
												<div class="col-sm-10 col-md-3">
													<input type="text" name="nama" class="form-control" value="<?php echo all("pegawai", "nrp", $ap->nrp_ajuan, "nama"); ?>" readonly>
												</div>
											</div><br>
											<div class="form-group">
												<label class="col-sm-1 col-md-3"  class="form-control">Alasan</label>
												<div class="col-sm-10 col-md-3">
													<textarea name="alasan" cols="50" rows='5' required="true"></textarea>
												</div>
											</div><br>
											<div class="form-group">
												<label class="col-sm-1 col-md-4" class="form-control">Nominal ACC</label>
												<div class="col-sm-10 col-md-3">
													<input type="text" name="nominal" class="form-control" value="<?php echo $ap->jumlah_ajuan; ?>" onkeypress='return isNumberKey(event)'>
												</div>
											</div><br>
											<div class="form-group">
												<label class="col-sm-1 col-md-4" class="form-control">Sistem</label>
												<div class="col-sm-10 col-md-3">
													<select name='akun1' required="true" class="form-control">
							                            <option value="">--Pilih--</option>
							                            <?php 
							                            foreach ($akun as $akun1) {
							                                echo "<option value='$akun1->id_akun'>$akun1->id_akun - $akun1->nama_akun</option>";
							                            }
							                            ?>
							                        </select> 
												</div>
											</div>
										</div>
										<div class="modal-footer">
											<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
											<button type="submit" class="btn btn-primary">Save</button>
										</div>
									</div>
								</div>
							 </div> 
						</form>

						<form action="<?php echo base_url('pinjaman_kary/approval_ajuan_kasbon'); ?>" method="post" class="form-horizontal" name='a'>
							<button type="button" class="btn btn-default" data-toggle="modal" data-target="#modal-reject"><i class='fa fa-close'></i></button>
							<div class="modal fade" id="modal-reject">
								<div class="modal-dialog">
							        <div class="modal-content">
										<input type="hidden" name="id_ajuan_kasbon" value="<?php echo $ap->id_ajuan_kasbon; ?>">
										<input type="hidden" name="ket" value="R">
										<div class="modal-header">
										    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
										        <span aria-hidden="true">&times;</span>
										    </button>
										    <h4 class="modal-title">Approval Pengajuan Kasbon</h4>
										</div>
										<div class="modal-body">
											<div class="form-group">
												<label class="col-sm-1 col-md-3"  class="form-control">Alasan</label>
												<div class="col-sm-10 col-md-3">
													<textarea name="alasan" cols="50" rows='5' required="true"></textarea>
												</div>
											</div>
										</div>
										<div class="modal-footer">
											<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
											<button type="submit" class="btn btn-primary">Save</button>
										</div>
									</div>
								</div>
							 </div>
						</form>
						</td>
						<?php
					echo "</tr>";
				}
			?>
			</tbody>
		</table>
	</div>
</div>