<?php 
    if ($this->session->flashdata('sukses')) { ?>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h6><i class="icon fa fa-check"></i><b>BERHASIL</b></h6>
            <?php echo $this->session->flashdata('sukses');?>
        </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
        <div class="alert alert-info alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h6><i class="icon fa fa-check"></i>GAGAL</h6>
            <?php echo $this->session->flashdata('gagal');?>
        </div>
    <?php
    }
    ?>

<section class="content">
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title"><b>Input Kutipan</b></h3>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse"><i class="fa fa-minus"></i></button>
            </div>
        </div>
        <div class="box-body">
            <form action="<?php echo base_url('personal/kutipan'); ?>" method="post" class="form-horizontal">
            	<div class="form-group">
					<label class="col-sm-1 control-label col-md-2">Tanggal</label>
					<div class="col-sm-10 col-md-3 input-group date ">
					    <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
					    <input type="text" class="form-control" name='tgl' id="datepicker"> 
					</div>
				</div>
				<div class="box-body">
					<div class="form-group">
						<label class="col-sm-1 control-label col-md-2">Isi Kutipan</label>
						<div class="col-sm-2 col-md-5"><textarea name="isi_kutipan" required="true" class="form-control" rows="10" required="true"></textarea></div>
					</div>
					<div class="form-group">
						<label class="col-sm-1 control-label col-md-2">Sumber</label>
						<div class="col-sm-2 col-md-3"><input type="text" class="form-control" name='sumber' required></div>
					</div>
					<div class="box-footer">
						<button type="reset" class="btn btn-default">Reset</button>
						<button type="submit" class="btn btn-info pull-left">Simpan</button>
					</div>
				</div>
			</form>
        </div>
    </div>

	<div class="box">
        <div class="box-header with-border">
            <h3 class="box-title"><b>Kutipan</b></h3>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse"><i class="fa fa-minus"></i></button>
            </div>
        </div>
        <div class="box-body">
            <div class="box">
				<div class="box-body">
					<table id="example1" class="table table-bordered table-striped" id="datatablefull">
						<thead>
						<tr>
							<th>No</th>
							<th>Tanggal</th>
							<th>Isi Kutipan</th>
							<th>Sumber</th>
							<th>User</th>
							<th></th>
						</tr>
						</thead>
						<tbody>
							<?php 
							foreach ($kutipan as $kutip){
								$no++;
								echo "<tr>
										<td>$no</td>
										<td>".tgl_indo($kutip->tgl)."</td>
										<td>$kutip->isi_kutipan</td>
										<td>$kutip->sumber</td>
										<td>".all("pegawai", "nrp", $kutip->nrp, "nama")."</td>
										<td><a href='".base_url('personal/delete_kutipan')."/$kutip->id_kutipan' onclick='javascript: return confirm('Apakah Anda Yakin Akan Menghapus Data Ini?')'><i class='fa fa-close'></i></a></td>
								</tr>";
							}
							?>
						</tbody>
				  </table>
				</div>
			</div>
		</div>
    </div>
</section>