<?php 
    if ($this->session->flashdata('sukses')) { ?>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h6><i class="icon fa fa-check"></i><b>BERHASIL</b></h6>
            <?php echo $this->session->flashdata('sukses');?>
        </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
        <div class="alert alert-info alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h6><i class="icon fa fa-check"></i>GAGAL</h6>
            <?php echo $this->session->flashdata('gagal');?>
        </div>
    <?php
    }
    ?>


<!-- Main content -->
<section class="content">
    <!-- Default box -->
    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title"><b>Input Kelompok ODOJ</b></h3>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse"><i class="fa fa-minus"></i></button>
            </div>
        </div>
        <div class="box-body">
            <form action="<?php echo base_url('personal/simpan_kelompok_odoj'); ?>" method="post" class="form-horizontal">
				<div class="box-body">
					<div class="form-group">
						<label class="col-sm-1 control-label col-md-2">Nama Kelompok</label>
						<div class="col-sm-2 col-md-3"><input type="text" class="form-control" name='nama' maxlength='50' required></div>
					</div>
					<div class="form-group">
						<label class="col-sm-1 control-label col-md-2">Penanggung Jawab</label>
						<div class="col-sm-2 col-md-3">
							<select class="form-control select2" name='pj' required>
								<option value=''>---Pilih---</option>
								<?php
								foreach($pegawai as $peg){ 
									echo "<option value='".$peg->nrp."'>$peg->nrp - $peg->nama</option>";
								}
								?>
							</select>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-1 control-label col-md-2">Anggota <?php echo $i; ?></label>
						<div class="col-sm-2 col-md-3">
							<select class="form-control select2" name='nrp[]' multiple="true" required="true">
								<option value=''>---Pilih---</option>
								<?php
								foreach($pegawai as $peg){ 
									echo "<option value='".$peg->nrp."'>$peg->nrp - $peg->nama</option>";
								}
								?>
							</select>
						</div>
					</div>
					<div class="box-footer">
						<button type="reset" class="btn btn-default">Reset</button>
						<button type="submit" class="btn btn-info pull-left">Simpan</button>
					</div>
				</div>
			</form>
        </div>
    </div><!-- /.box -->
	<!--- Menampilkan data-->
	<div class="box">
        <div class="box-header with-border">
            <h3 class="box-title"><b>Data Kelompok ODOJ</b></h3>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse"><i class="fa fa-minus"></i></button>
            </div>
        </div>
        <div class="box-body">
            <div class="box">
				<!-- /.box-header -->
				<div class="box-body">
					<table class="table table-bordered table-striped" id='datatablefull'>
						<thead>
						<tr>
							<th>No</th>
							<th>Nama Kelompok</th>
							<th>Penanggung Jawab</th>
							<th>Detail</th>
						</tr>
						</thead>
						<tbody>
							<?php
							foreach ($kelompok as $klmpk) {
								$no++;
								echo "<tr>
										<td>$no</td>
										<td>$klmpk->nama_kel_odoj</td>
										<td>$klmpk->nama</td>
										<td><a href='".base_url('personal/detail_kelompok_odoj')."/$klmpk->id_kel_odoj' title='Detail'><i class='fa fa-search-plus'></i></a>
											<a href='".base_url('personal/edit_kelompok_odoj')."/$klmpk->id_kel_odoj' title='Edit'><i class='fa fa-pencil-square-o'></i></a>
											<a href='".base_url('personal/hapus_kelompok_odoj')."/$klmpk->id_kel_odoj' title='Hapus'><i class='fa fa-eraser'></i></a>
										</td>
									</tr>";
							}
							?>
						</tbody>
				  </table>
				</div>
			</div>
		</div>
    </div><!-- /.box -->
</section><!-- /.content -->