    <?php 
    if ($this->session->flashdata('sukses')) { ?>
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Berhasil</h4>
        <?php echo $this->session->flashdata('sukses');?>
    </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-times"></i> Gagal</h4>
        <?php echo $this->session->flashdata('gagal');?>
    </div>
    <?php 
    } ?>

    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">Status Item</h3>
        </div>
        <!-- modal tambah-->
        <div class="box-body">
            <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modal-tambah">
                <i class="fa fa-fw fa-plus"></i> Tambah Status Item
            </button>
        </div>
        <div class="modal modal-default fade" id="modal-tambah">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Tambah Status Item</h4>
              </div>
              <form action="<?php echo base_url('perpus/tambah_status_item'); ?>" method="post">
              <div class="modal-body">
                    <div class="form-group">
                        <label>Kode Status Item</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-check-square-o"></i>
                            </div>
                            <input type="text" name="id_status_item" class="form-control" required/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Nama Status Item</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-check-square-o"></i>
                            </div>
                            <input type="text" name="nama_status_item" class="form-control" required/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Apakah Dipinjamkan</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-check-square-o"></i>
                            </div>
                            <select class="form-control" name="dipinjamkan" required>
                                <option value="">Pilih</option>
                                <option value="1">Ya</option>
                                <option value="0">Tidak</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Apakah Dihitung Stok</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-check-square-o"></i>
                            </div>
                            <select class="form-control" name="dihitung_stok" required>
                                <option value="">Pilih</option>
                                <option value="1">Ya</option>
                                <option value="0">Tidak</option>
                            </select>
                        </div>
                    </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-success">Simpan</button>
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->
        <div class="box-body table-responsive">
            <table class="table table-bordered"> 
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Kode</th>
                        <th>Status Item</th>
                        <th>Dipinjamkan</th>
                        <th>Dihitung Stok</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $no = 1;    
                    foreach ($status as $key) {?>
                        <tr>
                            <td><?php echo $no; ?>.</td>
                            <td><?php echo $key->id_status_item; ?></td>
                            <td><?php echo $key->nama_status_item; ?></td>
                            <td><?php echo status($key->dipinjamkan); ?></td>
                            <td><?php echo status($key->dihitung_stok); ?></td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-edit-'.$key->id_status_item; ?>"><i class="fa fa-edit"></i></button>
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-hapus-'.$key->id_status_item; ?>"><i class="fa fa-trash-o"></i></button>
                                </div>
                            </td>
                        </tr>
                        <?php
                        $no++;
                        ?>
                        <!-- modal edit-->
                        <div class="modal modal-default fade" id="<?php echo 'modal-edit-'.$key->id_status_item; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Edit Status Item</h4>
                              </div>
                              <form action="<?php echo base_url('perpus/edit_status_item'); ?>" method="post">
                              <div class="modal-body">
                                <div class="form-group">
                                    <label>Kode Status Item</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-check-square-o"></i>
                                        </div>
                                        <input type="text" name="id_status_item" value="<?php echo $key->id_status_item; ?>" readonly  class="form-control" required/>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Nama Status Item</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-check-square-o"></i>
                                        </div>
                                        <input type="text" name="nama_status_item" value="<?php echo $key->nama_status_item; ?>" class="form-control" required/>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Apakah Dipinjamkan</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-check-square-o"></i>
                                        </div>
                                        <select class="form-control" name="dipinjamkan" required>
                                            <option value="">Pilih</option>
                                            <option value="1" <?php if($key->dipinjamkan=='1'){echo "selected";} ?>>Ya</option>
                                            <option value="0" <?php if($key->dipinjamkan=='0'){echo "selected";} ?>>Tidak</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Apakah Dihitung Stok</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-check-square-o"></i>
                                        </div>
                                        <select class="form-control" name="dihitung_stok" required>
                                            <option value="">Pilih</option>
                                            <option value="1" <?php if($key->dihitung_stok=='1'){echo "selected";} ?>>Ya</option>
                                            <option value="0" <?php if($key->dihitung_stok=='0'){echo "selected";} ?>>Tidak</option>
                                        </select>
                                    </div>
                                </div>
                              </div>
                              <div class="modal-footer">
                                <input type="hidden" name="id_status_item" value="<?php echo $key->id_status_item; ?>">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-success">Simpan</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal edit-->
                        <!-- modal hapus-->
                        <div class="modal modal-danger fade" id="<?php echo 'modal-hapus-'.$key->id_status_item; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Hapus Status Item</h4>
                              </div>
                              <form action="<?php echo base_url('perpus/hapus_status_item'); ?>" method="post">
                              <div class="modal-body">
                                <p>Data Status Item dengan status<b><?php echo $key->nama_status_item; ?></b> akan segera dihapus.<br>
                                Apakah yakin mau hapus data ini..???</p>
                                <input type="hidden" name="id_status_item" value="<?php echo $key->id_status_item; ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-outline" data-dismiss="modal">Tidak Jadi</button>
                                <button type="submit" class="btn btn-outline">Ya, Hapus</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal hapus-->
                    <?php    
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>