    <?php 
    if ($this->session->flashdata('sukses')) { ?>
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Berhasil</h4>
        <?php echo $this->session->flashdata('sukses');?>
    </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-times"></i> Gagal</h4>
        <?php echo $this->session->flashdata('gagal');?>
    </div>
    <?php 
    } ?>

    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">Instansi</h3>
        </div>
        <!-- modal tambah-->
        <div class="box-body">
            <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modal-tambah">
                <i class="fa fa-fw fa-plus"></i> Tambah Instansi
            </button>
        </div>
        <div class="modal modal-default fade" id="modal-tambah">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Tambah Instansi</h4>
              </div>
              <form action="<?php echo base_url('perpus/tambah_instansi'); ?>" method="post">
              <div class="modal-body">
                    <div class="form-group">
                        <label>Instansi</label>
                        <div class="input-group">
                          <div class="input-group-addon">
                            <i class="fa fa-institution"></i>
                          </div>
                          <select class="form-control" name="sekolah" required>
                              <option value="">Pilih</option>
                                <?php foreach ($sekolah as $key){ ?>
                                    <option value="<?php echo $key->id_sekolah.'.'.$key->nama; ?>"><?php echo $key->nama; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Jenis Anggota</label>
                        <div class="input-group">
                          <div class="input-group-addon">
                            <i class="fa fa-user"></i>
                          </div>
                          <select class="form-control" name="jenis_anggota" required>
                              <option value="">Pilih</option>
                                <?php foreach ($jenis_anggota as $key){ ?>
                                    <option value="<?php echo $key->id_jenis_anggota; ?>"><?php echo $key->nama; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-success">Simpan</button>
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->
        <div class="box-body table-responsive">
            <table class="table table-bordered" > 
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Nama Instansi</th>
                        <th>Jenis Anggota</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $no = 1;    
                    foreach ($instansi as $key) {?>
                        <tr>
                            <td><?php echo $no; ?>.</td>
                            <td><?php echo $key->nama; ?></td>
                            <td><?php echo $key->nama_jenis_anggota; ?></td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-edit-'.$key->id_instansi; ?>"><i class="fa fa-edit"></i></button>
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-hapus-'.$key->id_instansi; ?>"><i class="fa fa-trash-o"></i></button>
                                </div>
                            </td>
                        </tr>
                        <?php
                        $no++;
                        ?>
                        <!-- modal edit-->
                        <div class="modal modal-default fade" id="<?php echo 'modal-edit-'.$key->id_instansi; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Edit Instansi</h4>
                              </div>
                              <form action="<?php echo base_url('perpus/edit_instansi'); ?>" method="post">
                              <div class="modal-body">
                                <div class="form-group">
                                    <label>Instansi</label>
                                    <div class="input-group">
                                      <div class="input-group-addon">
                                        <i class="fa fa-institution"></i>
                                      </div>
                                      <select class="form-control" name="sekolah" required>
                                          <option value="">Pilih</option>
                                            <?php foreach ($sekolah as $sek){ ?>
                                                <option value="<?php echo $sek->id_sekolah.'*'.$sek->nama; ?>" <?php if ($key->id_sekolah==$sek->id_sekolah) { echo "selected";} ?>><?php echo $sek->nama; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Jenis Anggota</label>
                                    <div class="input-group">
                                      <div class="input-group-addon">
                                        <i class="fa fa-user"></i>
                                      </div>
                                      <select class="form-control" name="jenis_anggota" required>
                                          <option value="">Pilih</option>
                                            <?php foreach ($jenis_anggota as $jenis){ ?>
                                                <option value="<?php echo $jenis->id_jenis_anggota; ?>" <?php if ($key->id_jenis_anggota==$jenis->id_jenis_anggota) { echo "selected";} ?>><?php echo $jenis->nama; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <input type="hidden" name="id_instansi" value="<?php echo $key->id_instansi ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-success">Simpan</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal edit-->
                        <!-- modal hapus-->
                        <div class="modal modal-danger fade" id="<?php echo 'modal-hapus-'.$key->id_instansi; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Hapus Instansi</h4>
                              </div>
                              <form action="<?php echo base_url('perpus/hapus_instansi'); ?>" method="post">
                              <div class="modal-body">
                                <p>Data Instansi dengan nama <b><?php echo $key->nama; ?></b> akan segera dihapus.<br>
                                Apakah yakin mau hapus data ini..???</p>
                                <input type="hidden" name="id_instansi" value="<?php echo $key->id_instansi ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-outline" data-dismiss="modal">Tidak Jadi</button>
                                <button type="submit" class="btn btn-outline">Ya, Hapus</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal hapus-->
                    <?php    
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>