    <?php 
    if ($this->session->flashdata('sukses')) { ?>
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Berhasil</h4>
        <?php echo $this->session->flashdata('sukses');?>
    </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-times"></i> Gagal</h4>
        <?php echo $this->session->flashdata('gagal');?>
    </div>
    <?php 
    } ?>

    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">DDC</h3>
        </div>
        <!-- modal tambah-->
        <div class="box-body">
            <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modal-tambah">
                <i class="fa fa-fw fa-plus"></i> Tambah DDC
            </button>
        </div>
        <div class="modal modal-default fade" id="modal-tambah">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Tambah DC</h4>
              </div>
              <form action="<?php echo base_url('perpus/tambah_ddc'); ?>" method="post">
              <div class="modal-body">
                    <div class="form-group">
                        <label>Kode DDC</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-asterisk"></i>
                            </div>
                            <input type="text" name="kode_ddc" class="form-control" required placeholder="Kode DDC " required="true" />
                        </div>
                    </div>   
                    <div class="form-group">
                        <label>Subjek</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-tag"></i>
                            </div>
                            <input type="text" name="subjek" class="form-control" required placeholder="Subjek" required="true" />
                        </div>
                    </div>                
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-success">Simpan</button>
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->

        <div class="modal modal-default fade" id="modal-edit">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Edit DDC</h4>
              </div>
              <form action="<?php echo base_url('perpus/edit_ddc'); ?>" method="post">
              <div class="modal-body">  
                <div class="modal-data"></div>                
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-success">Simpan</button>
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->

        <div class="modal modal-danger fade" id="modal-hapus">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Hapus DDC</h4>
              </div>
              <form action="<?php echo base_url('perpus/hapus_ddc'); ?>" method="post">
              <div class="modal-body">  
                <div class="modal-data"></div>                
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-outline" data-dismiss="modal">Tidak Jadi</button>
                <button type="submit" class="btn btn-outline">Ya, Hapus</button>
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->

        <div class="box-body table-responsive">
          
          <table id="table" class="table table-bordered table-striped" >
              <thead>
                  <tr>
                      <th>No</th>
                      <th>Kode DDC</th>
                      <th>Nama</th>
                      <th>Aksi</th>
                  </tr>
              </thead>
              <tbody>
              </tbody>
          </table>
        </div>
  
    </div>
 


<script type="text/javascript">
 
var table;
 
$(document).ready(function() {
 
    //datatables
    table = $('#table').DataTable({ 
 
        "processing": true, //Feature control the processing indicator.
        "serverSide": true, //Feature control DataTables' server-side processing mode.
        "order": [], //Initial no order.
 
        // Load data for the table's content from an Ajax source
        "ajax": {
            "url": "<?php echo site_url($url_ajax)?>",
            "type": "POST"
        },
 
        //Set column definition initialisation properties.
        "columnDefs": [
        { 
            "targets": [ 0, 3 ], //first column / numbering column
            "orderable": false, //set not orderable
        },
        ],
 
    });
 
});

var bu = "<?php echo base_URL()?>perpus/";
$(function(){
    $(document).on('click','.edit-record',function(e){
        e.preventDefault();
        $("#modal-edit").modal('show');
        $.post( bu + 'f_edit_ddc',
            {id:$(this).attr('data-id')},
            function(html){
                $(".modal-data").html(html);
            }   
        );
    });
});

$(function(){
    $(document).on('click','.hapus-record',function(e){
        e.preventDefault();
        $("#modal-hapus").modal('show');
        $.post( bu + 'f_hapus_ddc',
            {id:$(this).attr('data-id')},
            function(html){
                $(".modal-data").html(html);
            }   
        );
    });
});

</script>

