    <?php 
    if ($this->session->flashdata('sukses')) { ?>
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Berhasil</h4>
        <?php echo $this->session->flashdata('sukses');?>
    </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-times"></i> Gagal</h4>
        <?php echo $this->session->flashdata('gagal');?>
    </div>
    <?php 
    } ?>

    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">Aturan Peminjaman Buku</h3>
        </div>
        <!-- modal tambah-->
        <div class="box-body">
            <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modal-tambah">
                <i class="fa fa-fw fa-plus"></i> Tambah Aturan
            </button>
        </div>
        <div class="modal modal-default fade" id="modal-tambah">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Tambah Aturan Peminjaman Buku</h4>
              </div>
              <form action="<?php echo base_url('perpus/tambah_aturan_peminjaman'); ?>" method="post">
              <div class="modal-body">
                    <div class="form-group">
                        <label>Kategori Buku</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-tag"></i>
                            </div>
                            <select class="form-control" name="kategori_buku" required>
                                <option value="">Pilih</option>
                                  <?php foreach ($kategori_buku as $key){ ?>
                                      <option value="<?php echo $key->id_kategori_buku; ?>"><?php echo $key->nama; ?></option>
                                  <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Jenis Anggota</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-user"></i>
                            </div>
                            <select name="jenis_anggota[]" class="form-control select2" multiple="multiple" data-placeholder="Pilih" style="width: 100%;" required>
                                <option value="">Pilih</option>
                                  <?php foreach ($jenis_anggota as $key){ ?>
                                      <option value="<?php echo $key->id_jenis_anggota; ?>"><?php echo $key->nama; ?></option>
                                  <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Maksimal Jumlah Buku</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-book"></i>
                            </div>
                            <input type="text" name="jumlah_maksimal" onkeydown="return numbersonly(this, event);" class="form-control" required placeholder="Jumlah Maksimal Peminjaman Buku " />
                        </div>
                    </div>
                    <div class="row">
                      <div class="col-sm-6">
                        <div class="form-group">
                            <label>Maksimal Lama Pinjam</label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                  <i class="fa fa-clock-o"></i>
                                </div>
                                <input type="text" name="lama_maksimal" onkeydown="return numbersonly(this, event);" class="form-control" required placeholder="Lama Maksimal Peminjaman" />
                            </div>
                        </div>                        
                      </div>
                      <div class="col-sm-6">
                        <div class="form-group">
                            <label>Satuan</label>
                                <select class="form-control" name="satuan_lama" required>
                                    <option value="">Pilih</option>
                                    <option value="Hari">Hari</option>
                                    <option value="Bulan">Bulan</option>
                                </select>
                        </div>                        
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-sm-6">
                        <div class="form-group">
                            <label>Sanksi Keterlambatan</label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                  <i class="fa fa-dollar"></i>
                                </div>
                                <input type="text" name="denda_keterlambatan" onkeydown="return numbersonly(this, event);" class="form-control" required placeholder="Rp ..." />
                            </div>
                        </div>                        
                      </div>
                      <div class="col-sm-6">
                        <div class="form-group">
                            <label>Setiap</label>
                                <select class="form-control" name="satuan_denda" required>
                                    <option value="">Pilih</option>
                                    <option value="Hari">Hari</option>
                                    <option value="Bulan">Bulan</option>
                                </select>
                        </div>                        
                      </div>
                    </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-success">Simpan</button>
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->
        <div class="box-body table-responsive">
            <table class="table table-bordered" > 
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Kategori Buku</th>
                        <th>Jenis Anggota</th>
                        <th>Maksimal Lama Pinjam</th>
                        <th>Maksimal Jumlah Buku</th>
                        <th>Sanksi Keterlambatan</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $no = 1;    
                    foreach ($aturan_peminjaman as $key) {?>
                        <tr>
                            <td><?php echo $no; ?>.</td>
                            <td><?php echo $key->nama_kategori_buku. ' (' .$key->label.')' ; ?></td>
                            <td><?php echo $key->nama_jenis_anggota; ?></td>
                            <td><?php echo $key->lama_maksimal. ' '.$key->satuan_lama; ?></td>
                            <td><?php echo $key->jumlah_maksimal; ?></td>
                            <td><?php echo 'Rp. '. number_format($key->denda_keterlambatan). '/'.$key->satuan_denda; ?></td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-edit-'.$key->id_aturan_peminjaman; ?>"><i class="fa fa-edit"></i></button>
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-hapus-'.$key->id_aturan_peminjaman; ?>"><i class="fa fa-trash-o"></i></button>
                                </div>
                            </td>
                        </tr>
                        <?php
                        $no++;
                        ?>
                        <!-- modal edit-->
                        <div class="modal modal-default fade" id="<?php echo 'modal-edit-'.$key->id_aturan_peminjaman; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Edit Aturan Peminjaman Buku</h4>
                              </div>
                              <form action="<?php echo base_url('perpus/edit_aturan_peminjaman'); ?>" method="post">
                              <div class="modal-body">
                                <div class="form-group">
                                    <label>Kategori Buku</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-tag"></i>
                                        </div>
                                        <select class="form-control" name="kategori_buku" required>
                                            <option value="">Pilih</option>
                                              <?php foreach ($kategori_buku as $kb){ ?>
                                                  <option value="<?php echo $kb->id_kategori_buku; ?>" <?php if ($key->id_kategori_buku==$kb->id_kategori_buku) { echo "selected";} ?>><?php echo $kb->nama; ?></option>
                                              <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Jenis Anggota</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-user"></i>
                                        </div>
                                        <select name="jenis_anggota" class="form-control select" data-placeholder="Pilih" style="width: 100%;" required>
                                            <option value="">Pilih</option>
                                              <?php foreach ($jenis_anggota as $ja){ ?>
                                                  <option value="<?php echo $ja->id_jenis_anggota; ?>" <?php if ($key->id_jenis_anggota==$ja->id_jenis_anggota) { echo "selected";} ?>><?php echo $ja->nama; ?></option>
                                              <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Maksimal Jumlah Buku</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-book"></i>
                                        </div>
                                        <input type="text" name="jumlah_maksimal" value="<?php echo $key->jumlah_maksimal ?>" onkeydown="return numbersonly(this, event);" class="form-control" required placeholder="Jumlah Maksimal Peminjaman Buku " />
                                    </div>
                                </div>
                                <div class="row">
                                  <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Maksimal Pinjam</label>
                                        <div class="input-group">
                                            <div class="input-group-addon">
                                              <i class="fa fa-clock-o"></i>
                                            </div>
                                            <input type="text" name="lama_maksimal" value="<?php echo $key->lama_maksimal ?>" onkeydown="return numbersonly(this, event);" class="form-control"  required placeholder="Lama Maksimal Peminjaman" />
                                        </div>
                                    </div>                        
                                  </div>
                                  <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Satuan</label>
                                            <select class="form-control" name="satuan_lama" required>
                                                <option value="">Pilih</option>
                                                <option value="Hari" <?php if ($key->satuan_lama=='Hari') { echo "selected";} ?>>Hari</option>
                                                <option value="Bulan" <?php if ($key->satuan_lama=='Bulan') { echo "selected";} ?>>Bulan</option>
                                            </select>
                                    </div>                        
                                  </div>
                                </div>
                                <div class="row">
                                  <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Sanksi Keterlambatan</label>
                                        <div class="input-group">
                                            <div class="input-group-addon">
                                              <i class="fa fa-dollar"></i>
                                            </div>
                                            <input type="text" name="denda_keterlambatan" value="<?php echo $key->denda_keterlambatan ?>" onkeydown="return numbersonly(this, event);" class="form-control"  required placeholder="Rp ..." />
                                        </div>
                                    </div>                        
                                  </div>
                                  <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Setiap</label>
                                            <select class="form-control" name="satuan_denda" required>
                                                <option value="">Pilih</option>
                                                <option value="Hari" <?php if ($key->satuan_denda=='Hari') { echo "selected";} ?>>Hari</option>
                                                <option value="Bulan" <?php if ($key->satuan_denda=='Bulan') { echo "selected";} ?>>Bulan</option>
                                            </select>
                                    </div>                        
                                  </div>
                                </div>                                
                                <input type="hidden" name="id_aturan_peminjaman" value="<?php echo $key->id_aturan_peminjaman ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-success">Simpan</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal edit-->
                        <!-- modal hapus-->
                        <div class="modal modal-danger fade" id="<?php echo 'modal-hapus-'.$key->id_aturan_peminjaman; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Hapus Aturan Peminjaman Buku</h4>
                              </div>
                              <form action="<?php echo base_url('perpus/hapus_aturan_peminjaman'); ?>" method="post">
                              <div class="modal-body">
                                <p>Data Aturan Peminjaman dengan kategori <b><?php echo $key->nama_kategori_buku; ?></b> dan anggota <b><?php echo $key->nama_jenis_anggota; ?></b> akan segera dihapus.<br>
                                Apakah yakin mau hapus data ini..???</p>
                                <input type="hidden" name="id_aturan_peminjaman" value="<?php echo $key->id_aturan_peminjaman ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-outline" data-dismiss="modal">Tidak Jadi</button>
                                <button type="submit" class="btn btn-outline">Ya, Hapus</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal hapus-->
                    <?php    
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>