    <?php 
    if ($this->session->flashdata('sukses')) { ?>
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Berhasil</h4>
        <?php echo $this->session->flashdata('sukses');?>
    </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-times"></i> Gagal</h4>
        <?php echo $this->session->flashdata('gagal');?>
    </div>
    <?php 
    } ?>

    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">Aturan Kehilangan Buku</h3>
        </div>
        <!-- modal tambah-->
        <div class="box-body">
            <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modal-tambah">
                <i class="fa fa-fw fa-plus"></i> Tambah Aturan
            </button>
        </div>
        <div class="modal modal-default fade" id="modal-tambah">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Tambah Aturan Kehilangan Buku</h4>
              </div>
              <form action="<?php echo base_url('perpus/tambah_aturan_kehilangan'); ?>" method="post">
              <div class="modal-body">
                    <div class="form-group">
                        <label>Nama Sanksi</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-balance-scale"></i>
                            </div>
                            <input type="text" name="nama_aturan" class="form-control" required>
                        </div>
                    </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-success">Simpan</button>
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->
        <div class="box-body table-responsive">
            <table class="table table-bordered" > 
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Sanksi Menghilangkan Buku</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $no = 1;    
                    foreach ($aturan_kehilangan as $key) {?>
                        <tr>
                            <td><?php echo $no; ?>.</td>
                            <td><?php echo $key->nama_aturan; ?></td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-edit-'.$key->id_aturan_kehilangan; ?>"><i class="fa fa-edit"></i></button>
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-hapus-'.$key->id_aturan_kehilangan; ?>"><i class="fa fa-trash-o"></i></button>
                                </div>
                            </td>
                        </tr>
                        <?php
                        $no++;
                        ?>
                        <!-- modal edit-->
                        <div class="modal modal-default fade" id="<?php echo 'modal-edit-'.$key->id_aturan_kehilangan; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Edit Aturan Kehilangan Buku</h4>
                              </div>
                              <form action="<?php echo base_url('perpus/edit_aturan_kehilangan'); ?>" method="post">
                              <div class="modal-body">
                                <div class="form-group">
                                    <label>Nama Sanksi</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-balance-scale"></i>
                                        </div>
                                        <input type="text" name="nama_aturan" value="<?php echo $key->nama_aturan ?>" class="form-control" required>
                                    </div>
                                </div>                              
                                <input type="hidden" name="id_aturan_kehilangan" value="<?php echo $key->id_aturan_kehilangan ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-success">Simpan</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal edit-->
                        <!-- modal hapus-->
                        <div class="modal modal-danger fade" id="<?php echo 'modal-hapus-'.$key->id_aturan_kehilangan; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Hapus Aturan Kehilangan Buku</h4>
                              </div>
                              <form action="<?php echo base_url('perpus/hapus_aturan_kehilangan'); ?>" method="post">
                              <div class="modal-body">
                                <p>Data Aturan Kehilangan Buku dengan nama Sanksi <b><?php echo $key->nama_aturan; ?></b> akan segera dihapus.<br>
                                Apakah yakin mau hapus data ini..???</p>
                                <input type="hidden" name="id_aturan_kehilangan" value="<?php echo $key->id_aturan_kehilangan ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-outline" data-dismiss="modal">Tidak Jadi</button>
                                <button type="submit" class="btn btn-outline">Ya, Hapus</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal hapus-->
                    <?php    
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>