    <?php 
    if ($this->session->flashdata('sukses')) { ?>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h6><i class="icon fa fa-check"></i><b>BERHASIL</b></h6>
            <?php echo $this->session->flashdata('sukses');?>
        </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
        <div class="alert alert-info alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h6><i class="icon fa fa-check"></i>GAGAL</h6>
            <?php echo $this->session->flashdata('gagal');?>
        </div>
    <?php
    }
    ?>


	<div class="box box-danger">
	    <div class="box-header with-border"><h3 class="box-title">Input Indikator Kriteria Penilaian</h3></div>
		<div class="box-body">
			<form action="<?php echo base_url('dppp/simpan_indikator'); ?>" method="post" class="form-horizontal">
				<div class="form-group">
					<label class="col-sm-1 col-md-2">Kriteria</label>
					<div class="col-sm-10 col-md-3">
						<select name="kriteria" required="true" class="form-control">
							<option value="">Pilih</option>
							<?php 
							foreach ($kriteria as $k){
								echo "<option value='$k->id_kriteria'>$k->kriteria</option>";
							}
							?>
						</select>
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-1 col-md-2">Indikator</label>
					<div class="col-sm-10 col-md-3"><input type="text" class="form-control" name='indikator' required="true"></div>
				</div>
				<div class="form-group">
					<label class="col-sm-1 col-md-2">Keterangan</label>
					<div class="col-sm-10 col-md-3"><textarea name="keterangan" rows="4" cols="38"></textarea></div>
				</div>
				<div class="form-group">
					<label class="col-sm-1 col-md-2">Pengisi</label>
					<div class="col-sm-10 col-md-3">
						<select name="pengisi" required="true" class="form-control">
							<option value="Non HRD">Non HRD</option>
							<option value="HRD">HRD</option>
						</select>
					</div>
				</div>
				<div class="box-footer">
					<button type="reset" class="btn btn-default">Reset</button>   &nbsp; &nbsp; &nbsp; &nbsp;
					<button type="submit" class="btn btn-info pull-left">Simpan</button>
				</div>
			</form>
		</div>
	</div>


	<div class="box">
        <div class="box-header with-border">
            <h3 class="box-title"><b>Indikator Kriteria Penilaian</b></h3>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse"><i class="fa fa-minus"></i></button>
            </div>
        </div>
        <div class="box-body">
            <div class="box">
				<div class="box-body table-responsive no-padding">
					<table class="table table-borderred table-hover" rules='all' id="datatablefull">
                        <thead>
						<tr>
							<th>No</th>
							<th>Kriteria</th>
							<th>Kode Indikator</th>
							<th>Indikator</th>
							<th>Keterangan</th>
							<th>Pengisi</th>
							<th>Status</th>
							<th></th>
						</tr> 
                        </thead>
                        <tbody>
							<?php
							foreach ($indikator as $i){
								$no++;
								echo "<tr>
										<td>$no</td>
										<td>".all("peg_dp3_kriteria", "id_kriteria", $i->id_kriteria, "kriteria")."</td>
										<td>$i->id_indikator</td>
										<td>$i->indikator</td>
										<td>$i->keterangan</td>
										<td>$i->pengisi</td>
										<td>$i->status</td>
										<td>
											<a href='".base_url('dppp/indikator')."/$i->id_indikator/on'><i class='fa fa-check-circle' title='ON'></i></a>
											<a href='".base_url('dppp/indikator')."/$i->id_indikator/off'><i class='fa fa-power-off' title='OFF'></i></a>
										</td>
									</tr>";
							}
							?>
                        </tbody>
				  </table>
				</div>
			</div>
		</div>
    </div>