<?php 
    if ($this->session->flashdata('sukses')) { ?>
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h4><i class="icon fa fa-check"></i> Berhasil</h4>
            <?php echo $this->session->flashdata('sukses');?>
        </div>
        <?php
    } else if ($this->session->flashdata('gagal')) { ?>
        <div class="alert alert-danger alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h4><i class="icon fa fa-times"></i> Data gagal disimpan</h4>
            <?php echo $this->session->flashdata('gagal');?>
        </div>
        <?php
    }
?>

<section class="content">
	<div class="row">
        <div class="col-md-12">
        	<div class="box box-info">
        		<div class="box-header with-border">
			        <h3 class="box-title"><b>Input Jenis Potongan Gaji</b></h3>
			        <div class="box-tools pull-right">
			            <button class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse"><i class="fa fa-minus"></i></button>
			        </div>
			    </div>
		        <form action="<?php echo base_url('penggajian/jenis_potongan'); ?>" method="post" class="form-horizontal">
					<div class="box-body">
					    <div class="form-group">
					        <label class="col-sm-1 col-md-2">Jenis Potongan</label>
					       	<div class="col-sm-10 col-md-4">
						       	<input class='form-control col-md-2' type='text' name='jenis' required="true" maxlength="100">
						    </div>
					    </div>
					</div>
					<div class="box-body">
					    <div class="form-group">
					        <label class="col-sm-1 col-md-2">Keterangan</label>
					       	<div class="col-sm-10 col-md-5">
						       	<textarea name="ket" rows="4" cols="60"></textarea>
						    </div>
					    </div>
					</div>
					<div id="loadData1"></div>
					<div class="box-footer">
		            	<div class="form-group col-sm-1 col-md-2 col-md-2">
			               	<button type="submit" class="btn btn-success">Simpan</button>
			                <button type="reset" class="btn btn-danger">Reset</button>
			            </div>
		            </div>
		        </form>
		    </div>

		    <div class="box box-info">
        		<div class="box-header with-border">
			        <h3 class="box-title"><b>Jenis Potongan Gaji</b></h3>
			        <div class="box-tools pull-right">
			            <button class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse"><i class="fa fa-minus"></i></button>
			        </div>
			    </div>
			    <table class="table table-borderred table-hover table-responsive" rules='all' id='datatablefull'>
					<thead>
						<tr>
							<th>No</th>
							<th>Jenis Potongan</th>
							<th>Keterangan</th>
							<th>Tanggal Input</th>
							<th>Petugas</th>
							<th>Status</th>
							<th></th>
						</tr>
					</thead>
					<tbody>
					<?php 
						foreach ($jenis_potongan as $jp){
							$id_sekolah=all("pegawai", "nrp", $ts->nrp, "id_sekolah");
							$no++;
								echo "<tr>
									<td>$no</td> 
									<td>$jp->jenis_pot</td>
									<td>$jp->keterangan</td>
									<td>".tgl_indo($jp->tgl)."</td>
									<td>".all("pegawai", "nrp", $jp->nrp, "nama")."</td>
									<td>$jp->status</td>
									<td><a href='".base_url('penggajian/update_j_pot')."/$jp->id_jenispot/on'><i class='fa fa-check-circle-o' title='On'></i></a>  
										<a href='".base_url('penggajian/update_j_pot')."/$jp->id_jenispot/off'><i class='fa fa-power-off' title='Off'></i></a>
									</td>
								</tr>";
						}
					?>
					</tbody>
				</table>
		    </div>
        </div>
    </div>


</section>


