<?php
$hariini=date("Y-m-d");
header("Content-Type:application/vnd.ms-excel");
header("Content-Disposition:attachment; filename=Data_Pegawai_".$hariini.".xls");
header("Expires: 0");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header("Cache-Control: private",false);

?>


	<div class="box">
        <div class="box-header with-border">
            <h3 class="box-title"><b>Data Pegawai</b></h3>
            <div class="box-tools pull-right">
                <button class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse"><i class="fa fa-minus"></i></button>
            </div>
        </div>
        <div class="box-body">
            <div class="box">
				<div class="box-body table-responsive no-padding">
					<table border="1">
                        <thead>
						<tr>
							<th>No</th>
							<th>NIP</th>
							<th>NUPTK</th>
							<th>NRP</th>
							<th>No KTP/NIK</th>
							<th>Nama</th>
							<th>Tempat Lahir</th>
							<th>Tanggal Lahir</th>
							<th>Jenis Kelamin</th>
							<th>Gol.Darah</th>
							<th>Alamat</th>
							<th>Agama</th>
							<th>Status Perkawinan</th>
							<th>Warga Negara</th>
							<th>Telp. 1</th>
							<th>Telp. 2</th>
							<th>TMT Lama</th>
							<th>TMT Baru</th>
							<th>Status Pegawai</th>
							<th>Kategori</th>
							<th>Ijazah Baru</th>
							<th>Tanggal Ijazah Baru</th>
                            <th>Status Aktif</th>
                            <th>Status Kontrak</th>
                            <th>Penempatan Utama</th>
							<th>Jabatan Utama</th>
                            <th>Penempatan Tambahan</th>
							<th>Jabatan Tambahan</th>
							<th>Pangkat/Golongan</th>
							<th>Email</th>
							<th>Pend. Terakhir</th>
							<th>Nama Institusi</th>
							<th>Fakultas</th>
							<th>Jurusan</th>
						</tr>
                        </thead>
                        <tbody>
							<?php
							foreach ($pegawai as $peg){
								$id_jabatan=$peg->id_jabatan;
								$no++;
								echo "<tr>
										<td>$no</td>
										<td>'$peg->nip</td>
										<td>'$peg->nuptk</td>
										<td>'$peg->nrp</td>
										<td>'$peg->no_ktp</td>
										<td>$peg->nama</td>
										<td>$peg->tmp_lhr</td>
										<td>".tgl_indo($peg->tgl_lhr)."</td>
										<td>$peg->jk</td>
										<td>$peg->gol_darah</td>
										<td>$peg->alamat. Desa/Kel.".desa($peg->kel)." Kec.".kecamatan($peg->kec)." Kab.".kabupaten($peg->kota)." Prov.".provinsi($peg->prov)."</td>
										<td>$peg->agama</td>
										<td>$peg->st_marital</td>
										<td>$peg->warga_negara</td>
										<td>$peg->tlp</td>
										<td>$peg->no_hp2</td>
										<td>".tgl_indo($peg->tgl_masuk)."</td>
										<td>".tgl_indo($peg->tgl_masuk_baru)."</td>
										<td>$peg->status_pegawai</td>
										<td>$peg->kategori</td>
										<td>".all("tingkat_pendidikan", "id_tp", $peg->ijazah_baru, 'nama_tp')."</td>
										<td>".tgl_indo($peg->tgl_ijazah_baru)."</td>
										<td>$peg->status_aktf</td>
										<td>".all("kontrak", "id_kontrak", $peg->id_kontrak, "nama_kontrak")."</td>
                                        <td>".all("sekolah", "id_sekolah", $peg->id_sekolah, "nama")."</td>
										<td>$peg->nama_jabatan</td>
										<td>".all("sekolah", "id_sekolah", $peg->id_sekolah2, "nama")."</td>
										<td>".all("jabatan", "id_jabatan", $peg->id_sekolah2, "nama_jabatan")."</td>
										<td>".all("golongan", "id_golongan", $peg->id_golongan, "pangkat")." (".all("golongan", "id_golongan", $peg->id_golongan, "golongan").")</td>
										<td>$peg->email</td>
										<td>".all("tingkat_pendidikan", "id_tp", $peg->pend_akhir, "nama_tp")."</td>
										<td>".$institusi[$peg->nrp]."</td>
										<td>".$fakultas[$peg->nrp]."</td>
										<td>".$jurusan[$peg->nrp]."</td>
									</tr>";
							}
							?>
                        </tbody>
				  </table>
				</div>
			</div>
		</div>
    </div>