    <?php 
    if ($this->session->flashdata('sukses')) { ?>
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Berhasil</h4>
        <?php echo $this->session->flashdata('sukses');?>
    </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-times"></i> Gagal</h4>
        <?php echo $this->session->flashdata('gagal');?>
    </div>
    <?php 
    } ?>

    <div class="box box-danger">
        <div class="box-header with-border">
            <h3 class="box-title">Penyakit</h3>
        </div>
        <!-- modal tambah-->
        <div class="box-body">
            <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#modal-tambah">
                 <i class="fa fa-plus"></i> Tambah Penyakit
            </button>
        </div>
        <div class="modal modal-default fade" id="modal-tambah">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Tambah Penyakit</h4>
              </div>
              <form action="<?php echo base_url('kesehatan/tambah_penyakit'); ?>" method="post">
              <div class="modal-body">
                    <div class="form-group">
                        <label>Nama Penyakit</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-bug"></i>
                            </div>
                            <input type="text" name="nama_penyakit" class="form-control" required/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Keterangan</label>
                        <div class="input-group">
                          <div class="input-group-addon">
                            <i class="fa fa-file-text-o"></i>
                          </div>
                          <input type="text" name="keterangan" class="form-control" required/>
                        </div>
                    </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-danger">Simpan</button>
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->
        <div class="box-body table-responsive">
            <table class="table table-bordered table-striped" id="datatablefull"> 
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Nama Penyakit</th>
                        <th>Keterangan</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $no = 1;    
                    foreach ($penyakit as $key) {?>
                        <tr>
                            <td><?php echo $no; ?>.</td>
                            <td><?php echo $key->nama_penyakit; ?></td>
                            <td><?php echo $key->keterangan; ?></td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-edit-'.$key->id_penyakit; ?>"><i class="fa fa-edit"></i></button>
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-hapus-'.$key->id_penyakit; ?>"><i class="fa fa-trash-o"></i></button>
                                </div>
                            </td>
                        </tr>
                        <?php
                        $no++;
                        ?>
                        <!-- modal edit-->
                        <div class="modal modal-default fade" id="<?php echo 'modal-edit-'.$key->id_penyakit; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Edit Penyakit</h4>
                              </div>
                              <form action="<?php echo base_url('kesehatan/edit_penyakit'); ?>" method="post">
                              <div class="modal-body">
                                <div class="form-group">
                                    <label>Nama Penyakit</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-bug"></i>
                                        </div>
                                        <input type="text" name="nama_penyakit" value="<?php echo $key->nama_penyakit; ?>" class="form-control" required/>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Keterangan</label>
                                    <div class="input-group">
                                      <div class="input-group-addon">
                                        <i class="fa fa-file-text-o"></i>
                                      </div>
                                      <input type="text" name="keterangan" value="<?php echo $key->keterangan; ?>" class="form-control"/>
                                    </div>
                                </div>
                                <input type="hidden" name="id_penyakit" value="<?php echo $key->id_penyakit ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-success">Simpan</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal edit-->
                        <!-- modal hapus-->
                        <div class="modal modal-danger fade" id="<?php echo 'modal-hapus-'.$key->id_penyakit; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Hapus Penyakit</h4>
                              </div>
                              <form action="<?php echo base_url('kesehatan/hapus_penyakit'); ?>" method="post">
                              <div class="modal-body">
                                <p>Data Penyakit dengan nama <b><?php echo $key->nama_penyakit; ?></b> akan segera dihapus.<br>
                                Apakah yakin mau hapus data ini..???</p>
                                <input type="hidden" name="id_penyakit" value="<?php echo $key->id_penyakit ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-outline" data-dismiss="modal">Tidak Jadi</button>
                                <button type="submit" class="btn btn-outline">Ya, Hapus</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal hapus-->
                    <?php    
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>