    <?php 
    if ($this->session->flashdata('sukses')) { ?>
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Berhasil</h4>
        <?php echo $this->session->flashdata('sukses');?>
    </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-times"></i> Gagal</h4>
        <?php echo $this->session->flashdata('gagal');?>
    </div>
    <?php 
    } ?>

    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">Kamar</h3>
        </div>
        <!-- modal tambah-->
        <div class="box-body">
            <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modal-tambah">
                <i class="fa fa-fw fa-plus"></i> Tambah Kamar
            </button>
        </div>
        <div class="modal modal-default fade" id="modal-tambah">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Tambah Kamar</h4>
              </div>
              <form action="<?php echo base_url('boarding/tambah_kamar'); ?>" method="post">
              <div class="modal-body">
                    <div class="form-group">
                        <label>Rayon</label>
                        <div class="input-group">
                          <div class="input-group-addon">
                            <i class="fa fa-building"></i>
                          </div>
                          <select class="form-control" name="asrama" id='asrama' required>
                              <option value="">Pilih</option>
                                <?php foreach ($asrama as $key){ ?>
                                    <option value="<?php echo $key->id_asrama; ?>"><?php echo $key->nama.' ('.$key->jenis.')'; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Nama Kamar</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-hotel"></i>
                            </div>
                            <input type="text" name="nama" class="form-control" required />
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Kapasitas</label>
                        <div class="input-group">
                          <div class="input-group-addon">
                            <i class="fa fa-users"></i>
                          </div>
                          <input type="text" name="kapasitas" onkeydown="return numbersonly(this, event);" class="form-control" required placeholder="Jumlah maksimal santri dalam kamar" />
                        </div>
                    </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-success">Simpan</button>
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->
        <div class="box-body table-responsive">
            <table class="table table-bordered table-hover" id="datatablefull"> 
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Kamar</th>
                        <th>Rayon</th>
                        <th>Kapasitas</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $no = 1;    
                    foreach ($kamar as $key) {
                      if ($key->status=='0') {
                        $bg_text = 'text-muted';
                        $status = 'Off';
                        $status_btn = 'disabled';
                      }else{
                        $bg_text = '';
                        $status = 'On';
                        $status_btn = '';
                      }
                      ?>
                        <tr>
                            <td><p class="<?php echo $bg_text; ?>"><?php echo $no; ?>.</p></td>
                            <td><p class="<?php echo $bg_text; ?>"><?php echo $key->nama; ?></p></td>
                            <td><p class="<?php echo $bg_text; ?>"><?php echo $key->nama_asrama; ?></p></td>
                            <td><p class="<?php echo $bg_text; ?>"><?php echo $key->kapasitas; ?></p></td>
                            <td><p class="<?php echo $bg_text; ?>"><?php echo $status; ?></p></td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-edit-'.$key->id_kamar; ?>" <?php echo $status_btn; ?>><i class="fa fa-edit"></i></button>
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-hapus-'.$key->id_kamar; ?>" <?php echo $status_btn; ?>><i class="fa fa-trash-o"></i></button>
                                </div>
                            </td>
                        </tr>
                        <?php
                        $no++;
                        ?>
                        <!-- modal edit-->
                        <div class="modal modal-default fade" id="<?php echo 'modal-edit-'.$key->id_kamar; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Edit Kamar</h4>
                              </div>
                              <form action="<?php echo base_url('boarding/edit_kamar'); ?>" method="post">
                              <div class="modal-body">
                                <div class="form-group">
                                    <label>Rayon</label>
                                    <div class="input-group">
                                      <div class="input-group-addon">
                                        <i class="fa fa-building"></i>
                                      </div>
                                      <select class="form-control" name="asrama" id='asrama' required>
                                          <option value="">Pilih</option>
                                            <?php foreach ($asrama as $al){ ?>
                                                <option value="<?php echo $al->id_asrama; ?>" <?php if ($key->id_asrama==$al->id_asrama) { echo "selected";} ?>><?php echo $al->nama; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Nama Kamar</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-hotel"></i>
                                        </div>
                                        <input type="text" name="nama" value="<?php echo $key->nama; ?>" class="form-control" required/>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Kapasitas</label>
                                    <div class="input-group">
                                      <div class="input-group-addon">
                                        <i class="fa fa-users"></i>
                                      </div>
                                      <input type="text" name="kapasitas" value="<?php echo $key->kapasitas; ?>" onkeydown="return numbersonly(this, event);" class="form-control" required placeholder="Jumlah maksimal santri dalam kamar" />
                                    </div>
                                </div>
                                <input type="hidden" name="id_kamar" value="<?php echo $key->id_kamar ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-success">Simpan</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal edit-->
                        <!-- modal hapus-->
                        <div class="modal modal-danger fade" id="<?php echo 'modal-hapus-'.$key->id_kamar; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Hapus Kamar</h4>
                              </div>
                              <form action="<?php echo base_url('boarding/hapus_kamar'); ?>" method="post">
                              <div class="modal-body">
                                <p>Data Kamar dengan nama kamar <b><?php echo $key->nama; ?></b> akan segera dihapus.<br>
                                Apakah yakin mau hapus data ini..???</p>
                                <input type="hidden" name="id_kamar" value="<?php echo $key->id_kamar ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-outline" data-dismiss="modal">Tidak Jadi</button>
                                <button type="submit" class="btn btn-outline">Ya, Hapus</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal hapus-->
                    <?php    
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>