    <?php 
    if ($this->session->flashdata('sukses')) { ?>
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-check"></i> Berhasil</h4>
        <?php echo $this->session->flashdata('sukses');?>
    </div>
    <?php
    }elseif ($this->session->flashdata('gagal')) { ?>
    <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <h4><i class="icon fa fa-times"></i> Gagal</h4>
        <?php echo $this->session->flashdata('gagal');?>
    </div>
    <?php 
    } ?>

    <div class="box">
        <div class="box-header with-border">
            <h3 class="box-title">Rayon</h3>
        </div>
        <!-- modal tambah-->
        <div class="box-body">
            <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modal-tambah">
                 <i class="fa fa-plus"></i> Tambah Rayon
            </button>
        </div>
        <div class="modal modal-default fade" id="modal-tambah">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Tambah Rayon</h4>
              </div>
              <form action="<?php echo base_url('boarding/tambah_asrama'); ?>" method="post">
              <div class="modal-body">
                    <div class="form-group">
                        <label>Nama Rayon</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                              <i class="fa fa-building"></i>
                            </div>
                            <input type="text" name="nama" class="form-control" required/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Peruntukan</label>
                        <div class="input-group">
                          <div class="input-group-addon">
                            <i class="fa fa-user"></i>
                          </div>
                          <select class="form-control" name="jenis" id='jenis' required>
                              <option value="">Pilih</option>
                              <option value="Putra">Santri Putra</option>
                              <option value="Putri">Santri Putri</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Tempat</label>
                        <div class="input-group">
                          <div class="input-group-addon">
                            <i class="fa fa-map-marker"></i>
                          </div>
                          <select class="form-control" name="alamat" id='alamat' required>
                              <option value="">Pilih</option>
                                <?php foreach ($alamat as $key){ ?>
                                    <option value="<?php echo $key->id_alamat; ?>"><?php echo $key->nama_alamat; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                <button type="submit" class="btn btn-success">Simpan</button>
              </div>
              </form>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
        <!-- /.modal -->
        <div class="box-body table-responsive">
            <table class="table table-bordered table-hover" id="datatablefull"> 
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Nama Rayon</th>
                        <th>Peruntukan</th>
                        <th>Tempat</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $no = 1;    
                    foreach ($asrama as $key) {?>
                        <tr>
                            <td><?php echo $no; ?>.</td>
                            <td><?php echo $key->nama; ?></td>
                            <td><?php echo "Santri " . $key->jenis; ?></td>
                            <td><?php echo $key->nama_alamat; ?></td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-edit-'.$key->id_asrama; ?>"><i class="fa fa-edit"></i></button>
                                    <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="<?php echo '#modal-hapus-'.$key->id_asrama; ?>"><i class="fa fa-trash-o"></i></button>
                                </div>
                            </td>
                        </tr>
                        <?php
                        $no++;
                        ?>
                        <!-- modal edit-->
                        <div class="modal modal-default fade" id="<?php echo 'modal-edit-'.$key->id_asrama; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Edit Rayon</h4>
                              </div>
                              <form action="<?php echo base_url('boarding/edit_asrama'); ?>" method="post">
                              <div class="modal-body">
                                <div class="form-group">
                                    <label>Nama Rayon</label>
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                          <i class="fa fa-building"></i>
                                        </div>
                                        <input type="text" name="nama" value="<?php echo $key->nama; ?>" class="form-control" required/>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Peruntukan</label>
                                    <div class="input-group">
                                      <div class="input-group-addon">
                                        <i class="fa fa-user"></i>
                                      </div>
                                      <select class="form-control" name="jenis" id='jenis' required>
                                          <option value="">Pilih</option>
                                          <option value="Putra" <?php if ($key->jenis=='Putra') { echo "selected";} ?>
                                            >Santri Putra</option>
                                          <option value="Putri" <?php if ($key->jenis=='Putri') { echo "selected";} ?>>Santri Putri</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>Tempat</label>
                                    <div class="input-group">
                                      <div class="input-group-addon">
                                        <i class="fa fa-map-marker"></i>
                                      </div>
                                      <select class="form-control" name="alamat" id='alamat' required>
                                          <option value="">Pilih</option>
                                            <?php foreach ($alamat as $al){ ?>
                                                <option value="<?php echo $al->id_alamat; ?>" <?php if ($key->id_alamat==$al->id_alamat) { echo "selected";} ?>><?php echo $al->nama_alamat; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <input type="hidden" name="id_asrama" value="<?php echo $key->id_asrama ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
                                <button type="submit" class="btn btn-success">Simpan</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal edit-->
                        <!-- modal hapus-->
                        <div class="modal modal-danger fade" id="<?php echo 'modal-hapus-'.$key->id_asrama; ?>">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Hapus Rayon</h4>
                              </div>
                              <form action="<?php echo base_url('boarding/hapus_asrama'); ?>" method="post">
                              <div class="modal-body">
                                <p>Data Rayon dengan nama <b><?php echo $key->nama; ?></b> akan segera dihapus.<br>
                                Apakah yakin mau hapus data ini..???</p>
                                <input type="hidden" name="id_asrama" value="<?php echo $key->id_asrama ?>">
                              </div>
                              <div class="modal-footer">
                                <button type="button" class="btn btn-outline" data-dismiss="modal">Tidak Jadi</button>
                                <button type="submit" class="btn btn-outline">Ya, Hapus</button>
                              </div>
                              </form>
                            </div>
                          </div>
                        </div>
                        <!-- / modal hapus-->
                    <?php    
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>