<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Abs_shift_kerja_pegawai_model extends CI_Model
{

    // nama tabel
    private $table = "abs_shift_kerja_pegawai";

    // field
    private $id = "id";
    private $nik = "nik";
    private $id_shift_kerja = "id_shift_kerja";
    private $hari = "hari";
    private $minggu_ke = "minggu_ke";

    // function
    function getAll(){
        $db = $this->db;
        $res = $db->get($this->table);
        return $res->result();
    }

    function get_shift_kerja_pegawai_harian($nik = NULL, $divisi = NULL){
        $filter_nik = '';
        if ($nik != NULL) {
            $filter_nik = "AND p.nrp='$nik'";
        }

        $filter_divisi = '';
        if ($divisi != NULL) {
            $filter_divisi = "AND s.id_sekolah='$divisi'";
        }

        $query = $this->db->query("SELECT p.nrp, p.nama, s.nama AS divisi, 
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.hari like '%Monday%' AND a.minggu_ke='all') AS senin,
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.hari like '%Tuesday%' AND a.minggu_ke='all') AS selasa,
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.hari like '%Wednesday%' AND a.minggu_ke='all') AS rabu,
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.hari like '%Thursday%' AND a.minggu_ke='all') AS kamis,
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.hari like '%Friday%' AND a.minggu_ke='all') AS jumat,
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.hari like '%Saturday%' AND a.minggu_ke='all') AS sabtu,
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.hari like '%Sunday%' AND a.minggu_ke='all') AS ahad 

            FROM `pegawai` p
            LEFT JOIN sekolah s ON p.id_sekolah=s.id_sekolah 
            WHERE s.kategori='Non Sekolah'
            $filter_nik 
            $filter_divisi
            ORDER BY s.nama ASC, p.nama ASC
        ");
        
        return $query->result();

    }


    function get_shift_kerja_pegawai_pekanan($nik = NULL, $divisi = NULL){
        $filter_nik = '';
        if ($nik != NULL) {
            $filter_nik = "AND p.nrp='$nik'";
        }

        $filter_divisi = '';
        if ($divisi != NULL) {
            $filter_divisi = "AND s.id_sekolah='$divisi'";
        }

        $query = $this->db->query("SELECT p.nrp, p.nama, s.nama AS divisi, 
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.minggu_ke='1' GROUP BY minggu_ke) AS pekan_1,
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.minggu_ke='2' GROUP BY minggu_ke) AS pekan_2,
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.minggu_ke='3' GROUP BY minggu_ke) AS pekan_3,
            (SELECT concat(b.nama_shift_kerja,',',TIME_FORMAT(b.jam_kerja_in,'%H:%i'),'-',TIME_FORMAT(b.jam_kerja_out,'%H:%i'),',',a.id_shift_kerja) FROM abs_shift_kerja_pegawai a JOIN abs_shift_kerja b ON a.id_shift_kerja=b.id_shift_kerja WHERE a.nik=p.nrp AND a.minggu_ke='4' GROUP BY minggu_ke) AS pekan_4

            FROM `pegawai` p
            LEFT JOIN sekolah s ON p.id_sekolah=s.id_sekolah 
            WHERE s.kategori='Non Sekolah'
            AND s.jenis_presensi='pekanan'
            $filter_nik 
            $filter_divisi
            ORDER BY s.nama ASC, p.nama ASC
        ");
        
        return $query->result();

    }

    function update(
        $id_shift_kerja_new,
        $id_shift_kerja_old,
        $nik,
        $hari,
        $minggu_ke
    ) {
        $db = $this->db;
        $data = array(
            $this->id_shift_kerja => $id_shift_kerja_new,
        );
        $db->where($this->id_shift_kerja, $id_shift_kerja_old);
        $db->where($this->nik, $nik);
        $db->like($this->hari, $hari);
        $db->where($this->minggu_ke, $minggu_ke);
        $db->update($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    function input(
        $id,
        $nik,
        $id_shift_kerja,
        $hari,
        $minggu_ke
    ) {
        $db = $this->db;
        $data = array(
            $this->id => $id,
            $this->nik => $nik,
            $this->id_shift_kerja => $id_shift_kerja,
            $this->hari => $hari,
            $this->minggu_ke => $minggu_ke
        );
        $db->insert($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    function hapus(        
        $id_shift_kerja_old,
        $nik,
        $hari,
        $minggu_ke
    )
    {
        $db = $this->db;
        $db->where($this->id_shift_kerja, $id_shift_kerja_old);
        $db->where($this->nik, $nik);
        $db->like($this->hari, $hari);
        $db->where($this->minggu_ke, $minggu_ke);
        if ($db->delete($this->table)) {
            return 1;
        } else {
            return 0;
        }
    }

}

/* End of file Abs_shift_kerja_pegawai_model.php */
