<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Abs_shift_kerja_model extends CI_Model
{

    // nama table 
    private $table = "abs_shift_kerja";

    // field
    private $id_shift_kerja = "id_shift_kerja";
    private $id_sekolah = "id_sekolah";
    private $nama_shift_kerja = "nama_shift_kerja";
    private $jam_kerja_in = "jam_kerja_in";
    private $jam_kerja_out = "jam_kerja_out";
    private $scan_in_min = "scan_in_min";
    private $scan_in_max = "scan_in_max";
    private $scan_out_min = "scan_out_min";
    private $scan_out_max = "scan_out_max";
    private $durasi_kerja = "durasi_kerja";
    private $status = "status";

    // function
    function getAll()
    {
        $db = $this->db;
        $res = $db->get($this->table);
        return $res->result();
    }

    function input(
        $id_sekolah,
        $nama_shift_kerja,
        $jam_kerja_in,
        $jam_kerja_out,
        $scan_in_min,
        $scan_in_max,
        $scan_out_min,
        $scan_out_max,
        $durasi_kerja
    ) {
        $db = $this->db;
        $data = array(
            $this->id_sekolah => $id_sekolah,
            $this->nama_shift_kerja => $nama_shift_kerja,
            $this->jam_kerja_in => $jam_kerja_in,
            $this->jam_kerja_out => $jam_kerja_out,
            $this->scan_in_min => $scan_in_min,
            $this->scan_in_max => $scan_in_max,
            $this->scan_out_min => $scan_out_min,
            $this->scan_out_max => $scan_out_max,
            $this->durasi_kerja => $durasi_kerja,
            $this->status => "on",
        );
        $db->insert($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    function getDataWhere($id_sekolah)
    {
        $db = $this->db;
        $res = $db->query("SELECT a.*,b.nama as divisi from abs_shift_kerja as a LEFT JOIN sekolah as b on a.id_sekolah =b.id_sekolah WHERE a.id_sekolah='$id_sekolah' and a.status='on'");
        return $res->result();
    }
    function getOneDataWhere($id_shift_kerja){
        $db = $this->db;
        $res = $db->query("SELECT a.*,b.nama as divisi from abs_shift_kerja as a LEFT JOIN sekolah as b on a.id_sekolah =b.id_sekolah WHERE a.id_shift_kerja='$id_shift_kerja' and a.status='on'");
        return $res->result();
    }

    function hapus($id_shift_kerja)
    {
        $db = $this->db;
        $data = array(
            $this->status => 'off'
        );
        $db->where($this->id_shift_kerja, $id_shift_kerja);
        $db->update($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }
    function update(
        $id_shift_kerja,
        $nama_shift_kerja,
        $jam_kerja_in,
        $jam_kerja_out,
        $scan_in_min,
        $scan_in_max,
        $scan_out_min,
        $scan_out_max,
        $durasi_kerja
    ) {
        $db = $this->db;
        $data = array(
            $this->nama_shift_kerja => $nama_shift_kerja,
            $this->jam_kerja_in => $jam_kerja_in,
            $this->jam_kerja_out => $jam_kerja_out,
            $this->scan_in_min => $scan_in_min,
            $this->scan_in_max => $scan_in_max,
            $this->scan_out_min => $scan_out_min,
            $this->scan_out_max => $scan_out_max,
            $this->durasi_kerja => $durasi_kerja,
        );
        $db->where($this->id_shift_kerja,$id_shift_kerja);
        $db->update($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }
}

/* End of file Abs_shift_kerja_model.php */
