<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Abs_log_model extends CI_Model
{

    // nama table 
    private $table = "abs_log";

    // field
    private $log_id = "log_id";
    private $log_time = "log_time";
    private $user_id = "user_id";
    private $source = "source";
    private $created_at = "created_at";
    private $created_by = "created_by";
    private $updated_at = "updated_at";
    private $updated_by = "updated_by";

    // function
    function getAll($tgl1, $tgl2, $nrp)
    {
        $db = $this->db;
        $res = null;
        if (($tgl1 != null && $tgl2 != null) && $nrp == null) {
            $res = $db->query("SELECT a.*,b.nama as updated_by_name,(SELECT nama as nama_finger FROM abs_spo WHERE serial_number=a.source) as nama_finger from (SELECT a.*,b.nama as nama_user FROM abs_log as a JOIN pegawai as b on a.user_id = b.nrp) as a LEFT JOIN pegawai as b on a.updated_by = b.nrp WHERE a.log_time BETWEEN '$tgl1' and '$tgl2 23:59:59'");
            $res = $res->result();
        } else if (($tgl1 != null && $tgl2 != null) && $nrp != null) {
            $res = $db->query("SELECT a.*,b.nama as updated_by_name,(SELECT nama as nama_finger FROM abs_spo WHERE serial_number=a.source) as nama_finger from (SELECT a.*,b.nama as nama_user FROM abs_log as a JOIN pegawai as b on a.user_id = b.nrp) as a LEFT JOIN pegawai as b on a.updated_by = b.nrp WHERE a.log_time BETWEEN '$tgl1' and '$tgl2 23:59:59' AND a.user_id='$nrp'");
            $res = $res->result();
        } else {
            $res = 0;
        }
        return $res;
    }

    function getLogPegawai($tgl, $nrp)
    {
        $db = $this->db;
        if ($tgl != null && $nrp != null) {
            if ($tgl != "" && $nrp != "") {
                $res = $db->query("SELECT a.*,b.nama as updated_by_name,(SELECT nama as nama_finger FROM abs_spo WHERE serial_number=a.source) as nama_finger from (SELECT a.*,b.nama as nama_user FROM abs_log as a JOIN pegawai as b on a.user_id = b.nrp) as a LEFT JOIN pegawai as b on a.updated_by = b.nrp WHERE a.log_time LIKE '$tgl%'  AND a.user_id='$nrp' ORDER BY a.log_time ASC");
                return $res->result();
            }
        }
    }

    function inputManual($log_time, $user_id)
    {
        $db = $this->db;
        $nrp = $this->session->userdata("nrp");
        $data = array(
            $this->log_time => $log_time,
            $this->user_id => $user_id,
            $this->source => "",
            $this->created_at => date("Y-m-d H:m:s"),
            $this->created_by => $nrp,
            $this->updated_at => date("Y-m-d H:m:s"),
            $this->updated_by => $nrp,
        );
        $db->insert($this->table,$data);
        $res  = $db->affected_rows();
        if($res > 0){
            return 1;
        }else{
            return 0;
        }
        
    }

    function get_by_id($log_id)
    {
        $db = $this->db;
        $res = $db->query("SELECT a.*, b.nama FROM abs_log as a JOIN pegawai as b on a.user_id = b.nrp WHERE a.log_id ='$log_id' ");
        return $res->result();
    }

    function hapus($log_id)
    {
        $db = $this->db;
        $db->where($this->log_id, $log_id);
        if ($db->delete($this->table)) {
            return 1;
        } else {
            return 0;
        }
    }

}

/* End of file Abs_log_model.php */
