<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Abs_jam_kerja_harian_model extends CI_Model
{
    // nama table 
    private $table = "abs_jam_kerja_harian";

    // field
    private $id = "id";
    private $nik = "nik";
    private $id_jabatan = "id_jabatan";
    private $id_sekolah = "id_sekolah";
    private $tanggal = "tanggal";
    private $hari = "hari";
    private $minggu_ke = "minggu_ke";
    private $jenis = "jenis";
    private $id_shift_kerja = "id_shift_kerja";
    private $nama_shift_kerja = "nama_shift_kerja";
    private $jam_kerja_in = "jam_kerja_in";
    private $jam_kerja_out = "jam_kerja_out";
    private $scan_in_min = "scan_in_min";
    private $scan_in_max = "scan_in_max";
    private $scan_out_min = "scan_out_min";
    private $scan_out_max = "scan_out_max";
    private $presensi = "presensi";
    private $updated_at = "updated_at";
    private $updated_by = "updated_by";

    // function 

    function getAll()
    {
        $db = $this->db;
        $res = $db->get($this->table);
        return $res->result();
    }

    function get_tanggal_kerja($nik, $hari, $tanggal_mulai)
    {
        $db = $this->db;
        $db->select('id');
        $db->select('tanggal');
        $db->where($this->nik, $nik);
        $db->where($this->hari, $hari);
        $db->where($this->tanggal . ' >=', $tanggal_mulai);
        $res = $db->get($this->table);
        return $res->result();
    }

    function input(
        $nik,
        $id_jabatan,
        $id_sekolah,
        $tanggal,
        $hari,
        $minggu_ke,
        $jenis,
        $id_shift_kerja,
        $nama_shift_kerja,
        $jam_kerja_in,
        $jam_kerja_out,
        $scan_in_min,
        $scan_in_max,
        $scan_out_min,
        $scan_out_max,
        $updated_at,
        $updated_by,
        $presensi
    ) {
        $db = $this->db;
        $data = array(
            $this->id => '',
            $this->nik => $nik,
            $this->id_jabatan => $id_jabatan,
            $this->id_sekolah => $id_sekolah,
            $this->tanggal => $tanggal,
            $this->hari => $hari,
            $this->minggu_ke => $minggu_ke,
            $this->jenis => $jenis,
            $this->id_shift_kerja => $id_shift_kerja,
            $this->nama_shift_kerja => $nama_shift_kerja,
            $this->jam_kerja_in => $jam_kerja_in,
            $this->jam_kerja_out => $jam_kerja_out,
            $this->scan_in_min => $scan_in_min,
            $this->scan_in_max => $scan_in_max,
            $this->scan_out_min => $scan_out_min,
            $this->scan_out_max => $scan_out_max,
            $this->updated_at => $updated_at,
            $this->updated_by => $updated_by,
            $this->presensi => $presensi,
        );
        $db->insert($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    function update_shift_kerja(
        $id_shift_kerja_new,
        $nama_shift_kerja,
        $jam_kerja_in,
        $jam_kerja_out,
        $scan_in_min,
        $scan_in_max,
        $scan_out_min,
        $scan_out_max,
        $id
    ) {
        $db = $this->db;
        $data = array(
            $this->id_shift_kerja => $id_shift_kerja_new,
            $this->nama_shift_kerja => $nama_shift_kerja,
            $this->jam_kerja_in => $jam_kerja_in,
            $this->jam_kerja_out => $jam_kerja_out,
            $this->scan_in_min => $scan_in_min,
            $this->scan_in_max => $scan_in_max,
            $this->scan_out_min => $scan_out_min,
            $this->scan_out_max => $scan_out_max,
        );
        $db->where($this->id, $id);
        $db->update($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    function update_shift_kerja_by_id_shift(
        $id_shift_kerja,
        $nama_shift_kerja,
        $jam_kerja_in,
        $jam_kerja_out,
        $scan_in_min,
        $scan_in_max,
        $scan_out_min,
        $scan_out_max,
        $tanggal
    ) {
        $db = $this->db;
        $data = array(
            $this->nama_shift_kerja => $nama_shift_kerja,
            $this->jam_kerja_in => $jam_kerja_in,
            $this->jam_kerja_out => $jam_kerja_out,
            $this->scan_in_min => $scan_in_min,
            $this->scan_in_max => $scan_in_max,
            $this->scan_out_min => $scan_out_min,
            $this->scan_out_max => $scan_out_max,
        );
        $db->where($this->id_shift_kerja, $id_shift_kerja);
        $db->where($this->tanggal, $tanggal);
        $db->update($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    function hapus($id)
    {
        $db = $this->db;
        $db->where($this->id, $id);
        if ($db->delete($this->table)) {
            return 1;
        } else {
            return 0;
        }
    }


    function getPresensi($tanggal_mulai, $tanggal_sampai, $nik = NULL, $divisi = NULL)
    {
        $filter_nik = '';
        if ($nik != NULL) {
            $filter_nik = "AND a.nik='$nik'";
        }

        $filter_divisi = '';
        if ($divisi != NULL) {
            $filter_divisi = "AND s.id_sekolah='$divisi'";
        }

        $query = $this->db->query("SELECT p.nama, s.nama AS divisi, j.nama_jabatan, a.*, 
            (SELECT log_time FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time ASC LIMIT 1) AS scan_in, 
            (SELECT log_time FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time DESC LIMIT 1) AS scan_out, 
            TIMEDIFF(
                (SELECT IF(log_time < a.jam_kerja_in, a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time DESC LIMIT 1), 
                (SELECT IF(log_time < a.jam_kerja_in, a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time ASC LIMIT 1)) AS durasi_kerja_real,
            TIMEDIFF(a.jam_kerja_out, a.jam_kerja_in) AS durasi_kerja_wajib,
            TIMEDIFF(
                TIMEDIFF(
                (SELECT IF(log_time < a.jam_kerja_in, a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time DESC LIMIT 1), 
                (SELECT IF(log_time < a.jam_kerja_in,a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time ASC LIMIT 1)),
                TIMEDIFF(a.jam_kerja_out, a.jam_kerja_in)
            ) AS plusmin, 
            TIMEDIFF(
                (SELECT IF(log_time < a.jam_kerja_in, a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time ASC LIMIT 1),
                a.jam_kerja_in
            ) AS menit_terlambat,
            TIMEDIFF(
                a.jam_kerja_out,
                (SELECT IF(log_time < a.jam_kerja_out, log_time, a.jam_kerja_out) FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time DESC LIMIT 1)
            ) AS menit_pulang_cepat

            FROM `abs_jam_kerja_harian` a
            LEFT JOIN pegawai p ON a.nik=p.nrp
            LEFT JOIN sekolah s ON a.id_sekolah=s.id_sekolah
            LEFT JOIN jabatan j ON a.id_jabatan=j.id_jabatan
            WHERE a.jam_kerja_in >= '$tanggal_mulai' AND a.jam_kerja_in <= '$tanggal_sampai' AND p.status_aktf='Aktif'
            $filter_nik 
            $filter_divisi
            ORDER BY a.jam_kerja_in ASC, p.nama ASC
            ");

        return $query->result();
    }

    function getResume($tanggal_mulai, $tanggal_sampai, $nik = NULL, $divisi = NULL, $asrama = NULL)
    {
        $filter_nik = '';
        if ($nik != NULL) {
            $filter_nik = " AND a.nik='$nik'";
        }

        $filter_divisi = '';
        if ($divisi != NULL) {
            $filter_divisi = " AND s.id_sekolah='$divisi'";
        }

        $filter_asrama = '';
        if ($asrama != NULL) {
            $filter_asrama = " AND p.asrama='$asrama'";
        }

        $query = $this->db->query("SELECT p.nama, s.nama AS divisi, j.nama_jabatan, a.nik, a.presensi,
            SEC_TO_TIME(SUM(TIME_TO_SEC( 
            TIMEDIFF(
                (SELECT IF(log_time < a.jam_kerja_in, a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time DESC LIMIT 1), 
                (SELECT IF(log_time < a.jam_kerja_in,a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time ASC LIMIT 1)
            )
            ))) AS sum_durasi_kerja_real,
            SEC_TO_TIME(SUM(TIME_TO_SEC( 
            TIMEDIFF(a.jam_kerja_out, a.jam_kerja_in) 
            ))) AS sum_durasi_kerja_wajib,
            SEC_TO_TIME(SUM(TIME_TO_SEC(
            TIMEDIFF(
                TIMEDIFF(
                (SELECT IF(log_time < a.jam_kerja_in, a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time DESC LIMIT 1), 
                (SELECT IF(log_time < a.jam_kerja_in,a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max  AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time ASC LIMIT 1)),
                TIMEDIFF(a.jam_kerja_out, a.jam_kerja_in)
            )
            ))) AS sum_plusmin, 
            SEC_TO_TIME(SUM(TIME_TO_SEC(
            TIMEDIFF(
                (SELECT IF(log_time < a.jam_kerja_in,a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time ASC LIMIT 1),
                a.jam_kerja_in
            )
            )))AS sum_menit_terlambat,
            SUM(IF(
            TIMEDIFF(
                (SELECT IF(log_time < a.jam_kerja_in,a.jam_kerja_in, log_time) FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time ASC LIMIT 1),
                a.jam_kerja_in
            )!='00:00:00',1,0
            )) AS waktu_terlambat,
            SEC_TO_TIME(SUM(TIME_TO_SEC(
            TIMEDIFF(
                a.jam_kerja_out,
                (SELECT IF(log_time < a.jam_kerja_out, log_time, a.jam_kerja_out) FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time DESC LIMIT 1)
            )
            ))) AS sum_menit_pulang_cepat,
            SUM(IF(
            TIMEDIFF(
                a.jam_kerja_out,
                (SELECT IF(log_time < a.jam_kerja_out, log_time, a.jam_kerja_out) FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time DESC LIMIT 1)
            )!='00:00:00',1,0
            )) AS waktu_pulang_cepat,
            SUM(IF(a.presensi='I',1,0)) AS jumlah_ijin,
            SUM(IF(a.presensi='S',1,0)) AS jumlah_sakit,
            SUM(IF(a.presensi='A',1,0)) AS jumlah_alfa,
            SUM(IF(
                (
                (SELECT log_time FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik AND (a.presensi='H' OR a.presensi IS NULL)) 
                OR 
                (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik AND (a.presensi='H' OR a.presensi IS NULL)) ORDER BY log_time ASC LIMIT 1) != '' 
                AND
                (SELECT log_time FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik AND (a.presensi='H' OR a.presensi IS NULL)) 
                OR 
                (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik AND (a.presensi='H' OR a.presensi IS NULL)) ORDER BY log_time DESC LIMIT 1) != '' 
                ),
                1,0
            )) AS jumlah_hadir,
            SUM(IF(
                (
                (SELECT log_time FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik ) 
                OR 
                (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time ASC LIMIT 1) IS NULL 
                AND
                (SELECT log_time FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik) 
                OR 
                (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time DESC LIMIT 1) IS NULL 
                )
                AND a.presensi IS NULL,
                1,0
            )) AS jumlah_tanpa_keterangan
    
            FROM `abs_jam_kerja_harian` a
            LEFT JOIN pegawai p ON a.nik=p.nrp
            LEFT JOIN sekolah s ON a.id_sekolah=s.id_sekolah
            LEFT JOIN jabatan j ON a.id_jabatan=j.id_jabatan
            WHERE a.jam_kerja_in >= '$tanggal_mulai' AND a.jam_kerja_in <= '$tanggal_sampai' AND p.status_aktf='Aktif'
            $filter_nik 
            $filter_divisi
            $filter_asrama
            GROUP BY a.nik
            ORDER BY p.nama ASC
        ");

        return $query->result();
    }

    function dataForPresensiManual($nrp, $tgl)
    {
        $db  = $this->db;
        $res = $db->query("SELECT a.id , a.nik,a.tanggal,a.nama_shift_kerja as nama_shift,a.id_shift_kerja,a.jam_kerja_in,a.jam_kerja_out,(SELECT nama from pegawai WHERE nrp=a.nik) as nama_user,(SELECT log_time FROM abs_log WHERE (log_time >= a.scan_in_min AND log_time <= a.scan_in_max AND a.scan_in_max!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_in_max='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time ASC LIMIT 1) AS scan_in,(SELECT log_time FROM abs_log WHERE (log_time >= a.scan_out_min AND log_time <= a.scan_out_max AND a.scan_out_min!='0000-00-00 00:00:00' AND user_id=a.nik) OR (log_time >= a.scan_in_min AND a.scan_out_min='0000-00-00 00:00:00' AND log_time <= a.scan_out_max AND user_id=a.nik) ORDER BY log_time DESC LIMIT 1) AS scan_out FROM  abs_jam_kerja_harian as a WHERE a.nik='$nrp' AND a.tanggal='$tgl'");
        return $res->result();
    }

    function get_tanggal_kerja_pekanan($nik, $hari, $tanggal_mulai, $minggu_ke)
    {
        $db = $this->db;
        $db->select('id');
        $db->select('tanggal');
        $db->where($this->nik, $nik);
        $db->where($this->hari, $hari);
        $db->where($this->minggu_ke, $minggu_ke);
        $db->where($this->tanggal . ' >=', $tanggal_mulai);
        $res = $db->get($this->table);
        return $res->result();
    }

    function updatePresensi($id, $nik, $tanggal, $presensi)
    {
        $db  = $this->db;
        $data = array(
            $this->presensi => $presensi
        );
        $where = array(
            $this->id => $id,
            $this->nik => $nik,
            $this->tanggal => $tanggal
        );
        $db->where($this->id, $id);
        $db->where($this->nik, $nik);
        $db->where($this->tanggal, $tanggal);
        $db->update($this->table, $data);

        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }
}

/* End of file Abs_jam_kerja_harian_model.php */
