<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Abs_free_kerja_pegawai_model extends CI_Model
{

    // nama tabel
    private $table = "abs_free_kerja_pegawai";

    // field
    private $id = "id";
    private $nik = "nik";
    private $hari = "hari";
    private $minggu_ke = "minggu_ke";

    // function
    function getAll(){
        $db = $this->db;
        $res = $db->get($this->table);
        return $res->result();
    }


    function get_free_kerja_pegawai_pekanan($nik = NULL, $divisi = NULL){
        $filter_nik = '';
        if ($nik != NULL) {
            $filter_nik = "AND p.nrp='$nik'";
        }

        $filter_divisi = '';
        if ($divisi != NULL) {
            $filter_divisi = "AND s.id_sekolah='$divisi'";
        }

        $query = $this->db->query("SELECT p.nrp, p.nama, s.nama AS divisi, 
            (SELECT hari FROM abs_free_kerja_pegawai WHERE nik=p.nrp AND minggu_ke='1' GROUP BY minggu_ke) AS pekan_1,
            (SELECT hari FROM abs_free_kerja_pegawai WHERE nik=p.nrp AND minggu_ke='2' GROUP BY minggu_ke) AS pekan_2,
            (SELECT hari FROM abs_free_kerja_pegawai WHERE nik=p.nrp AND minggu_ke='3' GROUP BY minggu_ke) AS pekan_3,
            (SELECT hari FROM abs_free_kerja_pegawai WHERE nik=p.nrp AND minggu_ke='4' GROUP BY minggu_ke) AS pekan_4
            FROM `pegawai` p
            LEFT JOIN sekolah s ON p.id_sekolah=s.id_sekolah 
            WHERE s.kategori='Non Sekolah'
            $filter_nik 
            $filter_divisi
            ORDER BY s.nama ASC, p.nama ASC
        ");
        
        return $query->result();

    }

    function update(
        $nik,
        $hari,
        $minggu_ke
    ) {
        $db = $this->db;
        $data = array(
            $this->hari => $hari,
        );
        $db->where($this->nik, $nik);
        $db->where($this->minggu_ke, $minggu_ke);
        $db->update($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    function input(
        $nik,
        $hari,
        $minggu_ke
    ) {
        $db = $this->db;
        $data = array(
            $this->id => '',
            $this->nik => $nik,
            $this->hari => $hari,
            $this->minggu_ke => $minggu_ke
        );
        $db->insert($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    function hapus(        
        $nik,
        $hari,
        $minggu_ke
    )
    {
        $db = $this->db;
        $db->where($this->nik, $nik);
        $db->where($this->hari, $hari);
        $db->where($this->minggu_ke, $minggu_ke);
        if ($db->delete($this->table)) {
            return 1;
        } else {
            return 0;
        }
    }

}

/* End of file Abs_shift_kerja_pegawai_model.php */
