<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Abs_asrama_model extends CI_Model
{

    // nama tabel
    private $table = "abs_asrama";

    // field
    private $id = "id";
    private $nama = "nama";
    private $is_on = "is_on";
    private $created_at = "created_at";
    private $updated_at = "updated_at";

    // function
    function getAll(){
        $db = $this->db;
        $db->order_by('nama', 'ASC');
        $res = $db->get($this->table);
        return $res->result();
    }

    function getOn(){
        $db = $this->db;
        $db->where($this->is_on, 1);
        $db->order_by('nama', 'ASC');
        $res = $db->get($this->table);
        return $res->result();
    }

    function update(
        $id,
        $nama,
        $is_on
    ) {
        $db = $this->db;
        $data = array(
            $this->nama => $nama,
            $this->is_on => $is_on,
        );
        $db->where($this->id, $id);
        $db->update($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    function input(
        $nama
    ) {
        $db = $this->db;
        $data = array(
            $this->id => '',
            $this->nama => $nama,
            $this->is_on => 1
        );
        $db->insert($this->table, $data);
        $res = $db->affected_rows();
        if ($res > 0) {
            return 1;
        } else {
            return 0;
        }
    }

    function delete(        
        $id
    )
    {
        $db = $this->db;
        $db->where($this->id, $id);
        if ($db->delete($this->table)) {
            return 1;
        } else {
            return 0;
        }
    }

}

/* End of file Abs_shift_kerja_pegawai_model.php */
