<?php defined("BASEPATH")OR exit("file not found");
class Pegawai_model extends CI_Model{
    private $table ="pegawai";

    private $status_aktf = "status_aktf";

    function gurutahfidz(){
        $this->db->select("*");
        $this->db->where("id_jabatan='21'");
        $res =$this->db->get($this->table);
        return $res->result();
    }

    function getDataByID($nik){
        $this->db->select('pegawai.nrp, pegawai.nama, pegawai.jk, sekolah.nama AS divisi, jabatan.nama_jabatan, sekolah.id_sekolah, jabatan.id_jabatan, pegawai.foto');
        $this->db->from('pegawai');
        $this->db->join('sekolah', 'sekolah.id_sekolah = pegawai.id_sekolah');
        $this->db->join('jabatan', 'jabatan.id_jabatan = pegawai.id_jabatan');
        $this->db->where('pegawai.nrp', $nik);
        $query = $this->db->get();
        return $query->result();
    }    

    function pegawai_non_sekolah($jenis_presensi=null){
        $this->db->select('pegawai.nrp, pegawai.nama');
        $this->db->from('pegawai');
        $this->db->join('sekolah', 'sekolah.id_sekolah = pegawai.id_sekolah');
        $this->db->where('sekolah.kategori', 'Non Sekolah');
		 $this->db->where('pegawai.status_aktf', 'Aktif');
        if ( $jenis_presensi != null) {
            $this->db->where('sekolah.jenis_presensi', $jenis_presensi);
        }
    	$this->db->order_by('pegawai.nama', 'ASC');
        $query = $this->db->get();
		return $query->result();
    }

    function pegawai_non_sekolah_aktiv($katakunci){
        $this->db->select('pegawai.nrp, pegawai.nama');
        $this->db->from('pegawai');
        $this->db->join('sekolah', 'sekolah.id_sekolah = pegawai.id_sekolah');
        $this->db->like('pegawai.nrp', $katakunci);
        $this->db->or_like('pegawai.nama', $katakunci);
        $this->db->where('sekolah.kategori', 'Non Sekolah');
        $this->db->where('pegawai.status_aktf', 'Aktif');
        $this->db->order_by('pegawai.nama', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    function pegawai_non_sekolah_by_presensi($jenis_presensi){
        $this->db->select('pegawai.nrp, pegawai.nama');
        $this->db->from('pegawai');
        $this->db->join('sekolah', 'sekolah.id_sekolah = pegawai.id_sekolah');
        $this->db->where('sekolah.kategori', 'Non Sekolah');
        $this->db->where('sekolah.jenis_presensi', $jenis_presensi);
        $this->db->where('pegawai.status_aktf', 'Aktif');
        $this->db->order_by('pegawai.nama', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    function sekolah_non_sekolah($jenis_presensi=null){
        $this->db->select('id_sekolah, nama');
        $this->db->from('sekolah');
        $this->db->where('kategori', 'Non Sekolah');

        if ( $jenis_presensi != null) {
            $this->db->where('sekolah.jenis_presensi', $jenis_presensi);
        }
        
    	$this->db->order_by('nama', 'ASC');
        $query = $this->db->get();
		return $query->result();
    }
	
	function pegawai_all($jenis_presensi=null){
        $this->db->select('pegawai.nrp, pegawai.nama');
        $this->db->from('pegawai');
        $this->db->join('sekolah', 'sekolah.id_sekolah = pegawai.id_sekolah');
        $this->db->where('sekolah.kategori', 'Sekolah');
		 $this->db->where('pegawai.status_aktf', 'Aktif');
        if ( $jenis_presensi != null) {
            $this->db->where('sekolah.jenis_presensi', $jenis_presensi);
        }
    	$this->db->order_by('pegawai.nama', 'ASC');
        $query = $this->db->get();
		return $query->result();
    }

    function pegawai_all_aktiv($katakunci){
        $this->db->select('pegawai.nrp, pegawai.nama');
        $this->db->from('pegawai');
        $this->db->join('sekolah', 'sekolah.id_sekolah = pegawai.id_sekolah');
        $this->db->like('pegawai.nrp', $katakunci);
        $this->db->or_like('pegawai.nama', $katakunci);
        $this->db->where('sekolah.kategori', 'Non Sekolah');
        $this->db->where('pegawai.status_aktf', 'Aktif');
        $this->db->order_by('pegawai.nama', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    function pegawai_all_by_presensi($jenis_presensi){
        $this->db->select('pegawai.nrp, pegawai.nama');
        $this->db->from('pegawai');
        $this->db->join('sekolah', 'sekolah.id_sekolah = pegawai.id_sekolah');
        $this->db->where('sekolah.kategori', 'Non Sekolah');
        $this->db->where('sekolah.jenis_presensi', $jenis_presensi);
        $this->db->where('pegawai.status_aktf', 'Aktif');
        $this->db->order_by('pegawai.nama', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    function sekolah_all($jenis_presensi=null){
        $this->db->select('id_sekolah, nama');
        $this->db->from('sekolah');
        $this->db->where('kategori', 'Non Sekolah');

        if ( $jenis_presensi != null) {
            $this->db->where('sekolah.jenis_presensi', $jenis_presensi);
        }
        
    	$this->db->order_by('nama', 'ASC');
        $query = $this->db->get();
		return $query->result();
    }

    function getAllPegawai(){
        $db =$this->db;
        $db->select("nrp,nama");
        $db->where($this->status_aktf,"Aktif");
        $db->order_by('nama', 'asc');        
        $res = $db->get($this->table);
        return $res->result();
    }
}