<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Perpus_models extends CI_Model {	

//    var $table = 'perpus_penulis';
//    var $column_order = array(null, 'nama'); //set column field database for datatable orderable
//    var $column_search = array('nama'); //set column field database for datatable searchable 
//    var $order = array('nama' => 'asc'); // default order 

    function __construct(){
        parent::__construct();
    }
 
    private function _get_datatables_query($table, $column_order, $column_search, $order, $search_external_value)
    {

        if ($table == 'perpus_biblio') {
    
            if ($column_search[0] == 'perpus_penulis.nama') {
                $this->db->select($table.'.id_biblio,'.$table.'.judul,'.$table.'.judul_paralel,'.$table.'.judul_terjemah,'.$table.'.edisi,'.$table.'.tahun_terbit,'.$table.'.id_tempat as nama_tempat,'.$table.'.id_penerbit as nama_penerbit,'.$table.'.klasifikasi,'.$table.'.deskripsi_fisik, '.$table.'.no_panggil, perpus_penulis.nama as nama_penulis');
                $this->db->from('perpus_biblio_pengarang');
                $this->db->join('perpus_biblio', 'perpus_biblio.id_biblio=perpus_biblio_pengarang.id_biblio', 'left');
                $this->db->join('perpus_penulis', 'perpus_penulis.id_penulis=perpus_biblio_pengarang.id_penulis', 'left');
            }else{
                $this->db->select('perpus_tempat.nama_tempat, perpus_penerbit.nama as nama_penerbit, '.$table.'.*');
                $this->db->from($table);
                $this->db->join('perpus_tempat', 'perpus_biblio.id_tempat=perpus_tempat.id_tempat', 'left');
                $this->db->join('perpus_penerbit', 'perpus_biblio.id_penerbit=perpus_penerbit.id_penerbit', 'left');            
            }

        }elseif($table == 'perpus_bahan_pustaka'){
                $this->db->select('perpus_lokasi.*, perpus_status_item.*, perpus_jenis_pustaka.*, perpus_biblio.*, perpus_bahan_pustaka.*, perpus_sumber.*');
                $this->db->from('perpus_bahan_pustaka');
                $this->db->join('perpus_lokasi', 'perpus_bahan_pustaka.id_lokasi=perpus_lokasi.id_lokasi', 'left');
                $this->db->join('perpus_status_item', 'perpus_bahan_pustaka.id_status_item=perpus_status_item.id_status_item', 'left');
                $this->db->join('perpus_jenis_pustaka', 'perpus_bahan_pustaka.id_jenis_pustaka=perpus_jenis_pustaka.id_jenis_pustaka', 'left');
                $this->db->join('perpus_biblio', 'perpus_bahan_pustaka.id_biblio=perpus_biblio.id_biblio', 'left');
                $this->db->join('perpus_sumber', 'perpus_bahan_pustaka.id_sumber=perpus_sumber.id_sumber', 'left');
        }elseif($table == 'perpus_pinjaman'){
                $this->db->select('perpus_pinjaman.*, perpus_anggota.nama');
                $this->db->from('perpus_pinjaman');
            //    $this->db->join('perpus_bahan_pustaka', 'perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv', 'left');
                $this->db->join('perpus_anggota', 'perpus_anggota.id_user=perpus_pinjaman.id_user', 'left');
        }elseif($table == 'perpus_pengembalian'){
                $this->db->select('perpus_pinjaman.*, perpus_anggota.nama');
                $this->db->from('perpus_pinjaman');
            //    $this->db->join('perpus_bahan_pustaka', 'perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv', 'left');
                $this->db->join('perpus_anggota', 'perpus_anggota.id_user=perpus_pinjaman.id_user', 'left');
        }elseif($table == 'perpus_perpanjangan'){
                $this->db->select('perpus_pinjaman.*, perpus_anggota.nama, perpus_perpanjangan.perpanjangan as perpanjangan_ke, perpus_perpanjangan.tanggal_perpanjangan, perpus_perpanjangan.tanggal_jatuh_tempo_perpanjangan, perpus_perpanjangan.id_perpanjangan');
                $this->db->from('perpus_pinjaman');
            //    $this->db->join('perpus_bahan_pustaka', 'perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv', 'left');
                $this->db->join('perpus_anggota', 'perpus_anggota.id_user=perpus_pinjaman.id_user', 'left');
                $this->db->join('perpus_perpanjangan', 'perpus_perpanjangan.id_pinjaman=perpus_pinjaman.id_pinjaman', 'left');
        }elseif($table == 'perpus_pelanggaran'){
                $this->db->select('perpus_pinjaman.*, perpus_anggota.nama, perpus_pelanggaran.*');
                $this->db->from('perpus_pinjaman');
            //    $this->db->join('perpus_bahan_pustaka', 'perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv');
                $this->db->join('perpus_anggota', 'perpus_anggota.id_user=perpus_pinjaman.id_user');
                $this->db->join('perpus_pelanggaran', 'perpus_pelanggaran.id_pinjaman=perpus_pinjaman.id_pinjaman');
        }elseif($table == 'perpus_pinjaman_ruangan'){
                $this->db->select('perpus_pinjaman_ruangan.*, perpus_anggota.nama, perpus_ruangan.*');
                $this->db->from('perpus_pinjaman_ruangan');
                $this->db->join('perpus_ruangan', 'perpus_ruangan.id_ruangan=perpus_pinjaman_ruangan.id_ruangan', 'left');
                $this->db->join('perpus_anggota', 'perpus_anggota.id_user=perpus_pinjaman_ruangan.id_user', 'left');
        }elseif($table == 'perpus_pinjaman_komputer'){
                $this->db->select('perpus_pinjaman_komputer.*, perpus_anggota.nama, perpus_komputer.*');
                $this->db->from('perpus_pinjaman_komputer');
                $this->db->join('perpus_komputer', 'perpus_komputer.id_komputer=perpus_pinjaman_komputer.id_komputer', 'left');
                $this->db->join('perpus_anggota', 'perpus_anggota.id_user=perpus_pinjaman_komputer.id_user', 'left');
        }elseif($table == 'perpus_perbaikan'){
                $this->db->select('perpus_perbaikan.*, perpus_bahan_pustaka.id_biblio, perpus_biblio.judul');
                $this->db->from('perpus_bahan_pustaka');
                $this->db->join('perpus_perbaikan', 'perpus_perbaikan.kode_inv=perpus_bahan_pustaka.kode_inv');
                $this->db->join('perpus_biblio', 'perpus_biblio.id_biblio=perpus_bahan_pustaka.id_biblio');
        }elseif($table == 'perpus_kunjungan'){
                // $this->db->select('perpus_kunjungan.*, perpus_anggota.nama');
                // $this->db->from('perpus_kunjungan');
                // $this->db->join('perpus_anggota', 'perpus_anggota.id_user=perpus_kunjungan.id_user');
                $this->db->select('perpus_kunjungan.*, perpus_anggota.nama, perpus_instansi.nama AS instansi');
                $this->db->from('perpus_anggota');
                $this->db->join('perpus_kunjungan', 'perpus_anggota.id_user=perpus_kunjungan.id_user', 'RIGHT');
                $this->db->join('perpus_instansi', 'perpus_anggota.id_instansi=perpus_instansi.id_instansi', 'LEFT');
        }else{
            $this->db->from($table);
        }

        # khusus untuk view daftara pegnembalian
        if ($table == 'perpus_pengembalian') {
            $this->db->where('dikembalikan', '1');
            $this->db->where('perpus_pinjaman.status', '1');
        }elseif($table == 'perpus_perpanjangan') {
            $this->db->where('perpus_pinjaman.perpanjangan !=', '0');
        }
         
        $i = 0;
     
        foreach ($column_search as $item) // loop column 
        {
            if($_POST['search']['value']) // if datatable send POST for search
            {
                 
                if($i===0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                }
                else
                {
                    $this->db->or_like($item, $_POST['search']['value']);
                }
 
                if(count($column_search) - 1 == $i) //last loop
                {
                    $this->db->group_end(); //close bracket
                }
            }
            elseif ($search_external_value != '') { // untuk pencarian yang dari post luar
                
            	$this->db->where($item.' like', '%'.$search_external_value.'%');
            //  $this->db->like($item, $search_external_value);
            }
            $i++;
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } 
        else if(isset($order))
        {
            $order = $order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($table, $column_order, $column_search, $order, $search_external_value)
    {
        $this->_get_datatables_query($table, $column_order, $column_search, $order, $search_external_value);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
 
    function count_filtered($table, $column_order, $column_search, $order, $search_external_value)
    {
        $this->_get_datatables_query($table, $column_order, $column_search, $order, $search_external_value);
        $query = $this->db->get();
        return $query->num_rows();
    }

    function count_filtered2($table, $column_order, $column_search, $order, $search_external_value)
    {
        if($table == 'perpus_pinjaman'){
                $this->db->select('perpus_pinjaman.id_pinjaman');
                $this->db->from('perpus_pinjaman');
                $this->db->join('perpus_anggota', 'perpus_anggota.id_user=perpus_pinjaman.id_user', 'left');
        }elseif($table == 'perpus_pengembalian'){
                $this->db->select('perpus_pinjaman.id_pinjaman');
                $this->db->from('perpus_pinjaman');
                $this->db->join('perpus_anggota', 'perpus_anggota.id_user=perpus_pinjaman.id_user', 'left');
        }

        if ($search_external_value != '') {
            foreach ($column_search as $key => $item) {
                $this->db->where($item." like", "%".$search_external_value."%");
            }
            
        }
        
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all($table)
    {
        $this->db->from($table);
        return $this->db->count_all_results();
    }

    function getJoin1where($select, $tabel, $tabeljoin1, $idjoin1, $arraywhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1, 'left');
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin2where($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $arraywhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1, 'left');
        $this->db->join($tabeljoin2, $idjoin2, 'left');
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin3where($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $arraywhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1, 'left');
        $this->db->join($tabeljoin2, $idjoin2, 'left');
        $this->db->join($tabeljoin3, $idjoin3, 'left');
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin4where($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $tabeljoin4, $idjoin4, $arraywhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1, 'left');
        $this->db->join($tabeljoin2, $idjoin2, 'left');
        $this->db->join($tabeljoin3, $idjoin3, 'left');
        $this->db->join($tabeljoin4, $idjoin4, 'left');
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin5where($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $tabeljoin4, $idjoin4, $tabeljoin5, $idjoin5, $arraywhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1, 'left');
        $this->db->join($tabeljoin2, $idjoin2, 'left');
        $this->db->join($tabeljoin3, $idjoin3, 'left');
        $this->db->join($tabeljoin4, $idjoin4, 'left');
        $this->db->join($tabeljoin5, $idjoin5, 'left');
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin5($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $tabeljoin4, $idjoin4, $tabeljoin5, $idjoin5, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1, 'left');
        $this->db->join($tabeljoin2, $idjoin2, 'left');
        $this->db->join($tabeljoin3, $idjoin3, 'left');
        $this->db->join($tabeljoin4, $idjoin4, 'left');
        $this->db->join($tabeljoin5, $idjoin5, 'right');
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin1whereGroupLimit($select, $tabel, $tabeljoin1, $idjoin1, $arraywhere, $fieldgroup, $fieldorder, $jenis_orderby, $limit) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->where($arraywhere);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $this->db->limit($limit);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin2whereGroupLimit($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $arraywhere, $fieldgroup, $fieldorder, $jenis_orderby, $limit) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->where($arraywhere);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $this->db->limit($limit);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin2whereLimit($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $arraywhere, $fieldorder, $jenis_orderby, $limit) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $this->db->limit($limit);
        $query = $this->db->get();
        return $query->result();
    }

    function get_table($tabel) {
        $q = $this->db->query("SELECT ".$tabel);
        return $q->result();
    }

    function getPengarangBuku($id_biblio){
        $this->db->select("perpus_penulis.nama");
        $this->db->from("perpus_biblio_pengarang");
        $this->db->join("perpus_penulis", "perpus_penulis.id_penulis=perpus_biblio_pengarang.id_penulis");
        $this->db->where("id_biblio", $id_biblio);
        $this->db->order_by("id_jenis_kepengarangan", 'ASC');
        $query = $this->db->get();
        return $query->result_array();        
    }

    function truncate_table($tabel) {
        $q = $this->db->TRUNCATE($tabel);
        return $q;
    }

}
?>