<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_models extends CI_Model {	
    private $db2;

    function __construct(){
        parent::__construct();
        $this->db2 = $this->load->database('database_kedua',TRUE);
    }
	
	function getAll($tabel) {
		$q = $this->db->query("SELECT * FROM $tabel");
		return $q->result();
	}
	
	function getAllPaging($tabel, $limit, $jml) {
		//$q = $this->db->query("SELECT * FROM $tabel");
		$q = $this->db->query("SELECT * FROM $tabel $limit, $jml");
		return $q->result();
	}
	
	function getSpesific($tabel, $kondisi) {
		$q = $this->db->query("SELECT * FROM $tabel where $kondisi");
		return $q->result();	
	}

	function getDataByID($tabel, $kunci, $data) {
		$q = $this->db->query("SELECT * FROM $tabel WHERE $kunci='$data'");
		return $q->result();	
	}
	
	function getRows($tabel){
		$q = $this->db->query("SELECT * FROM $tabel");
		return $q->num_rows();
	}
	
	function get_data($select, $table, $where){       
        $query = 'SELECT '.$select.' FROM '.$table.' '.$where;
        $q = $this->db->query($query);
        return $q->result();
    }
	
	function getDataJoin($select,$table,$join){
		$q = $this->db->query("SELECT $select FROM $table $join");
		return $q->result();	
	} 
  
	function save_data($data, $table){
		//$this->db->db_set_charset('latin1', 'latin1_swedish_ci');
        $return = FALSE;
        if ($this->db->insert($table, $data)){
            $return = TRUE;
        }
         
        return $return;
    }

    function save_batch($data, $table){
        $return = FALSE;
        if ($this->db->insert_batch($table, $data)){
            $return = TRUE;
        }
         
        return $return;
    }
  
	function update_data($id, $field, $data, $table){
        $return = FALSE;
        $this->db->where($field, $id);
        if ($this->db->update($table, $data)){
            $return = TRUE;
        }
         
        return $return;
    }

    function update_batch($data, $table, $field){
        $return = FALSE;
        if ($this->db->update_batch($table, $data, $field)){
            $return = TRUE;
        }
         
        return $return;
    }    
  
	function delete_data($id, $field, $table){
        $return = FALSE;
        $this->db->where($field, $id);
        if ($this->db->delete($table)){
            $return = TRUE;
        }
         
        return $return;
    }
	
	function getEmployees($select, $table, $tablejoin, $id){
		$this->db->select($select);
		$this->db->from($table);
		//$this->db->join('trn_address', 'trn_address.employee_id = trn_employee.employee_id');
		$this->db->join($tablejoin, $id);
		$query = $this->db->get();
		return $query->result();
	}
	
	
	 function get_absensi() {
        $this->datatables->select('absensi_id, absensi.user_id as nrp, absensi.date as tanggal, absensi.time_in as masuk, absensi.time_out as pulang, pegawai.nama as nama');
        $this->datatables->from('absensi');
        $this->datatables->join('pegawai', 'absensi.user_id = pegawai.nrp');
    //    $this->datatables->add_column('view', '<a href="world/edit/$1">edit</a> | <a href="world/delete/$1">delete</a>', 'absensi_id');
    //	$this->datatables->group_by("absensi.user_id", "desc");
        return $this->datatables->generate();
    }

    function get_pegawai() {
        $this->datatables->select('pegawai.*, jabatan.*, sekolah.nama as nm_sekolah');
        $this->datatables->from('pegawai');
        $this->datatables->join('jabatan', 'jabatan.id_jabatan=pegawai.id_jabatan');
        $this->datatables->join('sekolah', 'sekolah.id_sekolah=pegawai.id_sekolah');

        //$this->datatables->add_column("view", "<a href='".base_url('pegawai/detail_pegawai/$1')."' ><i class='fa fa-search-plus'></i></a> <a href='".base_url('pegawai/edit_pegawai/$1')."' ><i class='fa fa-edit'></a>", 'nrp');
    //	$this->datatables->group_by("absensi.user_id", "desc");
        return $this->datatables->generate();
    }

	function getJoin1($select, $tabel, $tabeljoin, $idjoin, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin, $idjoin);
    	$this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
		return $query->result();
    }
	
	function getJoin2($select, $tabel, $tabeljoin1, $idjoin1,$tabeljoin2, $idjoin2, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
    	$this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
		return $query->result();
    }

    function getJoin3($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->join($tabeljoin3, $idjoin3);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin1where($select, $tabel, $tabeljoin, $idjoin, $arraywhere, $fieldorder, $jenis_orderby) {
        //$arraywhere = array('name !=' => $name, 'id <' => $id, 'date >' => $date);
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin, $idjoin);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }
	
	function getJoin2whereIn($select, $tabel, $tabeljoin1, $idjoin1,$tabeljoin2, $idjoin2, $fieldwhere, $idwhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->where_in($fieldwhere, $idwhere);
    	$this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
		return $query->result();
    }
	
	function getJoin2where($select, $tabel, $tabeljoin1, $idjoin1,$tabeljoin2, $idjoin2, $fieldwhere, $idwhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->where($fieldwhere, $idwhere);
    	$this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
		return $query->result();
    }

    function getJoin2whereLimit($select, $tabel, $tabeljoin1, $idjoin1,$tabeljoin2, $idjoin2, $fieldwhere, $idwhere, $fieldorder, $jenis_orderby, $limit) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->where($fieldwhere, $idwhere);
        $this->db->limit($limit);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getwhere($select, $tabel, $fieldwhere, $idwhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($fieldwhere, $idwhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }
    
    function getTabelwhere($select, $tabel, $arraywhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

     function getTabelGroup($select, $tabel, $arraywhere, $fieldgroup, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($arraywhere);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getTabelGroup1($select, $tabel, $arraywhere, $fieldgroup, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($arraywhere);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }


    function getTabelwhereOr($select, $tabel, $arraywhere, $orwhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($arraywhere); 
        $this->db->where($orwhere, NULL, FALSE);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getTabelOr($select, $tabel, $orwhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->or_where($orwhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }
    
    function getTabelOrWhere($select, $tabel, $orwhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->or_where($orwhere, NULL, FALSE);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin1whereOr($select, $tabel, $tabeljoin, $idjoin, $arraywhere, $orwhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin, $idjoin);
        $this->db->where($arraywhere);
        $this->db->or_where($orwhere, NULL, FALSE);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getSession($nrp, $cari){
        $q_cek_pegawai = $this->db->get_where('pegawai', array('nrp' => $nrp,'status_aktf' => 'Aktif'));
        if (count($q_cek_pegawai->result()) > 0) {
            foreach ($q_cek_pegawai->result() as $qcp) {
                $q_cek_jabatan = $this->db->get_where('jabatan', array('id_jabatan' => $qcp->id_jabatan));
                $q_cek_sekolah = $this->db->get_where('sekolah', array('id_sekolah' => $qcp->id_sekolah));

                if ($cari=="nama_pegawai"){
                    $nilai=$qcp->nama;
                } else if ($cari=="id_sekolah"){
                    $nilai=$qcp->id_sekolah;
                } else if ($cari=="id_jabatan"){
                     $nilai=$qcp->id_jabatan;
                } else if ($cari=="id_sekolah2"){
                    $nilai=$qcp->id_sekolah2;
                } else if ($cari=="id_jabatan2"){
                     $nilai=$qcp->id_jabatan2;
                } else if ($cari=="nama_jabatan"){
                    foreach ($q_cek_jabatan->result() as $qcj) {
                        $nilai=$qcj->nama_jabatan;
                    }
                } else if ($cari=="nama_sekolah"){
                    foreach ($q_cek_sekolah->result() as $qcs) {
                        $nilai=$qcs->nama;
                    }
                } else if ($cari=="jenjang"){
                    foreach ($q_cek_sekolah->result() as $qcs) {
                        $nilai=$qcs->id_jenjang;
                    }
                } 
            }
        }    
            return $nilai;
    }

    function getTabelOrder($select, $tabel, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getTabelAOrWhere($select, $tabel, $arrayor, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($arrayor);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }


    function tambahData($select, $tabel, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin3where($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $arraywhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->join($tabeljoin3, $idjoin3);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin3whereRows($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $arraywhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->join($tabeljoin3, $idjoin3);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->num_rows();
    }

    function getJoin4where($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $tabeljoin4, $idjoin4, $arraywhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->join($tabeljoin3, $idjoin3);
        $this->db->join($tabeljoin4, $idjoin4);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin4whereGroup($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $tabeljoin4, $idjoin4, $arraywhere, $fieldgroup, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->join($tabeljoin3, $idjoin3);
        $this->db->join($tabeljoin4, $idjoin4);
        $this->db->where($arraywhere);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getRowsWhere($select, $tabel, $fieldwhere, $idwhere, $fieldorder, $jenis_orderby){
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($fieldwhere, $idwhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $q = $this->db->get();
        return $q->num_rows();
    }

    function getRowsAWhere($select, $tabel, $arraywhere, $fieldorder, $jenis_orderby){
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $q = $this->db->get();
        return $q->num_rows();
    }
    
    function getRowsJoin1Where($select, $tabel, $tabeljoin1, $idjoin1, $arraywhere, $fieldorder, $jenis_orderby){
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $q = $this->db->get();
        return $q->num_rows();
    }

    function getRowsGroupJoin1Where($select, $tabel, $tabeljoin1, $idjoin1, $arraywhere, $fieldgroup, $fieldorder, $jenis_orderby){
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->where($arraywhere);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $q = $this->db->get();
        return $q->num_rows();
    }

    function getRowsJoin2Where($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $arraywhere, $fieldorder, $jenis_orderby){
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $q = $this->db->get();
        return $q->num_rows();
    }

    function getTableGroup($select, $tabel, $fieldgroup, $fieldorder, $jenis_orderby){
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getRowsGroup($select, $tabel, $fieldgroup, $fieldorder, $jenis_orderby){
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->num_rows();
    }

    function getwhereGroup($select, $tabel, $fieldwhere, $idwhere, $fieldgroup, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($fieldwhere, $idwhere);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }
     
    function getAwhereGroup($select, $tabel, $arraywhere, $fieldgroup, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($arraywhere);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin1Group($select, $tabel, $tabeljoin, $idjoin, $groupfield, $fieldorder, $jenis_orderby) {
        //$arraywhere = array('name !=' => $name, 'id <' => $id, 'date >' => $date);
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin, $idjoin);
        $this->db->group_by($groupfield);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin1whereGroup($select, $tabel, $tabeljoin, $idjoin, $arraywhere, $groupfield, $fieldorder, $jenis_orderby) {
        //$arraywhere = array('name !=' => $name, 'id <' => $id, 'date >' => $date);
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin, $idjoin);
        $this->db->where($arraywhere);
        $this->db->group_by($groupfield);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }


    function getJoin2Awhere($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $arraywhere, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin2AwhereGroup($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $arraywhere, $groupfield, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->where($arraywhere);
        $this->db->group_by($groupfield);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getJoin3AwhereGroup($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $arraywhere, $groupfield, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->join($tabeljoin1, $idjoin1);
        $this->db->join($tabeljoin2, $idjoin2);
        $this->db->join($tabeljoin3, $idjoin3);
        $this->db->where($arraywhere);
        $this->db->group_by($groupfield);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function no_urut($tabel){
        $jml_urut = $this->m_models->getRows($tabel);
        $jno=$jml_urut+1;
        if($jno < 10){
            $nourut = '000'.$jno;
        }else if($jno < 100){
            $nourut = '00'.$jno;
        }else if($jno < 1000){
            $nourut = '0'.$jno;
        }else {
            $nourut = $jno;
        }

        return $nourut;
    }


    //Nomor urut Kegiatan
    function no_urut_keg($tabel,$pkey){
        $jml_urut = $this->m_models->getRows($tabel);
        // Mengambil Karakter angka terakhir
        $durut = $this->m_models->getAll("$tabel order by $pkey desc limit 1");

        foreach ($durut as $drt){

            $jnom = $drt->$pkey;
        }
        $jml_urut = substr($jnom,3,4);

        $jno=$jml_urut+1;
        if($jno < 10){
            $nourut = '000'.$jno;
        }else if($jno < 100){
            $nourut = '00'.$jno;
        }else if($jno < 1000){
            $nourut = '0'.$jno;
        }else {
            $nourut = $jno;
        }

        return $nourut;
    }


    function no_urutGroup($tabel, $fieldgroup, $fieldorder){
        $jml_urut = $this->m_models->getRowsGroup("*", $tabel, $fieldgroup, $fieldorder, "asc");
        $jno=$jml_urut+1;
        if($jno < 10){
            $nourut = '000'.$jno;
        }else if($jno < 100){
            $nourut = '00'.$jno;
        }else if($jno < 1000){
            $nourut = '0'.$jno;
        }else {
            $nourut = $jno;
        }

        return $nourut;
    }

    //cek alur approval
    function cekAlurApp($hak_akses, $keterangan){
        if ($hak_akses == 1){
             $ket="approve1";
        } else {
            $arr1=array('pengajuan =' => $keterangan, 'approve1 =' => $hak_akses);
            $japp1 = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr1, "approval_alur.id_app", "asc");
            $arr2=array('pengajuan =' => $keterangan, 'approve2 =' => $hak_akses);
            $japp2 = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr2, "approval_alur.id_app", "asc");
            $arr3=array('pengajuan =' => $keterangan, 'approve3 =' => $hak_akses);
            $japp3 = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr3, "approval_alur.id_app", "asc");
            $arr4=array('pengajuan =' => $keterangan, 'approve4 =' => $hak_akses);
            $japp4 = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr4, "approval_alur.id_app", "asc");
            $arr5=array('pengajuan =' => $keterangan, 'approve5 =' => $hak_akses);
            $japp5 = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr5, "approval_alur.id_app", "asc");

            if ($japp1 != 0){
                $ket="approve1";
            } else if ($japp2 != 0){
                $ket="approve2";
            } else if ($japp3 != 0){
                $ket="approve3";
            } else if ($japp4 != 0){
                $ket="approve4";
            } else if ($japp5 != 0){
                $ket="approve5";
            }
        } 
        return $ket;
    }

    function alurApp($hak_akses, $keterangan, $id_sekolah){
        if ($hak_akses == 1){
             $ket="approve1";
        } else {
            $arr1=array('pengajuan =' => $keterangan, 'approve1 =' => $hak_akses, 'id_sekolah=' => $id_sekolah);
            $japp1 = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr1, "approval_alur.id_app", "asc");
            $arr2=array('pengajuan =' => $keterangan, 'approve2 =' => $hak_akses, 'id_sekolah=' => $id_sekolah);
            $japp2 = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr2, "approval_alur.id_app", "asc");
            $arr3=array('pengajuan =' => $keterangan, 'approve3 =' => $hak_akses, 'id_sekolah=' => $id_sekolah);
            $japp3 = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr3, "approval_alur.id_app", "asc");
            $arr4=array('pengajuan =' => $keterangan, 'approve4 =' => $hak_akses, 'id_sekolah=' => $id_sekolah);
            $japp4 = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr4, "approval_alur.id_app", "asc");
            $arr5=array('pengajuan =' => $keterangan, 'approve5 =' => $hak_akses, 'id_sekolah=' => $id_sekolah);
            $japp5 = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr5, "approval_alur.id_app", "asc");

            if ($japp1 != 0){
                $ket="approve1";
            } else if ($japp2 != 0){
                $ket="approve2";
            } else if ($japp3 != 0){
                $ket="approve3";
            } else if ($japp4 != 0){
                $ket="approve4";
            } else if ($japp5 != 0){
                $ket="approve5";
            }
        } 
        return $ket;
    }

    function cekAlurAppNext($hak_akses, $keterangan, $alurapp, $id_sekolah){
        $app=substr($alurapp,7); 
        $n=$app+1;
        $ap="Approve$n";
        $arr=array('pengajuan =' => $keterangan, $alurapp => $hak_akses, 'id_sekolah' => $id_sekolah, $ap .'!=' => '0');
        $japp = $this->m_models->getRowsJoin1Where("*", "approval_pengajuan", "approval_alur", "approval_alur.id_app=approval_pengajuan.id_app", $arr, "approval_alur.id_app", "asc");

        return $japp;
    }


    function delete_dataarray($data, $table){
        $return = FALSE;
        $this->db->where($data);
        if ($this->db->delete($table)){
            $return = TRUE;
        }
         
        return $return;
    }

    function getTabelSiswa($id_sekolah, $tabel){
        $CI =& get_instance();
        $CI->load->model('m_models');

        $ars = array('id_sekolah = ' => $id_sekolah);
        $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ars, "id_sekolah", "asc");
        foreach ($data['sekolah'] as $sklh){
            $data['jenjang'] = $this->m_models->getwhere("*", "jenjang_pendidikan", "id_jenjang", $sklh->id_jenjang, "id_jenjang", "asc");
            foreach ($data['jenjang']  as $jenjang) {
                $tabel= $tabel."_".strtolower($jenjang->nama_jenjang);
                return $tabel;
            }
        } 
    }


     function getTabelwhereLimit($select, $tabel, $arraywhere, $limit, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($arraywhere);
        $this->db->limit($limit); 
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->result();
    }

    function getRowswhereLimit($select, $tabel, $arraywhere, $limit, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($arraywhere);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $this->db->limit($limit); 
        $query = $this->db->get();
        return $query->num_rows();
    }


    //mendapatkan no transaksi jurnal
    function notransaksi_jurnal($id_sekolah){ 
        $ar=array('id_sekolah =' => $id_sekolah, "status_aktif = " => "on");
        $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "nama", "asc");
        $kode_jurnal=$data['sekolah'][0]->kode_jurnal;
        $comp=$kode_jurnal;
        $arrwhere = array('no_transaksi like' => "04/".$comp."-04/%"); 
        $data['s1'] = $this->m_models->getTabelwhereLimit("no_transaksi", "jurnal", $arrwhere, "1", "no_transaksi", "desc");
        $js1 = $this->m_models->getRowswhereLimit("no_transaksi", "jurnal", $arrwhere, "1", "no_transaksi", "desc");
        if ($js1 != 0){
            foreach ($data['s1'] as $j1) {
                $no_trans_terakhir = substr($j1->no_transaksi,17,5);
                $mtrans_b4 = substr($j1->no_transaksi,14,2);
                $ytrans_b4 = substr($j1->no_transaksi,11,2);
                //echo "<div class='alt-reg' center><label>No.Transaksi Terakhir ==> <b>$j1->no_transaksi</font></label></div>";
                $todayn = date("Y-m-d");
                $tahunn = substr($todayn,2,2);
                $blnn = substr($todayn,5,2);
                if($tahunn > $ytrans_b4){
                    $no_trans_terakhir1=1;
                }else if(($tahunn == $ytrans_b4)and($blnn > $mtrans_b4)){
                    $no_trans_terakhir1=1;
                }else if(($tahunn == $ytrans_b4)and($blnn == $mtrans_b4)) { 
                    $no_trans_terakhir1=$no_trans_terakhir+1;
                }
                //menambahkan angka nol
                if($no_trans_terakhir1 < 10) {
                    $notrans_t1 = '0000'.$no_trans_terakhir1;
                }else if($no_trans_terakhir1 < 100) {
                    $notrans_t1 = '000'.$no_trans_terakhir1;
                }else if($no_trans_terakhir1 < 1000){
                    $notrans_t1 = '00'.$no_trans_terakhir1;
                }else if($no_trans_terakhir1 < 10000){
                    $notrans_t1 = '0'.$no_trans_terakhir1;
                }else {
                    $notrans_t1 = $no_trans_terakhir1;
                }
            }
        } else {
          /*  $no_trans_terakhir = substr($j1->no_transaksi,16,5);
            $mtrans_b4 = substr($j1->no_transaksi,13,2);
            $ytrans_b4 = substr($j1->no_transaksi,10,2);
            //echo "<div class='alt-reg' center><label>No.Transaksi Terakhir ==> <b>$j1->no_transaksi</font></label></div>";
            $todayn = date("Y-m-d");
            $tahunn = substr($todayn,2,2);
            $blnn = substr($todayn,5,2);
            if($tahunn > $ytrans_b4){
                $no_trans_terakhir1=1;
            }else if(($tahunn == $ytrans_b4)and($blnn > $mtrans_b4)){
                $no_trans_terakhir1=1;
            }else if(($tahunn == $ytrans_b4)and($blnn == $mtrans_b4)){
                $no_trans_terakhir1=$no_trans_terakhir+1;
            } */
            $todayn = date("Y-m-d");
            $tahunn = substr($todayn,2,2);
            $blnn = substr($todayn,5,2);
                $no_trans_terakhir1=1;

            //menambahkan angka nol
            if($no_trans_terakhir1 < 10) {
                $notrans_t1 = '0000'.$no_trans_terakhir1;
            }else if($no_trans_terakhir1 < 100) {
                $notrans_t1 = '000'.$no_trans_terakhir1;
            }else if($no_trans_terakhir1 < 1000){
                $notrans_t1 = '00'.$no_trans_terakhir1;
            }else if($no_trans_terakhir1 < 10000){
                $notrans_t1 = '0'.$no_trans_terakhir1;
            }else {
                $notrans_t1 = $no_trans_terakhir1;
            }
        }
        $no_transaksi="04/$comp-04/$tahunn/$blnn/$notrans_t1"; 
        return $no_transaksi;    
    }


    //saldo jurnal
    function saldo_jurnal($akun, $id_tahun, $id_sekolah, $bulan){
        $arwherep1 = array('akun.id_akun =' => $akun);
            $data['akunp1'] = $this->m_models->getJoin1where("akun.*, rules_akun.debet, rules_akun.kredit, rules_akun.normal", "akun", "rules_akun", "rules_akun.id_akun=akun.id_akun",$arwherep1, "akun.id_akun", "asc");
            foreach ($data['akunp1'] as $akunp1){
                $arjurnal = array('id_tahun = ' => $id_tahun, 'id_sekolah = '=> $id_sekolah, 'approve1 ='=>'Approve', 'approve2 ='=>'Approve', 'approve3 ='=>'Approve', 'tgl like '=>"%".$bulan."%");
                $arorw = "(akun1 ='$akunp1->id_akun' or akun2 ='$akunp1->id_akun')";
                $data['pendapatan'] = $this->m_models->getTabelwhereOr("*", "jurnal", $arjurnal, $arorw, "tgl", "asc");
                $jml_pndpt=0; $Tawal=0;
                foreach ($data['pendapatan'] as $p){
                    $t1 = $akunp1->debet;
                    $t2 = $akunp1->kredit;
                    $normal = $akunp1->normal;
                    if ($akunp1->id_akun==$p->akun1){
                        $debet_awal9 = $p->debet1;  
                        $kredit_awal9 = $p->kredit1;
                        //mengatur operator
                        if(($t1 == '+')and($t2 == '-')) {
                            $awal = ($Tawal+$debet_awal9)-$kredit_awal9;
                        } else if(($t1 == '-')and($t2 == '+')) {
                            $awal = ($Tawal-$debet_awal9)+$kredit_awal9;
                        }
                    } else if ($akunp1->id_akun==$p->akun2){
                        $debet_awal9 = $p->debet2;  
                        $kredit_awal9 = $p->kredit2;
                        //mengatur operator
                        if(($t1 == '+')and($t2 == '-')){
                            $awal = ($Tawal+$debet_awal9)-$kredit_awal9;
                        }else if(($t1 == '-')and($t2 == '+')){
                            $awal = ($Tawal-$debet_awal9)+$kredit_awal9;
                        }
                    }
                    $jml_pndpt += $awal;       
                } 
            }
            return $jml_pndpt;
    }

    //laba rugi
    function labarugi($tahun, $id_jenjang_prs){
        $CI =& get_instance();
        $CI->load->model('m_models');
        if ($tahun != ""){
            //pendapatan
            $arwherep1 = array('akun.id_akun like ' => "4.1.1%");
            $data['akunp1'] = $this->m_models->getTabelwhere("*", "akun", $arwherep1, "id_akun", "asc");
            foreach ($data['akunp1'] as $akunp1){
                $jml_pndpt += $this->m_models->saldo_jurnal($akunp1->id_akun, $tahun, "PRS", $id_jenjang_prs); 
            }
            //beban
            $arwhereb1 = array('id_akun like ' => "5.1%");
            $data['akunb1'] = $this->m_models->getTabelwhere("*", "akun", $arwhereb1, "id_akun", "asc");
            foreach ($data['akunb1'] as $akunb1){
                $jml_beban += $this->m_models->saldo_jurnal($akunb1->id_akun, $tahun, "PRS", $id_jenjang_prs); 
            } 
            $lr = $jml_pndpt-$jml_beban;
            return $lr;
        }
    }
	
	//Update Data Lebih dari 1 kondisi
	function update_data2($array, $data, $table){
        $return = FALSE;
        $this->db->where($array);
        if ($this->db->update($table, $data)){
            $return = TRUE;
        }
         
        return $return;
    }
		
	function getAwhereGroupRows($select, $tabel, $arraywhere, $fieldgroup, $fieldorder, $jenis_orderby) {
        $this->db->select($select);
        $this->db->from($tabel);
        $this->db->where($arraywhere);
        $this->db->group_by($fieldgroup);
        $this->db->order_by($fieldorder, $jenis_orderby);
        $query = $this->db->get();
        return $query->num_rows();
    }
	
    function getDataByIDQ($tabel, $kunci, $data) {
        $q = $this->db->query("SELECT * FROM $tabel WHERE $kunci='$data'");
        return $q->num_rows();  
    }
    
    function getDbAll($tabel) {
        $q = $this->db2->query("SELECT * FROM $tabel");
        return $q->result();
    }

    function getJoin1whereDb2($select, $tabel, $tabeljoin, $idjoin, $arraywhere, $fieldorder, $jenis_orderby) {
        //$arraywhere = array('name !=' => $name, 'id <' => $id, 'date >' => $date);
        $this->db2->select($select);
        $this->db2->from($tabel);
        $this->db2->join($tabeljoin, $idjoin);
        $this->db2->where($arraywhere);
        $this->db2->order_by($fieldorder, $jenis_orderby);
        $query = $this->db2->get();
        return $query->result();
    }

   


}
?>
