<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Tabungan extends CI_Controller {
	function __construct() {
	    error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	function tabungan_siswa(){ 
	   $this->load->view('template/header');
	    $data[hak_akses]=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];

		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun1", "desc");
	   	$data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "desc");
	   // $data[thn_on]=$data['tahun'][0]->id_tahun;

		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE); 
		$kelas = $this->input->post('kelas', TRUE);
		$ex = explode("-", $this->input->post('idsekolah', TRUE));
		$data['ds']="$dari-$sampai";
		$id_sekolah = $ex[1];
		$ta = $ex[0];

		if (($dari != "") && ($sampai != "") && ($id_sekolah != "")&& ($kelas != "")){
			$data[id]="$ta-$kelas";
			$jnjg=db_jenjang($id_sekolah);
			$rbel="rombongan_belajar_".$jnjg;
			$sswa="siswa_".$jnjg;
			$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$kelas, $rbel.".id_tahun"=>$ta, $rbel.".id_sekolah"=>$id_sekolah);
		    $data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");

		    //pemasukan dan pengambilan tabungan
		    foreach ($data['rombel'] as $s){
		    	$ar = array('tanggal >='=>$dari, 'tanggal <='=>$sampai, 'id_siswa'=>$s->id_siswa, 'id_tahun'=>$ta, 'id_kelas'=>$kelas);
	   			$data['tab'] = $this->m_models->getTabelwhere("*", "k_tabungan_siswa", $ar, "tanggal", "asc");
	   			$saldo_awal=0; $jml_tabungan=0; $jml_ambil_tabungan=0;
	   			foreach ($data['tab'] as $t) {
	   				$saldo_awal += $t->saldo_awal;
	   				$jml_tabungan += $t->jml_tabungan;
	   				$jml_ambil_tabungan += $t->jml_ambil_tabungan;
	   				$data[saldo_awal][$s->id_siswa]=$saldo_awal;
	   				$data[jml_tabungan][$s->id_siswa]=$jml_tabungan;
	   				$data[jml_ambil_tabungan][$s->id_siswa]=$jml_ambil_tabungan;
	   			}
		    }


		} else {
			$this->session->set_flashdata('gagal_cari', 'Silahkan lakukan pencarian !!!');
		}

	    $this->load->view('tabungan/tabungansiswa', $data); 
	   	$this->load->view('template/footer');
  	}  

  	public function ceksekolah(){
		//$this->load->view('template/head');
		//$this->load->view('template/js');
  		//$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah");
		$tahun=$this->input->get('tahun', TRUE); 
		$data[tahun]=$tahun;

		$ex=explode("-", $this->input->get('id_sekolah', TRUE));
		$id_sekolah=$ex[1];
		$id_tahun=$ex[0];
		$data[id_sekolah]=$this->input->get('id_sekolah', TRUE);

		$ar_sklh = array('status_aktif' => 'on');
		if (($id_sekolah==1) or ($id_sekolah==2) or ($id_sekolah==3)){
			 $arorw = "(id_sekolah='$id_sekolah')";
		} else {
			 $arorw = "(id_sekolah='1' or id_sekolah='2' or id_sekolah='3')";
		}
	   
		$data[sekolah] = $this->m_models->getTabelwhereOr("*", "sekolah", $ar_sklh, $arorw, "nama", "asc");

		$ar = array('id_sekolah'=>$id_sekolah, 'id_tahun'=>$id_tahun);
	    $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ar, "nama_kelas", "asc");

		$this->load->view('tabungan/ceksekolah_tab', $data);
	}
	
	public function ambil_tabungan(){
		$this->load->view('template/header');
	    $nrp=$this->session->userdata['nrp'];
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah");
		$where=array('id_sekolah =' => $id_sekolah, 'akun.id_akun like'=>'1.1.1.%');
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");

		$id = $this->uri->segment(3);
		$ex=explode("-",$id);
		$data[ket] = $ex[3];
		$data[id_siswa] = $ex[2];
		$data[ta] = $ex[0];
		$data[kelas] = $ex[1];
		$this->load->view('tabungan/ambil_tabungan_siswa', $data);
	   	$this->load->view('template/footer');
	}


	public function simpan_ambil_tabungan(){
		$this->load->view('template/head');
		$this->load->view('template/js');

	    $nrp=$this->session->userdata['nrp'];
	    $ids=$this->input->post('ids');

		$id_siswa = $this->input->post('id_siswa', TRUE);
		$idsiswa = $this->input->post('idsiswa', TRUE);  

		$nominal = db_nominal($this->input->post('nominal', TRUE));
		$ta = $this->input->post('ta', TRUE);
		$kelas = $this->input->post('kelas', TRUE);
		$ex = explode("-", $this->input->post('tgl', TRUE));
		$tgl="$ex[2]-$ex[1]-$ex[0]";
		$akun = $this->input->post('akun', TRUE);
		$ket = $this->input->post('ket', TRUE);
		$id_sekolah = $this->input->post('id_sekolah', TRUE);

		$nrp_ajuan = $this->input->post('nrp', TRUE);
		if ($nrp_ajuan != ""){
			$ar_tab = array('nrp' => $nrp_ajuan, 'tanggal' => $tgl, 'jml_ambil_tabungan' => $nominal, 'id_tahun'=>$ta, 'id_sekolah'=>$id_sekolah, 'petugas'=>$nrp, 'sistem'=>$akun, 'ket_ambil'=>$ket); 
			$simpan = $this->m_models->save_data($ar_tab, "k_tabungan_guru");
		} else {
			$ar_tab = array('id_siswa' => $id_siswa, 'tanggal' => $tgl, 'jml_ambil_tabungan' => $nominal, 'id_tahun'=>$ta, 'id_kelas'=>$kelas, 'petugas'=>$nrp, 'sistem'=>$akun, 'ket_ambil'=>$ket); 
			$simpan = $this->m_models->save_data($ar_tab, "k_tabungan_siswa");
		}
		

		if($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    }else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		} 
		redirect('tabungan/tabungan_siswa'); 
	}

	public function detail_tabungan(){
		$this->load->view('template/header');

		$id = $this->uri->segment(3);
		$ds = $this->uri->segment(4);
		$ex=explode("-",$id);
		$data[ta] = $ex[0];
		$data[kelas] = $ex[1];
		$data[id_siswa] = $ex[2];
		$data[ket] = $ex[3];
		$data[id_sekolah] = $ex[4];
		$e=explode("-", $ds);
		$data[dari]="$e[0]-$e[1]-$e[2]";
		$data[sampai]="$e[3]-$e[4]-$e[5]"; 

		if ($ex[3]=="guru"){
			$ar_r = array('status_aktf =' => 'Aktif', "id_sekolah"=>$ex[4]);
			$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $ar_r, "nama", "asc");

			//pemasukan tabungan
			$ar = array('tanggal >='=>"$e[0]-$e[1]-$e[2]", 'tanggal <='=>"$e[3]-$e[4]-$e[5]", 'nrp'=>$ex[2], 'id_tahun'=>$ex[0], 'id_sekolah'=>$ex[4], 'jml_tabungan !=' => "0");
		   	$data['tab'] = $this->m_models->getTabelwhere("*", "k_tabungan_guru", $ar, "tanggal", "asc");

		   	//pengambilan tabungan
		   	$ar = array('tanggal >='=>"$e[0]-$e[1]-$e[2]", 'tanggal <='=>"$e[3]-$e[4]-$e[5]", 'nrp'=>$ex[2], 'id_tahun'=>$ex[0], 'id_sekolah'=>$ex[4], 'jml_ambil_tabungan !=' => "0");
		   	$data['ambil_tab'] = $this->m_models->getTabelwhere("*", "k_tabungan_guru", $ar, "tanggal", "asc");
		} else {
			$jnjg=db_siswa($ex[2]);
			$rbel="rombongan_belajar_".$jnjg;
			$sswa="siswa_".$jnjg;
			$id_sekolah=substr($ex[2], 0,3); 
			$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$ex[1], $rbel.".id_tahun"=>$ex[0], $rbel.".id_sekolah"=>$id_sekolah);
			$data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");

			//pemasukan tabungan
			$ar = array('tanggal >='=>"$e[0]-$e[1]-$e[2]", 'tanggal <='=>"$e[3]-$e[4]-$e[5]", 'id_siswa'=>$ex[2], 'id_tahun'=>$ex[0], 'id_kelas'=>$ex[1], 'jml_tabungan !=' => "0");
		   	$data['tab'] = $this->m_models->getTabelwhere("*", "k_tabungan_siswa", $ar, "tanggal", "asc");

		   	//pengambilan tabungan
		   	$ar = array('tanggal >='=>"$e[0]-$e[1]-$e[2]", 'tanggal <='=>"$e[3]-$e[4]-$e[5]", 'id_siswa'=>$ex[2], 'id_tahun'=>$ex[0], 'id_kelas'=>$ex[1], 'jml_ambil_tabungan !=' => "0");
		   	$data['ambil_tab'] = $this->m_models->getTabelwhere("*", "k_tabungan_siswa", $ar, "tanggal", "asc");

		}
		
		$this->load->view('tabungan/detail_tabungan_siswa', $data);
	   	$this->load->view('template/footer');
	}


	//input tabungan siswa
  	function masuk_tabungan_siswa(){ 
	   	$this->load->view('template/header');
	    $nrp=$this->session->userdata['nrp'];
	    $id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	    
	    $data[hak_akses]=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];
	    $ar_sklh = array('status_aktif' => 'on');

	    if (($id_sekolah == "8") or ($id_sekolah == "18")){
	    	$arorw = "(id_sekolah='1' or id_sekolah='2' or id_sekolah='3')";
	    } else {
	    	$arorw = "(id_sekolah='$id_sekolah')";
	    }
		$data[sekolah] = $this->m_models->getTabelwhereOr("*", "sekolah", $ar_sklh, $arorw, "nama", "asc");

	    $this->load->view('tabungan/input_tabungansiswa', $data); 
	   	$this->load->view('template/footer');
  	}

  	public function cek_sekolah(){
		$this->load->view('template/head');
		$this->load->view('template/js');

		$id_sekolah=$this->input->get('id_sekolah', TRUE);
		$kl=$this->input->get('kelas', TRUE);
		$data['id_sekolah']=$id_sekolah;
		$ex=explode("-", $kl);
		$idsekolah=$ex[0];
		$data['kls']=$ex[1]; 
		$id_tahun=ta_berjalan(); 

		$ar = array('id_sekolah'=>$id_sekolah, 'id_tahun'=>$id_tahun);
	    $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ar, "nama_kelas", "asc"); 

	    if ($kl != ""){ 
	    	$jnjg=db_jenjang($idsekolah); 
	    	$data['jenjang']=$jnjg;
			$rbel="rombongan_belajar_".$jnjg;
			$sswa="siswa_".$jnjg;
			if ($ex[1] != "guru"){
				$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$ex[1], $rbel.".id_tahun"=>$id_tahun, $rbel.".id_sekolah"=>$idsekolah);
				//$ar_r = array('status_aktif =' => 'Aktif');
			    $data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");
			} else {
				$data['karyawan'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' and id_sekolah='$idsekolah' order by nama");
			}
	    }

		$this->load->view('tabungan/ceksekolah', $data);
	}

	public function simpan_tabungan_siswa(){
	    $nrp=$this->session->userdata['nrp'];
  		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah");

		$id_tahun=ta_berjalan(); 
		$tgl = date_db($this->input->post('tgl', TRUE));
		$kelas = $this->input->post('kelas', TRUE);
		$idsiswa = $this->input->post('id_siswa', TRUE);
		$nonrp = $this->input->post('nrp', TRUE);
		$no = $this->input->post('no', TRUE); 
		$idsekolah = $this->input->post('idsekolah', TRUE); 
			if ($kelas != ""){ 
				for ($j=0; $j < $no; $j++){ 
					$id_siswa=$idsiswa[$j]; 
					$no_nrp=$nonrp[$j]; 
					$nominal = db_nominal($this->input->post('nominal'.$id_siswa, TRUE)); 
					$nominal_kar = db_nominal($this->input->post('nominal'.$no_nrp, TRUE));  echo "$nominal_kar $no_nrp<br>";
					if (($nominal != 0)&&($id_siswa != 0)){ 
						$ar_pos = array('id_siswa' => $id_siswa, 'tanggal' => $tgl, 'jml_tabungan' => $nominal, 'id_tahun'=>$id_tahun, 'id_kelas'=>$kelas, 'petugas'=>$nrp); 
						$simpan = $this->m_models->save_data($ar_pos, "k_tabungan_siswa");
						
					}
					if (($nominal_kar != 0)&&($no_nrp != 0)){ 
						$ar_pos = array('nrp' => $no_nrp, 'tanggal' => $tgl, 'jml_tabungan' => $nominal_kar, 'id_tahun'=>$id_tahun, 'id_sekolah'=>$idsekolah, 'petugas'=>$nrp); 
						$simpan = $this->m_models->save_data($ar_pos, "k_tabungan_guru");
					}
				}
			}
		if($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
	    }else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('tabungan/masuk_tabungan_siswa'); 
	}

	public function download_tabungan_siswa(){
	    $this->load->view('template/header');
	    $data[hak_akses]=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];

		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun1", "desc");
	   	$data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "desc");

		$data['tahun_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data[thnon]=date("Y");

	   // $data[thn_on]=$data['tahun'][0]->id_tahun;

		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE); 
		$kelas = $this->input->post('kelas', TRUE);
		$submit = $this->input->post('submit', TRUE);
		$ex = explode("-", $this->input->post('idsekolah', TRUE));
		$data['ds']="$dari-$sampai";
		$id_sekolah = $ex[1];
		$ta = $ex[0];

		if (($dari != "") && ($sampai != "") && ($id_sekolah != "")&& ($kelas != "")){
			if ($submit=="bulanan"){
				$data[id]="$ta-$kelas";
				$jnjg=db_jenjang($id_sekolah);
				$rbel="rombongan_belajar_".$jnjg;
				$sswa="siswa_".$jnjg;
				$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$kelas, $rbel.".id_tahun"=>$ta, $rbel.".id_sekolah"=>$id_sekolah);
			    $data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");

			    //pemasukan dan pengambilan tabungan
			    foreach ($data['rombel'] as $s){
			    	$ar = array('tanggal >='=>$dari, 'tanggal <='=>$sampai, 'id_siswa'=>$s->id_siswa, 'id_tahun'=>$ta, 'id_kelas'=>$kelas);
		   			$data['tab'] = $this->m_models->getTabelwhere("*", "k_tabungan_siswa", $ar, "tanggal", "asc");
		   			$saldo_awal=0; $jml_tabungan=0; $jml_ambil_tabungan=0;
		   			foreach ($data['tab'] as $t) {
		   				$saldo_awal += $t->saldo_awal;
		   				$jml_tabungan += $t->jml_tabungan;
		   				$jml_ambil_tabungan += $t->jml_ambil_tabungan;
		   				$data[saldo_awal][$s->id_siswa]=$saldo_awal;
		   				$data[jml_tabungan][$s->id_siswa]=$jml_tabungan;
		   				$data[jml_ambil_tabungan][$s->id_siswa]=$jml_ambil_tabungan;
		   			}
			    }
			}
		}

		$this->load->view('tabungan/download_tabungan_siswa', $data); 
	   	$this->load->view('template/footer');
	}

	public function cetak_tabungan_siswa(){
	    $data[hak_akses]=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];

		$tgl = $this->input->post('tgl', TRUE);
		$bln = $this->input->post('bln', TRUE);
		$thn = $this->input->post('thn', TRUE); 
		$kelas = $this->input->post('kelas', TRUE);
		$submit = $this->input->post('submit', TRUE);
		$ex = explode("-", $this->input->post('idsekolah', TRUE));
		$id_sekolah = $ex[1];
		$ta = $ex[0];

		$data[id_sekolah]=$id_sekolah;
		$data[id_kelas]=$kelas;
		$data[id_tahun]=$ta;
		$data[tgl]=$tgl;
		if (($bln != "") && ($thn != "") && ($id_sekolah != "")&& ($kelas != "")){
			$data[id]="$ta-$kelas";
			$jnjg=db_jenjang($id_sekolah);
			$rbel="rombongan_belajar_".$jnjg;
			$sswa="siswa_".$jnjg;
			$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$kelas, $rbel.".id_tahun"=>$ta, $rbel.".id_sekolah"=>$id_sekolah);
			$data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");

			//pemasukan dan pengambilan tabungan
			foreach ($data['rombel'] as $s){
				if ($tgl == ""){
					for ($i=1; $i <= 31; $i++){ 
			    		$periode="$thn-$bln-$i";
			    		$ar = array('tanggal'=>$periode, 'id_siswa'=>$s->id_siswa, 'id_tahun'=>$ta, 'id_kelas'=>$kelas);
				   		$data['tab'][$i][$s->id_siswa] = $this->m_models->getTabelwhere("*", "k_tabungan_siswa", $ar, "tanggal", "asc");
				   		$data['jtab'][$i][$s->id_siswa] = $this->m_models->getRowsAWhere("*", "k_tabungan_siswa", $ar, "tanggal", "asc");
				   		foreach ($data['tab'][$i][$s->id_siswa] as $t){
							$data['total_jml_tabungan'][$i][$s->id_siswa] += $t->jml_tabungan;
							$data['total_jml_ambil_tabungan'][$i][$s->id_siswa] += $t->jml_ambil_tabungan;
						}
				   	}
				   	$bulansblm="$thn-$bln-01";
				} else {
					$periode="$thn-$bln-$tgl"; 
			    	$ar = array('tanggal'=>$periode, 'id_siswa'=>$s->id_siswa, 'id_tahun'=>$ta, 'id_kelas'=>$kelas);
			    	$data['tab'][$tgl][$s->id_siswa] = $this->m_models->getTabelwhere("*", "k_tabungan_siswa", $ar, "tanggal", "asc"); 
				  	$data['jtab'][$tgl][$s->id_siswa] = $this->m_models->getRowsAWhere("*", "k_tabungan_siswa", $ar, "tanggal", "asc");

				  	foreach ($data['tab'][$tgl][$s->id_siswa] as $t){
						$data['total_jml_tabungan'][$tgl][$s->id_siswa] += $t->jml_tabungan;
						$data['total_jml_ambil_tabungan'][$tgl][$s->id_siswa] += $t->jml_ambil_tabungan;
					}
				  	$bulansblm=$periode;
			   	}
		    	
			   	$ar_t = array('tanggal <'=>$bulansblm, 'id_siswa'=>$s->id_siswa, 'id_tahun'=>$ta, 'id_kelas'=>$kelas);
		   		$data['tab_t'] = $this->m_models->getTabelwhere("*", "k_tabungan_siswa", $ar_t, "tanggal", "asc");
		  		$saldo_awal_t=0; $jml_tabungan_t=0; $jml_ambil_tabungan_t=0;
	 			foreach ($data['tab_t'] as $t_t) {
	   				$saldo_awal_t += $t->saldo_awal;
		   			$jml_tabungan_t += $t->jml_tabungan;
		   			$jml_ambil_tabungan_t += $t->jml_ambil_tabungan;
		   			$data[saldo_akhir_t][$s->id_siswa]=($saldo_awal_t[$s->id_siswa]+$jml_tabungan_t[$s->id_siswa])-$jml_ambil_tabungan_t[$s->id_siswa];
		   		}
			}
		}

		$this->load->view('tabungan/cetak_tabungan_siswa', $data); 
	}


	#tabungan guru
	function tabungan_guru(){ 
	   $this->load->view('template/header');
	    $data[hak_akses]=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];

		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun1", "desc");
	   	$data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "desc");
	   // $data[thn_on]=$data['tahun'][0]->id_tahun;

		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE); 
		$ex = explode("-", $this->input->post('id_sekolah', TRUE));
		$data['ds']="$dari-$sampai";
		$id_sekolah = $ex[1];
		$data['id_sekolah']=$id_sekolah;
		$ta = $ex[0];
		if (($dari != "") && ($sampai != "") && ($id_sekolah != "")){
			$data[id]="$ta-$kelas";
			$ar_r = array('status_aktf =' => 'Aktif', "id_sekolah"=>$id_sekolah);
		    $data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $ar_r, "nama", "asc");

		    //pemasukan dan pengambilan tabungan
		    foreach ($data['pegawai'] as $s){ 
		    	$ar = array('tanggal >='=>$dari, 'tanggal <='=>$sampai, 'nrp'=>$s->nrp, 'id_tahun'=>$ta, 'id_sekolah'=>$id_sekolah);
	   			$data['tab'] = $this->m_models->getTabelwhere("*", "k_tabungan_guru", $ar, "tanggal", "asc");
	   			$saldo_awal=0; $jml_tabungan=0; $jml_ambil_tabungan=0;
	   			foreach ($data['tab'] as $t) {
	   				$saldo_awal += $t->saldo_awal;
	   				$jml_tabungan += $t->jml_tabungan;
	   				$jml_ambil_tabungan += $t->jml_ambil_tabungan; 
	   				$data[saldo_awal][$s->nrp]=$saldo_awal;
	   				$data[jml_tabungan][$s->nrp]=$jml_tabungan;
	   				$data[jml_ambil_tabungan][$s->nrp]=$jml_ambil_tabungan;
	   			}
		    }
		} else {
			$this->session->set_flashdata('gagal_cari', 'Silahkan lakukan pencarian !!!');
		}

	    $this->load->view('tabungan/tabunganguru', $data); 
	   	$this->load->view('template/footer');
  	}  

  	function laporan_tabungan(){ 
	   	$this->load->view('template/header');
	    $data[hak_akses]=$this->session->userdata['hak_akses'];
	    $nrp=$this->session->userdata['nrp'];

	    $data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun1", "desc");
	   	$data['tahun'] = $this->m_models->getwhere("*", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "desc");

	    $id_sekolah = $this->m_models->getSession($nrp, "id_sekolah");
		$ar_sklh = array('status_aktif' => 'on');
		if (($id_sekolah==1) or ($id_sekolah==2) or ($id_sekolah==3)){
			 $arorw = "(id_sekolah='$id_sekolah')";
		} else {
			 $arorw = "(id_sekolah='1' or id_sekolah='2' or id_sekolah='3')";
		}
	   
		$data[sekolah] = $this->m_models->getTabelwhereOr("*", "sekolah", $ar_sklh, $arorw, "nama", "asc");


		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE); 
		$ex = explode("-", $this->input->post('id_sekolah', TRUE));
		$data['ds']="$dari-$sampai";
		$ta=$ex[0];
		$idsekolah=$ex[1];
		$data['dari']=$dari;
		$data['sampai']=$sampai;
		if (($dari != "") && ($sampai != "") && ($idsekolah != "") && ($ta != "")){
			#menampilkan kelas
			$ak = array('id_tahun'=>$ta, 'id_sekolah'=>$idsekolah);
	   		$data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ak, "nama_kelas", "asc");
		    //pemasukan dan pengambilan tabungan
		    foreach ($data['kelas'] as $s){ 
		    	$ar = array('tanggal >='=>$dari, 'tanggal <='=>$sampai, 'id_tahun'=>$ta, 'id_kelas'=>$s->id_kelas);
	   			$data['tab'] = $this->m_models->getTabelwhere("*", "k_tabungan_siswa", $ar, "tanggal", "asc");
	   			$saldo_awal=0; $jml_tabungan=0; $jml_ambil_tabungan=0;
	   			foreach ($data['tab'] as $t) {
	   				$saldo_awal += $t->saldo_awal;
	   				$jml_tabungan += $t->jml_tabungan;
	   				$jml_ambil_tabungan += $t->jml_ambil_tabungan;
	   				$data[saldo_awal][$s->id_kelas]=$saldo_awal;
	   				$data[jml_tabungan][$s->id_kelas]=$jml_tabungan;
	   				$data[jml_ambil_tabungan][$s->id_kelas]=$jml_ambil_tabungan;
	   			}
		    }
		} else {
			$this->session->set_flashdata('gagal_cari', 'Silahkan lakukan pencarian !!!');
		}

	    $this->load->view('tabungan/laporantabungan', $data); 
	   	$this->load->view('template/footer');
  	}  



}