<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Spo extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
		 error_reporting(0);
		 $this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
		$this->load->model('m_models');
        if (!isset($this->session->userdata['id_pengguna'])) {
            redirect(base_url("login"));
        }
    }

    private function changeTanggal($tgl)
    {

        $new_tgl = array();
        $new_date = str_replace(" ", "", $tgl);
        $new_date = explode("-", $new_date);
        if (count($new_date) == 1) {
            $tgl1 = $new_date[0];

            $tgl1 = implode("-", array_reverse(explode("-", (str_replace("/", "-", $tgl1)))));
            $new_tgl = array(
                'tgl1' => $tgl1,
                'tgl2' => ""
            );
        } else if (count($new_date) == 2) {
            $tgl1 = $new_date[0];
            $tgl2 = $new_date[1];

            $tgl1 = implode("-", array_reverse(explode("-", (str_replace("/", "-", $tgl1)))));
            $tgl2 = implode("-", array_reverse(explode("-", (str_replace("/", "-", $tgl2)))));
            $new_tgl = array(
                'tgl1' => $tgl1,
                'tgl2' => $tgl2
            );
        }

        return $new_tgl;
    }

    public function index()
    {
        $v = $this->load;
        $v->view("template/header");
        $v->view("template/footer");
    }

    function lihat_log()
    {
        // init var model
        $v = $this->load;
        $v->model("pegawai_model/pegawai_model");

        // ==========================
        $pgw = $this->pegawai_model;
        $data['pegawai'] = $pgw->pegawai_non_sekolah();
        $v->view("template/header");
        $v->view("spo/log_view", $data);
        $v->view("template/footer");
    }

    function datalogview()
    {
        //load model
        $this->load->model("spo/abs_log_model");

        // init 
        $mLog = $this->abs_log_model;
        $I = $this->input;

        $tgl = $I->post("tgl");
        $nrp = $I->post("nrp");
        $tgl = $this->changeTanggal($tgl);
        if ($nrp == null || $nrp == "") {
            $data['log'] = $mLog->getAll($tgl["tgl1"], $tgl["tgl2"], null);
        } else {
            $data['log'] = $mLog->getAll($tgl["tgl1"], $tgl["tgl2"], $nrp);
        }
        $this->load->view("spo/data_log_view", $data);
    }

    function shif_kerja()
    {

        // init 
        $this->load->model("pegawai_model/pegawai_model");
        $v = $this->load;
        $pgw = $this->pegawai_model;

        // ===============================================
        $data['divisi'] = $pgw->sekolah_non_sekolah();
        $v->view("template/header");
        $v->view("spo/shif_kerja", $data);
        $v->view("template/footer");
    }

    function simpan_shift_kerja()
    {
        // load model
        $this->load->model("spo/abs_shift_kerja_model");
        $mShift = $this->abs_shift_kerja_model;
        $ip = $this->input;

        // ========================================
        $id_sekolah = $ip->post("id_sekolah");
        $nama_shift_kerja = $ip->post("nama_shift_kerja");
        $jam_kerja_in = $ip->post("jam_kerja_in");
        $jam_kerja_out = $ip->post("jam_kerja_out");
        $scan_in_min = $ip->post("scan_in_min");
        $scan_in_max = $ip->post("scan_in_max");
        $scan_out_min = $ip->post("scan_out_min");
        $scan_out_max = $ip->post("scan_out_max");
        $durasi_kerja = $ip->post("durasi_kerja");

        if (
            $id_sekolah != "" &&
            $nama_shift_kerja != "" &&
            $jam_kerja_in != "00:00" &&
            $jam_kerja_out != "00:00" &&
            $scan_out_max != "00:00" &&
            $durasi_kerja != ""
        ) {
            $res = $mShift->input(
                $id_sekolah,
                $nama_shift_kerja,
                $jam_kerja_in,
                $jam_kerja_out,
                $scan_in_min,
                $scan_in_max,
                $scan_out_min,
                $scan_out_max,
                $durasi_kerja
            );

            if ($res == 0) {
                echo 0;
            } else {
                echo 1;
            }
        } else {
            echo 0;
        }
    }

    function dataShiftKerja()
    {
        // init
        $this->load->model("pegawai_model/pegawai_model");
        $mPgw = $this->pegawai_model;
        $v = $this->load;

        // ===============================
        $data['divisi'] = $mPgw->sekolah_non_sekolah();
        $v->view("template/header");
        $v->view("spo/data_shift_kerja", $data);
        $v->view("template/footer");
    }

    function tabelShiftKerja()
    {
        // init
        $this->load->model("spo/abs_shift_kerja_model");
        $mSk = $this->abs_shift_kerja_model;

        //==============================================
        $id_sekolah = $this->input->post("id_sekolah");
        $data = null;
        if ($id_sekolah != null || $id_sekolah != "") {
            $data['dataShift'] = $mSk->getDataWhere($id_sekolah);
            if (count($data['dataShift']) != 0) {
                $this->load->view("spo/table_shift_kerja", $data);
            } else {
                echo "<center><b>Data Tidak Ditemukan</b></center>";
            }
        } else {
            echo "<center><b>Data Tidak Ditemukan</b></center>";
        }
    }

    private function inTabelShiftKerja($id_sekolah)
    {
        // init
        $this->load->model("spo/abs_shift_kerja_model");
        $mSk = $this->abs_shift_kerja_model;

        //==============================================
        if ( $this->input->post("id_sekolah") != '') {
            $id_sekolah = $this->input->post("id_sekolah");
        }
        
        $data = null;
        if ($id_sekolah != null || $id_sekolah != "") {
            $data['dataShift'] = $mSk->getDataWhere($id_sekolah);
            if (count($data['dataShift']) != 0) {
                $this->load->view("spo/table_shift_kerja", $data);
            } else {
                echo "<center><b>Data Tidak Ditemukan</b></center>";
            }
        } else {
            echo "<center><b>Data Tidak Ditemukan</b></center>";
        }
    }

    function hapusDataShiftKerja()
    {
        //init 
        $this->load->model("spo/abs_shift_kerja_model");
        $mSk = $this->abs_shift_kerja_model;

        //=========================================
        $id_sekolah = $this->input->post("id_sekolah");
        $id_shift_kerja = $this->input->post("id_shift_kerja");

        $mSk->hapus($id_shift_kerja);
        $this->inTabelShiftKerja($id_sekolah);
    }

    function formEditShiftKerja()
    {
        //init 
        $this->load->model("spo/abs_shift_kerja_model");
        $mSk = $this->abs_shift_kerja_model;

        //=============================================
        $id_shift_kerja = $this->input->post("id_shift_kerja");
        $data['data'] = $mSk->getOneDataWhere($id_shift_kerja);
        $this->load->view("spo/form_edit_shift_kerja", $data);
    }
    function update_shift_kerja()
    {
        // load model
        $this->load->model('spo/Abs_jam_kerja_harian_model');
        $this->load->model("spo/abs_shift_kerja_model");
        $mShift = $this->abs_shift_kerja_model;
        $ip = $this->input;

        // ========================================
        $id_sekolah = $ip->post("id_sekolah");
        $id_shift_kerja = $ip->post("id_shift_kerja");
        $nama_shift_kerja = $ip->post("nama_shift_kerja");
        $jam_kerja_in = $ip->post("jam_kerja_in");
        $jam_kerja_out = $ip->post("jam_kerja_out");
        $scan_in_min = $ip->post("scan_in_min");
        $scan_in_max = $ip->post("scan_in_max");
        $scan_out_min = $ip->post("scan_out_min");
        $scan_out_max = $ip->post("scan_out_max");
        $durasi_kerja = $ip->post("durasi_kerja");
        $tanggal_berlaku = $ip->post("tanggal_berlaku");
        $tanggal_berlaku = to_Ymd($tanggal_berlaku);

        if (
            $id_shift_kerja != "" &&
            $nama_shift_kerja != "" &&
            $jam_kerja_in != "00:00" &&
            $jam_kerja_out != "00:00" &&
            $scan_out_max != "00:00" &&
            $durasi_kerja != ""
        ) {
            $res = $mShift->update(
                $id_shift_kerja,
                $nama_shift_kerja,
                $jam_kerja_in,
                $jam_kerja_out,
                $scan_in_min,
                $scan_in_max,
                $scan_out_min,
                $scan_out_max,
                $durasi_kerja
            );

            $shift_kerja = $this->abs_shift_kerja_model->getOneDataWhere($id_shift_kerja);
            # update data di jam kerja harian yang sudah di set shit sebelumnya
            $tanggal_hari_ini = date("Y-m-d");
            while ( strtotime($tanggal_berlaku ) <= strtotime($tanggal_hari_ini)) {

                $tgl_sekarang = $tanggal_berlaku;
                $tgl_besok = date("Y-m-d", strtotime('+1 day', strtotime($tgl_sekarang)));

                $jam_kerja_in = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_in;

                if (strtotime($shift_kerja[0]->jam_kerja_out) < strtotime($shift_kerja[0]->jam_kerja_in)) {
                    $jam_kerja_out = $tgl_besok." ".$shift_kerja[0]->jam_kerja_out;
                }else{
                    $jam_kerja_out = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_out;
                }

                $scan_in_min = $tgl_sekarang." ".$shift_kerja[0]->scan_in_min;

                if ($shift_kerja[0]->scan_in_max === '00:00:00') {
                    $scan_in_max = "0000-00-00 00:00:00";
                }elseif(strtotime($shift_kerja[0]->scan_in_max) < strtotime($shift_kerja[0]->scan_in_min) AND $shift_kerja[0]->scan_in_max != '00:00:00'){
                    $scan_in_max = $tgl_besok." ".$shift_kerja[0]->scan_in_max;
                }else{
                    $scan_in_max = $tgl_sekarang." ".$shift_kerja[0]->scan_in_max;
                }

                if ($shift_kerja[0]->scan_out_min === '00:00:00') {
                    $scan_out_min = "0000-00-00 00:00:00";
                }else{
                    $scan_out_min = $tgl_sekarang." ".$shift_kerja[0]->scan_out_min;
                }

                if(strtotime($shift_kerja[0]->scan_out_max) < strtotime($shift_kerja[0]->scan_in_min) ){
                    $scan_out_max = $tgl_besok." ".$shift_kerja[0]->scan_out_max;
                }else{
                    $scan_out_max = $tgl_sekarang." ".$shift_kerja[0]->scan_out_max;
                }

                $this->Abs_jam_kerja_harian_model->update_shift_kerja_by_id_shift(
                    $id_shift_kerja,
                    $nama_shift_kerja,
                    $jam_kerja_in,
                    $jam_kerja_out,
                    $scan_in_min,
                    $scan_in_max,
                    $scan_out_min,
                    $scan_out_max,
                    $tgl_sekarang
                );

                $tanggal_berlaku = date("Y-m-d", strtotime('+1 day', strtotime($tanggal_berlaku)));

            }

            if ($res == 0) {
                echo 0;
            } else {
                $this->inTabelShiftKerja($id_sekolah);
            }
        } else {
            echo 0;
        }
    }

    function updatePresensi()
    {
        // init
        $this->load->model("pegawai_model/pegawai_model");
        $mPg = $this->pegawai_model;
        $v = $this->load;

        $nik = $this->uri->segment('3');
        $tgl = $this->uri->segment('4') . "/" . $this->uri->segment('5') . "/" . $this->uri->segment('6');
        $nama ="";
        $nm = $mPg->getDataByID($nik);
        foreach($nm as $nm){
        $nama = $nm->nama;
        }
        //==================================

        $data['nrp'] = "";
        $data['nama'] = "";
        $data['tgl'] = "";

        if ($tgl != "" && $nama != "" && $nik != "") {
            $data['nrp'] =  $nik;
            $data['nama'] = $nama;
            $data['tgl'] =  $tgl;
        }
        $v->view("template/header");
        $v->view("spo/update_presensi",$data);
        $v->view("template/footer");
    }

    function showPegawai()
    {
        // init
        $this->load->model("pegawai_model/pegawai_model");
        $mPgw = $this->pegawai_model;

        //================================================
        $data['pegawai'] = $mPgw->pegawai_non_sekolah();
        $this->load->view("spo/table_pegawai", $data);
    }

    function logPresensiPegawai()
    {
        //load model
        $this->load->model("spo/abs_log_model");

        // init 
        $mLog = $this->abs_log_model;
        $I = $this->input;

        $tgl = $I->post("tanggal");
        $nrp = $I->post("nrp");
        $tgl = $this->changeTanggal($tgl);
        $data['log'] = $mLog->getLogPegawai($tgl['tgl1'], $nrp);
        $this->load->view("spo/data_log_view", $data);
    }

    function detaiPresensiManual()
    {
        //load model
        $this->load->model("spo/abs_jam_kerja_harian_model");

        // init 
        $mJKH = $this->abs_jam_kerja_harian_model;
        $I = $this->input;

        $tgl = $I->post("tanggal");
        $nrp = $I->post("nrp");
        $tgl = $this->changeTanggal($tgl);
        $data['detail'] = $mJKH->dataForPresensiManual($nrp, $tgl['tgl1']);

        $this->load->view("spo/table_detail_presensi_manual", $data);
    }

    function inputManualPresensi(){
        // init
        $this->load->model("spo/abs_log_model");
        $this->load->model("spo/abs_jam_kerja_harian_model");
        $mLog = $this->abs_log_model;
        $mJKH = $this->abs_jam_kerja_harian_model;
        $I = $this->input;

        //=============================
        $presensi = $I->post("presensi");
        $log_time1 = $I->post("log_time1");
        $log_time2 = $I->post("log_time2");
        $user_id = $I->post("nrp");
        $id = $I->post("id_jam_kerja");
        $tanggal = $I->post("tanggal");
        $tanggal = $this->changeTanggal($tanggal);
        $tanggal = $tanggal['tgl1'];
        $nik = $I->post("nik");

        // echo $log_time1.$log_time2;

        if($presensi !=""){
            if($presensi !="H"){
                $mJKH->updatePresensi($id,$nik,$tanggal,$presensi);
            }else{
                if($log_time1 !="" || $log_time1 !=null){
                    $mLog->inputManual($log_time1, $user_id);
                }
                if($log_time2 !="" || $log_time2 !=null){
                    $mLog->inputManual($log_time2, $user_id);
                }
                $mJKH->updatePresensi($id,$nik,$tanggal,"H");
            }
        }else{
            if($log_time1 !="" || $log_time1 !=null){
                $mLog->inputManual($log_time1, $user_id);
            }
            if($log_time2 !="" || $log_time2 !=null){
                $mLog->inputManual($log_time2, $user_id);
            }
            $mJKH->updatePresensi($id,$nik,$tanggal,"H");
        }
    }
}

/* End of file Spo.php */
