<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Simtitis extends CI_Controller {
	function __construct() {
		parent::__construct();

		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}

		$this->load->model('m_models');
	}

	# mengambil data sekolah yang ada simtitisnya
	public function getSekolahSimtitis(){
		$arraywhere=array('sekolah.kategori' => 'Sekolah', 'sekolah.simtitis' => 'Ya');
		return $this->m_models->getJoin1where("sekolah.id_sekolah, sekolah.nama, sekolah.id_jenjang, sekolah.kode_pengenal, sekolah.id_jenjang, jenjang_pendidikan.nama_jenjang", "sekolah","jenjang_pendidikan", "sekolah.id_jenjang=jenjang_pendidikan.id_jenjang", $arraywhere, "id_sekolah", "ASC");
	}

	# fungsi mengambil data siswa buat JS
	public function getsiswa(){
		$this->load->view('template/head');
		$sekolah=$this->input->get('sekolah'); 

		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		// $kode_sekolah = $exp[1].'%';
		// $id_sekolah = str_replace("0", "", $kode_sekolah);
		$id_sekolah = (int)$exp[1];

		# mencari tahun akademik yang sedang aktif
		$tahun_akademik = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $tahun_akademik[0]->id_tahun;
		
		#query data dari tabel rombel yang id sekolah dipilih dan id tahun akademik sedang aktif, join ke tabel siswa
		$arraywhere=array($tabel_rombel.".id_sekolah" => $id_sekolah, $tabel_rombel.".id_tahun" => $id_tahun);
		$data['siswa'] = $this->m_models->getJoin1where($tabel_siswa.".id_siswa, ".$tabel_siswa.".nis, ".$tabel_siswa.".nama_lengkap,".$tabel_rombel.".*", $tabel_rombel, $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", $arraywhere, "nama_lengkap", "ASC");

		$this->load->view('simtitis/data_siswa',$data);

		$this->load->view('template/js');
	}

	# fungsi mengambil semua data siswa buat JS
	public function getsiswaAll(){
		$this->load->view('template/head');
		$sekolah=$this->input->get('sekolah'); 

		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$kode_sekolah = $exp[1].'%';
		$id_sekolah = str_replace("0", "", $kode_sekolah);

		#query data dari tabel rombel yang id sekolah dipilih dan id tahun akademik sedang aktif, join ke tabel siswa
		$arraywhere=array($tabel_rombel.".id_sekolah" => $id_sekolah);
		$data['siswa'] = $this->m_models->getJoin1where($tabel_siswa.".id_siswa, ".$tabel_siswa.".nis, ".$tabel_siswa.".nama_lengkap,".$tabel_rombel.".*", $tabel_rombel, $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", $arraywhere, "nama_lengkap", "ASC");

		$this->load->view('simtitis/data_siswa',$data);

		$this->load->view('template/js');
	}

	# fungsi menampilkan data log pengambilan
	public function pengambilan(){
		$this->load->view('template/header');

		# ambil data dari post pencarian
		$sekolah = $this->input->post('sekolah', TRUE); 
		$tgl_dari = $this->input->post('dari', TRUE); 
		$tgl_sampai = $this->input->post('sampai', TRUE); 
		$finance = $this->input->post('finance', TRUE); 

		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$kode_sekolah = $exp[1].'%';

		if ($tgl_dari!= null AND $tgl_sampai != null) {
			$arrWhere=array('log_tarik_simtitis.date >=' => $tgl_dari, 'log_tarik_simtitis.date <=' => $tgl_sampai, 'log_tarik_simtitis.user_id like ' => $kode_sekolah);
			if ($finance != 'semua_finance') {
				$arrWhere['log_tarik_simtitis.finance'] = $finance;
			}
		
			$data['tarik'] = $this->m_models->getJoin2where("log_tarik_simtitis.*,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk,".$tabel_siswa.".nis, pegawai.nama","log_tarik_simtitis", $tabel_siswa,"log_tarik_simtitis.user_id=".$tabel_siswa.".id_siswa","pegawai", "log_tarik_simtitis.finance=pegawai.nrp",$arrWhere,"", "date","asc");
		}

		# ambil data sekolah yang ada simtitisnya
		$data['sekolah'] = $this->getSekolahSimtitis();

		# ambil finance yg pernah ada
		$data['finance'] = $this->m_models->get_data("pegawai.nrp, pegawai.nama", "log_tarik_simtitis", "JOIN pegawai ON log_tarik_simtitis.finance=pegawai.nrp GROUP BY finance ORDER BY nama ASC");

		# tampilkan data
		$this->load->view('simtitis/data_pengambilan', $data); 

		$this->load->view('template/footer');
	}

	public function input_pengambilan(){
		$this->load->view('template/header');

		# ambil nrp user untuk mengisi finance tabel simtitis
		$nrp = $this->session->userdata['nrp'];

		# ambil data sekolah yang ada simtitisnya
		$data['sekolah'] = $this->getSekolahSimtitis();
		$this->load->view('simtitis/input_pengambilan',$data);

		# ambil data dari post input data
		$id_siswa = $this->input->post('id_siswa', TRUE);
        $sekolah  = $this->input->post('sekolah', TRUE);
        $tanggal  = date_db($this->input->post('tanggal', TRUE));
        $jam  = time_db($this->input->post('jam', TRUE));
        $nominal  = str_replace('.', '', $this->input->post('nominal', TRUE));
        $keterangan_ori  = $this->input->post('keterangan', TRUE);
        $keterangan = preg_replace("/[^a-zA-Z0-9\-\(\)\/\ ]/", "", $keterangan_ori);

		# pecah data untuk mendaptakn table siswa dan id_sekolah
        $exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$kode_sekolah = $exp[1].'%';

		# cek data transaksi siswa di tanggal yang di input, jika belum ada simpan, karenya hanya 1 transaksi setiap harinya
        //$jumlah_data = $this->m_models->getRows("log_tarik_simtitis WHERE user_id='$id_siswa' AND date='$tanggal'");
	    $saldo_akhir = 0;
		# ambil saldo santri
		$u_simtitis = $this->m_models->getDataByID('unit_simtitis', 'user_id', $id_siswa);
		foreach ($u_simtitis as $key) {
			$saldo_akhir = $key->saldo;
		}


        if ($id_siswa != null AND $keterangan != null) {
	        if ($nominal <= $saldo_akhir) {
	        	# buat no transaksi
		       	$id = date('ymdHis');
		        //$id_log = substr($id_siswa, 0, 3) . $id;
		        $id_log =  $id . rand(10,99);
		        # data yang akan disimpan
		        $data = array (
		            'log_tarik_id' => $id_log,
		            'user_id'  => $id_siswa,
		            'date'  => $tanggal,
		            'time'  => $jam,
		            'nominal_tarik'=> $nominal,
		            'finance' => $nrp,
		            'verifikasi' => 'M',
		            'keterangan' => $keterangan,
		            'no_transaksi' => '',
		            'sinkronisasi' => '1' 
		        );
		        # proses simpan
		    	if ($this->m_models->save_data($data,"log_tarik_simtitis") == TRUE) {
		    		$saldo = NULL;
		    		# update data saldo di table unit_simtitis kalo udah ada, kalo belum insert
		    		$simtitis = $this->m_models->getDataByID('unit_simtitis', 'user_id', $id_siswa);
		    		foreach ($simtitis as $key) {
		    			$saldo = $key->saldo;
		    		}

		    		if ($saldo != NULL) {
			    		$saldo_akhir = $saldo - $nominal;

					    $data = array (
					        'user_id' => $id_siswa,
					        'saldo'=> $saldo_akhir
					    );

			    		$this->m_models->update_data($id_siswa, 'user_id', $data, "unit_simtitis");
		    		}else{
					    $data = array (
					        'user_id' => $id_siswa,
					        'unit_simtitis' => '00',
					        'saldo'=> $nominal
					    );

			    		$this->m_models->save_data($data, "unit_simtitis");
		    		}

		    		$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    	}else{
		    		$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		    	}
		    	# tampilkan data yang baru disimpan berdasarkan tanggal yang sama dan kode sekolah yang sama yang verif manual
				$arrWhere=array('log_tarik_simtitis.verifikasi' => 'M', "log_tarik_simtitis.date " => $tanggal, 'log_tarik_simtitis.user_id like ' => $kode_sekolah);
				$data['tarik'] = $this->m_models->getJoin2where("log_tarik_simtitis.*,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk,".$tabel_siswa.".nis, pegawai.nama","log_tarik_simtitis", $tabel_siswa,"log_tarik_simtitis.user_id=".$tabel_siswa.".id_siswa","pegawai", "log_tarik_simtitis.finance=pegawai.nrp",$arrWhere,"", "log_tarik_id","asc");

	        }else{
	        	$this->session->set_flashdata('sudah_ada', 'Maaf, saldo santri tidak mencukupi');
	        }
    	}

		$this->load->view('simtitis/data_input_pengambilan', $data);

		$this->load->view('template/footer');		
	}


	public function get_siswa(){
		$this->load->view('template/head');
		$sekolah=$this->input->get('sekolah'); 

		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
	//	$kode_sekolah = $exp[1].'%';
	//	$id_sekolah = str_replace("0", "", $kode_sekolah);
		$id_sekolah = (int)$exp[1];
		$id_sekolah = $id_sekolah.'%';
		$data['idsiswa']="";

	//	echo $id_sekolah ." ".$id_sekolah2;

		# mencari tahun akademik yang sedang aktif
		$tahun_akademik = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
		$id_tahun = $tahun_akademik[0]->id_tahun;
		
		#query data dari tabel rombel yang id sekolah dipilih dan id tahun akademik sedang aktif, join ke tabel siswa
		$arraywhere=array($tabel_rombel.".id_sekolah" => $id_sekolah, $tabel_rombel.".id_tahun" => $id_tahun);
		$data['siswa'] = $this->m_models->getJoin1where($tabel_siswa.".id_siswa, ".$tabel_siswa.".nis, ".$tabel_siswa.".nama_lengkap,".$tabel_rombel.".*", $tabel_rombel, $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", $arraywhere, "nama_lengkap", "ASC");

		$this->load->view('simtitis/datasiswa',$data);

		$this->load->view('template/js');
	}

	public function get_detail(){
		$id_siswa=$this->input->get('id_siswa'); 
		$data['idsiswa'] = $id_siswa;
		//$data['riwayat'] = $this->m_models->get_data("*", "log_simpan_simtitis", "JOIN pegawai ON log_simpan_simtitis.finance=pegawai.nrp where id_siswa='$id_siswa' ORDER BY tgl_simpan desc limit 5");

		$this->load->view('simtitis/datasiswa',$data);
	}

	public function detail(){
		$this->load->view('template/header');
		$id_siswa = $this->uri->segment(3);
		//$data['riwayat'] = $this->m_models->get_data("*", "log_simpan_simtitis", "JOIN pegawai ON log_simpan_simtitis.finance=pegawai.nrp where id_siswa='$id_siswa' ORDER BY tgl_simpan desc limit 5");
		$arrWhere=array('log_simpan_simtitis.user_id' => $id_siswa);
		$jenjang=db_siswa($id_siswa);
		$tabel_siswa="siswa_".$jenjang;
		$data['simpan'] = $this->m_models->getJoin2where("log_simpan_simtitis.*,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk,".$tabel_siswa.".nis, pegawai.nama", "log_simpan_simtitis", 
			$tabel_siswa, "log_simpan_simtitis.user_id=".$tabel_siswa.".id_siswa",
			"pegawai", "log_simpan_simtitis.finance=pegawai.nrp",
				$arrWhere, "" ,"tgl_simpan","desc limit 4");

		$data['finance'] = $this->m_models->get_data("pegawai.nrp, pegawai.nama", "log_simpan_simtitis", "JOIN pegawai ON log_simpan_simtitis.finance=pegawai.nrp GROUP BY finance ORDER BY nama ASC");

		$this->load->view('simtitis/detail',$data);
		$this->load->view('template/footer');
	}

	

	# fungsi menampilkan data log simpanan
	public function simpanan(){
		$this->load->view('template/header');

		# ambil data dari post pencarian
		$sekolah = $this->input->post('sekolah', TRUE); 
		$tgl_dari = $this->input->post('dari', TRUE); 
		$tgl_sampai = $this->input->post('sampai', TRUE); 
		$finance = $this->input->post('finance', TRUE); 

		$data['sekolah_pilih'] = $sekolah; 
		$data['tgl_dari_pilih'] = $tgl_dari; 
		$data['tgl_sampai_pilih'] = $tgl_sampai; 
		$data['finance_pilih'] = $finance; 

		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$kode_sekolah = $exp[1].'%';

		# query pencarian berdasarkan form cari
		if ($tgl_dari!= null AND $tgl_sampai != null) {
			$arrWhere=array('log_simpan_simtitis.tgl_simpan >=' => $tgl_dari, 'log_simpan_simtitis.tgl_simpan <=' => $tgl_sampai, 'log_simpan_simtitis.user_id like ' => $kode_sekolah);
			if ($finance != 'semua_finance') {
				$arrWhere['log_simpan_simtitis.finance'] = $finance;
			}
			$data['simpan'] = $this->m_models->getJoin2where("log_simpan_simtitis.*,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk,".$tabel_siswa.".nis, pegawai.nama", "log_simpan_simtitis", 
				$tabel_siswa, "log_simpan_simtitis.user_id=".$tabel_siswa.".id_siswa",
				"pegawai", "log_simpan_simtitis.finance=pegawai.nrp",
				$arrWhere, "" ,"tgl_simpan","asc");
		}

		# ambil data sekolah yang ada simtitisnya
		$data['sekolah'] = $this->getSekolahSimtitis();

		$data['finance'] = $this->m_models->get_data("pegawai.nrp, pegawai.nama", "log_simpan_simtitis", "JOIN pegawai ON log_simpan_simtitis.finance=pegawai.nrp GROUP BY finance ORDER BY nama ASC");

		# tampilkan data
		$this->load->view('simtitis/data_penyimpanan', $data); 

		$this->load->view('template/footer');
	}

	# fungsi menampilkan data log simpanan
	public function simpanan_excel($sekolah_pilih, $tgl_dari_pilih, $tgl_sampai_pilih, $finance_pilih){
		# ambil data dari post pencarian
		$sekolah = $sekolah_pilih; 
		$tgl_dari = $tgl_dari_pilih; 
		$tgl_sampai = $tgl_sampai_pilih; 
		$finance = $finance_pilih; 

		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$kode_sekolah = $exp[1].'%';

		# query pencarian berdasarkan form cari
		if ($tgl_dari!= null AND $tgl_sampai != null) {
			$arrWhere=array('log_simpan_simtitis.tgl_simpan >=' => $tgl_dari, 'log_simpan_simtitis.tgl_simpan <=' => $tgl_sampai, 'log_simpan_simtitis.user_id like ' => $kode_sekolah);
			if ($finance != 'semua_finance') {
				$arrWhere['log_simpan_simtitis.finance'] = $finance;
			}
			$data['simpan'] = $this->m_models->getJoin2where("log_simpan_simtitis.*,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk,".$tabel_siswa.".nis, pegawai.nama", "log_simpan_simtitis", 
				$tabel_siswa, "log_simpan_simtitis.user_id=".$tabel_siswa.".id_siswa",
				"pegawai", "log_simpan_simtitis.finance=pegawai.nrp",
				$arrWhere, "" ,"tgl_simpan","asc");
		}

		# ambil data sekolah yang ada simtitisnya
		$data['sekolah'] = $this->getSekolahSimtitis();

		//$data['finance'] = $this->m_models->get_data("pegawai.nrp, pegawai.nama", "log_simpan_simtitis", "JOIN pegawai ON log_simpan_simtitis.finance=pegawai.nrp GROUP BY finance ORDER BY nama ASC");
		
		$sekol = $this->m_models->get_data("nama", "sekolah", "WHERE kode_pengenal='$exp[1]' ");
		foreach ($sekol as $key) {
			$nama_sekolah = $key->nama;
		}
		$data['sekolah_pilih'] = $nama_sekolah; 
		$data['tgl_dari_pilih'] = $tgl_dari_pilih; 
		$data['tgl_sampai_pilih'] = $tgl_sampai_pilih; 

		# tampilkan data
		$this->load->view('simtitis/data_penyimpanan_excel', $data); 
	}


	public function input_simpanan(){
		$this->load->view('template/header');

		# ambil nrp user untuk mengisi finance tabel simtitis
		$nrp = $this->session->userdata['nrp'];

		# ambil data sekolah yang ada simtitisnya
		$data['sekolah'] = $this->getSekolahSimtitis();

		# mengambil akun kas/bank untuk metode pembayaran 
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah"); 
		$ar_akun=array('status =' => "on", "id_sekolah = " => $id_sekolah, "akun.id_akun like " => "1.%");
       // $data['akun'] = $this->m_models->getJoin1where("akun.*, pilihan_akun.id_sekolah, pilihan_akun.status", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $ar_akun, "nama_akun", "asc");
		if ($nrp=="040016"){
			$data['akun'] = $this->m_models->get_data("akun.*, pilihan_akun.id_sekolah, pilihan_akun.status", "akun", "join pilihan_akun on pilihan_akun.id_akun=akun.id_akun where status='on' and (akun.id_akun = '2.1.1.06' or  akun.id_akun = '2.1.1.07' or akun.id_akun = '2.1.1.08' or akun.nama_akun like '%BANK%') group by akun.id_akun order by nama_akun asc");
		} else {
			//$data['akun'] = $this->m_models->get_data("akun.*, pilihan_akun.id_sekolah, pilihan_akun.status", "akun", "join pilihan_akun on pilihan_akun.id_akun=akun.id_akun where status='on' and (akun.id_akun = '2.1.1.06' or  akun.id_akun = '2.1.1.07' or akun.id_akun = '2.1.1.08') group by akun.id_akun order by nama_akun asc");
			//$data['akun'] = $this->m_models->get_data("*", "akun", "where id_akun in (SELECT id_akun FROM pilihan_akun WHERE id_sekolah='$id_sekolah' and status='on') and (akun.id_akun = '2.1.1.06' or  akun.id_akun = '2.1.1.07' or akun.id_akun = '2.1.1.08') order by nama_akun asc");
			$data['akun'] = $this->m_models->get_data("*", "akun", "where id_akun in (SELECT id_akun FROM pilihan_akun WHERE id_sekolah='$id_sekolah' and status='on' and (nama_akun like 'Teller%' or nama_akun like 'Bank%')) or (akun.id_akun = '2.1.1.06' or  akun.id_akun = '2.1.1.07' or akun.id_akun = '2.1.1.08') order by nama_akun asc");
		}

		# tampilkan form inputan
	    $this->load->view('simtitis/input_penyimpanan', $data);
       
		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$sekolah  = $this->input->post('sekolah', TRUE);
        $exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$kode_sekolah = $exp[1].'%';

		# ambil data dari post input data
		$akun2 = $this->input->post('akun', TRUE);
		$id_siswa = $this->input->post('id_siswa', TRUE);
        //$sekolah  = $this->input->post('sekolah', TRUE);
        $tanggal  = date_db($this->input->post('tanggal', TRUE));
        $nominal  = str_replace('.', '', $this->input->post('nominal', TRUE));

        if ($id_siswa != null) {
        	# buat kode transaksi
	       	$id = date('ymdHis');
	        //$id_log = substr($id_siswa, 0, 3) . $id;
	        $id_log =  $id . rand(101,999);
	        # mengambil no transaksi untuk ke jurnal
	        $no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah);

	        # data yang akan disimpan
	        $data = array (
	            'id_log_simpan' => $id_log,
	            'user_id'  => $id_siswa,
	            'tgl_simpan'  => $tanggal,
	            'nom_simpan'  => $nominal,
	            'finance' => $nrp,
	            'no_transaksi' => $no_transaksi,
	            'sinkronisasi' => '1'
	        );

	        # proses simpan
	    	if ($this->m_models->save_data($data,"log_simpan_simtitis") == TRUE) {
	    		$saldo = NULL;
	    		# update data saldo di table unit_simtitis kalo udah ada, kalo belum insert
	    		$simtitis = $this->m_models->getDataByID('unit_simtitis', 'user_id', $id_siswa);
	    		foreach ($simtitis as $key) {
	    			$saldo = $key->saldo;
	    		}

	    		if ($saldo != NULL) {
		    		$saldo_akhir = $saldo + $nominal;

				    $data = array (
				        'user_id' => $id_siswa,
				        'saldo'=> $saldo_akhir
				    );

		    		$this->m_models->update_data($id_siswa, 'user_id', $data, "unit_simtitis");
	    		}else{
				    $data = array (
				        'user_id' => $id_siswa,
				        'unit_simtitis' => '00',
				        'saldo'=> $nominal
				    );

		    		$this->m_models->save_data($data, "unit_simtitis");
	    		}

	    		//simpan ke jurnal
				$id_ta=ta_berjalan(); 
				$nama_siswa=ceknamasiswa($id_siswa);
				$uraian="Pembayaran SIMTITIS untuk siswa $nama_siswa";
		    	$ar_jurnal=array('tgl' => $tanggal, 'no_transaksi' => $no_transaksi, 'akun1' => "1.1.1.34", 'uraian1' => $uraian, 'debet1' => $nominal, 'kredit1' => '0', 'akun2' => $akun2, 'uraian2' => $uraian, 'debet2' => '0', 'kredit2' => $nominal, 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => "pembayaran simtitis", 'id_tahun'=>$id_ta, 'nrp'=>$nrp);
				$simpan=$this->m_models->save_data($ar_jurnal, 'jurnal');

	    		$this->session->set_flashdata('sukses', 'Data berhasil disimpan');



	    		$tombol = $this->input->post('tombol', TRUE); 

				if ($tombol=="simpan"){
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				} else if ($tombol=="simpanprint"){
					redirect('simtitis/print_bukti_transaksi/'.$id_siswa."/".$tanggal."/".$nrp);
				}


	    	//	redirect('simtitis/input_simpanan'); 
	    	}else{
	    		$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	//	redirect('simtitis/input_simpanan'); 
	    	}

	    	# tampilkan data yang baru disimpan berdasarkan tanggal yang sama dan kode sekolah 
			$arrWhere=array('log_simpan_simtitis.finance' => $nrp, "log_simpan_simtitis.tgl_simpan " => $tanggal);
			$data['simpanan'] = $this->m_models->getJoin2whereLimit("log_simpan_simtitis.*,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk,".$tabel_siswa.".nis, pegawai.nama","log_simpan_simtitis", $tabel_siswa, "log_simpan_simtitis.user_id=".$tabel_siswa.".id_siswa","pegawai", "log_simpan_simtitis.finance=pegawai.nrp",$arrWhere,"", "id_log_simpan","asc", "5");
	    }

		$this->load->view('simtitis/data_input_penyimpanan', $data);

	   	$this->load->view('template/footer');
	}

	# Resume Transaksi siswa per kelas
 	public function resume_trans_siswa(){
 		$this->load->view('template/header');

 		# ambil data dari form pencarian
		$sekolah = $this->input->post('sekolah', TRUE);
        $tahun_akademik = $this->input->post('tahun_akademik', TRUE);
        $bln = $this->input->post('bln', TRUE);
        $thn = $this->input->post('thn', TRUE);

     	# kirim data form buat selected form
     	$data['sekolahpilih'] = $sekolah;
     	$data['tapilih'] = $tahun_akademik;
        $data['bln'] = $bln;
        $data['thn'] = $thn;

        # membuat bulan tahun cari
        $thnbln = $thn.'-'.$bln;
        $thnblntgl = $thnbln.'-01';

       	# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$id_sekolah = $exp[1].'%';
		$kode_pengenal = $exp[2].'%';

		
		if ($sekolah != null AND $tahun_akademik != null AND $bln != null AND $thn != null) {

			# mencari data log pengambilan bulan cari
			if ($id_sekolah==40){
				$data_log_tarik = $this->m_models->get_data("user_id, SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date like '$thnbln%' AND (user_id like '$kode_pengenal' or user_id like '006%') GROUP BY user_id");
			} else {
				$data_log_tarik = $this->m_models->get_data("user_id, SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date like '$thnbln%' AND user_id like '$kode_pengenal' GROUP BY user_id");
			}
			
			# buat data log tarik berdasarkan id_siswa
			foreach ($data_log_tarik as $key) {
				$log_tarik[$key->user_id] = $key->nominal_tarik;
			}

			# mencari data log peyimpanan bulan cari
			if ($id_sekolah==40){
				$data_log_simpan = $this->m_models->get_data("user_id, SUM(nom_simpan) AS nominal_simpan", "log_simpan_simtitis", "WHERE tgl_simpan like '$thnbln%' AND (user_id like '$kode_pengenal%' or user_id like '006%') GROUP BY user_id");
			} else { 
				$data_log_simpan = $this->m_models->get_data("user_id, SUM(nom_simpan) AS nominal_simpan", "log_simpan_simtitis", "WHERE tgl_simpan like '$thnbln%' AND user_id like '$kode_pengenal%' GROUP BY user_id");
			}
			# buat data log tarik berdasarkan id_siswa
			foreach ($data_log_simpan as $key) {
				$log_simpan[$key->user_id] = $key->nominal_simpan;
			}

			# mencari data log pengambilan sebelum bulan cari 
			if ($id_sekolah==40){
				$data_log_tarik_dulu = $this->m_models->get_data("user_id, SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date < '$thnblntgl' AND (user_id like '$kode_pengenal' or user_id like '006%') GROUP BY user_id");
			} else {
				$data_log_tarik_dulu = $this->m_models->get_data("user_id, SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date < '$thnblntgl' AND user_id like '$kode_pengenal' GROUP BY user_id");
			}
			# buat data log tarik berdasarkan id_siswa
			foreach ($data_log_tarik_dulu as $key) {
				$log_tarik_dulu[$key->user_id] = $key->nominal_tarik;
			}

			# mencari data log peyimpanan sebelum bulan cari
			if ($id_sekolah==40){
				$data_log_simpan_dulu = $this->m_models->get_data("user_id, SUM(nom_simpan) AS nominal_simpan", "log_simpan_simtitis", "WHERE tgl_simpan < '$thnblntgl' AND (user_id like '$kode_pengenal' or user_id like '006%') GROUP BY user_id");
			} else {
				$data_log_simpan_dulu = $this->m_models->get_data("user_id, SUM(nom_simpan) AS nominal_simpan", "log_simpan_simtitis", "WHERE tgl_simpan < '$thnblntgl' AND user_id like '$kode_pengenal' GROUP BY user_id");
			}
			# buat data log tarik berdasarkan id_siswa
			foreach ($data_log_simpan_dulu as $key) {
				$log_simpan_dulu[$key->user_id] = $key->nominal_simpan;
			}

			$arrWhere=array($tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
			# cari data siswa dengan kriteria kondisi arrWhere di atas
			$siswa = $this->m_models->getJoin2where($tabel_rombel.".*,".$tabel_siswa.".nis,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk, kelas.nama_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas",  $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", $arrWhere,"", "id_siswa","asc");

			$jml_siswa = 0;

			foreach ($siswa as $key) {

				# membuat data array yang akan ditampilkan berdasarkan data yang didapat
				$arr_resume['id_siswa'][] = $key->id_siswa;
				$arr_resume['nis'][] = $key->nis;
 				$arr_resume['nama'][] = $key->nama_lengkap;
 				$arr_resume['kelas'][] = $key->nama_kelas;
 				$arr_resume['jk'][] = $key->jk;
 				# saldo awal hitung dengan mengurangi simpanan dengan pengambilan bulan dulu
 				$arr_resume['saldo_awal'][] = $log_simpan_dulu[$key->id_siswa] - $log_tarik_dulu[$key->id_siswa];
 				# simpanan bulan cari
 				$arr_resume['simpanan'][] = $log_simpan[$key->id_siswa];
 				# pengambilan bulan cari
 				$arr_resume['pengambilan'][] = $log_tarik[$key->id_siswa];
 				# saldo akhir bulan cari
 				$arr_resume['saldo_akhir'][] = $log_simpan_dulu[$key->id_siswa] - $log_tarik_dulu[$key->id_siswa] + $log_simpan[$key->id_siswa] -  $log_tarik[$key->id_siswa];

 				# hitung jumlah siswa
				$jml_siswa = $jml_siswa + 1;
			}

		}

 		# kirim dara lengkap
 		$data['resume'] = $arr_resume;
		# kirim dara jumlah row data
 		$data['jml_data'] = $jml_siswa;
		# kirim tabel siswanya
		$data['tabel_siswa'] = $tabel_siswa;
		# kirim tahun bulan cari
		$data['bulan_cari'] = $thnbln;

 		# ambil data sekolah yang ada simtitisnya
		$data['sekolah'] = $this->getSekolahSimtitis();

		# ambil data tahun akademik
		$data['ta'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");

		$this->load->view('simtitis/resume_trans_siswa', $data); 

		$this->load->view('template/footer');
	}

	function detail_trans_siswa($id_siswa, $tabel_siswa, $thnbln){
 		$this->load->view('template/header');
 		$thnblntgl = $thnbln.'-01';

 		# mencari data siswa
 		$siswa = $this->m_models->get_data('nis, nama_lengkap', $tabel_siswa, "WHERE id_siswa='$id_siswa'");
 		$data['nama'] = $siswa[0]->nama_lengkap; 		
 		$data['nis'] = $siswa[0]->nis;

		# mencari data log pengambilan sebelum bulan cari 
		$data_log_tarik_dulu = $this->m_models->get_data("user_id, SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date < '$thnblntgl' AND user_id like '$id_siswa' GROUP BY user_id");
		$jumlah_tarik = $data_log_tarik_dulu[0]->nominal_tarik;

		# mencari data log peyimpanan sebelum bulan cari
		$data_log_simpan_dulu = $this->m_models->get_data("user_id, SUM(nom_simpan) AS nominal_simpan", "log_simpan_simtitis", "WHERE tgl_simpan < '$thnblntgl' AND user_id like '$id_siswa' GROUP BY user_id");
		$jumlah_simpan = $data_log_simpan_dulu[0]->nominal_simpan;

		# menghitung saldo awal
 		$saldo_awal = $jumlah_simpan - $jumlah_tarik;
 		$jumlah_baris = 1;

 		# membuat data buat saldo awal tanggal 1 
 		$det['tanggal'][] = $thnblntgl;
 		$det['keterangan'][] = 'Saldo Awal';
 		$det['keuangan'][] = '';
 		$det['in'][] = '';
 		$det['out'][] = '';
 		$det['saldo'][] = $saldo_awal;

 		# buat perulangan dari tanggal 1 sampe max bulan 
 		for ($i=1; $i <= 31 ; $i++) { 
 			if ($i<10) {
 				$tanggal = $thnbln.'-0'.$i;
 			}else{
 				$tanggal = $thnbln.'-'.$i;
 			}

 			# mengisi data log simpanan
 			//$data['log_simpan'] = $this->m_models->getSpesific('log_simpan_simtitis', "user_id='$id_siswa' AND tgl_simpan='$tanggal'");
 			$data['log_simpan'] = $this->m_models->get_data("log_simpan_simtitis.*, pegawai.nama AS nama_keuangan", 'log_simpan_simtitis', "JOIN pegawai ON log_simpan_simtitis.finance=pegawai.nrp WHERE user_id='$id_siswa' AND tgl_simpan='$tanggal'");
 			foreach ($data['log_simpan'] as $key) {
 				$det['tanggal'][] = $tanggal;
 				$det['keterangan'][] = 'Setor Titipan';
 				$det['keuangan'][] = $key->nama_keuangan;
 				$det['in'][] = $key->nom_simpan;
 				$det['out'][] = '';
 				$saldo_awal += $key->nom_simpan;
 				$det['saldo'][] = $saldo_awal;
 				$jumlah_baris++;
 			}

 			# mengisi data log tarikan
 			//$data['log_tarik'] = $this->m_models->getSpesific('log_tarik_simtitis', "user_id='$id_siswa' AND date='$tanggal'");
 			$data['log_tarik'] = $this->m_models->get_data("log_tarik_simtitis.*, pegawai.nama AS nama_keuangan", 'log_tarik_simtitis', "JOIN pegawai ON log_tarik_simtitis.finance=pegawai.nrp WHERE user_id='$id_siswa' AND date='$tanggal'");
 			foreach ($data['log_tarik'] as $key) {
	 			# keterangan verifikasi
	 			if ($key->verifikasi == 'F') {
	 				$verifikasi = ' &bull; Verif Sidik Jari';
	 			}else{
	 				$verifikasi = ' &bull; Verif Manual';
	 			}
	 			# keterangan pengambilan
	 			if ($key->keterangan != null) {
	 				$keterangan = ' &bull; '.$key->keterangan ;
	 			}else{
	 				$keterangan = '';
	 			}
	 				
	 			$det['tanggal'][] = $tanggal;
	 			$det['keterangan'][] = 'Penarikan Tunai' . $verifikasi . $keterangan;
	 			$det['keuangan'][] = $key->nama_keuangan;
 				$det['in'][] = '';
 				$det['out'][] = $key->nominal_tarik;
 				$saldo_awal -= $key->nominal_tarik;
 				$det['saldo'][] = $saldo_awal;
 				$jumlah_baris++;
 			}
 		}

 		# kirim data buat di view
 		$data['det_resume'] = $det;
 		$data['jumlah_baris'] = $jumlah_baris;

		$this->load->view('simtitis/detail_trans_siswa', $data); 

		$this->load->view('template/footer');		
	}

	function resume_global(){
		$this->load->view('template/header');

		# ambil data dari form pencarian
		$tgl = $this->input->post('tgl', TRUE);
        $bln = $this->input->post('bln', TRUE);
        $thn = $this->input->post('thn', TRUE);

        # kirim data bulan dan tahun yang dipilih buat selected form
        $data['tgl'] = $tgl;
        $data['bln'] = $bln;
        $data['thn'] = $thn;

        # membuat bulan tahun cari
        //$thnbln = $thn.'-'.$bln;
        if ($tgl == '-') {
        	$thnbln = $thn.'-'.$bln;
        	$thnblntgl = $thnbln.'-01';
        }else{
        	$thnbln = $thn.'-'.$bln.'-'.sprintf("%02s", $tgl);
        	$thnblntgl = $thn.'-'.$bln.'-'.$tgl;
        }
        

        if ($bln != null AND $thn != null) {

			# ambil data sekolah yang ada simtitisnya
			$sekolah = $this->getSekolahSimtitis();
			$jml_sekolah = 0;

			foreach ($sekolah as $key) {
				# mencari data log pengambilan bulan cari
				$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date like '$thnbln%' AND user_id like '$key->kode_pengenal%'");
				$pengambilan = $data_log_tarik[0]->nominal_tarik;

				# mencari data log peyimpanan bulan cari
				$data_log_simpan = $this->m_models->get_data("SUM(nom_simpan) AS nominal_simpan", "log_simpan_simtitis", "WHERE tgl_simpan like '$thnbln%' AND user_id like '$key->kode_pengenal%'");
				$simpanan = $data_log_simpan[0]->nominal_simpan;

				# mencari data log pengambilan sebelum bulan cari 
				$data_log_tarik_dulu = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date < '$thnblntgl' AND user_id like '$key->kode_pengenal%'");
				$pengambilan_dulu = $data_log_tarik_dulu[0]->nominal_tarik;

				# mencari data log peyimpanan sebelum bulan cari
				$data_log_simpan_dulu = $this->m_models->get_data("SUM(nom_simpan) AS data_log_simpan_dulu", "log_simpan_simtitis", "WHERE tgl_simpan < '$thnblntgl' AND user_id like '$key->kode_pengenal%'");
				$simpanan_dulu = $data_log_simpan_dulu[0]->data_log_simpan_dulu;

				# mencari saldo awal
				$saldo_awal = $simpanan_dulu - $pengambilan_dulu;
				# mencari saldo akhir
				$saldo_akhir = $saldo_awal + $simpanan - $pengambilan;

				# hitung total
				$tot_saldo_awal += $saldo_awal;
				$tot_simpanan += $simpanan;
				$tot_pengambilan += $pengambilan;
				$tot_saldo_akhir += $saldo_akhir;

				# isi data array
				$arr_resume['nm_sekolah'][] = $key->nama;
				$arr_resume['saldo_awal'][] = $saldo_awal;
				$arr_resume['simpanan'][] = $simpanan;
				$arr_resume['pengambilan'][] = $pengambilan;
				$arr_resume['saldo_akhir'][] = $saldo_akhir;
				
				$jml_sekolah = $jml_sekolah+1;
			}
		}

		# menambahkan data total
		$data['tot_saldo_awal'] = $tot_saldo_awal;
		$data['tot_simpanan'] = $tot_simpanan;
		$data['tot_pengambilan'] = $tot_pengambilan;
		$data['tot_saldo_akhir'] = $tot_saldo_akhir;		

		#kirim jumlah data sekolah
		$data['jml_sekolah'] = $jml_sekolah;
		# kirim dara resume
		$data['resume'] = $arr_resume;

		$this->load->view('simtitis/resume_global', $data); 

		$this->load->view('template/footer');		
	}

	function resume_global_simtitis(){
		$this->load->view('template/header');

		# ambil data dari form pencarian
		$unit = $this->input->post('unit', TRUE);
		$tgl = $this->input->post('tgl', TRUE);
        $bln = $this->input->post('bln', TRUE);
        $thn = $this->input->post('thn', TRUE);

        # kirim data bulan dan tahun yang dipilih buat selected form
        $data['unit'] = $unit;
        $data['tgl'] = $tgl;
        $data['bln'] = $bln;
        $data['thn'] = $thn;

        # membuat bulan tahun cari
        //$thnbln = $thn.'-'.$bln;
        if ($tgl == '-') {
        	$thnbln = $thn.'-'.$bln;
        	$thnblntgl = $thnbln.'-01';
        }else{
        	$thnbln = $thn.'-'.$bln.'-'.sprintf("%02s", $tgl);
        	$thnblntgl = $thn.'-'.$bln.'-'.$tgl;
        }
        

        if ($bln != null AND $thn != null) {
        	if ($unit == 'sekolah') {
				# ambil data sekolah yang ada simtitisnya
				$sekolah = $this->getSekolahSimtitis();
				$jml_sekolah = 0;

				foreach ($sekolah as $key) {
					# mencari data log pengambilan bulan cari
					$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik, COUNT(*) AS jml_trans_tarik", "log_tarik_simtitis", "WHERE date like '$thnbln%' AND user_id like '$key->kode_pengenal%'");
					$pengambilan = $data_log_tarik[0]->nominal_tarik;
					$jml_trans_pengambilan = $data_log_tarik[0]->jml_trans_tarik;

					# mencari data log peyimpanan bulan cari
					$data_log_simpan = $this->m_models->get_data("SUM(nom_simpan) AS nominal_simpan, COUNT(*) AS jml_trans_simpan", "log_simpan_simtitis", "WHERE tgl_simpan like '$thnbln%' AND user_id like '$key->kode_pengenal%'");
					$simpanan = $data_log_simpan[0]->nominal_simpan;
					$jml_trans_simpanan = $data_log_simpan[0]->jml_trans_simpan;

					# mencari data log pengambilan sebelum bulan cari 
					$data_log_tarik_dulu = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date < '$thnblntgl' AND user_id like '$key->kode_pengenal%'");
					$pengambilan_dulu = $data_log_tarik_dulu[0]->nominal_tarik;

					# mencari data log peyimpanan sebelum bulan cari
					$data_log_simpan_dulu = $this->m_models->get_data("SUM(nom_simpan) AS data_log_simpan_dulu", "log_simpan_simtitis", "WHERE tgl_simpan < '$thnblntgl' AND user_id like '$key->kode_pengenal%'");
					$simpanan_dulu = $data_log_simpan_dulu[0]->data_log_simpan_dulu;

					# mencari saldo awal
					$saldo_awal = $simpanan_dulu - $pengambilan_dulu;
					# mencari saldo akhir
					$saldo_akhir = $saldo_awal + $simpanan - $pengambilan;

					# hitung total
					$tot_saldo_awal += $saldo_awal;
					$tot_simpanan += $simpanan;
					$tot_trans_simpanan += $jml_trans_simpanan;
					$tot_pengambilan += $pengambilan;
					$tot_trans_pengambilan += $jml_trans_pengambilan;
					$tot_saldo_akhir += $saldo_akhir;

					# isi data array
					$arr_resume['nm_sekolah'][] = $key->nama;
					$arr_resume['saldo_awal'][] = $saldo_awal;
					$arr_resume['simpanan'][] = $simpanan;
					$arr_resume['jml_trans_simpan'][] = $jml_trans_simpanan;
					$arr_resume['pengambilan'][] = $pengambilan;
					$arr_resume['jml_trans_pengambilan'][] = $jml_trans_pengambilan;
					$arr_resume['saldo_akhir'][] = $saldo_akhir;
					
					$jml_sekolah = $jml_sekolah+1;
				}
        	}else{
				# ambil data sekolah yang ada simtitisnya
				$simtitis = $this->m_models->getAll("simtitis ORDER BY id_simtitis");
				$jml_simtitis = 0;

				foreach ($simtitis as $key) {
					$query_add_log_tarik = '';
					$query_add_log_simpan = '';
					# filter tambahan untuk siswa id sekolah 40 dengan kode pengenal di id_siswa 006
					if ($key->kode_simtitis == '03' AND $key->kode_pengenal == '40') {
						$query_add_log_tarik = " OR log_tarik_simtitis.user_id like '006%' ";
						$query_add_log_simpan = " OR log_simpan_simtitis.user_id like '006%' ";
					}
					

					# mencari data log pengambilan bulan cari
					$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik, COUNT(*) AS jml_trans_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date like '$thnbln%' AND ( log_tarik_simtitis.user_id like '$key->kode_pengenal%' ".$query_add_log_tarik." ) AND unit_simtitis='$key->kode_simtitis' ");
					$pengambilan = $data_log_tarik[0]->nominal_tarik;
					$jml_trans_pengambilan = $data_log_tarik[0]->jml_trans_tarik;

					# mencari data log peyimpanan bulan cari
					$data_log_simpan = $this->m_models->get_data("SUM(nom_simpan) AS nominal_simpan, COUNT(*) AS jml_trans_simpan", "log_simpan_simtitis", "JOIN unit_simtitis ON log_simpan_simtitis.user_id=unit_simtitis.user_id WHERE tgl_simpan like '$thnbln%' AND (log_simpan_simtitis.user_id like '$key->kode_pengenal%' ".$query_add_log_simpan." ) AND unit_simtitis='$key->kode_simtitis'");
					$simpanan = $data_log_simpan[0]->nominal_simpan;
					$jml_trans_simpanan = $data_log_simpan[0]->jml_trans_simpan;

					# mencari data log pengambilan sebelum bulan cari 
					$data_log_tarik_dulu = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date < '$thnblntgl' AND (log_tarik_simtitis.user_id like '$key->kode_pengenal%' ".$query_add_log_tarik." ) AND unit_simtitis='$key->kode_simtitis'");
					$pengambilan_dulu = $data_log_tarik_dulu[0]->nominal_tarik;

					# mencari data log peyimpanan sebelum bulan cari
					$data_log_simpan_dulu = $this->m_models->get_data("SUM(nom_simpan) AS data_log_simpan_dulu", "log_simpan_simtitis", "JOIN unit_simtitis ON log_simpan_simtitis.user_id=unit_simtitis.user_id WHERE tgl_simpan < '$thnblntgl' AND (log_simpan_simtitis.user_id like '$key->kode_pengenal%' ".$query_add_log_simpan." ) AND unit_simtitis='$key->kode_simtitis'");
					$simpanan_dulu = $data_log_simpan_dulu[0]->data_log_simpan_dulu;

					# mencari saldo awal
					$saldo_awal = $simpanan_dulu - $pengambilan_dulu;
					# mencari saldo akhir
					$saldo_akhir = $saldo_awal + $simpanan - $pengambilan;

					# hitung total
					$tot_saldo_awal += $saldo_awal;
					$tot_simpanan += $simpanan;
					$tot_trans_simpanan += $jml_trans_simpanan;
					$tot_pengambilan += $pengambilan;
					$tot_trans_pengambilan += $jml_trans_pengambilan;
					$tot_saldo_akhir += $saldo_akhir;

					# isi data array
					$arr_resume['nm_unit_simtitis'][] = $key->nama_unit;
					$arr_resume['nm_sekolah'][] = $key->sekolah;
					$arr_resume['saldo_awal'][] = $saldo_awal;
					$arr_resume['simpanan'][] = $simpanan;
					$arr_resume['jml_trans_simpan'][] = $jml_trans_simpanan;
					$arr_resume['pengambilan'][] = $pengambilan;
					$arr_resume['jml_trans_pengambilan'][] = $jml_trans_pengambilan;
					$arr_resume['saldo_akhir'][] = $saldo_akhir;
					
					$jml_simtitis = $jml_simtitis+1;
				}
			}
		}

		# menambahkan data total
		$data['tot_saldo_awal'] = $tot_saldo_awal;
		$data['tot_simpanan'] = $tot_simpanan;
		$data['tot_trans_simpanan'] = $tot_trans_simpanan;
		$data['tot_pengambilan'] = $tot_pengambilan;
		$data['tot_trans_pengambilan'] = $tot_trans_pengambilan;
		$data['tot_saldo_akhir'] = $tot_saldo_akhir;		

		#kirim jumlah data sekolah
		$data['jml_sekolah'] = $jml_sekolah;
		# kirim dara resume
		$data['resume'] = $arr_resume;

		$this->load->view('simtitis/resume_global_simtitis', $data); 

		$this->load->view('template/footer');		
	}

	# fungsi menampilkan data log transaksi simtits bagi SISWA & ORTU
	public function log_transaksi(){
		$this->load->view('template/header');

		# ambil data dari post pencarian
		$tgl_dari = $this->input->post('dari', TRUE); 
		$tgl_sampai = $this->input->post('sampai', TRUE); 
		$id_siswa = $this->input->post('id_siswa', TRUE); 

		# query pencarian berdasarkan form cari
		if ($tgl_dari!= null AND $tgl_sampai != null) {
			# mencari data log pengambilan sebelum bulan cari 
			$data_log_tarik_dulu = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date < '$tgl_dari' AND user_id='$id_siswa'");
			$pengambilan_dulu = $data_log_tarik_dulu[0]->nominal_tarik;

			# mencari data log peyimpanan sebelum bulan cari
			$data_log_simpan_dulu = $this->m_models->get_data("SUM(nom_simpan) AS data_log_simpan_dulu", "log_simpan_simtitis", "WHERE tgl_simpan < '$tgl_dari' AND user_id='$id_siswa'");
			$simpanan_dulu = $data_log_simpan_dulu[0]->data_log_simpan_dulu;

			# mencari saldo awal
			$saldo_awal = $simpanan_dulu - $pengambilan_dulu;
	 		$jumlah_baris = 1;

	 		# membuat data buat saldo awal tanggal 1 
	 		$det['tanggal'][] = $tgl_dari;
	 		$det['keterangan'][] = 'Saldo Awal';
	 		$det['in'][] = '';
	 		$det['out'][] = '';
	 		$det['saldo'][] = $saldo_awal;

	 		# cari jumlah hari dari interval tanggal pencarian
	 		$start_date = new DateTime($tgl_dari);
			$end_date = new DateTime($tgl_sampai);
			$interval = $start_date->diff($end_date);
			$jml_hari = $interval->days;

	 		# isi var tanggal dengan tanggal pertala
	 		$tanggal = $tgl_dari;

	 		# buat perulangan dari tanggal 1 sampe max bulan 
	 		for ($i=0; $i <= $jml_hari; $i++) { 

	 			# mengisi data log simpanan
	 			$data['log_simpan'] = $this->m_models->getSpesific('log_simpan_simtitis', "user_id='$id_siswa' AND tgl_simpan='$tanggal'");
	 			foreach ($data['log_simpan'] as $key) {
	 				$det['tanggal'][] = $tanggal;
	 				$det['keterangan'][] = 'Setor Titipan';
	 				$det['in'][] = $key->nom_simpan;
	 				$det['out'][] = '';
	 				$saldo_awal += $key->nom_simpan;
	 				$det['saldo'][] = $saldo_awal;
	 				$jumlah_baris++;
	 			}

	 			# mengisi data log tarikan
	 			$data['log_tarik'] = $this->m_models->getSpesific('log_tarik_simtitis', "user_id='$id_siswa' AND date='$tanggal'");
	 			foreach ($data['log_tarik'] as $key) {
	 				# keterangan verifikasi
	 				if ($key->verifikasi == 'F') {
	 					$verifikasi = ' &bull; Verif Sidik Jari';
	 				}else{
	 					$verifikasi = ' &bull; Verif Manual';
	 				}
	 				# keterangan pengambilan
	 				if ($key->keterangan != null) {
	 					$keterangan = ' &bull; '.$key->keterangan ;
	 				}else{
	 					$keterangan = '';
	 				}
	 				
	 				$det['tanggal'][] = $tanggal;
	 				$det['keterangan'][] = 'Penarikan Tunai' . $verifikasi . $keterangan;
	 				$det['in'][] = '';
	 				$det['out'][] = $key->nominal_tarik;
	 				$saldo_awal -= $key->nominal_tarik;
	 				$det['saldo'][] = $saldo_awal;
	 				$jumlah_baris++;
	 			}

	 			# mencari tanggal berikutnya
	 			$tanggal = date('Y-m-d', strtotime('+1 day', strtotime($tanggal)));
	 		}

	 		# kirim data buat di view
	 		$data['det_resume'] = $det;
	 		$data['jumlah_baris'] = $jumlah_baris;
		}

		# cek user yang mengakses
		$data['hak_akses'] = $this->session->userdata['hak_akses'];
		//coba manual
		$data['hak_akses'] = 'ada';

		# jika yang membuka siswa
		if ($data['hak_akses'] == 'siswa') {
			# ambil id_siswa dari sesion login
			//$id_siswa = $this->session->userdata['id_siswa'];
			//$data['id_siswa'] = $id_siswa;
			$data['id_siswa'] = '006151610006';
		# jika yang membuka ortu
		}elseif ($data['hak_akses'] == 'ortu') {
			# cari siswa dari orang tua login
			$data['siswa'] = $this->getAnakSekolah('171810004');
			$data['jml_anak'] = count($data['siswa']['id_siswa']);
		# jika yang membuka admin atau yang lainnya
		}else{
			$data['sekolah'] = $this->getSekolahSimtitis();
		}

		# tampilkan data
		$this->load->view('simtitis/log_transaksi_siswa', $data); 

		$this->load->view('template/footer');
	}

	function log_transaksi2(){
		$this->load->view('template/header');
		
		# cek user yang mengakses
		$data['hak_akses'] = $this->session->userdata['hak_akses'];
		//coba manual
		$data['hak_akses'] = 'ada';

		# jika yang membuka siswa
		if ($data['hak_akses'] == 'siswa') {
			# ambil id_siswa dari sesion login
			//$id_siswa = $this->session->userdata['id_siswa'];
			//$data['id_siswa'] = $id_siswa;
			$data['id_siswa'] = '006151610006';
		# jika yang membuka ortu
		}elseif ($data['hak_akses'] == 'ortu') {
			# cari siswa dari orang tua login
			$data['siswa'] = $this->getAnakSekolah('171810004');
			$data['jml_anak'] = count($data['siswa']['id_siswa']);
		# jika yang membuka admin atau yang lainnya
		}else{
			$data['sekolah'] = $this->getSekolahSimtitis();
		}

		# tampilkan data ke view
		$this->load->view('simtitis/log_transaksi_simtitis', $data); 

		$this->load->view('template/footer');
	}	

		# fungsi mengambil semua data siswa buat JS
	public function getsiswaAll2(){
		$this->load->view('template/head');
		$sekolah=$this->input->get('sekolah'); 

		# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$kode_sekolah = $exp[1].'%';
		//$id_sekolah = str_replace("0", "", $kode_sekolah); echo "$kode_sekolah==$sekolah";
		$id_sekolah = all("sekolah", "kode_pengenal", $exp[1], "id_sekolah");

		#query data dari tabel rombel yang id sekolah dipilih dan id tahun akademik sedang aktif, join ke tabel siswa
		$arraywhere=array($tabel_rombel.".id_sekolah" => $id_sekolah);
		$data['siswa'] = $this->m_models->getJoin1whereGroup($tabel_siswa.".id_siswa, ".$tabel_siswa.".nis, ".$tabel_siswa.".nama_lengkap,".$tabel_rombel.".*", $tabel_rombel, $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", $arraywhere, $tabel_rombel.".id_siswa", "nama_lengkap", "ASC");

		$this->load->view('simtitis/data_siswa2',$data);

		$this->load->view('template/js');
	}

	function log_transaksi_simtitis_html(){
		$this->load->view('template/head');
		//$posted  = $this->input->post(); 
		//var_dump($posted);
		# ambil data dari post pencarian
		$periode = $this->input->post('periode', TRUE);
		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$tgl_dari = shortdate_indo2($tanggal['tanggal1']);
		$tgl_sampai = shortdate_indo2($tanggal['tanggal2']);
		$data['tanggal1'] = $tgl_dari;
		$data['tanggal2'] = $tgl_sampai;


		//$tgl_dari = $this->input->post('dari', TRUE); 
		//$tgl_sampai = $this->input->post('sampai', TRUE); 
		$id_siswa = $this->input->post('id_siswa', TRUE); 
		$export_excel = $this->input->post('export_excel', TRUE);

		# query pencarian berdasarkan form cari
		//if ($tgl_dari!= null AND $tgl_sampai != null) {
			# mencari data log pengambilan sebelum bulan cari 
			$data_log_tarik_dulu = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date < '$tanggal[tanggal1]' AND user_id='$id_siswa'");
			$pengambilan_dulu = $data_log_tarik_dulu[0]->nominal_tarik;

			# mencari data log peyimpanan sebelum bulan cari
			$data_log_simpan_dulu = $this->m_models->get_data("SUM(nom_simpan) AS nom_simpan", "log_simpan_simtitis", "WHERE tgl_simpan < '$tanggal[tanggal1]' AND user_id='$id_siswa'");
			$simpanan_dulu = $data_log_simpan_dulu[0]->nom_simpan;

			# mencari saldo awal
			$saldo_awal = $simpanan_dulu - $pengambilan_dulu;
	 		$jumlah_baris = 1;

	 		# membuat data buat saldo awal tanggal 1 
	 		$det['tanggal'][] = $tanggal['tanggal1'];
	 		$det['keterangan'][] = 'Saldo Awal';
	 		$det['keuangan'][] = '';
	 		$det['in'][] = '';
	 		$det['out'][] = '';
	 		$det['saldo'][] = $saldo_awal;

	 		# cari jumlah hari dari interval tanggal pencarian
	 		$start_date = new DateTime($tgl_dari);
			$end_date = new DateTime($tgl_sampai);
			$interval = $start_date->diff($end_date);
			$jml_hari = $interval->days;

	 		# isi var tanggal dengan tanggal pertala
	 		$tanggal = $tanggal['tanggal1'];

	 		# buat perulangan dari tanggal 1 sampe max bulan 
	 		for ($i=0; $i <= $jml_hari; $i++) { 

	 			# mengisi data log simpanan
	 			//$data['log_simpan'] = $this->m_models->getSpesific('log_simpan_simtitis', "user_id='$id_siswa' AND tgl_simpan='$tanggal'");
	 			$data['log_simpan'] = $this->m_models->get_data("log_simpan_simtitis.*, pegawai.nama AS nama_keuangan", 'log_simpan_simtitis', "JOIN pegawai ON log_simpan_simtitis.finance=pegawai.nrp WHERE user_id='$id_siswa' AND tgl_simpan='$tanggal'");
	 			foreach ($data['log_simpan'] as $key) {
	 				$det['tanggal'][] = $tanggal;
	 				$det['keterangan'][] = 'Setor Titipan';
	 				$det['keuangan'][] = $key->nama_keuangan;
	 				$det['in'][] = $key->nom_simpan;
	 				$det['out'][] = '';
	 				$saldo_awal += $key->nom_simpan;
	 				$det['saldo'][] = $saldo_awal;
	 				$jumlah_baris++;
	 			}

	 			# mengisi data log tarikan
	 			//$data['log_tarik'] = $this->m_models->getSpesific('log_tarik_simtitis', "user_id='$id_siswa' AND date='$tanggal'");
	 			$data['log_tarik'] = $this->m_models->get_data("log_tarik_simtitis.*, pegawai.nama AS nama_keuangan", 'log_tarik_simtitis', "JOIN pegawai ON log_tarik_simtitis.finance=pegawai.nrp WHERE user_id='$id_siswa' AND date='$tanggal'");
	 			foreach ($data['log_tarik'] as $key) {
	 				# keterangan verifikasi
	 				if ($key->verifikasi == 'F') {
	 					$verifikasi = ' &bull; Verif Sidik Jari';
	 				}else{
	 					$verifikasi = ' &bull; Verif Manual';
	 				}
	 				# keterangan pengambilan
	 				if ($key->keterangan != null) {
	 					$keterangan = ' &bull; '.$key->keterangan ;
	 				}else{
	 					$keterangan = '';
	 				}
	 				
	 				$det['tanggal'][] = $tanggal;
	 				$det['keterangan'][] = 'Penarikan Tunai' . $verifikasi . $keterangan;
	 				$det['keuangan'][] = $key->nama_keuangan;
	 				$det['in'][] = '';
	 				$det['out'][] = $key->nominal_tarik;
	 				$saldo_awal -= $key->nominal_tarik;
	 				$det['saldo'][] = $saldo_awal;
	 				$jumlah_baris++;
	 			}

	 			# mencari tanggal berikutnya
	 			$tanggal = date('Y-m-d', strtotime('+1 day', strtotime($tanggal)));
	 		}

	 		# kirim data buat di view
	 		$data['det_resume'] = $det;
	 		$data['jumlah_baris'] = $jumlah_baris;
		//}
		
		if ($export_excel == 'export_excel') {
			$this->load->view('simtitis/log_transaksi_simtitis_excel', $data);
		}else{
			$this->load->view('simtitis/log_transaksi_simtitis_html', $data);
		}

		$this->load->view('template/js');	
	}

	function rentang_tanggal_db($rentangtanggal){
		$exp = explode("-", $rentangtanggal);

		# mencari tanggal pertama
		$tanggal1 = explode("/", trim($exp[0]));
		$tanggal1_db = $tanggal1[2].'-'.$tanggal1[1].'-'.$tanggal1[0];

		# mencari tanggal kedua
		$tanggal2 = explode("/", trim($exp[1]));
		$tanggal2_db = $tanggal2[2].'-'.$tanggal2[1].'-'.$tanggal2[0];

		$periode = array('tanggal1' => $tanggal1_db, 'tanggal2' => $tanggal2_db);

		return $periode;
	}


	# buat menampilkan status terkini dari SIMTITIS view bagi SISWA
	function status(){
		$this->load->view('template/header');
		# mencari tanggal sekarang
		//$tgl_sekarang = date('Y-m-d');
		# ambil id_siswa dari sesion login
		$id_siswa = '006151610006';

		# mencari data log pengambilan sebelum bulan cari 
		$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE user_id='$id_siswa'");
		$pengambilan = $data_log_tarik[0]->nominal_tarik;

		# mencari data log peyimpanan sebelum bulan cari
		$data_log_simpan = $this->m_models->get_data("SUM(nom_simpan) AS data_log_simpan_dulu", "log_simpan_simtitis", "WHERE user_id='$id_siswa'");
		$simpanan = $data_log_simpan[0]->data_log_simpan_dulu;

		# mencari saldo akhir
		$saldo_akhir = $simpanan - $pengambilan;

		# masukan data untuk dikirim ke view
		$data['saldo_akhir'] = $saldo_akhir;
		$data['simpanan'] = $simpanan;
		$data['pengambilan'] = $pengambilan;

		# tampilkan data
		$this->load->view('simtitis/status', $data); 

		$this->load->view('template/footer');
	}

	# buat menampilkan status terkini dari SIMTITIS view bagi orang tua
	function info_status(){
		$this->load->view('template/header');
		# mencari tanggal sekarang
		//$tgl_sekarang = date('Y-m-d');

		# cari siswa dari orang tua login
		//$siswa = $this->getAnakSekolah('171810004');
		//$jml_anak = count($siswa['id_siswa']);
		#data percobaan
		$siswa['id_siswa'][0] = '006151610006';
		$siswa['nama'][0] = 'Afifah Amalia Azahra';
		$jml_anak = 1;


		for ($i=0; $i <$jml_anak ; $i++) { 
			$id_siswa = $siswa['id_siswa'][$i];
			# mencari data log pengambilan sebelum bulan cari 
			$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE user_id='$id_siswa'");
			$pengambilan = $data_log_tarik[0]->nominal_tarik;

			# mencari data log peyimpanan sebelum bulan cari
			$data_log_simpan = $this->m_models->get_data("SUM(nom_simpan) AS data_log_simpan_dulu", "log_simpan_simtitis", "WHERE user_id='$id_siswa'");
			$simpanan = $data_log_simpan[0]->data_log_simpan_dulu;

			# mencari saldo akhir
			$saldo_akhir = $simpanan - $pengambilan;

			# masukan data untuk dikirim ke view
			$sim_anak['nama'][] = $siswa['nama'][$i];
			$sim_anak['saldo_akhir'][] = $saldo_akhir;
			$sim_anak['simpanan'][] = $simpanan;
			$sim_anak['pengambilan'][] = $pengambilan;
		}

		$data['jml_anak'] = $jml_anak;
		$data['sim_anak'] = $sim_anak;

		# tampilkan data
		$this->load->view('simtitis/info_status', $data); 

		$this->load->view('template/footer');
	}

	# fungsi untuk mencari anak sekolah bagi orang tua
	function getAnakSekolah($nik_ortu){
		# ambil data sekolah yang ada simtitisnya
		$sekolah = $this->getSekolahSimtitis();
		foreach ($sekolah as $key){ 
			# ambil data dari sekolah simtitis
        	$jenjang_pendidikan = strtolower($key->nama_jenjang);
        	$id_sekolah = $key->id_sekolah;
        	$kode_pengenal = $key->kode_pengenal;

        	#pencarian siswa dari tabel ortu_ayah sesuai jenjang loop
        	$tabel = "ortu_ayah_".$jenjang_pendidikan;
        	$tabeljoin1 = "siswa_".$jenjang_pendidikan;
        	$arraywhere = array($tabel.'.nik' => $nik_ortu, $tabeljoin1.'.status_aktif' => 'Aktif');

        	$data_ayah = $this->m_models->getRowsJoin1Where($tabel.'.id_siswa,'.$tabeljoin1.'.nama_lengkap,'.$tabeljoin1.'.nis,'.$tabeljoin1.'.status_aktif', $tabel, $tabeljoin1, $tabel.'.id_siswa='.$tabeljoin1.'.id_siswa', $arraywhere, 'nama_lengkap', 'ASC');
        	if ($data_ayah != 0) {
        		$data_siswa = $this->m_models->getJoin1Where($tabel.'.id_siswa,'.$tabeljoin1.'.nama_lengkap,'.$tabeljoin1.'.nis,'.$tabeljoin1.'.status_aktif', $tabel, $tabeljoin1, $tabel.'.id_siswa='.$tabeljoin1.'.id_siswa', $arraywhere, 'nama_lengkap', 'ASC');
        		foreach ($data_siswa as $key) {
        			# data yang akan diambil dan dikririm simpan di array sisni
        			$arr_siswa['id_siswa'][] = $key->id_siswa;
        			$arr_siswa['nis'][] = $key->nis;
        			$arr_siswa['nama'][] = $key->nama_lengkap;
        		}
        	# Jika data tidak ditemuakn lanjut ke pencarian siswa dari tabel ortu_ibu sesuai jenjang loop
        	}else{
	        	$tabel = "ortu_ibu_".$jenjang_pendidikan;
	        	$tabeljoin1 = "siswa_".$jenjang_pendidikan;
	        	$arraywhere = array($tabel.'.nik' => $nik_ortu, $tabeljoin1.'.status_aktif' => 'Aktif');

	        	$data_ibu = $this->m_models->getRowsJoin1Where($tabel.'.id_siswa,'.$tabeljoin1.'.nama_lengkap,'.$tabeljoin1.'.nis,'.$tabeljoin1.'.status_aktif', $tabel, $tabeljoin1, $tabel.'.id_siswa='.$tabeljoin1.'.id_siswa', $arraywhere, 'nama_lengkap', 'ASC');
	        	if ($data_ibu != 0) {
	        		$data_siswa = $this->m_models->getJoin1Where($tabel.'.id_siswa,'.$tabeljoin1.'.nama_lengkap,'.$tabeljoin1.'.nis,'.$tabeljoin1.'.status_aktif', $tabel, $tabeljoin1, $tabel.'.id_siswa='.$tabeljoin1.'.id_siswa', $arraywhere, 'nama_lengkap', 'ASC');
	        		foreach ($data_siswa as $key) {
	        			# data yang akan diambil dan dikririm simpan di array sisni
	        			$arr_siswa['id_siswa'][] = $key->id_siswa;
	        			$arr_siswa['nis'][] = $key->nis;
	        			$arr_siswa['nama'][] = $key->nama_lengkap;
	        		}
	        	}else{
	        		# Jika data tidak ditemuakn juga lanjut ke pencarian siswa dari tabel ortu_wali sesuai jenjang loop
		        	$tabel = "ortu_wali_".$jenjang_pendidikan;
		        	$tabeljoin1 = "siswa_".$jenjang_pendidikan;
		        	$arraywhere = array($tabel.'.nik' => $nik_ortu, $tabeljoin1.'.status_aktif' => 'Aktif');

		        	$data_ayah = $this->m_models->getRowsJoin1Where($tabel.'.id_siswa,'.$tabeljoin1.'.nama_lengkap,'.$tabeljoin1.'.nis,'.$tabeljoin1.'.status_aktif', $tabel, $tabeljoin1, $tabel.'.id_siswa='.$tabeljoin1.'.id_siswa', $arraywhere, 'nama_lengkap', 'ASC');
		        	if ($data_ayah != 0) {
		        		$data_siswa = $this->m_models->getJoin1Where($tabel.'.id_siswa,'.$tabeljoin1.'.nama_lengkap,'.$tabeljoin1.'.nis,'.$tabeljoin1.'.status_aktif', $tabel, $tabeljoin1, $tabel.'.id_siswa='.$tabeljoin1.'.id_siswa', $arraywhere, 'nama_lengkap', 'ASC');
		        		foreach ($data_siswa as $key) {
		        			# data yang akan diambil dan dikririm simpan di array sisni
		        			$arr_siswa['id_siswa'][] = $key->id_siswa;
		        			$arr_siswa['nis'][] = $key->nis;
		        			$arr_siswa['nama'][] = $key->nama_lengkap;
		        		}
		        	}
	        	}
        	}
        } 

        # kirim data hasil dari fungsi ini ke luar
        return $arr_siswa;
	}

	#input administari bulanan 
	function input_adm_bulanan(){

		$this->load->view('template/header');

 		# ambil data dari form pencarian
		$simtitis = $this->input->post('simtitis', TRUE);
		$saldo = $this->input->post('saldo', TRUE);

     	# kirim data form buat selected form
     	$data['simtitisipilih'] = $simtitis;

       	# pecah data untuk mendaptakn kode_simtiti, kode pengenal sekolah, nominal adm bulanan
		$exp = explode("-", $simtitis);
		$kode_simtitis = $exp[0];
		$kode_pengenal = $exp[1];
		$adm_bulanan = $exp[2];

		$bulan_potong = date("Y-m-");
	
		if ($simtitis != null) {

				# cari data santri yang ada saldonya dan belum dipotong adm
				// if ($saldo == '1') { 
				// 	$siswa = $this->m_models->get_data("user_finger_siswa.user_name, unit_simtitis.*", "unit_simtitis", " JOIN user_finger_siswa ON unit_simtitis.user_id=user_finger_siswa.user_id WHERE unit_simtitis.user_id NOT IN ( SELECT user_id FROM log_tarik_simtitis WHERE date like '$bulan_potong%' AND keterangan='BIAYA Adm') AND saldo >= '$adm_bulanan' AND unit_simtitis.unit_simtitis='$kode_simtitis' AND unit_simtitis.user_id LIKE '$kode_pengenal%' ");
				// }elseif($saldo == '0'){
				// 	$siswa = $this->m_models->get_data("user_finger_siswa.user_name, unit_simtitis.*", "unit_simtitis", " JOIN user_finger_siswa ON unit_simtitis.user_id=user_finger_siswa.user_id WHERE unit_simtitis.user_id NOT IN ( SELECT user_id FROM log_tarik_simtitis WHERE date like '$bulan_potong%' AND keterangan='BIAYA Adm') AND unit_simtitis.user_id IN (SELECT user_id FROM log_tarik_simtitis WHERE date like '$bulan_potong%') AND saldo='0' AND unit_simtitis.unit_simtitis='$kode_simtitis' AND unit_simtitis.user_id LIKE '$kode_pengenal%' ");
				// }
				// 
			//echo $kode_pengenal;
				$siswa = $this->m_models->get_data("user_finger_siswa.user_name, unit_simtitis.*", "unit_simtitis", " JOIN user_finger_siswa ON unit_simtitis.user_id=user_finger_siswa.user_id WHERE unit_simtitis.user_id NOT IN ( SELECT user_id FROM log_tarik_simtitis WHERE date like '$bulan_potong%' AND keterangan='Biaya Adm') AND saldo >= '$adm_bulanan' AND unit_simtitis.user_id IN (SELECT user_id FROM log_tarik_simtitis WHERE date like '$bulan_potong%') AND unit_simtitis.unit_simtitis='$kode_simtitis' AND unit_simtitis.user_id LIKE '$kode_pengenal%' ");
				
				$jml_siswa = 0;

				foreach ($siswa as $key) {
					# membuat data array yang akan ditampilkan berdasarkan data yang didapat
					$arr_anggota['id_siswa'][] = $key->user_id;
	 				$arr_anggota['nama'][] = $key->user_name;
	 				$arr_anggota['saldo'][] = $key->saldo;

	 				# hitung jumlah siswa
					$jml_siswa = $jml_siswa + 1;
				}
		}

 		# kirim dara lengkap
 		$data['anggota'] = $arr_anggota;
		# kirim dara jumlah row data
 		$data['jml_data'] = $jml_siswa;

 		# ambil data instansi
		$data['simtitis'] = $this->m_models->getAll("simtitis ORDER BY id_simtitis");

		# tampilkan data ke view
		$this->load->view('simtitis/input_adm_bulanan', $data); 

		$this->load->view('template/footer');		
	}

	function simpan_adm_bulanan(){
		$simpan = false;
		# ambil data yang di post
		$siswa = array_unique($this->input->post('siswa'));
		$jml_siswa = count($siswa);
		$tanggal_input = date_db($this->input->post('tanggal_input'));
		$waktu_now = date("H:i:s");
		$simtitis = $this->input->post('simtitis', TRUE);
		$saldo = $this->input->post('saldo');

		# ambil data nrp finance pusat yg id_jabatan 3
		$finance = '';
		$pegawai = $this->m_models->get_data("nrp", "pegawai", "WHERE id_jabatan='3'");
		foreach ($pegawai as $key) {
			$finance = $key->nrp;
		}

       	# pecah data untuk mendaptakn kode_simtiti, kode pengenal sekolah, nominal adm bulanan
		$exp = explode("-", $simtitis);
		$kode_simtitis = $exp[0];
		$kode_pengenal = $exp[1];
		$adm_bulanan = $exp[2];

		$id = date('ymdHi');
		
		if ($jml_siswa > 0) {
			for ($i = 0; $i < $jml_siswa; $i++){ 

				$log_akhir = sprintf("%04s", $i);

				$id_log =  $id . $log_akhir;
				$id_user = $siswa[$i];

				# masukan ke array buat di simpan sekaligus
				$data[$i]['log_tarik_id'] = $id_log;
				$data[$i]['user_id'] = $siswa[$i];
				$data[$i]['date'] = $tanggal_input;
				$data[$i]['time'] = $waktu_now;
				$data[$i]['nominal_tarik'] = $adm_bulanan;
				$data[$i]['finance'] = $finance;
				$data[$i]['verifikasi'] = 'M';
				$data[$i]['keterangan'] = 'Biaya Adm';
				$data[$i]['no_transaksi'] = '';
				$data[$i]['sinkronisasi'] = 1;

				# masukan ke array buat di update sekaligus ke tabel unit_simtitis
				$saldo_akhir = $saldo[$id_user] - $adm_bulanan;
				$data_unit_simtitis[$i]['user_id'] = $id_user;
				$data_unit_simtitis[$i]['saldo'] = $saldo_akhir;

			}

			# proses simpan ke tabel perpus_anggota
			$simpan = $this->m_models->save_batch($data,"log_tarik_simtitis");
		}
			
		if ($simpan == TRUE) {
			# update saldo simtitis
			$simpan = $this->m_models->update_batch($data_unit_simtitis, "unit_simtitis", "user_id");
			if ($simpan == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		# kirim data form buat selected form
    	$data['simtitisipilih'] = $simtitis;

		redirect('simtitis/input_adm_bulanan');
	}

	function laporan_pengambilan(){
		$this->load->view('template/header');
		
		$data['simtitis'] = $this->m_models->get_data("nama_unit, kode_simtitis", "simtitis", "GROUP BY kode_simtitis");
		$data['finance'] = $this->m_models->get_data("pegawai.nrp, pegawai.nama", "log_tarik_simtitis", "JOIN pegawai ON log_tarik_simtitis.finance=pegawai.nrp GROUP BY finance ORDER BY nama ASC");

		# tampilkan data ke view
		$this->load->view('simtitis/laporan_pengambilan', $data); 

		$this->load->view('template/footer');		
	}

	# fungsi mengambil semua data sekolah dari tabel simtitis buat JS
	public function getSimtitisSekolah(){
		$this->load->view('template/head');
		$kode_simtitis = $this->input->get('unit_simtitis'); 

		#query data dari tabel simtitis untuk diambil sekolahnya
		$data['sekolah'] = $this->m_models->get_data("kode_pengenal, sekolah", "simtitis", "WHERE kode_simtitis='$kode_simtitis' ");
		# mengambil data finance
		//$data['finance'] = $this->m_models->get_data("pegawai.nrp, pegawai.nama", "log_tarik_simtitis", "JOIN pegawai ON log_tarik_simtitis.finance=pegawai.nrp GROUP BY finance ");
		//$data['finance'] = $this->m_models->get_data("finance", "log_tarik_simtitis", "GROUP BY finance");

		$this->load->view('simtitis/sekolah_simtitis',$data);

		$this->load->view('template/js');
	}

	function resume_data_pengambilan(){ 
		$this->load->view('template/head');
		$posted  = $this->input->post(); 
		//var_dump($posted);
		# get POST pencarian
		$periode = $this->input->post('periode', TRUE);
		$unit_simtitis = $this->input->post('unit_simtitis', TRUE);
		$sekolah = $this->input->post('sekolah', TRUE);
		$finance = $this->input->post('finance', TRUE);
		$groupby = $this->input->post('groupby', TRUE);
		$pengambilan_siswa = $this->input->post('pengambilan_siswa', TRUE);
		$biaya_adm = $this->input->post('biaya_adm', TRUE);

	// 	$export_excel = $this->input->post('export_excel', TRUE);

		// echo "periode ".$periode.'<br>';
		// echo "unit_simtitis ".$unit_simtitis.'<br>';
		// echo "sekolah ".$sekolah.'<br>';
		// echo "finance ".$finance.'<br>';
		// echo "pengambilan_siswa ".$pengambilan_siswa.'<br>';
		// echo "biaya_adm ".$biaya_adm.'<br>';

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);

	
		$arraywhere = array('log_tarik_simtitis.date >=' => $tanggal['tanggal1'], 'log_tarik_simtitis.date <=' => $tanggal['tanggal2'] );
		$arr_where['simtitis.id_simtitis !='] = '';
		# cek jika kriteria anggota dipilih maka tambahkan data kriteria nggota ke arraywhere
		if ($sekolah != null AND $sekolah != 'semua_sekolah') {

		 	$arraywhere['log_tarik_simtitis.user_id like'] = $sekolah."%"; 
		 	$arr_where['simtitis.kode_pengenal'] = $sekolah;

		 	# cari data sekolah berdasarkan kode pengenal
		 	$d_sekolah = $this->m_models->get_data("sekolah", "simtitis", "WHERE kode_pengenal='$sekolah' AND kode_simtitis='$unit_simtitis' ");
		 	$nama_sekolah = $d_sekolah[0]->sekolah;

		}else{
			$nama_sekolah = 'Semua Sekolah';
		}

		if ($unit_simtitis != 'semua_simtitis') {
			$arraywhere['unit_simtitis.unit_simtitis'] = $unit_simtitis;
			$arr_where['simtitis.kode_simtitis'] = $unit_simtitis;
		}

		if ($finance != 'semua_finance') {

			$arraywhere['log_tarik_simtitis.finance'] = $finance;

			# cari data pegawai berdasarkan nrp
		 	$d_pegawai = $this->m_models->get_data("nama", "pegawai", "WHERE nrp='$finance' ");
		 	$nama_finance = $d_pegawai[0]->nama;

		}else{
			$nama_finance = 'Semua Finance';
		}

		if ($pengambilan_siswa == 'on' AND $biaya_adm == NULL) { 
			$arraywhere['log_tarik_simtitis.keterangan !='] = 'Biaya Adm';
		}

		if ($pengambilan_siswa == NULL AND $biaya_adm == 'on') {  
			$arraywhere['log_tarik_simtitis.keterangan'] = 'Biaya Adm';
			$arraywhere['log_tarik_simtitis.verifikasi'] = 'M';
		}
		
		if ($groupby == 'simtitis') {

			$q_pengambilan = $this->m_models->getJoin1whereGroup("SUM(log_tarik_simtitis.nominal_tarik) AS jml_nominal, COUNT(*) AS  jml_trans_tarik, log_tarik_simtitis .finance, unit_simtitis.unit_simtitis", "unit_simtitis", 
			"log_tarik_simtitis", "log_tarik_simtitis.user_id=unit_simtitis.user_id", 
			$arraywhere, "unit_simtitis.unit_simtitis", "unit_simtitis.unit_simtitis", "ASC");

			$no = 0;
			foreach ($q_pengambilan as $key) {

				# mencari nama unit simtitis
				$data_simtitis= $this->m_models->get_data("nama_unit", "simtitis", "where kode_simtitis='$key->unit_simtitis'");
				$nama_unit = $data_simtitis[0]->nama_unit;

				$pengambilan[$no]['unit_simtitis'] = $nama_unit;
				$pengambilan[$no]['sekolah'] = $nama_sekolah;
				$pengambilan[$no]['finance'] = $nama_finance;
				$pengambilan[$no]['transaksi'] = $key->jml_trans_tarik;
				$pengambilan[$no]['nominal'] = $key->jml_nominal;			
				$no++;			
			}

		}

		if ($groupby == 'sekolah') { 

				# ambil data sekolah yang ada simtitisnya
				$d_simtitis = $this->m_models->getTabelwhere("*", "simtitis",  $arr_where, "id_simtitis", "ASC");
				$no = 0;

				foreach ($d_simtitis as $key) {
					# mencari data log pengambilan bulan cari
					if ($finance == 'semua_finance') {
						if ($pengambilan_siswa == 'on' AND $biaya_adm == NULL) {
							$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik, COUNT(*) AS jml_trans_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date >= '$tanggal[tanggal1]' AND date <= '$tanggal[tanggal2]' AND log_tarik_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' AND keterangan != 'Biaya Adm' ");
						}elseif ($pengambilan_siswa == NULL AND $biaya_adm == 'on') {
							$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik, COUNT(*) AS jml_trans_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date >= '$tanggal[tanggal1]' AND date <= '$tanggal[tanggal2]' AND log_tarik_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' AND keterangan = 'Biaya Adm' AND verifikasi='M' ");
						}else{
							$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik, COUNT(*) AS jml_trans_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date >= '$tanggal[tanggal1]' AND date <= '$tanggal[tanggal2]' AND log_tarik_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' ");
						}
					}else{
						if ($pengambilan_siswa == 'on' AND $biaya_adm == NULL) {
							$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik, COUNT(*) AS jml_trans_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date >= '$tanggal[tanggal1]' AND date <= '$tanggal[tanggal2]' AND log_tarik_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' AND keterangan != 'Biaya Adm' AND finance='$finance' ");
						}elseif ($pengambilan_siswa == NULL AND $biaya_adm == 'on') {
							$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik, COUNT(*) AS jml_trans_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date >= '$tanggal[tanggal1]' AND date <= '$tanggal[tanggal2]' AND log_tarik_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' AND keterangan = 'Biaya Adm' AND verifikasi='M' AND finance='$finance'");
						}else{
							$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik, COUNT(*) AS jml_trans_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date >= '$tanggal[tanggal1]' AND date <= '$tanggal[tanggal2]' AND log_tarik_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' AND finance='$finance'");
						}
					}

					foreach ($data_log_tarik as $log) {
						$nominal_tarik = $log->nominal_tarik;
						$jml_trans_pengambilan = $log->jml_trans_tarik;
					}

					$pengambilan[$no]['unit_simtitis'] = $key->nama_unit;
					$pengambilan[$no]['sekolah'] = $key->sekolah;
					$pengambilan[$no]['finance'] = $nama_finance;
					$pengambilan[$no]['nominal'] = $nominal_tarik;		
					$pengambilan[$no]['transaksi'] = $jml_trans_pengambilan;	
					$no++;	

				}

		}

		if ($groupby == 'finance') { 

			$q_pengambilan = $this->m_models->getJoin1whereGroup("SUM(log_tarik_simtitis.nominal_tarik) AS jml_nominal, COUNT(*) AS  jml_trans_tarik, log_tarik_simtitis.finance, unit_simtitis.unit_simtitis", "unit_simtitis", 
			"log_tarik_simtitis", "log_tarik_simtitis.user_id=unit_simtitis.user_id", 
			$arraywhere, "log_tarik_simtitis.finance", "jml_nominal", "DESC");

			$no = 0;
			foreach ($q_pengambilan as $key) {

				# mencari nama unit simtitis
				$data_simtitis= $this->m_models->get_data("nama_unit", "simtitis", "where kode_simtitis='$key->unit_simtitis'");
				$nama_unit = $data_simtitis[0]->nama_unit;

				# cari data pegawai berdasarkan nrp
			 	$d_pegawai = $this->m_models->get_data("nama", "pegawai", "WHERE nrp='$key->finance' ");
			 	$nama_finance = $d_pegawai[0]->nama;

				$pengambilan[$no]['unit_simtitis'] = $nama_unit;
				$pengambilan[$no]['sekolah'] = $nama_sekolah;
				$pengambilan[$no]['finance'] = $nama_finance;
				$pengambilan[$no]['transaksi'] = $key->jml_trans_tarik;
				$pengambilan[$no]['nominal'] = $key->jml_nominal;			
				$no++;			
			}

		}
		
		$data['jumlah_data'] = $no;
		if ($no > 0) {
			$data['pengambilan'] = $pengambilan;
		}
	
		// if ($export_excel == 'export_excel') {
		// 	$this->load->view('perpustakaan/laporan_peminjaman_excel', $data);
		// }else{
		// 	$this->load->view('perpustakaan/laporan_peminjaman_html', $data);
		// }

		$this->load->view('simtitis/resume_data_pengambilan', $data);
		
		$this->load->view('template/js');
	}

	function laporan_simpanan(){
		$this->load->view('template/header');
		
		$data['simtitis'] = $this->m_models->get_data("nama_unit, kode_simtitis", "simtitis", "GROUP BY kode_simtitis");
		$data['finance'] = $this->m_models->get_data("pegawai.nrp, pegawai.nama", "log_simpan_simtitis", "JOIN pegawai ON log_simpan_simtitis.finance=pegawai.nrp GROUP BY finance ORDER BY nama ASC");

		# tampilkan data ke view
		$this->load->view('simtitis/laporan_simpanan', $data); 

		$this->load->view('template/footer');		
	}

	function resume_data_simpanan(){ 
		$this->load->view('template/head');
		$posted  = $this->input->post(); 
		//var_dump($posted);
		# get POST pencarian
		$periode = $this->input->post('periode', TRUE);
		$unit_simtitis = $this->input->post('unit_simtitis', TRUE);
		$sekolah = $this->input->post('sekolah', TRUE);
		$finance = $this->input->post('finance', TRUE);
		$groupby = $this->input->post('groupby', TRUE);

		// echo "periode ".$periode.'<br>';
		// echo "unit_simtitis ".$unit_simtitis.'<br>';
		// echo "sekolah ".$sekolah.'<br>';
		// echo "finance ".$finance.'<br>';

		# konversi tanggal ke tanggal db
		$tanggal = $this->rentang_tanggal_db($periode);
		$data['tanggal1']= shortdate_indo2($tanggal['tanggal1']);
		$data['tanggal2']= shortdate_indo2($tanggal['tanggal2']);

	
		$arraywhere = array('log_simpan_simtitis.tgl_simpan >=' => $tanggal['tanggal1'], 'log_simpan_simtitis.tgl_simpan <=' => $tanggal['tanggal2'] );
		$arr_where['simtitis.id_simtitis !='] = '';
		# cek jika kriteria anggota dipilih maka tambahkan data kriteria nggota ke arraywhere
		if ($sekolah != null AND $sekolah != 'semua_sekolah') {

		 	$arraywhere['log_simpan_simtitis.user_id like'] = $sekolah."%"; 
		 	$arr_where['simtitis.kode_pengenal'] = $sekolah;

		 	# cari data sekolah berdasarkan kode pengenal
		 	$d_sekolah = $this->m_models->get_data("sekolah", "simtitis", "WHERE kode_pengenal='$sekolah' AND kode_simtitis='$unit_simtitis' ");
		 	$nama_sekolah = $d_sekolah[0]->sekolah;

		}else{
			$nama_sekolah = 'Semua Sekolah';
		}

		if ($unit_simtitis != 'semua_simtitis') {
			$arraywhere['unit_simtitis.unit_simtitis'] = $unit_simtitis;
			$arr_where['simtitis.kode_simtitis'] = $unit_simtitis;
		}

		if ($finance != 'semua_finance') {

			$arraywhere['log_simpan_simtitis.finance'] = $finance;

			# cari data pegawai berdasarkan nrp
		 	$d_pegawai = $this->m_models->get_data("nama", "pegawai", "WHERE nrp='$finance' ");
		 	$nama_finance = $d_pegawai[0]->nama;

		}else{
			$nama_finance = 'Semua Finance';
		}
		
		if ($groupby == 'simtitis') {

			$q_simpanan = $this->m_models->getJoin1whereGroup("SUM(log_simpan_simtitis.nom_simpan) AS jml_nominal, COUNT(*) AS  jml_trans_simpanan, log_simpan_simtitis.finance, unit_simtitis.unit_simtitis", "unit_simtitis", 
			"log_simpan_simtitis", "log_simpan_simtitis.user_id=unit_simtitis.user_id", 
			$arraywhere, "unit_simtitis.unit_simtitis", "unit_simtitis.unit_simtitis", "ASC");

			$no = 0;
			foreach ($q_simpanan as $key) {

				# mencari nama unit simtitis
				$data_simtitis= $this->m_models->get_data("nama_unit", "simtitis", "where kode_simtitis='$key->unit_simtitis'");
				$nama_unit = $data_simtitis[0]->nama_unit;

				$simpanan[$no]['unit_simtitis'] = $nama_unit;
				$simpanan[$no]['sekolah'] = $nama_sekolah;
				$simpanan[$no]['finance'] = $nama_finance;
				$simpanan[$no]['transaksi'] = $key->jml_trans_simpanan;
				$simpanan[$no]['nominal'] = $key->jml_nominal;			
				$no++;			
			}

		}

		if ($groupby == 'sekolah') { 

				# ambil data sekolah yang ada simtitisnya
				$d_simtitis = $this->m_models->getTabelwhere("*", "simtitis",  $arr_where, "id_simtitis", "ASC");
				$no = 0;

				foreach ($d_simtitis as $key) {
					# mencari data log pengambilan bulan cari
					if ($finance == 'semua_finance') {

						$data_log_tarik = $this->m_models->get_data("SUM(nom_simpan) AS nominal_simpan, COUNT(*) AS jml_trans_simpan", "log_simpan_simtitis", "JOIN unit_simtitis ON log_simpan_simtitis.user_id=unit_simtitis.user_id WHERE tgl_simpan >= '$tanggal[tanggal1]' AND tgl_simpan <= '$tanggal[tanggal2]' AND log_simpan_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' ");
						
					}else{

						$data_log_tarik = $this->m_models->get_data("SUM(nom_simpan) AS nominal_simpan, COUNT(*) AS jml_trans_simpan", "log_simpan_simtitis", "JOIN unit_simtitis ON log_simpan_simtitis.user_id=unit_simtitis.user_id WHERE tgl_simpan >= '$tanggal[tanggal1]' AND tgl_simpan <= '$tanggal[tanggal2]' AND log_simpan_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' AND Finance='$finance' ");
					
					}

					foreach ($data_log_tarik as $log) {
						$nominal_simpan = $log->nominal_simpan;
						$jml_trans_simpan = $log->jml_trans_simpan;
					}

					$simpanan[$no]['unit_simtitis'] = $key->nama_unit;
					$simpanan[$no]['sekolah'] = $key->sekolah;
					$simpanan[$no]['finance'] = $nama_finance;
					$simpanan[$no]['nominal'] = $nominal_simpan;		
					$simpanan[$no]['transaksi'] = $jml_trans_simpan;	
					$no++;	
				}
		}

		if ($groupby == 'finance') { 

			$q_pengambilan = $this->m_models->getJoin1whereGroup("SUM(log_simpan_simtitis.nom_simpan) AS jml_nominal, COUNT(*) AS  jml_trans_simpan, log_simpan_simtitis.finance, unit_simtitis.unit_simtitis", "unit_simtitis", 
			"log_simpan_simtitis", "log_simpan_simtitis.user_id=unit_simtitis.user_id", 
			$arraywhere, "log_simpan_simtitis.finance", "jml_nominal", "DESC");

			$no = 0;
			foreach ($q_pengambilan as $key) {

				# mencari nama unit simtitis
				$data_simtitis= $this->m_models->get_data("nama_unit", "simtitis", "where kode_simtitis='$key->unit_simtitis'");
				$nama_unit = $data_simtitis[0]->nama_unit;

				# cari data pegawai berdasarkan nrp
			 	$d_pegawai = $this->m_models->get_data("nama", "pegawai", "WHERE nrp='$key->finance' ");
			 	$nama_finance = $d_pegawai[0]->nama;

				$simpanan[$no]['unit_simtitis'] = $nama_unit;
				$simpanan[$no]['sekolah'] = $nama_sekolah;
				$simpanan[$no]['finance'] = $nama_finance;
				$simpanan[$no]['transaksi'] = $key->jml_trans_simpan;
				$simpanan[$no]['nominal'] = $key->jml_nominal;			
				$no++;			
			}

		 }
		
		$data['jumlah_data'] = $no;
		if ($no > 0) {
			$data['simpanan'] = $simpanan;
		}
	
		$this->load->view('simtitis/resume_data_simpanan', $data);
		
		$this->load->view('template/js');
	}

	public function print_bukti_transaksi(){
		$user = $this->session->userdata['nrp'];
		$id_siswa = $this->uri->segment(3);
		$tanggal = $this->uri->segment(4);
		$nrp = $this->uri->segment(5);
		$data['id_sekolah']=$this->m_models->getSession($nrp, "id_sekolah");

		if (($id_siswa != "") or ($tanggal != "") && ($nrp != "")){
			$arraywhere = array('user_id' => $id_siswa, 'tgl_simpan'=>$tanggal, 'finance'=>$nrp);
			$data['log_simpan'] = $this->m_models->getTabelwhere("*", "log_simpan_simtitis", $arraywhere, "tgl_simpan", "desc limit 1");
		}


		$this->load->library('pdf');
		$customPaper = array(0,0,912.0114899085,528.0066520523);
		$this->pdf->setPaper($customPaper, 'potrait');
		$this->pdf->load_view('simtitis/print_bukti_transaksi', $data);
		$this->pdf->render();
		$this->pdf->stream("Kwitansi_Simtitis.pdf", array('Attachment'=>0));

		//$this->load->view('simtitis/print_bukti_transaksi',$data);
	}

	function kas_simtitis(){
		$this->load->view('template/header');

		# ambil data dari form pencarian
		$tgl = $this->input->post('tgl', TRUE);
        $bln = $this->input->post('bln', TRUE);
        $thn = $this->input->post('thn', TRUE);

        # kirim data bulan dan tahun yang dipilih buat selected form
        $data['tgl'] = $tgl;
        $data['bln'] = $bln;
        $data['thn'] = $thn;

        # membuat bulan tahun cari
        //$thnbln = $thn.'-'.$bln;
        if ($tgl == '-') {
        	$thn_bln = $thn.'-'.$bln;
        	$thnbln = $thn.'-'.$bln;
        	$thnblntgl = $thnbln.'-01';
        }else{
        	$thn_bln = $thn.'-'.$bln;
        	$thnbln = $thn.'-'.$bln.'-'.sprintf("%02s", $tgl);
        	$thnblntgl = $thn.'-'.$bln.'-'.$tgl;
        }

        $data['thnblntgl'] = $thnblntgl;
        

        if ($bln != null AND $thn != null) {
				# ambil data sekolah yang ada simtitisnya
				$simtitis = $this->m_models->getAll("simtitis ORDER BY id_simtitis");
				$jml_simtitis = 0;

				foreach ($simtitis as $key){
					# mencari data log pengambilan bulan cari
					$data_log_tarik = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik, COUNT(*) AS jml_trans_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date like '$thnbln%' AND log_tarik_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' ");
					$pengambilan = $data_log_tarik[0]->nominal_tarik;
					$jml_trans_pengambilan = $data_log_tarik[0]->jml_trans_tarik;

					# mencari data log penyimpanan bulan cari
					$data_log_simpan = $this->m_models->get_data("SUM(nom_simpan) AS nominal_simpan, COUNT(*) AS jml_trans_simpan", "log_simpan_simtitis", "JOIN unit_simtitis ON log_simpan_simtitis.user_id=unit_simtitis.user_id WHERE tgl_simpan like '$thnbln%' AND log_simpan_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' and finance not in (select nrp FROM pegawai where id_sekolah='18') ");
					$simpanan = $data_log_simpan[0]->nominal_simpan;
					$jml_trans_simpanan = $data_log_simpan[0]->jml_trans_simpan;

					# mencari data log penyimpanan bulan cari untuk bagian keuangan
					$data_log_simpan1 = $this->m_models->get_data("SUM(nom_simpan) AS nominal_simpan, COUNT(*) AS jml_trans_simpan", "log_simpan_simtitis", "JOIN unit_simtitis ON log_simpan_simtitis.user_id=unit_simtitis.user_id WHERE tgl_simpan like '$thnbln%' AND log_simpan_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis' and finance in (select nrp FROM pegawai where id_sekolah='18') ");
					$simpanan1 = $data_log_simpan1[0]->nominal_simpan;
					$jml_trans_simpanan1 = $data_log_simpan1[0]->jml_trans_simpan;

					# mencari data log pengambilan sebelum bulan cari 
					$data_log_tarik_dulu = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date < '$thnblntgl' AND log_tarik_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis'");
					$pengambilan_dulu = $data_log_tarik_dulu[0]->nominal_tarik;

					# mencari data log penyimpanan sebelum bulan cari
					$data_log_simpan_dulu = $this->m_models->get_data("SUM(nom_simpan) AS data_log_simpan_dulu", "log_simpan_simtitis", "JOIN unit_simtitis ON log_simpan_simtitis.user_id=unit_simtitis.user_id WHERE tgl_simpan < '$thnblntgl' AND log_simpan_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis'  and finance not in (select nrp FROM pegawai where id_sekolah='18')");
					$simpanan_dulu = $data_log_simpan_dulu[0]->data_log_simpan_dulu;

					# mencari data log penyimpanan sebelum bulan cari untuk bagian keuangan
					$data_log_simpan_dulu2 = $this->m_models->get_data("SUM(nom_simpan) AS data_log_simpan_dulu", "log_simpan_simtitis", "JOIN unit_simtitis ON log_simpan_simtitis.user_id=unit_simtitis.user_id WHERE tgl_simpan < '$thnblntgl' AND log_simpan_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis'  and finance in (select nrp FROM pegawai where id_sekolah='18')");
					$simpanan_dulu2 = $data_log_simpan_dulu2[0]->data_log_simpan_dulu;

					#untuk total
					# mencari data log pengambilan sebelum bulan cari 
					$data_log_tarik_dulu1 = $this->m_models->get_data("SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "JOIN unit_simtitis ON log_tarik_simtitis.user_id=unit_simtitis.user_id WHERE date < '$thnblntgl' AND log_tarik_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis'");
					$pengambilan_dulu1 = $data_log_tarik_dulu1[0]->nominal_tarik;

					# mencari data log peyimpanan sebelum bulan cari
					$data_log_simpan_dulu1 = $this->m_models->get_data("SUM(nom_simpan) AS data_log_simpan_dulu", "log_simpan_simtitis", "JOIN unit_simtitis ON log_simpan_simtitis.user_id=unit_simtitis.user_id WHERE tgl_simpan < '$thnblntgl' AND log_simpan_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis'  and finance not in (select nrp FROM pegawai where id_sekolah='18')");
					$simpanan_dulu1 = $data_log_simpan_dulu1[0]->data_log_simpan_dulu;

					# mencari data log peyimpanan sebelum bulan cari
					$data_log_simpan_dulu3 = $this->m_models->get_data("SUM(nom_simpan) AS data_log_simpan_dulu", "log_simpan_simtitis", "JOIN unit_simtitis ON log_simpan_simtitis.user_id=unit_simtitis.user_id WHERE tgl_simpan < '$thnblntgl' AND log_simpan_simtitis.user_id like '$key->kode_pengenal%' AND unit_simtitis='$key->kode_simtitis'  and finance in (select nrp FROM pegawai where id_sekolah='18')");
					$simpanan_dulu3 = $data_log_simpan_dulu3[0]->data_log_simpan_dulu;

					#mutasi akun1 simtitis, akun2 kas keuangan
					$q_mutasi_debet = $this->m_models->get_data("SUM(debet1) AS debet", "jurnal", "WHERE akun2 = '$key->akun_jurnal' and asal='pemasukan divisi' and approve3='Approve' and tgl like '%$thnbln%'");
					$mutasi_debet = $q_mutasi_debet[0]->debet; 
					$q_mutasi_debet1 = $this->m_models->get_data("SUM(debet1) AS debet", "jurnal", "WHERE akun2 = '$key->akun_jurnal' and asal='pemasukan divisi' and approve3='Approve' and tgl < '$thnblntgl'");
					$mutasi_debet1 = $q_mutasi_debet1[0]->debet; 

					#kredit
					$q_mutasi_kredit = $this->m_models->get_data("SUM(kredit2) AS kredit", "jurnal", "WHERE akun1 = '$key->akun_jurnal' AND id_sekolah = '18' and approve3='Approve' and tgl like '%$thnbln%'");
					$mutasi_kredit = $q_mutasi_kredit[0]->kredit;
					$q_mutasi_kredit1 = $this->m_models->get_data("SUM(kredit2) AS kredit", "jurnal", "WHERE akun1 = '$key->akun_jurnal' AND id_sekolah = '18' and approve3='Approve' and tgl < '$thnblntgl'");
					$mutasi_kredit1 = $q_mutasi_kredit1[0]->kredit; 


					# mencari saldo awal
					$saldo_awal_unit =  $simpanan_dulu1 + ($mutasi_kredit1 - $mutasi_debet1) - $pengambilan_dulu1;
					$saldo_awal_pusat =  $simpanan_dulu3 - ($mutasi_kredit1 + $mutasi_debet1);
					$saldo_awal = $saldo_awal_unit + $saldo_awal_pusat;
					//$saldo_awal = $simpanan_dulu - $pengambilan_dulu;
					# mencari saldo akhir
					//$saldo_akhir = $saldo_awal + $simpanan - $pengambilan;
					$saldo_akhir_unit = $saldo_awal_unit + $simpanan + ($mutasi_kredit - $mutasi_debet) - $pengambilan;
					$saldo_akhir_pusat = $saldo_awal_pusat + $simpanan1 - $mutasi_kredit + $mutasi_debet;
					//$saldo_akhir = $saldo_awal + ($simpanan + $simpanan1) + $mutasi_kredit - $pengambilan;
					$saldo_akhir = $saldo_akhir_unit + $saldo_akhir_pusat;


					/*
					saldo awal total (unit+pusat) + penitipan - pengambilan = saldo akhir
					saldo akhir unit = penitipan unit + mutasi kredit - pengambilan
					saldo akhir pusat = penitipan pusat - mutasi kredit 
					*/


					#saldo akhir global kas
					$saldoakhir = ($simpanan_dulu1 - $pengambilan_dulu1) + $simpanan - $pengambilan; 

					# hitung total
					$tot_saldo_awal_unit += $saldo_awal_unit;
					$tot_saldo_awal_pusat += $saldo_awal_pusat;
					$tot_saldo_awal += $saldo_awal;
					$tot_simpanan += $simpanan;
					$tot_simpanan_finance += $simpanan1;
					$tot_trans_simpanan += $jml_trans_simpanan;
					$tot_pengambilan += $pengambilan;
					$tot_trans_pengambilan += $jml_trans_pengambilan;
					$tot_saldo_akhir += $saldo_akhir;
					$tot_saldoakhir += $saldoakhir;
					$tot_mutasi_debet += $mutasi_debet;
					$tot_mutasi_kredit += $mutasi_kredit;
					$tot_saldo_akhir_unit += $saldo_akhir_unit;
					$tot_saldo_akhir_pusat += $saldo_akhir_pusat;

					# isi data array
					$arr_resume['nm_unit_simtitis'][] = $key->nama_unit;
					$arr_resume['nm_sekolah'][] = $key->sekolah;
					$arr_resume['saldo_awal'][] = $saldo_awal;
					$arr_resume['saldo_awal_unit'][] = $saldo_awal_unit;
					$arr_resume['saldo_awal_pusat'][] = $saldo_awal_pusat;
					$arr_resume['simpanan'][] = $simpanan;
					$arr_resume['simpanan_finance'][] = $simpanan1;
					$arr_resume['jml_trans_simpan'][] = $jml_trans_simpanan;
					$arr_resume['pengambilan'][] = $pengambilan;
					$arr_resume['jml_trans_pengambilan'][] = $jml_trans_pengambilan;
					$arr_resume['saldo_akhir_unit'][] = $saldo_akhir_unit;
					$arr_resume['saldo_akhir_pusat'][] = $saldo_akhir_pusat;
					$arr_resume['saldo_akhir'][] = $saldo_akhir;
					$arr_resume['mutasi_debet'][] = $mutasi_debet;
					$arr_resume['mutasi_kredit'][] = $mutasi_kredit;
					$arr_resume['tot_simpanan'][] = $tot_simpanan;
					$arr_resume['tot_simpanan_finance'][] = $tot_simpanan_finance;
					$arr_resume['tot_saldo_awal_unit'][] = $tot_saldo_awal_unit;
					$arr_resume['tot_saldo_awal_pusat'][] = $tot_saldo_awal_pusat;
					
					$jml_simtitis = $jml_simtitis+1;
				}
		}

		# menambahkan data total
		$data['tot_saldo_awal'] = $tot_saldo_awal;
		$data['tot_simpanan'] = $tot_simpanan;
		$data['tot_simpanan_finance'] = $tot_simpanan_finance;
		$data['tot_trans_simpanan'] = $tot_trans_simpanan;
		$data['tot_pengambilan'] = $tot_pengambilan;
		$data['tot_trans_pengambilan'] = $tot_trans_pengambilan;
		$data['tot_saldo_akhir'] = $tot_saldo_akhir;		
		$data['tot_saldo_akhir_unit'] = $tot_saldo_akhir_unit;		
		$data['tot_saldo_akhir_pusat'] = $tot_saldo_akhir_pusat;		
		$data['tot_saldoakhir'] = $tot_saldoakhir;	
		$data['tot_simpanan_finance'] = $tot_simpanan_finance;
		$data['tot_saldo_awal_unit'] = $tot_saldo_awal_unit;
		$data['tot_saldo_awal_pusat'] = $tot_saldo_awal_pusat;	
		$data['tot_mutasi_debet'] = $tot_mutasi_debet;	
		$data['tot_mutasi_kredit'] = $tot_mutasi_kredit;	

		#kirim jumlah data sekolah
		$data['jml_sekolah'] = $jml_sekolah;
		# kirim dara resume
		$data['resume'] = $arr_resume;

		$this->load->view('simtitis/kas_simtitis', $data); 

		$this->load->view('template/footer');		
	}

public function cek_saldo(){
 		$this->load->view('template/header');

 		# ambil data dari form pencarian
		$sekolah = $this->input->post('sekolah', TRUE);
        $tahun_akademik = $this->input->post('tahun_akademik', TRUE);
        $bln = $this->input->post('bln', TRUE);
        $thn = $this->input->post('thn', TRUE);

     	# kirim data form buat selected form
     	$data['sekolahpilih'] = $sekolah;
     	$data['tapilih'] = $tahun_akademik;
        $data['bln'] = $bln;
        $data['thn'] = $thn;

        # membuat bulan tahun cari
        $thnbln = $thn.'-'.$bln;
        $thnblntgl = $thnbln.'-01';

       	# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$id_sekolah = $exp[1].'%';
		$kode_pengenal = $exp[2].'%';

		
		if ($sekolah != null AND $tahun_akademik != null AND $bln != null AND $thn != null) {

			# mencari data log pengambilan bulan cari
			$data_log_tarik = $this->m_models->get_data("user_id, SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE user_id like '$kode_pengenal' GROUP BY user_id");
			# buat data log tarik berdasarkan id_siswa
			foreach ($data_log_tarik as $key) {
				$log_tarik[$key->user_id] = $key->nominal_tarik;
			}

			# mencari data log peyimpanan bulan cari
			$data_log_simpan = $this->m_models->get_data("user_id, SUM(nom_simpan) AS nominal_simpan", "log_simpan_simtitis", "WHERE user_id like '$kode_pengenal%' GROUP BY user_id");
			# buat data log tarik berdasarkan id_siswa
			foreach ($data_log_simpan as $key) {
				$log_simpan[$key->user_id] = $key->nominal_simpan;
			}

			// # mencari data log pengambilan sebelum bulan cari 
			// $data_log_tarik_dulu = $this->m_models->get_data("user_id, SUM(nominal_tarik) AS nominal_tarik", "log_tarik_simtitis", "WHERE date < '$thnblntgl' AND user_id like '$kode_pengenal' GROUP BY user_id");
			// # buat data log tarik berdasarkan id_siswa
			// foreach ($data_log_tarik_dulu as $key) {
			// 	$log_tarik_dulu[$key->user_id] = $key->nominal_tarik;
			// }

			// # mencari data log peyimpanan sebelum bulan cari
			// $data_log_simpan_dulu = $this->m_models->get_data("user_id, SUM(nom_simpan) AS nominal_simpan", "log_simpan_simtitis", "WHERE tgl_simpan < '$thnblntgl' AND user_id like '$kode_pengenal' GROUP BY user_id");
			// # buat data log tarik berdasarkan id_siswa
			// foreach ($data_log_simpan_dulu as $key) {
			// 	$log_simpan_dulu[$key->user_id] = $key->nominal_simpan;
			// }

			# mencari saldo di unit simtitis
			$data_saldo_online = $this->m_models->get_data("*", "unit_simtitis", "WHERE user_id like '$kode_pengenal%' ");
			# buat data log tarik berdasarkan id_siswa
			foreach ($data_saldo_online as $key) {
				$saldo_online[$key->user_id] = $key->saldo;
			}

			# mencari saldo di offline
			$data_saldo_offline = $this->m_models->get_data("*", "saldo_offline", "WHERE user_id like '$kode_pengenal%' ");
			# buat data log tarik berdasarkan id_siswa
			foreach ($data_saldo_offline as $key) {
				$saldo_offline[$key->user_id] = $key->saldo;
			}

			$arrWhere=array($tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
			# cari data siswa dengan kriteria kondisi arrWhere di atas
			$siswa = $this->m_models->getJoin2where($tabel_rombel.".*,".$tabel_siswa.".nis,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk, kelas.nama_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas",  $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", $arrWhere,"", "id_siswa","asc");

			$jml_siswa = 0;

			foreach ($siswa as $key) {

				# membuat data array yang akan ditampilkan berdasarkan data yang didapat
				$arr_resume['id_siswa'][] = $key->id_siswa;
				$arr_resume['nis'][] = $key->nis;
 				$arr_resume['nama'][] = $key->nama_lengkap;
 				$arr_resume['kelas'][] = $key->nama_kelas;
 				$arr_resume['jk'][] = $key->jk;
 				# saldo awal hitung dengan mengurangi simpanan dengan pengambilan bulan dulu
 				// $arr_resume['saldo_awal'][] = $log_simpan_dulu[$key->id_siswa] - $log_tarik_dulu[$key->id_siswa];
 				// # simpanan bulan cari
 				// $arr_resume['simpanan'][] = $log_simpan[$key->id_siswa];
 				// # pengambilan bulan cari
 				// $arr_resume['pengambilan'][] = $log_tarik[$key->id_siswa];
 				// # saldo akhir bulan cari
 				// $saldoakhir = $log_simpan_dulu[$key->id_siswa] - $log_tarik_dulu[$key->id_siswa] + $log_simpan[$key->id_siswa] -  $log_tarik[$key->id_siswa];
 				$arr_resume['saldo_akhir'][] = $log_simpan[$key->id_siswa] - $log_tarik[$key->id_siswa];

 				$arr_resume['saldo_online'][] = $saldo_online[$key->id_siswa];

 				if (isset($saldo_offline[$key->id_siswa])) {
 					$arr_resume['saldo_offline'][] = $saldo_offline[$key->id_siswa];
 				}else{
 					$arr_resume['saldo_offline'][] = 0;
 				}
 				

 				# hitung jumlah siswa
				$jml_siswa = $jml_siswa + 1;
			}

		}

 		# kirim dara lengkap
 		$data['resume'] = $arr_resume;
		# kirim dara jumlah row data
 		$data['jml_data'] = $jml_siswa;
		# kirim tabel siswanya
		$data['tabel_siswa'] = $tabel_siswa;
		# kirim tahun bulan cari
		$data['bulan_cari'] = $thnbln;

 		# ambil data sekolah yang ada simtitisnya
		$data['sekolah'] = $this->getSekolahSimtitis();

		# ambil data tahun akademik
		$data['ta'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");

		$this->load->view('simtitis/cek_saldo', $data); 

		$this->load->view('template/footer');
	}

}