<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Raport extends CI_Controller {
	 function __construct()
       {
            parent::__construct();
            $this->load->helper('url');
			$this->load->helper('download');
        $this->load->library('pagination');
    if (!isset($this->session->userdata['id_pengguna'])) {
      redirect(base_url("login"));
    }
            $this->load->library('pagination');
            $this->load->model('m_models'); 
       }



public function raport_pas(){ 
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$jabatan=$this->m_models->getSession($nrp, "id_jabatan");
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$hariini=date("Y-m-d");
		$id_tahun=ta_berjalan("id_tahun");
		$data['idthn']=$id_tahun;
		if ($jabatan=="10"){
			$ars = array('id_tahun' => $id_tahun, 'id_sekolah'=>$id_sekolah);
	        $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ars, "id_tingkatan_kelas", "asc");
		} else {
			$ars = array('id_tahun' => $id_tahun, 'nrp'=>$nrp, 'id_sekolah'=>$id_sekolah);
	        $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ars, "id_tingkatan_kelas", "asc");
		}


		$data['thn_akademik'] = $this->m_models->getAll("tahun_akademik order by id_tahun asc");
		$data['semester'] = $this->m_models->getAll("satuan_waktu_pendidikan where status='on' and id_sekolah='$id_sekolah' and id_tahun='$id_tahun' order by nama_satuan asc limit 1");

		$kelas  = $this->input->post('kelas', TRUE);
		$smt  = $this->input->post('smt', TRUE);
		$thn  = $this->input->post('thn', TRUE);
		if ($kelas != ""){ 
			$ars = array('id_tahun' => $id_tahun, 'id_kelas'=>$kelas);
	        $kls = $this->m_models->getTabelwhere("*", "kelas", $ars, "nama_kelas", "asc");
	        $data['nm_kelas'] = $kls[0]->nama_kelas;
	        $data['id_tahun'] = $id_tahun;
	        $data['smt'] = $smt;
	        $data['thn'] = $thn;
 
	        $jenjang=db_jenjang($id_sekolah);
	        $rombel="rombongan_belajar_".$jenjang;
	        $siswa="siswa_".$jenjang;

	        $data['jenjang'] = $jenjang;
			$data['tampilsiswa']=$this->m_models->get_data("$siswa.id_siswa, nama_lengkap, nis", $rombel, "join $siswa on $rombel.id_siswa = $siswa.id_siswa where $rombel.id_kelas='$kelas' and $rombel.id_tahun='$id_tahun'");
		}
		
		$this->load->view('raport/raport_pas', $data);
		$this->load->view('template/footer');
	}



	// untuk mengecek nama kelas yang

	function cek_kelas(){
	$nrp=$this->session->userdata['nrp']; 
	$jabatan=$this->m_models->getSession($nrp, "id_jabatan");
	$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	$id_tahun=$this->input->get('thn');

	if ($jabatan=="10"){
			$ars = array('id_tahun' => $id_tahun, 'id_sekolah'=>$id_sekolah);
	        $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ars, "id_tingkatan_kelas", "asc");
		} else {
			$ars = array('id_tahun' => $id_tahun, 'nrp'=>$nrp, 'id_sekolah'=>$id_sekolah);
	        $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ars, "id_tingkatan_kelas", "asc");
		}
	$this->load->view('raport/cek_kelas',$data);
	}

	function cek_semester(){
	$nrp=$this->session->userdata['nrp']; 
	$jabatan=$this->m_models->getSession($nrp, "id_jabatan");
	$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
	$id_kelas=$this->input->get('kelas');

	$id_tahun = all("kelas","id_kelas",$id_kelas,"id_tahun");

	$data['semester'] = $this->m_models->getAll("satuan_waktu_pendidikan where status='on' and id_sekolah='$id_sekolah' and id_tahun='$id_tahun' order by nama_satuan asc limit 1");
	$data['kurikulum'] = $this->m_models->getAll("kelas join sekolah_kurikulum on kelas.id_kurikulum = sekolah_kurikulum.id_kurikulum where id_kelas='$id_kelas'");
		
	$this->load->view('raport/cek_semester',$data);
	}


// MASTER K 13
	public function predikat_spiritual(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");

		$predikat  = $this->input->post('predikat', TRUE); 
		$deskripsi  = $this->input->post('deskripsi', TRUE); 
		$kurikulum  = $this->input->post('kurikulum', TRUE); 
		if (($predikat != "")&&($deskripsi != "")&&($kurikulum != "")){
			$ar = array('predikat'=>$predikat, 'deskripsi' => $deskripsi, 'jenis'=>"spiritual",'tgl_input'=>$hariini, 'petugas'=>$nrp, 'status'=>"on", 'kurikulum'=>$kurikulum);
			if ($this->m_models->save_data($ar, 'r_predikat') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('raport/predikat_spiritual');
		}
		
		$data['kurikulum']=$this->m_models->getTabelOrder("*", "sekolah_kurikulum", "nama_kurikulum", "asc");
		$ars = array('jenis' => "spiritual");
        $data['r_predikat'] = $this->m_models->getTabelwhere("*", "r_predikat", $ars, "kurikulum, predikat", "asc");


		$this->load->view('raport/predikat_spiritual', $data);
		$this->load->view('template/footer');
	}

	
	public function predikat_sosial(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");

		$predikat  = $this->input->post('predikat', TRUE); 
		$deskripsi  = $this->input->post('deskripsi', TRUE); 
		$kurikulum  = $this->input->post('kurikulum', TRUE); 
		if (($predikat != "")&&($deskripsi != "")&&($kurikulum != "")){
			$ar = array('predikat'=>$predikat, 'deskripsi' => $deskripsi, 'jenis'=>"sosial",'tgl_input'=>$hariini, 'petugas'=>$nrp, 'status'=>"on", 'kurikulum'=>$kurikulum);
			if ($this->m_models->save_data($ar, 'r_predikat') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('raport/predikat_sosial');
		}
		
		$data['kurikulum']=$this->m_models->getTabelOrder("*", "sekolah_kurikulum", "nama_kurikulum", "asc");
		$ars = array('jenis' => "sosial");
        $data['r_predikat'] = $this->m_models->getTabelwhere("*", "r_predikat", $ars, "kurikulum, predikat", "asc");


		$this->load->view('raport/predikat_sosial', $data);
		$this->load->view('template/footer');
	}

	public function predikat_pengetahuan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");

		$predikat  = $this->input->post('predikat', TRUE); 
		$deskripsi  = $this->input->post('deskripsi', TRUE); 
		$kurikulum  = $this->input->post('kurikulum', TRUE); 
		$nilai_min  = $this->input->post('nilai_min', TRUE); 
		$nilai_max  = $this->input->post('nilai_max', TRUE); 
		if (($predikat != "")&&($deskripsi != "")&&($kurikulum != "")&&($nilai_min != "")&&($nilai_max != "")){
			$ar = array('predikat'=>$predikat, 'deskripsi' => $deskripsi, 'jenis'=>"pengetahuan", 'nilai_min'=>$nilai_min, 'nilai_max'=>$nilai_max, 'tgl_input'=>$hariini, 'petugas'=>$nrp, 'status'=>"on", 'kurikulum'=>$kurikulum);
			if ($this->m_models->save_data($ar, 'r_predikat') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('raport/predikat_pengetahuan');
		}
		
		$data['kurikulum']=$this->m_models->getTabelOrder("*", "sekolah_kurikulum", "nama_kurikulum", "asc");
		$ars = array('jenis' => "pengetahuan");
        $data['r_predikat'] = $this->m_models->getTabelwhere("*", "r_predikat", $ars, "kurikulum, predikat", "asc");


		$this->load->view('raport/predikat_pengetahuan', $data);
		$this->load->view('template/footer');
	}

	public function predikat_keterampilan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");

		$predikat  = $this->input->post('predikat', TRUE); 
		$deskripsi  = $this->input->post('deskripsi', TRUE); 
		$kurikulum  = $this->input->post('kurikulum', TRUE); 
		$nilai_min  = $this->input->post('nilai_min', TRUE); 
		$nilai_max  = $this->input->post('nilai_max', TRUE); 
		if (($predikat != "")&&($deskripsi != "")&&($kurikulum != "")&&($nilai_min != "")&&($nilai_max != "")){
			$ar = array('predikat'=>$predikat, 'deskripsi' => $deskripsi, 'jenis'=>"keterampilan", 'nilai_min'=>$nilai_min, 'nilai_max'=>$nilai_max, 'tgl_input'=>$hariini, 'petugas'=>$nrp, 'status'=>"on", 'kurikulum'=>$kurikulum);
			if ($this->m_models->save_data($ar, 'r_predikat') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('raport/predikat_keterampilan');
		}
		
		$data['kurikulum']=$this->m_models->getTabelOrder("*", "sekolah_kurikulum", "nama_kurikulum", "asc");
		$ars = array('jenis' => "keterampilan");
        $data['r_predikat'] = $this->m_models->getTabelwhere("*", "r_predikat", $ars, "kurikulum, predikat", "asc");


		$this->load->view('raport/predikat_keterampilan', $data);
		$this->load->view('template/footer');
	}

	public function nilai_spiritual(){ 
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$jabatan=$this->m_models->getSession($nrp, "id_jabatan");		
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$hariini=date("Y-m-d");
		$id_tahun=ta_berjalan("id_tahun");
		if ($jabatan=="10"){
			$ars = array('id_tahun' => $id_tahun);
	        $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ars, "nama_kelas", "asc");
		} else {
			$ars = array('id_tahun' => $id_tahun, 'b_musyrifah.nrp'=>$nrp);
	        $data['kelas'] = $this->m_models->getJoin1where("*", "kelas", "b_musyrifah", "b_musyrifah.id_kelas=kelas.id_kelas", $ars, "nama_kelas", "asc");
		}
		$ar_smt = array('id_tahun' => $id_tahun, 'id_sekolah'=>$id_sekolah);
        $data['smster'] = $this->m_models->getTabelwhere("*", "satuan_waktu_pendidikan", $ar_smt, "nama_satuan", "asc");			

		$semester  = $this->input->post('semester', TRUE);
		$kelas  = $this->input->post('kelas', TRUE);
		$jenis  = $this->input->post('jenis', TRUE);
		$id_siswa  = $this->input->post('id_siswa', TRUE);
		$no = $this->input->post('no', TRUE);
        if (($semester != "") && ($kelas !="") && ($jenis != "")&&($no != "")){
			for ($i=0; $i <= $no; $i++){ 
				$idsiswa=$id_siswa[$i];
				$predikat = $this->input->post('predikat'.$idsiswa, TRUE);
				if (($predikat != "") && ($idsiswa != "")){
					$ar = array('id_siswa'=>$idsiswa, 'id_tahun' => $id_tahun, 'id_r_predikat'=>$predikat, 'user'=>$nrp, 'tgl_input'=>$hariini, 'semester'=>$semester, 'jenis'=>$jenis);
					$simpan=$this->m_models->save_data($ar, 'r_nilai_spiritual');
				}
			}
			if ($simpan== TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('raport/nilai_spiritual');
		}
		$this->load->view('raport/nilai_spiritual', $data);
		$this->load->view('template/footer');
	}

	public function ceksiswa(){
		$nrp=$this->session->userdata['nrp'];	
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$kelas  = $this->input->get('kelas', TRUE);
		$id_tahun=ta_berjalan("id_tahun");

		$rbel="rombongan_belajar_smp";
		$sswa="siswa_smp";
		$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$kelas, $rbel.".id_tahun"=>$id_tahun, $rbel.".id_sekolah"=>$id_sekolah);
		$data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");

		$ars = array('jenis' => "spiritual", 'status'=>'on');
        $data['r_predikat'] = $this->m_models->getTabelwhere("*", "r_predikat", $ars, "kurikulum, predikat", "asc");
		
		$this->load->view('raport/ceksiswa', $data);
	}

	public function nilai_sosial(){ 
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$jabatan=$this->m_models->getSession($nrp, "id_jabatan");
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$hariini=date("Y-m-d");
		$id_tahun=ta_berjalan("id_tahun");
		if ($jabatan=="10"){
			$ars = array('id_tahun' => $id_tahun,'id_sekolah'=>$id_sekolah);
	        $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ars, "id_tingkatan_kelas", "asc");
		} else {
			$ars = array('id_tahun' => $id_tahun, 'nrp'=>$nrp,'id_sekolah'=>$id_sekolah);
	        $data['kelas'] = $this->m_models->getTabelwhere("*", "kelas", $ars, "id_tingkatan_kelas", "asc");
		}
		$ar_smt = array('id_tahun' => $id_tahun, 'id_sekolah'=>$id_sekolah);
        $data['smster'] = $this->m_models->getTabelwhere("*", "satuan_waktu_pendidikan", $ar_smt, "nama_satuan", "asc");		

		$semester  = $this->input->post('semester', TRUE);
		$kelas  = $this->input->post('kelas', TRUE);
		$jenis  = $this->input->post('jenis', TRUE);
		$id_siswa  = $this->input->post('id_siswa', TRUE);
		$no = $this->input->post('no', TRUE);
        if (($semester != "") && ($kelas !="") && ($jenis != "")&&($no != "")){
			for ($i=0; $i <= $no; $i++){ 
				$idsiswa=$id_siswa[$i];
				$predikat = $this->input->post('predikat'.$idsiswa, TRUE);
				if (($predikat != "") && ($idsiswa != "")){
					$ar = array('id_siswa'=>$idsiswa, 'id_tahun' => $id_tahun, 'id_r_predikat'=>$predikat, 'user'=>$nrp, 'tgl_input'=>$hariini, 'semester'=>$semester, 'jenis'=>$jenis);
					$simpan=$this->m_models->save_data($ar, 'r_nilai_sosial');
				}
			}
			if ($simpan== TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('raport/nilai_sosial');
		}
		$this->load->view('raport/nilai_sosial', $data);
		$this->load->view('template/footer');
	}

	public function ceksiswasos(){
		$nrp=$this->session->userdata['nrp'];	
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$kelas  = $this->input->get('kelas', TRUE);
		$id_tahun=ta_berjalan("id_tahun");

		$rbel="rombongan_belajar_smp";
		$sswa="siswa_smp";
		$ar_r = array('status_aktif =' => 'Aktif', $rbel.".id_kelas"=>$kelas, $rbel.".id_tahun"=>$id_tahun, $rbel.".id_sekolah"=>$id_sekolah);
		$data['rombel'] = $this->m_models->getJoin1where("*", $rbel, $sswa, "$rbel.id_siswa=$sswa.id_siswa", $ar_r, "nama_lengkap", "asc");

		$ars = array('jenis' => "sosial", 'status'=>'on');
        $data['r_predikat'] = $this->m_models->getTabelwhere("*", "r_predikat", $ars, "kurikulum, predikat", "asc");
		
		$this->load->view('raport/ceksiswasos', $data);
	}

	public function set_mapel(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$jabatan=$this->m_models->getSession($nrp, "id_jabatan");		
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$hariini=date("Y-m-d");
		$id_tahun=ta_berjalan("id_tahun");
		//$data['kurikulum']=$this->m_models->getTabelOrder("*", "sekolah_kurikulum", "nama_kurikulum", "asc");
		$data['kurikulum']=$this->m_models->getAll("sekolah_kurikulum where id_sekolah='$id_sekolah' order by nama_kurikulum asc ");
		$arm = array('status' => 'on','id_sekolah'=>$id_sekolah);
        $data['mapel'] = $this->m_models->getTabelwhere("*", "mata_pelajaran", $arm, "nama_mapel", "asc");

		$kurikulum  = $this->input->post('kurikulum', TRUE);
		$jml_no  = $this->input->post('jml_no', TRUE);
        if (($kurikulum != "") && ($jml_no !="")){
			for ($i=0; $i <= $no; $i++){
				$no  = $this->input->post('no', TRUE);
				$nomor = $no[$i];
				$id_mapel  = $this->input->post('id_mapel'.$nomor, TRUE);
				$hariini=date("Y-m-d");

				if (($nomor != "") && ($id_mapel != "")){
					$ar = array('urutan'=>$nomor, 'id_mapel' => $id_mapel, 'id_kurikulum'=>$kurikulum, 'tgl_input'=>$hariini, 'petugas'=>$nrp);
					$simpan=$this->m_models->save_data($ar, 'r_urutan_mapel');
				}
			}
			if ($simpan== TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('raport/set_mapel');
		}

		$id_kurikulum  = $this->input->post('id_kurikulum', TRUE);
		if ($id_kurikulum != ""){
			$data['nm_kurikulum']=all("sekolah_kurikulum", "id_kurikulum", $id_kurikulum, "nama_kurikulum");
			$armp = array('id_kurikulum' => $id_kurikulum);
	        $data['urutan_mapel'] = $this->m_models->getJoin1where("*", "r_urutan_mapel", "mata_pelajaran", "mata_pelajaran.id_mapel=r_urutan_mapel.id_mapel",  $armp, "urutan", "asc");
		}
			
		$this->load->view('raport/set_mapel', $data);
		$this->load->view('template/footer');
	}

	//END MASTER


	public function raport_smp_k13(){ 
		$nrp=$this->session->userdata['nrp']; 
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$id_siswa = $this->uri->segment(3);
		$id_tahun = $this->uri->segment(4);
		$smt = $this->uri->segment(5);


		$data['skl'] = $this->m_models->getDataByID("sekolah","id_sekolah",$id_sekolah);
		foreach ($data['skl'] as $sk)
		{
			$data['nama_sekolah'] = $sk->nama;
			$prov = $sk->prov;
			$kab = $sk->kab;
			$kec = $sk->kec;
			$desa = $sk->desa;

			$data['prov'] = all("provinsi","id_prov",$prov,"nama");
			$data['kab'] = all("kabupaten","id_kab",$kab,"nama");
			$data['kec'] = all("kecamatan","id_kec",$kec,"nama");
			$data['desa'] = all("kelurahan","id_kel",$desa,"nama");



		}

		$jenjang=db_jenjang($id_sekolah);
	    $siswa="siswa_".$jenjang;
		$nm_siswa=all($siswa, "id_siswa", $id_siswa, "nama_lengkap");
		//$nis=all($siswa, "id_siswa", $id_siswa, "nis");
		$nisn=all($siswa, "id_siswa", $id_siswa, "nisn");
		$rombel="rombongan_belajar_".$jenjang;
		$data['tampilsiswa']=$this->m_models->get_data("$siswa.id_siswa, nama_lengkap, nis, id_kelas", $rombel, "join $siswa on $rombel.id_siswa = $siswa.id_siswa where $rombel.id_siswa='$id_siswa' and $rombel.id_tahun='$id_tahun'");
		$data['nm_siswa']=$nm_siswa;
		$data['nisn']=$nisn;
		$data['nis']=$data['tampilsiswa'][0]->nis;
		$idkls=$data['tampilsiswa'][0]->id_kelas;
		$ars = array('id_tahun' => $id_tahun, 'id_kelas'=>$idkls);
	    $kls = $this->m_models->getTabelwhere("*", "kelas", $ars, "nama_kelas", "asc");
	    $data['nm_kelas'] = $kls[0]->nama_kelas;

	    $data['wali_kelas'] = all("pegawai","nrp", $kls[0]->nrp,"nama");
	    $nrp_wakel = $kls[0]->nrp;
	    $data['nrp_wakel']=$nrp_wakel;
	    $data['nm_walikelas']=all("pegawai", "nrp", $nrp_wakel, "nama");
		$data['semester']=all("satuan_waktu_pendidikan", "id_satuan_waktu", $smt, "nama_satuan");
		$data['thn_pelajaran']=all("tahun_akademik", "id_tahun", $id_tahun, "periode");
		$ex=explode(" ", $nm_siswa);
		$nm_awal=$ex[0];

		#kepsek		
		$ar_k = array('status_aktf' => 'Aktif', 'id_jabatan'=> 4,'id_sekolah'=>$id_sekolah);
	    $pegawai = $this->m_models->getTabelwhere("nama, nrp", "pegawai", $ar_k, "nama", "asc");
	    $data['nm_kepsek'] = $pegawai[0]->nama;
	    $data['nrp_kepsek'] = $pegawai[0]->nrp;


		#NILAI SOSIAL		
		$ar_sosial = array('id_siswa' => $id_siswa, 'id_tahun'=>$id_tahun, 'semester'=>$smt, 'r_nilai_sosial.jenis'=>"PAS");
	    $n_sosial = $this->m_models->getJoin1where("*", "r_nilai_sosial", "r_predikat", "r_predikat.id_r_predikat=r_nilai_sosial.id_r_predikat", $ar_sosial, "id_siswa", "asc");
	    $data['predikat_sosial'] = $n_sosial[0]->predikat;
	    $data['deskripsi_sosial'] = "Ananda ".$nm_awal." ".$n_sosial[0]->deskripsi;

		#NILAI SPIRITUAL
		$ar_spiritual = array('id_siswa' => $id_siswa, 'id_tahun'=>$id_tahun, 'semester'=>$smt, 'r_nilai_spiritual.jenis'=>"PAS");
	    $n_spiritual = $this->m_models->getJoin1where("*", "r_nilai_spiritual", "r_predikat", "r_predikat.id_r_predikat=r_nilai_spiritual.id_r_predikat", $ar_spiritual, "id_siswa", "asc");
	    $data['predikat_spiritual'] = $n_spiritual[0]->predikat;
	    $data['deskripsi_spiritual'] = "Ananda ".$nm_awal." ".$n_spiritual[0]->deskripsi;

	    #nilai pengetahuan
	    $armp = array('id_kurikulum' => $id_kurikulum);
	    $data['urutan_mapel'] = $this->m_models->getJoin1where("*", "r_urutan_mapel", "mata_pelajaran", "mata_pelajaran.id_mapel=r_urutan_mapel.id_mapel",  $armp, "urutan", "asc");
	    foreach ($data['urutan_mapel'] as $um){
		    #KKM
		    $a_kkm = array('id_tahun' => $id_tahun, 'id_sekolah'=>$id_sekolah, 'id_kelas'=>$idkls, 'id_satuan_waktu'=>$smt, 'id_mapel'=>$um->id_mapel);
	    	$data['d_kkm'] = $this->m_models->getTabelwhere("kkm", "jadwal_mapel", $a_kkm, "kkm", "asc");
	    	$data['kkm'][$um->id_mapel] = $data['d_kkm'][0]->kkm;

	    	#nilai akhir pengetahuan
	    	$a_na = array('id_sekolah' => $id_sekolah, 'id_mapel'=>$um->id_mapel, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_komponen_penilaian'=>1, 'id_kategori_ujian'=>'12');
		    $data['nilai_akhir'] = $this->m_models->getTabelwhere("*", "tb_nilai_akhir_smp", $a_na, "id_siswa", "asc"); 
		    $na_pengetahuan=$data['nilai_akhir'][0]->nilai_angka==0;
	    	if (($um->id_mapel=="20")&&($na_pengetahuan==0)){
	    		$data['na_pengetahuan'][$um->id_mapel]=nilai_pai($id_sekolah, $id_tahun, $smt, $id_siswa, '1', '12');
	    	} else {
	    		$data['na_pengetahuan'][$um->id_mapel]=$data['nilai_akhir'][0]->nilai_angka;
	    	}
		   
		  /* 	#JML KD
		   	$a_kd = array('id_sekolah' => $id_sekolah, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_komponen_penilaian'=>'12', 'id_mapel'=>$um->id_mapel, 'id_kelas'=>$idkls);
		    $data['jmlkd'] = $this->m_models->getTabelwhere("*", "r_jml_kd", $a_kd, "id_j_kd", "asc");	
		    $j_kd = $this->m_models->getRowsAWhere("*", "r_jml_kd", $a_kd, "id_j_kd", "asc");
		    if ($j_kd==0){
		    	$data['jml_kd'] = 0;
		    } else {
		    	$data['jml_kd'] = $data['jmlkd'][0]->jml_kd;
		    }*/
		    

	    	#nilai akhir keterampilan
	    	$a_na_k = array('id_sekolah' => $id_sekolah, 'id_mapel'=>$um->id_mapel, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_komponen_penilaian'=>2, 'id_kategori_ujian'=>'12');
	    	$data['nilai_akhir_k'] = $this->m_models->getTabelwhere("*", "tb_nilai_akhir_smp", $a_na_k, "id_siswa", "asc");
	    	$na_keterampilan=$data['nilai_akhir_k'][0]->nilai_angka;
	    	if (($um->id_mapel=="20")&&($na_keterampilan==0)){
	    		$data['na_keterampilan'][$um->id_mapel]=nilai_pai($id_sekolah, $id_tahun, $smt, $id_siswa, '2', '12');
	    	} else {
	    		$data['na_keterampilan'][$um->id_mapel]=$data['nilai_akhir_k'][0]->nilai_angka;
	    	}
	    }


	    #CETAK HALAMAN 2
	    #NILAI EKSKUL
	    $ar_eks = array('id_siswa' => $id_siswa, 'ekskul_nilai_ekskul.id_satuan_waktu'=>$smt, 'id_tahun'=>$id_tahun, 'id_kategori_ujian'=>'12');
	    $data['keg_ekskul'] = $this->m_models->getJoin2Awhere("nama_ekskul, nilai_ekskul", "ekskul_nilai_ekskul", "satuan_waktu_pendidikan", "satuan_waktu_pendidikan.id_satuan_waktu=ekskul_nilai_ekskul.id_satuan_waktu", "ekskul_nama_ekskul", "ekskul_nama_ekskul.id_nama_ekskul=ekskul_nilai_ekskul.id_nama_ekskul", $ar_eks, "nama_ekskul", "asc");
	    $data['j_keg_ekskul'] = $this->m_models->getRowsJoin2Where("nama_ekskul, nilai_ekskul", "ekskul_nilai_ekskul", "satuan_waktu_pendidikan", "satuan_waktu_pendidikan.id_satuan_waktu=ekskul_nilai_ekskul.id_satuan_waktu", "ekskul_nama_ekskul", "ekskul_nama_ekskul.id_nama_ekskul=ekskul_nilai_ekskul.id_nama_ekskul", $ar_eks, "nama_ekskul", "asc");

	    #NILAI PRESTASI
	    $a_na_pres = array('id_sekolah' => $id_sekolah, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_kategori_ujian'=>'12');
	    $data['keg_prestasi'] = $this->m_models->getTabelwhere("*", "siswa_prestasi_lomba_smp", $a_na_pres, "id_siswa", "asc");
	    $data['j_keg_prestasi'] = $this->m_models->getRows("siswa_prestasi_lomba_smp where id_sekolah='$id_sekolah' and id_tahun='$id_tahun' and id_satuan_waktu='$smt' and id_kategori_ujian='12' and id_siswa='$id_siswa'");

	    #NILAI KEGIATAN SEKOLAH
	    $a_na_keg = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa);
	    $data['keg_sekolah'] = $this->m_models->getTabelwhere("*", "r_keg_sekolah", $a_na_keg, "tgl_mulai, jenis_kegiatan", "asc");
	    $data['j_keg_sekolah'] = $this->m_models->getRows("r_keg_sekolah where id_tahun='$id_tahun' and id_satuan_waktu='$smt' and id_siswa='$id_siswa'");


	    #ABSENSI SISWA
	    #SAKIT
	    $as = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'S');
	   	$data['j_sakit'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_smp", $as, "id_siswa", "asc");
	   	#IZIN
	   	$ai = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'I');
	   	$data['j_izin'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_smp", $ai, "id_siswa", "asc");
	   	#TK
	   	$atk = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'TK');
	   	$data['j_tk'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_smp", $atk, "id_siswa", "asc");


 


		$this->load->view('raport/raport_smp_k13', $data);
		$this->load->library('pdf');
		$this->pdf->setPaper("A4", 'portrait');
		$this->pdf->setPaper($customPaper, 'potrait');
		$this->pdf->load_view('raport/raport_smp_k13', $data);
		$this->pdf->render();
		$this->pdf->stream("Raport_PAS_".$nm_siswa.".pdf", array('Attachment'=>0));
	}


// K13 SMA
	public function raport_sma_k13(){ 


		// mencari Kode Kurikulum K13 SMP



		$nrp=$this->session->userdata['nrp']; 
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$id_siswa = $this->uri->segment(3);
		$id_tahun = $this->uri->segment(4);
		$smt = $this->uri->segment(5);


		$data['skl'] = $this->m_models->getDataByID("sekolah","id_sekolah",$id_sekolah);

		$data['kr'] = $this->m_models->getAll("sekolah_kurikulum where id_sekolah='$id_sekolah' and nama_kurikulum like '%13%' ");
		foreach ($data['kr'] as $krl)
		{
			$id_kurikulum = $krl->id_kurikulum;
		}

		foreach ($data['skl'] as $sk)
		{
			$data['nama_sekolah'] = $sk->nama;
			$prov = $sk->prov;
			$kab = $sk->kab;
			$kec = $sk->kec;
			$desa = $sk->desa;

			$data['prov'] = all("provinsi","id_prov",$prov,"nama");
			$data['kab'] = all("kabupaten","id_kab",$kab,"nama");
			$data['kec'] = all("kecamatan","id_kec",$kec,"nama");
			$data['desa'] = all("kelurahan","id_kel",$desa,"nama");



		}

		$jenjang=db_jenjang($id_sekolah);
	    $siswa="siswa_".$jenjang;
		$nm_siswa=all($siswa, "id_siswa", $id_siswa, "nama_lengkap");
		//$nis=all($siswa, "id_siswa", $id_siswa, "nis");
		$nisn=all($siswa, "id_siswa", $id_siswa, "nisn");
		$rombel="rombongan_belajar_".$jenjang;
		$data['tampilsiswa']=$this->m_models->get_data("$siswa.id_siswa, nama_lengkap, nis, id_kelas", $rombel, "join $siswa on $rombel.id_siswa = $siswa.id_siswa where $rombel.id_siswa='$id_siswa' and $rombel.id_tahun='$id_tahun'");
		$data['nm_siswa']=$nm_siswa;
		$data['nisn']=$nisn;
		$data['nis']=$data['tampilsiswa'][0]->nis;
		$idkls=$data['tampilsiswa'][0]->id_kelas;
		$ars = array('id_tahun' => $id_tahun, 'id_kelas'=>$idkls);
	    $kls = $this->m_models->getTabelwhere("*", "kelas", $ars, "nama_kelas", "asc");
	    $data['nm_kelas'] = $kls[0]->nama_kelas;

	    $data['wali_kelas'] = all("pegawai","nrp", $kls[0]->nrp,"nama");
	    $nrp_wakel = $kls[0]->nrp;
	    $data['nrp_wakel']=$nrp_wakel;
	    $data['nm_walikelas']=all("pegawai", "nrp", $nrp_wakel, "nama");
		$data['semester']=all("satuan_waktu_pendidikan", "id_satuan_waktu", $smt, "nama_satuan");
		$data['thn_pelajaran']=all("tahun_akademik", "id_tahun", $id_tahun, "periode");
		$ex=explode(" ", $nm_siswa);
		$nm_awal=$ex[0];

		#kepsek		
		$ar_k = array('status_aktf' => 'Aktif', 'id_jabatan'=> 4,'id_sekolah'=>$id_sekolah);
	    $pegawai = $this->m_models->getTabelwhere("nama, nrp", "pegawai", $ar_k, "nama", "asc");
	    $data['nm_kepsek'] = $pegawai[0]->nama;
	    $data['nrp_kepsek'] = $pegawai[0]->nrp;


		#NILAI SOSIAL		
		$ar_sosial = array('id_siswa' => $id_siswa, 'id_tahun'=>$id_tahun, 'semester'=>$smt, 'r_nilai_sosial.jenis'=>"PAS");
	    $n_sosial = $this->m_models->getJoin1where("*", "r_nilai_sosial", "r_predikat", "r_predikat.id_r_predikat=r_nilai_sosial.id_r_predikat", $ar_sosial, "id_siswa", "asc");
	    $data['predikat_sosial'] = $n_sosial[0]->predikat;
	    $data['deskripsi_sosial'] = "Ananda ".$nm_awal." ".$n_sosial[0]->deskripsi;

		#NILAI SPIRITUAL
		$ar_spiritual = array('id_siswa' => $id_siswa, 'id_tahun'=>$id_tahun, 'semester'=>$smt, 'r_nilai_spiritual.jenis'=>"PAS");
	    $n_spiritual = $this->m_models->getJoin1where("*", "r_nilai_spiritual", "r_predikat", "r_predikat.id_r_predikat=r_nilai_spiritual.id_r_predikat", $ar_spiritual, "id_siswa", "asc");
	    $data['predikat_spiritual'] = $n_spiritual[0]->predikat;
	    $data['deskripsi_spiritual'] = "Ananda ".$nm_awal." ".$n_spiritual[0]->deskripsi;

	    #nilai pengetahuan
	    $armp = array('id_kurikulum' => $id_kurikulum);
	    $data['urutan_mapel'] = $this->m_models->getJoin1where("*", "r_urutan_mapel", "mata_pelajaran", "mata_pelajaran.id_mapel=r_urutan_mapel.id_mapel",  $armp, "urutan", "asc");
	    foreach ($data['urutan_mapel'] as $um){
		    #KKM
		    $a_kkm = array('id_tahun' => $id_tahun, 'id_sekolah'=>$id_sekolah, 'id_kelas'=>$idkls, 'id_satuan_waktu'=>$smt, 'id_mapel'=>$um->id_mapel);
	    	$data['d_kkm'] = $this->m_models->getTabelwhere("kkm", "jadwal_mapel", $a_kkm, "kkm", "asc");
	    	$data['kkm'][$um->id_mapel] = $data['d_kkm'][0]->kkm;

	    	#nilai akhir pengetahuan
	    	$a_na = array('id_sekolah' => $id_sekolah, 'id_mapel'=>$um->id_mapel, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_komponen_penilaian'=>1, 'id_kategori_ujian'=>'12');
		    $data['nilai_akhir'] = $this->m_models->getTabelwhere("*", "tb_nilai_akhir_".$jenjang, $a_na, "id_siswa", "asc"); 
		    $na_pengetahuan=$data['nilai_akhir'][0]->nilai_angka==0;
	    	if (($um->id_mapel=="20")&&($na_pengetahuan==0)){
	    		$data['na_pengetahuan'][$um->id_mapel]=nilai_pai($id_sekolah, $id_tahun, $smt, $id_siswa, '1', '12');
	    	} else {
	    		$data['na_pengetahuan'][$um->id_mapel]=$data['nilai_akhir'][0]->nilai_angka;
	    	}
		   
		  /* 	#JML KD
		   	$a_kd = array('id_sekolah' => $id_sekolah, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_komponen_penilaian'=>'12', 'id_mapel'=>$um->id_mapel, 'id_kelas'=>$idkls);
		    $data['jmlkd'] = $this->m_models->getTabelwhere("*", "r_jml_kd", $a_kd, "id_j_kd", "asc");	
		    $j_kd = $this->m_models->getRowsAWhere("*", "r_jml_kd", $a_kd, "id_j_kd", "asc");
		    if ($j_kd==0){
		    	$data['jml_kd'] = 0;
		    } else {
		    	$data['jml_kd'] = $data['jmlkd'][0]->jml_kd;
		    }*/
		    

	    	#nilai akhir keterampilan
	    	$a_na_k = array('id_sekolah' => $id_sekolah, 'id_mapel'=>$um->id_mapel, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_komponen_penilaian'=>2, 'id_kategori_ujian'=>'12');
	    	$data['nilai_akhir_k'] = $this->m_models->getTabelwhere("*", "tb_nilai_akhir_".$jenjang, $a_na_k, "id_siswa", "asc");
	    	$na_keterampilan=$data['nilai_akhir_k'][0]->nilai_angka;
	    	if (($um->id_mapel=="20")&&($na_keterampilan==0)){
	    		$data['na_keterampilan'][$um->id_mapel]=nilai_pai($id_sekolah, $id_tahun, $smt, $id_siswa, '2', '12');
	    	} else {
	    		$data['na_keterampilan'][$um->id_mapel]=$data['nilai_akhir_k'][0]->nilai_angka;
	    	}
	    }


	    #CETAK HALAMAN 2
	    #NILAI EKSKUL
	    $ar_eks = array('id_siswa' => $id_siswa, 'ekskul_nilai_ekskul.id_satuan_waktu'=>$smt, 'id_tahun'=>$id_tahun, 'id_kategori_ujian'=>'12');
	    $data['keg_ekskul'] = $this->m_models->getJoin2Awhere("nama_ekskul, nilai_ekskul", "ekskul_nilai_ekskul", "satuan_waktu_pendidikan", "satuan_waktu_pendidikan.id_satuan_waktu=ekskul_nilai_ekskul.id_satuan_waktu", "ekskul_nama_ekskul", "ekskul_nama_ekskul.id_nama_ekskul=ekskul_nilai_ekskul.id_nama_ekskul", $ar_eks, "nama_ekskul", "asc");
	    $data['j_keg_ekskul'] = $this->m_models->getRowsJoin2Where("nama_ekskul, nilai_ekskul", "ekskul_nilai_ekskul", "satuan_waktu_pendidikan", "satuan_waktu_pendidikan.id_satuan_waktu=ekskul_nilai_ekskul.id_satuan_waktu", "ekskul_nama_ekskul", "ekskul_nama_ekskul.id_nama_ekskul=ekskul_nilai_ekskul.id_nama_ekskul", $ar_eks, "nama_ekskul", "asc");

	    #NILAI PRESTASI
	    $a_na_pres = array('id_sekolah' => $id_sekolah, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_kategori_ujian'=>'12');
	    $data['keg_prestasi'] = $this->m_models->getTabelwhere("*", "siswa_prestasi_lomba_".$jenjang, $a_na_pres, "id_siswa", "asc");
	    $data['j_keg_prestasi'] = $this->m_models->getRows("siswa_prestasi_lomba_".$jenjang." where id_sekolah='$id_sekolah' and id_tahun='$id_tahun' and id_satuan_waktu='$smt' and id_kategori_ujian='12' and id_siswa='$id_siswa'");

	    #NILAI KEGIATAN SEKOLAH
	    $a_na_keg = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa);
	    $data['keg_sekolah'] = $this->m_models->getTabelwhere("*", "r_keg_sekolah", $a_na_keg, "tgl_mulai, jenis_kegiatan", "asc");
	    $data['j_keg_sekolah'] = $this->m_models->getRows("r_keg_sekolah where id_tahun='$id_tahun' and id_satuan_waktu='$smt' and id_siswa='$id_siswa'");


	    #ABSENSI SISWA
	    #SAKIT
	    $as = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'S');
	   	$data['j_sakit'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_".$jenjang, $as, "id_siswa", "asc");
	   	#IZIN
	   	$ai = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'I');
	   	$data['j_izin'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_".$jenjang, $ai, "id_siswa", "asc");
	   	#TK
	   	$atk = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'TK');
	   	$data['j_tk'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_".$jenjang, $atk, "id_siswa", "asc");


 


		$this->load->view('raport/raport_sma_k13', $data);
		$this->load->library('pdf');
		$this->pdf->setPaper("Letter", 'portrait');
		$this->pdf->setPaper($customPaper, 'potrait');
		$this->pdf->load_view('raport/raport_sma_k13', $data);
		$this->pdf->render();
		$this->pdf->stream("Raport_PAS_".$nm_siswa.".pdf", array('Attachment'=>0));
	}



	// Raport PAS 

	public function raport_sma_ktsp(){ 


		// mencari Kode Kurikulum K13 SMP



		$nrp=$this->session->userdata['nrp']; 
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$id_siswa = $this->uri->segment(3);
		$id_tahun = $this->uri->segment(4);
		$smt = $this->uri->segment(5);


		$data['kepribadian'] = $this->m_models->getAll("r_kategori_kepribadian where id_sekolah='$id_sekolah' and status='on'");
		$data['skl'] = $this->m_models->getDataByID("sekolah","id_sekolah",$id_sekolah);

		$data['kr'] = $this->m_models->getAll("sekolah_kurikulum where id_sekolah='$id_sekolah' and nama_kurikulum like '%ktsp%' ");
		foreach ($data['kr'] as $krl)
		{
			$id_kurikulum = $krl->id_kurikulum;
		}

		foreach ($data['skl'] as $sk)
		{
			$data['nama_sekolah'] = $sk->nama;
			$prov = $sk->prov;
			$kab = $sk->kab;
			$kec = $sk->kec;
			$desa = $sk->desa;

			$data['prov'] = all("provinsi","id_prov",$prov,"nama");
			$data['kab'] = all("kabupaten","id_kab",$kab,"nama");
			$data['kec'] = all("kecamatan","id_kec",$kec,"nama");
			$data['desa'] = all("kelurahan","id_kel",$desa,"nama");



		}

		$jenjang=db_jenjang($id_sekolah);
	    $siswa="siswa_".$jenjang;
		$nm_siswa=all($siswa, "id_siswa", $id_siswa, "nama_lengkap");
		//$nis=all($siswa, "id_siswa", $id_siswa, "nis");
		$nisn=all($siswa, "id_siswa", $id_siswa, "nisn");
		$rombel="rombongan_belajar_".$jenjang;
		$data['tampilsiswa']=$this->m_models->get_data("$siswa.id_siswa, nama_lengkap, nis, id_kelas", $rombel, "join $siswa on $rombel.id_siswa = $siswa.id_siswa where $rombel.id_siswa='$id_siswa' and $rombel.id_tahun='$id_tahun'");
		$data['nm_siswa']=$nm_siswa;
		$data['nisn']=$nisn;
		$data['nis']=$data['tampilsiswa'][0]->nis;
		$idkls=$data['tampilsiswa'][0]->id_kelas;
		$ars = array('id_tahun' => $id_tahun, 'id_kelas'=>$idkls);
	    $kls = $this->m_models->getTabelwhere("*", "kelas", $ars, "nama_kelas", "asc");
	    $data['nm_kelas'] = $kls[0]->nama_kelas;

	    $data['wali_kelas'] = all("pegawai","nrp", $kls[0]->nrp,"nama");
	    $nrp_wakel = $kls[0]->nrp;
	    $data['nrp_wakel']=$nrp_wakel;
	    $data['nm_walikelas']=all("pegawai", "nrp", $nrp_wakel, "nama");
		$data['semester']=all("satuan_waktu_pendidikan", "id_satuan_waktu", $smt, "nama_satuan");
		$data['thn_pelajaran']=all("tahun_akademik", "id_tahun", $id_tahun, "periode");
		$ex=explode(" ", $nm_siswa);
		$nm_awal=$ex[0];

		#kepsek		
		$ar_k = array('status_aktf' => 'Aktif', 'id_jabatan'=> 4,'id_sekolah'=>$id_sekolah);
	    $pegawai = $this->m_models->getTabelwhere("nama, nrp", "pegawai", $ar_k, "nama", "asc");
	    $data['nm_kepsek'] = $pegawai[0]->nama;
	    $data['nrp_kepsek'] = $pegawai[0]->nrp;


		#NILAI SOSIAL		
		$ar_sosial = array('id_siswa' => $id_siswa, 'id_tahun'=>$id_tahun, 'semester'=>$smt, 'r_nilai_sosial.jenis'=>"PAS");
	    $n_sosial = $this->m_models->getJoin1where("*", "r_nilai_sosial", "r_predikat", "r_predikat.id_r_predikat=r_nilai_sosial.id_r_predikat", $ar_sosial, "id_siswa", "asc");
	    $data['predikat_sosial'] = $n_sosial[0]->predikat;
	    $data['deskripsi_sosial'] = "Ananda ".$nm_awal." ".$n_sosial[0]->deskripsi;

		#NILAI SPIRITUAL
		$ar_spiritual = array('id_siswa' => $id_siswa, 'id_tahun'=>$id_tahun, 'semester'=>$smt, 'r_nilai_spiritual.jenis'=>"PAS");
	    $n_spiritual = $this->m_models->getJoin1where("*", "r_nilai_spiritual", "r_predikat", "r_predikat.id_r_predikat=r_nilai_spiritual.id_r_predikat", $ar_spiritual, "id_siswa", "asc");
	    $data['predikat_spiritual'] = $n_spiritual[0]->predikat;
	    $data['deskripsi_spiritual'] = "Ananda ".$nm_awal." ".$n_spiritual[0]->deskripsi;

	    #nilai pengetahuan
	    $armp = array('id_kurikulum' => $id_kurikulum);
	    $data['urutan_mapel'] = $this->m_models->getJoin1where("*", "r_urutan_mapel", "mata_pelajaran", "mata_pelajaran.id_mapel=r_urutan_mapel.id_mapel",  $armp, "urutan", "asc");
	    foreach ($data['urutan_mapel'] as $um){
		    #KKM
		    $a_kkm = array('id_tahun' => $id_tahun, 'id_sekolah'=>$id_sekolah, 'id_kelas'=>$idkls, 'id_satuan_waktu'=>$smt, 'id_mapel'=>$um->id_mapel);
	    	$data['d_kkm'] = $this->m_models->getTabelwhere("kkm", "jadwal_mapel", $a_kkm, "kkm", "asc");
	    	$data['kkm'][$um->id_mapel] = $data['d_kkm'][0]->kkm;

	    	#nilai akhir pengetahuan
	    	$a_na = array('id_sekolah' => $id_sekolah, 'id_mapel'=>$um->id_mapel, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_komponen_penilaian'=>1, 'id_kategori_ujian'=>'12');
		    $data['nilai_akhir'] = $this->m_models->getTabelwhere("*", "tb_nilai_akhir_".$jenjang, $a_na, "id_siswa", "asc"); 
		    $na_pengetahuan=$data['nilai_akhir'][0]->nilai_angka==0;
	    	if (($um->id_mapel=="20")&&($na_pengetahuan==0)){
	    		$data['na_pengetahuan'][$um->id_mapel]=nilai_pai($id_sekolah, $id_tahun, $smt, $id_siswa, '1', '12');
	    	} else {
	    		$data['na_pengetahuan'][$um->id_mapel]=$data['nilai_akhir'][0]->nilai_angka;
	    	}
		   
		  /* 	#JML KD
		   	$a_kd = array('id_sekolah' => $id_sekolah, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_komponen_penilaian'=>'12', 'id_mapel'=>$um->id_mapel, 'id_kelas'=>$idkls);
		    $data['jmlkd'] = $this->m_models->getTabelwhere("*", "r_jml_kd", $a_kd, "id_j_kd", "asc");	
		    $j_kd = $this->m_models->getRowsAWhere("*", "r_jml_kd", $a_kd, "id_j_kd", "asc");
		    if ($j_kd==0){
		    	$data['jml_kd'] = 0;
		    } else {
		    	$data['jml_kd'] = $data['jmlkd'][0]->jml_kd;
		    }*/
		    

	    	#nilai akhir keterampilan
	    	$a_na_k = array('id_sekolah' => $id_sekolah, 'id_mapel'=>$um->id_mapel, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_komponen_penilaian'=>2, 'id_kategori_ujian'=>'12');
	    	$data['nilai_akhir_k'] = $this->m_models->getTabelwhere("*", "tb_nilai_akhir_".$jenjang, $a_na_k, "id_siswa", "asc");
	    	$na_keterampilan=$data['nilai_akhir_k'][0]->nilai_angka;
	    	if (($um->id_mapel=="20")&&($na_keterampilan==0)){
	    		$data['na_keterampilan'][$um->id_mapel]=nilai_pai($id_sekolah, $id_tahun, $smt, $id_siswa, '2', '12');
	    	} else {
	    		$data['na_keterampilan'][$um->id_mapel]=$data['nilai_akhir_k'][0]->nilai_angka;
	    	}
	    }


	    #CETAK HALAMAN 2
	    #NILAI EKSKUL
	    $ar_eks = array('id_siswa' => $id_siswa, 'ekskul_nilai_ekskul.id_satuan_waktu'=>$smt, 'id_tahun'=>$id_tahun, 'id_kategori_ujian'=>'12');
	    $data['keg_ekskul'] = $this->m_models->getJoin2Awhere("nama_ekskul, nilai_ekskul", "ekskul_nilai_ekskul", "satuan_waktu_pendidikan", "satuan_waktu_pendidikan.id_satuan_waktu=ekskul_nilai_ekskul.id_satuan_waktu", "ekskul_nama_ekskul", "ekskul_nama_ekskul.id_nama_ekskul=ekskul_nilai_ekskul.id_nama_ekskul", $ar_eks, "nama_ekskul", "asc");
	    $data['j_keg_ekskul'] = $this->m_models->getRowsJoin2Where("nama_ekskul, nilai_ekskul", "ekskul_nilai_ekskul", "satuan_waktu_pendidikan", "satuan_waktu_pendidikan.id_satuan_waktu=ekskul_nilai_ekskul.id_satuan_waktu", "ekskul_nama_ekskul", "ekskul_nama_ekskul.id_nama_ekskul=ekskul_nilai_ekskul.id_nama_ekskul", $ar_eks, "nama_ekskul", "asc");

	    #NILAI PRESTASI
	    $a_na_pres = array('id_sekolah' => $id_sekolah, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_kategori_ujian'=>'12');
	    $data['keg_prestasi'] = $this->m_models->getTabelwhere("*", "siswa_prestasi_lomba_".$jenjang, $a_na_pres, "id_siswa", "asc");
	    $data['j_keg_prestasi'] = $this->m_models->getRows("siswa_prestasi_lomba_".$jenjang." where id_sekolah='$id_sekolah' and id_tahun='$id_tahun' and id_satuan_waktu='$smt' and id_kategori_ujian='12' and id_siswa='$id_siswa'");

	    #NILAI KEGIATAN SEKOLAH
	    $a_na_keg = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa);
	    $data['keg_sekolah'] = $this->m_models->getTabelwhere("*", "r_keg_sekolah", $a_na_keg, "tgl_mulai, jenis_kegiatan", "asc");
	    $data['j_keg_sekolah'] = $this->m_models->getRows("r_keg_sekolah where id_tahun='$id_tahun' and id_satuan_waktu='$smt' and id_siswa='$id_siswa'");


	    #ABSENSI SISWA
	    #SAKIT
	    $as = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'S');
	   	$data['j_sakit'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_".$jenjang, $as, "id_siswa", "asc");
	   	#IZIN
	   	$ai = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'I');
	   	$data['j_izin'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_".$jenjang, $ai, "id_siswa", "asc");
	   	#TK
	   	$atk = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'TK');
	   	$data['j_tk'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_".$jenjang, $atk, "id_siswa", "asc");


 


		$this->load->view('raport/raport_sma_ktsp', $data);
		$this->load->library('pdf');
		$this->pdf->setPaper("Letter", 'portrait');
		$this->pdf->setPaper($customPaper, 'potrait');
		$this->pdf->load_view('raport/raport_sma_ktsp', $data);
		$this->pdf->render();
		$this->pdf->stream("Raport_PAS_".$nm_siswa.".pdf", array('Attachment'=>0));
	}


	// KTSP SMP
	public function raport_smp_ktsp(){ 


		// mencari Kode Kurikulum K13 SMP



		$nrp=$this->session->userdata['nrp']; 
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$id_siswa = $this->uri->segment(3);
		$id_tahun = $this->uri->segment(4);
		$smt = $this->uri->segment(5);


		$data['kepribadian'] = $this->m_models->getAll("r_kategori_kepribadian where id_sekolah='$id_sekolah' and status='on'");
		$data['skl'] = $this->m_models->getDataByID("sekolah","id_sekolah",$id_sekolah);

		$data['kr'] = $this->m_models->getAll("sekolah_kurikulum where id_sekolah='$id_sekolah' and nama_kurikulum like '%ktsp%' ");
		foreach ($data['kr'] as $krl)
		{
			$id_kurikulum = $krl->id_kurikulum;
		}

		foreach ($data['skl'] as $sk)
		{
			$data['nama_sekolah'] = $sk->nama;
			$prov = $sk->prov;
			$kab = $sk->kab;
			$kec = $sk->kec;
			$desa = $sk->desa;

			$data['prov'] = all("provinsi","id_prov",$prov,"nama");
			$data['kab'] = all("kabupaten","id_kab",$kab,"nama");
			$data['kec'] = all("kecamatan","id_kec",$kec,"nama");
			$data['desa'] = all("kelurahan","id_kel",$desa,"nama");



		}

		$jenjang=db_jenjang($id_sekolah);
	    $siswa="siswa_".$jenjang;
		$nm_siswa=all($siswa, "id_siswa", $id_siswa, "nama_lengkap");
		//$nis=all($siswa, "id_siswa", $id_siswa, "nis");
		$nisn=all($siswa, "id_siswa", $id_siswa, "nisn");
		$rombel="rombongan_belajar_".$jenjang;
		$data['tampilsiswa']=$this->m_models->get_data("$siswa.id_siswa, nama_lengkap, nis, id_kelas", $rombel, "join $siswa on $rombel.id_siswa = $siswa.id_siswa where $rombel.id_siswa='$id_siswa' and $rombel.id_tahun='$id_tahun'");
		$data['nm_siswa']=$nm_siswa;
		$data['nisn']=$nisn;
		$data['nis']=$data['tampilsiswa'][0]->nis;
		$idkls=$data['tampilsiswa'][0]->id_kelas;
		$ars = array('id_tahun' => $id_tahun, 'id_kelas'=>$idkls);
	    $kls = $this->m_models->getTabelwhere("*", "kelas", $ars, "nama_kelas", "asc");
	    $data['nm_kelas'] = $kls[0]->nama_kelas;

	    $data['wali_kelas'] = all("pegawai","nrp", $kls[0]->nrp,"nama");
	    $nrp_wakel = $kls[0]->nrp;
	    $data['nrp_wakel']=$nrp_wakel;
	    $data['nm_walikelas']=all("pegawai", "nrp", $nrp_wakel, "nama");
		$data['semester']=all("satuan_waktu_pendidikan", "id_satuan_waktu", $smt, "nama_satuan");
		$data['thn_pelajaran']=all("tahun_akademik", "id_tahun", $id_tahun, "periode");
		$ex=explode(" ", $nm_siswa);
		$nm_awal=$ex[0];

		#kepsek		
		$ar_k = array('status_aktf' => 'Aktif', 'id_jabatan'=> 4,'id_sekolah'=>$id_sekolah);
	    $pegawai = $this->m_models->getTabelwhere("nama, nrp", "pegawai", $ar_k, "nama", "asc");
	    $data['nm_kepsek'] = $pegawai[0]->nama;
	    $data['nrp_kepsek'] = $pegawai[0]->nrp;


		#NILAI SOSIAL		
		$ar_sosial = array('id_siswa' => $id_siswa, 'id_tahun'=>$id_tahun, 'semester'=>$smt, 'r_nilai_sosial.jenis'=>"PAS");
	    $n_sosial = $this->m_models->getJoin1where("*", "r_nilai_sosial", "r_predikat", "r_predikat.id_r_predikat=r_nilai_sosial.id_r_predikat", $ar_sosial, "id_siswa", "asc");
	    $data['predikat_sosial'] = $n_sosial[0]->predikat;
	    $data['deskripsi_sosial'] = "Ananda ".$nm_awal." ".$n_sosial[0]->deskripsi;

		#NILAI SPIRITUAL
		$ar_spiritual = array('id_siswa' => $id_siswa, 'id_tahun'=>$id_tahun, 'semester'=>$smt, 'r_nilai_spiritual.jenis'=>"PAS");
	    $n_spiritual = $this->m_models->getJoin1where("*", "r_nilai_spiritual", "r_predikat", "r_predikat.id_r_predikat=r_nilai_spiritual.id_r_predikat", $ar_spiritual, "id_siswa", "asc");
	    $data['predikat_spiritual'] = $n_spiritual[0]->predikat;
	    $data['deskripsi_spiritual'] = "Ananda ".$nm_awal." ".$n_spiritual[0]->deskripsi;

	    #nilai pengetahuan
	    $armp = array('id_kurikulum' => $id_kurikulum);
	    $data['urutan_mapel'] = $this->m_models->getJoin1where("*", "r_urutan_mapel", "mata_pelajaran", "mata_pelajaran.id_mapel=r_urutan_mapel.id_mapel",  $armp, "urutan", "asc");
	    foreach ($data['urutan_mapel'] as $um){
		    #KKM
		    $a_kkm = array('id_tahun' => $id_tahun, 'id_sekolah'=>$id_sekolah, 'id_kelas'=>$idkls, 'id_satuan_waktu'=>$smt, 'id_mapel'=>$um->id_mapel);
	    	$data['d_kkm'] = $this->m_models->getTabelwhere("kkm", "jadwal_mapel", $a_kkm, "kkm", "asc");
	    	$data['kkm'][$um->id_mapel] = $data['d_kkm'][0]->kkm;

	    	#nilai akhir pengetahuan
	    	$a_na = array('id_sekolah' => $id_sekolah, 'id_mapel'=>$um->id_mapel, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_komponen_penilaian'=>1, 'id_kategori_ujian'=>'12');
		    $data['nilai_akhir'] = $this->m_models->getTabelwhere("*", "tb_nilai_akhir_".$jenjang, $a_na, "id_siswa", "asc"); 
		    $na_pengetahuan=$data['nilai_akhir'][0]->nilai_angka==0;
	    	if (($um->id_mapel=="20")&&($na_pengetahuan==0)){
	    		$data['na_pengetahuan'][$um->id_mapel]=nilai_pai($id_sekolah, $id_tahun, $smt, $id_siswa, '1', '12');
	    	} else {
	    		$data['na_pengetahuan'][$um->id_mapel]=$data['nilai_akhir'][0]->nilai_angka;
	    	}
		   
		  /* 	#JML KD
		   	$a_kd = array('id_sekolah' => $id_sekolah, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_komponen_penilaian'=>'12', 'id_mapel'=>$um->id_mapel, 'id_kelas'=>$idkls);
		    $data['jmlkd'] = $this->m_models->getTabelwhere("*", "r_jml_kd", $a_kd, "id_j_kd", "asc");	
		    $j_kd = $this->m_models->getRowsAWhere("*", "r_jml_kd", $a_kd, "id_j_kd", "asc");
		    if ($j_kd==0){
		    	$data['jml_kd'] = 0;
		    } else {
		    	$data['jml_kd'] = $data['jmlkd'][0]->jml_kd;
		    }*/
		    

	    	#nilai akhir keterampilan
	    	$a_na_k = array('id_sekolah' => $id_sekolah, 'id_mapel'=>$um->id_mapel, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_komponen_penilaian'=>2, 'id_kategori_ujian'=>'12');
	    	$data['nilai_akhir_k'] = $this->m_models->getTabelwhere("*", "tb_nilai_akhir_".$jenjang, $a_na_k, "id_siswa", "asc");
	    	$na_keterampilan=$data['nilai_akhir_k'][0]->nilai_angka;
	    	if (($um->id_mapel=="20")&&($na_keterampilan==0)){
	    		$data['na_keterampilan'][$um->id_mapel]=nilai_pai($id_sekolah, $id_tahun, $smt, $id_siswa, '2', '12');
	    	} else {
	    		$data['na_keterampilan'][$um->id_mapel]=$data['nilai_akhir_k'][0]->nilai_angka;
	    	}
	    }


	    #CETAK HALAMAN 2
	    #NILAI EKSKUL
	    $ar_eks = array('id_siswa' => $id_siswa, 'ekskul_nilai_ekskul.id_satuan_waktu'=>$smt, 'id_tahun'=>$id_tahun, 'id_kategori_ujian'=>'12');
	    $data['keg_ekskul'] = $this->m_models->getJoin2Awhere("nama_ekskul, nilai_ekskul", "ekskul_nilai_ekskul", "satuan_waktu_pendidikan", "satuan_waktu_pendidikan.id_satuan_waktu=ekskul_nilai_ekskul.id_satuan_waktu", "ekskul_nama_ekskul", "ekskul_nama_ekskul.id_nama_ekskul=ekskul_nilai_ekskul.id_nama_ekskul", $ar_eks, "nama_ekskul", "asc");
	    $data['j_keg_ekskul'] = $this->m_models->getRowsJoin2Where("nama_ekskul, nilai_ekskul", "ekskul_nilai_ekskul", "satuan_waktu_pendidikan", "satuan_waktu_pendidikan.id_satuan_waktu=ekskul_nilai_ekskul.id_satuan_waktu", "ekskul_nama_ekskul", "ekskul_nama_ekskul.id_nama_ekskul=ekskul_nilai_ekskul.id_nama_ekskul", $ar_eks, "nama_ekskul", "asc");

	    #NILAI PRESTASI
	    $a_na_pres = array('id_sekolah' => $id_sekolah, 'id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'id_kategori_ujian'=>'12');
	    $data['keg_prestasi'] = $this->m_models->getTabelwhere("*", "siswa_prestasi_lomba_".$jenjang, $a_na_pres, "id_siswa", "asc");
	    $data['j_keg_prestasi'] = $this->m_models->getRows("siswa_prestasi_lomba_".$jenjang." where id_sekolah='$id_sekolah' and id_tahun='$id_tahun' and id_satuan_waktu='$smt' and id_kategori_ujian='12' and id_siswa='$id_siswa'");

	    #NILAI KEGIATAN SEKOLAH
	    $a_na_keg = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa);
	    $data['keg_sekolah'] = $this->m_models->getTabelwhere("*", "r_keg_sekolah", $a_na_keg, "tgl_mulai, jenis_kegiatan", "asc");
	    $data['j_keg_sekolah'] = $this->m_models->getRows("r_keg_sekolah where id_tahun='$id_tahun' and id_satuan_waktu='$smt' and id_siswa='$id_siswa'");


	    #ABSENSI SISWA
	    #SAKIT
	    $as = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'S');
	   	$data['j_sakit'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_".$jenjang, $as, "id_siswa", "asc");
	   	#IZIN
	   	$ai = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'I');
	   	$data['j_izin'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_".$jenjang, $ai, "id_siswa", "asc");
	   	#TK
	   	$atk = array('id_tahun'=>$id_tahun, 'id_satuan_waktu'=>$smt, 'id_siswa'=>$id_siswa, 'jam_ke'=>'1', 'absensi'=>'TK');
	   	$data['j_tk'] = $this->m_models->getRowsAWhere("*", "tb_agenda_kelas_".$jenjang, $atk, "id_siswa", "asc");


 


		$this->load->view('raport/raport_smp_ktsp', $data);
		$this->load->library('pdf');
		$this->pdf->setPaper("Letter", 'portrait');
		$this->pdf->setPaper($customPaper, 'potrait');
		$this->pdf->load_view('raport/raport_smp_ktsp', $data);
		$this->pdf->render();
		$this->pdf->stream("Raport_PAS_".$nm_siswa.".pdf", array('Attachment'=>0));
	}





	 }
?>