<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Presensi_tmp extends CI_Controller {
	function __construct() {
		parent::__construct();

		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}

	//	$this->load->model('m_models');
	//	$this->load->helper('tgl_indo');
	}

	function get_pegawai_aktiv(){
		if (isset($_GET['term'])){ 
      		$q = strtolower($_GET['term']);
      		$this->load->model('pegawai_model/Pegawai_model');
			$datacari = $this->Pegawai_model->pegawai_non_sekolah_aktiv($q);

      		if (count($datacari > 0)) {
      			foreach ($datacari as $key) {
      				$row_set[] = $key->nrp.' '.$key->nama;
      			}
      			echo json_encode($row_set);
      		}
    	}
	}

	function hari_english($hari){
		switch($hari){
			case 'ahad':
				$hari = "Sunday";
			break;
	 
			case 'senin':			
				$hari = "Monday";
			break;
	 
			case 'selasa':
				$hari = "Tuesday";
			break;
	 
			case 'rabu':
				$hari = "Wednesday";
			break;
	 
			case 'kamis':
				$hari = "Thursday";
			break;
	 
			case 'jumat':
				$hari = "Friday";
			break;
	 
			case 'sabtu':
				$hari = "Saturday";
			break;
			
			default:
				$hari = "Tidak di ketahui";		
			break;
		}
	 
		return $hari;
	 
	}

	#data_presensi
	function presensi(){
		$this->load->view('template/header');
		$this->load->view('template/date_range_picker');
		$this->load->view('template/dataTables');
		$nrp = $this->session->userdata['nrp'];

		$this->load->model('pegawai_model/Pegawai_model');
		$data['pegawai'] = $this->Pegawai_model->pegawai_non_sekolah();
		$data['sekolah'] = $this->Pegawai_model->sekolah_non_sekolah();

		# tampilkan data ke view
		$this->load->view('spo/presensi', $data); 

		$this->load->view('template/footer');
	}

	function presensi_detail(){ 
		$pegawai = $this->input->post('pegawai', TRUE);
		$divisi = $this->input->post('divisi', TRUE);
		$export_excel = $this->input->post('export_excel', TRUE);

		$rentangtanggal = $this->input->post('rentangtanggal', TRUE);
		$exp = explode("-", $rentangtanggal);
		$tanggal_mulai = to_Ymd2(trim($exp[0])) . " 00:00:00";
		$tanggal_sampai = to_Ymd2(trim($exp[1])) . " 23:59:59";

		$nik = NULL;
		if ($pegawai != 'semua_pegawai') {
			$nik = $pegawai;
		}

		$id_sekolah = NULL;
		if ($divisi != 'semua_divisi') {
			$id_sekolah = $divisi;
		}

		$this->load->model('spo/Abs_jam_kerja_harian_model');
		$data['presensi'] = $this->Abs_jam_kerja_harian_model->getPresensi($tanggal_mulai, $tanggal_sampai, $nik, $id_sekolah);

		if ($export_excel == 'true') {
			// $data['kelas'] = $kelas;
			// $data['tahun'] = $thn;
			// $data['bulan'] = $bln;
			// $this->load->view('boarding/rekap_kondisi_santri_detail_excel', $data);
			$this->load->view('spo/presensi_detail_excel', $data);
		}else{
			$this->load->view('spo/presensi_detail', $data);
		}	
	}

	function resume(){
		$this->load->view('template/header');
		$this->load->view('template/date_range_picker');
		$this->load->view('template/dataTables');
		$nrp = $this->session->userdata['nrp'];

		$this->load->model('pegawai_model/Pegawai_model');
		$data['pegawai'] = $this->Pegawai_model->pegawai_non_sekolah();
		$data['sekolah'] = $this->Pegawai_model->sekolah_non_sekolah();

		$this->load->model('spo/Abs_asrama_model');
		$data['asrama'] = $this->Abs_asrama_model->getAll();

		# tampilkan data ke view
		$this->load->view('spo/resume_tmp', $data); 

		$this->load->view('template/footer');
	}

	function resume_detail(){ 
		$pegawai = $this->input->post('pegawai', TRUE);
		$divisi = $this->input->post('divisi', TRUE);
		$asrama = $this->input->post('asrama', TRUE);
		$export_excel = $this->input->post('export_excel', TRUE);

		$rentangtanggal = $this->input->post('rentangtanggal', TRUE);
		$exp = explode("-", $rentangtanggal);
		$tanggal_mulai = to_Ymd2(trim($exp[0])) . " 00:00:00";
		$tanggal_sampai = to_Ymd2(trim($exp[1])) . " 23:59:59";

		$nik = NULL;
		if ($pegawai != 'semua_pegawai') {
			$nik = $pegawai;
		}

		$id_sekolah = NULL;
		if ($divisi != 'semua_divisi') {
			$id_sekolah = $divisi;
		}

		$id_asrama = NULL;
		if ($asrama != '') {
			$id_asrama = $asrama;
		}

		$this->load->model('spo/Abs_jam_kerja_harian_model');
		$data['resume'] = $this->Abs_jam_kerja_harian_model->getResume($tanggal_mulai, $tanggal_sampai, $nik, $id_sekolah, $id_asrama);

		if ($export_excel == 'true') {
			// $data['kelas'] = $kelas;
			// $data['tahun'] = $thn;
			// $data['bulan'] = $bln;
			// $this->load->view('boarding/rekap_kondisi_santri_detail_excel', $data);
			$this->load->view('spo/resume_detail_excel', $data);
		}else{
			$this->load->view('spo/resume_detail', $data);
		}	
	}


	function shift_kerja_pegawai_harian(){
		$this->load->view('template/header');
		$this->load->view('template/dataTables');
		$nrp = $this->session->userdata['nrp'];

		$this->load->model('pegawai_model/Pegawai_model');
		$data['pegawai'] = $this->Pegawai_model->pegawai_non_sekolah();
		$data['sekolah'] = $this->Pegawai_model->sekolah_non_sekolah();

		# tampilkan data ke view
		$this->load->view('spo/shift_kerja_pegawai_harian', $data); 

		$this->load->view('template/footer');
	}


	function shift_kerja_pegawai_harian_detail(){ 
		$pegawai = $this->input->post('pegawai', TRUE);
		$divisi = $this->input->post('divisi', TRUE);
		$export_excel = $this->input->post('export_excel', TRUE);

		$nik = NULL;
		if ($pegawai != 'semua_pegawai') {
			$nik = $pegawai;
		}

		$id_sekolah = NULL;
		if ($divisi != 'semua_divisi') {
			$id_sekolah = $divisi;
		}

		$this->load->model('spo/Abs_shift_kerja_pegawai_model');
		$data['shift_kerja'] = $this->Abs_shift_kerja_pegawai_model->get_shift_kerja_pegawai_harian($nik, $id_sekolah);

		if ($export_excel == 'true') {
			// $data['kelas'] = $kelas;
			// $data['tahun'] = $thn;
			// $data['bulan'] = $bln;
			// $this->load->view('boarding/rekap_kondisi_santri_detail_excel', $data);
			$this->load->view('spo/shift_kerja_pegawai_harian_detail', $data);
		}else{
			$this->load->view('spo/shift_kerja_pegawai_harian_detail', $data);
		}	
	}

	function shift_kerja_pegawai_pekanan(){
		$this->load->view('template/header');
		$this->load->view('template/dataTables');
		$nrp = $this->session->userdata['nrp'];

		$this->load->model('pegawai_model/Pegawai_model');
		$data['pegawai'] = $this->Pegawai_model->pegawai_non_sekolah();
		$data['sekolah'] = $this->Pegawai_model->sekolah_non_sekolah();

		# tampilkan data ke view
		$this->load->view('spo/shift_kerja_pegawai_pekanan', $data); 

		$this->load->view('template/footer');
	}


	function shift_kerja_pegawai_pekanan_detail(){ 
		$pegawai = $this->input->post('pegawai', TRUE);
		$divisi = $this->input->post('divisi', TRUE);
		$export_excel = $this->input->post('export_excel', TRUE);

		$nik = NULL;
		if ($pegawai != 'semua_pegawai') {
			$nik = $pegawai;
		}

		$id_sekolah = NULL;
		if ($divisi != 'semua_divisi') {
			$id_sekolah = $divisi;
		}

		$this->load->model('spo/Abs_shift_kerja_pegawai_model');
		$data['shift_kerja'] = $this->Abs_shift_kerja_pegawai_model->get_shift_kerja_pegawai_pekanan($nik, $id_sekolah);

		if ($export_excel == 'true') {
			// $data['kelas'] = $kelas;
			// $data['tahun'] = $thn;
			// $data['bulan'] = $bln;
			// $this->load->view('boarding/rekap_kondisi_santri_detail_excel', $data);
			$this->load->view('spo/shift_kerja_pegawai_pekanan_detail', $data);
		}else{
			$this->load->view('spo/shift_kerja_pegawai_pekanan_detail', $data);
		}	
	}

	function pembagian_shift_kerja_pegawai_harian(){
		$this->load->view('template/header');
	//	$this->load->view('template/select2');
		$this->load->view('template/date_range_picker');
		$this->load->view('template/dataTables');

		$this->load->model('pegawai_model/Pegawai_model');
		$data['all_pegawai'] = $this->Pegawai_model->pegawai_non_sekolah_by_presensi('harian');

		if ($this->input->post('nik', TRUE) || $this->uri->segment(3) != '') {
			if ($this->input->post('nik', TRUE)) {
				$nik = $this->input->post('nik', TRUE);
			}else{
				$nik = $this->uri->segment(3);
			}

			# mencari profil pegawai
			$data['pegawai'] = $this->Pegawai_model->getDataByID($nik);

			# mencari shift kerja pegawai berdasarkan id sekolah
			$this->load->model('spo/Abs_shift_kerja_model');
			$data['shift_kerja'] = $this->Abs_shift_kerja_model->getDataWhere($data['pegawai'][0]->id_sekolah);

			$this->load->model('spo/User_finger_karyawan_model');
			$data['user_finger'] = $this->User_finger_karyawan_model->get_by_user_id($nik);

			# mencari shift kerja pegawai yang dipilih
			$this->load->model('spo/Abs_shift_kerja_pegawai_model');
			$data['shift_kerja_pegawai'] = $this->Abs_shift_kerja_pegawai_model->get_shift_kerja_pegawai_harian($nik);
			
		}

		$this->load->view('spo/pembagian_shift_kerja_pegawai_harian', $data); 

		$this->load->view('template/footer');
	}

	function simpan_pembagian_shift_kerja_pegawai_harian(){
		$this->load->model('spo/Abs_shift_kerja_pegawai_model');
		$this->load->model('spo/Abs_shift_kerja_model');
		$this->load->model('spo/Abs_jam_kerja_harian_model');
		$nrp_user = $this->session->userdata['nrp'];

		$nik = $this->input->post('nrp', TRUE); 
		$id_jabatan = $this->input->post('id_jabatan', TRUE); 
		$id_sekolah = $this->input->post('id_sekolah', TRUE); 
		$tanggal_berlaku = $this->input->post('tanggal_berlaku', TRUE);
		$tanggal_berlaku2 = to_Ymd($tanggal_berlaku);

        $arr_hari = array(
          '1' => 'senin', 
          '2' => 'selasa',
          '3' => 'rabu',
          '4' => 'kamis',
          '5' => 'jumat',
          '6' => 'sabtu',
          '7' => 'ahad',
        ); 
        $no = 1;
        foreach ($arr_hari as $k => $nama_hari) {
        	$tanggal_berlaku = $tanggal_berlaku2;

			$hari = $this->input->post('hari'.$nama_hari, TRUE);
			$id_shift_kerja_new = $this->input->post('id_shift_kerja'.$nama_hari, TRUE); 
			$id_shift_kerja_old = $this->input->post('id_shift_kerja_hari'.$nama_hari, TRUE); 

			$shift_kerja = $this->Abs_shift_kerja_model->getOneDataWhere($id_shift_kerja_new);
			$tanggal_kerja_kena_update = $this->Abs_jam_kerja_harian_model->get_tanggal_kerja($nik, $this->hari_english($hari), $tanggal_berlaku);

			if ($id_shift_kerja_old != '' AND $id_shift_kerja_new != '') {
				# update shift kerja pegawai
				$this->Abs_shift_kerja_pegawai_model->update($id_shift_kerja_new, $id_shift_kerja_old, $nik, $this->hari_english($hari), 'all');					
			        
			    $arr_tanggal_kerja_kena_update = array();
				foreach ($tanggal_kerja_kena_update as $key) {
					$arr_tanggal_kerja_kena_update[] = $key->tanggal;
					$tgl_sekarang = $key->tanggal;
					$tgl_besok = date("Y-m-d", strtotime('+1 day', strtotime($tgl_sekarang)));

					$jam_kerja_in = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_in;

					if (strtotime($shift_kerja[0]->jam_kerja_out) < strtotime($shift_kerja[0]->jam_kerja_in)) {
						$jam_kerja_out = $tgl_besok." ".$shift_kerja[0]->jam_kerja_out;
					}else{
						$jam_kerja_out = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_out;
					}

					$scan_in_min = $tgl_sekarang." ".$shift_kerja[0]->scan_in_min;

					if ($shift_kerja[0]->scan_in_max === '00:00:00') {
						$scan_in_max = "0000-00-00 00:00:00";
					}elseif(strtotime($shift_kerja[0]->scan_in_max) < strtotime($shift_kerja[0]->scan_in_min) AND $shift_kerja[0]->scan_in_max != '00:00:00'){
						$scan_in_max = $tgl_besok." ".$shift_kerja[0]->scan_in_max;
					}else{
						$scan_in_max = $tgl_sekarang." ".$shift_kerja[0]->scan_in_max;
					}

					if ($shift_kerja[0]->scan_out_min === '00:00:00') {
						$scan_out_min = "0000-00-00 00:00:00";
					}else{
						$scan_out_min = $tgl_sekarang." ".$shift_kerja[0]->scan_out_min;
					}

					if(strtotime($shift_kerja[0]->scan_out_max) < strtotime($shift_kerja[0]->scan_in_min) ){
						$scan_out_max = $tgl_besok." ".$shift_kerja[0]->scan_out_max;
					}else{
						$scan_out_max = $tgl_sekarang." ".$shift_kerja[0]->scan_out_max;
					}

					$this->Abs_jam_kerja_harian_model->update_shift_kerja(
				        $id_shift_kerja_new,
				        $shift_kerja[0]->nama_shift_kerja,
				        $jam_kerja_in,
				        $jam_kerja_out,
				        $scan_in_min,
				        $scan_in_max,
				        $scan_out_min,
				        $scan_out_max,
				        $key->id
				    );

				}

				$tanggal_sekarang = date("Y-m-d");
				while ( strtotime($tanggal_berlaku ) <= strtotime($tanggal_sekarang)) {
					
					$day = date('l', strtotime($tanggal_berlaku));
					if ($day == $this->hari_english($hari) AND !in_array($tanggal_berlaku, $arr_tanggal_kerja_kena_update)) {
					//	echo $tanggal_berlaku . "<br>";

						$tgl_sekarang = $tanggal_berlaku;
						$tgl_besok = date("Y-m-d", strtotime('+1 day', strtotime($tgl_sekarang)));

						$jam_kerja_in = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_in;

						if (strtotime($shift_kerja[0]->jam_kerja_out) < strtotime($shift_kerja[0]->jam_kerja_in)) {
							$jam_kerja_out = $tgl_besok." ".$shift_kerja[0]->jam_kerja_out;
						}else{
							$jam_kerja_out = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_out;
						}

						$scan_in_min = $tgl_sekarang." ".$shift_kerja[0]->scan_in_min;

						if ($shift_kerja[0]->scan_in_max === '00:00:00') {
							$scan_in_max = "0000-00-00 00:00:00";
						}elseif(strtotime($shift_kerja[0]->scan_in_max) < strtotime($shift_kerja[0]->scan_in_min) AND $shift_kerja[0]->scan_in_max != '00:00:00'){
							$scan_in_max = $tgl_besok." ".$shift_kerja[0]->scan_in_max;
						}else{
							$scan_in_max = $tgl_sekarang." ".$shift_kerja[0]->scan_in_max;
						}

						if ($shift_kerja[0]->scan_out_min === '00:00:00') {
							$scan_out_min = "0000-00-00 00:00:00";
						}else{
							$scan_out_min = $tgl_sekarang." ".$shift_kerja[0]->scan_out_min;
						}

						if(strtotime($shift_kerja[0]->scan_out_max) < strtotime($shift_kerja[0]->scan_in_min) ){
							$scan_out_max = $tgl_besok." ".$shift_kerja[0]->scan_out_max;
						}else{
							$scan_out_max = $tgl_sekarang." ".$shift_kerja[0]->scan_out_max;
						}

						$firstOfMonth = date("Y-m-01", strtotime($tanggal_berlaku));
	    				$minggu_ke = intval(date("W", strtotime("-4 day", strtotime($tanggal_berlaku)))) - intval(date("W", strtotime("-4 day", strtotime($firstOfMonth)))) +1;

						# INPUT JAM KERJA HARIAN
						$this->Abs_jam_kerja_harian_model->input(
							$nik, 
							$id_jabatan, 
							$id_sekolah, 
							$tanggal_berlaku, 
							$day, $minggu_ke, 
							'Jam Kerja', 
							$id_shift_kerja_new, 
							$shift_kerja[0]->nama_shift_kerja, 
					        $jam_kerja_in,
					        $jam_kerja_out,
					        $scan_in_min,
					        $scan_in_max,
					        $scan_out_min,
					        $scan_out_max,
							date("Y-m-d H:i:s"), 
							$nrp_user, 
							NULL 
						);

						$tanggal_berlaku = date("Y-m-d", strtotime('+7 day', strtotime($tanggal_berlaku)));

					}else{
						$tanggal_berlaku = date("Y-m-d", strtotime('+1 day', strtotime($tanggal_berlaku)));
					}
				}	

			}elseif($id_shift_kerja_old == '' AND $id_shift_kerja_new != ''){ 
				$this->Abs_shift_kerja_pegawai_model->input('', $nik, $id_shift_kerja_new, $this->hari_english($hari), 'all');

				$tanggal_sekarang = date("Y-m-d");
				while ( strtotime($tanggal_berlaku ) <= strtotime($tanggal_sekarang)) {
					
					$day = date('l', strtotime($tanggal_berlaku));
					if ($day == $this->hari_english($hari)) {
					//	echo $tanggal_berlaku . "<br>";

						$tgl_sekarang = $tanggal_berlaku;
						$tgl_besok = date("Y-m-d", strtotime('+1 day', strtotime($tgl_sekarang)));

						$jam_kerja_in = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_in;

						if (strtotime($shift_kerja[0]->jam_kerja_out) < strtotime($shift_kerja[0]->jam_kerja_in)) {
							$jam_kerja_out = $tgl_besok." ".$shift_kerja[0]->jam_kerja_out;
						}else{
							$jam_kerja_out = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_out;
						}

						$scan_in_min = $tgl_sekarang." ".$shift_kerja[0]->scan_in_min;

						if ($shift_kerja[0]->scan_in_max === '00:00:00') {
							$scan_in_max = "0000-00-00 00:00:00";
						}elseif(strtotime($shift_kerja[0]->scan_in_max) < strtotime($shift_kerja[0]->scan_in_min) AND $shift_kerja[0]->scan_in_max != '00:00:00'){
							$scan_in_max = $tgl_besok." ".$shift_kerja[0]->scan_in_max;
						}else{
							$scan_in_max = $tgl_sekarang." ".$shift_kerja[0]->scan_in_max;
						}

						if ($shift_kerja[0]->scan_out_min === '00:00:00') {
							$scan_out_min = "0000-00-00 00:00:00";
						}else{
							$scan_out_min = $tgl_sekarang." ".$shift_kerja[0]->scan_out_min;
						}

						if(strtotime($shift_kerja[0]->scan_out_max) < strtotime($shift_kerja[0]->scan_in_min) ){
							$scan_out_max = $tgl_besok." ".$shift_kerja[0]->scan_out_max;
						}else{
							$scan_out_max = $tgl_sekarang." ".$shift_kerja[0]->scan_out_max;
						}

						$firstOfMonth = date("Y-m-01", strtotime($tanggal_berlaku));
	    				$minggu_ke = intval(date("W", strtotime("-4 day", strtotime($tanggal_berlaku)))) - intval(date("W", strtotime("-4 day", strtotime($firstOfMonth)))) +1;

						# INPUT JAM KERJA HARIAN
						$this->Abs_jam_kerja_harian_model->input(
							$nik, 
							$id_jabatan, 
							$id_sekolah, 
							$tanggal_berlaku, 
							$day, $minggu_ke, 
							'Jam Kerja', 
							$id_shift_kerja_new, 
							$shift_kerja[0]->nama_shift_kerja, 
					        $jam_kerja_in,
					        $jam_kerja_out,
					        $scan_in_min,
					        $scan_in_max,
					        $scan_out_min,
					        $scan_out_max,
							date("Y-m-d H:i:s"), 
							$nrp_user, 
							NULL 
						);

						$tanggal_berlaku = date("Y-m-d", strtotime('+7 day', strtotime($tanggal_berlaku)));

					}else{
						$tanggal_berlaku = date("Y-m-d", strtotime('+1 day', strtotime($tanggal_berlaku)));
					}
				}

			}elseif ($id_shift_kerja_old != '' AND $id_shift_kerja_new == '') {
				$this->Abs_shift_kerja_pegawai_model->hapus($id_shift_kerja_old, $nik, $this->hari_english($hari), 'all');
			        
				foreach ($tanggal_kerja_kena_update as $key) {
					$this->Abs_jam_kerja_harian_model->hapus($key->id);
				}		
			}elseif ($id_shift_kerja_old == '' AND $id_shift_kerja_new == '') {
				foreach ($tanggal_kerja_kena_update as $key) {
					$this->Abs_jam_kerja_harian_model->hapus($key->id);
				}
			}

		}

		redirect('presensi/pembagian_shift_kerja_pegawai_harian/'.$nik);

	}


	function pembagian_shift_kerja_pegawai_pekanan(){
		$this->load->view('template/header');
		$this->load->view('template/date_range_picker');
		$this->load->view('template/dataTables');

		$this->load->model('pegawai_model/Pegawai_model');
		$data['all_pegawai'] = $this->Pegawai_model->pegawai_non_sekolah_by_presensi('pekanan');

		if ($this->input->post('nik', TRUE) || $this->uri->segment(3) != '') {
			if ($this->input->post('nik', TRUE)) {
				$nik = $this->input->post('nik', TRUE);
			}else{
				$nik = $this->uri->segment(3);
			}

			# mencari profil pegawai
			$data['pegawai'] = $this->Pegawai_model->getDataByID($nik);

			$this->load->model('spo/User_finger_karyawan_model');
			$data['user_finger'] = $this->User_finger_karyawan_model->get_by_user_id($nik);

			# mencari shift kerja pegawai berdasarkan id sekolah
			$this->load->model('spo/Abs_shift_kerja_model');
			$data['shift_kerja'] = $this->Abs_shift_kerja_model->getDataWhere($data['pegawai'][0]->id_sekolah);

			# mencari shift kerja pegawai yang dipilih
			$this->load->model('spo/Abs_shift_kerja_pegawai_model');
			$data['shift_kerja_pegawai'] = $this->Abs_shift_kerja_pegawai_model->get_shift_kerja_pegawai_pekanan($nik);

			# mencari free kerja pegawai yang dipilih
			$this->load->model('spo/Abs_free_kerja_pegawai_model');
			$data['free_kerja_pegawai'] = $this->Abs_free_kerja_pegawai_model->get_free_kerja_pegawai_pekanan($nik);
			
		}

		$this->load->view('spo/pembagian_shift_kerja_pegawai_pekanan_tmp', $data); 

		$this->load->view('template/footer');
	}

	function simpan_pembagian_shift_kerja_pegawai_pekanan(){
		$this->load->model('spo/Abs_shift_kerja_pegawai_model');
		$this->load->model('spo/Abs_shift_kerja_model');
		$this->load->model('spo/Abs_jam_kerja_harian_model');
		$this->load->model('spo/Abs_free_kerja_pegawai_model');
		$nrp_user = $this->session->userdata['nrp'];

		$nik = $this->input->post('nrp', TRUE); 
		$id_jabatan = $this->input->post('id_jabatan', TRUE); 
		$id_sekolah = $this->input->post('id_sekolah', TRUE); 
		$tanggal_berlaku = $this->input->post('tanggal_berlaku', TRUE);
		$tanggal_berlaku2 = to_Ymd($tanggal_berlaku);



        $arr_hari = array(
          '1' => 'senin', 
          '2' => 'selasa',
          '3' => 'rabu',
          '4' => 'kamis',
          '5' => 'jumat',
          '6' => 'sabtu',
          '7' => 'ahad',
        ); 

        $arr_pekan = array(
          '1' => 'Pekan 1', 
          '2' => 'Pekan 2',
          '3' => 'Pekan 3',
          '4' => 'Pekan 4',
        ); 
        $no = 0;
        foreach ($arr_pekan as $pekan_ke => $pekan) {
			$id_shift_kerja_new_post = $this->input->post('id_shift_kerja'.$pekan_ke, TRUE); 
			$id_shift_kerja_old = $this->input->post('id_shift_kerja_pekan'.$pekan_ke, TRUE); 

			$free_kerja = $this->input->post('free_kerja'.$pekan_ke, TRUE);
			$free_kerja_old = $this->input->post('free_kerja_pekan'.$pekan_ke, TRUE);  

			if ($free_kerja_old != '' AND $free_kerja != '') { 
				# update free kerja pegawai
				$this->Abs_free_kerja_pegawai_model->update($nik, $free_kerja, $pekan_ke);
				
			}elseif($free_kerja_old == '' AND $free_kerja != ''){ 
				# input free kerja pegawai
				$this->Abs_free_kerja_pegawai_model->input($nik, $free_kerja, $pekan_ke);

			}elseif ($free_kerja_old != '' AND $free_kerja == '') { 
				# hapus free kerja pegawai
				$this->Abs_free_kerja_pegawai_model->hapus($nik, $free_kerja, $pekan_ke);

			}

			$shift_kerja = $this->Abs_shift_kerja_model->getOneDataWhere($id_shift_kerja_new_post);

        foreach ($arr_hari as $k => $nama_hari) {
        	$id_shift_kerja_new = $id_shift_kerja_new_post; 
        	$tanggal_berlaku = $tanggal_berlaku2;

			$hari = $nama_hari;
			$tanggal_kerja_kena_update = $this->Abs_jam_kerja_harian_model->get_tanggal_kerja_pekanan($nik, $this->hari_english($hari), $tanggal_berlaku, $pekan_ke);

			# hari libur
			# jika hari pas hari libur dan hari libur 
			if ($free_kerja == $this->hari_english($hari)) {
				$id_shift_kerja_new = '';
			}

			if ($id_shift_kerja_old != '' AND $id_shift_kerja_new != '') {
				# update shift kerja pegawai
		//		$this->Abs_shift_kerja_pegawai_model->update($id_shift_kerja_new, $id_shift_kerja_old, $nik, $this->hari_english($hari), $pekan_ke);					
			        
			    $arr_tanggal_kerja_kena_update = array();
				foreach ($tanggal_kerja_kena_update as $key) {
					$arr_tanggal_kerja_kena_update[] = $key->tanggal;
					$tgl_sekarang = $key->tanggal;
					$tgl_besok = date("Y-m-d", strtotime('+1 day', strtotime($tgl_sekarang)));

					$jam_kerja_in = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_in;

					if (strtotime($shift_kerja[0]->jam_kerja_out) < strtotime($shift_kerja[0]->jam_kerja_in)) {
						$jam_kerja_out = $tgl_besok." ".$shift_kerja[0]->jam_kerja_out;
					}else{
						$jam_kerja_out = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_out;
					}

					$scan_in_min = $tgl_sekarang." ".$shift_kerja[0]->scan_in_min;

					if ($shift_kerja[0]->scan_in_max === '00:00:00') {
						$scan_in_max = "0000-00-00 00:00:00";
					}elseif(strtotime($shift_kerja[0]->scan_in_max) < strtotime($shift_kerja[0]->scan_in_min) AND $shift_kerja[0]->scan_in_max != '00:00:00'){
						$scan_in_max = $tgl_besok." ".$shift_kerja[0]->scan_in_max;
					}else{
						$scan_in_max = $tgl_sekarang." ".$shift_kerja[0]->scan_in_max;
					}

					if ($shift_kerja[0]->scan_out_min === '00:00:00') {
						$scan_out_min = "0000-00-00 00:00:00";
					}else{
						$scan_out_min = $tgl_sekarang." ".$shift_kerja[0]->scan_out_min;
					}

					if(strtotime($shift_kerja[0]->scan_out_max) < strtotime($shift_kerja[0]->scan_in_min) ){
						$scan_out_max = $tgl_besok." ".$shift_kerja[0]->scan_out_max;
					}else{
						$scan_out_max = $tgl_sekarang." ".$shift_kerja[0]->scan_out_max;
					}

					// $this->Abs_jam_kerja_harian_model->update_shift_kerja(
				 //        $id_shift_kerja_new,
				 //        $shift_kerja[0]->nama_shift_kerja,
				 //        $jam_kerja_in,
				 //        $jam_kerja_out,
				 //        $scan_in_min,
				 //        $scan_in_max,
				 //        $scan_out_min,
				 //        $scan_out_max,
				 //        $key->id
				 //    );

				}

				$tanggal_sekarang = date("Y-m-d");
				while ( strtotime($tanggal_berlaku ) <= strtotime($tanggal_sekarang)) {

					$firstOfMonth = date("Y-m-01", strtotime($tanggal_berlaku));
	    			$minggu_ke = intval(date("W", strtotime("-4 day", strtotime($tanggal_berlaku)))) - intval(date("W", strtotime("-4 day", strtotime($firstOfMonth)))) +1;

					$day = date('l', strtotime($tanggal_berlaku));
					if ($day == $this->hari_english($hari) AND !in_array($tanggal_berlaku, $arr_tanggal_kerja_kena_update) AND $minggu_ke == $pekan_ke) {
					//	echo $tanggal_berlaku . "<br>";

						$tgl_sekarang = $tanggal_berlaku;
						$tgl_besok = date("Y-m-d", strtotime('+1 day', strtotime($tgl_sekarang)));

						$jam_kerja_in = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_in;

						if (strtotime($shift_kerja[0]->jam_kerja_out) < strtotime($shift_kerja[0]->jam_kerja_in)) {
							$jam_kerja_out = $tgl_besok." ".$shift_kerja[0]->jam_kerja_out;
						}else{
							$jam_kerja_out = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_out;
						}

						$scan_in_min = $tgl_sekarang." ".$shift_kerja[0]->scan_in_min;

						if ($shift_kerja[0]->scan_in_max === '00:00:00') {
							$scan_in_max = "0000-00-00 00:00:00";
						}elseif(strtotime($shift_kerja[0]->scan_in_max) < strtotime($shift_kerja[0]->scan_in_min) AND $shift_kerja[0]->scan_in_max != '00:00:00'){
							$scan_in_max = $tgl_besok." ".$shift_kerja[0]->scan_in_max;
						}else{
							$scan_in_max = $tgl_sekarang." ".$shift_kerja[0]->scan_in_max;
						}

						if ($shift_kerja[0]->scan_out_min === '00:00:00') {
							$scan_out_min = "0000-00-00 00:00:00";
						}else{
							$scan_out_min = $tgl_sekarang." ".$shift_kerja[0]->scan_out_min;
						}

						if(strtotime($shift_kerja[0]->scan_out_max) < strtotime($shift_kerja[0]->scan_in_min) ){
							$scan_out_max = $tgl_besok." ".$shift_kerja[0]->scan_out_max;
						}else{
							$scan_out_max = $tgl_sekarang." ".$shift_kerja[0]->scan_out_max;
						}

						# INPUT JAM KERJA HARIAN
						// $this->Abs_jam_kerja_harian_model->input(
						// 	$nik, 
						// 	$id_jabatan, 
						// 	$id_sekolah, 
						// 	$tanggal_berlaku, 
						// 	$day, $minggu_ke, 
						// 	'Jam Kerja', 
						// 	$id_shift_kerja_new, 
						// 	$shift_kerja[0]->nama_shift_kerja, 
					 //        $jam_kerja_in,
					 //        $jam_kerja_out,
					 //        $scan_in_min,
					 //        $scan_in_max,
					 //        $scan_out_min,
					 //        $scan_out_max,
						// 	date("Y-m-d H:i:s"), 
						// 	$nrp_user, 
						// 	NULL 
						// );

						$tanggal_berlaku = date("Y-m-d", strtotime('+7 day', strtotime($tanggal_berlaku)));

					}else{
						$tanggal_berlaku = date("Y-m-d", strtotime('+1 day', strtotime($tanggal_berlaku)));
					}
				}	

			}elseif($id_shift_kerja_old == '' AND $id_shift_kerja_new != ''){ 
			//	$this->Abs_shift_kerja_pegawai_model->input('', $nik, $id_shift_kerja_new, $this->hari_english($hari), $pekan_ke);

				$tanggal_sekarang = date("Y-m-d");
				while ( strtotime($tanggal_berlaku ) <= strtotime($tanggal_sekarang)) {
					$firstOfMonth = date("Y-m-01", strtotime($tanggal_berlaku));
	    			$minggu_ke = intval(date("W", strtotime("-4 day", strtotime($tanggal_berlaku)))) - intval(date("W", strtotime("-4 day", strtotime($firstOfMonth)))) +1;

					$day = date('l', strtotime($tanggal_berlaku));
					if ($day == $this->hari_english($hari) AND $minggu_ke == $pekan_ke) {
					//	echo $tanggal_berlaku . "<br>";

						$tgl_sekarang = $tanggal_berlaku;
						$tgl_besok = date("Y-m-d", strtotime('+1 day', strtotime($tgl_sekarang)));

						$jam_kerja_in = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_in;

						if (strtotime($shift_kerja[0]->jam_kerja_out) < strtotime($shift_kerja[0]->jam_kerja_in)) {
							$jam_kerja_out = $tgl_besok." ".$shift_kerja[0]->jam_kerja_out;
						}else{
							$jam_kerja_out = $tgl_sekarang." ".$shift_kerja[0]->jam_kerja_out;
						}

						$scan_in_min = $tgl_sekarang." ".$shift_kerja[0]->scan_in_min;

						if ($shift_kerja[0]->scan_in_max === '00:00:00') {
							$scan_in_max = "0000-00-00 00:00:00";
						}elseif(strtotime($shift_kerja[0]->scan_in_max) < strtotime($shift_kerja[0]->scan_in_min) AND $shift_kerja[0]->scan_in_max != '00:00:00'){
							$scan_in_max = $tgl_besok." ".$shift_kerja[0]->scan_in_max;
						}else{
							$scan_in_max = $tgl_sekarang." ".$shift_kerja[0]->scan_in_max;
						}

						if ($shift_kerja[0]->scan_out_min === '00:00:00') {
							$scan_out_min = "0000-00-00 00:00:00";
						}else{
							$scan_out_min = $tgl_sekarang." ".$shift_kerja[0]->scan_out_min;
						}

						if(strtotime($shift_kerja[0]->scan_out_max) < strtotime($shift_kerja[0]->scan_in_min) ){
							$scan_out_max = $tgl_besok." ".$shift_kerja[0]->scan_out_max;
						}else{
							$scan_out_max = $tgl_sekarang." ".$shift_kerja[0]->scan_out_max;
						}

						# INPUT JAM KERJA HARIAN
						// $this->Abs_jam_kerja_harian_model->input(
						// 	$nik, 
						// 	$id_jabatan, 
						// 	$id_sekolah, 
						// 	$tanggal_berlaku, 
						// 	$day, $minggu_ke, 
						// 	'Jam Kerja', 
						// 	$id_shift_kerja_new, 
						// 	$shift_kerja[0]->nama_shift_kerja, 
					 //        $jam_kerja_in,
					 //        $jam_kerja_out,
					 //        $scan_in_min,
					 //        $scan_in_max,
					 //        $scan_out_min,
					 //        $scan_out_max,
						// 	date("Y-m-d H:i:s"), 
						// 	$nrp_user, 
						// 	NULL 
						// );

						$tanggal_berlaku = date("Y-m-d", strtotime('+7 day', strtotime($tanggal_berlaku)));

					}else{
						$tanggal_berlaku = date("Y-m-d", strtotime('+1 day', strtotime($tanggal_berlaku)));
					}
				}

			}elseif ($id_shift_kerja_old != '' AND $id_shift_kerja_new == '') {
		//		$this->Abs_shift_kerja_pegawai_model->hapus($id_shift_kerja_old, $nik, $this->hari_english($hari), $pekan_ke);
			        
				foreach ($tanggal_kerja_kena_update as $key) {
		//			$this->Abs_jam_kerja_harian_model->hapus($key->id);
				}		
			}elseif ($id_shift_kerja_old == '' AND $id_shift_kerja_new == '') {
				foreach ($tanggal_kerja_kena_update as $key) {
		//			$this->Abs_jam_kerja_harian_model->hapus($key->id);
				}
			}

		}

		}

	//	redirect('presensi_tmp/pembagian_shift_kerja_pegawai_pekanan/'.$nik);

	}

	function f_hapus_log(){ 
		$this->load->view('template/head');
		$log_id = $this->input->post('id', TRUE);

		$this->load->model('spo/Abs_log_model');
		$data['log'] = $this->Abs_log_model->get_by_id($log_id);

		$this->load->view('spo/f_hapus_log', $data); 
	}

	function hapus_log(){
		$this->load->model('spo/Abs_log_model');
		$log_id = $this->input->post('log_id', TRUE);

		# proses hapus
		if ($this->Abs_log_model->hapus($log_id) == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('spo/lihat_log');
	}


	function test_presensi(){
		$this->load->model('spo/Abs_free_kerja_pegawai_model');
		$data = $this->Abs_free_kerja_pegawai_model->input('2150204615', 'Tuesday', '1');

		var_dump($data);


		 //        $arr_pekan = array(
   //        '1' => 'Pekan 1', 
   //        '2' => 'Pekan 2',
   //        '3' => 'Pekan 3',
   //        '4' => 'Pekan 4',
   //      ); 
   //      $no = 1;
   //      foreach ($arr_pekan as $pekan_ke => $pekan) {
   //      	echo $pekan_ke ."<br>";

   //      	$id_shift_kerja_new = $this->input->post('id_shift_kerja'.$pekan_ke, TRUE); 
			// $id_shift_kerja_old = $this->input->post('id_shift_kerja_pekan'.$pekan_ke, TRUE); 

			// echo "id_shift_kerja_new : ".$id_shift_kerja_new ."<br>";
			// echo "id_shift_kerja_old : ".$id_shift_kerja_old ."<br><br>";
			// $this->Abs_shift_kerja_pegawai_model->input('', '007', $no, 'Monday', $pekan_ke);
			// $no++;

   //      }

	// 	$this->load->model('spo/Abs_shift_kerja_pegawai_model');
	// 	$this->load->model('spo/Abs_shift_kerja_model');
	// 	$this->load->model('spo/Abs_jam_kerja_harian_model');

	// 	$this->Abs_shift_kerja_pegawai_model->hapus_shift_kerja_harian('3', '260819.1.114', 'Monday');

	// 	$id_shift_kerja_old = $this->input->post('id_shift_kerja_hari', TRUE); 
	// 	echo $id_shift_kerja_old;

	// //	$hari = 'jumat';
	// 	$tanggal_berlaku = '2019-12-01';

	// 	$tanggal_sekarang = '2019-12-31';
	// 	$no = 1;
	// 	while ( strtotime($tanggal_berlaku ) <= strtotime($tanggal_sekarang)) {
			
	// 		$day = date('l', strtotime($tanggal_berlaku));
	// 		if ($day == 'Monday') {
	// 		//	echo $tanggal_berlaku . "<br>";
	// 			$tanggal_berlaku =date("Y-m-d", strtotime('+7 day', strtotime($tanggal_berlaku)));
	// 		}else{
	// 			$tanggal_berlaku =date("Y-m-d", strtotime('+1 day', strtotime($tanggal_berlaku)));
	// 		}
	// 		//$no++;
	// 		//$tanggal_berlaku =date("Y-m-d", strtotime('+1 day', strtotime($tanggal_berlaku)));
	// 	}


	//	$this->load->model('spo/Abs_jam_kerja_harian_model');
	//	$shift_kerja = $this->Abs_jam_kerja_harian_model->input('007', '1', '1', '2019-12-13', 'Friday', '3', 'Jam Kerja', '1', 'Shift coba', '2019-12-13 08:00:00', '2019-12-13 14:00:00', '2019-12-13 08:00:00', '2019-12-13 08:00:00', '2019-12-13 08:00:00', '2019-12-13 08:00:00', '2019-12-13 08:00:00', '007', NULL );

	//	$this->load->model('spo/Abs_shift_kerja_pegawai_model');
	//	$this->Abs_shift_kerja_pegawai_model->hapus_shift_kerja_harian('2', '000001.1.023', $this->hari_english($hari));

		// $this->load->model('spo/Abs_shift_kerja_model');
		// $shift_kerja = $this->Abs_shift_kerja_model->getOneDataWhere('4');
	//	var_dump($shift_kerja);

		// $this->load->model('spo/Abs_jam_kerja_harian_model');
		// $shift_kerja = $this->Abs_jam_kerja_harian_model->get_tanggal_kerja('000001.1.023', 'Thursday', '2019-12-13');
		// var_dump($shift_kerja);

		// $this->Abs_jam_kerja_harian_model->update_shift_kerja(
	 //        '0',
	 //        'coba',
	 //        $jam_kerja_in,
	 //        $jam_kerja_out,
	 //        $scan_in_min,
	 //        $scan_in_max,
	 //        $scan_out_min,
	 //        $scan_out_max,
	 //        $key->id
	 //    );
	}

	function tes_minggu_ke(){
		$tgl_sekarang = '2019-10-06';
		$hari = date('l', strtotime($tgl_sekarang));
		$firstOfMonth = date("Y-m-01", strtotime($tgl_sekarang));
    	$minggu_ke = intval(date("W", strtotime("-4 day", strtotime($tgl_sekarang)))) - intval(date("W", strtotime("-4 day", strtotime($firstOfMonth)))) +1;

    	echo intval(date("W", strtotime("-4 day", strtotime($firstOfMonth))));
    	echo " ";
    	echo intval(date("W", strtotime("-4 day", strtotime($tgl_sekarang))));

    	echo " ";
    	echo $firstOfMonth;		
	}


}