<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Pinjaman_kary extends CI_Controller {	
	function __construct(){
	    error_reporting(0);
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	public function ajuan_pinjaman(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_tahun=ta_berjalan(); 
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah");
		$hariini=date("Y-m-d");

		$nominal = db_nominal($this->input->post('nominal', TRUE));
		$ket = $this->input->post('ket', TRUE);
		$cicilan = $this->input->post('cicilan', TRUE);
		if (($nominal != "") && ($ket != "")){
			$ar_pinj = array('tanggal' => $hariini, 'nrp_ajuan' => $nrp, 'id_sekolah' => $id_sekolah, 'jumlah_ajuan'=>$nominal, 'ket'=>$ket, 'id_tahun'=>$id_tahun, 'approve1'=>'Proses', 'approve2'=>'Proses', 'approve3'=>'Proses', 'jml_cicilan'=>$cicilan);
			if($this->m_models->save_data($ar_pinj, "k_ajuan_piutangkary") == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('pinjaman_kary/ajuan_pinjaman'); 
		}

		
		$ar_ap = array('nrp_ajuan =' => $nrp);
		$data[ajuan_pinj] = $this->m_models->getTabelWhere("*", "k_ajuan_piutangkary", $ar_ap, "tanggal", "asc");
		$this->load->view('pinjamankaryawan/pengajuan_pinjaman', $data);
		$this->load->view('template/footer');
	}


	public function approval_ajuan_pinjaman(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_tahun=ta_berjalan(); 
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah");
		$id_jabatan = $this->m_models->getSession($nrp, "id_jabatan");
		$hariini=date("Y-m-d");
		$waktu=date("H:i:s");

		$id_ajuan_piutangkary = $this->input->post('id_ajuan_piutangkary', TRUE);
		$ket = $this->input->post('ket', TRUE);
		$alasan = $this->input->post('alasan', TRUE);
		$nominal = $this->input->post('nominal', TRUE);
		$nama = $this->input->post('nama', TRUE);
		$akun1 = $this->input->post('akun1', TRUE);
		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 
		$uraian="Pinjaman Karyawan : ".$nama;	

		if (($alasan != "")&&($id_ajuan_piutangkary != "")&&($ket != "")){
			if ($ket=="A"){
				//update data pengajuan
				$ar_ap= array('jumlah_acc'=>$nominal, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve');
				$update_dt=$this->m_models->update_data($id_ajuan_piutangkary, "id_ajuan_piutangkary", $ar_ap, "k_ajuan_piutangkary");

				//simpan history approval
				$ar_ajuan = array('tgl' => $hariini, 'waktu' => $waktu, 'nrp' => $nrp, 'id_ap'=>$id_ajuan_piutangkary, 'status'=>'Approve', 'keterangan'=>$alasan, 'id_jabatan'=>$id_jabatan);
				$s_app=$this->m_models->save_data($ar_ajuan, "approval_history");

				//simpan ke jurnal
				$ar_jurnal = array('tgl' => $hariini, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nominal, 'akun2'=>'1.1.2.01', 'uraian2'=>$uraian, 'debet2'=>$nominal, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'piutang karyawan', 'id_tahun'=>$id_tahun, 'nrp'=>$nrp);
				$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");

				//simpan tabel pinjaman
				$ar_pinj = array('tanggal' => $hariini, 'no_transaksi' => $no_transaksi, 'jumlah' => $nominal, 'ket'=>$uraian, 'sistem'=>$akun1, 'id_tahun'=>$id_tahun, 'nrp'=>$nrp);
				$s_pinj=$this->m_models->save_data($ar_pinj, "k_piutang_karyawan");
			} else if ($ket=="R"){
				//update data pengajuan
				$ar_ap= array('approve1'=>'Reject', 'approve2'=>'Reject', 'approve3'=>'Reject');
				$update_dt=$this->m_models->update_data($id_ajuan_piutangkary, "id_ajuan_piutangkary", $ar_ap, "k_ajuan_piutangkary");

				//simpan history approval
				$ar_ajuan = array('tgl' => $hariini, 'waktu' => $waktu, 'nrp' => $nrp, 'id_ap'=>$id_ajuan_piutangkary, 'status'=>'Reject', 'keterangan'=>$alasan, 'id_jabatan'=>$id_jabatan);
				$s_app=$this->m_models->save_data($ar_ajuan, "approval_history");
			}

			if($s_app == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('pinjaman_kary/approval_ajuan_pinjaman'); 
		}


		$ar_ap = array('approve3 =' => 'Proses');
		$data[ajuan_pinj] = $this->m_models->getTabelWhere("*", "k_ajuan_piutangkary", $ar_ap, "tanggal", "asc");
		$where=array('id_sekolah =' => $id_sekolah, 'akun.id_akun like'=>'1.1.1.%');
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");
		$this->load->view('pinjamankaryawan/app_pengajuan_pinjaman', $data);
		$this->load->view('template/footer');
	}


	public function piutang_karyawan(){
		$this->load->view('template/header');

		$ar_sklh = array('status_aktif' => 'on');
		$data[sekolah] = $this->m_models->getTabelWhere("*", "sekolah", $ar_sklh, "nama", "asc");
		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE);
		$id_sekolah = $this->input->post('id_sekolah', TRUE);
		$data['ds']="$dari-$sampai";

		if (($dari != "") && ($sampai != "") && ($id_sekolah != "")){
			$ar_kary = array('status_aktf' => 'Aktif', 'id_sekolah'=>$id_sekolah);
			$data['pegawai'] = $this->m_models->getTabelWhere("*", "pegawai", $ar_kary, "nama", "asc");
			foreach ($data['pegawai'] as $p){
				//pinjaman karyawan
				$ar_pinj = array('nrp' => $p->nrp, 'tanggal >='=>$dari, 'tanggal <='=>$sampai);
				$data['pinjaman'] = $this->m_models->getTabelWhere("*", "k_piutang_karyawan", $ar_pinj, "tanggal", "asc");
				//$pinjaman=0;
				foreach ($data['pinjaman'] as $pinj) {
					$pinjaman += $pinj->jumlah;
					$data['jml_pinjaman'][$p->nrp]=$pinjaman; 
				}

				//pembayaran karyawan
				$ar_pemb = array('nrp' => $p->nrp, 'tgl_bayar >='=>$dari, 'tgl_bayar <='=>$sampai);
				$data['pembayaran'] = $this->m_models->getTabelWhere("*", "k_pembayaran_karyawan", $ar_pemb, "tgl_bayar", "asc");
				$pembayaran=0; $potongan=0; $retur=0;
				foreach ($data['pembayaran'] as $pemb){
					$pembayaran += $pemb->jml_bayar;
					$potongan += $pemb->jml_potongan;
					$retur += $pemb->jml_retur;
					$data['jml_pembayaran'][$p->nrp]=$pembayaran;
					$data['jml_potongan'][$p->nrp]=$potongan;
					$data['jml_retur'][$p->nrp]=$retur;
				}
			}
		}
		$where=array('id_sekolah =' => $id_sekolah, 'akun.id_akun like'=>'1.1.1.%');
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");
		$this->load->view('pinjamankaryawan/piutang_karyawan', $data);
		$this->load->view('pinjamankaryawan/pembayaran_karyawan', $data);
		$this->load->view('pinjamankaryawan/potongan_karyawan', $data);
		$this->load->view('pinjamankaryawan/retur_karyawan', $data);
		$this->load->view('pinjamankaryawan/detail_pinjkaryawan', $data);
		$this->load->view('template/footer');
	}

	//pembayaran pinjaman
	function bayar_pinjaman(){
		$nrp=$this->session->userdata['nrp']; 
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah");
		$where=array('id_sekolah =' => $id_sekolah, 'akun.id_akun like'=>'1.1.1.%');
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");
		$this->load->view('pinjamankaryawan/pembayaran_karyawan', $data);
	}

	function bayar_piutangkary(){
		$petugas=$this->session->userdata['nrp']; 
		$id_sekolah = $this->m_models->getSession($petugas, "id_sekolah");
		$id_tahun=ta_berjalan(); 

		$nrp_pegawai = $this->input->post('nrp', TRUE);
		$nama = $this->input->post('nama', TRUE);
		$ex=explode("-", $this->input->post('tgl', TRUE));
		$tgl = "$ex[2]-$ex[1]-$ex[0]";
		$nominal = db_nominal($this->input->post('nominal', TRUE));
		$akun = $this->input->post('akun', TRUE);
		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 
		$uraian="Pembayaran Piutang Karyawan : ".$nama;


		if (($nrp_pegawai != "") && ($nama != "")&& ($tgl != "")&& ($nominal != "")&& ($akun != "")){
			//simpan ke tabel pembayaran karyawan
			$ar_pemb = array('nrp' => $nrp_pegawai, 'tgl_bayar' => $tgl, 'jml_bayar' => $nominal, 'sistem'=>$akun, 'no_transaksi'=>$no_transaksi, 'petugas'=>$petugas);
			$s_pemb=$this->m_models->save_data($ar_pemb, "k_pembayaran_karyawan");

			//simpan ke jurnal
			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => '1.1.2.01', 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nominal, 'akun2'=>$akun, 'uraian2'=>$uraian, 'debet2'=>$nominal, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran piutang karyawan', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
			$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
 

			if($s_jurnal == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('pinjaman_kary/piutang_karyawan'); 
		}
	}

	//potongan pinjaman
	function potongan_pinjaman(){
		$this->load->view('pinjamankaryawan/potongan_karyawan', $data);
	}
	
	function pot_piutangkary(){
		$petugas=$this->session->userdata['nrp']; 
		$id_sekolah = $this->m_models->getSession($petugas, "id_sekolah");
		$id_tahun=ta_berjalan(); 

		$nrp_pegawai = $this->input->post('nrp', TRUE);
		$nama = $this->input->post('nama', TRUE);
		$ket = $this->input->post('ket', TRUE);
		$ex=explode("-", $this->input->post('tgl', TRUE));
		$tgl = "$ex[2]-$ex[1]-$ex[0]";
		$nominal = db_nominal($this->input->post('nominal', TRUE));
		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 
		$uraian="Potongan Pembayaran Karyawan : ".$nama;


		if (($nrp_pegawai != "") && ($nama != "")&& ($tgl != "")&& ($nominal != "")){
			//simpan ke tabel pembayaran karyawan
			$ar_pemb = array('nrp' => $nrp_pegawai, 'tgl_bayar' => $tgl, 'jml_potongan' => $nominal, 'no_transaksi'=>$no_transaksi, 'petugas'=>$petugas, 'ket_potongan'=>$ket);
			$s_pemb=$this->m_models->save_data($ar_pemb, "k_pembayaran_karyawan");

			//simpan ke jurnal
			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => '1.1.2.01', 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nominal, 'akun2'=>'5.2.1.01', 'uraian2'=>$uraian, 'debet2'=>$nominal, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran piutang karyawan', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
			$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");

 

			if($s_jurnal == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('pinjaman_kary/piutang_karyawan'); 
		}
	}

	//retur pinjaman
	function retur_pinjaman(){
		$petugas=$this->session->userdata['nrp']; 
		$id_sekolah = $this->m_models->getSession($petugas, "id_sekolah");
		$id_tahun=ta_berjalan(); 
		$where=array('id_sekolah =' => $id_sekolah, 'akun.id_akun like'=>'1.1.1.%');
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");

		$this->load->view('pinjamankaryawan/retur_karyawan', $data);
	}

	function retur_piutangkary(){
		$petugas=$this->session->userdata['nrp']; 
		$id_sekolah = $this->m_models->getSession($petugas, "id_sekolah");
		$id_tahun=ta_berjalan(); 
		$where=array('id_sekolah =' => $id_sekolah, 'akun.id_akun like'=>'1.1.1.%');
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");

		$nrp_pegawai = $this->input->post('nrp', TRUE);
		$nama = $this->input->post('nama', TRUE);
		$akun = $this->input->post('akun', TRUE);
		$ex=explode("-", $this->input->post('tgl', TRUE));
		$tgl = "$ex[2]-$ex[1]-$ex[0]";
		$nominal = db_nominal($this->input->post('nominal', TRUE));
		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 
		$uraian="Retur Pembayaran Karyawan : ".$nama;


		if (($nrp_pegawai != "") && ($nama != "")&& ($tgl != "")&& ($nominal != "")&&($akun != "")){
			//simpan ke tabel pembayaran karyawan
			$ar_pemb = array('nrp' => $nrp_pegawai, 'tgl_bayar' => $tgl, 'jml_retur' => $nominal, 'no_transaksi'=>$no_transaksi, 'petugas'=>$petugas, 'sistem'=>$akun);
			$s_pemb=$this->m_models->save_data($ar_pemb, "k_pembayaran_karyawan");

			//simpan ke jurnal
			$ar_jurnal = array('tgl' => $tgl, 'no_transaksi' => $no_transaksi, 'akun1' => $akun, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nominal, 'akun2'=>'1.1.2.01', 'uraian2'=>$uraian, 'debet2'=>$nominal, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'pembayaran piutang karyawan', 'id_tahun'=>$id_tahun, 'nrp'=>$petugas);
			$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");
	
 

			if($s_jurnal == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('pinjaman_kary/piutang_karyawan'); 
		}
	}

	public function detail_pinjaman(){
		$id = $this->input->post('id', TRUE);
		$ex = explode("-", $id);
		$nrp=$ex[0];
		$dari="$ex[1]-$ex[2]-$ex[3]";
		$sampai="$ex[4]-$ex[5]-$ex[6]";
		$data[nrp]=$nrp;
		$data[dari]=$dari;
		$data[sampai]=$sampai;

		//pinjaman karyawan
		$ar_pinj = array('nrp' => $nrp, 'tanggal >='=>$dari, 'tanggal <='=>$sampai);
		$data['pinjaman'] = $this->m_models->getTabelWhere("*", "k_piutang_karyawan", $ar_pinj, "tanggal", "asc");
		
		//pembayaran karyawan
		$ar_pemb = array('nrp' => $nrp, 'tgl_bayar >='=>$dari, 'tgl_bayar <='=>$sampai, 'jml_bayar != '=>"0");
		$data['pembayaran'] = $this->m_models->getTabelWhere("*", "k_pembayaran_karyawan", $ar_pemb, "tgl_bayar", "asc");

		$ar_pot = array('nrp' => $nrp, 'tgl_bayar >='=>$dari, 'tgl_bayar <='=>$sampai, 'jml_potongan != '=>"0");
		$data['potongan'] = $this->m_models->getTabelWhere("*", "k_pembayaran_karyawan", $ar_pot, "tgl_bayar", "asc");

		$ar_retur = array('nrp' => $nrp, 'tgl_bayar >='=>$dari, 'tgl_bayar <='=>$sampai, 'jml_retur != '=>"0");
		$data['retur'] = $this->m_models->getTabelWhere("*", "k_pembayaran_karyawan", $ar_retur, "tgl_bayar", "asc");

		$this->load->view('pinjamankaryawan/detail_pinjkaryawan', $data);
	}

	public function ajuan_kasbon(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_tahun=ta_berjalan(); 
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah");
		$hariini=date("Y-m-d");

		$nominal = db_nominal($this->input->post('nominal', TRUE));
		$ket = $this->input->post('ket', TRUE);
		$cicilan = $this->input->post('cicilan', TRUE);
		if (($nominal != "") && ($ket != "")){
			$ar_pinj = array('tanggal' => $hariini, 'nrp_ajuan' => $nrp, 'id_sekolah' => $id_sekolah, 'jumlah_ajuan'=>$nominal, 'ket'=>$ket, 'id_tahun'=>$id_tahun, 'approve1'=>'Proses', 'approve2'=>'Proses', 'approve3'=>'Proses');
			if($this->m_models->save_data($ar_pinj, "k_ajuan_kasbon") == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('pinjaman_kary/ajuan_kasbon'); 
		}

		$ar_ap = array('nrp_ajuan =' => $nrp);
		$data[ajuan_pinj] = $this->m_models->getTabelWhere("*", "k_ajuan_kasbon", $ar_ap, "tanggal", "asc");
		$this->load->view('pinjamankaryawan/pengajuan_kasbon', $data);
		$this->load->view('template/footer');
	}

	public function approval_ajuan_kasbon(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 
		$id_tahun=ta_berjalan(); 
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah");
		$id_jabatan = $this->m_models->getSession($nrp, "id_jabatan");
		$hariini=date("Y-m-d");
		$waktu=date("H:i:s");

		$id_ajuan_kasbon = $this->input->post('id_ajuan_kasbon', TRUE);
		$ket = $this->input->post('ket', TRUE);
		$alasan = $this->input->post('alasan', TRUE);
		$nominal = $this->input->post('nominal', TRUE);
		$nama = $this->input->post('nama', TRUE);
		$akun1 = $this->input->post('akun1', TRUE);
		$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 
		$uraian="Kasbon Karyawan : ".$nama;	

		if (($alasan != "")&&($id_ajuan_kasbon != "")&&($ket != "")){
			if ($ket=="A"){
				//update data pengajuan
				$ar_ap= array('jumlah_acc'=>$nominal, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve');
				$update_dt=$this->m_models->update_data($id_ajuan_kasbon, "id_ajuan_kasbon", $ar_ap, "k_ajuan_kasbon");

				//simpan history approval
				$ar_ajuan = array('tgl' => $hariini, 'waktu' => $waktu, 'nrp' => $nrp, 'id_ap'=>$id_ajuan_kasbon, 'status'=>'Approve', 'keterangan'=>$alasan, 'id_jabatan'=>$id_jabatan);
				$s_app=$this->m_models->save_data($ar_ajuan, "approval_history");

				//simpan ke jurnal
				$ar_jurnal = array('tgl' => $hariini, 'no_transaksi' => $no_transaksi, 'akun1' => $akun1, 'uraian1'=>$uraian, 'debet1'=>'0', 'kredit1'=>$nominal, 'akun2'=>'1.1.2.01', 'uraian2'=>$uraian, 'debet2'=>$nominal, 'kredit2'=>'0', 'id_sekolah'=>$id_sekolah, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Approve', 'asal'=>'piutang karyawan', 'id_tahun'=>$id_tahun, 'nrp'=>$nrp);
				$s_jurnal=$this->m_models->save_data($ar_jurnal, "jurnal");

				//simpan tabel pinjaman
				$ar_pinj = array('tanggal' => $hariini, 'no_transaksi' => $no_transaksi, 'jumlah' => $nominal, 'ket'=>$uraian, 'sistem'=>$akun1, 'id_tahun'=>$id_tahun, 'nrp'=>$nrp);
				$s_pinj=$this->m_models->save_data($ar_pinj, "k_piutang_kasbon");
			} else if ($ket=="R"){
				//update data pengajuan
				$ar_ap= array('approve1'=>'Reject', 'approve2'=>'Reject', 'approve3'=>'Reject');
				$update_dt=$this->m_models->update_data($id_ajuan_piutangkary, "id_ajuan_kasbon", $ar_ap, "k_ajuan_kasbon");

				//simpan history approval
				$ar_ajuan = array('tgl' => $hariini, 'waktu' => $waktu, 'nrp' => $nrp, 'id_ap'=>$id_ajuan_kasbon, 'status'=>'Reject', 'keterangan'=>$alasan, 'id_jabatan'=>$id_jabatan);
				$s_app=$this->m_models->save_data($ar_ajuan, "approval_history");
			}

			if($s_app == TRUE){
		    	$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		    }else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
	    	}
			redirect('pinjaman_kary/approval_ajuan_kasbon'); 
		}


		$ar_ap = array('approve3 =' => 'Proses');
		$data[ajuan_pinj] = $this->m_models->getTabelWhere("*", "k_ajuan_kasbon", $ar_ap, "tanggal", "asc");
		$where=array('id_sekolah =' => $id_sekolah, 'akun.id_akun like'=>'1.1.1.%');
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");
		$this->load->view('pinjamankaryawan/approval_ajuan_kasbon', $data);
		$this->load->view('template/footer');
	}

	public function kasbon_karyawan(){
		$this->load->view('template/header');

		$ar_sklh = array('status_aktif' => 'on');
		$data[sekolah] = $this->m_models->getTabelWhere("*", "sekolah", $ar_sklh, "nama", "asc");
		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE);
		$id_sekolah = $this->input->post('id_sekolah', TRUE);
		$data['ds']="$dari-$sampai";

		if (($dari != "") && ($sampai != "") && ($id_sekolah != "")){
			$ar_kary = array('status_aktf' => 'Aktif', 'id_sekolah'=>$id_sekolah);
			$data['pegawai'] = $this->m_models->getTabelWhere("*", "pegawai", $ar_kary, "nama", "asc");
			foreach ($data['pegawai'] as $p){
				//pinjaman karyawan
				$ar_pinj = array('nrp' => $p->nrp, 'tanggal >='=>$dari, 'tanggal <='=>$sampai);
				$data['pinjaman'] = $this->m_models->getTabelWhere("*", "k_piutang_kasbon", $ar_pinj, "tanggal", "asc");
				//$pinjaman=0;
				foreach ($data['pinjaman'] as $pinj) {
					$pinjaman += $pinj->jumlah;
					$data['jml_pinjaman'][$p->nrp]=$pinjaman; 
				}
			}
		}
		$where=array('id_sekolah =' => $id_sekolah, 'akun.id_akun like'=>'1.1.1.%');
		$data['akun'] = $this->m_models->getJoin1where("*", "akun", "pilihan_akun", "pilihan_akun.id_akun=akun.id_akun", $where, "akun.id_akun", "asc");
		$this->load->view('pinjamankaryawan/kasbon_karyawan', $data);
		$this->load->view('template/footer');
	}


}