<?php
error_reporting(0);
defined('BASEPATH') OR exit('No direct script access allowed');
class Personal extends CI_Controller {
	function __construct() {
		parent::__construct();
		$this->load->helper('url');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}
	
	public function odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$this->load->view('personal/odoj');
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	public function anggota_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama");
		$data['kelompok'] = $this->m_models->getAll("kelompok_odoj join pegawai on pegawai.nrp=kelompok_odoj.nrp_pj");
		$data['anggota'] = $this->m_models->getAll("anggota_odoj join kelompok_odoj on kelompok_odoj.nrp_pj=anggota_odoj.nrp join pegawai on pegawai.nrp=anggota_odoj.nrp");
		$nrp=$data['anggota'][0]->nrp_pj;
		$data['pegawai_pj'] = $this->m_models->getAll("pegawai where nrp='$nrp' order by nama");
		$data['pj']=$data['pegawai_pj'][0]->nama;
		$this->load->view('personal/anggota_odoj',$data);
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	public function simpan_anggota_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$kelompok = $this->input->post('kelompok');
		$nrp = $this->input->post('nrp');
		if (($kelompok != "")&&($nrp != "")){
			$simpan=$this->db->query("INSERT INTO anggota_odoj VALUES ('', '$nrp', '$kelompok',now(),'0000-00-00')") or die (mysql_error());
			if ($simpan == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		}
		redirect('personal/anggota_odoj');
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	public function kelompok_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$data['kelompok'] = $this->m_models->getAll("kelompok_odoj join pegawai on pegawai.nrp=kelompok_odoj.nrp_pj");
		$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama");
		$this->load->view('personal/kelompok_odoj',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	public function detail_kelompok_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$id_kel = $this->uri->segment(3);
		$data['anggota'] = $this->m_models->getAll("anggota_odoj join pegawai on pegawai.nrp=anggota_odoj.nrp join kelompok_odoj on kelompok_odoj.id_kel_odoj=anggota_odoj.kelompok where kelompok='$id_kel'");
		foreach ($data['anggota'] as $anggt){
			$id_jab=$anggt->id_jabatan;
			$id_sklh=$anggt->id_sekolah;
			$data['jabatan'] = $this->m_models->getAll("jabatan where id_jabatan='$id_jab'");
			$data['sekolah'] = $this->m_models->getAll("sekolah where id_sekolah='$id_sklh'");
			$data['pj'] = $this->m_models->getAll("pegawai where nrp='$anggt->nrp_pj'");
			$sklh=$data[sekolah][0]->nama;
			$jab=$data[jabatan][0]->nama_jabatan;
			$pj=$data[pj][0]->nama;			
			$data[arr]=array("$anggt->nama_kel_odoj", "$pj", "$anggt->nrp", "$anggt->nama", "$sklh", "$jab");
		}
		$this->load->view('personal/detail_kelompok_odoj',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function hapus_kelompok_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$id_kel_odoj = $this->uri->segment(3);
		$hapus=$this->m_models->delete_data($id_kel_odoj, "kelompok", "anggota_odoj");
		if ($this->m_models->delete_data($id_kel_odoj, "id_kel_odoj", "kelompok_odoj") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dihapus');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('personal/kutipan');
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	public function simpan_kelompok_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$nama = $this->input->post('nama');
		$pj = $this->input->post('pj');
		
		if (($nama != "")&&($pj != "")){
			$this->db->query("INSERT INTO kelompok_odoj VALUES ('', '$nama', '$pj')") or die (mysql_error());
			
			$data[kelompok]= $this->m_models->getAll("kelompok_odoj where nama_kel_odoj='$nama' and nrp_pj='$pj'");
			$id_kel=$data[kelompok][0]->id_kel_odoj;
			$nrp_peg=$this->input->post('nrp');
			for ($j=0; $j<=50; $j++){
				$nrp = $nrp_peg[$j]; 
				if (($nrp != "")){
					$simpan=$this->db->query("INSERT INTO anggota_odoj VALUES ('', '$nrp', '$id_kel',now(),'0000-00-00')") or die (mysql_error());
				}
			}
			if ($simpan == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		}
		redirect('personal/kelompok_odoj');
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function edit_kelompok_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$id_kel_odoj = $this->uri->segment(3);
		$data['id_kel_odoj']=$id_kel_odoj;
		$data['kelompok'] = $this->m_models->getAll("kelompok_odoj join pegawai on pegawai.nrp=kelompok_odoj.nrp_pj where id_kel_odoj=$id_kel_odoj");
		$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' order by nama");
		$data['anggota'] = $this->m_models->getAll("anggota_odoj join pegawai on pegawai.nrp=anggota_odoj.nrp where kelompok=$id_kel_odoj");
		$this->load->view('personal/edit_kelompok_odoj',$data);

		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function update_kelompok_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$nama = $this->input->post('nama');
		$pj = $this->input->post('pj');
		$id_kel_odoj = $this->input->post('id_kel_odoj');
		$nrp_peg=$this->input->post('nrp');

		$arrwhere=array('nama_kel_odoj ' =>$nama, 'nrp_pj'=>$pj);
		$update_dt = $this->m_models->update_data($id_kel_odoj, "id_kel_odoj", $arrwhere, "kelompok_odoj");
		for ($j=0; $j<=50; $j++){ 
			$ex=explode("-", $nrp_peg[$j]);
			$id_ao=$ex[1];
			$hari=date("Y-m-d");
			if ($id_ao==""){
				$nrp=$nrp_peg[$j];
				$as=array('nrp' => $nrp, 'kelompok' => $id_kel_odoj, 'tgl_on' => $hari);
				//$simpan = $this->m_models->save_data($as, "anggota_odoj");
			} else {
				$nrp=$ex[0];
				$ap=array('kelompok =' => $id_kel_odoj);
				$data['anggota'] = $this->m_models->getTabelwhere("*", "anggota_odoj", $ap, "id_ao", "asc");
				foreach ($data['anggota'] as $a) {
					if ($a->id_ao != $id_ao){
						$ar=array('tgl_off ' =>$hari);
						//$updt = $this->m_models->update_data($id_ao, "id_ao", $ar, "anggota_odoj");
					}
				}
			}
		}
		
		if ($update_dt == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('personal/kelompok_odoj');
		$this->load->view('template/footer');
	}

	
	public function setoran_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$hak_akses=$this->session->userdata('hak_akses'); 
		$nrp=$this->session->userdata('nrp'); 
		$jml=substr_count($hak_akses, "+"); 
        $ex=explode("+", $hak_akses);
        for ($i=0; $i<=$jml; $i++){
            $ha=$ex[$i]; 
            $data['h']=$ha;
            if ($ha==50){ 
            	$a += 50;
            } else { 
           		$a += "";	
            }
        }

        if ($a==50){
        	$arraywhere = array('nrp_pj =' => $nrp);
        	$data['anggota'] = $this->m_models->getJoin2where("*", "anggota_odoj", "pegawai", "pegawai.nrp=anggota_odoj.nrp","kelompok_odoj", "kelompok_odoj.id_kel_odoj=anggota_odoj.kelompok", $arraywhere, "", "nama", "asc");
        } else {
        	$arraywhere = array('pegawai.nrp =' => $nrp);
        	$data['anggota'] = $this->m_models->getJoin1where("*", "pegawai", "anggota_odoj", "pegawai on pegawai.nrp=anggota_odoj.nrp", $arraywhere , "nama", "asc");
        }

		$data['setoran'] = $this->m_models->getJoin1("*", "setoran_odoj", "anggota_odoj", "setoran_odoj.id_ao=anggota_odoj.id_ao", "tanggal", "asc");
		foreach ($data['setoran'] as $set_odoj) {
			$arrwhere = array('id_kel_odoj =' => $set_odoj->kelompok);
			$data['angg_odoj'] = $this->m_models->getJoin1where("*","kelompok_odoj","pegawai","kelompok_odoj.nrp_pj=pegawai.nrp", $arrwhere, "nama", "asc");
		}
		
		$this->load->view('personal/setoran_odoj',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function ceksetodoj(){
		$id_ao = $this->input->get('id_ao');

		$tanggal = date("Y-m-d");
		for ($i=0; $i<=3; $i++){ 
			$hari = date('Y-m-d', strtotime('-'.$i.'day', strtotime($tanggal)));
			$jso=cekSetoranOdoj($id_ao, $hari);
			if ($jso==0){ 
				$array_tgl[] = $hari; 
			} 
		} 
		$data['hari']=$array_tgl;
		$data['juz'] = $this->m_models->getTableGroup("*", "ayat_alquran","juz", "juz", "asc");
		$this->load->view('personal/ceksetodoj',$data);
	}

	
	public function simpan_setoran_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$hari=date("Y-m-d");

		$id_ao = $this->input->post('id_ao');
		$juz = $this->input->post('juz');
		$waktu = $this->input->post('waktu');
		$tgl = $this->input->post('tgl');
		if (($id_ao != "")&&($juz != "")){
			$hariini=date("Y-m-d");
			$jset = $this->m_models->getRows("setoran_odoj where tanggal='$tgl' and id_ao='$id_ao'");
			if ($jset==0){
				$simpan=$this->db->query("INSERT INTO setoran_odoj VALUES ('', '$id_ao', '$tgl', '$waktu', '$juz')") or die (mysql_error());
			}

			$nrp=all("anggota_odoj", "id_ao", $id_ao, "nrp");
			$nama_pegawai=all("pegawai", "nrp", $nrp, "nama");
			$j_setor = $this->m_models->getRowsWhere("*", "setoran_odoj", "tanggal", $hari, "id_so", "asc");

			if ($simpan == TRUE){
				$this->session->set_flashdata("sukses", "Laporan sudah dicatat.<br>".
				$nama_pegawai.", kholas ".$juz ."<br>
				Total ".$j_setor." member sudah lapor");
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('personal/setoran_odoj');
		}

		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	
	public function resume_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$data['kelompok'] = $this->m_models->getAll("kelompok_odoj join pegawai on pegawai.nrp=kelompok_odoj.nrp_pj");
		$this->load->view('personal/resume_odoj',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	public function detail_resume_odoj(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$id_kel = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		$hariini=date("Y-m-d");
		if($ket=="B"){
			$data['anggota'] = $this->m_models->getAll("anggota_odoj join pegawai on pegawai.nrp=anggota_odoj.nrp join kelompok_odoj on kelompok_odoj.id_kel_odoj=anggota_odoj.kelompok where kelompok='$id_kel' and id_ao in (select id_ao from setoran_odoj where tanggal='$hariini')");
		} else if($ket=="P"){
			$data['anggota'] = $this->m_models->getAll("anggota_odoj join pegawai on pegawai.nrp=anggota_odoj.nrp join kelompok_odoj on kelompok_odoj.id_kel_odoj=anggota_odoj.kelompok where kelompok='$id_kel' and id_ao not in (select id_ao from setoran_odoj where tanggal='$hariini')");
		}
		foreach ($data['anggota'] as $anggt){
			$data['pj'] = $this->m_models->getAll("pegawai where nrp='$anggt->nrp_pj'");
			$pj=$data[pj][0]->nama;			
			$data[arr]=array("$anggt->nama_kel_odoj", "$pj", "$anggt->nrp", "$anggt->nama", "$sklh", "$jab");
		}
		$this->load->view('personal/detail_resume_odoj',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}






	//Mutaba’ah yaumiyah Ramadhan
	public function myr(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$this->load->view('personal/myr');
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function input_mut_yaumiyah(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$id_jabatan=$this->m_models->getSession($nrp, "id_jabatan");
		$id_sekolah=$this->m_models->getSession($nrp, "id_sekolah");
		$subuh = $this->input->post('subuh');
		$dzuhur = $this->input->post('dzuhur');
		$ashar = $this->input->post('ashar');
		$magrib = $this->input->post('magrib');
		$isya = $this->input->post('isya');
		$qab_subuh = $this->input->post('qab_subuh');
		$qab_dzuhur = $this->input->post('qab_dzuhur');
		$bad_dzuhur = $this->input->post('bad_dzuhur');
		$qab_ashar = $this->input->post('qab_ashar');
		$bad_magrib = $this->input->post('bad_magrib');
		$qab_isya = $this->input->post('qab_isya');
		$bad_isya = $this->input->post('bad_isya');
		$dhuha = $this->input->post('dhuha');
		$qiyamul_lail = $this->input->post('qiyamul_lail');
		$almatsurat_pagi = $this->input->post('almatsurat_pagi');
		$almatsurat_petang = $this->input->post('almatsurat_petang');
		$tilawah = $this->input->post('tilawah');
		$tadabbur = $this->input->post('tadabbur');
		$hafalan_quran = $this->input->post('hafalan_quran');
		$hafalan_hadist = $this->input->post('hafalan_hadist');
		$infaq = $this->input->post('infaq');
		$silaturahmi = $this->input->post('silaturahmi');
		$dzikir = $this->input->post('dzikir');
		$buku = $this->input->post('buku');
		$halaqah = $this->input->post('halaqah');
		$puasa = $this->input->post('puasa');
		$tarawih = $this->input->post('tarawih');
		$tahjil = $this->input->post('tahjil');
		$hariini=date("Y-m-d");
		//$tanggal = date('Y-m-d', strtotime('-1 day', strtotime($hariini)));
		$tanggal = date_db($this->input->post('tgl'));
		$jam = date("h:i:s");
		$amy=array('tanggal like' => "%$tanggal%", 'nrp'=>$nrp);
		$cek = $this->m_models->getRowsAWhere("*", "mutabaah_yaumiyah", $amy, "tanggal", "asc");
		if (($subuh != "") && ($dzuhur != "") && ($ashar != "") && ($magrib != "") && ($isya != "")){
			if($cek == 0){
				$my = array('subuh' => $subuh, 'duhur' => $dzuhur, 'ashar' => $ashar, 'maghrib' => $magrib, 'isya' => $isya, 'qab_subuh' => $qab_subuh, 'qab_duhur' => $qab_dzuhur, 'bad_duhur' => $bad_dzuhur, 'qab_ashar' => $qab_ashar, 'bad_maghrib' => $bad_magrib, 'qab_isya' => $qab_isya, 'bad_isya' => $bad_isya, 'dhuha' => $dhuha, 'qiyamul_lail' => $qiyamul_lail, 'al_matsurat_pagi' => $almatsurat_pagi, 'al_matsurat_petang' => $almatsurat_petang, 'tadabbur' => $tadabbur, 'hafalan_al_quran' => $hafalan_quran, 'hafalan_hadist' => $hafalan_hadist, 'infaq' => $infaq, 'silaturahmi' => $silaturahmi, 'riyadhoh' => $dzikir, 'baca_buku' => $buku, 'halaqah' => $halaqah, 'nrp' => $nrp, 'id_jabatan' => $id_jabatan, 'id_sekolah' => $id_sekolah, 'tanggal' => $tanggal." ".$jam, 'tarawih'=>$tarawih, 'tahjil'=>$tahjil);
				if ($puasa != "T"){
					$ap=array('keterangan' => $puasa, 'nrp' => $nrp, 'id_jabatan' => $id_jabatan, 'id_sekolah' => $id_sekolah, 'tanggal' => "$tanggal $jam", 'puasa' => 'Y');
					$data['puasa'] = $this->m_models->save_data($ap, "m_y_puasa");
				}
				//$data['mutabaah_yaumiyah'] = $this->m_models->save_data($my, "mutabaah_yaumiyah");
				if ($this->m_models->save_data($my, "mutabaah_yaumiyah") == TRUE){
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
				redirect('personal/input_mut_yaumiyah');
			} else {
				$this->session->set_flashdata('gagal', 'Data sudah diinput!!!');
				redirect('personal/input_mut_yaumiyah');
			}
		} else {
			$this->load->view('personal/input_mut_yaumiyah');
		}
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function rekap_mut_yaumiyah(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE);
		$data[dari]=$dari;
		$data[sampai]=$sampai;

		$data[nama_pegawai]=$this->m_models->getSession($nrp, "nama_pegawai");
		$data[nama_sekolah]=$this->m_models->getSession($nrp, "nama_sekolah");
		$data[nama_jabatan]=$this->m_models->getSession($nrp, "nama_jabatan");

		if (($dari != "") && ($sampai != "")){
			$arraywhere=array('mutabaah_yaumiyah.nrp =' => $nrp, 'tanggal >='=>$dari, 'tanggal <='=>$sampai);
			$data['rekap_my'] = $this->m_models->getJoin1where("*", "mutabaah_yaumiyah", "pegawai", "pegawai.nrp=mutabaah_yaumiyah.nrp", $arraywhere, "tanggal", "desc");
			foreach ($data['rekap_my'] as $rm) {
				$tgl=$rm->tanggal;
				$where=array('m_y_puasa.nrp =' => $nrp, 'tanggal =' => $tgl);
				$data['puasa'] = $this->m_models->getJoin1where("*", "m_y_puasa", "pegawai", "pegawai.nrp=m_y_puasa.nrp", $where, "tanggal", "desc");
				if ($data['puasa'][0]->keterangan==""){
					$data[ket][$nrp]="<font class='tc_mrh'><i class='fa fa-times'></i></font>";
				} else {
					$data[ket][$nrp]=$data['puasa'][0]->keterangan;
				}
			}
		}
		
		$this->load->view('personal/rekap_mut_yaumiyah', $data);
		$this->load->view('template/footer');
	}

	public function cetak_rekap_my(){
		$this->load->view('template/head');
		$nrp=$this->session->userdata['nrp'];

		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$data[dari]=$dari;
		$data[sampai]=$sampai;

		$data[nama_pegawai]=$this->m_models->getSession($nrp, "nama_pegawai");
		$data[nama_sekolah]=$this->m_models->getSession($nrp, "nama_sekolah");
		$data[nama_jabatan]=$this->m_models->getSession($nrp, "nama_jabatan");


		if (($dari != "") && ($sampai != "")){
			$arraywhere=array('mutabaah_yaumiyah.nrp =' => $nrp, 'tanggal >='=>$dari, 'tanggal <='=>$sampai);
			$data['rekap_my'] = $this->m_models->getJoin1where("*", "mutabaah_yaumiyah", "pegawai", "pegawai.nrp=mutabaah_yaumiyah.nrp", $arraywhere, "tanggal", "desc");
			foreach ($data['rekap_my'] as $rm) {
				$tgl=$rm->tanggal;
				$where=array('m_y_puasa.nrp =' => $nrp, 'tanggal =' => $tgl);
				$data['puasa'] = $this->m_models->getJoin1where("*", "m_y_puasa", "pegawai", "pegawai.nrp=m_y_puasa.nrp", $where, "tanggal", "desc");
				if ($data['puasa'][0]->keterangan==""){
					$data[ket][$nrp]="Tidak Puasa";
				} else {
					$data[ket][$nrp]=$data['puasa'][0]->keterangan;
				}
			}
		}
		
		$this->load->view('personal/cetak_rekap_my', $data);
	}

	public function lap_mut_yaumiyah(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$data['divisi'] = $this->m_models->getTabelOrder("*", "sekolah", "nama", "asc");

		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE);
		$divisi = $this->input->post('jenjang', TRUE);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[id_sekolah]=$divisi;

		if (($dari != "") && ($sampai != "") && ($divisi != "")){
			$arraywhere=array('tanggal >='=>$dari, 'tanggal <='=>$sampai, 'mutabaah_yaumiyah.id_sekolah'=>$divisi);
			$data['rekap_my'] = $this->m_models->getJoin1where("*", "mutabaah_yaumiyah", "pegawai", "pegawai.nrp=mutabaah_yaumiyah.nrp", $arraywhere, "tanggal", "desc");
			foreach ($data['rekap_my'] as $rm){
				$tgl=$rm->tanggal;
				$where=array('m_y_puasa.nrp =' => $nrp, 'tanggal =' => $tgl);
				$data['puasa'] = $this->m_models->getJoin1where("*", "m_y_puasa", "pegawai", "pegawai.nrp=m_y_puasa.nrp", $where, "tanggal", "desc");
				if ($data['puasa'][0]->keterangan==""){
					$data[ket][$nrp]="<font class='tc_mrh'><i class='fa fa-times'></i></font>";
				} else {
					$data[ket][$nrp]=$data['puasa'][0]->keterangan;
				}
			}
		}
		
		$this->load->view('personal/lap_mut_yaumiyah', $data);
		$this->load->view('template/footer');
	}

	public function cetak_laporan_my(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$divisi = $this->uri->segment(5);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[divisi]=$divisi;

		if (($dari != "") && ($sampai != "") && ($divisi != "")){
			$arraywhere=array('tanggal >='=>$dari, 'tanggal <='=>$sampai, 'mutabaah_yaumiyah.id_sekolah'=>$divisi);
			$data['rekap_my'] = $this->m_models->getJoin1where("*", "mutabaah_yaumiyah", "pegawai", "pegawai.nrp=mutabaah_yaumiyah.nrp", $arraywhere, "tanggal", "desc");
			foreach ($data['rekap_my'] as $rm){
				$tgl=$rm->tanggal;
				$where=array('m_y_puasa.nrp =' => $rm->nrp, 'tanggal =' => $tgl);
				$data['puasa'] = $this->m_models->getJoin1where("*", "m_y_puasa", "pegawai", "pegawai.nrp=m_y_puasa.nrp", $where, "tanggal", "desc");
				if ($data['puasa'][0]->keterangan==""){
					$data[ket][$rm->nrp]="Tidak Puasa";
				} else {
					$data[ket][$rm->nrp]=$data['puasa'][0]->keterangan;
				}
			}
		}
		
		$this->load->view('personal/cetak_laporan_my', $data);
	}

	
	//Mutaba’ah Hafalan Al-Quran
	public function mha(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$this->load->view('personal/mha');
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function kelompok_mha(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$data['kelompok'] = $this->m_models->getJoin1("*", "kelompok_mha", "pegawai", "pegawai.nrp=kelompok_mha.nrp_pj", "nama", "asc");
		$data['pegawai'] = $this->m_models->getwhere("*", "pegawai", "status_aktf", "Aktif", "nama", "asc");
		$this->load->view('personal/kelompok_mha',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function simpan_kelompok_mha(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$nama = $this->input->post('nama');
		$pj = $this->input->post('pj');
		
		if (($nama != "")&&($pj != "")){
			$this->db->query("INSERT INTO kelompok_mha VALUES ('', '$nama', '$pj')") or die (mysql_error());
			
			$data[kelompok]= $this->m_models->getAll("kelompok_mha where nama_kel_mha='$nama' and nrp_pj='$pj'");
			$id_kel=$data[kelompok][0]->id_kel_mha;
			for ($j=1; $j<=50; $j++){
				$nrp_peg= $this->input->post('nrp');
				$nrp = $nrp_peg[$j];
				if (($nrp != "")){
					$simpan=$this->db->query("INSERT INTO anggota_mha VALUES ('', '$nrp', '$id_kel',now(),'0000-00-00')") or die (mysql_error());
				}
			}
			
		}
		if ($simpan == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		redirect('personal/kelompok_mha');
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	public function detail_kelompok_mha(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$id_kel = $this->uri->segment(3);
		$arraywhere=array('kelompok =' => $id_kel, "tgl_off"=>"0000-00-00");
		$data['anggota'] = $this->m_models->getJoin2where("*", "anggota_mha", "pegawai", "pegawai.nrp=anggota_mha.nrp", "kelompok_mha", "kelompok_mha.id_kel_mha=anggota_mha.kelompok", $arraywhere, "", "nama", "asc");	
		$id_kel_mha=$data['anggota'][0]->id_kel_mha;
		$data['kel_mha'] = $this->m_models->getwhere("*", "kelompok_mha", "id_kel_mha", $id_kel_mha);
		foreach ($data['anggota'] as $anggt){
			$id_jab=$anggt->id_jabatan;
			$id_sklh=$anggt->id_sekolah;
			$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "id_sekolah", $anggt->id_sekolah);
			$data['jabatan'] = $this->m_models->getwhere("*", "jabatan", "id_jabatan", $anggt->id_jabatan);
			$data['pj'] = $this->m_models->getwhere("*", "pegawai", "nrp", $anggt->nrp_pj);
			$arr = array('sklh' => $data['sekolah'][0]->nama, 'jab' => $data['jabatan'][0]->nama_jabatan,);
		}
		$this->load->view('personal/detail_kelompok_mha',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function input_setoran_hapalan(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');

		$nrp=$this->session->userdata['nrp'];
		$data['janggota'] = $this->m_models->getRowsWhere("*", "anggota_mha", "nrp", $nrp);
		$jenis_setoran = $this->input->post('jenis_setoran');
		$juz = $this->input->post('juz');
		$srt = $this->input->post('srt');
		$ayat_awal = $this->input->post('ayat_awal');
		$ayat_akhir = $this->input->post('ayat_akhir');
		$data['anggota'] = $this->m_models->getwhere("*", "anggota_mha", "nrp", $nrp);
		$no_anggota=$data['anggota'][0]->id_ao;
		$tgl=date("Y-m-d");


		if ($no_anggota != ""){ 
			if ($juz != ""){
				$ha=array('nrp' => $nrp, 'tanggal' => $tgl, 'jenis_setoran' => $jenis_setoran, 'juz' => $juz, 'status' => 'Proses', 'id_ao' => $no_anggota);
				$simpan = $this->m_models->save_data($ha, "hafalan_alquran");
				if ($simpan == TRUE){
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
				redirect('personal/input_setoran_hapalan');
			} else if (($srt !="")&&($ayat_awal != "")&&($ayat_akhir != "")){ 
				$ha=array('nrp' => $nrp, 'tanggal' => $tgl, 'jenis_setoran' => $jenis_setoran, 'no_surat' => $srt, 'ayat_awal' => $ayat_awal, 'ayat_akhir' => $ayat_akhir, 'status' => 'Proses', 'id_ao' => $no_anggota);
				$simpan = $this->m_models->save_data($ha, "hafalan_alquran");
				if ($simpan == TRUE){
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
				}else{
					$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
				}
				redirect('personal/input_setoran_hapalan');
			} else {
				$this->load->view('personal/input_setoran_hapalan');
			}
		} else if ($no_anggota == ""){
			$this->session->set_flashdata('gagal', 'Maaf, Anda belum menjadi anggota setoran hafalan !!!');
			$this->load->view('personal/input_setoran_hapalan');
		}
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function jenis_setoran_hafalan(){
		error_reporting(0);
		$no_surat=$_GET[srt]; 
		$data['surat_alquran'] = $this->m_models->getTabelOrder("*", "surat_alquran", "no_surat", "asc");
		$data['ayat_awal'] = $this->m_models->getwhere("*", "ayat_alquran", "no_surat", $no_surat );
		$this->load->view('personal/jenis_setoran_hafalan', $data);
	}
	
	public function app_setoran_hapalan(){
		$this->load->view('template/header');
		$id_ha = $this->uri->segment(3);
		$ket = $this->uri->segment(4);
		$nrp_musyrif=$this->session->userdata['nrp'];

		$arraywhere=array('nrp_pj =' => $nrp_musyrif, 'status =' =>'Proses');
		$data['anggota'] = $this->m_models->getJoin3where("*", "anggota_mha", "kelompok_mha", "kelompok_mha.id_kel_mha=anggota_mha.kelompok", "hafalan_alquran", "hafalan_alquran.id_ao=anggota_mha.id_ao", "pegawai", "pegawai.nrp=anggota_mha.nrp", $arraywhere, "nama", "asc");
		if ($ket=="A"){
			$arrwhere=array('status ' =>'Approve');
			$data['update_data'] = $this->m_models->update_data($id_ha, "id_ha", $arrwhere, "hafalan_alquran");
			redirect('personal/app_setoran_hapalan');
		} else if ($ket=="R"){
			$arrwhere=array('status ' =>'Reject');
			$data['update_data'] = $this->m_models->update_data($id_ha, "id_ha", $arrwhere, "hafalan_alquran");
			redirect('personal/app_setoran_hapalan');
		}
		if ($data['update_data'] == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		$this->load->view('personal/app_setoran_hapalan', $data);
		$this->load->view('template/footer');
	}
	
	
	public function rekap_setoran_hapalan(){
		$this->load->view('template/header');
		$nrp_musyrif=$this->session->userdata['nrp'];
		$dari = $this->input->post('dari'); 
		$sampai = $this->input->post('sampai'); 
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		if (($dari != "") && ($sampai != "")){
			$arraywhere=array('nrp_pj =' => $nrp_musyrif, 'status =' =>'Approve', 'tanggal >='=>$dari, 'tanggal <='=>$sampai);
			$data['anggota'] = $this->m_models->getJoin3where("*", "anggota_mha", "kelompok_mha", "kelompok_mha.id_kel_mha=anggota_mha.kelompok", "hafalan_alquran", "hafalan_alquran.id_ao=anggota_mha.id_ao", "pegawai", "pegawai.nrp=anggota_mha.nrp", $arraywhere, "nama", "asc");
		}
			
		$this->load->view('personal/rekap_setoran_hapalan', $data);
		$this->load->view('template/footer');
	}

	public function cetak_rekap_setor_hafalan(){
		$nrp_musyrif=$this->session->userdata['nrp'];
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		if (($dari != "") && ($sampai != "")){
			$arraywhere=array('nrp_pj =' => $nrp_musyrif, 'status =' =>'Approve', 'tanggal >='=>$dari, 'tanggal <='=>$sampai);
			$data['anggota'] = $this->m_models->getJoin3where("*", "anggota_mha", "kelompok_mha", "kelompok_mha.id_kel_mha=anggota_mha.kelompok", "hafalan_alquran", "hafalan_alquran.id_ao=anggota_mha.id_ao", "pegawai", "pegawai.nrp=anggota_mha.nrp", $arraywhere, "nama", "asc");
		}
			
		$this->load->view('personal/cetak_rekap_setor_hafalan', $data);
	}

	public function rekap_hapalan_tuntas(){
		$this->load->view('template/header');
		$ar=array('status_aktf' => 'Aktif');
		$data[musyrif]=$this->m_models->getJoin1where("*", "kelompok_mha", "pegawai", "pegawai.nrp=kelompok_mha.nrp_pj", $ar, "nama", "asc");

		$nrp_musyrif = $this->input->post('nrp_pj'); 
		$juz = $this->input->post('juz'); 
		$data[juz]=$juz;
		$data[nrp_musyrif]=$nrp_musyrif;

		if (($nrp_musyrif != "")&&($juz != "")){
			$arraywhere=array('nrp_pj =' => $nrp_musyrif);
			$data['anggota'] = $this->m_models->getJoin2Awhere("*", "anggota_mha", "kelompok_mha", "kelompok_mha.id_kel_mha=anggota_mha.kelompok", "pegawai", "pegawai.nrp=anggota_mha.nrp", $arraywhere, "nama", "asc");
		}

		$this->load->view('personal/rekap_hapalan_tuntas', $data);
		$this->load->view('template/footer');
	}

	public function cetak_rekap_hafalantuntas(){
		$this->load->view('template/head');
		$ar=array('status_aktf' => 'Aktif');
		$data[musyrif]=$this->m_models->getJoin1where("*", "kelompok_mha", "pegawai", "pegawai.nrp=kelompok_mha.nrp_pj", $ar, "nama", "asc");
		$nrp_musyrif = $this->uri->segment(3);
		$juz = $this->uri->segment(4);
		$data[juz]=$juz;

		if (($nrp_musyrif != "")&&($juz != "")){
			$arraywhere=array('nrp_pj =' => $nrp_musyrif);
			$data['anggota'] = $this->m_models->getJoin2Awhere("*", "anggota_mha", "kelompok_mha", "kelompok_mha.id_kel_mha=anggota_mha.kelompok", "pegawai", "pegawai.nrp=anggota_mha.nrp", $arraywhere, "nama", "asc");
		}
		$this->load->view('personal/cetak_rekap_hafalantuntas', $data);
	}

	public function lap_setoran_hapalan(){
		$this->load->view('template/header');
		$ar=array('status_aktf' => 'Aktif');
		$data[musyrif]=$this->m_models->getJoin1where("*", "kelompok_mha", "pegawai", "pegawai.nrp=kelompok_mha.nrp_pj", $ar, "nama", "asc");

		$dari = $this->input->post('dari'); 
		$sampai = $this->input->post('sampai'); 
		$nrp_musyrif = $this->input->post('nrp_pj'); 
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[nrp_musyrif]=$nrp_musyrif;
		if (($dari != "") && ($sampai != "") && ($nrp_musyrif != "")){
			$arraywhere=array('nrp_pj =' => $nrp_musyrif, 'status =' =>'Approve', 'tanggal >='=>$dari, 'tanggal <='=>$sampai);
			$data['anggota'] = $this->m_models->getJoin3where("*", "anggota_mha", "kelompok_mha", "kelompok_mha.id_kel_mha=anggota_mha.kelompok", "hafalan_alquran", "hafalan_alquran.id_ao=anggota_mha.id_ao", "pegawai", "pegawai.nrp=anggota_mha.nrp", $arraywhere, "nama", "asc");
		}
			
		$this->load->view('personal/lap_setoran_hapalan', $data);
		$this->load->view('template/footer');
	}

	public function cetak_lap_setor_hafalan(){
		$ar=array('status_aktf' => 'Aktif');
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$nrp_musyrif = $this->uri->segment(5);

		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[nrp_musyrif]=$nrp_musyrif;
		if (($dari != "") && ($sampai != "") && ($nrp_musyrif != "")){
			$arraywhere=array('nrp_pj =' => $nrp_musyrif, 'status =' =>'Approve', 'tanggal >='=>$dari, 'tanggal <='=>$sampai);
			$data['anggota'] = $this->m_models->getJoin3where("*", "anggota_mha", "kelompok_mha", "kelompok_mha.id_kel_mha=anggota_mha.kelompok", "hafalan_alquran", "hafalan_alquran.id_ao=anggota_mha.id_ao", "pegawai", "pegawai.nrp=anggota_mha.nrp", $arraywhere, "nama", "asc");
		}
			
		$this->load->view('personal/cetak_lap_setor_hafalan', $data);
	}

	
	//Halaqoh Tarbiyah
	public function htb(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$this->load->view('personal/htb');
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function kelompok_htb(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$data['kelompok'] = $this->m_models->getJoin1Group("*", "kelompok_htb", "pegawai", "pegawai.nrp=kelompok_htb.murabbi", "nama_kel_htb, nama", "nama", "asc");
		$data['pegawai'] = $this->m_models->getwhere("*", "pegawai", "status_aktf", "Aktif", "nama", "asc");
		$data['stiq'] = $this->m_models->getwhere("*", "siswa_pt", "status_aktif", "Aktif", "nama_lengkap", "asc");
		$this->load->view('personal/kelompok_htb',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function simpan_kelompok_htb(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$nama = $this->input->post('nama');
		$pj = $this->input->post('pj');
		
		if (($nama != "")&&($pj != "")){
			$this->db->query("INSERT INTO kelompok_htb VALUES ('', '$nama', '$pj')") or die (mysql_error());
			
			$data[kelompok]= $this->m_models->getAll("kelompok_htb where nama_kel_htb='$nama' and murabbi='$pj'");
			$id_kel=$data[kelompok][0]->id_kel_htb;
			$nrp_peg=$this->input->post('nrp');
			$siswa_stiq=$this->input->post('stiq'); 
			for ($j=0; $j<=50; $j++){
				$nrp =  $nrp_peg[$j]; 
				if (($nrp != "")){
					$simpanpeg=$this->db->query("INSERT INTO anggota_htb VALUES ('', '$nrp', '$id_kel',now(),'0000-00-00')") or die (mysql_error());
				}

				$siswa = $siswa_stiq[$j];
				if (($siswa != "")){
					$simpansiswa=$this->db->query("INSERT INTO anggota_htb VALUES ('', '$siswa', '$id_kel',now(),'0000-00-00')") or die (mysql_error());
				}
			}
		}
		//if (($simpanpeg == TRUE) or ($simpansiswa == TRUE)){
			if ($simpanpeg == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		redirect('personal/kelompok_htb');
		
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}
	
	public function detail_kelompok_htb(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$id_kel = $this->uri->segment(3);
		$arraywhere=array('kelompok =' => $id_kel, "tgl_off"=>"0000-00-00");
		$data['anggota'] = $this->m_models->getJoin2where("*", "anggota_htb", "pegawai", "pegawai.nrp=anggota_htb.nrp", "kelompok_htb", "kelompok_htb.id_kel_htb=anggota_htb.kelompok", $arraywhere, "", "nama", "asc");	
		$id_kel_htb=$data['anggota'][0]->id_kel_htb;
		// function getwhere($select, $tabel, $fieldwhere, $idwhere, $fieldorder, $jenis_orderby) {
		$data['kel_htb'] = $this->m_models->getwhere("*", "kelompok_htb", "id_kel_htb", $id_kel_htb, "id_kel_htb","asc");
		foreach ($data['anggota'] as $anggt){
			$id_jab=$anggt->id_jabatan;
			$id_sklh=$anggt->id_sekolah;
			$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "id_sekolah", $anggt->id_sekolah,"id_sekolah","asc");
			$data['jabatan'] = $this->m_models->getwhere("*", "jabatan", "id_jabatan", $anggt->id_jabatan,"id_jabatan","asc");
			$data['pj'] = $this->m_models->getwhere("*", "pegawai", "nrp", $anggt->murabbi,"nrp","asc");
			$arr = array('sklh' => $data['sekolah'][0]->nama, 'jab' => $data['jabatan'][0]->nama_jabatan,);
		}

		//data anggota htb stiq
		$ar_stiq=array('kelompok =' => $id_kel, "tgl_off"=>"0000-00-00");
		$data['anggota_stiq'] = $this->m_models->getJoin2where("*", "anggota_htb", "siswa_pt", "siswa_pt.id_siswa=anggota_htb.nrp", "kelompok_htb", "kelompok_htb.id_kel_htb=anggota_htb.kelompok", $ar_stiq, "", "nama_lengkap", "asc");
		$this->load->view('personal/detail_kelompok_htb',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function update_anggota_htb(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");
		$id_htb = $this->uri->segment(3);
		$status = $this->uri->segment(4);
		if ($id_htb != ""){
			if ($status=="on"){
				$j_off= array('tgl_off'=>"0000-00-00", 'tgl_on'=>$hariini);
			} else if ($status=="off"){
				$j_off= array('tgl_off'=>$hariini);
			}
			if ($this->m_models->update_data($id_htb, "id_htb", $j_off, "anggota_htb") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('personal/detail_kelompok_htb');
		}
		$this->load->view('template/footer');
	}

	public function edit_kelompok_htb(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$id_kel = $this->uri->segment(3);

		$data['pegawai'] = $this->m_models->getwhere("*", "pegawai", "status_aktf", "Aktif", "nama", "asc");
		$data['stiq'] = $this->m_models->getwhere("*", "siswa_pt", "status_aktif", "Aktif", "nama_lengkap", "asc");

		$arraywhere=array('kelompok =' => $id_kel, "tgl_off"=>"0000-00-00");
		$data['anggota'] = $this->m_models->getJoin2where("*", "anggota_htb", "pegawai", "pegawai.nrp=anggota_htb.nrp", "kelompok_htb", "kelompok_htb.id_kel_htb=anggota_htb.kelompok", $arraywhere, "", "nama", "asc");	
		$id_kel_htb=$data['anggota'][0]->id_kel_htb;
		// function getwhere($select, $tabel, $fieldwhere, $idwhere, $fieldorder, $jenis_orderby) {
		$data['kel_htb'] = $this->m_models->getwhere("*", "kelompok_htb", "id_kel_htb", $id_kel_htb, "id_kel_htb","asc");
		foreach ($data['anggota'] as $anggt){
			$id_jab=$anggt->id_jabatan;
			$id_sklh=$anggt->id_sekolah;
			$data['sekolah'] = $this->m_models->getwhere("*", "sekolah", "id_sekolah", $anggt->id_sekolah,"id_sekolah","asc");
			$data['jabatan'] = $this->m_models->getwhere("*", "jabatan", "id_jabatan", $anggt->id_jabatan,"id_jabatan","asc");
			$data['pj'] = $this->m_models->getwhere("*", "pegawai", "nrp", $anggt->murabbi,"nrp","asc");
			$arr = array('sklh' => $data['sekolah'][0]->nama, 'jab' => $data['jabatan'][0]->nama_jabatan,);
		}

		//data anggota htb stiq
		$ar_stiq=array('kelompok =' => $id_kel, "tgl_off"=>"0000-00-00");
		$data['anggota_stiq'] = $this->m_models->getJoin2where("*", "anggota_htb", "siswa_pt", "siswa_pt.id_siswa=anggota_htb.nrp", "kelompok_htb", "kelompok_htb.id_kel_htb=anggota_htb.kelompok", $ar_stiq, "", "nama_lengkap", "asc");
		$this->load->view('personal/edit_kelompok_htb',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	
	public function updatekelompokhtb(){
		$nrp=$this->session->userdata['nrp']; 
		$hariini=date("Y-m-d");

		$id_kel_htb = $this->input->post('id_kel_htb');
		$nama = $this->input->post('nama');
		$pj = $this->input->post('pj');

		$ar_k=array("nama_kel_htb"=>$nama, "murabbi"=>$pj);
		$up_k=$this->m_models->update_data($id_kel_htb, "id_kel_htb", $ar_k, "kelompok_htb");

		$idhtb = $this->input->post('id_htb');
		for ($i=0; $i < count($idhtb) ; $i++) { 
			$id_htb=$idhtb[$i];
			$nrp_anggota = $this->input->post('nrp_anggota'.$id_htb);
			$ar_a=array("nrp"=>$nrp_anggota);
			$up=$this->m_models->update_data($id_htb, "id_htb", $ar_a, "anggota_htb");
		}

		if ($up == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil diubah');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('personal/kelompok_htb');
	}


	public function input_htb(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$nrp_murrabi=$this->session->userdata['nrp'];
		$id_sekolah=$this->m_models->getSession($nrp_murrabi, "id_sekolah");

		if($id_sekolah==13){ 
			$ar=array('status_aktf =' => "Aktif");
			$data['murabbi'] = $this->m_models->getJoin1whereGroup("kelompok_htb.*, pegawai.nama", "kelompok_htb", "pegawai", "pegawai.nrp=kelompok_htb.murabbi", $ar, "kelompok_htb.murabbi", "nama", "asc");
		} else {
			$ar=array('status_aktf =' => "Aktif", 'nrp'=>$nrp_murrabi);
			$data['murabbi'] = $this->m_models->getJoin1whereGroup("kelompok_htb.*, pegawai.nama", "kelompok_htb", "pegawai", "pegawai.nrp=kelompok_htb.murabbi", $ar, "kelompok_htb.murabbi", "nama", "asc");
		}


		$tema = $this->input->post('tema');
		$ringkasan = $this->input->post('ringkasan');
		$tgl = date_db($this->input->post('tgl'));
		$waktu_awal = date_db($this->input->post('waktu_awal'));
		$waktu_selesai = date_db($this->input->post('waktu_selesai'));
		$tmp = $this->input->post('tmp');
		if (($tema != "") && ($ringkasan != "")){
			$janggota = $this->m_models->getRowsJoin2Where("*", "anggota_htb", "pegawai", "pegawai.nrp=anggota_htb.nrp", "kelompok_htb", "kelompok_htb.id_kel_htb=anggota_htb.kelompok", $arraywhere, "nama", "asc");
			$hariini=date("Y-m-d");
			foreach ($data['anggota'] as $anggt) {
				$kehadiran = $this->input->post('kehadiran'.$anggt->nrp);
				$htb=array('id_kel_htb' => $anggt->kelompok, 'tanggal' => $tgl, 'id_htb' => $anggt->id_htb, 'kehadiran' => $kehadiran, 'tema_htb' => $tema, 'ringkasan_htb' => $ringkasan, 'nrp_input' => $nrp_murrabi, 'tgl_input'=>$hariini, "waktu_mulai"=>$waktu_awal, "waktu_selesai"=>$waktu_selesai, "tempat"=>$tmp);
				$data['puasa'] = $this->m_models->save_data($htb, "laporan_htb");
			}
			redirect('personal/input_htb');
		} else {
			$this->load->view('personal/input_htb',$data);
		}

		if ($data['puasa'] == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}


	
	public function cekmurrabi(){
		$murrabi = $this->input->get('murrabi'); 
		$arraywhere=array('kelompok =' => $murrabi);
		$data['anggota'] = $this->m_models->getJoin2where("*", "anggota_htb", "pegawai", "pegawai.nrp=anggota_htb.nrp", "kelompok_htb", "kelompok_htb.id_kel_htb=anggota_htb.kelompok", $arraywhere,  "", "nama", "asc");	
		$this->load->view('personal/cekmurrabi',$data);
	}

	public function rekap_htb(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$nrp_murrabi=$this->session->userdata['nrp'];
		$id_sekolah=$this->m_models->getSession($nrp_murrabi, "id_sekolah");

		if (($id_sekolah==8) or ($id_sekolah==13)){
			$ar=array('status_aktf' => 'Aktif');
			$data[dt_murabbi]=$this->m_models->getJoin1where("*", "kelompok_htb", "pegawai", "pegawai.nrp=kelompok_htb.murabbi", $ar, "nama_kel_htb", "asc");
		} else {
			$ar=array('murabbi' => $nrp_murrabi);
			$data[dt_murabbi]=$this->m_models->getJoin1where("*", "kelompok_htb", "pegawai", "pegawai.nrp=kelompok_htb.murabbi", $ar, "nama_kel_htb", "asc");
		}
		
		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE);
		$nrp_murabbi = $this->input->post('nrp_murabbi', TRUE);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[nrp_murabbi]=$nrp_murabbi;
		if (($dari != "") && ($sampai != "")){
			$arraywhere=array('murabbi =' => $nrp_murabbi);
			$data['anggota'] = $this->m_models->getJoin2Awhere("*", "anggota_htb", "pegawai", "pegawai.nrp=anggota_htb.nrp", "kelompok_htb", "kelompok_htb.id_kel_htb=anggota_htb.kelompok",  $arraywhere, "nama", "asc");
		}
		$this->load->view('personal/rekap_htb',$data);
		$this->load->view('template/footer');
	}

	public function cetak_rekap_htb(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$nrp_murabbi = $this->uri->segment(5);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[nrp_murabbi]=$nrp_murabbi;
		if (($dari != "") && ($sampai != "")){
			$arraywhere=array('murabbi =' => $nrp_murabbi);
			$data['anggota'] = $this->m_models->getJoin2Awhere("*", "anggota_htb", "pegawai", "pegawai.nrp=anggota_htb.nrp", "kelompok_htb", "kelompok_htb.id_kel_htb=anggota_htb.kelompok",  $arraywhere, "nama", "asc");
		}
		$this->load->view('personal/cetak_rekap_htb',$data);
	}

	public function laporan_htb(){
		$this->load->view('template/header');
		$ar=array('status_aktf' => 'Aktif');
		$data[dt_murabbi]=$this->m_models->getJoin1where("*", "kelompok_htb", "pegawai", "pegawai.nrp=kelompok_htb.murabbi", $ar, "nama_kel_htb", "asc");

		$dari = $this->input->post('dari', TRUE);
		$sampai = $this->input->post('sampai', TRUE);
		$nrp_murabbi = $this->input->post('nrp_murabbi', TRUE);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[murabbi]=$nrp_murabbi;
		if (($dari != "") && ($sampai != "")&& ($nrp_murabbi != "")){
			$arraywhere=array('murabbi =' => $nrp_murabbi);
			$data['anggota'] = $this->m_models->getJoin3where("*", "anggota_htb", "pegawai", "pegawai.nrp=anggota_htb.nrp", "kelompok_htb", "kelompok_htb.id_kel_htb=anggota_htb.kelompok", "laporan_htb","laporan_htb.id_htb=anggota_htb.id_htb", $arraywhere, "tanggal", "asc");
		}
		$this->load->view('personal/laporan_htb',$data);
		$this->load->view('template/footer');
	}

	public function cetak_laporan_htb(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$nrp_murabbi = $this->uri->segment(5);
		$data[dari]=$dari;
		$data[sampai]=$sampai;

		if (($dari != "") && ($sampai != "")&& ($nrp_murabbi != "")){ 
			$arraywhere=array('murabbi =' => $nrp_murabbi);
			$data['anggota'] = $this->m_models->getJoin3where("*", "anggota_htb", "pegawai", "pegawai.nrp=anggota_htb.nrp", "kelompok_htb", "kelompok_htb.id_kel_htb=anggota_htb.kelompok", "laporan_htb","laporan_htb.id_htb=anggota_htb.id_htb", $arraywhere, "tanggal", "asc");
		}
		$this->load->view('personal/cetak_laporan_htb',$data);
	}

	
	public function resume_odoj_bulanan(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$kel = $this->uri->segment(5);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		if (($dari != "") && ($sampai != "") && ($kel != "")){
			$data['kelompok'] = $this->m_models->getAll("anggota_odoj join pegawai on pegawai.nrp=anggota_odoj.nrp join kelompok_odoj on kelompok_odoj.id_kel_odoj=anggota_odoj.kelompok where id_ao in (select id_ao from setoran_odoj where tanggal >= '$dari' and tanggal <= '$sampai') and anggota_odoj.kelompok='$kel' group by id_ao order by nama_kel_odoj, nama");
			foreach ($data['kelompok'] as $kelompok) {
				$data[jumlah][$kelompok->nrp] = $this->m_models->getRows("setoran_odoj join anggota_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where setoran_odoj.id_ao='$kelompok->id_ao' and (tanggal >= '$dari' and tanggal <= '$sampai')");
				$data[nama_sekolah][$kelompok->nrp]=all("sekolah", "id_sekolah", $kelompok->id_sekolah, "nama");
				$data[nama_jabatan][$kelompok->nrp]=all("jabatan", "id_jabatan", $kelompok->id_jabatan, "nama_jabatan");
				$data['setoran'] = $this->m_models->getAll("setoran_odoj join anggota_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where setoran_odoj.id_ao='$kelompok->id_ao' and (tanggal >= '$dari' and tanggal <= '$sampai')");
				foreach ($data['setoran'] as $ar) {
					$point=cekPointOdoj($ar->jam);
					$data[t_point][$kelompok->nrp] += $point;
				}
			}
		}		
		$this->load->view('personal/resume_odoj_bulanan',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	
	public function cetak_resume_odoj_bulanan(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		if (($dari != "") && ($sampai != "")){
			$data['kelompok'] = $this->m_models->getAll("anggota_odoj join pegawai on pegawai.nrp=anggota_odoj.nrp join kelompok_odoj on kelompok_odoj.id_kel_odoj=anggota_odoj.kelompok where id_ao in (select id_ao from setoran_odoj where tanggal >= '$dari' and tanggal <= '$sampai') group by id_ao order by nama_kel_odoj, nama");
			foreach ($data['kelompok'] as $kelompok) {
				$data['setoran'] = $this->m_models->getAll("setoran_odoj join anggota_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where setoran_odoj.id_ao='$kelompok->id_ao' and (tanggal >= '$dari' and tanggal <= '$sampai')");
				$id_ao=$kelompok->id_ao;
				$data['jml_point'] = $this->m_models->getwhere("*", "setoran_odoj", "id_ao", $id_ao, "tanggal", "asc");
			}
		}		
		$this->load->view('personal/cetak_resume_odoj_bulanan',$data);
	}
	
	public function detail_resume_odoj_bulanan(){
		//menampilkan tampilan header konten
		$this->load->view('template/header');
		
		$id_ao = $this->uri->segment(3);
		$dari = $this->uri->segment(4);
		$sampai = $this->uri->segment(5);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[id_ao]=$id_ao;
		$hariini=date("Y-m-d");
		$data['setoran'] = $this->m_models->getAll("setoran_odoj join anggota_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where setoran_odoj.id_ao='$id_ao' and tanggal >= '$dari' and tanggal <= '$sampai'");
		foreach ($data['setoran'] as $anggt){ 
			$data[nrp]=$anggt->nrp;
			$data[point][$anggt->id_so]=cekPointOdoj($anggt->jam);
			$id_jabatan=all("pegawai", "nrp", $anggt->nrp, "id_jabatan");
			$id_sekolah=all("pegawai", "nrp", $anggt->nrp, "id_sekolah");

			$data[nama_jabatan][$anggt->nrp]=all("jabatan", "id_jabatan", $id_jabatan, "nama_jabatan");
			$data[nama_sekolah][$anggt->nrp]=all("sekolah", "id_sekolah", $id_sekolah, "nama");
			$data[nama_pegawai][$anggt->nrp]=all("pegawai", "nrp", $anggt->nrp, "nama");
		}	
		$this->load->view('personal/detail_resume_odoj_bulanan',$data);
		//menampilkan tampilan footer
		$this->load->view('template/footer');
	}

	public function cetak_detailresume_odoj(){
		$id_ao = $this->uri->segment(5);
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[id_ao]=$id_ao;
		$hariini=date("Y-m-d");
		$data['setoran'] = $this->m_models->getAll("setoran_odoj join anggota_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where setoran_odoj.id_ao='$id_ao' and tanggal >= '$dari' and tanggal <= '$sampai'");
		foreach ($data['setoran'] as $anggt){ 
			$data[nrp]=$anggt->nrp;
			$data[point][$anggt->id_so]=cekPointOdoj($anggt->jam);
			$id_jabatan=all("pegawai", "nrp", $anggt->nrp, "id_jabatan");
			$id_sekolah=all("pegawai", "nrp", $anggt->nrp, "id_sekolah");

			$data[nama_jabatan][$anggt->nrp]=all("jabatan", "id_jabatan", $id_jabatan, "nama_jabatan");
			$data[nama_sekolah][$anggt->nrp]=all("sekolah", "id_sekolah", $id_sekolah, "nama");
			$data[nama_pegawai][$anggt->nrp]=all("pegawai", "nrp", $anggt->nrp, "nama");
		}
		$this->load->view('personal/cetak_detailresume_odoj',$data);
	}

	public function kutipan(){ 
		$this->load->view('template/header');

		$nrp=$this->session->userdata['nrp'];
		$isi_kutipan = $this->input->post('isi_kutipan');
		$sumber = $this->input->post('sumber');
		$hariini= $this->input->post('tgl'); 
		if ($isi_kutipan != ""){
			$ar = array('tgl'=>$hariini,'isi_kutipan' => $isi_kutipan, 'sumber' => $sumber, 'nrp'=>$nrp);
			if ($this->m_models->save_data($ar, 'kutipan') == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('personal/kutipan');
		}


		$data[kutipan]=$this->m_models->getTabelOrder("*", "kutipan", "tgl", "asc");
		$this->load->view('personal/kutipan',$data);
		$this->load->view('template/footer');
	}


	public function delete_kutipan(){
		$id_kutipan = $this->uri->segment(3);
		if ($id_kutipan != ""){
			if ($this->m_models->delete_data($id_kutipan, "id_kutipan", "kutipan") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil dihapus');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('personal/kutipan');
		}
	}

	public function resume_odoj_kelompok(){
		$this->load->view('template/header');

		$dari = $this->input->post('dari'); 
		$sampai = $this->input->post('sampai'); 
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		if (($dari != "") && ($sampai != "")){
			$data['kelompok'] = $this->m_models->getAll("anggota_odoj join kelompok_odoj on kelompok_odoj.id_kel_odoj=anggota_odoj.kelompok where id_ao in (select id_ao from setoran_odoj where tanggal >= '$dari' and tanggal <= '$sampai') group by kelompok order by nama_kel_odoj");
			foreach ($data['kelompok'] as $kelompok) {
				$data['jml'][$kelompok->kelompok] = $this->m_models->getRows("setoran_odoj join anggota_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where anggota_odoj.kelompok='$kelompok->kelompok' and (tanggal >= '$dari' and tanggal <= '$sampai') group by anggota_odoj.id_ao");

				$data['setoran'] = $this->m_models->getAll("setoran_odoj join anggota_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where anggota_odoj.kelompok='$kelompok->kelompok' and (tanggal >= '$dari' and tanggal <= '$sampai') ");
				$t_point=0;
				foreach ($data['setoran'] as $ar) {
					$point=cekPointOdoj($ar->jam);
					$t_point += $point;
				}
				$data[point][$kelompok->kelompok]=$t_point;
			}
		}		
		$this->load->view('personal/resume_odoj_kelompok',$data);
		$this->load->view('template/footer');	
	}

	public function detail_resume_odoj_kel(){
		$this->load->view('template/header');
		
		$kelompok = $this->uri->segment(3);
		$dari = $this->uri->segment(4);
		$sampai = $this->uri->segment(5);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		$data[kelompok]=$kelompok;
		$hariini=date("Y-m-d");
		//$data['anggota'] = $this->m_models->getAll("anggota_odoj join pegawai on pegawai.nrp=anggota_odoj.nrp join kelompok_odoj on kelompok_odoj.id_kel_odoj=anggota_odoj.kelompok join setoran_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where setoran_odoj.id_ao='$id_ao' and tanggal like '2017-09%'");
		$data['setoran'] = $this->m_models->getAll("setoran_odoj join anggota_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where anggota_odoj.kelompok='$kelompok' and tanggal >= '$dari' and tanggal <= '$sampai'");
		foreach ($data['setoran'] as $anggt){
			$data['pj'] = $this->m_models->getAll("pegawai where nrp='$anggt->nrp_pj'");
			$pj=$data[pj][0]->nama;			
			$data[arr]=array("$anggt->nama_kel_odoj", "$pj", "$anggt->nrp", "$anggt->nama", "$sklh", "$jab");
		}
		$this->load->view('personal/detail_resume_odoj_kel',$data);
		$this->load->view('template/footer');
	}

	public function cetak_resume_odoj_kel(){
		$dari = $this->uri->segment(3);
		$sampai = $this->uri->segment(4);
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		if (($dari != "") && ($sampai != "")){
			$data['kelompok'] = $this->m_models->getAll("anggota_odoj join kelompok_odoj on kelompok_odoj.id_kel_odoj=anggota_odoj.kelompok where id_ao in (select id_ao from setoran_odoj where tanggal >= '$dari' and tanggal <= '$sampai') group by kelompok order by nama_kel_odoj");
			foreach ($data['kelompok'] as $kelompok) {
				$data['jml'][$kelompok->kelompok] = $this->m_models->getRows("setoran_odoj join anggota_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where anggota_odoj.kelompok='$kelompok->kelompok' and (tanggal >= '$dari' and tanggal <= '$sampai') group by anggota_odoj.id_ao");

				$data['setoran'] = $this->m_models->getAll("setoran_odoj join anggota_odoj on setoran_odoj.id_ao=anggota_odoj.id_ao where anggota_odoj.kelompok='$kelompok->kelompok' and (tanggal >= '$dari' and tanggal <= '$sampai') ");
				$t_point=0;
				foreach ($data['setoran'] as $ar) {
					$point=cekPointOdoj($ar->jam);
					$t_point += $point;
				}
				$data[point][$kelompok->kelompok]=$t_point;
			}
		}		
		$this->load->view('personal/cetak_resume_odoj_kel',$data);
	}

	#status setoran hafalan al quran
	public function status_setoran(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp'];
		$dari = $this->input->post('dari'); 
		$sampai = $this->input->post('sampai'); 
		$data[dari]=$dari;
		$data[sampai]=$sampai;
		if (($dari != "") && ($sampai != "")){
			$arraywhere=array('anggota_mha.nrp =' => $nrp, 'status =' =>'Approve', 'tanggal >='=>$dari, 'tanggal <='=>$sampai);
			$data['anggota'] = $this->m_models->getJoin3where("*", "anggota_mha", "kelompok_mha", "kelompok_mha.id_kel_mha=anggota_mha.kelompok", "hafalan_alquran", "hafalan_alquran.id_ao=anggota_mha.id_ao", "pegawai", "pegawai.nrp=anggota_mha.nrp", $arraywhere, "nama", "asc");
		}
			
		$this->load->view('personal/status_setoran', $data);
		$this->load->view('template/footer');
	}

}