<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Perpus extends CI_Controller {
	function __construct() {
		parent::__construct();

		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}

		$this->load->model('m_models');
		$this->load->model('perpus_models');
		$this->load->library(array('upload','image_lib'));
	}

	function get_terlambat($tanggal_jatuh_tempo, $tanggal_pengembalian){
		$this->load->helper('absen');
		# cari selilih hari
		$selisih_hari = get_selisih_hari($tanggal_jatuh_tempo, $tanggal_pengembalian);

		# cari + atau - nilai selilihnya
		$jatuh_tempo = preg_replace('/[^0-9]/', '', $tanggal_jatuh_tempo);
		$pengembalian = preg_replace('/[^0-9]/', '', $tanggal_pengembalian);

		if ($pengembalian > $jatuh_tempo) {
			$nilai_selisih_hari = '+'.$selisih_hari;
		}elseif($pengembalian == $jatuh_tempo){
			$nilai_selisih_hari = $selisih_hari;
		}else{
			$nilai_selisih_hari = '-'.$selisih_hari;
		}

		return $nilai_selisih_hari;
	}

	function get_penerbit($id, $field_id){
		if ($field_id == 'id_biblio') {
			$arraywhere = array('perpus_biblio.id_biblio' => $id);
			$penerbit = $this->m_models->getJoin1where("perpus_penerbit.nama", "perpus_biblio", "perpus_penerbit", "perpus_penerbit.id_penerbit=perpus_biblio.id_penerbit", $arraywhere, "id_biblio", "ASC" );
			return $penerbit[0]->nama;
		}
	}

	function get_pengarang($id, $field_id){
		if ($field_id == 'id_biblio') {
			$arraywhere = array('perpus_biblio_pengarang.id_biblio' => $id);
			$penulis = $this->m_models->getJoin1where("perpus_penulis.nama", "perpus_biblio_pengarang", "perpus_penulis", "perpus_penulis.id_penulis=perpus_biblio_pengarang.id_penulis", $arraywhere, "id_biblio", "ASC" );
			$i = 0;
			foreach ($penulis as $key) {
				if ($i > 0) {
					$nama_pengarang = ','.$key->nama;
				}else{
					$nama_pengarang = $key->nama;
				}
				$pengarang = $pengarang .' '. $nama_pengarang;
				$i++;
			}
			return $pengarang;
		}
	}

	function jenis_anggota(){
		$this->load->view('template/header');

		# ambil data jenis anggota perpustakaan
		$data[jenis_anggota] = $this->m_models->getAll("perpus_jenis_anggota ORDER BY id_jenis_anggota ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/jenis_anggota', $data); 

		$this->load->view('template/footer');
	}

	function tambah_jenis_anggota(){
		$nama = $this->input->post('nama', TRUE);

 		$data = array (
		    'nama' => $nama
		);

		# proses simpan
		if ($this->m_models->save_data($data,"perpus_jenis_anggota") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/jenis_anggota');
	}

	function edit_jenis_anggota(){
		$id_jenis_anggota = $this->input->post('id_jenis_anggota', TRUE);
		$nama = $this->input->post('nama', TRUE);

 		$data = array (
		    'nama' => $nama
		);

		# proses simpan
		if ($this->m_models->update_data($id_jenis_anggota, 'id_jenis_anggota',$data,"perpus_jenis_anggota") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/jenis_anggota');
	}

	function hapus_jenis_anggota(){
		$id_jenis_anggota = $this->input->post('id_jenis_anggota', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_jenis_anggota, 'id_jenis_anggota', 'perpus_jenis_anggota') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/jenis_anggota');
	}

	function instansi(){
		$this->load->view('template/header');

		# ambil data instansi
		$data[instansi] = $this->m_models->getJoin1("perpus_jenis_anggota.nama as nama_jenis_anggota, perpus_instansi.*", "perpus_instansi", "perpus_jenis_anggota", "perpus_instansi.id_jenis_anggota=perpus_jenis_anggota.id_jenis_anggota", "perpus_instansi.nama", "ASC");

		# ambil data jenis anggota perpustakaan
		$data[jenis_anggota] = $this->m_models->getAll("perpus_jenis_anggota ORDER BY id_jenis_anggota ASC");

		# ambil data sekolah
		$data[sekolah] = $this->m_models->get_data("nama, id_sekolah","sekolah", "WHERE kategori='sekolah' ORDER BY id_sekolah ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/instansi', $data); 

		$this->load->view('template/footer');
	}

	function tambah_instansi(){
		$sekolah = $this->input->post('sekolah', TRUE);
		$exp = explode(".", $sekolah);
		$id_sekolah = $exp[0];
		$nama_sekolah = $exp[1];
		$id_jenis_anggota = $this->input->post('jenis_anggota', TRUE);

 		$data = array (
		    'nama' => $nama_sekolah,
		    'id_jenis_anggota' => $id_jenis_anggota,
		    'id_sekolah' => $id_sekolah
		);

		# proses simpan
		if ($this->m_models->save_data($data,"perpus_instansi") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/instansi');
	}

	function edit_instansi(){
		$sekolah = $this->input->post('sekolah', TRUE);
		$exp = explode("*", $sekolah);
		$id_sekolah = $exp[0];
		$nama_sekolah = $exp[1];
		$id_jenis_anggota = $this->input->post('jenis_anggota', TRUE);
		$id_instansi = $this->input->post('id_instansi', TRUE);

 		$data = array (
		    'nama' => $nama_sekolah,
		    'id_jenis_anggota' => $id_jenis_anggota,
		    'id_sekolah' => $id_sekolah
		);


		# proses simpan
		if ($this->m_models->update_data($id_instansi, 'id_instansi', $data, "perpus_instansi") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/instansi');
	}

	function hapus_instansi(){
		$id_instansi = $this->input->post('id_instansi', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_instansi, 'id_instansi', 'perpus_instansi') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/instansi');
	}

	function anggota(){
		$this->load->view('template/header');

 		# ambil data dari form pencarian
		$instansi = $this->input->post('instansi', TRUE);
        $status = $this->input->post('status', TRUE);

     	# kirim data form buat selected form
     	$data['instansipilih'] = $instansi;
     	$data['statuspilih'] = $status;

       	# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $instansi);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
	//	$id_sekolah = $exp[1].'%';
	//	$kode_pengenal = $exp[2].'%';
	
		if ($instansi != null AND $status != null) {
			# jika yang dipilih instansi SDM maka ngambil data dari tabel pegawai
			if ($exp[0] == 'Yayasan') {
				$arrWhere=array('perpus_anggota.status' => $status);
				# cari data SDM dengan kriteria kondisi arrWhere di atas
				$siswa = $this->m_models->getJoin2where("pegawai.nrp, pegawai.nama, pegawai.nrp, pegawai.tmp_lhr, pegawai.tgl_lhr, pegawai.jk, pegawai.id_jabatan, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", "pegawai", "perpus_anggota.id_user=pegawai.nrp", "perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", $arrWhere,"", "pegawai.nama","asc");

				$jml_siswa = 0;

				foreach ($siswa as $key) {
					# membuat data array yang akan ditampilkan berdasarkan data yang didapat
					$arr_anggota['id_anggota'][] = $key->id_anggota;
					$arr_anggota['id_siswa'][] = $key->nrp;
					$arr_anggota['nis'][] = $key->nrp;
	 				$arr_anggota['nama'][] = $key->nama;
	 				$arr_anggota['jk'][] = $key->jk;
	 				$arr_anggota['tempat_lahir'][] = $key->tmp_lhr;
	 				$arr_anggota['tanggal_lahir'][] = $key->tgl_lhr;
	 				$arr_anggota['instansi'][] = $key->nama_instansi;
	 				$arr_anggota['id_jabatan'][] = $key->id_jabatan;
	 				$arr_anggota['status'][] = $key->status;
	 				$arr_anggota['tanggal_masuk'][] = $key->tanggal_masuk;

	 				# hitung jumlah pegawai
					$jml_siswa = $jml_siswa + 1;
				}
			# jika data instansi selain SDM maka ke sini, ngambil data dari tabel siswa
			}else{ 
				$arrWhere=array('perpus_anggota.status' => $status);
				# cari data siswa dengan kriteria kondisi arrWhere di atas
				$siswa = $this->m_models->getJoin2where($tabel_siswa.".nis,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk,".$tabel_siswa.".tempat_lahir,".$tabel_siswa.".tanggal_lahir, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", $tabel_siswa, "perpus_anggota.id_user=".$tabel_siswa.".id_siswa", "perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", $arrWhere,"", $tabel_siswa.".nama_lengkap","asc");

				$jml_siswa = 0;

				foreach ($siswa as $key) {
					# membuat data array yang akan ditampilkan berdasarkan data yang didapat
					$arr_anggota['id_anggota'][] = $key->id_anggota;
					$arr_anggota['id_siswa'][] = $key->id_user;
					$arr_anggota['nis'][] = $key->nis;
	 				$arr_anggota['nama'][] = $key->nama_lengkap;
	 				$arr_anggota['jk'][] = $key->jk;
	 				$arr_anggota['tempat_lahir'][] = $key->tempat_lahir;
	 				$arr_anggota['tanggal_lahir'][] = $key->tanggal_lahir;
	 				$arr_anggota['instansi'][] = $key->nama_instansi;
	 				$arr_anggota['status'][] = $key->status;
	 				$arr_anggota['tanggal_masuk'][] = $key->tanggal_masuk;

	 				# hitung jumlah siswa
					$jml_siswa = $jml_siswa + 1;
				}				
			}

		}

 		# kirim dara lengkap
 		$data['anggota'] = $arr_anggota;
		# kirim dara jumlah row data
 		$data['jml_data'] = $jml_siswa;

 		# ambil data instansi
		$data['instansi'] = $this->m_models->getJoin2("sekolah.id_sekolah, sekolah.nama as nama_sekolah, sekolah.id_jenjang, sekolah.kode_pengenal, perpus_instansi.*, jenjang_pendidikan.nama_jenjang", "sekolah","perpus_instansi", "perpus_instansi.id_sekolah=sekolah.id_sekolah", "jenjang_pendidikan", "sekolah.id_jenjang=jenjang_pendidikan.id_jenjang", "perpus_instansi.id_sekolah", "ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/anggota', $data); 

		$this->load->view('template/footer');		
	}

	function tambah_anggota(){

		$this->load->view('template/header');

 		# ambil data dari form pencarian
		$instansi = $this->input->post('instansi', TRUE);

     	# kirim data form buat selected form
     	$data['instansipilih'] = $instansi;

       	# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $instansi);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$id_sekolah = $exp[1].'%';
	//	$kode_pengenal = $exp[2].'%';
		#cari id instansi
		$d_instansi = $this->m_models->get_data("id_instansi", "perpus_instansi", "WHERE id_sekolah='$exp[1]'");
		$data['id_instansi'] = $d_instansi[0]->id_instansi;
	
		if ($instansi != null) {
			# jika yang dipilih instansi SDM maka ngambil data dari tabel pegawai
			if ($exp[0] == 'Yayasan') {
				# cari data pegawai yang tidak ada di tabel anggota perpus
				$siswa = $this->m_models->get_data("pegawai.nrp, pegawai.nama, pegawai.jk, pegawai.id_jabatan, jabatan.nama_jabatan", "pegawai", " JOIN jabatan ON pegawai.id_jabatan=jabatan.id_jabatan WHERE nrp NOT IN ( SELECT id_user FROM perpus_anggota)");

				$jml_siswa = 0;

				foreach ($siswa as $key) {
					# membuat data array yang akan ditampilkan berdasarkan data yang didapat
					$arr_anggota['id_siswa'][] = $key->nrp;
					$arr_anggota['nis'][] = $key->nrp;
	 				$arr_anggota['nama'][] = $key->nama;
	 				$arr_anggota['jk'][] = $key->jk;
	 				$arr_anggota['kelas'][] = $key->nama_jabatan;

	 				# hitung jumlah siswa
					$jml_siswa = $jml_siswa + 1;
				}
			# jika data instansi selain SDM maka ke sini, ngambil data dari tabel siswa
			}else{ 
				# cari data pegawai yang tidak ada di tabel anggota perpus
				$siswa = $this->m_models->get_data($tabel_siswa.".id_siswa,".$tabel_siswa.".nis,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk ", $tabel_siswa, "WHERE id_sekolah='".$id_sekolah."' AND id_siswa NOT IN ( SELECT id_user FROM perpus_anggota)");


				# ambil data tahun akademik
				$ta = $this->m_models->get_data("id_tahun, periode", "tahun_akademik", "WHERE status_berjalan='ON'");
				$id_ta = $ta[0]->id_tahun;

				# cari data kelas siswa
				$arrWhere=array($tabel_rombel.'.id_tahun' => $id_ta, $tabel_rombel.'.id_sekolah' => $id_sekolah);
				$kelas_siswa = $this->m_models->getJoin1where($tabel_rombel.".*, kelas.nama_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas", $arrWhere, $tabel_rombel.".id_siswa","asc");
				foreach ($kelas_siswa as $kel) {
					$kelas[$kel->id_siswa] = $kel->nama_kelas;
				}

				$jml_siswa = 0;

				foreach ($siswa as $key) {
					# membuat data array yang akan ditampilkan berdasarkan data yang didapat
					$arr_anggota['id_siswa'][] = $key->id_siswa;
					$arr_anggota['nis'][] = $key->nis;
	 				$arr_anggota['nama'][] = $key->nama_lengkap;
	 				$arr_anggota['jk'][] = $key->jk;
	 				$arr_anggota['kelas'][] = $kelas[$key->id_siswa];

	 				# hitung jumlah siswa
					$jml_siswa = $jml_siswa + 1;
				}				
			}

		}

 		# kirim dara lengkap
 		$data['anggota'] = $arr_anggota;
		# kirim dara jumlah row data
 		$data['jml_data'] = $jml_siswa;

 		# ambil data instansi
		$data['instansi'] = $this->m_models->getJoin2("sekolah.id_sekolah, sekolah.nama as nama_sekolah, sekolah.id_jenjang, sekolah.kode_pengenal, perpus_instansi.*, jenjang_pendidikan.nama_jenjang", "sekolah","perpus_instansi", "perpus_instansi.id_sekolah=sekolah.id_sekolah", "jenjang_pendidikan", "sekolah.id_jenjang=jenjang_pendidikan.id_jenjang", "perpus_instansi.id_sekolah", "ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/tambah_anggota', $data); 

		$this->load->view('template/footer');		
	}

	function simpan_anggota(){
		$simpan = false;
		# ambil data yang di post
		$siswa = $this->input->post('siswa');
		$jml_siswa = count($this->input->post('siswa'));
		$tanggal_masuk = date_db($this->input->post('tanggal_masuk'));
		$instansi = $this->input->post('instansi');	
		$nama = $this->input->post('nama');

		# cari id anggota terakhir
		$id_akhir = $this->m_models->get_data("MAX(id_anggota) AS id", "perpus_anggota", "");
		$id_akhirnya = $id_akhir[0]->id;
		
		$no_urut = (int) substr($id_akhirnya,2,6);
		$kode_tahun = date('y');

		if ($jml_siswa > 0) {
			for ($i = 0; $i < $jml_siswa; $i++){ 
				# buat id baru terurut
				$no_urut++;
				$id_baru = $kode_tahun.sprintf("%06s", $no_urut);

				#id siswa / nim / nrp
				$id_user = $siswa[$i];
				# masukan ke array buat di simpan sekaligus
				$data[$i]['id_anggota'] = $id_baru;
				$data[$i]['id_user'] = $id_user;
				$data[$i]['nama'] = $nama[$id_user];
				$data[$i]['id_instansi'] = $instansi;
				$data[$i]['tanggal_masuk'] = $tanggal_masuk;
				$data[$i]['tanggal_keluar'] = '0000-00-00';
				$data[$i]['status'] = 'Aktif';
			}

			# proses simpan ke tabel perpus_anggota
			$simpan = $this->m_models->save_batch($data,"perpus_anggota");
		}
			
		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/tambah_anggota');
	}

	function proses_anggota(){
 		$this->load->view('template/header');

 		# ambil data dari form pencarian
		$sekolah = $this->input->post('sekolah', TRUE);
        $tahun_akademik = $this->input->post('tahun_akademik', TRUE);
        $status = $this->input->post('status', TRUE);
        $tingkat = $this->input->post('tingkat', TRUE);

     	# kirim data form buat selected form
     	$data['sekolahpilih'] = $sekolah;
     	$data['tapilih'] = $tahun_akademik;
        $data['statuspilih'] = $status;
        $data['tingkatpilih'] = $tingkat;

       	# pecah data untuk mendaptakn table siswa dan id_sekolah
		$exp = explode("-", $sekolah);
		$tabel_rombel = 'rombongan_belajar_'.strtolower($exp[0]);
		$tabel_siswa = 'siswa_'.strtolower($exp[0]);
		$id_sekolah = $exp[1].'%';
		$kode_pengenal = $exp[2].'%';
		
		if ($sekolah != null AND $tahun_akademik != null AND $status != null AND $tingkat != null) {

			# jika yang dipilih instansi SDM maka ngambil data dari tabel pegawai
			if ($exp[0] == 'Yayasan') {
				$arrWhere=array('perpus_anggota.status' => $status);
				# cari data SDM dengan kriteria kondisi arrWhere di atas
				$siswa = $this->m_models->getJoin2where("pegawai.nrp, pegawai.nama, pegawai.nrp, pegawai.tmp_lhr, pegawai.tgl_lhr, pegawai.jk, pegawai.id_jabatan, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", "pegawai", "perpus_anggota.id_user=pegawai.nrp", "perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", $arrWhere,"", "pegawai.nama","asc");

				$jml_anggota = 0;

				foreach ($siswa as $key) {
					# membuat data array yang akan ditampilkan berdasarkan data yang didapat
					$arr_anggota['id_anggota'][] = $key->id_anggota;
					$arr_anggota['id_siswa'][] = $key->nrp;
					$arr_anggota['nis'][] = $key->nrp;
	 				$arr_anggota['nama'][] = $key->nama;
	 				$arr_anggota['jk'][] = $key->jk;
	 				$arr_anggota['kelas'][] = '';
	 				$arr_anggota['status'][] = $key->status;

	 				# hitung jumlah pegawai
					$jml_anggota = $jml_anggota + 1;
				}
			# jika data instansi selain SDM maka ke sini, ngambil data dari tabel siswa
			}else{
				# cari id kelas buat filter data anggota karena susah ga bisa join langsung
				$kelas = $this->m_models->get_data("id_kelas", "kelas", "WHERE id_tingkatan_kelas='$tingkat' AND id_tahun='$tahun_akademik' AND id_sekolah='$id_sekolah'");
				foreach ($kelas as $key ) {
					$kelas[]= $key->id_kelas;
				}

				$arrWhere=array($tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
				# cari data siswa dengan kriteria kondisi arrWhere di atas
				$siswa = $this->m_models->getJoin3where($tabel_rombel.".*,".$tabel_siswa.".nis,".$tabel_siswa.".nama_lengkap,".$tabel_siswa.".jk, kelas.nama_kelas, kelas.id_kelas, perpus_anggota.*", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas",  $tabel_siswa, $tabel_rombel.".id_siswa=".$tabel_siswa.".id_siswa", "perpus_anggota", $tabel_rombel.".id_siswa=perpus_anggota.id_user", $arrWhere,"", "id_siswa","asc");

				$jml_anggota = 0;

				foreach ($siswa as $key) {
					if (in_array($key->id_kelas, $kelas)) {
						# membuat data array yang akan ditampilkan berdasarkan data yang didapat
						$arr_anggota['id_anggota'][] = $key->id_anggota;
						$arr_anggota['id_siswa'][] = $key->id_siswa;
						$arr_anggota['nis'][] = $key->nis;
		 				$arr_anggota['nama'][] = $key->nama_lengkap;
		 				$arr_anggota['kelas'][] = $key->nama_kelas;
		 				$arr_anggota['jk'][] = $key->jk;
		 				$arr_anggota['status'][] = $key->status;

		 				# hitung jumlah siswa
						$jml_anggota = $jml_anggota + 1;
					}
				}				
			}
		}

 		# kirim dara lengkap
 		$data['anggota'] = $arr_anggota;
		# kirim dara jumlah row data
 		$data['jml_data'] = $jml_anggota;

 		# ambil data sekolah yang ada simtitisnya
		$data['sekolah'] = $this->m_models->getJoin2("sekolah.id_sekolah, sekolah.nama as nama_sekolah, sekolah.id_jenjang, sekolah.kode_pengenal, perpus_instansi.*, jenjang_pendidikan.nama_jenjang", "sekolah","perpus_instansi", "perpus_instansi.id_sekolah=sekolah.id_sekolah", "jenjang_pendidikan", "sekolah.id_jenjang=jenjang_pendidikan.id_jenjang", "perpus_instansi.id_sekolah", "ASC");

		# ambil data tingkat
		$jml_tingkat = 0;
		foreach ($data['sekolah'] as $key) {
			$tingkat_kelas = $this->m_models->get_data("id_tingkatan_kelas, tingkat", "tingkatan_kelas", "WHERE id_jenjang='$key->id_jenjang'");

			foreach ($tingkat_kelas as $val) {
				$arr_tingkat['id_tingkatan_kelas'][] = $val->id_tingkatan_kelas;
				$arr_tingkat['tingkat'][] = $val->tingkat;
				$jml_tingkat++;
			}
		}
	
		$data['tingkatan_kelas'] = $arr_tingkat;
		$data['jml_tingkat'] = $jml_tingkat;
	
		# ambil data tahun akademik
		$data['ta'] = $this->m_models->get_data("id_tahun, periode, status_berjalan", "tahun_akademik", "ORDER BY periode DESC");

		$this->load->view('perpustakaan/proses_anggota', $data); 

		$this->load->view('template/footer');		
	}

	function simpan_proses_anggota(){
		$simpan = false;
		# ambil data yang di post
		$anggota = $this->input->post('anggota');
		$jml_anggota = count($this->input->post('anggota'));
		$proses = $this->input->post('submit');

		if ($proses == 'aktifkan') {
			$status = 'Aktif';
		}else{
			$status = 'Tidak Aktif';
		}

		if ($jml_anggota > 0) {
			for ($i = 0; $i < $jml_anggota; $i++){ 
				# masukan ke array buat di simpan sekaligus
				$data[$i]['id_anggota'] = $anggota[$i];
				$data[$i]['status'] = $status;
			}

			# proses simpan ke tabel perpus_anggota
			$simpan = $this->m_models->update_batch($data, "perpus_anggota", "id_anggota");
		}

		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}	

		redirect('perpus/proses_anggota');		
	}

	function kategori_buku(){
		$this->load->view('template/header');

		# ambil data jenis kategori_buku
		$data[kategori_buku] = $this->m_models->getAll("perpus_kategori_buku ORDER BY id_kategori_buku ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/kategori_buku', $data); 

		$this->load->view('template/footer');
	}

	function tambah_kategori_buku(){
		$nama = $this->input->post('nama', TRUE);
		$label = $this->input->post('label', TRUE);

 		$data = array (
		    'nama' => $nama,
		    'label' => $label
		);

		# proses simpan
		if ($this->m_models->save_data($data,"perpus_kategori_buku") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/kategori_buku');
	}

	function edit_kategori_buku(){
		$id_kategori_buku = $this->input->post('id_kategori_buku', TRUE);
		$nama = $this->input->post('nama', TRUE);
		$label = $this->input->post('label', TRUE);

 		$data = array (
		    'nama' => $nama,
		    'label' => $label
		);

		# proses simpan
		if ($this->m_models->update_data($id_kategori_buku, 'id_kategori_buku', $data, "perpus_kategori_buku") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/kategori_buku');
	}

	function hapus_kategori_buku(){
		$id_kategori_buku = $this->input->post('id_kategori_buku', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_kategori_buku, 'id_kategori_buku', 'perpus_kategori_buku') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/kategori_buku');
	}

	function aturan_peminjaman(){
		$this->load->view('template/header');

		# ambil data aturan peminjaman buku
		$data[aturan_peminjaman] = $this->m_models->getJoin2("perpus_jenis_anggota.nama as nama_jenis_anggota, perpus_kategori_buku.nama as nama_kategori_buku, perpus_kategori_buku.label, perpus_aturan_peminjaman.*", "perpus_aturan_peminjaman", "perpus_jenis_anggota", "perpus_aturan_peminjaman.id_jenis_anggota=perpus_jenis_anggota.id_jenis_anggota", "perpus_kategori_buku", "perpus_aturan_peminjaman.id_kategori_buku=perpus_kategori_buku.id_kategori_buku", "perpus_aturan_peminjaman.id_kategori_buku","asc");

		# ambil data kategori buku
		$data[kategori_buku] = $this->m_models->getAll("perpus_kategori_buku ORDER BY id_kategori_buku ASC");

		# ambil data jenis anggota
		$data[jenis_anggota] = $this->m_models->getAll("perpus_jenis_anggota ORDER BY id_jenis_anggota ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/aturan_peminjaman', $data); 

		$this->load->view('template/footer');
	}

	function tambah_aturan_peminjaman(){
		$kategori_buku = $this->input->post('kategori_buku', TRUE);
		$jenis_anggota = $this->input->post('jenis_anggota', TRUE);
		$lama_maksimal = str_replace('.', '', $this->input->post('lama_maksimal', TRUE));
		$satuan_lama = $this->input->post('satuan_lama', TRUE);
		$denda_keterlambatan = str_replace('.', '', $this->input->post('denda_keterlambatan', TRUE));
		$satuan_denda = $this->input->post('satuan_denda', TRUE);
		$jumlah_maksimal = str_replace('.', '', $this->input->post('jumlah_maksimal', TRUE));

		for ($i=0; $i <count($jenis_anggota) ; $i++) { 
			$data[$i]['id_aturan_peminjaman'] = '';
			$data[$i]['id_kategori_buku'] = $kategori_buku;
			$data[$i]['id_jenis_anggota'] = $jenis_anggota[$i];
			$data[$i]['lama_maksimal'] = $lama_maksimal;
			$data[$i]['satuan_lama'] = $satuan_lama;
			$data[$i]['denda_keterlambatan'] = $denda_keterlambatan;
			$data[$i]['satuan_denda'] = $satuan_denda;
			$data[$i]['jumlah_maksimal'] = $jumlah_maksimal;
		}

		# proses simpan
		if ($this->m_models->save_batch($data, "perpus_aturan_peminjaman") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/aturan_peminjaman'); 
	}

	function edit_aturan_peminjaman(){
		$id_aturan_peminjaman = $this->input->post('id_aturan_peminjaman', TRUE);
		$kategori_buku = $this->input->post('kategori_buku', TRUE);
		$jenis_anggota = $this->input->post('jenis_anggota', TRUE);
		$lama_maksimal = str_replace('.', '', $this->input->post('lama_maksimal', TRUE));
		$satuan_lama = $this->input->post('satuan_lama', TRUE);
		$denda_keterlambatan = str_replace('.', '', $this->input->post('denda_keterlambatan', TRUE));
		$satuan_denda = $this->input->post('satuan_denda', TRUE);
		$jumlah_maksimal = str_replace('.', '', $this->input->post('jumlah_maksimal', TRUE));

 		$data = array (
		    'id_kategori_buku' => $kategori_buku,
		    'id_jenis_anggota' => $jenis_anggota,
		    'lama_maksimal' => $lama_maksimal,
		    'satuan_lama' => $satuan_lama,
		    'denda_keterlambatan' => $denda_keterlambatan,
		    'satuan_denda' => $satuan_denda,
		    'jumlah_maksimal' => $jumlah_maksimal
		);

		# proses simpan
		if ($this->m_models->update_data($id_aturan_peminjaman, 'id_aturan_peminjaman', $data, "perpus_aturan_peminjaman") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/aturan_peminjaman');
	}

	function hapus_aturan_peminjaman(){
		$id_aturan_peminjaman = $this->input->post('id_aturan_peminjaman', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_aturan_peminjaman, 'id_aturan_peminjaman', 'perpus_aturan_peminjaman') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/aturan_peminjaman');
	}

	function aturan_kehilangan(){
		$this->load->view('template/header');

		# ambil data aturan peminjaman buku
		$data[aturan_kehilangan] = $this->m_models->getAll("perpus_aturan_kehilangan ORDER BY nama_aturan ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/aturan_kehilangan', $data); 

		$this->load->view('template/footer');
	}

	function tambah_aturan_kehilangan(){
		$nama_aturan = $this->input->post('nama_aturan', TRUE);

		$data = array('nama_aturan' => $nama_aturan);

		# proses simpan
		if ($this->m_models->save_data($data, "perpus_aturan_kehilangan") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/aturan_kehilangan'); 
	}

	function edit_aturan_kehilangan(){
		$nama_aturan = $this->input->post('nama_aturan', TRUE);
		$id_aturan_kehilangan = $this->input->post('id_aturan_kehilangan', TRUE);

 		$data = array (
		    'nama_aturan' => $nama_aturan
		);

		# proses simpan
		if ($this->m_models->update_data($id_aturan_kehilangan, 'id_aturan_kehilangan', $data, "perpus_aturan_kehilangan") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/aturan_kehilangan');
	}

	function hapus_aturan_kehilangan(){
		$id_aturan_kehilangan = $this->input->post('id_aturan_kehilangan', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_aturan_kehilangan, 'id_aturan_kehilangan', 'perpus_aturan_kehilangan') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/aturan_kehilangan');
	}

	function lokasi(){
		$this->load->view('template/header');

		# ambil data lokasi perpustakaan
		$data[lokasi] = $this->m_models->getAll("perpus_lokasi ORDER BY nama_lokasi ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/lokasi', $data); 

		$this->load->view('template/footer');
	}

	function tambah_lokasi(){
		$id_lokasi = $this->input->post('id_lokasi', TRUE);
		$nama_lokasi = $this->input->post('nama_lokasi', TRUE);

		$jmldata = $this->m_models->getRowsWhere("id_lokasi", "perpus_lokasi", "id_lokasi", $id_lokasi, "id_lokasi", "ASC");

		if ($jmldata == 0 ) {
			$data = array('id_lokasi' => $id_lokasi, 'nama_lokasi' => $nama_lokasi);

			# proses simpan
			if ($this->m_models->save_data($data, "perpus_lokasi") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Kode Lokasi sudah ada.');
		}

		redirect('perpus/lokasi'); 
	}

	function edit_lokasi(){
		$id_lokasi = $this->input->post('id_lokasi', TRUE);
		$nama_lokasi = $this->input->post('nama_lokasi', TRUE);

 		$data = array (
		    'nama_lokasi' => $nama_lokasi
		);

		# proses simpan
		if ($this->m_models->update_data($id_lokasi, 'id_lokasi', $data, "perpus_lokasi") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/lokasi');
	}

	function hapus_lokasi(){
		$id_lokasi = $this->input->post('id_lokasi', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_lokasi, 'id_lokasi', 'perpus_lokasi') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/lokasi');
	}

	function bahasa(){
		$this->load->view('template/header');

		# ambil data bahasa
		$data[bahasa] = $this->m_models->getAll("perpus_bahasa ORDER BY nama_bahasa ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/bahasa', $data); 

		$this->load->view('template/footer');
	}

	function tambah_bahasa(){
		$id_bahasa = $this->input->post('id_bahasa', TRUE);
		$nama_bahasa = $this->input->post('nama_bahasa', TRUE);

		$jmldata = $this->m_models->getRowsWhere("id_bahasa", "perpus_bahasa", "id_bahasa", $id_bahasa, "id_bahasa", "ASC");

		if ($jmldata == 0 ) {
			$data = array('id_bahasa' => $id_bahasa, 'nama_bahasa' => $nama_bahasa);

			# proses simpan
			if ($this->m_models->save_data($data, "perpus_bahasa") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Kode Bahasa sudah ada.');
		}

		redirect('perpus/bahasa'); 
	}

	function edit_bahasa(){
		$id_bahasa = $this->input->post('id_bahasa', TRUE);
		$nama_bahasa = $this->input->post('nama_bahasa', TRUE);

 		$data = array (
		    'nama_bahasa' => $nama_bahasa
		);

		# proses simpan
		if ($this->m_models->update_data($id_bahasa, 'id_bahasa', $data, "perpus_bahasa") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/bahasa');
	}

	function hapus_bahasa(){
		$id_bahasa = $this->input->post('id_bahasa', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_bahasa, 'id_bahasa', 'perpus_bahasa') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/bahasa');
	}

	function penulis(){
		$this->load->view('template/header');

		# kirim link ajax list penulis 
		$data['url_ajax'] = 'perpus/ajax_list_penulis';
 
		# tampilkan data ke view
		$this->load->view('perpustakaan/penulis', $data); 

		$this->load->view('template/footer');
	}

    public function ajax_list_penulis()
    {
    	 $table = 'perpus_penulis';
		 $column_order = array(null, 'nama'); //set column field database for datatable orderable
		 $order = array('nama' => 'asc'); // default order 
		 $column_search_external = $this->uri->segment(3);
		 if ($column_search_external != null) {
		 	$column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
		 }else{
		 	$column_search = array('nama'); //set column field database for datatable searchable 
		 }
		 
		 $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $penulis) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $penulis->nama;
            $row[] = '<div class="btn-group">
            			<a href="#" class="edit-record" data-id="'.$penulis->id_penulis.'"><button type="button" class="btn btn-default btn-sm" ><i class="fa fa-edit"></i></button></a>
            			<a href="#" class="hapus-record" data-id="'.$penulis->id_penulis.'"><button type="button" class="btn btn-default btn-sm" ><i class="fa fa-trash-o"></i></button></a>
                      </div>';

            $data[] = $row;
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function tambah_penulis(){
		$nama = $this->input->post('nama', TRUE);
		$tahun = $this->input->post('tahun', TRUE);
		$tipe = $this->input->post('tipe', TRUE);

		$data = array(
			'nama' => $nama, 
			'tahun' => $tahun,
			'tipe' => $tipe
		);

		# proses simpan
		if ($this->m_models->save_data($data, "perpus_penulis") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/penulis'); 
	}

	function f_edit_penulis(){ 
		$this->load->view('template/head');
		$id_penulis = $this->input->post('id', TRUE);

		$data['penulis'] = $this->m_models->get_data("*", "perpus_penulis", "WHERE id_penulis='$id_penulis' ");

		$this->load->view('perpustakaan/f_edit_penulis', $data); 
		$this->load->view('template/js');
	}

	function edit_penulis(){
		$id_penulis = $this->input->post('id_penulis', TRUE);
		$nama = $this->input->post('nama', TRUE);
		$tahun = $this->input->post('tahun', TRUE);
		$tipe = $this->input->post('tipe', TRUE);

 		$data = array (
			'nama' => $nama, 
			'tahun' => $tahun,
			'tipe' => $tipe
		);

		# proses simpan
		if ($this->m_models->update_data($id_penulis, 'id_penulis', $data, "perpus_penulis") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/penulis');
	}

	function f_hapus_penulis(){ 
		$this->load->view('template/head');
		$id_penulis = $this->input->post('id', TRUE);

		$data['penulis'] = $this->m_models->get_data("*", "perpus_penulis", "WHERE id_penulis='$id_penulis' ");

		$this->load->view('perpustakaan/f_hapus_penulis', $data); 
		$this->load->view('template/js');
	}

	function hapus_penulis(){
		$id_penulis = $this->input->post('id_penulis', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_penulis, 'id_penulis', 'perpus_penulis') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/penulis');
	}

	function penerbit(){
		$this->load->view('template/header');

		# kirim link ajax list penerbit 
		$data['url_ajax'] = 'perpus/ajax_list_penerbit';

		# tampilkan data ke view
		$this->load->view('perpustakaan/penerbit', $data); 

		$this->load->view('template/footer');
	}

    public function ajax_list_penerbit()
    {
    	 $table = 'perpus_penerbit';
		 $column_order = array(null, 'nama'); //set column field database for datatable orderable
		 $order = array('nama' => 'asc'); // default order 
		 $column_search_external = $this->uri->segment(3);
		 if ($column_search_external != null) {
		 	$column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
		 }else{
		 	$column_search = array('nama'); //set column field database for datatable searchable 
		 }
		 
		 $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $penerbit) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $penerbit->nama;
            $row[] = '<div class="btn-group">
            			<a href="#" class="edit-record" data-id="'.$penerbit->id_penerbit.'"><button type="button" class="btn btn-default btn-sm" ><i class="fa fa-edit"></i></button></a>
            			<a href="#" class="hapus-record" data-id="'.$penerbit->id_penerbit.'"><button type="button" class="btn btn-default btn-sm" ><i class="fa fa-trash-o"></i></button></a>
                      </div>';

            $data[] = $row;
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function tambah_penerbit(){
		$nama = $this->input->post('nama', TRUE);

		$data = array(
			'nama' => $nama
		);

		# proses simpan
		if ($this->m_models->save_data($data, "perpus_penerbit") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/penerbit'); 
	}

	function f_edit_penerbit(){ 
		$this->load->view('template/head');
		$id_penerbit = $this->input->post('id', TRUE);

		$data['penerbit'] = $this->m_models->get_data("*", "perpus_penerbit", "WHERE id_penerbit='$id_penerbit' ");

		$this->load->view('perpustakaan/f_edit_penerbit', $data); 
		$this->load->view('template/js');
	}

	function edit_penerbit(){
		$id_penerbit = $this->input->post('id_penerbit', TRUE);
		$nama = $this->input->post('nama', TRUE);

 		$data = array (
			'nama' => $nama
		);

		# proses simpan
		if ($this->m_models->update_data($id_penerbit, 'id_penerbit', $data, "perpus_penerbit") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/penerbit');
	}
	
	function f_hapus_penerbit(){ 
		$this->load->view('template/head');
		$id_penerbit = $this->input->post('id', TRUE);

		$data['penerbit'] = $this->m_models->get_data("*", "perpus_penerbit", "WHERE id_penerbit='$id_penerbit' ");

		$this->load->view('perpustakaan/f_hapus_penerbit', $data); 
		$this->load->view('template/js');
	}

	function hapus_penerbit(){
		$id_penerbit = $this->input->post('id_penerbit', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_penerbit, 'id_penerbit', 'perpus_penerbit') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/penerbit');
	}

	function tempat(){
		$this->load->view('template/header');

		# ambil data lokasi perpustakaan
		$data[tempat] = $this->m_models->getAll("perpus_tempat ORDER BY nama_tempat ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/tempat', $data); 

		$this->load->view('template/footer');
	}

	function tambah_tempat(){
		$nama_tempat = $this->input->post('nama_tempat', TRUE);

		$jmldata = $this->m_models->getRowsWhere("id_tempat", "perpus_tempat", "nama_tempat", $nama_tempat, "id_tempat", "ASC");

		if ($jmldata == 0 ) {
			$data = array('id_tempat' => '', 'nama_tempat' => $nama_tempat);

			# proses simpan
			if ($this->m_models->save_data($data, "perpus_tempat") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Kode Lokasi sudah ada.');
		}

		redirect('perpus/tempat'); 
	}

	function edit_tempat(){
		$id_tempat = $this->input->post('id_tempat', TRUE);
		$nama_tempat = $this->input->post('nama_tempat', TRUE);

 		$data = array (
		    'nama_tempat' => $nama_tempat
		);

		# proses simpan
		if ($this->m_models->update_data($id_tempat, 'id_tempat', $data, "perpus_tempat") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/tempat');
	}

	function hapus_tempat(){
		$id_tempat = $this->input->post('id_tempat', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_tempat, 'id_tempat', 'perpus_tempat') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/tempat');
	}

	function sumber(){
		$this->load->view('template/header');

		# ambil data lokasi perpustakaan
		$data[tempat] = $this->m_models->getAll("perpus_sumber ORDER BY nama_sumber ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/sumber', $data); 

		$this->load->view('template/footer');
	}

	function tambah_sumber(){
		$nama_sumber = $this->input->post('nama_sumber', TRUE);

		$jmldata = $this->m_models->getRowsWhere("id_sumber", "perpus_sumber", "nama_sumber", $nama_sumber, "id_sumber", "ASC");

		if ($jmldata == 0 ) {
			$data = array('id_sumber' => '', 'nama_sumber' => $nama_sumber);

			# proses simpan
			if ($this->m_models->save_data($data, "perpus_sumber") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Kode Lokasi sudah ada.');
		}

		redirect('perpus/sumber'); 
	}

	function edit_sumber(){
		$id_sumber = $this->input->post('id_sumber', TRUE);
		$nama_sumber = $this->input->post('nama_sumber', TRUE);

 		$data = array (
		    'nama_sumber' => $nama_sumber
		);

		# proses simpan
		if ($this->m_models->update_data($id_sumber, 'id_sumber', $data, "perpus_sumber") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/sumber');
	}

	function hapus_sumber(){
		$id_sumber = $this->input->post('id_sumber', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_sumber, 'id_sumber', 'perpus_sumber') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/sumber');
	}

	function jenis_pustaka(){
		$this->load->view('template/header');

		# ambil data lokasi perpustakaan
		$data[jenis] = $this->m_models->getAll("perpus_jenis_pustaka ORDER BY jenis_pustaka ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/jenis_pustaka', $data); 

		$this->load->view('template/footer');
	}

	function tambah_jenis_pustaka(){
		$jenis_pustaka = $this->input->post('jenis_pustaka', TRUE);
		$kode_jenis_pustaka = $this->input->post('kode_jenis_pustaka', TRUE);

		$jmldata = $this->m_models->getRowsWhere("id_jenis_pustaka", "perpus_jenis_pustaka", "jenis_pustaka", $nama_jenis_pustaka, "id_jenis_pustaka", "ASC");

		if ($jmldata == 0 ) {
			$data = array('id_jenis_pustaka' => '', 'jenis_pustaka' => $jenis_pustaka, 'kode_jenis_pustaka' => $kode_jenis_pustaka);

			# proses simpan
			if ($this->m_models->save_data($data, "perpus_jenis_pustaka") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Kode Lokasi sudah ada.');
		}

		redirect('perpus/jenis_pustaka'); 
	}

	function edit_jenis_pustaka(){
		$id_jenis_pustaka = $this->input->post('id_jenis_pustaka', TRUE);
		$jenis_pustaka = $this->input->post('jenis_pustaka', TRUE);
		$kode_jenis_pustaka = $this->input->post('kode_jenis_pustaka', TRUE);

 		$data = array (
		    'jenis_pustaka' => $jenis_pustaka,
		    'kode_jenis_pustaka' => $kode_jenis_pustaka
		);

		# proses simpan
		if ($this->m_models->update_data($id_jenis_pustaka, 'id_jenis_pustaka', $data, "perpus_jenis_pustaka") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/jenis_pustaka');
	}

	function hapus_jenis_pustaka(){
		$id_jenis_pustaka = $this->input->post('id_jenis_pustaka', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_jenis_pustaka, 'id_jenis_pustaka', 'perpus_jenis_pustaka') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/jenis_pustaka');
	}

	function status_item(){
		$this->load->view('template/header');

		# ambil data lokasi perpustakaan
		$data[status] = $this->m_models->getAll("perpus_status_item ORDER BY nama_status_item ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/status_item', $data); 

		$this->load->view('template/footer');
	}

	function tambah_status_item(){
		$id_status_item = $this->input->post('id_status_item', TRUE);
		$nama_status_item = $this->input->post('nama_status_item', TRUE);
		$dipinjamkan = $this->input->post('dipinjamkan', TRUE);
		$dihitung_stok = $this->input->post('dihitung_stok', TRUE);

		$jmldata = $this->m_models->getRowsWhere("id_status_item", "perpus_status_item", "nama_status_item", $nama_status_item, "id_status_item", "ASC");

		if ($jmldata == 0 ) {
			$data = array('id_status_item' => $id_status_item,
						  'nama_status_item' => $nama_status_item,
						  'dipinjamkan' => $dipinjamkan,
						  'dihitung_stok' => $dihitung_stok
						);

			# proses simpan
			if ($this->m_models->save_data($data, "perpus_status_item") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Kode Lokasi sudah ada.');
		}

		redirect('perpus/status_item'); 
	}

	function edit_status_item(){
		$id_status_item = $this->input->post('id_status_item', TRUE);
		$nama_status_item = $this->input->post('nama_status_item', TRUE);
		$dipinjamkan = $this->input->post('dipinjamkan', TRUE);
		$dihitung_stok = $this->input->post('dihitung_stok', TRUE);

 		$data = array (
			'nama_status_item' => $nama_status_item,
			'dipinjamkan' => $dipinjamkan,
			'dihitung_stok' => $dihitung_stok
		);

		# proses simpan
		if ($this->m_models->update_data($id_status_item, 'id_status_item', $data, "perpus_status_item") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/status_item');
	}

	function hapus_status_item(){
		$id_jenis_pustaka = $this->input->post('id_jenis_pustaka', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_jenis_pustaka, 'id_jenis_pustaka', 'perpus_jenis_pustaka') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/status_item');
	}


	function jenis_kepengarangan(){
		$this->load->view('template/header');

		# ambil data bahasa
		$data[jenis_kepengarangan] = $this->m_models->getAll("perpus_jenis_kepengarangan ORDER BY nama_jenis_kepengarangan ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/jenis_kepengarangan', $data); 

		$this->load->view('template/footer');
	}

	function tambah_jenis_kepengarangan(){
		$nama = $this->input->post('nama', TRUE);

		$data = array(
			'nama_jenis_kepengarangan' => $nama
		);

		# proses simpan
		if ($this->m_models->save_data($data, "perpus_jenis_kepengarangan") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/jenis_kepengarangan'); 
	}

	function edit_jenis_kepengarangan(){
		$id_jenis_kepengarangan = $this->input->post('id_jenis_kepengarangan', TRUE);
		$nama = $this->input->post('nama', TRUE);

 		$data = array (
			'nama_jenis_kepengarangan' => $nama
		);

		# proses simpan
		if ($this->m_models->update_data($id_jenis_kepengarangan, 'id_jenis_kepengarangan', $data, "perpus_jenis_kepengarangan") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/jenis_kepengarangan');
	}

	function hapus_jenis_kepengarangan(){
		$id_jenis_kepengarangan = $this->input->post('id_jenis_kepengarangan', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_jenis_kepengarangan, 'id_jenis_kepengarangan', 'perpus_jenis_kepengarangan') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/jenis_kepengarangan');
	}

	function tema(){
		$this->load->view('template/header');

		# ambil data bahasa
		$data[tema] = $this->m_models->getAll("perpus_tema ORDER BY tema ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/tema', $data); 

		$this->load->view('template/footer');
	}

	function tambah_tema(){
		$tema = $this->input->post('tema', TRUE);

		$data = array(
			'tema' => $tema
		);

		# proses simpan
		if ($this->m_models->save_data($data, "perpus_tema") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/tema'); 
	}

	function edit_tema(){
		$id_tema = $this->input->post('id_tema', TRUE);
		$tema = $this->input->post('tema', TRUE);

 		$data = array (
			'tema' => $tema
		);

		# proses simpan
		if ($this->m_models->update_data($id_tema, 'id_tema', $data, "perpus_tema") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/tema');
	}

	function hapus_tema(){
		$id_tema = $this->input->post('id_tema', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_tema, 'id_tema', 'perpus_tema') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/tema');
	}


	function supplier(){
		$this->load->view('template/header');

		# ambil data bahasa
		$data[supplier] = $this->m_models->getAll("perpus_supplier ORDER BY nama_supplier ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/supplier', $data); 

		$this->load->view('template/footer');
	}

	function tambah_supplier(){
		$nama_supplier = $this->input->post('nama_supplier', TRUE);
		$alamat = $this->input->post('alamat', TRUE);
		$telepon = $this->input->post('telepon', TRUE);

		$data = array(
			'nama_supplier' => $nama_supplier,
			'alamat' => $alamat,
			'telepon' => $telepon
		);

		# proses simpan
		if ($this->m_models->save_data($data, "perpus_supplier") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/supplier'); 
	}

	function edit_supplier(){
		$id_supplier = $this->input->post('id_supplier', TRUE);
		$nama_supplier = $this->input->post('nama_supplier', TRUE);
		$alamat = $this->input->post('alamat', TRUE);
		$telepon = $this->input->post('telepon', TRUE);

		$data = array(
			'nama_supplier' => $nama_supplier,
			'alamat' => $alamat,
			'telepon' => $telepon
		);

		# proses simpan
		if ($this->m_models->update_data($id_supplier, 'id_supplier', $data, "perpus_supplier") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/supplier');
	}

	function hapus_supplier(){
		$id_supplier = $this->input->post('id_supplier', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_supplier, 'id_supplier', 'perpus_supplier') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/supplier');
	}

	# --------------------------- BAHAN PUSTAKA ------------------------------ #
	
	function bibliografi(){
		$this->load->view('template/header');
		$kolom_cari = $this->input->post('kolom_cari', TRUE); 
		$text_cari = $this->input->post('text_cari', TRUE);
		$cari = $this->input->post('cari', TRUE);

		$data['kolom_cari'] = $kolom_cari;
        $data['text_cari'] = $text_cari;

		$text_cari = str_replace(" ","#", $text_cari);

        # kirim link ajax list penulis 
        $data['url_ajax'] = 'perpus/ajax_list_biblio/'.$kolom_cari.'/'.$text_cari;
		
		
		

		# tampilkan data ke view
		$this->load->view('perpustakaan/bibliografi', $data); 

		$this->load->view('template/footer');		
	}



    public function ajax_list_biblio()
    {
         $table = 'perpus_biblio';
         $column_order = array(null, 'judul', 'edisi', 'tahun_terbit', 'deskripsi_fisik', 'no_panggil' ); //set column field database for datatable orderable
         $order = array('id_biblio' => 'DESC'); // default order 
         $column_search_external = $this->uri->segment(3);
         if ($column_search_external != null) {
            $column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
         }else{
            $column_search = array('judul', 'judul_paralel', 'judul_terjemah', 'edisi', 'tahun_terbit'); //set column field database for datatable searchable 
         }
         
        // $search_external_value = $this->uri->segment(4); 
         $search_external_value = str_replace("#"," ", $this->uri->segment(4));

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $biblio) {
        	# kolom judul
        	$judul_paralel = '';
        	$judul_terjemah = '';
        	$pengarang = '';

        	if ($biblio->judul_paralel != '') {
        		$judul_paralel = ' : '.$biblio->judul_paralel;
        	}
        	if ($biblio->judul_terjemah != '') {
        		$judul_terjemah = ' : '.$biblio->judul_terjemah;
        	}        	

        	# mencari kepengerangan
        	$arraywhere = array('perpus_biblio_pengarang.id_biblio' => $biblio->id_biblio);
        	$kepengarangan = $this->m_models->getJoin1where("perpus_penulis.nama", "perpus_biblio_pengarang","perpus_penulis", "perpus_penulis.id_penulis=perpus_biblio_pengarang.id_penulis", $arraywhere, "perpus_biblio_pengarang.id_biblio_pengarang", "desc");
        	foreach ($kepengarangan as $key) {
        		$pengarang = '<br>'.$key->nama;
        	}
        	
        	# kolom kepenerbitana
        	$tempat = '';
        	$penerbit = '';

        	if ($biblio->nama_tempat != '' AND $biblio->nama_penerbit != '') {
        		$tempat = $biblio->nama_tempat.' : ';
        	}elseif($biblio->nama_tempat != ''){
        		$tempat = $biblio->nama_tempat;
        	}
        	if ($biblio->nama_penerbit != '' AND $biblio->tahun_terbit != '') {
        		$penerbit = $biblio->nama_penerbit.', ';
        	}elseif($biblio->nama_penerbit != ''){
        		$penerbit = $biblio->nama_penerbit;
        	}

        	# mencari jumlah eksemplar
        	$jumlah_eksemplar = $this->m_models->getRows("perpus_bahan_pustaka WHERE id_biblio='$biblio->id_biblio' ");

            $no++;
            $row = array();
            $row[] = $no;
            $row[] = '<a href="edit_bibliografi/'.$biblio->id_biblio.'" >'.$biblio->judul.$judul_paralel.$judul_terjemah.$pengarang.'</a>';
            $row[] = $biblio->edisi;
            $row[] = $tempat.$penerbit.$biblio->tahun_terbit;
            $row[] = $biblio->deskripsi_fisik;
            $row[] = $biblio->no_panggil;
            $row[] = '';
            $row[] = $jumlah_eksemplar;
            $row[] = '<div class="btn-group">
            			<a href="detail_bibliografi/'.$biblio->id_biblio.'"><button type="button" class="btn btn-primary btn-sm" ><i class="fa fa-folder-open"></i> Detail</button></a>
                      </div>';

            $data[] = $row;
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function tambah_bibliografi(){
		$this->load->view('template/header');

		# ---------- ambil data buat form isian ----------- #
		# ambil data tempat terbit
		$data[tempat] = $this->m_models->getAll("perpus_tempat ORDER BY nama_tempat ASC");
		# ambil data penerbit
		$data[penerbit] = $this->m_models->get_data("id_penerbit, nama as nama_penerbit", "perpus_penerbit", "ORDER BY nama ASC");
		# ambil data kategori buku
		$data[kategori] = $this->m_models->get_data("id_kategori_buku, nama as nama_kategori_buku", "perpus_kategori_buku", "ORDER BY nama ASC");
		# ambil data bahasa
		$data[bahasa] = $this->m_models->get_data("id_bahasa, nama_bahasa", "perpus_bahasa", "ORDER BY nama_bahasa ASC");
		# ambil data tema
		$data[tema] = $this->m_models->get_data("*", "perpus_tema", "ORDER BY tema ASC");
		# ambil data penulis
		$data[penulis] = $this->m_models->get_data("id_penulis, nama as penulis", "perpus_penulis", "ORDER BY nama ASC");
		# ambil data jenis_kepengarangan
		$data[jenis_kepengarangan] = $this->m_models->get_data("*", "perpus_jenis_kepengarangan", "ORDER BY nama_jenis_kepengarangan ASC");
		# ambil data jenis sumber
		$data[sumber] = $this->m_models->get_data("*", "perpus_sumber", "ORDER BY nama_sumber ASC");
		# ambil data nama sumber
		$data[supplier] = $this->m_models->get_data("*", "perpus_supplier", "ORDER BY nama_supplier ASC");
		# ambil data nama sumber
		$data[jenis_pustaka] = $this->m_models->get_data("*", "perpus_jenis_pustaka", "ORDER BY jenis_pustaka ASC");
		# ambil data status
		$data[status_item] = $this->m_models->get_data("*", "perpus_status_item", "ORDER BY nama_status_item ASC");
		# ambil data lokasi perpustakaan
		$data[lokasi] = $this->m_models->get_data("*", "perpus_lokasi", "ORDER BY nama_lokasi ASC");
		# ambil data eddc
		$data[ddc] = $this->m_models->getAll("perpus_ddc ORDER BY kode_ddc ASC");
		# ---------- /. data buat form isian -------------- #



		# tampilkan data ke view
		$this->load->view('perpustakaan/tambah_bibliografi', $data); 

		$this->load->view('template/footer');	
	}

	function get_penulis(){
		if (isset($_GET['term'])){ 
      		$q = strtolower($_GET['term']);
      		$datacari = $this->m_models->get_data("nama", "perpus_penulis", "WHERE nama like '%$q%' ORDER BY nama ASC ");

      		if (count($datacari > 0)) {
      			foreach ($datacari as $key) {
      				$row_set[] = $key->nama;
      			}
      			echo json_encode($row_set);
      		}
    	}
	}

	function simpan_bibliografi(){
		$gambar_sampul = '';

		/* -- upload berkas -- */
		$this->upload->initialize(array(
			'file_name' => 'file_'.time(),
	        'upload_path' => './assets/gambar_sampul', // nama folder gambar
	        'allowed_types' => 'jpg|png|jpeg|bmp', // format gambar
	        )); 

		if($this->upload->do_upload('gambar_sampul')){
        	$data_upload = $this->upload->data();
        	# ambil nama buat di simpan di tabel database
        	$gambar_sampul = $data_upload['file_name'];       		
		}else{
			$error = $this->upload->display_errors();
		//	print_r($error);
		}
		/* -- end upload berkas --*/

		# judul
		$judul = $this->input->post('judul', TRUE);
		$judul_paralel = $this->input->post('judul_paralel', TRUE);
		$judul_terjemah = $this->input->post('judul_terjemah', TRUE);
		# nama pengarang untuk kartu katalog, di input manual
		$pengarang_katalog = $this->input->post('pengarang_katalog', TRUE);

		# penerbit tempat dan penerbit harus di edit
		$id_tempat = $this->input->post('tempat', TRUE);
		# jika tempatnya baru maka simpat dulu di tabel tempat kemudina ambil id nya
		$tempat_baru = strpos($id_tempat,"-");
		if ($tempat_baru == TRUE){
			$exp = explode("-", $id_tempat);
			$nama_tempat = $exp[1];

			$data_tempat = array('nama_tempat' => $nama_tempat);

			if ($this->m_models->save_data($data_tempat, "perpus_tempat") == TRUE) {
				$tempat = $this->m_models->get_data("id_tempat", "perpus_tempat", "WHERE nama_tempat='$nama_tempat'");
				$id_tempat = $tempat[0]->id_tempat;
			}else{
				$id_tempat = 0;
			}
		}

		$id_penerbit = $this->input->post('penerbit', TRUE);
		# jika penerbit baru maka simpat dulu di tabel penerbit kemudina ambil id nya
		$penerbit_baru = strpos($id_penerbit,"-");
		if ($penerbit_baru == TRUE){ 
			$exp = explode("-", $id_penerbit);
			$nama_penerbit = $exp[1];

			$data_penerbit = array('nama' => $nama_penerbit);

			if ($this->m_models->save_data($data_penerbit, "perpus_penerbit") == TRUE) {
				$penerbit = $this->m_models->get_data("id_penerbit", "perpus_penerbit", "WHERE nama='$nama_penerbit'");
				$id_penerbit = $penerbit[0]->id_penerbit;
			}else{
				$id_penerbit = 0;
			}
		}

		$tahun_terbit = $this->input->post('tahun_terbit', TRUE);
		$edisi = $this->input->post('edisi', TRUE);
		$jumlah_seri = $this->input->post('jumlah_seri', TRUE);

		$klasifikasi = $this->input->post('klasifikasi', TRUE);
		# jika klasifikasi baru maka simpat dulu di tabel ddc kemudina ambil id nya
		$klasifikasi_baru = strpos($klasifikasi,"-");
		if ($klasifikasi_baru == TRUE){
			$exp = explode("-", $klasifikasi);
			$klasifikasi_baru = $exp[1];

			$exp_klasifikasi = explode(":", $klasifikasi_baru);
			$no_klas_ddc = trim($exp_klasifikasi[0]);
			$subjek = trim($exp_klasifikasi[1]);

			$data_klasifikasi = array('kode_ddc' => $no_klas_ddc, 'subjek' => $subjek);

			if ($this->m_models->save_data($data_klasifikasi, "perpus_ddc") == TRUE) {
				$klasifikasi = $no_klas_ddc;
			}
		}else{
			$exp_klasifikasi = explode(":", $klasifikasi);
			$klasifikasi = trim($exp_klasifikasi[0]);
		}

		$no_panggil = $this->input->post('no_panggil', TRUE);
		$isbn_issn = $this->input->post('isbn', TRUE);
		$id_kategori_buku = $this->input->post('kategori_buku', TRUE);
		$id_bahasa = $this->input->post('bahasa', TRUE);
		$deskripsi_fisik = $this->input->post('deskripsi_fisik', TRUE);
		$daerah_catatan = $this->input->post('daerah_catatan', TRUE);
		$catatan = $this->input->post('catatan', TRUE);
		$nrp = $this->session->userdata['nrp'];

		$data = array(
			'judul' => $judul,
			'judul_paralel' => $judul_paralel,
			'judul_terjemah' => $judul_terjemah,
			'edisi' => $edisi,
			'isbn_issn' => $isbn_issn,
			'id_penerbit' => $id_penerbit,
			'tahun_terbit' => $tahun_terbit,
			'id_tempat' => $id_tempat,
			'jumlah_seri' => $jumlah_seri,
			'daerah_catatan' => $daerah_catatan,
			'klasifikasi' => $klasifikasi,
			'no_panggil' => $no_panggil,
			'id_kategori_buku' => $id_kategori_buku,
			'id_bahasa' => $id_bahasa,
			'catatan' => $catatan,
			'deskripsi_fisik' => $deskripsi_fisik,
			'gambar' => $gambar_sampul,
			'nrp' => $nrp,
			'pengarang_katalog' => $pengarang_katalog
		);

		# proses simpan
		if ($this->m_models->save_data($data, "perpus_biblio") == TRUE) {
			# ambil id biblio yang baru disimpan, ngambil yang terakhir aja ah
			$biblio = $this->m_models->get_data("id_biblio", "perpus_biblio", "ORDER BY id_biblio DESC LIMIT 1");
			$id_biblio = $biblio[0]->id_biblio;

			# simpan tema tema yang dipilih ke tabel biblio_tema
			/* subyek diambil dari kalsifikasi aja
			$tema = $this->input->post('tema');
			$jml_tema = count($this->input->post('tema'));
			for ($i=0; $i < $jml_tema ; $i++) { 
				$data_tema[$i]['id_biblio_tema'] = '';
				$data_tema[$i]['id_biblio'] = $id_biblio;
				$data_tema[$i]['id_tema'] = $tema[$i];
			}

			if ($jml_tema > 0) {
				$this->m_models->save_batch($data_tema, "perpus_biblio_tema");
			}
			*/
			
			# simpan data kepengarangan 
			$nama = $this->input->post('nama_input');
			$jml_data = count($this->input->post('nama_input'));
			$kepengarangan = $this->input->post('poin_input');

			$x = 0;
			for ($i=1; $i <= $jml_data ; $i++) { 
				if ($nama[$i] != '' AND $kepengarangan[$i] != '') {
					# cek id penulis di tabel penulis yang namanya di post
					$cek_penulis = $this->m_models->getRows("perpus_penulis WHERE nama='$nama[$i]'");
					if ($cek_penulis > 0) {
						$penulis = $this->m_models->get_data("id_penulis", "perpus_penulis", "WHERE nama='$nama[$i]' ");
						$id_penulis = $penulis[0]->id_penulis;
					}else{
						$penulis_baru = array(
							'id_penulis' => '',
							'nama' => $nama[$i], 
							'tahun' => '', 
							'tipe' => ''
						);

						if ($this->m_models->save_data($penulis_baru, "perpus_penulis") == TRUE) {
							$penulis = $this->m_models->get_data("id_penulis", "perpus_penulis", "WHERE nama='$nama[$i]' ");
							$id_penulis = $penulis[0]->id_penulis;
						}
					}

					$jenis_kepengarangan = $this->m_models->get_data("id_jenis_kepengarangan", "perpus_jenis_kepengarangan", "WHERE nama_jenis_kepengarangan='$kepengarangan[$i]' ");
					$id_jenis_kepengarangan = $jenis_kepengarangan[0]->id_jenis_kepengarangan;

					$data_penulis[$x]['id_biblio_pengarang'] = '';
					$data_penulis[$x]['id_biblio'] = $id_biblio;
					$data_penulis[$x]['id_penulis'] = $id_penulis;
					$data_penulis[$x]['id_jenis_kepengarangan'] = $id_jenis_kepengarangan;

					$x++;
				}
			}

			if ($x > 0) {
				$this->m_models->save_batch($data_penulis, "perpus_biblio_pengarang");
			}

			# simpan data pengadaan
			$id_supplier = $this->input->post('supplier', TRUE);
			# jika supplier baru maka simpan dulu di tabel supplier kemudina ambil id nya
			$supplier_baru = strpos($id_supplier,"-");
			if ($supplier_baru == TRUE){
				$exp = explode("-", $id_supplier);
				$nama_supplier = $exp[1];

				$data_supplier = array('nama_supplier' => $nama_supplier);

				if ($this->m_models->save_data($data_supplier, "perpus_supplier") == TRUE) {
					$supplier = $this->m_models->get_data("id_supplier", "perpus_supplier", "WHERE nama_supplier='$nama_supplier'");
					$id_supplier = $supplier[0]->id_supplier;
				}else{
					$id_supplier = 0;
				}
			}

			$tanggal_penerimaan = date_db($this->input->post('tanggal_penerimaan', TRUE));
			$id_sumber = $this->input->post('sumber', TRUE);
			$id_jenis_pustaka = $this->input->post('jenis_pustaka', TRUE);
			$id_status_item = $this->input->post('status_kondisi', TRUE);
			$id_lokasi = $this->input->post('lokasi', TRUE);
			$harga = str_replace('.', '',$this->input->post('harga', TRUE));

			# cari id biblio terakhir
			$kode_inv_lama = '';
			if ($id_jenis_pustaka == '1') {
				$id_akhir = $this->m_models->get_data("kode_inv", "perpus_bahan_pustaka", "WHERE id_jenis_pustaka='$id_jenis_pustaka' ORDER BY id_bahan_pustaka DESC LIMIT 1 ");
				foreach ($id_akhir as $key) {
					$kode_inv_lama = $key->kode_inv;
				}

				if ($kode_inv_lama != NULL) {
					$no_urut = (int) $kode_inv_lama;
				}else{
					$no_urut = 0;
				}
			}elseif ($id_jenis_pustaka == '2') {
				$tahun_sekarang = date('y');
				$id_akhir = $this->m_models->get_data("kode_inv", "perpus_bahan_pustaka", "WHERE id_jenis_pustaka='$id_jenis_pustaka' AND tanggal_penerimaan like '$tahun_sekarang%' ORDER BY id_bahan_pustaka DESC LIMIT 1 ");
				foreach ($id_akhir as $key) {
					$kode_inv_lama = $key->kode_inv;
				}

				if ($kode_inv_lama != NULL) {
					$kode_inv_lama = substr($kode_inv_lama, -3);
					$no_urut = (int) $kode_inv_lama;
				}else{
					$no_urut = 0;
				}
			}elseif ($id_jenis_pustaka == '3') {
				$id_akhir = $this->m_models->get_data("kode_inv", "perpus_bahan_pustaka", "WHERE id_jenis_pustaka='$id_jenis_pustaka' ORDER BY id_bahan_pustaka DESC LIMIT 1 ");
				foreach ($id_akhir as $key) {
					$kode_inv_lama = $key->kode_inv;
				}

				if ($kode_inv_lama != NULL) { 
					$kode_inv_lama = substr($kode_inv_lama, -3);
					$no_urut = (int) $kode_inv_lama;
				}else{
					$no_urut = 0;
				}
			}else{
				$id_akhir = $this->m_models->get_data("kode_inv", "perpus_bahan_pustaka", "WHERE id_jenis_pustaka='$id_jenis_pustaka' ORDER BY id_bahan_pustaka DESC LIMIT 1 ");
				foreach ($id_akhir as $key) {
					$kode_inv_lama = $key->kode_inv;
				}

				if ($kode_inv_lama != NULL) { 
					$kode_inv_lama = substr($kode_inv_lama, -3);
					$no_urut = (int) $kode_inv_lama;
				}else{
					$no_urut = 0;
				}				
			}
				
			$jenis_pustaka = $this->m_models->get_data("kode_jenis_pustaka", "perpus_jenis_pustaka", "WHERE id_jenis_pustaka='$id_jenis_pustaka' ");
			foreach ($jenis_pustaka as $key) {
				$kode_jenis_pustaka = $key->kode_jenis_pustaka;
			}

			$tahun_sekarang = date('Y');

			$jumlah = $this->input->post('jumlah', TRUE);		

			for ($i=0; $i < $jumlah; $i++) { 
				# buat kode inv baru terurut
				$no_urut++;

				if ($id_jenis_pustaka == '1') {
					$kode_inv_baru = sprintf("%06s", $no_urut);
				}elseif($id_jenis_pustaka == '3') {
					$kode_inv_baru = $kode_jenis_pustaka.sprintf("%03s", $no_urut);
				}else{
					$kode_inv_baru = $tahun_sekarang.$kode_jenis_pustaka.sprintf("%03s", $no_urut);
				}

				$data_bahan[$i]['id_bahan_pustaka'] = '';
				$data_bahan[$i]['id_biblio'] = $id_biblio;
				$data_bahan[$i]['kode_inv'] = $kode_inv_baru;
				$data_bahan[$i]['id_jenis_pustaka'] = $id_jenis_pustaka;
				$data_bahan[$i]['tanggal_penerimaan'] = $tanggal_penerimaan;
				$data_bahan[$i]['id_supplier'] = $id_supplier;
				$data_bahan[$i]['id_sumber'] = $id_sumber;
				$data_bahan[$i]['id_lokasi'] = $id_lokasi;
				$data_bahan[$i]['harga'] = $harga;
				$data_bahan[$i]['id_status_item'] = $id_status_item;
				$data_bahan[$i]['nrp'] = $nrp;
			}

			if ($jumlah > 0) {
				$this->m_models->save_batch($data_bahan, "perpus_bahan_pustaka");
			}

			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/bibliografi'); 		
	}

	function edit_bibliografi($id_biblio){
		$this->load->view('template/header');

		# ---------- ambil data buat form isian ----------- #
		# ambil data tempat terbit
		$data[tempat] = $this->m_models->getAll("perpus_tempat ORDER BY nama_tempat ASC");
		# ambil data penerbit
		$data[penerbit] = $this->m_models->get_data("id_penerbit, nama as nama_penerbit", "perpus_penerbit", "ORDER BY nama ASC");
		# ambil data kategori buku
		$data[kategori] = $this->m_models->get_data("id_kategori_buku, nama as nama_kategori_buku", "perpus_kategori_buku", "ORDER BY nama ASC");
		# ambil data bahasa
		$data[bahasa] = $this->m_models->get_data("id_bahasa, nama_bahasa", "perpus_bahasa", "ORDER BY nama_bahasa ASC");
		# ambil data tema
		$data[tema] = $this->m_models->get_data("*", "perpus_tema", "ORDER BY tema ASC");
		# ambil data penulis
		$data[penulis] = $this->m_models->get_data("id_penulis, nama as penulis", "perpus_penulis", "ORDER BY nama ASC");
		# ambil data jenis_kepengarangan
		$data[jenis_kepengarangan] = $this->m_models->get_data("*", "perpus_jenis_kepengarangan", "ORDER BY nama_jenis_kepengarangan ASC");
		# ambil data jenis sumber
		$data[sumber] = $this->m_models->get_data("*", "perpus_sumber", "ORDER BY nama_sumber ASC");
		# ambil data nama sumber
		$data[supplier] = $this->m_models->get_data("*", "perpus_supplier", "ORDER BY nama_supplier ASC");
		# ambil data nama sumber
		$data[jenis_pustaka] = $this->m_models->get_data("*", "perpus_jenis_pustaka", "ORDER BY jenis_pustaka ASC");
		# ambil data status
		$data[status_item] = $this->m_models->get_data("*", "perpus_status_item", "ORDER BY nama_status_item ASC");
		# ambil data lokasi perpustakaan
		$data[lokasi] = $this->m_models->get_data("*", "perpus_lokasi", "ORDER BY nama_lokasi ASC");
		# ---------- /. data buat form isian -------------- #

		$data['biblio'] = $this->m_models->get_data("*", "perpus_biblio", "WHERE id_biblio='$id_biblio' ");

		$arraywhere = array('perpus_biblio_pengarang.id_biblio' => $id_biblio);
		$data['biblio_pengarang'] = $this->perpus_models->getJoin2where("perpus_biblio_pengarang.*, perpus_penulis.nama, perpus_jenis_kepengarangan.*", "perpus_biblio_pengarang", "perpus_penulis", "perpus_biblio_pengarang.id_penulis=perpus_penulis.id_penulis", "perpus_jenis_kepengarangan", "perpus_biblio_pengarang.id_jenis_kepengarangan=perpus_jenis_kepengarangan.id_jenis_kepengarangan", $arraywhere, "perpus_biblio_pengarang.id_biblio", "ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/edit_bibliografi', $data); 

		$this->load->view('template/footer');			
	}

	function simpan_edit_bibliografi(){
		$gambar_sampul = '';

		/* -- upload berkas -- */
		$this->upload->initialize(array(
			'file_name' => 'file_'.time(),
	        'upload_path' => './assets/gambar_sampul', // nama folder gambar
	        'allowed_types' => 'jpg|png|jpeg|bmp', // format gambar
	        )); 

		if($this->upload->do_upload('gambar_sampul')){
        	$data_upload = $this->upload->data();
        	# ambil nama buat di simpan di tabel database
        	$gambar_sampul = $data_upload['file_name'];       		
		}else{
			$error = $this->upload->display_errors();
		//	print_r($error);
		}
		/* -- end upload berkas --*/

		# judul
		$judul = $this->input->post('judul', TRUE);
		$judul_paralel = $this->input->post('judul_paralel', TRUE);
		$judul_terjemah = $this->input->post('judul_terjemah', TRUE);

		# pengarang untuk kartu katalog
		$pengarang_katalog = $this->input->post('pengarang_katalog', TRUE);

		# penerbit tempat dan penerbit harus di edit
		$id_tempat = $this->input->post('tempat', TRUE);
		# jika tempatnya baru maka simpat dulu di tabel tempat kemudina ambil id nya
		$tempat_baru = strpos($id_tempat,"-");
		if ($tempat_baru == TRUE){
			$exp = explode("-", $id_tempat);
			$nama_tempat = $exp[1];

			$data_tempat = array('nama_tempat' => $nama_tempat);

			if ($this->m_models->save_data($data_tempat, "perpus_tempat") == TRUE) {
				$tempat = $this->m_models->get_data("id_tempat", "perpus_tempat", "WHERE nama_tempat='$nama_tempat'");
				$id_tempat = $tempat[0]->id_tempat;
			}else{
				$id_tempat = 0;
			}
		}

		$id_penerbit = $this->input->post('penerbit', TRUE);
		# jika penerbit baru maka simpat dulu di tabel penerbit kemudina ambil id nya
		$penerbit_baru = strpos($id_penerbit,"-");
		if ($penerbit_baru == TRUE){ 
			$exp = explode("-", $id_penerbit);
			$nama_penerbit = $exp[1];

			$data_penerbit = array('nama' => $nama_penerbit);

			if ($this->m_models->save_data($data_penerbit, "perpus_penerbit") == TRUE) {
				$penerbit = $this->m_models->get_data("id_penerbit", "perpus_penerbit", "WHERE nama='$nama_penerbit'");
				$id_penerbit = $penerbit[0]->id_penerbit;
			}else{
				$id_penerbit = 0;
			}
		}

		$id_biblio = $this->input->post('id_biblio', TRUE);
		$tahun_terbit = $this->input->post('tahun_terbit', TRUE);
		$edisi = $this->input->post('edisi', TRUE);
		$jumlah_seri = $this->input->post('jumlah_seri', TRUE);
		$klasifikasi = $this->input->post('klasifikasi', TRUE);
		$no_panggil = $this->input->post('no_panggil', TRUE);
		$isbn_issn = $this->input->post('isbn', TRUE);
		$id_kategori_buku = $this->input->post('kategori_buku', TRUE);
		$id_bahasa = $this->input->post('bahasa', TRUE);
		$deskripsi_fisik = $this->input->post('deskripsi_fisik', TRUE);
		$daerah_catatan = $this->input->post('daerah_catatan', TRUE);
		$catatan = $this->input->post('catatan', TRUE);
		$nrp = $this->session->userdata['nrp'];

		$data = array(
			'judul' => $judul,
			'judul_paralel' => $judul_paralel,
			'judul_terjemah' => $judul_terjemah,
			'edisi' => $edisi,
			'isbn_issn' => $isbn_issn,
			'id_penerbit' => $id_penerbit,
			'tahun_terbit' => $tahun_terbit,
			'id_tempat' => $id_tempat,
			'jumlah_seri' => $jumlah_seri,
			'daerah_catatan' => $daerah_catatan,
			'klasifikasi' => $klasifikasi,
			'no_panggil' => $no_panggil,
			'id_kategori_buku' => $id_kategori_buku,
			'id_bahasa' => $id_bahasa,
			'catatan' => $catatan,
			'deskripsi_fisik' => $deskripsi_fisik,
			'gambar' => $gambar_sampul,
			'nrp' => $nrp,
			'pengarang_katalog' => $pengarang_katalog
		);

		# proses simpan
		if ($this->m_models->update_data($id_biblio, 'id_biblio', $data,"perpus_biblio") == TRUE) {

			# simpan tema tema yang dipilih ke tabel biblio_tema
			/* subyek diambil dari kalsifikasi aja
			$tema = $this->input->post('tema');
			$jml_tema = count($this->input->post('tema'));
			for ($i=0; $i < $jml_tema ; $i++) { 
				$data_tema[$i]['id_biblio_tema'] = '';
				$data_tema[$i]['id_biblio'] = $id_biblio;
				$data_tema[$i]['id_tema'] = $tema[$i];
			}

			if ($jml_tema > 0) {
				$this->m_models->save_batch($data_tema, "perpus_biblio_tema");
			}
			*/
		
			# hapus bibilio_pengarang
			$pengarang_hapus = $this->input->post('pengarang_hapus', TRUE);
			$exp_hapus = explode("+", $pengarang_hapus);

			for ($a=0; $a < count($exp_hapus); $a++) { 
				$id_penulis = $exp_hapus[$a]; 
				$this->m_models->delete_data($id_penulis, 'id_biblio_pengarang', 'perpus_biblio_pengarang');
			}
			
			# simpan data kepengarangan 
			$nama = $this->input->post('nama_input');
			$jml_data = count($this->input->post('nama_input'));
			$kepengarangan = $this->input->post('poin_input');

			$x = 0;
			for ($i=1; $i <= $jml_data ; $i++) { 
				if ($nama[$i] != '' AND $kepengarangan[$i] != '') {
					# cek id penulis di tabel penulis yang namanya di post
					$cek_penulis = $this->m_models->getRows("perpus_penulis WHERE nama='$nama[$i]'");
					if ($cek_penulis > 0) {
						$penulis = $this->m_models->get_data("id_penulis", "perpus_penulis", "WHERE nama='$nama[$i]' ");
						$id_penulis = $penulis[0]->id_penulis;
					}else{
						$penulis_baru = array(
							'id_penulis' => '',
							'nama' => $nama[$i], 
							'tahun' => '', 
							'tipe' => ''
						);

						if ($this->m_models->save_data($penulis_baru, "perpus_penulis") == TRUE) {
							$penulis = $this->m_models->get_data("id_penulis", "perpus_penulis", "WHERE nama='$nama[$i]' ");
							$id_penulis = $penulis[0]->id_penulis;
						}
					}

					$jenis_kepengarangan = $this->m_models->get_data("id_jenis_kepengarangan", "perpus_jenis_kepengarangan", "WHERE nama_jenis_kepengarangan='$kepengarangan[$i]' ");
					$id_jenis_kepengarangan = $jenis_kepengarangan[0]->id_jenis_kepengarangan;

					$data_penulis[$x]['id_biblio_pengarang'] = '';
					$data_penulis[$x]['id_biblio'] = $id_biblio;
					$data_penulis[$x]['id_penulis'] = $id_penulis;
					$data_penulis[$x]['id_jenis_kepengarangan'] = $id_jenis_kepengarangan;

					$x++;
				}
			}

			if ($x > 0) {
				$this->m_models->save_batch($data_penulis, "perpus_biblio_pengarang");
			}

			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/bibliografi'); 		
	}

	function detail_bibliografi($id_biblio){
		$this->load->view('template/header');

		# ---------- /. data biblio -------------- #
		$arraywhere = array('perpus_biblio.id_biblio' => $id_biblio);
		$data['biblio'] = $this->perpus_models->getJoin4where("perpus_biblio.*, perpus_bahasa.*, perpus_kategori_buku.nama as nama_kategori_buku, perpus_tempat.*, perpus_penerbit.nama as nama_penerbit", "perpus_biblio", 
			"perpus_bahasa", "perpus_biblio.id_bahasa=perpus_bahasa.id_bahasa", 
			"perpus_kategori_buku", "perpus_biblio.id_kategori_buku=perpus_kategori_buku.id_kategori_buku", 
			"perpus_tempat", "perpus_biblio.id_tempat=perpus_tempat.id_tempat",
			"perpus_penerbit", "perpus_biblio.id_penerbit=perpus_penerbit.id_penerbit",
			$arraywhere, "perpus_biblio.id_biblio", "ASC");

		$arraywhere = array('perpus_biblio_pengarang.id_biblio' => $id_biblio);
		$data['biblio_pengarang'] = $this->perpus_models->getJoin2where("perpus_biblio_pengarang.*, perpus_penulis.nama, perpus_jenis_kepengarangan.*", "perpus_biblio_pengarang", "perpus_penulis", "perpus_biblio_pengarang.id_penulis=perpus_penulis.id_penulis", "perpus_jenis_kepengarangan", "perpus_biblio_pengarang.id_jenis_kepengarangan=perpus_jenis_kepengarangan.id_jenis_kepengarangan", $arraywhere, "perpus_biblio_pengarang.id_biblio", "ASC");

		# ----------------------------------------- #
		# --------- data bahan pustaka ------------ #
		$arraywhere = array('perpus_bahan_pustaka.id_biblio' => $id_biblio);
		$data['bahan_pustaka'] = $this->perpus_models->getJoin2where("perpus_bahan_pustaka.kode_inv, perpus_bahan_pustaka.id_bahan_pustaka, perpus_bahan_pustaka.kode_inv, perpus_lokasi.*, perpus_status_item.*", "perpus_bahan_pustaka", 
			"perpus_lokasi", "perpus_bahan_pustaka.id_lokasi=perpus_lokasi.id_lokasi", 
			"perpus_status_item", "perpus_bahan_pustaka.id_status_item=perpus_status_item.id_status_item", 
			$arraywhere, "perpus_bahan_pustaka.id_bahan_pustaka", "ASC");
		# ----------------------------------------- #
		# tampilkan data ke view
		$this->load->view('perpustakaan/detail_bibliografi', $data); 

		$this->load->view('template/footer');			
	}

	function detail_bahan_pustaka(){ 
		$this->load->view('template/head');
		$id = $this->input->post('id', TRUE);
		
		# --------- data bahan pustaka ------------ #
		$arraywhere = array('perpus_bahan_pustaka.id_bahan_pustaka' => $id);
		$data['detail_bahan_pustaka'] = $this->perpus_models->getJoin5where("perpus_bahan_pustaka.*, perpus_jenis_pustaka.*, perpus_lokasi.*, perpus_status_item.*, perpus_supplier.*, perpus_sumber.* ", "perpus_bahan_pustaka", 
			"perpus_lokasi", "perpus_bahan_pustaka.id_lokasi=perpus_lokasi.id_lokasi", 
			"perpus_status_item", "perpus_bahan_pustaka.id_status_item=perpus_status_item.id_status_item", 
			"perpus_jenis_pustaka", "perpus_bahan_pustaka.id_jenis_pustaka=perpus_jenis_pustaka.id_jenis_pustaka", 
			"perpus_sumber", "perpus_bahan_pustaka.id_sumber=perpus_sumber.id_sumber", 
			"perpus_supplier", "perpus_bahan_pustaka.id_supplier=perpus_supplier.id_supplier", 
			$arraywhere, "perpus_bahan_pustaka.id_bahan_pustaka", "ASC");
		# ----------------------------------------- #

		$this->load->view('perpustakaan/detail_bahan_pustaka', $data); 
		$this->load->view('template/js');
	}

	function bahan_pustaka(){
		$this->load->view('template/header');
		$kolom_cari = $this->input->post('kolom_cari', TRUE);
        $text_cari = $this->input->post('text_cari', TRUE);

		$data['kolom_cari'] = $kolom_cari;
        $data['text_cari'] = $text_cari;

		$text_cari = str_replace(" ","#", $text_cari);

        # kirim link ajax list penulis 
        $data['url_ajax'] = 'perpus/ajax_list_bahan_pustaka/'.$kolom_cari.'/'.$text_cari;

		# tampilkan data ke view
		$this->load->view('perpustakaan/bahan_pustaka', $data); 

		$this->load->view('template/footer');		
	}


    public function ajax_list_bahan_pustaka()
    {
    	 $table = 'perpus_bahan_pustaka';
		 $column_order = array(null,'kode_inv', 'tanggal_penerimaan', 'judul'); //set column field database for datatable orderable
		 $order = array('id_bahan_pustaka' => 'desc'); // default order 
		 $column_search_external = $this->uri->segment(3);
		 if ($column_search_external != null) {
		 	$column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
		 }else{
		 	$column_search = array('tanggal_penerimaan'); //set column field database for datatable searchable 
		 }
		 
		 $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $biblio) {
        	
        	# kolom judul
        	$judul_paralel = '';
        	$judul_terjemah = '';
        	$pengarang = '';

        	if ($biblio->judul_paralel != '') {
        		$judul_paralel = ' : '.$biblio->judul_paralel;
        	}
        	if ($biblio->judul_terjemah != '') {
        		$judul_terjemah = ' : '.$biblio->judul_terjemah;
        	}        	

        	# mencari kepengerangan
	       	$arraywhere = array('perpus_biblio_pengarang.id_biblio' => $biblio->id_biblio);
        	$kepengarangan = $this->m_models->getJoin1where("perpus_penulis.nama", "perpus_biblio_pengarang","perpus_penulis", "perpus_penulis.id_penulis=perpus_biblio_pengarang.id_penulis", $arraywhere, "perpus_biblio_pengarang.id_biblio_pengarang", "desc");
        	foreach ($kepengarangan as $key) {
        		$pengarang = '<br>'.$key->nama;
        	}
        	
        	# kolom kepenerbitana
        	$tempat = '';
        	$penerbit = '';

        	if ($biblio->id_tempat != 0 AND $biblio->id_penerbit != 0) {
        		$data_tempat = $this->m_models->get_data("*", "perpus_tempat", "WHERE id_tempat='$biblio->id_tempat' ");
        		foreach ($data_tempat as $key) {
        			$tempat = $key->nama_tempat.' : ';
        		}
        	}elseif($biblio->id_tempat != 0){
        		$data_tempat = $this->m_models->get_data("*", "perpus_tempat", "WHERE id_tempat='$biblio->id_tempat' ");
        		foreach ($data_tempat as $key) {
        			$tempat = $key->nama_tempat;
        		}
        	}
        	if ($biblio->id_penerbit != 0 AND $biblio->tahun_terbit != '') {
        		$data_penerbit = $this->m_models->get_data("*", "perpus_penerbit", "WHERE id_penerbit='$biblio->id_penerbit' ");
        		foreach ($data_penerbit as $key) {
        			$penerbit = $key->nama.', ';
        		}
        	}elseif($biblio->id_penerbit != 0){
        		$data_penerbit = $this->m_models->get_data("*", "perpus_penerbit", "WHERE id_penerbit='$biblio->id_penerbit' ");
        		foreach ($data_penerbit as $key) {
        			$penerbit = $key->nama;
        		}
        	}

        	$edisi = '';
        	if ($biblio->edisi != '') {
        		$edisi = $biblio->edisi.'<br>';
        	}

        	# cek ketersediaan
        	$pinjaman = $this->m_models->getRows("perpus_pinjaman WHERE kode_inv='$biblio->kode_inv' AND status='0' ");
        	if ($pinjaman > 0) {
        		$ketersediaan = 'Tidak Tersedia';
        	}else{
        		$ketersediaan = 'Tersedia';
        	}

        	# cari kategori buku
        	$kategori_buku = "";
        	$data_kategori_buku = $this->m_models->get_data("nama", "perpus_kategori_buku", "WHERE id_kategori_buku='$biblio->id_kategori_buku' ");
        	foreach ($data_kategori_buku as $key) {
        		$kategori_buku = " - ".$key->nama;
        	}

            $no++;
            $row = array();
            $row[] = number_format($no);
            $row[] = '<a href="edit_bahan_pustaka/'.$biblio->id_bahan_pustaka.'/'.$biblio->id_biblio.'" >'.$biblio->kode_inv.'</a>';
            $row[] = mediumdate_indo($biblio->tanggal_penerimaan);
            $row[] = '<b>'.$biblio->judul.$judul_paralel.$judul_terjemah.$pengarang.'</b><br><br>'.$edisi.$tempat.$penerbit.$biblio->tahun_terbit.'<br>'.$biblio->deskripsi_fisik;
            $row[] = $biblio->jenis_pustaka . $kategori_buku;
            $row[] = $biblio->klasifikasi;
            $row[] = $biblio->no_panggil;
            $row[] = $biblio->nama_sumber;
            $row[] = $biblio->nama_status_item;
            $row[] = $ketersediaan;
            $row[] = $biblio->nama_lokasi;

            $data[] = $row;
    
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

    function edit_bahan_pustaka($id_bp, $id_biblio){
		$this->load->view('template/header');

		# ---------- ambil data buat form isian ----------- #
		# ambil data jenis sumber
		$data[sumber] = $this->m_models->get_data("*", "perpus_sumber", "ORDER BY nama_sumber ASC");
		# ambil data nama sumber
		$data[supplier] = $this->m_models->get_data("*", "perpus_supplier", "ORDER BY nama_supplier ASC");
		# ambil data nama sumber
		$data[jenis_pustaka] = $this->m_models->get_data("*", "perpus_jenis_pustaka", "ORDER BY jenis_pustaka ASC");
		# ambil data status
		$data[status_item] = $this->m_models->get_data("*", "perpus_status_item", "ORDER BY nama_status_item ASC");
		# ambil data lokasi perpustakaan
		$data[lokasi] = $this->m_models->get_data("*", "perpus_lokasi", "ORDER BY nama_lokasi ASC");
		# ---------- /. data buat form isian -------------- #

		# ---------- /. data biblio -------------- #
		$arraywhere = array('perpus_biblio.id_biblio' => $id_biblio);
		$data['biblio'] = $this->perpus_models->getJoin4where("perpus_biblio.*, perpus_bahasa.*, perpus_kategori_buku.nama as nama_kategori_buku, perpus_tempat.*, perpus_penerbit.nama as nama_penerbit", "perpus_biblio", 
			"perpus_bahasa", "perpus_biblio.id_bahasa=perpus_bahasa.id_bahasa", 
			"perpus_kategori_buku", "perpus_biblio.id_kategori_buku=perpus_kategori_buku.id_kategori_buku", 
			"perpus_tempat", "perpus_biblio.id_tempat=perpus_tempat.id_tempat",
			"perpus_penerbit", "perpus_biblio.id_penerbit=perpus_penerbit.id_penerbit",
			$arraywhere, "perpus_biblio.id_biblio", "ASC");

		$arraywhere = array('perpus_biblio_pengarang.id_biblio' => $id_biblio);
		$data['biblio_pengarang'] = $this->perpus_models->getJoin2where("perpus_biblio_pengarang.*, perpus_penulis.nama, perpus_jenis_kepengarangan.*", "perpus_biblio_pengarang", "perpus_penulis", "perpus_biblio_pengarang.id_penulis=perpus_penulis.id_penulis", "perpus_jenis_kepengarangan", "perpus_biblio_pengarang.id_jenis_kepengarangan=perpus_jenis_kepengarangan.id_jenis_kepengarangan", $arraywhere, "perpus_biblio_pengarang.id_biblio", "ASC");

		# ----------------------------------------- #
		# --------- data bahan pustaka ------------ #
		
		$data['bahan_pustaka'] = $this->m_models->get_data("*", "perpus_bahan_pustaka", "WHERE id_bahan_pustaka='$id_bp' ");
		
		# ----------------------------------------- #

		# tampilkan data ke view
		$this->load->view('perpustakaan/edit_bahan_pustaka', $data); 

		$this->load->view('template/footer');

    }

    function simpan_bahan_pustaka(){
			# simpan data pengadaan
			$id_supplier = $this->input->post('supplier', TRUE);
			# jika supplier baru maka simpan dulu di tabel supplier kemudina ambil id nya
			$supplier_baru = strpos($id_supplier,"-");
			if ($supplier_baru == TRUE){
				$exp = explode("-", $id_supplier);
				$nama_supplier = $exp[1];

				$data_supplier = array('nama_supplier' => $nama_supplier);

				if ($this->m_models->save_data($data_supplier, "perpus_supplier") == TRUE) {
					$supplier = $this->m_models->get_data("id_supplier", "perpus_supplier", "WHERE nama_supplier='$nama_supplier'");
					$id_supplier = $supplier[0]->id_supplier;
				}else{
					$id_supplier = 0;
				}
			}

			$id_bahan_pustaka = $this->input->post('id_bahan_pustaka', TRUE);
			$id_biblio = $this->input->post('id_biblio', TRUE);
			$tanggal_penerimaan = date_db($this->input->post('tanggal_penerimaan', TRUE));
			$id_sumber = $this->input->post('sumber', TRUE);
			$id_jenis_pustaka = $this->input->post('jenis_pustaka', TRUE);
			$id_status_item = $this->input->post('status_kondisi', TRUE);
			$id_lokasi = $this->input->post('lokasi', TRUE);
			$harga = str_replace('.', '',$this->input->post('harga', TRUE));

			# cari id biblio terakhir
			if ($id_jenis_pustaka == '1') {
				$id_akhir = $this->m_models->get_data("kode_inv", "perpus_bahan_pustaka", "WHERE id_jenis_pustaka='$id_jenis_pustaka' ORDER BY id_bahan_pustaka DESC LIMIT 1 ");
				foreach ($id_akhir as $key) {
					$kode_inv_lama = $key->kode_inv;
				}

				if ($kode_inv_lama != NULL) {
					$no_urut = (int) $kode_inv_lama;
				}else{
					$no_urut = 0;
				}
			}elseif ($id_jenis_pustaka == '2') {
				$tahun_sekarang = date('Y');
				$id_akhir = $this->m_models->get_data("kode_inv", "perpus_bahan_pustaka", "WHERE id_jenis_pustaka='$id_jenis_pustaka' AND tanggal_penerimaan like '$tahun_sekarang%' ORDER BY id_bahan_pustaka DESC LIMIT 1 ");
				foreach ($id_akhir as $key) {
					$kode_inv_lama = $key->kode_inv;
				}

				if ($kode_inv_lama != NULL) {
					$kode_inv_lama = substr($kode_inv_lama, -3);
					$no_urut = (int) $kode_inv_lama;
				}else{
					$no_urut = 0;
				}
			}elseif ($id_jenis_pustaka == '3') {
				$id_akhir = $this->m_models->get_data("kode_inv", "perpus_bahan_pustaka", "WHERE id_jenis_pustaka='$id_jenis_pustaka' ORDER BY id_bahan_pustaka DESC LIMIT 1 ");
				foreach ($id_akhir as $key) {
					$kode_inv_lama = $key->kode_inv;
				}

				if ($kode_inv_lama != NULL) { 
					$kode_inv_lama = substr($kode_inv_lama, -3);
					$no_urut = (int) $kode_inv_lama;
				}else{
					$no_urut = 0;
				}
			}else{
				$id_akhir = $this->m_models->get_data("kode_inv", "perpus_bahan_pustaka", "WHERE id_jenis_pustaka='$id_jenis_pustaka' ORDER BY id_bahan_pustaka DESC LIMIT 1 ");
				foreach ($id_akhir as $key) {
					$kode_inv_lama = $key->kode_inv;
				}

				if ($kode_inv_lama != NULL) { 
					$kode_inv_lama = substr($kode_inv_lama, -3);
					$no_urut = (int) $kode_inv_lama;
				}else{
					$no_urut = 0;
				}				
			}
				
			$jenis_pustaka = $this->m_models->get_data("kode_jenis_pustaka", "perpus_jenis_pustaka", "WHERE id_jenis_pustaka='$id_jenis_pustaka' ");
			foreach ($jenis_pustaka as $key) {
				$kode_jenis_pustaka = $key->kode_jenis_pustaka;
			}

			$tahun_sekarang = date('Y');

			$jumlah = 1;		

			for ($i=0; $i < $jumlah; $i++) { 
				# buat kode inv baru terurut
				$no_urut++;

				if ($id_jenis_pustaka == '1') {
					$kode_inv_baru = sprintf("%06s", $no_urut);
				}elseif($id_jenis_pustaka == '3') {
					$kode_inv_baru = $kode_jenis_pustaka.sprintf("%03s", $no_urut);
				}else{
					$kode_inv_baru = $tahun_sekarang.'/'.$kode_jenis_pustaka.sprintf("%03s", $no_urut);
				}

				$data_bahan[$i]['id_bahan_pustaka'] = $id_bahan_pustaka;
				$data_bahan[$i]['id_biblio'] = $id_biblio;
				$data_bahan[$i]['id_jenis_pustaka'] = $id_jenis_pustaka;
				$data_bahan[$i]['tanggal_penerimaan'] = $tanggal_penerimaan;
				$data_bahan[$i]['id_supplier'] = $id_supplier;
				$data_bahan[$i]['id_sumber'] = $id_sumber;
				$data_bahan[$i]['id_lokasi'] = $id_lokasi;
				$data_bahan[$i]['harga'] = $harga;
				$data_bahan[$i]['id_status_item'] = $id_status_item;
				$data_bahan[$i]['nrp'] = $this->session->userdata['nrp'];
			}

			if ($jumlah > 0) {
				if ($this->m_models->update_batch($data_bahan, "perpus_bahan_pustaka", "id_bahan_pustaka") == TRUE ){ 
					$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
				}else{
					$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
				}
			}

		redirect('perpus/bahan_pustaka');     	
    }

	function get_anggota(){
		if (isset($_GET['term'])){ 
      		$q = strtolower($_GET['term']);
      		$datacari = $this->m_models->get_data("id_user, nama", "perpus_anggota", "WHERE (id_user like '%$q%' OR nama like '%$q%') AND status='Aktif' ORDER BY nama ASC ");

      		if (count($datacari > 0)) {
      			foreach ($datacari as $key) {
      				$row_set[] = $key->id_user.' '.$key->nama;
      			}
      			echo json_encode($row_set);
      		}
    	}
	}

	function get_anggota_sdm(){
		if (isset($_GET['term'])){ 
      		$q = strtolower($_GET['term']);
      		$datacari = $this->m_models->get_data("id_user, nama", "perpus_anggota", "WHERE (id_user like '%$q%' OR nama like '%$q%') AND status='Aktif' AND id_instansi='1' ORDER BY nama ASC ");

      		if (count($datacari > 0)) {
      			foreach ($datacari as $key) {
      				$row_set[] = $key->id_user.' '.$key->nama;
      			}
      			echo json_encode($row_set);
      		}
    	}
	}

	function getTahunAkademik($tanggal){
		# ambil data tahun akademik 
		$data = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE tanggal_mulai <= '$tanggal' AND tanggal_selesai >= '$tanggal'");
		$id_tahun = $data[0]->id_tahun;

		return $id_tahun;
	}

	public function get_bahan_pustaka_js(){

		$this->load->view('template/head');
		$kode_inv = $this->input->get('kode_inv'); 
		// echo $kode_inv;
		$exp = explode(" ", $kode_inv);
		$id_user = $exp[0];
		$data['id_user'] = $id_user;
		# cek maksimal pinjam dari tabel setting max_pinjam
		$max_pinjam = $this->m_models->get_data("nilai_setting", "perpus_setting", "WHERE nama_setting='max_pinjam' ");
		$maksimal_pinjam = $max_pinjam[0]->nilai_setting;
		
		# cek jumlah sudah dipinjam
		$sudah_pinjam = $this->m_models->getRows("perpus_pinjaman WHERE id_user='$id_user' AND status='0'");
		# sisa kuota masih bisa pinjam
		$kuota_pinjam = $maksimal_pinjam - $sudah_pinjam;

		$keranjang_tmp = array();
		$a = 0;
		for ($i=1; $i <count($exp) ; $i++) { 
			$kode_inv = trim($exp[$i]);
			# cek ada ga kode inv yang dicari
			$jml_buku = $this->m_models->getRows("perpus_bahan_pustaka WHERE kode_inv='$kode_inv' ");
			if ($jml_buku > 0) {
				# cek apakah bahan pustaka bisa dipinjam oleh anggota tersebut
				# aturannya ada di aturan peminjaman buku
				$arraywhere = array('perpus_bahan_pustaka.kode_inv' => $kode_inv);
				$buku = $this->perpus_models->getJoin2where("perpus_biblio.judul, perpus_biblio.id_kategori_buku, perpus_penerbit.nama as nama_penerbit, perpus_bahan_pustaka.kode_inv, perpus_bahan_pustaka.id_bahan_pustaka, perpus_bahan_pustaka.id_status_item", "perpus_biblio", 
					"perpus_penerbit", "perpus_penerbit.id_penerbit=perpus_biblio.id_penerbit",
					"perpus_bahan_pustaka", "perpus_bahan_pustaka.id_biblio=perpus_biblio.id_biblio",
					$arraywhere, "perpus_biblio.id_biblio", "ASC");
				# cari kategori bukunya apa Umum atau Referensi
				foreach ($buku as $key) { 
					$kategori_buku = $key->id_kategori_buku;
					$id_status_item = $key->id_status_item;
				}

				# cari jenis anggota yang pinjam apa, Santri, Mahasantri atau SDM
				$anggota = $this->m_models->get_data("perpus_instansi.id_jenis_anggota", "perpus_anggota", "JOIN perpus_instansi ON perpus_instansi.id_instansi=perpus_anggota.id_instansi WHERE perpus_anggota.id_user='$id_user' ");
				$jenis_anggota = $anggota[0]->id_jenis_anggota;

				# Cek anggota ini bisa pinjam buku ini ga, dengan data id_jenis anggota sama kategori buku
				$bisa_pinjam = $this->m_models->get_data("perpus_aturan_peminjaman.lama_maksimal", "perpus_aturan_peminjaman", "WHERE id_kategori_buku='$kategori_buku' AND id_jenis_anggota='$jenis_anggota' ");
				# jika di tabel aturan peminjaman ada berarti lanjut proses
				if (count($bisa_pinjam) > 0) {
					# cek di tabel pinjaman, apakah buku tersedia atau sedang dipinjam
					$pinjaman = $this->m_models->getRows("perpus_pinjaman WHERE kode_inv='$kode_inv' AND status='0'");
					# jika di tabel pinjaman ada berarti masih dipinjam
					if ($pinjaman > 0) {
						$this->session->set_flashdata('gagal', 'No. Inventaris <b>'. $kode_inv .'</b> tidak bisa dipinjam karena masih dalam proses peminjaman.');
					# jika tidak dipinam baru cek kondisi bahan pustaka, apakah Bagus, Rusak dsb
					}else{
						# ceks status item, apakah bisa dipinjam atau tidaks
						$status_item = $this->m_models->get_data("dipinjamkan, nama_status_item", "perpus_status_item", "WHERE id_status_item='$id_status_item' ");
						# jika status dipinjamakan TRUE / 1 maka cek barangkali sudah masuk keranjang
						if ($status_item[0]->dipinjamkan == '1') {
							# cek barangkali sudah masuk keranjang
							if (in_array($kode_inv, $keranjang_tmp)) {
								$this->session->set_userdata('gagal', 'Item dengan No. Inventaris <b>'. $kode_inv .'</b> ini sudah masuk dalam keranjang');
							}else{
								# cek kuota bisa pinjam
								# jika sudah pinjamnya masih kurang atau sama dengan maksimal yang bisa dipinjam
								if ($sudah_pinjam < $maksimal_pinjam) {
									# cari tanggal jatuh tempo dengan meliaht di aturan peminjaman
									date_default_timezone_set('Asia/Jakarta');
									$pinjam = date('Y-m-d');
									$lama_maksimal = (int) $bisa_pinjam[0]->lama_maksimal;
									$lama_pinjam = mktime(0,0,0,date("n"),date("j")+$lama_maksimal,date("Y"));
									$kembali = date("Y-m-d", $lama_pinjam);
							
									foreach ($buku as $key) { 
										$data_buku['id_bahan_pustaka'][$a] = $key->id_bahan_pustaka;
										$data_buku['kode_inv'][$a] = $key->kode_inv;
										$data_buku['judul'][$a] = $key->judul;
										$data_buku['tanggal_pinjam'][$a] = $pinjam;
										$data_buku['tanggal_jatuh_tempo'][$a] = $kembali;
										$data_buku['penerbit'][$a] = $key->nama_penerbit;
										$a++;
									}

									# buat variable kode_inv temporary buat cek input kode yang sama
									$keranjang_tmp[] = $kode_inv; 

									# hapus jika ana sesion notif
									if ($this->session->has_userdata('gagal')) { 
									        $this->session->unset_userdata('gagal');
									} 
									# data sudah pinjam ditambah hitungannya
									$sudah_pinjam++;
								}else{
									$this->session->set_userdata('gagal', 'Maaf, kuota pinjaman sudah maksimal.');
								}
							}

						}else{
							$this->session->set_userdata('gagal', 'Item ini tidak bisa dipinjam karena statusnya <b>'.$status_item[0]->nama_status_item .'</b>');
						}
					}
				# jika tidak bisa pinjam keluarkan notif
				}else{
					$this->session->set_userdata('gagal', 'Anggota ini tidak bisa meminjam Bahan Pustaka dengan No. Inventaris <b>'.$kode_inv .'</b>');
				}

			# jika kode inv tidak ditemukan
			}else{
				$this->session->set_userdata('gagal', 'No. Inventaris <b>'.$kode_inv.'</b> tidak ditemukan dalam database.');			
			}
		}
		

		$data['jumlah_data'] = $a;
		if ($a > 0) {
			$data['buku'] = $data_buku;
		}		

		$this->load->view('perpustakaan/keranjang_peminjaman', $data);

		$this->load->view('template/js');
	}

    function entri_peminjaman(){
		$this->load->view('template/header');
		$anggota = $this->input->post('id_anggota', TRUE); 
		$exp = explode(" ", $anggota);
		$id_anggota = $exp[0];

		if ($id_anggota == null) {
			# tampilkan data input anggota ke view
			$this->load->view('perpustakaan/f_anggota'); 
		}else{
			# cek data anggota ada engga
			$jml_anggota = $this->m_models->getRows("perpus_anggota WHERE id_user='$id_anggota' ");
			if ($jml_anggota > 0) {
				# cek status anggota
				$status_anggota =  $this->m_models->get_data("perpus_anggota.status, perpus_anggota.id_instansi", "perpus_anggota", "WHERE id_user='$id_anggota' ");
				# jika data ada dan status anggota masih aktif aktif
				if ($status_anggota[0]->status == 'Aktif') {	
					# -------------- profil anggota perpus ------------- #
					$id_instansi = $status_anggota[0]->id_instansi;
					# jika instansi anggota SDM
					if ($id_instansi == '1') {
						$arraywhere = array('perpus_anggota.id_user' => $id_anggota);
						$data['anggota'] = $this->m_models->getJoin2Awhere("perpus_anggota.nama, perpus_anggota.id_user, perpus_instansi.nama as nama_instansi, pegawai.jk, pegawai.nrp as nis, pegawai.foto, pegawai.id_sekolah, pegawai.id_jabatan", "perpus_anggota", 
							"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
							"pegawai", "perpus_anggota.id_user=pegawai.nrp", 
							$arraywhere, "perpus_anggota.id_user", "ASC");

						# cari jabatan dan sekolah
						$data['jabatan'] = $this->m_models->getDataByID("jabatan", 'id_jabatan', $data['anggota'][0]->id_jabatan);
						$data['sekolah'] = $this->m_models->getDataByID("sekolah", 'id_sekolah', $data['anggota'][0]->id_sekolah);
						$data['path_photo_server'] = 'img_pegawai/';

						$data['foto'] = all("user_finger_karyawan", "user_id", $data['anggota'][0]->id_user, "photo");
					# jika instansi anggota adalah Sekolah
					}else{
						# cari nama jenjang buat menentukan nama tabel atau romber
						$jenjang = db_siswa($id_anggota);

						$tabel_rombel = 'rombongan_belajar_'.$jenjang;
						$tabel_siswa = 'siswa_'.$jenjang;
						$tahun_akademik = $this->getTahunAkademik(date('Y-m-d'));
						$data['path_photo_server'] = 'img_siswa/'.$tabel_siswa.'/';

						$arrWhere=array('perpus_anggota.id_user' => $id_anggota);
						$data['anggota'] = $this->m_models->getJoin2Awhere($tabel_siswa.".nis,".$tabel_siswa.".id_sekolah,".$tabel_siswa.".jk, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", 
							$tabel_siswa, $tabel_siswa.".id_siswa=perpus_anggota.id_user", 
							"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
							$arrWhere, "id_user","asc");

						# ambil id_sekolah
						$id_sekolah = $data['anggota'][0]->id_sekolah;

						# cari kelas id_kelas
						$arrWhere=array($tabel_rombel.'.id_siswa ' => $id_anggota, $tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
						$data['kelas'] = $this->m_models->getJoin1where($tabel_rombel.".*, kelas.nama_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas", $arrWhere, "id_siswa","asc");

						$data['foto'] = all("user_finger_siswa", "user_id", $data['anggota'][0]->id_user, "photo");
					}


						#--------------- History Peminjaman ---------------#
						$histori_pinjam = $this->m_models->get_data("perpus_bahan_pustaka.kode_inv, perpus_bahan_pustaka.id_biblio, perpus_pinjaman.*", "perpus_pinjaman", "JOIN perpus_bahan_pustaka ON perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv WHERE perpus_pinjaman.id_user='$id_anggota' AND perpus_pinjaman.status='1' ORDER BY no_transaksi DESC LIMIT 10");
						$a = 0;
						foreach ($histori_pinjam as $key) { 
							# mencari judul 
							$judul = all("perpus_biblio", "id_biblio", $key->id_biblio, "judul");
							$klasifikasi = all("perpus_biblio", "id_biblio", $key->id_biblio, "klasifikasi");

							$histori['kode_inv'][$a] = $key->kode_inv;
							$histori['judul'][$a] = $judul;
							$histori['klasifikasi'][$a] = $klasifikasi;
							$histori['tanggal_pinjam'][$a] = $key->tanggal_pinjam;
							$histori['tanggal_pengembalian'][$a] = $key->tanggal_pengembalian;
							$a++;
						}	

						$data['jumlah_histori'] = $a;
						if ($a > 0) {
							$data['histori'] = $histori;
						}						
						
						#--------------- /.History Peminjaman ---------------#
						
						#--------------- Data Masih Pinjam -----------------#
						$arraywhere = array('perpus_pinjaman.id_user' => $id_anggota, 'perpus_pinjaman.status' => '0');
						$pinjam = $this->perpus_models->getJoin1where("perpus_bahan_pustaka.kode_inv, perpus_bahan_pustaka.id_biblio, perpus_pinjaman.*", "perpus_pinjaman", 
							"perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv",
							$arraywhere, "perpus_pinjaman.id_user", "ASC");
						$a = 0;
						foreach ($pinjam as $key) { 
							# mencari judul , pengarang, penerbit
							$judul = all("perpus_biblio", "id_biblio", $key->id_biblio, "judul");
							$penerbit = $this->get_penerbit($key->id_biblio, "id_biblio");
							$pengarang = $this->get_pengarang($key->id_biblio, "id_biblio");
							
							# mencari keterlambatan
							if ($key->tanggal_pengembalian == '0000-00-00') {
								$tanggal_pengembalian = date('Y-m-d');
							}else{
								$tanggal_pengembalian = $key->tanggal_pengembalian;
							}
							$pinjaman['no_transaksi'][$a] = $key->no_transaksi;
							$pinjaman['kode_inv'][$a] = $key->kode_inv;
							$pinjaman['judul'][$a] = $judul;
							$pinjaman['penerbit'][$a] = $penerbit;
							$pinjaman['pengarang'][$a] = $pengarang;
							$pinjaman['tanggal_pinjam'][$a] = $key->tanggal_pinjam;
							$pinjaman['tanggal_jatuh_tempo'][$a] = $key->tanggal_jatuh_tempo;
							$pinjaman['terlambat'][$a] = $this->get_terlambat($key->tanggal_jatuh_tempo, $tanggal_pengembalian);
							$a++;
						}	

						$data['jumlah_pinjam'] = $a;
						if ($a > 0) {
							$data['pinjam'] = $pinjaman;
						}					

						#--------------- /.Data Masih Pinjam ---------------#
				//	}


					# tampilkan data ke view
					$this->load->view('perpustakaan/entri_peminjaman', $data); 
				
				# jika status anggota tidak Aktif muncul notif gagal
				}else{
					$this->session->set_flashdata('gagal', 'Status anggota tidak aktif.');
					$data['id_anggota'] = $id_anggota;
					$this->load->view('perpustakaan/f_anggota', $data); 					
				}
			# jika id_user tidak ditemukan muncul notif gagal
			}else{
				$this->session->set_flashdata('gagal', 'Data Anggota tidak ditemukan, silahkan cek kembali data ID Anggota !!!');
				$data['id_anggota'] = $id_anggota;
				$this->load->view('perpustakaan/f_anggota', $data); 
			}
		}

		$this->load->view('template/footer');	    	
    }

    function simpan_peminjaman(){
		$simpan = false;
		$nrp = $this->session->userdata('nrp');
		# ambil data yang di post
		$kode_inv = $this->input->post('kode_inv');
		$jml_buku = count($this->input->post('kode_inv'));
		$tanggal_pinjam = $this->input->post('tanggal_pinjam');
		$tanggal_jatuh_tempo = $this->input->post('tanggal_jatuh_tempo');
		$id_user = $this->input->post('id_user');
		$id_kelas = $this->input->post('id_kelas');

		# cari no transaksi terakhir terakhir
		date_default_timezone_set('Asia/Jakarta');
		$tahun_bulan_sekarang = date('Y-m');
		$id_akhirnya = '';
		$no_urut = 0;
		$id_akhir = $this->m_models->get_data("MAX(no_transaksi) AS id", "perpus_pinjaman", "WHERE tanggal_pinjam like '$tahun_bulan_sekarang%' ");
		foreach ($id_akhir as $key) {
			$id_akhirnya = $id_akhir[0]->id;
		}
		if ($id_akhirnya != '') {
			$no_urut = (int) substr($id_akhirnya,8,4);
		}

		$kode_tanggal = date('Ymd');

		if ($jml_buku > 0) {
			for ($i = 0; $i < $jml_buku; $i++){ 
				# buat id baru terurut
				$no_urut++;
				$id_baru = $kode_tanggal.sprintf("%04s", $no_urut);

				$kode_inventaris = $kode_inv[$i];
				# masukan ke array buat di simpan sekaligus
				$data[$i]['id_pinjaman'] = '';
				$data[$i]['no_transaksi'] = $id_baru;
				$data[$i]['kode_inv'] = $kode_inventaris;
				$data[$i]['id_user'] = $id_user;
				$data[$i]['id_kelas'] = $id_kelas;
				$data[$i]['tanggal_pinjam'] = $tanggal_pinjam[$kode_inventaris];
				$data[$i]['tanggal_jatuh_tempo'] = $tanggal_jatuh_tempo[$kode_inventaris];
				$data[$i]['perpanjangan'] = '0';
				$data[$i]['dikembalikan'] = '0';
				$data[$i]['tanggal_pengembalian'] = '0000-00-00';
				$data[$i]['dihilangkan'] = '0';
				$data[$i]['tanggal_input'] = date('Y-m-d H:i:s');
				$data[$i]['tanggal_update'] = '0000-00-00';
				$data[$i]['nrp'] = $nrp;
			}

			# proses simpan ke tabel perpus_anggota
			$simpan = $this->m_models->save_batch($data, "perpus_pinjaman");
		}
			
		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/peminjaman');
    }

    #peminjaman
    function peminjaman(){
        $this->load->view('template/header');
        $kolom_cari = $this->input->post('kolom_cari', TRUE); 
        $text_cari = $this->input->post('text_cari', TRUE);

        $data['kolom_cari'] = $kolom_cari;
        $data['text_cari'] = $text_cari;

        $text_cari = str_replace(" ","#", $text_cari);

        # kirim link ajax list penulis 
        $data['url_ajax'] = 'perpus/ajax_list_peminjaman/'.$kolom_cari.'/'.$text_cari;

        # tampilkan data ke view
        $this->load->view('perpustakaan/peminjaman', $data); 

        $this->load->view('template/footer');  
    }

    public function ajax_list_peminjaman()
    {
         $table = 'perpus_pinjaman';
         $column_order = array(null,'no_transaksi' ,'kode_inv', null, 'id_user', 'perpus_anggota.nama', 'tanggal_pinjam', 'tanggal_jatuh_tempo', null); //set column field database for datatable orderable
         $order = array('no_transaksi' => 'desc'); // default order 
         $column_search_external = $this->uri->segment(3);
         if ($column_search_external != null) {
            $column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
         }else{
            $column_search = array('no_transaksi'); //set column field database for datatable searchable 
         }
         
         $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $pinjaman) {

        	# mencari judul koleksi
        	$id_biblio = all("perpus_bahan_pustaka", "kode_inv", $pinjaman->kode_inv, "id_biblio");
        	$judul = all("perpus_biblio", "id_biblio", $id_biblio, "judul");
        //	$judul = all("perpus_biblio", "id_biblio", $pinjaman->id_biblio, "judul");

        	# membuat tanggal kembali buat perhitungan keterlambatan
        	if ($pinjaman->dikembalikan == '1') {
        		$tanggal_pengembalian = $pinjaman->tanggal_pengembalian;
        	}else{
        		# kalo belum dikembalikan isi dengan tanggal sekarang
        		date_default_timezone_set('Asia/Jakarta');
        		$tanggal_pengembalian = date('Y-m-d');
        	}
            
            $no++;
            $row = array();
            $row[] = number_format($no);
            $row[] = $pinjaman->no_transaksi;
            $row[] = $pinjaman->kode_inv;
            $row[] = $judul;
            $row[] = $pinjaman->id_user;
            $row[] = $pinjaman->nama;
            $row[] = shortdate_indo2($pinjaman->tanggal_pinjam);
            $row[] = shortdate_indo2($pinjaman->tanggal_jatuh_tempo);
            $row[] = $this->get_terlambat($pinjaman->tanggal_jatuh_tempo, $tanggal_pengembalian);
            $row[] = '<a href="#" class="hapus-record" data-id="'.$pinjaman->id_pinjaman.'"><button type="button" class="btn btn-danger" ><i class="fa fa-trash-o"></i></button></a>';

            $data[] = $row;
    
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function f_hapus_peminjaman(){ 
		$this->load->view('template/head');
		$id_pinjaman = $this->input->post('id', TRUE);

		$data['pinjaman'] = $this->m_models->get_data("*", "perpus_pinjaman", "WHERE id_pinjaman='$id_pinjaman' ");

		$this->load->view('perpustakaan/f_hapus_peminjaman', $data); 
		$this->load->view('template/js');
	}

	function hapus_peminjaman(){
		$id_pinjaman = $this->input->post('id_pinjaman', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_pinjaman, 'id_pinjaman', 'perpus_pinjaman') == TRUE) {
			$this->m_models->delete_data($id_pinjaman, 'id_pinjaman', 'perpus_pelanggaran');
			$this->m_models->delete_data($id_pinjaman, 'id_pinjaman', 'perpus_perpanjangan');
			$this->m_models->delete_data($id_pinjaman, 'id_pinjaman', 'perpus_pengembalian');

			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/peminjaman');
	}


    function entri_perpanjangan(){
		$this->load->view('template/header');

		# tampilkan data ke view
		$this->load->view('perpustakaan/entri_perpanjangan');

		$this->load->view('template/footer');	
    }

    function get_perpanjangan_js(){
    	$this->load->helper('absen');
		$this->load->view('template/head');
		$kode_inv = $this->input->get('kode_inv'); 
		// echo $kode_inv;
		$exp = explode(" ", $kode_inv);

		$keranjang_tmp = array();
		$id_anggota = '';
		$a = 0;
		for ($i=0; $i <count($exp) ; $i++) { 
			$kode_inv = trim($exp[$i]);
			# cek ada ga kode inv yang dicari
			$jml_buku = $this->m_models->getRows("perpus_bahan_pustaka WHERE kode_inv='$kode_inv' ");
			if ($jml_buku > 0) {
				# cek tabel peminjaman apakah status masih proses atau sudah selesai
				$peminjaman = $this->m_models->getRows("perpus_pinjaman WHERE kode_inv='$kode_inv' AND status='0' ");
				if ($peminjaman > 0) {
					# cek barangkali sudah masuk keranjang
					if (in_array($kode_inv, $keranjang_tmp)) {
						$this->session->set_userdata('gagal', 'Item dengan No. Inventaris <b>'. $kode_inv .'</b> ini sudah masuk di daftar perpanjangan');
					}else{
						# jika ada dalam data pinjaman
						$arraywhere = array('perpus_bahan_pustaka.kode_inv' => $kode_inv, 'perpus_pinjaman.status' => '0');
						$buku = $this->perpus_models->getJoin1where("perpus_bahan_pustaka.id_biblio, perpus_pinjaman.*", "perpus_pinjaman", "perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv",
							$arraywhere, "perpus_pinjaman.id_pinjaman", "ASC");
						foreach ($buku as $key) {
							if ($id_anggota == '' OR $id_anggota == $key->id_user) {

								# mencari judul , penerbit
								$judul = all("perpus_biblio", "id_biblio", $key->id_biblio, "judul");
								$penerbit = $this->get_penerbit($key->id_biblio, "id_biblio");

								/* ---- menentukan lama pinjam buku ------ */
								# cari tanggal jatuh tempo dengan meliaht di aturan peminjaman
								date_default_timezone_set('Asia/Jakarta');
								// perpanjangan di tabelnya dimasukin ke tanggal pengembalian
								$tanggal_perpanjangan = date('Y-m-d');
								# Cek aturan peminjaman
								# sebelumnya cari jenis anggota yang pinjam apa, Santri, Mahasantri atau SDM
								$anggota = $this->m_models->get_data("perpus_instansi.id_jenis_anggota", "perpus_anggota", "JOIN perpus_instansi ON perpus_instansi.id_instansi=perpus_anggota.id_instansi WHERE perpus_anggota.id_user='$key->id_user' ");
								$jenis_anggota = $anggota[0]->id_jenis_anggota;
								# cek jenis buku nya apa
								$kategori_buku = all("perpus_biblio", "id_biblio", $key->id_biblio, "id_kategori_buku");
								# baru cek aturan peminjaman
								$bisa_pinjam = $this->m_models->get_data("perpus_aturan_peminjaman.lama_maksimal, perpus_aturan_peminjaman.denda_keterlambatan", "perpus_aturan_peminjaman", "WHERE id_kategori_buku='$kategori_buku' AND id_jenis_anggota='$jenis_anggota' ");

								$lama_maksimal = (int) $bisa_pinjam[0]->lama_maksimal;
								$lama_pinjam = mktime(0,0,0,date("n"),date("j")+$lama_maksimal,date("Y"));
								$kembali = date("Y-m-d", $lama_pinjam);

								/*----- /.menentukan lama pinjam buku ------ */

								/*----- mencari perpanjangan ke ------ */
								$perpanjangan = $key->perpanjangan + 1;
								/*------------------------------------ */

								/*----- mencari sudah jatuh tempo atau tidak ------ */
								# kalo udah lewat jatuh tempo / telat beri warna bg barisnya
								$jt = preg_replace('/\D/', '', $key->tanggal_jatuh_tempo);
								$pj = preg_replace('/\D/', '', $tanggal_perpanjangan);
								if ($pj > $jt) {
									$bg_baris = 'bg-gray';
									$denda_per_hari = $bisa_pinjam[0]->denda_keterlambatan;
								//	$telat = $pj - $jt;
									$jumlah_hari_minggu = $this->hitung_hari_minggu($key->tanggal_jatuh_tempo, $tanggal_pengembalian);
									$telat = get_selisih_hari($key->tanggal_jatuh_tempo, $tanggal_pengembalian) - $jumlah_hari_minggu;
									$total_denda = $denda_per_hari * $telat;
								}else{
									$bg_baris = '';
									$total_denda = 0;
								}
								/*------------------------------------ */

								/* ----- data untuk post tabel perpanjangan --- */
								$data_buku['id_pinjaman'][$a] = $key->id_pinjaman;
								$data_buku['no_transaksi'][$a] = $key->no_transaksi;
								$data_buku['kode_inv'][$a] = $key->kode_inv;
								$data_buku['judul'][$a] = $judul;
								$data_buku['penerbit'][$a] = $penerbit;
								$data_buku['tanggal_perpanjangan'][$a] = $tanggal_perpanjangan;
								$data_buku['tanggal_jatuh_tempo'][$a] = $kembali;
								$data_buku['perpanjangan'][$a] = $perpanjangan;
								$data_buku['bg_jatuh_tempo'][$a] = $bg_baris;
								$data_buku['denda'][$a] = $total_denda;
								$data_buku['tanggal_jatuh_tempo_sebelum'][$a] = $key->tanggal_jatuh_tempo;
								$data_buku['tanggal_pengembalian_sebelum'][$a] = $key->tanggal_pengembalian;
								$a++;

								/* ----- /.data untuk post tabel perpanjangan --- */


								/* ------- Profil peminjam ------ */
								# cari nama jenjang buat menentukan nama tabel atau romber
								/*
								$id_anggota = $key->id_user;
								$jenjang = db_siswa($id_anggota);

								$tabel_rombel = 'rombongan_belajar_'.$jenjang;
								$tabel_siswa = 'siswa_'.$jenjang;
								$tahun_akademik = $this->getTahunAkademik(date('Y-m-d'));

								$arrWhere=array('perpus_anggota.id_user' => $id_anggota);
								$data['anggota'] = $this->m_models->getJoin2Awhere($tabel_siswa.".nis,".$tabel_siswa.".id_sekolah,".$tabel_siswa.".jk, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", 
									$tabel_siswa, $tabel_siswa.".id_siswa=perpus_anggota.id_user", 
									"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
									$arrWhere, "id_user","asc");

								# ambil id_sekolah
								$id_sekolah = $data['anggota'][0]->id_sekolah;

								# cari kelas id_kelas
								$arrWhere=array($tabel_rombel.'.id_siswa ' => $id_anggota, $tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
								$data['kelas'] = $this->m_models->getJoin1where($tabel_rombel.".*, kelas.nama_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas", $arrWhere, "id_siswa","asc");
								*/
							
								$id_anggota = $key->id_user;
								$instansi = $this->m_models->get_data("perpus_instansi.nama", "perpus_anggota JOIN perpus_instansi ON perpus_anggota.id_instansi=perpus_instansi.id_instansi", "WHERE id_user='$id_anggota' ");
								if ( $instansi[0]->nama == 'SDM' ) {
									$arraywhere = array('perpus_anggota.id_user' => $id_anggota);
									$data['anggota'] = $this->m_models->getJoin2Awhere("perpus_anggota.nama, perpus_anggota.id_user, perpus_instansi.nama as nama_instansi, pegawai.jk, pegawai.nrp as nis, pegawai.foto, pegawai.id_sekolah, pegawai.id_jabatan", "perpus_anggota", 
										"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
										"pegawai", "perpus_anggota.id_user=pegawai.nrp", 
										$arraywhere, "perpus_anggota.id_user", "ASC");

									# cari jabatan dan sekolah
									$data['jabatan'] = $this->m_models->getDataByID("jabatan", 'id_jabatan', $data['anggota'][0]->id_jabatan);
									$data['sekolah'] = $this->m_models->getDataByID("sekolah", 'id_sekolah', $key->id_kelas);
									$data['path_photo_server'] = 'img_pegawai/';
								}else{
					
									$jenjang = db_siswa($id_anggota);

									$tabel_rombel = 'rombongan_belajar_'.$jenjang;
									$tabel_siswa = 'siswa_'.$jenjang;
									$tahun_akademik = $this->getTahunAkademik(date('Y-m-d'));
									$data['path_photo_server'] = 'img_siswa/'.$tabel_siswa.'/';

									$arrWhere=array('perpus_anggota.id_user' => $id_anggota);
									$data['anggota'] = $this->m_models->getJoin2Awhere($tabel_siswa.".nis,".$tabel_siswa.".id_sekolah,".$tabel_siswa.".jk, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", 
										$tabel_siswa, $tabel_siswa.".id_siswa=perpus_anggota.id_user", 
										"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
										$arrWhere, "id_user","asc");

									# cari kelas id_kelas
									$data['kelas'] = $this->m_models->getDataByID("kelas", 'id_kelas', $key->id_kelas);
								}
								/* ------- /. profil peminjam  ----- */

								#--------------- History Peminjaman ---------------#
								$histori_pinjam = $this->m_models->get_data("perpus_bahan_pustaka.kode_inv, perpus_bahan_pustaka.id_biblio, perpus_pinjaman.*", "perpus_pinjaman", "JOIN perpus_bahan_pustaka ON perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv WHERE perpus_pinjaman.id_user='$id_anggota' AND perpus_pinjaman.status='1' ORDER BY no_transaksi DESC LIMIT 10");
								$e = 0;
								foreach ($histori_pinjam as $key) { 
									# mencari judul 
									$judul = all("perpus_biblio", "id_biblio", $key->id_biblio, "judul");
									$klasifikasi = all("perpus_biblio", "id_biblio", $key->id_biblio, "klasifikasi");

									$histori['kode_inv'][$e] = $key->kode_inv;
									$histori['judul'][$e] = $judul;
									$histori['klasifikasi'][$e] = $klasifikasi;
									$histori['tanggal_pinjam'][$e] = $key->tanggal_pinjam;
									$histori['tanggal_pengembalian'][$e] = $key->tanggal_pengembalian;
									$e++;
								}	

								$data['jumlah_histori'] = $e;
								if ($e > 0) {
									$data['histori'] = $histori;
								}						
								
								#--------------- /.History Peminjaman ---------------#

								# buat variable kode_inv temporary buat cek input kode yang sama
								$keranjang_tmp[] = $kode_inv; 

								# hapus jika ana sesion notif
								if ($this->session->has_userdata('gagal')) { 
								        $this->session->unset_userdata('gagal');
								}
							}else{
								$this->session->set_userdata('gagal', 'Item dengan No. Inventaris <b>'. $kode_inv .'</b> beda peminjam.');
							}
						}
					}

				}else{
					$this->session->set_userdata('gagal', 'No. Inventaris <b>'.$kode_inv.'</b> tidak ada dalam daftar pinjaman.');	
				}

			# jika kode inv tidak ditemukan
			}else{
				$this->session->set_userdata('gagal', 'No. Inventaris <b>'.$kode_inv.'</b> tidak ditemukan dalam database.');			
			}
		}
		
		$data['jumlah_data'] = $a;
		if ($a > 0) {
			$data['buku'] = $data_buku;
			$this->load->view('perpustakaan/keranjang_perpanjangan', $data);
		}else{
			$this->load->view('perpustakaan/notif_perpanjangan');
		}		

		$this->load->view('template/js');    	
    }

    function simpan_perpanjangan(){
		$simpan = false;
		$nrp = $this->session->userdata('nrp');
		# ambil data yang di post
		$id_pinjaman = $this->input->post('id_pinjaman');
		$jml_buku = count($this->input->post('id_pinjaman'));
		$tanggal_pengembalian = $this->input->post('tanggal_perpanjangan');
		$tanggal_jatuh_tempo = $this->input->post('tanggal_jatuh_tempo');
		$perpanjangan = $this->input->post('perpanjangan');
		$denda = $this->input->post('denda');
		$tanggal_pengembalian_sebelum = $this->input->post('tanggal_pengembalian_sebelum');
		$tanggal_jatuh_tempo_sebelum = $this->input->post('tanggal_jatuh_tempo_sebelum');
		$id_user = $this->input->post('id_user');


		if ($jml_buku > 0) {
			$a = 0;
			for ($i = 0; $i < $jml_buku; $i++){ 
				$id = $id_pinjaman[$i];
				# array buat simpan di update tabel peminjaman
				$data[$i]['id_pinjaman'] = $id;
				$data[$i]['tanggal_pengembalian'] = $tanggal_pengembalian[$id];
				$data[$i]['tanggal_jatuh_tempo'] = $tanggal_jatuh_tempo[$id];
				$data[$i]['perpanjangan'] = $perpanjangan[$id];
				$data[$i]['tanggal_update'] = date('Y-m-d H:i:s');

				# array buat simpan di tabel perpanjangan
				date_default_timezone_set('Asia/Jakarta');
				$kode_waktu = date('Ymdhis');
				$id_perpanjangan = $kode_waktu.$i;
				$data_perpanjangan[$i]['id_perpanjangan'] = $id_perpanjangan;
				$data_perpanjangan[$i]['id_pinjaman'] = $id;
				$data_perpanjangan[$i]['perpanjangan'] = $perpanjangan[$id];
				$data_perpanjangan[$i]['tanggal_perpanjangan'] = $tanggal_pengembalian[$id];
				$data_perpanjangan[$i]['tanggal_jatuh_tempo_perpanjangan'] = $tanggal_jatuh_tempo[$id];		
				$data_perpanjangan[$i]['tanggal_jatuh_tempo_sebelum'] = $tanggal_jatuh_tempo_sebelum[$id];
				$data_perpanjangan[$i]['tanggal_pengembalian_sebelum'] = $tanggal_pengembalian_sebelum[$id];
				$data_perpanjangan[$i]['nrp'] = $nrp;

				# array buata simpan ke tabel pelanggaran jika ada denda
				if ($denda[$id] != 0) {
					$data_pelanggaran[$a]['id_pelanggaran'] = '';
					$data_pelanggaran[$a]['id_pinjaman'] = $id;
					$data_pelanggaran[$a]['jenis_pelanggaran'] = 'Telat';
					$data_pelanggaran[$a]['id_aturan_kehilangan'] = '1';
					$data_pelanggaran[$a]['id_perpanjangan'] = $id_perpanjangan;
					$data_pelanggaran[$a]['id_pengembalian'] = '0';
					$data_pelanggaran[$a]['jumlah_denda'] = $denda[$id];
					$data_pelanggaran[$a]['jumlah_bayar'] = 0;
					$data_pelanggaran[$a]['jumlah_diskon'] = 0;
					$data_pelanggaran[$a]['keterangan'] = '';
					$data_pelanggaran[$a]['nrp'] = $nrp;
					$data_pelanggaran[$a]['status'] = '0';
					$a++;
				}

			}

			# proses simpan ke tabel perpus_anggota
			$simpan = $this->m_models->update_batch($data, "perpus_pinjaman", "id_pinjaman");

			# proses simpan ke tabel perpus_perpanjangan
			$simpan = $this->m_models->save_batch($data_perpanjangan, "perpus_perpanjangan");

			# proses simpan ke tabel perpus_pelanggaran
			if ($a > 0) {
				$simpan = $this->m_models->save_batch($data_pelanggaran, "perpus_pelanggaran");
			}
			
		}
			
		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		# jika ada pelanggaran langsung buka pembayaran denda
		if ($a != 0) {
			redirect('perpus/pembayaran_denda/'.$id_user);
		}else{
			redirect('perpus/perpanjangan');
		}

    }

    #perpanjangan
    function perpanjangan(){
        $this->load->view('template/header');
        $kolom_cari = $this->input->post('kolom_cari', TRUE); 
        $text_cari = $this->input->post('text_cari', TRUE);

        $data['kolom_cari'] = $kolom_cari;
        $data['text_cari'] = $text_cari;

        $text_cari = str_replace(" ","#", $text_cari);

        # kirim link ajax list penulis 
        $data['url_ajax'] = 'perpus/ajax_list_perpanjangan/'.$kolom_cari.'/'.$text_cari;

        # tampilkan data ke view
        $this->load->view('perpustakaan/perpanjangan', $data); 

        $this->load->view('template/footer');  
    }

    public function ajax_list_perpanjangan()
    {
         $table = 'perpus_perpanjangan';
         $column_order = array(null,'no_transaksi' ,'kode_inv','', 'id_user', 'perpus_anggota.nama', 'perpus_perpanjangan.tanggal_perpanjangan', 'perpus_perpanjangan.tanggal_jatuh_tempo_perpanjangan', 'perpus_perpanjangan.perpanjangan'); //set column field database for datatable orderable
         $order = array('perpus_perpanjangan.tanggal_perpanjangan' => 'desc'); // default order 
         $column_search_external = $this->uri->segment(3);
         if ($column_search_external != null) {
            $column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
         }else{
            $column_search = array('no_transaksi'); //set column field database for datatable searchable 
         }
         
         $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $pinjaman) {

        	# mencari judul koleksi
        	$id_biblio = all("perpus_bahan_pustaka", "kode_inv", $pinjaman->kode_inv, "id_biblio");
        	$judul = all("perpus_biblio", "id_biblio", $id_biblio, "judul");
        	//$judul = all("perpus_biblio", "id_biblio", $pinjaman->id_biblio, "judul");
            
            $no++;
            $row = array();
            $row[] = number_format($no);
            $row[] = $pinjaman->no_transaksi;
            $row[] = $pinjaman->kode_inv;
            $row[] = $judul;
            $row[] = $pinjaman->id_user;
            $row[] = $pinjaman->nama;
            $row[] = shortdate_indo2($pinjaman->tanggal_perpanjangan);
            $row[] = shortdate_indo2($pinjaman->tanggal_jatuh_tempo_perpanjangan);
        //    $row[] = $pinjaman->perpanjangan_ke;
            $row[] = $this->get_terlambat($pinjaman->tanggal_jatuh_tempo_perpanjangan, $pinjaman->tanggal_perpanjangan);
            $row[] = '<a href="#" class="hapus-record" data-id="'.$pinjaman->id_perpanjangan.'"><button type="button" class="btn btn-danger" ><i class="fa fa-trash-o"></i></button></a>';

            $data[] = $row;
    
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function f_hapus_perpanjangan(){ 
		$this->load->view('template/head');
		$id_perpanjangan = $this->input->post('id', TRUE);

		$data['pinjaman'] = $this->m_models->get_data("perpus_pinjaman.id_pinjaman, perpus_pinjaman.no_transaksi, perpus_pinjaman.kode_inv, perpus_perpanjangan.*", "perpus_perpanjangan", "JOIN perpus_pinjaman ON perpus_perpanjangan.id_pinjaman=perpus_pinjaman.id_pinjaman WHERE id_perpanjangan='$id_perpanjangan' ");

		$this->load->view('perpustakaan/f_hapus_perpanjangan', $data); 
		$this->load->view('template/js');
	}

	function hapus_perpanjangan(){
		$id_pinjaman = $this->input->post('id_pinjaman', TRUE);
		$id_perpanjangan = $this->input->post('id_perpanjangan', TRUE);
		$tanggal_jatuh_tempo_sebelum = $this->input->post('tanggal_jatuh_tempo_sebelum', TRUE);
		$tanggal_pengembalian_sebelum = $this->input->post('tanggal_pengembalian_sebelum', TRUE);
		$perpanjangan = $this->input->post('perpanjangan', TRUE);

		# proses hapus
		# hapus ditabel perpanjangan
		if ($this->m_models->delete_data($id_perpanjangan, 'id_perpanjangan', 'perpus_perpanjangan') == TRUE) {
			# hapus di tabel pelanggaran kalo ada
			$pelanggaran = $this->m_models->getRows("perpus_pelanggaran WHERE id_perpanjangan='$id_perpanjangan' ");
			if ($pelanggaran > 0) {
				$this->m_models->delete_data($id_perpanjangan, 'id_perpanjangan', 'perpus_pelanggaran');
			} 
			# proses update tabel pinjaman
			date_default_timezone_set('Asia/Jakarta');
			$tanggal_update = date('Y-m-d H:i:s');

			# set perpanjangan sebelumnya
			$perpanjangan_sebelum = $perpanjangan - 1;


	 		$data = array (
			    'tanggal_pengembalian' => $tanggal_pengembalian_sebelum,
			    'tanggal_jatuh_tempo' => $tanggal_jatuh_tempo_sebelum,
			    'perpanjangan' => $perpanjangan_sebelum,
			    'tanggal_update' => $tanggal_update
			);
			
			$this->m_models->update_data($id_pinjaman, 'id_pinjaman', $data, "perpus_pinjaman");

			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/perpanjangan');
	}

    function denda(){
		$this->load->view('template/header');

		# tampilkan data ke view
		$this->load->view('perpustakaan/denda');

		$this->load->view('template/footer');	   	
    }

    function entri_denda(){
		$this->load->view('template/header');
		$anggota = $this->input->post('id_anggota', TRUE); 
		$exp = explode(" ", $anggota);
		$id_anggota = $exp[0];

		if ($id_anggota == null) {
			# tampilkan data input anggota ke view
			$this->load->view('perpustakaan/f_anggota_denda'); 
		}else{
			# cek data anggota ada engga
			$jml_anggota = $this->m_models->getRows("perpus_anggota WHERE id_user='$id_anggota' ");
			if ($jml_anggota > 0) {
				# cek status anggota
				$status_anggota =  $this->m_models->get_data("perpus_anggota.status, perpus_anggota.id_instansi", "perpus_anggota", "WHERE id_user='$id_anggota' ");
				# jika data ada dan status anggota masih aktif aktif
				if ($status_anggota[0]->status == 'Aktif') {	
					# cek data denda
					$arraywhere = array('perpus_pinjaman.id_user' => $id_anggota, 'perpus_pelanggaran.status' => '0', 'perpus_pelanggaran.jenis_pelanggaran' => 'Telat');
					$pelanggaran = $this->perpus_models->getJoin2where("perpus_bahan_pustaka.id_biblio, perpus_pelanggaran.*, perpus_pinjaman.*", "perpus_pinjaman", 
					"perpus_pelanggaran", "perpus_pelanggaran.id_pinjaman=perpus_pinjaman.id_pinjaman",
					"perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv",
					$arraywhere, "perpus_pinjaman.id_pinjaman", "ASC");

					$jumlah_pelanggaran = count($pelanggaran);
					if ($jumlah_pelanggaran > 0) {
						# tampilkan data ke view
						redirect('perpus/pembayaran_denda/'.$id_anggota);
					}else{
						$this->session->set_flashdata('gagal', 'Anggota dengan ID <b>'.$id_anggota.'</b> tidak memiliki denda yang harus dibayar.');
						$data['id_anggota'] = $id_anggota;
						$this->load->view('perpustakaan/f_anggota_denda', $data);
					}

				# jika status anggota tidak Aktif muncul notif gagal
				}else{
					$this->session->set_flashdata('gagal', 'Status anggota dengan ID <b>'.$id_anggota.'</b> tidak aktif.');
					$data['id_anggota'] = $id_anggota;
					$this->load->view('perpustakaan/f_anggota_denda', $data); 					
				}
			# jika id_user tidak ditemukan muncul notif gagal
			}else{
				$this->session->set_flashdata('gagal', 'Data Anggota dengan ID <b>'.$id_anggota.'</b> tidak ditemukan, silahkan cek kembali data ID Anggota !!!');
				$data['id_anggota'] = $id_anggota;
				$this->load->view('perpustakaan/f_anggota_denda', $data); 
			}
		}

		$this->load->view('template/footer'); 	
    }

    function pembayaran_denda($id_user){
		$this->load->view('template/header');


		/* ------- Profil peminjam ------ */
		# cari nama jenjang buat menentukan nama tabel atau romber
		$id_anggota = $id_user;
		$jenjang = db_siswa($id_anggota);

		$tabel_rombel = 'rombongan_belajar_'.$jenjang;
		$tabel_siswa = 'siswa_'.$jenjang;
		$tahun_akademik = $this->getTahunAkademik(date('Y-m-d'));

		$arrWhere=array('perpus_anggota.id_user' => $id_anggota);
		$data['anggota'] = $this->m_models->getJoin2Awhere($tabel_siswa.".nis,".$tabel_siswa.".id_sekolah,".$tabel_siswa.".jk, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", 
			$tabel_siswa, $tabel_siswa.".id_siswa=perpus_anggota.id_user", 
			"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
			$arrWhere, "id_user","asc");

		# ambil id_sekolah
		$id_sekolah = $data['anggota'][0]->id_sekolah;

		# cari kelas id_kelas
		$arrWhere=array($tabel_rombel.'.id_siswa ' => $id_anggota, $tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
		$data['kelas'] = $this->m_models->getJoin1where($tabel_rombel.".*, kelas.nama_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas", $arrWhere, "id_siswa","asc");
		/* ------- /. profil peminjam  ----- */

		#--------------- History Peminjaman ---------------#
		$histori_pinjam = $this->m_models->get_data("perpus_bahan_pustaka.kode_inv, perpus_bahan_pustaka.id_biblio, perpus_pinjaman.*", "perpus_pinjaman", "JOIN perpus_bahan_pustaka ON perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv WHERE perpus_pinjaman.id_user='$id_anggota' AND perpus_pinjaman.status='1' ORDER BY no_transaksi DESC LIMIT 10");
		$e = 0;
		foreach ($histori_pinjam as $key) { 
			# mencari judul 
			$judul = all("perpus_biblio", "id_biblio", $key->id_biblio, "judul");
			$klasifikasi = all("perpus_biblio", "id_biblio", $key->id_biblio, "klasifikasi");

			$histori['kode_inv'][$e] = $key->kode_inv;
			$histori['judul'][$e] = $judul;
			$histori['klasifikasi'][$e] = $klasifikasi;
			$histori['tanggal_pinjam'][$e] = $key->tanggal_pinjam;
			$histori['tanggal_pengembalian'][$e] = $key->tanggal_pengembalian;
			$e++;
		}	

		$data['jumlah_histori'] = $e;
		if ($e > 0) {
			$data['histori'] = $histori;
		}						
								
		#--------------- /.History Peminjaman ---------------#
								
		# -------------- data pelanggaran ------------------ #
		# jika ada dalam data pinjaman
		$arraywhere = array('perpus_pinjaman.id_user' => $id_anggota, 'perpus_pelanggaran.status' => '0', 'perpus_pelanggaran.jenis_pelanggaran' => 'Telat');
		$buku = $this->perpus_models->getJoin2where("perpus_bahan_pustaka.id_biblio, perpus_pelanggaran.*, perpus_pinjaman.*", "perpus_pinjaman", 
			"perpus_pelanggaran", "perpus_pelanggaran.id_pinjaman=perpus_pinjaman.id_pinjaman",
			"perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv",
			$arraywhere, "perpus_pinjaman.id_pinjaman", "ASC");
		$a = 0;
		foreach ($buku as $key) {
			# cari data judul
			$judul = all("perpus_biblio", "id_biblio", $key->id_biblio, "judul");

			$data_buku['id_pelanggaran'][$a] = $key->id_pelanggaran;
			$data_buku['kode_inv'][$a] = $key->kode_inv;
			$data_buku['judul'][$a] = $judul;
			$data_buku['jumlah_denda'][$a] = $key->jumlah_denda;
			$a++;			
		}

		$data['jumlah_data'] = $a;
		if ($a > 0) {
			$data['buku'] = $data_buku;
		}

		# -------------- /. data pelanggaran --------------- #

		# tampilkan data ke view
		$this->load->view('perpustakaan/pembayaran_denda', $data);

		$this->load->view('template/footer');	    	
    }

    function simpan_pembayaran_denda(){
    	$nrp = $this->session->userdata('nrp');
		$simpan = false;
		# ambil data yang di post
		$id_pelanggaran = $this->input->post('id_pelanggaran');
		$jml_buku = count($this->input->post('id_pelanggaran'));
		$jumlah_bayar = $this->input->post('jumlah_bayar');
		$jumlah_denda = $this->input->post('jumlah_denda');

		if ($jml_buku > 0) {
			for ($i = 0; $i < $jml_buku; $i++){ 
				$id = $id_pelanggaran[$i];
				$potongan = $jumlah_denda[$id] - $jumlah_bayar[$id];
				# array buat simpan di update tabel peminjaman
				$data[$i]['id_pelanggaran'] = $id;
				$data[$i]['jumlah_bayar'] = $jumlah_bayar[$id];
				$data[$i]['jumlah_diskon'] = $potongan;
				$data[$i]['nrp'] = $nrp;
				$data[$i]['status'] = '1';

				# input ke tabel jurnal
				# ---------------------
				$pinjaman = $this->m_models->get_data("perpus_pinjaman.no_transaksi, perpus_pelanggaran.id_pinjaman", "perpus_pelanggaran", "JOIN perpus_pinjaman ON perpus_pelanggaran.id_pinjaman=perpus_pinjaman.id_pinjaman WHERE id_pelanggaran='$id' ");
				$no_transaksi = $pinjaman[0]->no_transaksi;
				//$id_pinjaman = $pinjaman[0]->id_pinjaman;
				$tahun = $this->m_models->getwhere("id_tahun", "tahun_akademik", "status_berjalan", 'ON', "tahun1", "asc");
				$id_sekolah = '';
				$pegawai = $this->m_models->get_data("id_sekolah", "pegawai", "WHERE nrp='$nrp' ");
				foreach ($pegawai as $key) {
					$id_sekolah = $key->id_sekolah;
				}
			
			//	$pelanggaran = $this->m_models->get_data("id_pengembalian", "perpus_pelanggaran", "WHERE id_pelanggaran='$id' ");
			//	$asal = 'id_pengembalian_'.$pelanggaran[0]->id_pengembalian;
				$asal = 'id_pelanggaran_'.$id;

				$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 	
				$tanggal = date("Y-m-d");
				$uraian = 'Denda peminjaman nomor '.$no_transaksi;
				$nominal = $jumlah_bayar[$id];
				$data_jurnal = array('tgl' => $tanggal, 'no_transaksi' => $no_transaksi, 'akun1' => '4.1.1.02', 'uraian1' => $uraian, 'debet1' => '0', 'kredit1' => $nominal, 'akun2' => '1.1.1.27', 'uraian2' => $uraian, 'debet2' => $nominal, 'kredit2' => '0', 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => $asal, 'keterangan' => '', 'id_tahun'=> $tahun[0]->id_tahun, 'nrp'=> $nrp);
				$this->m_models->save_data($data_jurnal, "jurnal");
				# ----------------------
			}

			# proses simpan ke tabel perpus_anggota
			$simpan = $this->m_models->update_batch($data, "perpus_pelanggaran", "id_pelanggaran");
		}
			
		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/pelanggaran');
    }

    function entri_pengembalian(){
		$this->load->view('template/header');

		# tampilkan data ke view
		$this->load->view('perpustakaan/entri_pengembalian');

		$this->load->view('template/footer');	
    }

    function get_pengembalian_js(){
    	$this->load->helper('absen');
		$this->load->view('template/head');
		$kode_inv = $this->input->get('kode_inv'); 
		// echo $kode_inv;
		$exp = explode(" ", $kode_inv);

		$keranjang_tmp = array();
		$id_anggota = '';
		$a = 0;
		for ($i=0; $i <count($exp) ; $i++) { 
			$kode_inv = trim($exp[$i]);
			# cek ada ga kode inv yang dicari
			$jml_buku = $this->m_models->getRows("perpus_bahan_pustaka WHERE kode_inv='$kode_inv' ");
			if ($jml_buku > 0) {
				# cek tabel peminjaman apakah status masih proses atau sudah selesai
				$peminjaman = $this->m_models->getRows("perpus_pinjaman WHERE kode_inv='$kode_inv' AND status='0' ");
				if ($peminjaman > 0) {
					# cek barangkali sudah masuk keranjang
					if (in_array($kode_inv, $keranjang_tmp)) {
						$this->session->set_userdata('gagal', 'Item dengan No. Inventaris <b>'. $kode_inv .'</b> ini sudah masuk di daftar pengembalian');
					}else{
						# jika ada dalam data pinjaman
						$arraywhere = array('perpus_bahan_pustaka.kode_inv' => $kode_inv, 'perpus_pinjaman.status' => '0');
						$buku = $this->perpus_models->getJoin1where("perpus_bahan_pustaka.id_biblio, perpus_pinjaman.*", "perpus_pinjaman", "perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv",
							$arraywhere, "perpus_pinjaman.id_pinjaman", "ASC");
						foreach ($buku as $key) {
							if ($id_anggota == '' OR $id_anggota == $key->id_user) {

								# mencari judul , penerbit
								$judul = all("perpus_biblio", "id_biblio", $key->id_biblio, "judul");
								$penerbit = $this->get_penerbit($key->id_biblio, "id_biblio");

								/* ---- menentukan lama pinjam buku ------ */
								# cari tanggal jatuh tempo dengan meliaht di aturan peminjaman
								date_default_timezone_set('Asia/Jakarta');
								// perpanjangan di tabelnya dimasukin ke tanggal pengembalian
								$tanggal_pengembalian = date('Y-m-d');
								# Cek aturan peminjaman
								# sebelumnya cari jenis anggota yang pinjam apa, Santri, Mahasantri atau SDM
								$anggota = $this->m_models->get_data("perpus_instansi.id_jenis_anggota", "perpus_anggota", "JOIN perpus_instansi ON perpus_instansi.id_instansi=perpus_anggota.id_instansi WHERE perpus_anggota.id_user='$key->id_user' ");
								$jenis_anggota = $anggota[0]->id_jenis_anggota;
								# cek jenis buku nya apa
								$kategori_buku = all("perpus_biblio", "id_biblio", $key->id_biblio, "id_kategori_buku");
								# baru cek aturan peminjaman
								$bisa_pinjam = $this->m_models->get_data("perpus_aturan_peminjaman.lama_maksimal, perpus_aturan_peminjaman.denda_keterlambatan", "perpus_aturan_peminjaman", "WHERE id_kategori_buku='$kategori_buku' AND id_jenis_anggota='$jenis_anggota' ");

								$lama_maksimal = (int) $bisa_pinjam[0]->lama_maksimal;
								$lama_pinjam = mktime(0,0,0,date("n"),date("j")+$lama_maksimal,date("Y"));
								$kembali = date("Y-m-d", $lama_pinjam);

								/*----- /.menentukan lama pinjam buku ------ */

								/*----- mencari perpanjangan ke ------ */
								//$perpanjangan = $key->perpanjangan + 1;
								/*------------------------------------ */

								/*----- mencari sudah jatuh tempo atau tidak ------ */
								# kalo udah lewat jatuh tempo / telat beri warna bg barisnya
								$jt = preg_replace('/\D/', '', $key->tanggal_jatuh_tempo);
								$pj = preg_replace('/\D/', '', $tanggal_pengembalian);
								if ($pj > $jt) {
									$bg_baris = 'bg-gray';
									$denda_per_hari = $bisa_pinjam[0]->denda_keterlambatan;
								//	$telat = $pj - $jt;
									$jumlah_hari_minggu = $this->hitung_hari_minggu($key->tanggal_jatuh_tempo, $tanggal_pengembalian);
									$telat = get_selisih_hari($key->tanggal_jatuh_tempo, $tanggal_pengembalian) - $jumlah_hari_minggu;
									$total_denda = $denda_per_hari * $telat;
								}else{
									$bg_baris = '';
									$total_denda = 0;
								}
								/*------------------------------------ */

								/* ----- data untuk post tabel perpanjangan --- */
								$data_buku['id_pinjaman'][$a] = $key->id_pinjaman;
								$data_buku['no_transaksi'][$a] = $key->no_transaksi;
								$data_buku['kode_inv'][$a] = $key->kode_inv;
								$data_buku['judul'][$a] = $judul;
								$data_buku['penerbit'][$a] = $penerbit;
								$data_buku['tanggal_pinjam'][$a] = $key->tanggal_pinjam;
								$data_buku['tanggal_jatuh_tempo'][$a] = $key->tanggal_jatuh_tempo;
								$data_buku['tanggal_pengembalian'][$a] = $tanggal_pengembalian;
								$data_buku['telat'][$a] = get_selisih_hari($key->tanggal_jatuh_tempo, $tanggal_pengembalian);
								$data_buku['bg_jatuh_tempo'][$a] = $bg_baris;
								$data_buku['denda'][$a] = $total_denda;
								$data_buku['tanggal_pengembalian_sebelum'][$a] = $key->tanggal_pengembalian;
								$a++;

								/* ----- /.data untuk post tabel perpanjangan --- */


								/* ------- Profil peminjam ------ */
								# cari nama jenjang buat menentukan nama tabel atau romber
								/* profil peminjam lama
								$id_anggota = $key->id_user;
								$jenjang = db_siswa($id_anggota);

								$tabel_rombel = 'rombongan_belajar_'.$jenjang;
								$tabel_siswa = 'siswa_'.$jenjang;
								$tahun_akademik = $this->getTahunAkademik(date('Y-m-d'));

								$arrWhere=array('perpus_anggota.id_user' => $id_anggota);
								$data['anggota'] = $this->m_models->getJoin2Awhere($tabel_siswa.".nis,".$tabel_siswa.".id_sekolah,".$tabel_siswa.".jk, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", 
									$tabel_siswa, $tabel_siswa.".id_siswa=perpus_anggota.id_user", 
									"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
									$arrWhere, "id_user","asc");

								# ambil id_sekolah
								$id_sekolah = $data['anggota'][0]->id_sekolah;

								# cari kelas id_kelas
								$arrWhere=array($tabel_rombel.'.id_siswa ' => $id_anggota, $tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
								$data['kelas'] = $this->m_models->getJoin1where($tabel_rombel.".*, kelas.nama_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas", $arrWhere, "id_siswa","asc");
								*/
							
								$id_anggota = $key->id_user;
								$instansi = $this->m_models->get_data("perpus_instansi.nama", "perpus_anggota JOIN perpus_instansi ON perpus_anggota.id_instansi=perpus_instansi.id_instansi", "WHERE id_user='$id_anggota' ");
								if ( $instansi[0]->nama == 'SDM' ) {
									$arraywhere = array('perpus_anggota.id_user' => $id_anggota);
									$data['anggota'] = $this->m_models->getJoin2Awhere("perpus_anggota.nama, perpus_anggota.id_user, perpus_instansi.nama as nama_instansi, pegawai.jk, pegawai.nrp as nis, pegawai.foto, pegawai.id_sekolah, pegawai.id_jabatan", "perpus_anggota", 
										"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
										"pegawai", "perpus_anggota.id_user=pegawai.nrp", 
										$arraywhere, "perpus_anggota.id_user", "ASC");

									# cari jabatan dan sekolah
									$data['jabatan'] = $this->m_models->getDataByID("jabatan", 'id_jabatan', $data['anggota'][0]->id_jabatan);
									$data['sekolah'] = $this->m_models->getDataByID("sekolah", 'id_sekolah', $key->id_kelas);
									$data['path_photo_server'] = 'img_pegawai/';
									$data['foto'] = all("user_finger_karyawan", "user_id", $data['anggota'][0]->id_user, "photo");
								}else{
					
									$jenjang = db_siswa($id_anggota);

									$tabel_rombel = 'rombongan_belajar_'.$jenjang;
									$tabel_siswa = 'siswa_'.$jenjang;
									$tahun_akademik = $this->getTahunAkademik(date('Y-m-d'));
									$data['path_photo_server'] = 'img_siswa/'.$tabel_siswa.'/';

									$arrWhere=array('perpus_anggota.id_user' => $id_anggota);
									$data['anggota'] = $this->m_models->getJoin2Awhere($tabel_siswa.".nis,".$tabel_siswa.".id_sekolah,".$tabel_siswa.".jk, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", 
										$tabel_siswa, $tabel_siswa.".id_siswa=perpus_anggota.id_user", 
										"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
										$arrWhere, "id_user","asc");

									# cari kelas id_kelas
									$data['kelas'] = $this->m_models->getDataByID("kelas", 'id_kelas', $key->id_kelas);
									# photo
									$data['foto'] = all("user_finger_siswa", "user_id", $data['anggota'][0]->id_user, "photo");
								}


								/* ------- /. profil peminjam  ----- */

								#--------------- History Peminjaman ---------------#
								$histori_pinjam = $this->m_models->get_data("perpus_bahan_pustaka.kode_inv, perpus_bahan_pustaka.id_biblio, perpus_pinjaman.*", "perpus_pinjaman", "JOIN perpus_bahan_pustaka ON perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv WHERE perpus_pinjaman.id_user='$id_anggota' AND perpus_pinjaman.status='1' ORDER BY no_transaksi DESC LIMIT 10");
								$e = 0;
								foreach ($histori_pinjam as $key) { 
									# mencari judul 
									$judul = all("perpus_biblio", "id_biblio", $key->id_biblio, "judul");
									$klasifikasi = all("perpus_biblio", "id_biblio", $key->id_biblio, "klasifikasi");

									$histori['kode_inv'][$e] = $key->kode_inv;
									$histori['judul'][$e] = $judul;
									$histori['klasifikasi'][$e] = $klasifikasi;
									$histori['tanggal_pinjam'][$e] = $key->tanggal_pinjam;
									$histori['tanggal_pengembalian'][$e] = $key->tanggal_pengembalian;
									$e++;
								}	

								$data['jumlah_histori'] = $e;
								if ($e > 0) {
									$data['histori'] = $histori;
								}						
								
								#--------------- /.History Peminjaman ---------------#

								# buat variable kode_inv temporary buat cek input kode yang sama
								$keranjang_tmp[] = $kode_inv; 

								# hapus jika ana sesion notif
								if ($this->session->has_userdata('gagal')) { 
								        $this->session->unset_userdata('gagal');
								}
							}else{
								$this->session->set_userdata('gagal', 'Item dengan No. Inventaris <b>'. $kode_inv .'</b> beda peminjam.');
							}
						}
					}

				}else{
					$this->session->set_userdata('gagal', 'No. Inventaris <b>'.$kode_inv.'</b> tidak ada dalam daftar pinjaman.');	
				}

			# jika kode inv tidak ditemukan
			}else{
				$this->session->set_userdata('gagal', 'No. Inventaris <b>'.$kode_inv.'</b> tidak ditemukan dalam database.');			
			}
		}
		
		$data['jumlah_data'] = $a;
		if ($a > 0) {
			$data['buku'] = $data_buku;
			$this->load->view('perpustakaan/keranjang_pengembalian', $data);
		}else{
			$this->load->view('perpustakaan/notif_perpanjangan');
		}		

		$this->load->view('template/js');    	
    }

    function simpan_pengembalian(){
		$simpan = false;
		$nrp = $this->session->userdata('nrp');
		# ambil data yang di post
		$id_pinjaman = $this->input->post('id_pinjaman');
		$jml_buku = count($this->input->post('id_pinjaman'));
		$tanggal_pengembalian = $this->input->post('tanggal_pengembalian');
		$denda = $this->input->post('denda');
		$tanggal_pengembalian_sebelum = $this->input->post('tanggal_pengembalian_sebelum');
		$id_user = $this->input->post('id_user');


		if ($jml_buku > 0) {
			$a = 0;
			for ($i = 0; $i < $jml_buku; $i++){ 
				$id = $id_pinjaman[$i];
				# array buat simpan di update tabel peminjaman
				$data[$i]['id_pinjaman'] = $id;
				$data[$i]['tanggal_pengembalian'] = $tanggal_pengembalian[$id];
				$data[$i]['dikembalikan'] = '1';
				$data[$i]['status'] = '1';
				$data[$i]['tanggal_update'] = date('Y-m-d H:i:s');

				# array buat simpan di tabel pengembalian
				date_default_timezone_set('Asia/Jakarta');
				$kode_waktu = date('Ymdhis');
				$id_pengembalian= $kode_waktu.$i;
				$data_pengembalian[$i]['id_pengembalian'] = $id_pengembalian;
				$data_pengembalian[$i]['id_pinjaman'] = $id;
				$data_pengembalian[$i]['tanggal_pengembalian'] = $tanggal_pengembalian[$id];
				$data_pengembalian[$i]['tanggal_pengembalian_sebelum'] = $tanggal_pengembalian_sebelum[$id];
				$data_pengembalian[$i]['nrp'] = $nrp;

				# array buata simpan ke tabel pelanggaran jika ada denda
				if ($denda[$id] != 0) {
					$data_pelanggaran[$a]['id_pelanggaran'] = '';
					$data_pelanggaran[$a]['id_pinjaman'] = $id;
					$data_pelanggaran[$a]['jenis_pelanggaran'] = 'Telat';
					$data_pelanggaran[$a]['id_aturan_kehilangan'] = '1';
					$data_pelanggaran[$a]['id_perpanjangan'] = '0';
					$data_pelanggaran[$a]['id_pengembalian'] = $id_pengembalian;
					$data_pelanggaran[$a]['jumlah_denda'] = $denda[$id];
					$data_pelanggaran[$a]['jumlah_bayar'] = 0;
					$data_pelanggaran[$a]['jumlah_diskon'] = 0;
					$data_pelanggaran[$a]['keterangan'] = '';
					$data_pelanggaran[$a]['nrp'] = $nrp;
					$data_pelanggaran[$a]['status'] = '0';
					$a++;
				}

			}

			# proses simpan ke tabel perpus_anggota
			$simpan = $this->m_models->update_batch($data, "perpus_pinjaman", "id_pinjaman");

			# proses simpan ke tabel perpus_perpanjangan
			$simpan = $this->m_models->save_batch($data_pengembalian, "perpus_pengembalian");

			# proses simpan ke tabel perpus_pelanggaran
			if ($a > 0) {
				$simpan = $this->m_models->save_batch($data_pelanggaran, "perpus_pelanggaran");
			}
			
		}
			
		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		# jika ada pelanggaran langsung buka pembayaran denda
		if ($a != 0) {
			redirect('perpus/pembayaran_denda/'.$id_user);
		}else{
			redirect('perpus/pengembalian');
		}

    }

    #pengembalian
    function pengembalian(){
        $this->load->view('template/header');
        $kolom_cari = $this->input->post('kolom_cari', TRUE); 
        $text_cari = $this->input->post('text_cari', TRUE);

        $data['kolom_cari'] = $kolom_cari;
        $data['text_cari'] = $text_cari;

        $text_cari = str_replace(" ","#", $text_cari);

        # kirim link ajax list penulis 
        $data['url_ajax'] = 'perpus/ajax_list_pengembalian/'.$kolom_cari.'/'.$text_cari;

        # tampilkan data ke view
        $this->load->view('perpustakaan/pengembalian', $data); 

        $this->load->view('template/footer');  
    }

    public function ajax_list_pengembalian()
    {
         $table = 'perpus_pengembalian';
         $column_order = array(null,'no_transaksi' ,'kode_inv', null, 'id_user', 'perpus_anggota.nama', 'tanggal_pinjam', 'tanggal_jatuh_tempo', 'tanggal_pengembalian'); //set column field database for datatable orderable
         $order = array('tanggal_pengembalian' => 'desc'); // default order 
         $column_search_external = $this->uri->segment(3);
         if ($column_search_external != null) {
            $column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
         }else{
            $column_search = array('no_transaksi'); //set column field database for datatable searchable 
         }
         
         $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $pinjaman) {

        	# mencari judul koleksi
        	$id_biblio = all("perpus_bahan_pustaka", "kode_inv", $pinjaman->kode_inv, "id_biblio");
        	$judul = all("perpus_biblio", "id_biblio", $id_biblio, "judul");
            
            $no++;
            $row = array();
            $row[] = number_format($no);
            $row[] = $pinjaman->no_transaksi;
            $row[] = $pinjaman->kode_inv;
            $row[] = $judul;
            $row[] = $pinjaman->id_user;
            $row[] = $pinjaman->nama;
            $row[] = shortdate_indo2($pinjaman->tanggal_pinjam);
            $row[] = shortdate_indo2($pinjaman->tanggal_jatuh_tempo);
            $row[] = shortdate_indo2($pinjaman->tanggal_pengembalian);
            $row[] = $this->get_terlambat($pinjaman->tanggal_jatuh_tempo, $pinjaman->tanggal_pengembalian);
            $row[] = '<a href="#" class="hapus-record" data-id="'.$pinjaman->id_pinjaman.'"><button type="button" class="btn btn-danger" ><i class="fa fa-trash-o"></i></button></a>';

            $data[] = $row;
    
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function f_hapus_pengembalian(){ 
		$this->load->view('template/head');
		$id_pinjaman = $this->input->post('id', TRUE);

		$data['pinjaman'] = $this->m_models->get_data("*", "perpus_pinjaman", "WHERE id_pinjaman='$id_pinjaman' ");

		$this->load->view('perpustakaan/f_hapus_pengembalian', $data); 
		$this->load->view('template/js');
	}

	function hapus_pengembalian(){
		$id_pinjaman = $this->input->post('id_pinjaman', TRUE);
		# ambil data id_pengembalian
		$pengembalian = $this->m_models->get_data("id_pengembalian, tanggal_pengembalian_sebelum", "perpus_pengembalian", "WHERE id_pinjaman='$id_pinjaman' ");
		$id_pengembalian = $pengembalian[0]->id_pengembalian;
		$tanggal_pengembalian_sebelum = $pengembalian[0]->tanggal_pengembalian_sebelum;

		# proses hapus
		# hapus ditabel pengembalian
		if ($this->m_models->delete_data($id_pinjaman, 'id_pinjaman', 'perpus_pengembalian') == TRUE) {
			# hapus di tabel pelanggaran kalo ada
			$pelanggaran = $this->m_models->getRows("perpus_pelanggaran WHERE id_pengembalian='$id_pengembalian' ");
			if ($pelanggaran > 0) {
				# cari id pelanggaran buat di hapus di tabel jurnal berdasarkan id_pelanggaran
				$data_pelanggaran = $this->m_models->get_data("id_pelanggaran", "perpus_pelanggaran", "WHERE id_pengembalian='$id_pengembalian'");
				$id_pelanggaran = $data_pelanggaran[0]->id_pelanggaran;
				$this->m_models->delete_data('id_pelanggaran_'.$id_pelanggaran, 'asal', 'jurnal');
				# hapus data pelanggaran
				$this->m_models->delete_data($id_pengembalian, 'id_pengembalian', 'perpus_pelanggaran');
			} 
			# proses update tabel pinjaman
			date_default_timezone_set('Asia/Jakarta');
			$tanggal_update = date('Y-m-d H:i:s');

	 		$data = array (
			    'tanggal_pengembalian' => $tanggal_pengembalian_sebelum,
			    'dikembalikan' => '0',
			    'status' => '0',
			    'tanggal_update' => $tanggal_update
			);
			
			$this->m_models->update_data($id_pinjaman, 'id_pinjaman', $data, "perpus_pinjaman");

			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/pengembalian');
	}

    function entri_kehilangan(){
		$this->load->view('template/header');

		# tampilkan data ke view
		$this->load->view('perpustakaan/entri_kehilangan');

		$this->load->view('template/footer');	
    }

    function get_kehilangan_js(){
    	$this->load->helper('absen');
		$this->load->view('template/head');
		$kode_inv = $this->input->get('kode_inv'); 
		// echo $kode_inv;
		$exp = explode(" ", $kode_inv);

		$keranjang_tmp = array();
		$id_anggota = '';
		$a = 0;
		for ($i=0; $i <count($exp) ; $i++) { 
			$kode_inv = trim($exp[$i]);
			# cek ada ga kode inv yang dicari
			$jml_buku = $this->m_models->getRows("perpus_bahan_pustaka WHERE kode_inv='$kode_inv' ");
			if ($jml_buku > 0) {
				# cek tabel peminjaman apakah status masih proses atau sudah selesai
				$peminjaman = $this->m_models->getRows("perpus_pinjaman WHERE kode_inv='$kode_inv' AND status='0' ");
				if ($peminjaman > 0) {
					# cek barangkali sudah masuk keranjang
					if (in_array($kode_inv, $keranjang_tmp)) {
						$this->session->set_userdata('gagal', 'Item dengan No. Inventaris <b>'. $kode_inv .'</b> ini sudah masuk di daftar pengembalian');
					}else{
						# jika ada dalam data pinjaman
						$arraywhere = array('perpus_bahan_pustaka.kode_inv' => $kode_inv, 'perpus_pinjaman.status' => '0');
						$buku = $this->perpus_models->getJoin1where("perpus_bahan_pustaka.id_biblio, perpus_pinjaman.*", "perpus_pinjaman", "perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv",
							$arraywhere, "perpus_pinjaman.id_pinjaman", "ASC");
						foreach ($buku as $key) {
							if ($id_anggota == '' OR $id_anggota == $key->id_user) {

								# mencari judul , penerbit
								$judul = all("perpus_biblio", "id_biblio", $key->id_biblio, "judul");
								$penerbit = $this->get_penerbit($key->id_biblio, "id_biblio");

								/* ---- menentukan lama pinjam buku ------ */
								# cari tanggal jatuh tempo dengan meliaht di aturan peminjaman
								date_default_timezone_set('Asia/Jakarta');
								// perpanjangan di tabelnya dimasukin ke tanggal pengembalian
								$tanggal_pengembalian = date('Y-m-d');
								# Cek aturan peminjaman
								# sebelumnya cari jenis anggota yang pinjam apa, Santri, Mahasantri atau SDM
								$anggota = $this->m_models->get_data("perpus_instansi.id_jenis_anggota", "perpus_anggota", "JOIN perpus_instansi ON perpus_instansi.id_instansi=perpus_anggota.id_instansi WHERE perpus_anggota.id_user='$key->id_user' ");
								$jenis_anggota = $anggota[0]->id_jenis_anggota;
								# cek jenis buku nya apa
								$kategori_buku = all("perpus_biblio", "id_biblio", $key->id_biblio, "id_kategori_buku");
								# baru cek aturan peminjaman
								$bisa_pinjam = $this->m_models->get_data("perpus_aturan_peminjaman.lama_maksimal, perpus_aturan_peminjaman.denda_keterlambatan", "perpus_aturan_peminjaman", "WHERE id_kategori_buku='$kategori_buku' AND id_jenis_anggota='$jenis_anggota' ");

								$lama_maksimal = (int) $bisa_pinjam[0]->lama_maksimal;
								$lama_pinjam = mktime(0,0,0,date("n"),date("j")+$lama_maksimal,date("Y"));
								$kembali = date("Y-m-d", $lama_pinjam);

								/*----- /.menentukan lama pinjam buku ------ */

								/*----- mencari perpanjangan ke ------ */
								//$perpanjangan = $key->perpanjangan + 1;
								/*------------------------------------ */

								/*----- mencari sudah jatuh tempo atau tidak ------ */
								# kalo udah lewat jatuh tempo / telat beri warna bg barisnya
								$jt = preg_replace('/\D/', '', $key->tanggal_jatuh_tempo);
								$pj = preg_replace('/\D/', '', $tanggal_pengembalian);
								if ($pj > $jt) {
									$bg_baris = 'bg-gray';
									$denda_per_hari = $bisa_pinjam[0]->denda_keterlambatan;
								//	$telat = $pj - $jt;
									$jumlah_hari_minggu = $this->hitung_hari_minggu($key->tanggal_jatuh_tempo, $tanggal_pengembalian);
									$telat = get_selisih_hari($key->tanggal_jatuh_tempo, $tanggal_pengembalian) - $jumlah_hari_minggu;
									$total_denda = $denda_per_hari * $telat;
								}else{
									$bg_baris = '';
									$total_denda = 0;
								}
								/*------------------------------------ */

								/* ----- data untuk post tabel perpanjangan --- */
								$data_buku['id_pinjaman'][$a] = $key->id_pinjaman;
								$data_buku['no_transaksi'][$a] = $key->no_transaksi;
								$data_buku['kode_inv'][$a] = $key->kode_inv;
								$data_buku['judul'][$a] = $judul;
								$data_buku['penerbit'][$a] = $penerbit;
								$data_buku['tanggal_pinjam'][$a] = $key->tanggal_pinjam;
								$data_buku['tanggal_jatuh_tempo'][$a] = $key->tanggal_jatuh_tempo;
								$data_buku['tanggal_pengembalian'][$a] = $tanggal_pengembalian;
								$data_buku['telat'][$a] = $this->get_terlambat($key->tanggal_jatuh_tempo, $tanggal_pengembalian);
								$data_buku['bg_jatuh_tempo'][$a] = $bg_baris;
								$data_buku['denda'][$a] = $total_denda;
								$data_buku['tanggal_pengembalian_sebelum'][$a] = $key->tanggal_pengembalian;
								$a++;

								/* ----- /.data untuk post tabel perpanjangan --- */


								/* ------- Profil peminjam ------ */
								# cari nama jenjang buat menentukan nama tabel atau romber
								$id_anggota = $key->id_user;
								$jenjang = db_siswa($id_anggota);

								$tabel_rombel = 'rombongan_belajar_'.$jenjang;
								$tabel_siswa = 'siswa_'.$jenjang;
								$tahun_akademik = $this->getTahunAkademik(date('Y-m-d'));

								$arrWhere=array('perpus_anggota.id_user' => $id_anggota);
								$data['anggota'] = $this->m_models->getJoin2Awhere($tabel_siswa.".nis,".$tabel_siswa.".id_sekolah,".$tabel_siswa.".jk, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", 
									$tabel_siswa, $tabel_siswa.".id_siswa=perpus_anggota.id_user", 
									"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
									$arrWhere, "id_user","asc");

								# ambil id_sekolah
								$id_sekolah = $data['anggota'][0]->id_sekolah;

								# cari kelas id_kelas
								$arrWhere=array($tabel_rombel.'.id_siswa ' => $id_anggota, $tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
								$data['kelas'] = $this->m_models->getJoin1where($tabel_rombel.".*, kelas.nama_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas", $arrWhere, "id_siswa","asc");
								/* ------- /. profil peminjam  ----- */

								#--------------- History Peminjaman ---------------#
								$histori_pinjam = $this->m_models->get_data("perpus_bahan_pustaka.kode_inv, perpus_bahan_pustaka.id_biblio, perpus_pinjaman.*", "perpus_pinjaman", "JOIN perpus_bahan_pustaka ON perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv WHERE perpus_pinjaman.id_user='$id_anggota' AND perpus_pinjaman.status='1' ORDER BY no_transaksi DESC LIMIT 10");
								$e = 0;
								foreach ($histori_pinjam as $key) { 
									# mencari judul 
									$judul = all("perpus_biblio", "id_biblio", $key->id_biblio, "judul");
									$klasifikasi = all("perpus_biblio", "id_biblio", $key->id_biblio, "klasifikasi");

									$histori['kode_inv'][$e] = $key->kode_inv;
									$histori['judul'][$e] = $judul;
									$histori['klasifikasi'][$e] = $klasifikasi;
									$histori['tanggal_pinjam'][$e] = $key->tanggal_pinjam;
									$histori['tanggal_pengembalian'][$e] = $key->tanggal_pengembalian;
									$e++;
								}	

								$data['jumlah_histori'] = $e;
								if ($e > 0) {
									$data['histori'] = $histori;
								}						
								
								#--------------- /.History Peminjaman ---------------#
								
								# -------------- load aturan kehilangan -------------#
								$data['aturan_kehilangan'] = $this->m_models->getAll("perpus_aturan_kehilangan ORDER BY id_aturan_kehilangan ASC");
								#  -------------- /.load aturan kehilangan -------------#

								# buat variable kode_inv temporary buat cek input kode yang sama
								$keranjang_tmp[] = $kode_inv; 

								# hapus jika ana sesion notif
								if ($this->session->has_userdata('gagal')) { 
								        $this->session->unset_userdata('gagal');
								}
							}else{
								$this->session->set_userdata('gagal', 'Item dengan No. Inventaris <b>'. $kode_inv .'</b> beda peminjam.');
							}
						}
					}

				}else{
					$this->session->set_userdata('gagal', 'No. Inventaris <b>'.$kode_inv.'</b> tidak ada dalam daftar pinjaman.');	
				}

			# jika kode inv tidak ditemukan
			}else{
				$this->session->set_userdata('gagal', 'No. Inventaris <b>'.$kode_inv.'</b> tidak ditemukan dalam database.');			
			}
		}
		
		$data['jumlah_data'] = $a;
		if ($a > 0) {
			$data['buku'] = $data_buku;
			$this->load->view('perpustakaan/keranjang_kehilangan', $data);
		}else{
			$this->load->view('perpustakaan/notif_perpanjangan');
		}		

		$this->load->view('template/js');    	
    }

    function simpan_kehilangan(){
		$simpan = false;
		$nrp = $this->session->userdata('nrp');
		# ambil data yang di post
		$id_pinjaman = $this->input->post('id_pinjaman');
		$jml_buku = count($this->input->post('id_pinjaman'));
		$tanggal_pengembalian = $this->input->post('tanggal_pengembalian');
		$tanggal_pengembalian_sebelum = $this->input->post('tanggal_pengembalian_sebelum');
		$id_user = $this->input->post('id_user');
		$id_aturan_kehilangan = $this->input->post('id_aturan_kehilangan');
		$jumlah_bayar = $this->input->post('jumlah_bayar');
		$keterangan = $this->input->post('keterangan');


		if ($jml_buku > 0) {
			$a = 0;
			for ($i = 0; $i < $jml_buku; $i++){ 
				$id = $id_pinjaman[$i];
				# array buat simpan di update tabel peminjaman
				$data[$i]['id_pinjaman'] = $id;
				$data[$i]['tanggal_pengembalian'] = $tanggal_pengembalian[$id];
				$data[$i]['dihilangkan'] = '1';
				$data[$i]['status'] = '1';
				$data[$i]['tanggal_update'] = date('Y-m-d H:i:s');

				if ($jumlah_bayar == '') {
					$jumlah_bayar = 0;
				}

				# array buata simpan ke tabel pelanggaran jika ada denda
					$data_pelanggaran[$a]['id_pelanggaran'] = '';
					$data_pelanggaran[$a]['id_pinjaman'] = $id;
					$data_pelanggaran[$a]['jenis_pelanggaran'] = 'Hilang';
					$data_pelanggaran[$a]['id_aturan_kehilangan'] = $id_aturan_kehilangan;
					$data_pelanggaran[$a]['id_perpanjangan'] = '0';
					$data_pelanggaran[$a]['id_pengembalian'] = '0';
					$data_pelanggaran[$a]['jumlah_denda'] = $jumlah_bayar;
					$data_pelanggaran[$a]['jumlah_bayar'] = $jumlah_bayar;
					$data_pelanggaran[$a]['jumlah_diskon'] = 0;
					$data_pelanggaran[$a]['keterangan'] = $keterangan;
					$data_pelanggaran[$a]['nrp'] = $nrp;
					$data_pelanggaran[$a]['status'] = '1';
					$a++;

			}

			# proses simpan ke tabel perpus_anggota
			$simpan = $this->m_models->update_batch($data, "perpus_pinjaman", "id_pinjaman");

			# proses simpan ke tabel perpus_pelanggaran
			$simpan = $this->m_models->save_batch($data_pelanggaran, "perpus_pelanggaran");
			
		}
			
		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/pelanggaran');
    }

    #peminjaman
    function pelanggaran(){
        $this->load->view('template/header');
        $kolom_cari = $this->input->post('kolom_cari', TRUE); 
        $text_cari = $this->input->post('text_cari', TRUE);

        $data['kolom_cari'] = $kolom_cari;
        $data['text_cari'] = $text_cari;

        $text_cari = str_replace(" ","#", $text_cari);

        # kirim link ajax list penulis 
        $data['url_ajax'] = 'perpus/ajax_list_pelanggaran/'.$kolom_cari.'/'.$text_cari;

        # tampilkan data ke view
        $this->load->view('perpustakaan/pelanggaran', $data); 

        $this->load->view('template/footer');  
    }

    public function ajax_list_pelanggaran()
    {
         $table = 'perpus_pelanggaran';
         $column_order = array(null,'no_transaksi' ,'kode_inv', null, 'id_user', 'perpus_anggota.nama', 'jenis_pelanggaran', null, 'jumlah_bayar', null); //set column field database for datatable orderable
         $order = array('no_transaksi' => 'desc'); // default order 
         $column_search_external = $this->uri->segment(3);
         if ($column_search_external != null) {
            $column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
         }else{
            $column_search = array('no_transaksi'); //set column field database for datatable searchable 
         }
         
         $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $pinjaman) {

        	# mencari judul koleksi
        	$id_biblio = all("perpus_bahan_pustaka", "kode_inv", $pinjaman->kode_inv, "id_biblio");
        	$judul = all("perpus_biblio", "id_biblio", $id_biblio, "judul");
        	$aturan_kehilangan = all("perpus_aturan_kehilangan", "id_aturan_kehilangan", $pinjaman->id_aturan_kehilangan, "nama_aturan");
            
            $no++;
            $row = array();
            $row[] = number_format($no);
            $row[] = $pinjaman->id_user;
            $row[] = $pinjaman->nama;
            $row[] = $pinjaman->no_transaksi;
            $row[] = $pinjaman->kode_inv;
            $row[] = '<a href="#" class="edit-record" data-id="'.$pinjaman->id_pelanggaran.'">'.$judul.'</a>';
            $row[] = $pinjaman->jenis_pelanggaran;
            $row[] = $aturan_kehilangan;
        //    $row[] = $pinjaman->jumlah_denda;
            $row[] = number_format($pinjaman->jumlah_bayar);
        //    $row[] = $pinjaman->jumlah_diskon;

            $row[] = '<a href="#" class="detail-record" data-id="'.$pinjaman->id_pelanggaran.'"><button type="button" class="btn btn-default btn-sm"><i class="fa fa-search-plus"></i></button></a>';

            $data[] = $row;
    
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

    function f_detail_pelanggaran(){ 
		$this->load->view('template/head');
		$id_pelanggaran = $this->input->post('id', TRUE);

		#getJoin3where($select, $tabel, $tabeljoin1, $idjoin1, $tabeljoin2, $idjoin2, $tabeljoin3, $idjoin3, $arraywhere, $fieldorder, $jenis_orderby)
		
		$arraywhere = array('perpus_pelanggaran.id_pelanggaran' => $id_pelanggaran );
		$data['pelanggaran'] = $this->m_models->getJoin3where("perpus_pinjaman.*, perpus_bahan_pustaka.id_biblio, perpus_anggota.nama, perpus_pelanggaran.*", "perpus_pinjaman", 
			"perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv",
			"perpus_anggota","perpus_anggota.id_user=perpus_pinjaman.id_user",
			"perpus_pelanggaran","perpus_pelanggaran.id_pinjaman=perpus_pinjaman.id_pinjaman",
			$arraywhere, "perpus_pinjaman.id_pinjaman", "ASC");

		$this->load->view('perpustakaan/f_detail_pelanggaran', $data); 
		$this->load->view('template/js');
	}

	function f_edit_pelanggaran(){ 
		$this->load->view('template/head');
		$id_pelanggaran = $this->input->post('id', TRUE);
		
		$arraywhere = array('perpus_pelanggaran.id_pelanggaran' => $id_pelanggaran );
		$data['pelanggaran'] = $this->m_models->getJoin3where("perpus_pinjaman.*, perpus_bahan_pustaka.id_biblio, perpus_anggota.nama, perpus_pelanggaran.*", "perpus_pinjaman", 
			"perpus_bahan_pustaka", "perpus_bahan_pustaka.kode_inv=perpus_pinjaman.kode_inv",
			"perpus_anggota","perpus_anggota.id_user=perpus_pinjaman.id_user",
			"perpus_pelanggaran","perpus_pelanggaran.id_pinjaman=perpus_pinjaman.id_pinjaman",
			$arraywhere, "perpus_pinjaman.id_pinjaman", "ASC");

		$data['aturan_kehilangan'] = $this->m_models->getAll("perpus_aturan_kehilangan ORDER BY nama_aturan ASC");

		$this->load->view('perpustakaan/f_edit_pelanggaran', $data); 
		$this->load->view('template/js');
	}

	function edit_pelanggaran(){
		$id_pelanggaran = $this->input->post('id_pelanggaran', TRUE);
		$jenis_pelanggaran = $this->input->post('jenis_pelanggaran', TRUE);
		$id_aturan_kehilangan = $this->input->post('id_aturan_kehilangan', TRUE);
		$jumlah_bayar = $this->input->post('jumlah_bayar', TRUE);
		$jumlah_diskon = $this->input->post('jumlah_diskon', TRUE);
		$keterangan = $this->input->post('keterangan', TRUE);

		if ($jenis_pelanggaran == 'Telat') {
			$data = array (
			    'jumlah_bayar' => $jumlah_bayar,
			    'jumlah_diskon' => $jumlah_diskon,
			    'keterangan' => $keterangan
			);
		}else{
			$data = array (
				'id_aturan_kehilangan' => $id_aturan_kehilangan,
			    'jumlah_bayar' => $jumlah_bayar,
			    'keterangan' => $keterangan
			);
		}
	
		# proses edit
		if ($this->m_models->update_data($id_pelanggaran, 'id_pelanggaran', $data, "perpus_pelanggaran") == TRUE) {

			$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
		}

		redirect('perpus/pelanggaran');
	}

    #peminjaman_komputer
    function peminjaman_komputer(){
        $this->load->view('template/header');
    
    	# ambil data semua komputer kecuali yang off / status 0
    	$data['komputer'] = $this->m_models->getAll("perpus_komputer WHERE status='1' ORDER BY nama_komputer ASC ");

    	# ambil data peminjaman hari ini
    	date_default_timezone_set('Asia/Jakarta');
    	$tanggal_sekarang = date('Y-m-d');
    	
    	$arraywhere = array('perpus_pinjaman_komputer.tanggal_pinjam' => $tanggal_sekarang);
    	$pinjaman = $this->perpus_models->getJoin2where("perpus_pinjaman_komputer.*, perpus_anggota.nama, perpus_komputer.nama_komputer", "perpus_pinjaman_komputer", 
    		"perpus_anggota", "perpus_pinjaman_komputer.id_user=perpus_anggota.id_user",
    		"perpus_komputer", "perpus_pinjaman_komputer.id_komputer=perpus_komputer.id_komputer",
    	 	$arraywhere, "perpus_pinjaman_komputer.id_pin_komputer", "ASC");
    	$komputer_pinjam = array();
    	$peminjaman = array();
    	foreach ($pinjaman as $key) { 
    		$peminjaman[$key->id_komputer]['id_pin_komputer'] = $key->id_pin_komputer;
    		$komputer_pinjam[] = $key->id_komputer;
    		$peminjaman[$key->id_komputer]['peminjam'] = $key->nama;
    		$nama_pj = all("perpus_anggota", "id_user", $pinjaman->id_pj, "nama");
    		$peminjaman[$key->id_komputer]['pj'] = $nama_pj;
    		$peminjaman[$key->id_komputer]['jam_mulai'] = $key->jam_mulai;
    		$peminjaman[$key->id_komputer]['jam_akhir'] = $key->jam_akhir;
    	}

    	$data['komputer_pinjam'] = $komputer_pinjam;
    	$data['pinjam'] = $peminjaman;
    	$data['waktu_now'] = date('Hi');

        # tampilkan data ke view
        $this->load->view('perpustakaan/peminjaman_komputer', $data); 

        $this->load->view('template/footer');  
    }	

    function entri_peminjaman_komputer($id_komputer){
		$this->load->view('template/header');
	//	$this->session->set_userdata('id_komputer_pilih', $id_komputer);

		$anggota = $this->input->post('id_anggota', TRUE); 
		$exp = explode(" ", $anggota);
		$id_anggota = $exp[0];

		if ($id_anggota == null) {
			# tampilkan data input anggota ke view
			$this->load->view('perpustakaan/f_anggota_komputer'); 
		}else{
			# cek data anggota ada engga
			$jml_anggota = $this->m_models->getRows("perpus_anggota WHERE id_user='$id_anggota' ");
			if ($jml_anggota > 0) {
				# cek status anggota
				$status_anggota =  $this->m_models->get_data("perpus_anggota.status, perpus_anggota.id_instansi", "perpus_anggota", "WHERE id_user='$id_anggota' ");
				# jika data ada dan status anggota masih aktif aktif
				if ($status_anggota[0]->status == 'Aktif') {	
					# data komputer yang dipilih
					$data['komputer'] = $this->m_models->get_data("id_komputer, nama_komputer", "perpus_komputer", "WHERE id_komputer='$id_komputer' ");
					# data pj
					$data['pj'] = $this->m_models->get_data("id_user, nama", "perpus_anggota", "WHERE id_instansi='1' ");

					# -------------- profil anggota perpus ------------- #
					$id_instansi = $status_anggota[0]->id_instansi;
					# jika instansi anggota SDM
					if ($id_instansi == '1') {
						$arraywhere = array('perpus_anggota.id_user' => $id_anggota);
						$data['anggota'] = $this->m_models->getJoin2Awhere("perpus_anggota.nama, perpus_anggota.id_user, perpus_instansi.nama as nama_instansi, pegawai.jk, pegawai.nrp as nis, pegawai.foto", "perpus_anggota", 
							"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
							"pegawai", "perpus_anggota.id_user=pegawai.nrp", 
							$arraywhere, "perpus_anggota.id_user", "ASC");
					# jika instansi anggota adalah Sekolah
					}else{
						# cari nama jenjang buat menentukan nama tabel atau romber
						$jenjang = db_siswa($id_anggota);

						$tabel_rombel = 'rombongan_belajar_'.$jenjang;
						$tabel_siswa = 'siswa_'.$jenjang;
						$tahun_akademik = $this->getTahunAkademik(date('Y-m-d'));
						$data['path_photo_server'] = 'img_siswa/'.$tabel_siswa.'/';

						$arrWhere=array('perpus_anggota.id_user' => $id_anggota);
						$data['anggota'] = $this->m_models->getJoin2Awhere($tabel_siswa.".nis,".$tabel_siswa.".id_sekolah,".$tabel_siswa.".jk, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", 
							$tabel_siswa, $tabel_siswa.".id_siswa=perpus_anggota.id_user", 
							"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
							$arrWhere, "id_user","asc");

						# ambil id_sekolah
						$id_sekolah = $data['anggota'][0]->id_sekolah;

						# cari kelas id_kelas
						$arrWhere=array($tabel_rombel.'.id_siswa ' => $id_anggota, $tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
						$data['kelas'] = $this->m_models->getJoin1where($tabel_rombel.".*, kelas.nama_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas", $arrWhere, "id_siswa","asc");
					}	
					# -------------- /. profil anggota perpus ------------- #
					# 					
						#--------------- History Peminjaman ---------------#
						$histori_pinjam = $this->m_models->get_data("perpus_pinjaman_komputer.*, perpus_anggota.nama, perpus_komputer.nama_komputer", "perpus_pinjaman_komputer", "JOIN perpus_anggota ON perpus_pinjaman_komputer.id_user=perpus_anggota.id_user JOIN perpus_komputer ON perpus_pinjaman_komputer.id_komputer=perpus_komputer.id_komputer WHERE perpus_pinjaman_komputer.id_user='$id_anggota' ORDER BY tanggal_pinjam DESC LIMIT 10");
						$a = 0;
						foreach ($histori_pinjam as $key) { 
							# mencari judul 
							$nama_pj = all("perpus_anggota", "id_user", $key->id_pj, "nama");

							$histori['tanggal_pinjam'][$a] = $key->tanggal_pinjam;
							$histori['komputer'][$a] = $key->nama_komputer;
							$histori['jam_mulai'][$a] = substr($key->jam_mulai,0,5);
							$histori['jam_akhir'][$a] = substr($key->jam_akhir,0,5);
							$histori['keperluan'][$a] = $key->keperluan;
							$histori['pj'][$a] = $nama_pj;
							$a++;
						}	

						$data['jumlah_histori'] = $a;
						if ($a > 0) {
							$data['histori'] = $histori;
						}						
						
						#--------------- /.History Peminjaman ---------------#
						
					# tampilkan data ke view
					$this->load->view('perpustakaan/entri_peminjaman_komputer', $data); 
				
				# jika status anggota tidak Aktif muncul notif gagal
				}else{
					$this->session->set_flashdata('gagal', 'Status anggota dengan ID <b>'.$id_anggota.'</b> tidak aktif.');
					$data['id_anggota'] = $id_anggota;
					$this->load->view('perpustakaan/f_anggota_komputer', $data); 					
				}
			# jika id_user tidak ditemukan muncul notif gagal
			}else{
				$this->session->set_flashdata('gagal', 'Data Anggota dengan ID <b>'.$id_anggota.'</b> tidak ditemukan, silahkan cek kembali data ID Anggota !!!');
				$data['id_anggota'] = $id_anggota;
				$this->load->view('perpustakaan/f_anggota_komputer', $data); 
			}
		}

		$this->load->view('template/footer');	
    }

    function simpan_peminjaman_komputer(){
    	$nrp = $this->session->userdata('nrp');
    	$id_komputer = $this->input->post('id_komputer', TRUE);
		$id_user = $this->input->post('id_user', TRUE);
		$id_kelas = $this->input->post('id_kelas', TRUE);
		$id_pj = $this->input->post('id_pj', TRUE);
		$jam_mulai = time_db($this->input->post('jam_mulai', TRUE));
		$jam_akhir = time_db($this->input->post('jam_akhir', TRUE));
		$keperluan = $this->input->post('keperluan', TRUE);

		date_default_timezone_set('Asia/Jakarta');
    	$tanggal_sekarang = date('Y-m-d');

		$data = array(
			'id_pin_komputer' => '',
			'id_komputer' => $id_komputer,
			'id_user' => $id_user, 
			'id_kelas' => $id_kelas,
			'id_pj' => $id_pj,
			'tanggal_pinjam' => $tanggal_sekarang,
			'jam_mulai' => $jam_mulai,
			'jam_akhir' => $jam_akhir,
			'keperluan' => $keperluan,
			'nrp' => $nrp
		);

		# proses simpan
		if ($this->m_models->save_data($data, "perpus_pinjaman_komputer") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}
		redirect('perpus/peminjaman_komputer');    	
    }

    function edit_peminjaman_komputer($id_pin_komputer){
		date_default_timezone_set('Asia/Jakarta');
    	$jam_akhir = date('H:i:s');

		$data = array(
			'id_pin_komputer' => $id_pin_komputer,
			'jam_akhir' => $jam_akhir
		);

		# proses simpan
		if ($this->m_models->update_data($id_pin_komputer, 'id_pin_komputer', $data, "perpus_pinjaman_komputer") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}
		redirect('perpus/peminjaman_komputer');    	
    }

    #daftar_peminjaman_komputer
    function daftar_peminjaman_komputer(){
        $this->load->view('template/header');
        $kolom_cari = $this->input->post('kolom_cari', TRUE); 
        $text_cari = $this->input->post('text_cari', TRUE);

        $data['kolom_cari'] = $kolom_cari;
        $data['text_cari'] = $text_cari;

        $text_cari = str_replace(" ","#", $text_cari);

        # kirim link ajax list penulis 
        $data['url_ajax'] = 'perpus/ajax_list_peminjaman_komputer/'.$kolom_cari.'/'.$text_cari;

        # tampilkan data ke view
        $this->load->view('perpustakaan/daftar_peminjaman_komputer', $data); 

        $this->load->view('template/footer');  
    }

    public function ajax_list_peminjaman_komputer()
    {
         $table = 'perpus_pinjaman_komputer';
         $column_order = array(null,'tanggal_pinjam', 'perpus_komputer.nama_komputer', 'id_user','perpus_anggota.nama',null, 'keperluan', 'id_pj', null); //set column field database for datatable orderable
         $order = array('id_pin_komputer' => 'desc'); // default order 
         $column_search_external = $this->uri->segment(3);
         if ($column_search_external != null) {
            $column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
         }else{
            $column_search = array('id_pin_komputer'); //set column field database for datatable searchable 
         }
         
         $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $pinjaman) {

        	# mencari judul koleksi
            $nama_pj = all("perpus_anggota", "id_user", $pinjaman->id_pj, "nama");

            $no++;
            $row = array();
            $row[] = number_format($no);
            $row[] = mediumdate_indo($pinjaman->tanggal_pinjam);
            $row[] = $pinjaman->nama_komputer;
            $row[] = $pinjaman->id_user;
            $row[] = $pinjaman->nama;
            $row[] = substr($pinjaman->jam_mulai,0,5).' - '.substr($pinjaman->jam_akhir,0,5);
            $row[] = $pinjaman->keperluan;
            $row[] = $pinjaman->id_pj;
            $row[] = $nama_pj;
            $row[] = '<a href="#" class="hapus-record" data-id="'.$pinjaman->id_pin_komputer.'"><button type="button" class="btn btn-danger" ><i class="fa fa-trash-o"></i></button></a>';

            $data[] = $row;
    
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function f_hapus_peminjaman_komputer(){ 
		$this->load->view('template/head');
		$id_pinjaman = $this->input->post('id', TRUE);

		$data['pinjaman'] = $this->m_models->get_data("*", "perpus_pinjaman_komputer", "WHERE id_pin_komputer='$id_pinjaman' ");

		$this->load->view('perpustakaan/f_hapus_peminjaman_komputer', $data); 
		$this->load->view('template/js');
	}

	function hapus_peminjaman_komputer(){
		$id_pin_komputer = $this->input->post('id_pin_komputer', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_pin_komputer, 'id_pin_komputer', 'perpus_pinjaman_komputer') == TRUE) {

			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/daftar_peminjaman_komputer');
	}

    function peminjaman_ruangan(){
		$this->load->view('template/header');
	//	$this->session->set_userdata('id_komputer_pilih', $id_komputer);

		$anggota = $this->input->post('id_anggota', TRUE); 
		$exp = explode(" ", $anggota);
		$id_anggota = $exp[0];

		if ($id_anggota == null) {
			# tampilkan data input anggota ke view
			$this->load->view('perpustakaan/f_anggota_ruangan'); 
		}else{
			# cek data anggota ada engga
			$jml_anggota = $this->m_models->getRows("perpus_anggota WHERE id_user='$id_anggota' ");
			if ($jml_anggota > 0) {
				# cek status anggota
				$status_anggota =  $this->m_models->get_data("perpus_anggota.status, perpus_anggota.id_instansi", "perpus_anggota", "WHERE id_user='$id_anggota' ");
				# jika data ada dan status anggota masih aktif aktif
				if ($status_anggota[0]->status == 'Aktif') {	
					# data komputer yang dipilih
					$data['ruangan'] = $this->m_models->get_data("*", "perpus_ruangan", "ORDER BY nama_ruangan ASC");

					# -------------- profil anggota perpus ------------- #
					$id_instansi = $status_anggota[0]->id_instansi;
					# jika instansi anggota SDM
					if ($id_instansi == '1') {
						$arraywhere = array('perpus_anggota.id_user' => $id_anggota);
						$data['anggota'] = $this->m_models->getJoin2Awhere("perpus_anggota.nama, perpus_anggota.id_user, perpus_instansi.nama as nama_instansi, pegawai.jk, pegawai.nrp as nis, pegawai.foto", "perpus_anggota", 
							"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
							"pegawai", "perpus_anggota.id_user=pegawai.nrp", 
							$arraywhere, "perpus_anggota.id_user", "ASC");
					# jika instansi anggota adalah Sekolah
					}else{
						# cari nama jenjang buat menentukan nama tabel atau romber
						$jenjang = db_siswa($id_anggota);

						$tabel_rombel = 'rombongan_belajar_'.$jenjang;
						$tabel_siswa = 'siswa_'.$jenjang;
						$tahun_akademik = $this->getTahunAkademik(date('Y-m-d'));

						$arrWhere=array('perpus_anggota.id_user' => $id_anggota);
						$data['anggota'] = $this->m_models->getJoin2Awhere($tabel_siswa.".nis,".$tabel_siswa.".id_sekolah,".$tabel_siswa.".jk, perpus_instansi.nama as nama_instansi, perpus_anggota.*", "perpus_anggota", 
							$tabel_siswa, $tabel_siswa.".id_siswa=perpus_anggota.id_user", 
							"perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", 
							$arrWhere, "id_user","asc");

						# ambil id_sekolah
						$id_sekolah = $data['anggota'][0]->id_sekolah;

						# cari kelas id_kelas
						$arrWhere=array($tabel_rombel.'.id_siswa ' => $id_anggota, $tabel_rombel.'.id_tahun ' => $tahun_akademik, $tabel_rombel.'.id_sekolah ' => $id_sekolah);
						$data['kelas'] = $this->m_models->getJoin1where($tabel_rombel.".*, kelas.nama_kelas", $tabel_rombel, "kelas", $tabel_rombel.".id_kelas=kelas.id_kelas", $arrWhere, "id_siswa","asc");
					}
					# -------------- /. profil anggota perpus ------------- #
					# 
						#--------------- History Peminjaman ---------------#
						$histori_pinjam = $this->m_models->get_data("perpus_pinjaman_ruangan.*, perpus_anggota.nama, perpus_ruangan.nama_ruangan", "perpus_pinjaman_ruangan", "JOIN perpus_anggota ON perpus_pinjaman_ruangan.id_user=perpus_anggota.id_user JOIN perpus_ruangan ON perpus_pinjaman_ruangan.id_ruangan=perpus_ruangan.id_ruangan WHERE perpus_pinjaman_ruangan.id_user='$id_anggota' ORDER BY id_pin_ruangan DESC LIMIT 10");
						$a = 0;
						foreach ($histori_pinjam as $key) {

							$histori['tanggal_pinjam'][$a] = $key->tanggal_pinjam;
							$histori['ruangan'][$a] = $key->nama_ruangan;
							$histori['jenis_pinjam'][$a] = $key->jenis_pinjam;
							$histori['jumlah_santri'][$a] = $key->jumlah_santri;
							$histori['jam_mulai'][$a] = substr($key->jam_mulai,0,5);
							$histori['jam_akhir'][$a] = substr($key->jam_akhir,0,5);
							$histori['keperluan'][$a] = $key->keperluan;
							$a++;
						}	

						$data['jumlah_histori'] = $a;
						if ($a > 0) {
							$data['histori'] = $histori;
						}						
						
						#--------------- /.History Peminjaman ---------------#
						
						#--------------- Pemesanan Peminjaman ---------------#
						date_default_timezone_set('Asia/Jakarta');
    					$tanggal_sekarang = date('Y-m-d');
						$pesanan_pinjam = $this->m_models->get_data("perpus_pinjaman_ruangan.*, perpus_anggota.nama, perpus_ruangan.nama_ruangan", "perpus_pinjaman_ruangan", "JOIN perpus_anggota ON perpus_pinjaman_ruangan.id_user=perpus_anggota.id_user JOIN perpus_ruangan ON perpus_pinjaman_ruangan.id_ruangan=perpus_ruangan.id_ruangan WHERE perpus_pinjaman_ruangan.tanggal_pinjam>='$tanggal_sekarang' ORDER BY tanggal_pinjam ASC ");
						$a = 0;
						foreach ($pesanan_pinjam as $key) {

							$pesanan['tanggal_pinjam'][$a] = $key->tanggal_pinjam;
							$pesanan['ruangan'][$a] = $key->nama_ruangan;
							$pesanan['jenis_pinjam'][$a] = $key->jenis_pinjam;
							$pesanan['jumlah_santri'][$a] = $key->jumlah_santri;
							$pesanan['jam_mulai'][$a] = substr($key->jam_mulai,0,5);
							$pesanan['jam_akhir'][$a] = substr($key->jam_akhir,0,5);
							$pesanan['keperluan'][$a] = $key->keperluan;
							$pesanan['id_anggota'][$a] = $key->id_user;
							$pesanan['nama_anggota'][$a] = $key->nama;

							$a++;
						}	

						$data['jumlah_pesanan'] = $a;
						if ($a > 0) {
							$data['pesanan'] = $pesanan;
						}						
						
						#--------------- /.Pemesanan Peminjaman ---------------#

					# tampilkan data ke view
					$this->load->view('perpustakaan/entri_peminjaman_ruangan', $data); 
				
				# jika status anggota tidak Aktif muncul notif gagal
				}else{
					$this->session->set_flashdata('gagal', 'Status anggota dengan ID <b>'.$id_anggota.'</b> tidak aktif.');
					$data['id_anggota'] = $id_anggota;
					$this->load->view('perpustakaan/f_anggota_ruangan', $data); 					
				}
			# jika id_user tidak ditemukan muncul notif gagal
			}else{
				$this->session->set_flashdata('gagal', 'Data Anggota dengan ID <b>'.$id_anggota.'</b> tidak ditemukan, silahkan cek kembali data ID Anggota !!!');
				$data['id_anggota'] = $id_anggota;
				$this->load->view('perpustakaan/f_anggota_ruangan', $data); 
			}
		}

		$this->load->view('template/footer');	
    }

    function simpan_peminjaman_ruangan(){
    	$nrp = $this->session->userdata('nrp');
    	$id_ruangan = $this->input->post('id_ruangan', TRUE);
		$id_user = $this->input->post('id_user', TRUE);
		$jenis_pinjam = $this->input->post('jenis_pinjam', TRUE);
		$jumlah_santri = $this->input->post('jumlah_santri', TRUE);
		$tanggal_pinjam = date_db($this->input->post('tanggal_pinjam', TRUE));
		$jam_mulai = time_db($this->input->post('jam_mulai', TRUE));
		$jam_akhir = time_db($this->input->post('jam_akhir', TRUE));
		$keperluan = $this->input->post('keperluan', TRUE);

	//	date_default_timezone_set('Asia/Jakarta');
    //	$tanggal_sekarang = date('Y-m-d');

		$data = array(
			'id_pin_ruangan' => '',
			'id_ruangan' => $id_ruangan,
			'id_user' => $id_user, 
			'jenis_pinjam' => $jenis_pinjam,
			'jumlah_santri' => $jumlah_santri,
			'tanggal_pinjam' => $tanggal_pinjam,
			'jam_mulai' => $jam_mulai,
			'jam_akhir' => $jam_akhir,
			'keperluan' => $keperluan,
			'nrp' => $nrp
		);

		# proses simpan
		if ($this->m_models->save_data($data, "perpus_pinjaman_ruangan") == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}
		redirect('perpus/daftar_peminjaman_ruangan');    	
    }

    #daftar_peminjaman_ruangan
    function daftar_peminjaman_ruangan(){
        $this->load->view('template/header');
        $kolom_cari = $this->input->post('kolom_cari', TRUE); 
        $text_cari = $this->input->post('text_cari', TRUE);

        $data['kolom_cari'] = $kolom_cari;
        $data['text_cari'] = $text_cari;

        $text_cari = str_replace(" ","#", $text_cari);

        # kirim link ajax list penulis 
        $data['url_ajax'] = 'perpus/ajax_list_peminjaman_ruangan/'.$kolom_cari.'/'.$text_cari;

        # tampilkan data ke view
        $this->load->view('perpustakaan/daftar_peminjaman_ruangan', $data); 

        $this->load->view('template/footer');  
    }

    public function ajax_list_peminjaman_ruangan()
    {
         $table = 'perpus_pinjaman_ruangan';
         $column_order = array(null,'tanggal_pinjam' ,'perpus_ruangan.nama_ruangan','jenis_pinjam','id_user','perpus_anggota.nama','jumlah_santri', null, 'keperluan'); //set column field database for datatable orderable
         $order = array('id_pin_ruangan' => 'desc'); // default order 
         $column_search_external = $this->uri->segment(3);
         if ($column_search_external != null) {
            $column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
         }else{
            $column_search = array('id_pin_ruangan'); //set column field database for datatable searchable 
         }
         
         $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $pinjaman) {

        	# mencari judul koleksi
            
            $no++;
            $row = array();
            $row[] = number_format($no);
            $row[] = mediumdate_indo($pinjaman->tanggal_pinjam);
            $row[] = $pinjaman->nama_ruangan;
            $row[] = $pinjaman->jenis_pinjam;
            $row[] = $pinjaman->id_user;
            $row[] = $pinjaman->nama;
            $row[] = $pinjaman->jumlah_santri;
            $row[] = substr($pinjaman->jam_mulai,0,5).' - '.substr($pinjaman->jam_akhir,0,5);
            $row[] = $pinjaman->keperluan;
            $row[] = '<a href="#" class="hapus-record" data-id="'.$pinjaman->id_pin_ruangan.'"><button type="button" class="btn btn-danger" ><i class="fa fa-trash-o"></i></button></a>';

            $data[] = $row;
    
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function f_hapus_peminjaman_ruangan(){ 
		$this->load->view('template/head');
		$id_pinjaman = $this->input->post('id', TRUE);

		$data['pinjaman'] = $this->m_models->get_data("*", "perpus_pinjaman_ruangan", "WHERE id_pin_ruangan='$id_pinjaman' ");

		$this->load->view('perpustakaan/f_hapus_peminjaman_ruangan', $data); 
		$this->load->view('template/js');
	}

	function hapus_peminjaman_ruangan(){
		$id_pin_ruangan = $this->input->post('id_pin_ruangan', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_pin_ruangan, 'id_pin_ruangan', 'perpus_pinjaman_ruangan') == TRUE) {

			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/daftar_peminjaman_ruangan');
	}


    function entri_perbaikan(){
		$this->load->view('template/header');

		# tampilkan data ke view
		$this->load->view('perpustakaan/entri_perbaikan');

		$this->load->view('template/footer');	
    }

    function get_perbaikan_js(){
		$this->load->view('template/head');
		$kode_inv = $this->input->get('kode_inv'); 
		// echo $kode_inv;
		$exp = explode(" ", $kode_inv);

		$keranjang_tmp = array();
		$id_anggota = '';
		$a = 0;
		for ($i=0; $i <count($exp) ; $i++) { 
			$kode_inv = trim($exp[$i]);
			# cek ada ga kode inv yang dicari
			$jml_buku = $this->m_models->getRows("perpus_bahan_pustaka WHERE kode_inv='$kode_inv' ");
			if ($jml_buku > 0) {
				# cek tabel perbaikan apakah status masih proses atau sudah selesai
				$perbaikan = $this->m_models->getRows("perpus_perbaikan WHERE kode_inv='$kode_inv' AND 	tanggal_release='0000-00-00' ");
				
				if ($perbaikan == 0) {
					# cek barangkali sudah masuk keranjang
					if (in_array($kode_inv, $keranjang_tmp)) {
						$this->session->set_userdata('gagal', 'Item dengan No. Inventaris <b>'. $kode_inv .'</b> ini sudah masuk di daftar perbaikan');
					}else{
						#
						$arraywhere = array('perpus_bahan_pustaka.kode_inv' => $kode_inv);
						$buku = $this->perpus_models->getJoin1where("perpus_bahan_pustaka.kode_inv, perpus_biblio.judul, perpus_biblio.id_biblio", "perpus_bahan_pustaka", "perpus_biblio", "perpus_bahan_pustaka.id_biblio=perpus_biblio.id_biblio",
							$arraywhere, "kode_inv", "ASC");
						foreach ($buku as $key) {
								# mencari judul , penerbit
								$penerbit = $this->get_penerbit($key->id_biblio, "id_biblio");

								date_default_timezone_set('Asia/Jakarta');
								$tanggal_perbaikan = date('Y-m-d');

								/* ----- data untuk post tabel perbaikan --- */
								$data_buku['kode_inv'][$a] = $key->kode_inv;
								$data_buku['judul'][$a] = $key->judul;
								$data_buku['penerbit'][$a] = $penerbit;
								$data_buku['tanggal_perbaikan'][$a] = $tanggal_perbaikan;
								$a++;

								/* ----- /.data untuk post tabel perbaikan --- */

								# buat variable kode_inv temporary buat cek input kode yang sama
								$keranjang_tmp[] = $kode_inv; 

								# hapus jika ana sesion notif
								if ($this->session->has_userdata('gagal')) { 
								        $this->session->unset_userdata('gagal');
								}
						}
					}

				}else{
					$this->session->set_userdata('gagal', 'No. Inventaris <b>'.$kode_inv.'</b> masih dalam proses perbaikan.');	
				}

			# jika kode inv tidak ditemukan
			}else{
				$this->session->set_userdata('gagal', 'No. Inventaris <b>'.$kode_inv.'</b> tidak ditemukan dalam database.');			
			}
		}
		
		$data['jumlah_data'] = $a;
		if ($a > 0) {
			$data['buku'] = $data_buku;
			$this->load->view('perpustakaan/keranjang_perbaikan', $data);
		}else{
			$this->load->view('perpustakaan/notif_perpanjangan');
		}		

		$this->load->view('template/js');    	
    }

    function simpan_perbaikan(){
		$simpan = false;

		# ambil data yang di post
		$kode_inv = $this->input->post('kode_inv');
		$jml_buku = count($this->input->post('kode_inv'));
		$keterangan = $this->input->post('keterangan');

		date_default_timezone_set('Asia/Jakarta');
		$tanggal_perbaikan = date('Y-m-d');


		if ($jml_buku > 0) {
			for ($i = 0; $i < $jml_buku; $i++){ 
				$id = $kode_inv[$i];
				# array buat simpan di update tabel peminjaman
				$data[$i]['id_perbaikan'] = '';
				$data[$i]['kode_inv'] = $id;
				$data[$i]['tanggal_perbaikan'] = $tanggal_perbaikan;
				$data[$i]['tanggal_release'] = '0000-00-00';
				$data[$i]['keterangan'] = $keterangan[$id];

			}

			# proses simpan ke tabel perpus_perpanjangan
			$simpan = $this->m_models->save_batch($data, "perpus_perbaikan");
		}
			
		if ($simpan == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/perbaikan');
    }

    #daftar_perbaikan
    function perbaikan(){
        $this->load->view('template/header');
        $kolom_cari = $this->input->post('kolom_cari', TRUE); 
        $text_cari = $this->input->post('text_cari', TRUE);

        $data['kolom_cari'] = $kolom_cari;
        $data['text_cari'] = $text_cari;

        $text_cari = str_replace(" ","#", $text_cari);

        # kirim link ajax list penulis 
        $data['url_ajax'] = 'perpus/ajax_list_perbaikan/'.$kolom_cari.'/'.$text_cari;

        # tampilkan data ke view
        $this->load->view('perpustakaan/perbaikan', $data); 

        $this->load->view('template/footer');  
    }

    public function ajax_list_perbaikan()
    {
         $table = 'perpus_perbaikan';
         $column_order = array(null,'perpus_perbaikan.kode_inv', 'perpus_biblio.judul', null, 'perpus_perbaikan.tanggal_perbaikan', 'perpus_perbaikan.tanggal_release', 'perpus_perbaikan.keterangan', null); //set column field database for datatable orderable
         $order = array('perpus_perbaikan.id_perbaikan' => 'desc'); // default order 
         $column_search_external = $this->uri->segment(3);
         if ($column_search_external != null) {
            $column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
         }else{
            $column_search = array('perpus_perbaikan.id_perbaikan'); //set column field database for datatable searchable 
         }
         
         $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $perbaikan) {

        	# mencari judul koleksi
            $penerbit = $this->get_penerbit($perbaikan->id_biblio, "id_biblio");

            $no++;
            $row = array();
            $row[] = number_format($no);
            $row[] = $perbaikan->kode_inv;
            $row[] = $perbaikan->judul;
            $row[] = $penerbit;
            $row[] = shortdate_indo2($perbaikan->tanggal_perbaikan);
            if ($perbaikan->tanggal_release != '0000-00-00') {
            	$row[] = shortdate_indo2($perbaikan->tanggal_release);
            }else{
            	$row[] = '<a href="#" class="edit-record" data-id="'.$perbaikan->id_perbaikan.'"><button type="button" class="btn btn-success" >Release</button></a>';	
            }
            $row[] = $perbaikan->keterangan;
            $row[] = '<a href="#" class="hapus-record" data-id="'.$perbaikan->id_perbaikan.'"><button type="button" class="btn btn-danger" ><i class="fa fa-trash-o"></i></button></a>';


            $data[] = $row;
    
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function f_hapus_perbaikan(){ 
		$this->load->view('template/head');
		$id_perbaikan = $this->input->post('id', TRUE);

		$data['perbaikan'] = $this->m_models->get_data("*", "perpus_perbaikan", "WHERE id_perbaikan='$id_perbaikan' ");

		$this->load->view('perpustakaan/f_hapus_perbaikan', $data); 
		$this->load->view('template/js');
	}

	function hapus_perbaikan(){
		$id_perbaikan = $this->input->post('id_perbaikan', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_perbaikan, 'id_perbaikan', 'perpus_perbaikan') == TRUE) {

			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/perbaikan');
	}

	function f_release_perbaikan(){ 
		$this->load->view('template/head');
		$id_perbaikan = $this->input->post('id', TRUE);

		$data['perbaikan'] = $this->m_models->get_data("*", "perpus_perbaikan", "WHERE id_perbaikan='$id_perbaikan' ");

		$this->load->view('perpustakaan/f_release_perbaikan', $data); 
		$this->load->view('template/js');
	}

	function release_perbaikan(){
		$id_perbaikan = $this->input->post('id_perbaikan', TRUE);
		date_default_timezone_set('Asia/Jakarta');
		$tanggal_release = date('Y-m-d');

 		$data = array (
			'tanggal_release' => $tanggal_release
		);

		# proses update
		if ($this->m_models->update_data($id_perbaikan, 'id_perbaikan', $data, 'perpus_perbaikan') == TRUE) {

			$this->session->set_flashdata('sukses', 'Data berhasil direlease.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal direlease.');
		}

		redirect('perpus/perbaikan');
	}

	function komputer(){
		$this->load->view('template/header');

		# ambil data bahasa
		$data['komputer'] = $this->m_models->getAll("perpus_komputer ORDER BY nama_komputer ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/komputer', $data); 

		$this->load->view('template/footer');
	}

	function tambah_komputer(){
		$nama_komputer = $this->input->post('nama_komputer', TRUE);

		$jmldata = $this->m_models->getRowsWhere("id_komputer", "perpus_komputer", "nama_komputer", $nama_komputer, "id_komputer", "ASC");

		if ($jmldata == 0 ) {
			$data = array('id_komputer' => '', 'nama_komputer' => $nama_komputer);

			# proses simpan
			if ($this->m_models->save_data($data, "perpus_komputer") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Nama Komputer sudah ada.');
		}

		redirect('perpus/komputer'); 
	}

	function edit_komputer(){
		$nama_komputer = $this->input->post('nama_komputer', TRUE);
		$id_komputer = $this->input->post('id_komputer', TRUE);

		$jmldata = $this->m_models->getRowsWhere("id_komputer", "perpus_komputer", "nama_komputer", $nama_komputer, "id_komputer", "ASC");

		if ($jmldata == 0 ) {
			$data = array (
		   		'nama_komputer' => $nama_komputer
			);

			# proses simpan
			if ($this->m_models->update_data($id_komputer, 'id_komputer', $data, "perpus_komputer") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Nama Komputer sudah ada.');
		}
		redirect('perpus/komputer');
	}

	function hapus_komputer(){
		$id_komputer = $this->input->post('id_komputer', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_komputer, 'id_komputer', 'perpus_komputer') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/komputer');
	}	

	function ruangan(){
		$this->load->view('template/header');

		# ambil data bahasa
		$data['ruangan'] = $this->m_models->getAll("perpus_ruangan ORDER BY nama_ruangan ASC");

		# tampilkan data ke view
		$this->load->view('perpustakaan/ruangan', $data); 

		$this->load->view('template/footer');
	}

	function tambah_ruangan(){
		$nama_ruangan = $this->input->post('nama_ruangan', TRUE);

		$jmldata = $this->m_models->getRowsWhere("id_ruangan", "perpus_ruangan", "nama_ruangan", $nama_ruangan, "id_ruangan", "ASC");

		if ($jmldata == 0 ) {
			$data = array('id_ruangan' => '', 'nama_ruangan' => $nama_ruangan);

			# proses simpan
			if ($this->m_models->save_data($data, "perpus_ruangan") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Nama Ruangan sudah ada.');
		}

		redirect('perpus/ruangan'); 
	}

	function edit_ruangan(){
		$nama_ruangan = $this->input->post('nama_ruangan', TRUE);
		$id_ruangan = $this->input->post('id_ruangan', TRUE);

		$jmldata = $this->m_models->getRowsWhere("id_ruangan", "perpus_ruangan", "nama_ruangan", $nama_ruangan, "id_ruangan", "ASC");

		if ($jmldata == 0 ) {
			$data = array (
		   		'nama_ruangan' => $nama_ruangan
			);

			# proses simpan
			if ($this->m_models->update_data($id_ruangan, 'id_ruangan', $data, "perpus_ruangan") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Nama Ruangan sudah ada.');
		}
		redirect('perpus/ruangan');
	}

	function hapus_ruangan(){
		$id_ruangan = $this->input->post('id_ruangan', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($id_ruangan, 'id_ruangan', 'perpus_ruangan') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/ruangan');
	}

    function cetak_label(){
		$this->load->view('template/header');
		$kolom_cari = $this->input->post('kolom_cari');
		$text_cari = $this->input->post('text_cari');

		$data['kolom_cari'] = $kolom_cari;
		$data['text_cari'] = $text_cari;

		# mencari data buku
		if ($kolom_cari != NULL AND $text_cari != NULL) {
			$arraywhere = array( $kolom_cari.' LIKE ' => '%'.$text_cari.'%');
		//	$data['buku'] = $this->m_models->getJoin1where("perpus_biblio.judul, perpus_biblio.id_kategori_buku, perpus_biblio.no_panggil, perpus_bahan_pustaka.kode_inv, perpus_biblio.klasifikasi", "perpus_bahan_pustaka", "perpus_biblio", "perpus_bahan_pustaka.id_biblio=perpus_biblio.id_biblio", $arraywhere, "perpus_bahan_pustaka.kode_inv", "ASC");
			$data['buku'] = $this->perpus_models->getJoin4where("perpus_biblio.*, perpus_bahan_pustaka.kode_inv, perpus_penerbit.nama as nama_penerbit, perpus_tempat.nama_tempat, perpus_ddc.subjek", "perpus_bahan_pustaka", 
				"perpus_biblio", "perpus_bahan_pustaka.id_biblio=perpus_biblio.id_biblio",
				"perpus_penerbit", "perpus_biblio.id_penerbit=perpus_penerbit.id_penerbit",
				"perpus_tempat", "perpus_biblio.id_tempat=perpus_tempat.id_tempat",
				"perpus_ddc", "perpus_ddc.kode_ddc=perpus_biblio.klasifikasi",
				$arraywhere, "perpus_bahan_pustaka.kode_inv", "ASC");
			$kategori = $this->m_models->getAll("perpus_kategori_buku");
			foreach ($kategori as $key) {
			 	$kategori['nama'][$key->id_kategori_buku] = $key->nama;
			 	$kategori['label'][$key->id_kategori_buku] = $key->label;
			}

			$data['kategori'] = $kategori; 
		}else{
			$data['buku'] = array();
		}

		# tampilkan data ke view
		$this->load->view('perpustakaan/cetak_label2', $data); 

		$this->load->view('template/footer');	    	
    }

    function cetak_label_pdf(){
		$kode_inv = $this->input->post('kode_inv');
		$jml_data = count($this->input->post('kode_inv'));
		$kategori = $this->input->post('kategori');
		$judul = $this->input->post('judul');
		$no_panggil = $this->input->post('no_panggil');
		$klasifikasi = $this->input->post('klasifikasi');
		$data['pilih_label'] = $this->input->post('pilih_label');

		$data['jumlah_data'] = $jml_data;

		if ($jml_data > 0) {
			for ($i=0; $i < $jml_data; $i++) { 
				$kode = $kode_inv[$i];
				$kode_klas = $klasifikasi[$kode];

				$buku['kode_inv'][$i] = $kode;
				$buku['kategori'][$i] = $kategori[$kode];
				$buku['no_panggil'][$i] = $no_panggil[$kode];
				$buku['judul'][$i] = $judul[$kode];
				$buku['bg'][$i] = $this->getWarnaKlas($kode_klas);
			//	$buku['bg'][$i] = $kode_klas;

				# cetak barcode ambil nama filenya
				$file_barcode = $this->cetak_barcode($kode);
				$buku['barcode'][$i] = $file_barcode;
			}

			$data['buku'] = $buku;
		}
		$this->load->view('perpustakaan/cetak_label_pdf', $data);

	    $this->load->library('pdf');

	//    $customPaper = array(0,0,1122.519685,1122.519685);
		$this->pdf->setPaper('A3', 'potrait');
	   	$this->pdf->load_view('perpustakaan/cetak_label_pdf', $data);
	   	$this->pdf->render();

	   	$this->pdf->stream("Label-Buku.pdf", array('Attachment'=>0));    	
	   	 
    }

	function cetak_label_barcode_pdf(){
		$kode_inv = $this->input->post('kode_inv');
		$jml_data = count($this->input->post('kode_inv'));
		$kategori = $this->input->post('kategori');
		$judul = $this->input->post('judul');
		$no_panggil = $this->input->post('no_panggil');
		$klasifikasi = $this->input->post('klasifikasi');
		$data['pilih_label'] = $this->input->post('pilih_label');

		$data['jumlah_data'] = $jml_data;

		

		if ($jml_data > 0) {
			for ($i=0; $i < $jml_data; $i++) { 
				$kode = $kode_inv[$i];
				$kode_klas = $klasifikasi[$kode];

				$buku['kode_inv'][$i] = $kode;
				$buku['kategori'][$i] = $kategori[$kode];
				$buku['no_panggil'][$i] = $no_panggil[$kode];
				$buku['judul'][$i] = $judul[$kode];
				$buku['bg'][$i] = $this->getWarnaKlas($kode_klas);
			//	$buku['bg'][$i] = $kode_klas;

				# cetak barcode ambil nama filenya
				$file_barcode = $this->cetak_barcode($kode);
				$buku['barcode'][$i] = $file_barcode;
			}

			$data['buku'] = $buku;
		}
		$this->load->view('perpustakaan/cetak_label_barcode_pdf', $data);

	    $this->load->library('pdf');

	//    $customPaper = array(0,0,1122.519685,1122.519685);
		$this->pdf->setPaper('A3', 'potrait');
	   	$this->pdf->load_view('perpustakaan/cetak_label_barcode_pdf', $data);
	   	$this->pdf->render();

	   	$this->pdf->stream("Label-Buku.pdf", array('Attachment'=>0));    	
	   	 
    }

    function cetak_barcode($kode){
    	$this->load->library('zend');
		$this->zend->load('Zend/Barcode');

	//	Zend_Barcode::render('code39', 'image', array('text'=>$kode), array());
		$file = Zend_Barcode::draw('code39', 'image', array('text' => $kode), array());
    	$store_image = imagepng($file,"assets/barcode/buku/{$kode}.png");
    	return $kode.'.png';
    }

    function getWarnaKlas($klas){
    	$karakter_klas = strlen($klas);
    	if ( $karakter_klas > 0) {
    		$kode = substr($klas,0,1);
    	}else{
    		$kode = '';
    	}
    	
    	if ($kode == '0') {
    		return '#002060';
    	}elseif($kode == '1'){
    		return '#ffff00';
    	}elseif($kode == '2'){
    		return '#00b050';
    	}elseif($kode == '3'){
    		return '#7a30a0';
    	}elseif($kode == '4'){
    		return '#ff0000';
    	}elseif($kode == '5'){
    		return '#0030a0';
    	}elseif($kode == '6'){
    		return '#f79646';
    	}elseif($kode == '7'){
    		return '#f489d9';
    	}elseif($kode == '8'){
    		return '#92d050';
    	}elseif($kode == '9'){
    		return '#bfbfbf';
    	}else{
    		return '#FFFFFF';
    	}

    }

    function cetak_label_katalog(){
		$kode_inv = $this->input->post('kode_inv');
		$jml_data = count($this->input->post('kode_inv'));
		$kategori = $this->input->post('kategori');
		$judul = $this->input->post('judul');
		$no_panggil = $this->input->post('no_panggil');
		$klasifikasi = $this->input->post('klasifikasi');
		$data['jenis_katalog'] = $this->input->post('jenis_katalog');
		$judul_paralel = $this->input->post('judul_paralel');
		$judul_terjemah = $this->input->post('judul_terjemah');
		$nama_pengarang = $this->input->post('nama_pengarang');
		$pengarang_katalog = $this->input->post('pengarang_katalog');
		$edisi = $this->input->post('edisi');
		$nama_tempat = $this->input->post('nama_tempat');
		$nama_penerbit = $this->input->post('nama_penerbit');
		$tahun_terbit = $this->input->post('tahun_terbit');
		$deskripsi_fisik = $this->input->post('deskripsi_fisik');
		$isbn_issn = $this->input->post('isbn_issn');
		$subjek = $this->input->post('subjek');


		$data['jumlah_data'] = $jml_data;

		if ($jml_data > 0) {
			for ($i=0; $i < $jml_data; $i++) { 
				$kode = $kode_inv[$i];
				$kode_klas = $klasifikasi[$kode];

				$buku['kode_inv'][$i] = $kode;
				$buku['kategori'][$i] = $kategori[$kode];
				$buku['no_panggil'][$i] = $no_panggil[$kode];
				$buku['judul'][$i] = $judul[$kode];
				$buku['judul_paralel'][$i] = $judul_paralel[$kode];
				$buku['judul_terjemah'][$i] = $judul_terjemah[$kode];
				$buku['nama_pengarang'][$i] = $nama_pengarang[$kode];
				$buku['pengarang_katalog'][$i] = $pengarang_katalog[$kode];
				$buku['edisi'][$i] = $edisi[$kode];
				$buku['nama_tempat'][$i] = $nama_tempat[$kode];
				$buku['nama_penerbit'][$i] = $nama_penerbit[$kode];
				$buku['tahun_terbit'][$i] = $tahun_terbit[$kode];
				$buku['deskripsi_fisik'][$i] = $deskripsi_fisik[$kode];
				$buku['isbn_issn'][$i] = $isbn_issn[$kode];
				$buku['subjek'][$i] = $subjek[$kode];
			}

			$data['buku'] = $buku;
		}
		$this->load->view('perpustakaan/cetak_label_katalog', $data);

	    $this->load->library('pdf');

	//    $customPaper = array(0,0,472.440945,283.464567);
	//    $customPaper = array(0,0,491.33858268,321.25984252);
	    $customPaper = array(0,0,793.7007874,1122.519685);
	    $this->pdf->setPaper($customPaper);
	//	$this->pdf->setPaper('A4', 'potrait');
	   	$this->pdf->load_view('perpustakaan/cetak_label_katalog', $data);
	   	$this->pdf->render();

	   	$this->pdf->stream("Kartu-Katalog.pdf", array('Attachment'=>0));    	
	   	 
    }

	function cetak_label_cart(){
		$kode_inv = $this->input->post('kode_inv');
		$jml_data = count($this->input->post('kode_inv'));

		if ($jml_data > 0) {
			for ($i=0; $i < $jml_data; $i++) { 

				$data = array( 'kode_inv' => $kode_inv[$i] );
				$simpan = $this->m_models->save_data($data, "perpus_print_cart");
			}
		}

		redirect('perpus/print_cart');
    }

	function entri_kunjungan(){
		$this->load->view('template/header');

		$arraywhere = array('perpus_anggota.status' => 'Aktif');
		$data['anggota'] = $this->m_models->getJoin1where("perpus_anggota.*, perpus_instansi.nama as nama_instansi", "perpus_anggota", "perpus_instansi", "perpus_anggota.id_instansi=perpus_instansi.id_instansi", $arraywhere, "perpus_anggota.id_user", "ASC" );

		# tampilkan data ke view
		$this->load->view('perpustakaan/entri_kunjungan', $data); 

		$this->load->view('template/footer');
	}

    function simpan_kunjungan(){
		$proses = false;
		$simpan = $this->input->post('simpan', TRUE);	

		if ($simpan != null) {
			$anggota = $this->input->post('anggota');
			$jml_anggota = count($this->input->post('anggota'));
			$tanggal = date_db($this->input->post('tanggal'));

			$ta = $this->m_models->get_data("id_tahun", "tahun_akademik", "WHERE status_berjalan='ON'");
			$id_tahun = $ta[0]->id_tahun;
			
			for ($i=0; $i<$jml_anggota; $i++){
				$id_user = $anggota[$i];
				$anggota_perpus = $this->m_models->get_data("id_instansi", "perpus_anggota", "WHERE id_user='$id_user' ");
				# jika anggota adalah SDM maka yang diambil adalah id_sekolah buat di simpan di id_kelas
				if ($anggota_perpus[0]->id_instansi == '1') {
					$pegawai = $this->m_models->get_data("id_sekolah", "pegawai", "WHERE nrp='$id_user'");
					$id_kelas = $pegawai[0]->id_sekolah;

				}else{
					$jenjang = db_siswa($anggota[$i]);
					# mencari kelas	
					$arraywhere = array('rombongan_belajar_'.$jenjang.'.id_tahun' => $id_tahun, 
									'rombongan_belajar_'.$jenjang.'.id_siswa' => $anggota[$i]);
					$kelas = $this->m_models->getJoin1where("kelas.id_kelas", "rombongan_belajar_".$jenjang, "kelas", "rombongan_belajar_".$jenjang.".id_kelas=kelas.id_kelas", $arraywhere, "kelas.nama_kelas", "ASC");
					$id_kelas = $kelas[0]->id_kelas;
				}

					# masukan data ke array buat disimpan sekaligus
					$data[$i]['id_kunjungan'] = '';
					$data[$i]['waktu'] = $tanggal.' 10:00:00';
					$data[$i]['id_user'] = $id_user;
					$data[$i]['id_kelas'] = $id_kelas;
					$data[$i]['id_lokasi'] = 'PAM1';
					$data[$i]['tujuan'] = '';
					$data[$i]['is_anggota'] = '1';
					$data[$i]['no_pengunjung'] = '';
					$data[$i]['nama'] = '';
					$data[$i]['jk'] = '';
					$data[$i]['alamat'] = '';
					$data[$i]['pencatatan'] = 'M';
			}

			# proses simpan ke tabel perpus_kunjungan
			$proses = $this->m_models->save_batch($data, "perpus_kunjungan");

		}

		# proses simpan
		if ($proses == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
		}

		redirect('perpus/entri_kunjungan');
    }

    #kunjungan
    function kunjungan(){
        $this->load->view('template/header');
        $kolom_cari = $this->input->post('kolom_cari', TRUE); 
        $text_cari = $this->input->post('text_cari', TRUE);

        $data['kolom_cari'] = $kolom_cari;
        $data['text_cari'] = $text_cari;

        $text_cari = str_replace(" ","#", $text_cari);

        # kirim link ajax list penulis 
        $data['url_ajax'] = 'perpus/ajax_list_kunjungan/'.$kolom_cari.'/'.$text_cari;

        # tampilkan data ke view
        $this->load->view('perpustakaan/kunjungan', $data); 

        $this->load->view('template/footer');  
    }

    public function ajax_list_kunjungan()
    {
         $table = 'perpus_kunjungan';
         $column_order = array(null,'waktu', 'id_user', 'perpus_anggota.nama', 'pencatatan', null); //set column field database for datatable orderable
         $order = array('id_kunjungan' => 'desc'); // default order 
         $column_search_external = $this->uri->segment(3);
         if ($column_search_external != null) {
            $column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
         }else{
            $column_search = array('id_kunjungan'); //set column field database for datatable searchable 
         }
         
         $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $kunjungan) {
        	$exp = explode(" ", $kunjungan->waktu);
            
            $no++;
            $row = array();
            $row[] = number_format($no);
            $row[] = shortdate_indo2($exp[0]).' '.substr($exp[1], 0, 5);
            $row[] = $kunjungan->id_user;
            $row[] = $kunjungan->nama;
            $row[] = $kunjungan->instansi;
            $row[] = $kunjungan->pencatatan;
            $row[] = '<a href="#" class="hapus-record" data-id="'.$kunjungan->id_kunjungan.'"><button type="button" class="btn btn-danger" ><i class="fa fa-trash-o"></i></button></a>';

            $data[] = $row;
    
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function f_hapus_kunjungan(){ 
		$this->load->view('template/head');
		$id_kunjungan = $this->input->post('id', TRUE);

		$data['kunjungan'] = $this->m_models->get_data("perpus_kunjungan.*, perpus_anggota.nama", "perpus_kunjungan", "JOIN perpus_anggota ON perpus_anggota.id_user=perpus_kunjungan.id_user  WHERE id_kunjungan='$id_kunjungan' ");

		$this->load->view('perpustakaan/f_hapus_kunjungan', $data); 
		$this->load->view('template/js');
	}

	function hapus_kunjungan(){
		$id_kunjungan = $this->input->post('id_kunjungan', TRUE);
		# proses hapus
		# hapus ditabel kunjungan
		if ($this->m_models->delete_data($id_kunjungan, 'id_kunjungan', 'perpus_kunjungan') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/kunjungan');
	}

	function ddc(){
		$this->load->view('template/header');

		# kirim link ajax list penulis 
		$data['url_ajax'] = 'perpus/ajax_list_ddc';
 
		# tampilkan data ke view
		$this->load->view('perpustakaan/ddc', $data); 

		$this->load->view('template/footer');
	}

    public function ajax_list_ddc()
    {
    	 $table = 'perpus_ddc';
		 $column_order = array(null, 'kode_ddc', 'subjek'); //set column field database for datatable orderable
		 $order = array('kode_ddc' => 'asc'); // default order 
		 $column_search_external = $this->uri->segment(3);
		 if ($column_search_external != null) {
		 	$column_search = array($column_search_external); //set column field database for datatable searchable dari pencarian luar datatable
		 }else{
		 	$column_search = array('subjek'); //set column field database for datatable searchable 
		 }
		 
		 $search_external_value = $this->uri->segment(4);

        $list = $this->perpus_models->get_datatables($table, $column_order, $column_search, $order, $search_external_value);
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $ddc) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $ddc->kode_ddc;
            $row[] = $ddc->subjek;
            $row[] = '<div class="btn-group">
            			<a href="#" class="edit-record" data-id="'.$ddc->kode_ddc.'"><button type="button" class="btn btn-default btn-sm" ><i class="fa fa-edit"></i></button></a>
            			<a href="#" class="hapus-record" data-id="'.$ddc->kode_ddc.'"><button type="button" class="btn btn-default btn-sm" ><i class="fa fa-trash-o"></i></button></a>
                      </div>';

            $data[] = $row;
        }
 
        $output = array(
                        "draw" => $_POST['draw'],
                        "recordsTotal" => $this->perpus_models->count_all($table),
                        "recordsFiltered" => $this->perpus_models->count_filtered($table, $column_order, $column_search, $order, $search_external_value),
                        "data" => $data,
                );
        //output to json format
        echo json_encode($output);
    }

	function tambah_ddc(){
		$kode_ddc = $this->input->post('kode_ddc', TRUE);
		$subjek = $this->input->post('subjek', TRUE);

		$data = array(
			'kode_ddc' => $kode_ddc, 
			'subjek' => $subjek
		);

		# cek barangkali data kode sudah ada
		$data_ddc = $this->m_models->getRows("perpus_ddc WHERE kode_ddc='$kode_ddc' ");
		if ($data_ddc == 0) {
			# proses simpan
			if ($this->m_models->save_data($data, "perpus_ddc") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal disimpan.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Data DDC dengan Kode '.$kode_ddc.' sudah ada.');
		}

		redirect('perpus/ddc'); 
	}

	function f_edit_ddc(){ 
		$this->load->view('template/head');
		$kode_ddc = $this->input->post('id', TRUE);

		$data['ddc'] = $this->m_models->get_data("*", "perpus_ddc", "WHERE kode_ddc='$kode_ddc' ");

		$this->load->view('perpustakaan/f_edit_ddc', $data); 
		$this->load->view('template/js');
	}

	function edit_ddc(){
		$kode_ddc = $this->input->post('kode_ddc', TRUE);
		$kode_ddc_lama = $this->input->post('kode_ddc_lama', TRUE);
		$subjek = $this->input->post('subjek', TRUE);

		$data = array(
			'kode_ddc' => $kode_ddc, 
			'subjek' => $subjek
		);

		$data_ddc = $this->m_models->getRows("perpus_ddc WHERE kode_ddc='$kode_ddc' ");
		if ($data_ddc == 0) {
			# proses simpan
			if ($this->m_models->update_data($kode_ddc_lama, 'kode_ddc', $data, "perpus_ddc") == TRUE) {
				$this->session->set_flashdata('sukses', 'Data berhasil diupdate.');
			}else{
				$this->session->set_flashdata('gagal', 'Data gagal diupdate.');
			}
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal disimpan, Data DDC dengan Kode '.$kode_ddc.' sudah ada.');
		}

		redirect('perpus/ddc');
	}

	function f_hapus_ddc(){ 
		$this->load->view('template/head');
		$kode_ddc = $this->input->post('id', TRUE);

		$data['ddc'] = $this->m_models->get_data("*", "perpus_ddc", "WHERE kode_ddc='$kode_ddc' ");

		$this->load->view('perpustakaan/f_hapus_ddc', $data); 
		$this->load->view('template/js');
	}

	function hapus_ddc(){
		$kode_ddc = $this->input->post('kode_ddc', TRUE);

		# proses hapus
		if ($this->m_models->delete_data($kode_ddc, 'kode_ddc', 'perpus_ddc') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/ddc');
	}

	function hitung_hari_minggu($start_day, $end_day){
		$start = new DateTime($start_day);
		$end = new DateTime($end_day);
		$days = $start->diff($end, true)->days;

		$sundays = intval($days / 7) + ($start->format('N') + $days % 7 >= 7);

		return $sundays;
	}

    function add_print_cart(){
    	$kode_inv = $this->input->get('kode_inv'); 

    	$data_cart = $this->m_models->getRows("perpus_print_cart WHERE kode_inv='$kode_inv' ");
    	if ($data_cart == 0) {
    		$data = array( 'kode_inv' => $kode_inv );
			# proses simpan
			if ($this->m_models->save_data($data, "perpus_print_cart") == TRUE) {
				$hasil_proses = 1;
			}else{
				$hasil_proses = 0;
			}
    	}else{
    		$hasil_proses = 0;
		}

		$data['hasil_proses'] = $hasil_proses;
		$data['total_print_cart'] = $this->m_models->getRows("perpus_print_cart ");

		$this->load->view('perpustakaan/notif_print_cart', $data);
    }

    function load_print_cart(){
		$data['total_print_cart'] = $this->m_models->getRows("perpus_print_cart ");

		$this->load->view('perpustakaan/notif_print_cart', $data);
    }

	function print_cart(){
		$this->load->view('template/header');
			$data['buku'] = $this->perpus_models->getJoin5("perpus_biblio.*, perpus_bahan_pustaka.kode_inv, perpus_penerbit.nama as nama_penerbit, perpus_tempat.nama_tempat, perpus_ddc.subjek", "perpus_bahan_pustaka", 
				"perpus_biblio", "perpus_bahan_pustaka.id_biblio=perpus_biblio.id_biblio",
				"perpus_penerbit", "perpus_biblio.id_penerbit=perpus_penerbit.id_penerbit",
				"perpus_tempat", "perpus_biblio.id_tempat=perpus_tempat.id_tempat",
				"perpus_ddc", "perpus_ddc.kode_ddc=perpus_biblio.klasifikasi",
				"perpus_print_cart", "perpus_print_cart.kode_inv=perpus_bahan_pustaka.kode_inv",
				"perpus_bahan_pustaka.kode_inv", "ASC");
			$kategori = $this->m_models->getAll("perpus_kategori_buku");
			foreach ($kategori as $key) {
			 	$kategori['nama'][$key->id_kategori_buku] = $key->nama;
			 	$kategori['label'][$key->id_kategori_buku] = $key->label;
			}

			$data['kategori'] = $kategori; 

		# tampilkan data ke view
		$this->load->view('perpustakaan/print_cart', $data); 

		$this->load->view('template/footer');	
	}

	function hapus_print_cart(){
		if ($this->perpus_models->truncate_table('perpus_print_cart') == TRUE) {
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus.');
		}else{
			$this->session->set_flashdata('gagal', 'Data gagal dihapus.');
		}

		redirect('perpus/print_cart');		
	}
	
	# DOWNLOAD BIBLIOGRAFI #
	 public function download_biblio(){
    //menampilkan tampilan header konten
    $kolom_cari = $this->uri->segment(3);
	$tcar = $this->uri->segment(4);
    $text_cari = str_replace(' ','%20',$tcar);
	 
	
if($kolom_cari!=""){
	if($kolom_cari=="perpus_penulis.nama"){
		//$data['biblio'] = $this->m_models->get_data("perpus_biblio.*,perpus_biblio_pengarang.id_biblio_pengarang,perpus_penulis.nama","perpus_biblio_pengarang join perpus_biblio on perpus_biblio_pengarang.id_biblio = perpus_biblio.id_biblio join perpus_penulis on perpus_biblio_pengarang.id_penulis = perpus_penulis.id_penulis"," WHERE perpus_penulis.nama like '%$text_cari%' order by perpus_biblio.id_biblio asc ");
		$data['biblio'] = $this->m_models->get_data("perpus_biblio.*,perpus_biblio_pengarang.id_biblio_pengarang,perpus_penulis.nama","perpus_biblio_pengarang join perpus_biblio on perpus_biblio_pengarang.id_biblio = perpus_biblio.id_biblio join perpus_penulis on perpus_biblio_pengarang.id_penulis = perpus_penulis.id_penulis"," WHERE perpus_penulis.nama like '%$text_cari%' order by perpus_biblio.id_biblio asc ");		
	} else if ($kolom_cari=="perpus_tempat.nama_tempat"){
		$data['biblio'] = $this->m_models->get_data("*, perpus_tempat.nama_tempat","perpus_biblio join perpus_tempat on biblio.id_tempat = perpus_tempat.id_tempat"," WHERE perpus_tempat.nama_tempat like '%$text_cari%' order by id_biblio asc ");
	} else if ($kolom_cari=="perpus_penerbit.nama"){
		$data['biblio'] = $this->m_models->get_data("*, perpus_penerbit.nama","perpus_biblio join perpus_penerbit on biblio.id_penerbit = perpus_penerbit=id_penerbit"," WHERE perpus_penerbit.nama like '%$text_cari%' order by id_biblio asc ");
	} else {
		$data['biblio'] = $this->m_models->get_data("*","perpus_biblio"," WHERE $kolom_cari like '%$text_cari%' order by id_biblio asc ");
		
	}
} else {
	$data['biblio'] = $this->m_models->get_data("*","perpus_biblio"," WHERE id_biblio !='' order by id_biblio asc ");
}


// Menghitung jumlah inventaris
foreach ($data['biblio'] as $bli){
	$hitung = $this->m_models->getRows("perpus_bahan_pustaka where id_biblio = '$bli->id_biblio'");
	$arr_data['inv'][$bli->id_biblio] = $hitung;
}
		$data['inven'] = $arr_data;
    $this->load->view('perpustakaan/download_biblio',$data);
    //menampilkan tampilan footer
  }
  
  public function download_biblio_all(){
    //menampilkan tampilan header konten
  
	

	$data['biblio'] = $this->m_models->get_data("*","perpus_biblio"," WHERE id_biblio !='' order by id_biblio asc ");


// Menghitung jumlah inventaris
foreach ($data['biblio'] as $bli){
	$hitung = $this->m_models->getRows("perpus_bahan_pustaka where id_biblio = '$bli->id_biblio'");
	
	$arr_data['inv'][$bli->id_biblio] = $hitung;
	
	
	
}
		$data['inven'] = $arr_data;
    $this->load->view('perpustakaan/download_biblio_all',$data);
    //menampilkan tampilan footer
  }

 
}