<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Penggajian extends CI_Controller {
	function __construct(){
	    error_reporting(0);
		parent::__construct();
        $this->load->library(array('PHPExcel','PHPExcel/IOFactory'));
		$this->load->helper('url');
		$this->load->helper('file');
		$this->load->helper('global');
        $this->load->library('pagination');
		if (!isset($this->session->userdata['id_pengguna'])) {
			redirect(base_url("login"));
		}
		$this->load->model('m_models');
		$this->load->library('datatables');
	}

	# setting nominal untuk tunjangan2 di penggajian
	public function setting_tunj(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp']; 

		$tunj = $this->input->post('tunj', TRUE); 
		$nominal = nominalIndo($this->input->post('nominal', TRUE)); 
		$kategori = nominalIndo($this->input->post('kategori', TRUE)); 
		if (($tunj != "") && ($nominal != "")&& ($kategori != "")){
			$hariini=date("Y-m-d");
			$j_off= array('rumus'=>$nominal, 'nrp'=>$nrp, 'tgl'=>$hariini, 'kategori'=>$kategori);
			if ($this->m_models->update_data($tunj, "id_rumus", $j_off, "k_gaji_rumus") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('penggajian/setting_tunj');
		}

		$data['jenis'] = $this->m_models->getTabelOrder("*", "k_gaji_rumus", "keterangan", "asc");
		
		$this->load->view('penggajian/set_tunj', $data);
		$this->load->view('template/footer');
	}


	public function cektunj(){ 
		$id_rumus = $this->input->get('tunj', TRUE);  

		$data['tunj']=$this->m_models->getwhere("*", "k_gaji_rumus", "id_rumus", $id_rumus, "id_rumus", "desc");
		$data['nominal']=$data[tunj][0]->rumus;
		$data['nm_tunj']=$data[tunj][0]->keterangan;
		$data['kategori']=$data[tunj][0]->kategori;
		$this->load->view('penggajian/cektunj', $data);
	}

	# setting tunjangan syari (tunjangan untuk lulusan yg dari mesir, dll sebagai bentuk penghargaan)
	public function setting_tunj_syari(){
		$this->load->view('template/header'); 
		$nrp_petugas=$this->session->userdata['nrp']; 

		$ar = array('status_aktif =' => 'on');
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar, "nama", "asc");
		$data['tunj_syari'] = $this->m_models->getTabelOrder("*", "k_gaji_tunjsyari", "nominal", "asc");
		$hariini=date("Y-m-d");

		$no = $this->input->post('no', TRUE); 
		$nrp = $this->input->post('nrp', TRUE); 
		if ($no != ""){
			for ($i=0; $i < $no; $i++) { 
			 	$nrp_peg=$nrp[$i]; 
			 	if ($nrp_peg != ""){
					$nominal = nominalIndo($this->input->post('nominal'.$nrp_peg, TRUE)); 
					$ket = $this->input->post('ket'.$nrp_peg, TRUE);

					if (($nominal != "") && ($ket != "") && ($nrp_peg != "")){ 
						$ar_cat = array('nrp'=>$nrp_peg, 'nominal' => $nominal, 'keterangan'=>$ket, 'tgl'=>$hariini, 'petugas'=>$nrp_petugas);
						$simpan=$this->m_models->save_data($ar_cat, 'k_gaji_tunjsyari');
					}
			 	}
			} 

			if ($simpan == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('penggajian/setting_tunj_syari');
		}
			

		$this->load->view('penggajian/setting_tunj_syari', $data);
		$this->load->view('penggajian/edit_tunj_syari', $data);
		$this->load->view('template/footer');
	}

	public function cekpegawai(){ 
		$id_sekolah = $this->input->get('id_sekolah', TRUE);  

		$as=array('status_aktf =' => 'Aktif', 'id_sekolah'=>$id_sekolah);
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $as, "nama", "asc");

		$this->load->view('penggajian/cekpegawai', $data);
	}


	public function edit_tunj_syari(){ 
		$nrp_petugas=$this->session->userdata['nrp']; 
		$id_tunj_syari = $this->input->post('id_tunj_syari', TRUE);  
		$nominal = nominalIndo($this->input->post('nominal', TRUE));  
		$ket = $this->input->post('ket', TRUE);  

		if (($id_tunj_syari != "")&&($nominal != "")&&($ket != "")){
			$hariini=date("Y-m-d");
			$j_off= array('nominal'=>$nominal, 'petugas'=>$nrp_petugas, 'tgl'=>$hariini);
			if ($this->m_models->update_data($id_tunj_syari, "id_tunj_syari", $j_off, "k_gaji_tunjsyari") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('penggajian/setting_tunj_syari');
		}
		$this->load->view('penggajian/edit_tunj_syari', $data);
	}

	public function hapus_tunj_syari(){ 
		$nrp_petugas=$this->session->userdata['nrp']; 
		$id = $this->uri->segment(3); 

		if ($this->m_models->delete_data($id, "id_tunj_syari", "k_gaji_tunjsyari") == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/setting_tunj_syari');

		$this->load->view('penggajian/hapus_tunj_syari', $data);
	}


	# input nominal untuk potongan gaji berdasarkan jenis potongan
	public function potongan_gaji(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah"); 

		if (($id_sekolah=="18") or ($id_sekolah=="8")){
	    	$ar_div = array('status_aktif' => "on");
		} else {
			$ar_div = array('status_aktif' => "on", 'id_sekolah'=>$id_sekolah);
		}
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");

	    $ar=array('status' => "on");
		$data['jenis_potongan'] = $this->m_models->getTabelwhere("*", "k_jenis_potgaji", $ar, "jenis_pot", "asc");

  		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_on']=date("Y");
		$data['bln_now']=date("m");

		$bln = $this->input->post('bln', TRUE);  
		$tahun = $this->input->post('tahun', TRUE);  
		$jenjang = $this->input->post('jenjang', TRUE);  
		$periode = $tahun."-".$bln."-00";
		if (($periode != "") && ($jenjang != "")){ 
			$ar_pot=array('periode' => $periode, 'id_sekolah'=>$jenjang);
			$data['potongan'] = $this->m_models->getTabelwhere("*", "k_gaji_pot", $ar_pot, "nrp", "asc");
		}


		$this->load->view('penggajian/potongan_gaji', $data);
		$this->load->view('template/footer');
	}


	public function cekpotpegawai(){ 
		$id_sekolah = $this->input->get('id_sekolah', TRUE);  

		$as=array('status_aktf =' => 'Aktif', 'id_sekolah'=>$id_sekolah);
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $as, "nama", "asc");

		$this->load->view('penggajian/cekpotpegawai', $data);
	}

	public function simpan_pot_gaji(){ 
		$nrp=$this->session->userdata['nrp'];

		$jenis_potongan = $this->input->post('jenis_potongan', TRUE); 
		$id_sekolah = $this->input->post('id_sekolah', TRUE); 
		$no = $this->input->post('no', TRUE); 
		$dt_nrp = $this->input->post('nrp', TRUE);
		$bln = $this->input->post('bln', TRUE);
		$tahun = $this->input->post('tahun', TRUE);
		$periode= $tahun."-".$bln."-00";
		$hariini=date("Y-m-d");
		for ($i=0; $i <= $no; $i++) { 
			$nrp_peg=$dt_nrp[$i];
			$nominal = nominalIndo($this->input->post('nominal'.$nrp_peg, TRUE));
			$ket = $this->input->post('ket'.$nrp_peg, TRUE);

			if (($jenis_potongan != "") && ($id_sekolah != "") && ($periode != "") && ($nrp_peg != "") && ($nominal != "")){
				$ar_cat = array('id_jenispot'=>$jenis_potongan, 'nrp' => $nrp_peg, 'id_sekolah'=>$id_sekolah, 'periode'=>$periode, 'nominal'=>$nominal, 'keterangan'=>$ket, 'tgl_input'=>$hariini, 'petugas'=>$nrp);
				$simpan = $this->m_models->save_data($ar_cat, 'k_gaji_pot');
			}
		}
		if ($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/potongan_gaji');
	}

	public function hapus_pot_gaji(){ 
		$nrp_petugas=$this->session->userdata['nrp']; 
		$id = $this->uri->segment(3); 

		if ($this->m_models->delete_data($id, "id_pot_gaji", "k_gaji_pot") == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil dihapus');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/potongan_gaji');
	}



	# data untuk menginputkan/ meng on off jenis potongan 
	public function jenis_potongan(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];

		$jenis = $this->input->post('jenis', TRUE); 
		$ket = $this->input->post('ket', TRUE); 
		$hariini=date("Y-m-d");
		if (($jenis != "") && ($ket != "")){
			$ar_cat = array('nrp'=>$nrp, 'jenis_pot' => $jenis, 'keterangan'=>$ket, 'tgl'=>$hariini, 'status'=>'on');
			if ($this->m_models->save_data($ar_cat, 'k_jenis_potgaji') == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('penggajian/jenis_potongan');
		}

		$data['jenis_potongan'] = $this->m_models->getTabelOrder("*", "k_jenis_potgaji", "jenis_pot", "asc");
		

		$this->load->view('penggajian/jenis_pot_gaji', $data);
		$this->load->view('template/footer');
	}

	public function update_j_pot(){
		$nrp=$this->session->userdata['nrp']; 

		$id_jenispot = $this->uri->segment(3); 
		$ket = $this->uri->segment(4); 
		
		if (($id_jenispot != "") && ($ket != "")){
			$hariini=date("Y-m-d");
			$j_off= array('status'=>$ket, 'tgl'=>$hariini, 'nrp'=>$nrp);
			if ($this->m_models->update_data($id_jenispot, "id_jenispot", $j_off, "k_jenis_potgaji") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('penggajian/jenis_potongan');
		}
	}


	# setting untuk gaji pokok
	public function setting_gaji_pokok(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];

		$data['golongan'] = $this->m_models->getTabelOrder("*", "golongan", "golongan", "asc");
		$data['tingkat_pendidikan'] = $this->m_models->getTabelOrder("*", "tingkat_pendidikan", "id_tp", "asc");

		//$data['gapok'] = $this->m_models->getJoin2("*", "k_gaji_pokok", "tingkat_pendidikan", "tingkat_pendidikan.id_tp=k_gaji_pokok.id_tp", "golongan", "golongan.id_golongan=k_gaji_pokok.id_golongan", "k_gaji_pokok.nrp", "asc");
		$data['gapok'] = $this->m_models->getJoin1("*", "k_gaji_pokok", "golongan", "golongan.id_golongan=k_gaji_pokok.id_golongan", "k_gaji_pokok.nrp", "asc");

		$this->load->view('penggajian/set_gapok', $data);
		$this->load->view('penggajian/edit_gapok', $data);
		$this->load->view('template/footer');
	}

	public function simpan_set_gapok(){
		$nrp=$this->session->userdata['nrp'];

		$pendidikan = $this->input->post('pendidikan', TRUE); 
		$golongan = $this->input->post('golongan', TRUE); 
		$nominal = nominalIndo($this->input->post('nominal', TRUE)); 

		$hariini=date("Y-m-d");
		$ar_cat = array('id_golongan' => $golongan, 'nominal'=>$nominal, 'tgl'=>$hariini, 'nrp'=>$nrp);
		$simpan = $this->m_models->save_data($ar_cat, 'k_gaji_pokok');
		if ($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/setting_gaji_pokok');
	}

	public function edit_gapok(){ 
		$nrp_petugas=$this->session->userdata['nrp']; 
		$id = $this->input->post('id'); 
		$data['id'] = $this->input->post('id'); 
		$data['id_tp']=all("k_gaji_pokok", "id_gapok", $id, "id_tp");
		$data['id_golongan']=all("k_gaji_pokok", "id_gapok", $id, "id_golongan");
		$data['nominal']=all("k_gaji_pokok", "id_gapok", $id, "nominal");

		$data['golongan'] = $this->m_models->getTabelOrder("*", "golongan", "golongan", "asc");
		$data['tingkat_pendidikan'] = $this->m_models->getTabelOrder("*", "tingkat_pendidikan", "id_tp", "asc");


		$this->load->view('penggajian/edit_gapok', $data);
	}

	public function update_gapok(){ 
		$nrp_petugas=$this->session->userdata['nrp']; 
		$id_gapok = $this->input->post('id_gapok', TRUE);  
		$nominal = nominalIndo($this->input->post('nominal', TRUE));  
		$pendidikan = $this->input->post('pendidikan', TRUE);  
		$golongan = $this->input->post('golongan', TRUE);  

		 if (($id_gapok != "")&&($nominal != "")&&($pendidikan != "")&&($golongan != "")){
			$hariini=date("Y-m-d");
			$j_off= array('id_tp'=>$pendidikan, 'id_golongan'=>$golongan, 'nominal'=>$nominal, 'tgl'=>$hariini, 'nrp'=>$nrp_petugas);
			if ($this->m_models->update_data($id_gapok, "id_gapok", $j_off, "k_gaji_pokok") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('penggajian/setting_gaji_pokok');
		} 
	}

	# setting tunjangan jabatan
	public function setting_tunj_jab(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$hariini=date("Y-m-d");

  		$data['jabatan'] = $this->m_models->getTabelOrder("*", "jabatan", "nama_jabatan", "asc");
		$id_jabatan = $this->input->post('jabatan', TRUE);  
		$nominal = nominalIndo($this->input->post('nominal', TRUE));  
		if (($id_jabatan != "") && ($nominal != "")){
			$ar_cat = array('id_jabatan'=>$id_jabatan, 'nominal' => $nominal, 'tgl'=>$hariini, 'petugas'=>$nrp);
			$simpan=$this->m_models->save_data($ar_cat, 'k_gaji_tunjabatan');

			if ($simpan == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('penggajian/setting_tunj_jab');
		}

  		$data['tunj_jab']=$this->m_models->getJoin1("*", "k_gaji_tunjabatan", "jabatan", "k_gaji_tunjabatan.id_jabatan=jabatan.id_jabatan", "nama_jabatan", "asc");


		$this->load->view('penggajian/set_tunj_jabatan', $data);
		$this->load->view('penggajian/edit_tunj_jab', $data);
		$this->load->view('template/footer');
	}
	

	public function edit_tunj_jab(){ 
		$nrp_petugas=$this->session->userdata['nrp']; 
		$id = $this->input->post('id', TRUE);  
  		$data['jabatan'] = $this->m_models->getTabelOrder("*", "jabatan", "nama_jabatan", "asc");
		$data['id']=$id;
		$data['id_jabatan']=all("k_gaji_tunjabatan", "id_t_jab", $id, "id_jabatan");
		$data['nominal']=all("k_gaji_tunjabatan", "id_t_jab", $id, "nominal");

		$nominal = nominalIndo($this->input->post('nominal', TRUE));  
		$jabatan = $this->input->post('jabatan', TRUE);  
		$id_t_jab = $this->input->post('id', TRUE);  

		if (($jabatan != "")&&($nominal != "")&&($id != "")){
			$hariini=date("Y-m-d");
			$j_off= array('nominal'=>$nominal, 'id_jabatan'=>$jabatan, 'tgl'=>$hariini, 'petugas'=>$nrp_petugas);
			if ($this->m_models->update_data($id_t_jab, "id_t_jab", $j_off, "k_gaji_tunjabatan") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('penggajian/setting_tunj_jab');
		}
		$this->load->view('penggajian/edit_tunj_jab', $data);
	}




	# ajuan penggajian karyawan
	public function ajuan_penggajian(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah"); 

		if (($id_sekolah=="18") or ($id_sekolah=="8")){
	    	$ar_div = array('status_aktif' => "on");
		} else {
			$ar_div = array('status_aktif' => "on", 'id_sekolah'=>$id_sekolah);
		}
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");

	    $ar=array('status' => "on");
		$data['jenis_potongan'] = $this->m_models->getTabelwhere("*", "k_jenis_potgaji", $ar, "jenis_pot", "asc");

  		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_on']=date("Y");
		$data['bln_now']=date("m");

		$data['akun']=$this->m_models->getAll("akun where (id_akun like '1.1.1.%' or id_akun like '1.1.3.%') and id_akun in (select id_akun from pilihan_akun where id_sekolah='$id_sekolah' and status='on' ) order by nama_akun asc ");

		$bln = $this->input->post('bln', TRUE);  
		$tahun = $this->input->post('tahun', TRUE);  
		$jenjang = $this->input->post('jenjang', TRUE);  
		$periode = $tahun."-".$bln."-00";
		if (($periode != "") && ($jenjang != "")){
			$data['periode']=$tahun."-".$bln;
			$ar_pot=array('status_aktf' => 'Aktif', 'id_sekolah'=>$jenjang);
			//$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $ar_pot, "nama", "asc");
			$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' and id_sekolah='$jenjang' and nrp not in (select nrp from k_gaji_eksklusif where nominal != 0) and nrp not in (select nrp from k_gaji where periode='$periode') order by nama asc");

			$arp=array('status' => 'on');
			$data['jenis_pot'] = $this->m_models->getRowsAWhere("*", "k_jenis_potgaji", $arp, "id_jenispot", "asc");
			$data['jenispot'] = $this->m_models->getTabelwhere("*", "k_jenis_potgaji", $arp, "id_jenispot", "asc");

			$ket_sekolah=all("sekolah", "id_sekolah", $jenjang, "kategori");
			if ($ket_sekolah=="Sekolah"){
				$this->load->view('penggajian/ajuan_penggajian', $data);
			} else if ($ket_sekolah=="Non Sekolah"){
				//Dapur
				if (($jenjang=="10") or ($jenjang=="11")){
					$this->load->view('penggajian/penggajian_dapur', $data);
				} else {
					$this->load->view('penggajian/penggajian_nonsekolah', $data);
				}
			}
		} else {
			$this->load->view('penggajian/ajuan_penggajian', $data);
		}
		
		$this->load->view('template/footer');
	}

	public function simpan_ajuan_gaji(){
		$petugas=$this->session->userdata['nrp'];

		$nrp = $this->input->post('nrp', TRUE); 
		$no_peg = $this->input->post('no_peg', TRUE); 
		$no = $this->input->post('no', TRUE); 
		$periode = $this->input->post('periode', TRUE); 
		$akun1 = $this->input->post('akun', TRUE);  
		
		$hariini=date("Y-m-d");
		for ($i=0; $i <= $no_peg; $i++){ 
			$nrp_peg=$nrp[$i];
			if ($nrp_peg != ""){
				$id_sekolah = $this->input->post('id_sekolah'.$nrp_peg, TRUE); 
				$id_jabatan = $this->input->post('id_jabatan'.$nrp_peg, TRUE); 
				//potongan
				for ($j=0; $j <= $no ; $j++){
					$pot = $this->input->post('potongan', TRUE); 
					if ($pot[$j] != ""){
						$potongan[$j] = $pot[$j];
					} else {
						$potongan[$j] = 0;
					}
				}

				if ($id_sekolah=="7"){
					$akun2 = "5.10.2.01";
				} else {
					$akun2 = "5.21.1.01";
				}

				//tunjangan-tunjangan
				$gapok = $this->input->post('gapok'.$nrp_peg, TRUE); 
				$tunj_jabatan = $this->input->post('tunj_jabatan'.$nrp_peg, TRUE); 
				$tunjangan_si = $this->input->post('tunjangan_si'.$nrp_peg, TRUE); 
				$tunjangan_anak = $this->input->post('tunjangan_anak'.$nrp_peg, TRUE); 
				$tunjangan_syari = $this->input->post('tunjangan_syari'.$nrp_peg, TRUE); 
				$tunjangan_lamakerja = $this->input->post('tunjangan_lamakerja'.$nrp_peg, TRUE); 
				$tunjangan_transport = $this->input->post('tunjangan_transport'.$nrp_peg, TRUE); 
				$tunjangan_hadir_rapat = $this->input->post('tunjangan_hadir_rapat'.$nrp_peg, TRUE); 
				$tunjangan_hadir_kjm = $this->input->post('tunjangan_hadir_kjm'.$nrp_peg, TRUE); 
				$tunjangan_hadir_tahfidz = $this->input->post('tunjangan_hadir_tahfidz'.$nrp_peg, TRUE); 
				$tunjangan_hadir_bahasa = $this->input->post('tunjangan_hadir_bahasa'.$nrp_peg, TRUE); 
				$tunjangan_hadir_piket = $this->input->post('tunjangan_hadir_piket'.$nrp_peg, TRUE); 
				$tunjangan_hadir_bljrmlm = $this->input->post('tunjangan_hadir_bljrmlm'.$nrp_peg, TRUE); 
				$tunjangan_hadir_kajian_ltq = $this->input->post('tunjangan_hadir_kajian_ltq'.$nrp_peg, TRUE); 
				$tunjangan_hadir_temporer = $this->input->post('tunjangan_hadir_temporer'.$nrp_peg, TRUE); 
				$tunjangan_hadir_lain = $this->input->post('tunjangan_hadir_lain'.$nrp_peg, TRUE); 



				if ($potongan[0] != ""){ $potongan1=$potongan[0]; } else { $potongan1=0; }
				if ($potongan[1] != ""){ $potongan2=$potongan[1]; } else { $potongan2=0; }
				if ($potongan[2] != ""){ $potongan3=$potongan[2]; } else { $potongan3=0; }
				if ($potongan[3] != ""){ $potongan4=$potongan[3]; } else { $potongan4=0; }
				if ($potongan[4] != ""){ $potongan5=$potongan[4]; } else { $potongan5=0; }
				if ($potongan[5] != ""){ $potongan6=$potongan[5]; } else { $potongan6=0; }
				if ($potongan[6] != ""){ $potongan7=$potongan[6]; } else { $potongan7=0; }
				if ($potongan[7] != ""){ $potongan8=$potongan[7]; } else { $potongan8=0; }
				if ($potongan[8] != ""){ $potongan9=$potongan[8]; } else { $potongan9=0; }
				if ($potongan[9] != ""){ $potongan10=$potongan[9]; } else { $potongan10=0; }
				if ($potongan[10] != ""){ $potongan11=$potongan[10]; } else { $potongan11=0; }
				if ($potongan[11] != ""){ $potongan12=$potongan[11]; } else { $potongan12=0; }
				if ($potongan[12] != ""){ $potongan13=$potongan[12]; } else { $potongan13=0; }
				if ($potongan[13] != ""){ $potongan14=$potongan[13]; } else { $potongan14=0; }
				if ($potongan[14] != ""){ $potongan15=$potongan[14]; } else { $potongan15=0; }
				if ($potongan[15] != ""){ $potongan16=$potongan[15]; } else { $potongan16=0; }
				if ($potongan[16] != ""){ $potongan17=$potongan[16]; } else { $potongan17=0; }
				if ($potongan[17] != ""){ $potongan18=$potongan[17]; } else { $potongan18=0; }
				if ($potongan[18] != ""){ $potongan19=$potongan[18]; } else { $potongan19=0; }
				if ($potongan[19] != ""){ $potongan20=$potongan[19]; } else { $potongan20=0; }


				if (($periode != "") && ($nrp_peg != "")){
					$ar_cat = array('petugas'=>$petugas, 'tanggal' => $hariini, 'periode'=>$periode, 'nrp'=>$nrp_peg, 'id_jabatan'=>$id_jabatan, 'id_sekolah'=>$id_sekolah, 'gaji_pokok'=>$gapok, 'tunj_jabatan'=>$tunj_jabatan, 'tunj_istri'=>$tunjangan_si, 'tunj_anak'=>$tunjangan_anak, 'tunj_syari'=>$tunjangan_syari, 'tunj_lamakerja'=>$tunjangan_lamakerja, 'transport'=>$tunjangan_transport, 'hadir_rapat'=>$tunjangan_hadir_rapat, 'kjm'=>$tunjangan_hadir_kjm, 'tahfidz'=>$tunjangan_hadir_tahfidz, 'bahasa'=>$tunjangan_hadir_bahasa, 'piket'=>$tunjangan_hadir_piket, 'belajar_mlm'=>$tunjangan_hadir_bljrmlm, 'kajian_ltq'=>$tunjangan_hadir_kajian_ltq, 'tunj_temporer'=>$tunjangan_hadir_temporer, 'tunj_lain'=>$tunjangan_hadir_lain,'potongan1'=>$potongan1, 'potongan2'=>$potongan2, 'potongan3'=>$potongan3, 'potongan4'=>$potongan4, 'potongan5'=>$potongan5, 'potongan6'=>$potongan6, 'potongan7'=>$potongan7, 'potongan8'=>$potongan8, 'potongan9'=>$potongan9, 'potongan10'=>$potongan10, 'potongan11'=>$potongan11, 'potongan12'=>$potongan12, 'potongan13'=>$potongan13, 'potongan14'=>$potongan14, 'potongan15'=>$potongan15, 'potongan16'=>$potongan16, 'potongan17'=>$potongan17, 'potongan18'=>$potongan18, 'potongan19'=>$potongan19, 'potongan20'=>$potongan20, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Proses', 'ket'=>'Sekolah');
						$simpan = $this->m_models->save_data($ar_cat, 'k_gaji');

						//menghitung thp
						$pemasukan=$gapok+$tunj_jabatan+$tunjangan_si+$tunjangan_anak+$tunjangan_syari+$tunjangan_lamakerja+$tunjangan_transport+$tunjangan_hadir_rapat+$tunjangan_hadir_kjm+$tunjangan_hadir_tahfidz+$tunjangan_hadir_bahasa+$tunjangan_hadir_piket+$tunjangan_hadir_bljrmlm+$tunjangan_hadir_kajian_ltq+$tunjangan_hadir_temporer+$tunjangan_hadir_lain;
						$potongan=$potongan1+$potongan2+$potongan3+$potongan4+$potongan5+$potongan6+$potongan7+$potongan8+$potongan9+$potongan10+$potongan11+$potongan12+$potongan13+$potongan14+$potongan15+$potongan16+$potongan17+$potongan18+$potongan19+$potongan20;
						$thp=$pemasukan-$potongan;
						$total_thp += $thp;
				}
				/*#simpan ke jurnal
				$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 	
				$nm_divisi=all("sekolah", "id_sekolah", $id_sekolah, "nama");
				$uraian="Beban gaji pegawai ".$nm_divisi;
		   		$no_jurnal=array('tgl' => $hariini, 'no_transaksi' => $no_transaksi, 'akun1' => $akun2, 'uraian1' => $uraian, 'debet1' => $total_thp, 'kredit1' => "0", 'akun2' => $akun1, 'uraian2' => $uraian, 'debet2' => "0", 'kredit2' => $total_thp, 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => "mutasi kas", 'id_tahun'=>$tahun, 'nrp'=> $nrp); 
		       	$simpan_jurnal=$this->m_models->save_data($no_jurnal, "jurnal");*/
			}
		}

		if ($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/ajuan_penggajian');
	}
	
	
	public function simpan_gaji_nonsekolah(){
		$petugas=$this->session->userdata['nrp'];

		$nrp = $this->input->post('nrp', TRUE); 
		$no_peg = $this->input->post('no_peg', TRUE); 
		$no = $this->input->post('no', TRUE); 
		$periode = $this->input->post('periode', TRUE); 
		$akun1 = $this->input->post('akun', TRUE);  
		$hariini=date("Y-m-d");
		for ($i=0; $i <= $no_peg; $i++){ 
			$nrp_peg=$nrp[$i];
			if ($nrp_peg != ""){
				$id_sekolah = $this->input->post('id_sekolah'.$nrp_peg, TRUE); 
				$id_jabatan = $this->input->post('id_jabatan'.$nrp_peg, TRUE); 
				//potongan
				for ($j=0; $j <= $no ; $j++){
					$pot = $this->input->post('potongan', TRUE); 
					if ($pot[$j] != ""){
						$potongan[$j] = $pot[$j];
					} else {
						$potongan[$j] = 0;
					}
				}

				if ($id_sekolah=="7"){
					$akun2 = "5.10.2.01";
				} else {
					$akun2 = "5.21.1.01";
				}

				//tunjangan-tunjangan
				$gapok = $this->input->post('gapok'.$nrp_peg, TRUE); 
				$tunj_jabatan = $this->input->post('tunj_jabatan'.$nrp_peg, TRUE); 
				$tunjangan_si = $this->input->post('tunjangan_si'.$nrp_peg, TRUE); 
				$tunjangan_anak = $this->input->post('tunjangan_anak'.$nrp_peg, TRUE); 
				$tunjangan_syari = $this->input->post('tunjangan_syari'.$nrp_peg, TRUE); 
				$tunjangan_lamakerja = $this->input->post('tunjangan_lamakerja'.$nrp_peg, TRUE); 
				$tunjangan_hadir_rapat = $this->input->post('tunjangan_hadir_rapat'.$nrp_peg, TRUE); 
				$tunjangan_hadir_kjm = $this->input->post('tunjangan_hadir_kjm'.$nrp_peg, TRUE); 
				$tunjangan_hadir_kajian_stq = $this->input->post('tunjangan_hadir_kajian_stq'.$nrp_peg, TRUE); 
				$tunjangan_hadir_lain = $this->input->post('tunjangan_hadir_lain'.$nrp_peg, TRUE); 

				if ($potongan[0] != ""){ $potongan1=$potongan[0]; } else { $potongan1=0; }
				if ($potongan[1] != ""){ $potongan2=$potongan[1]; } else { $potongan2=0; }
				if ($potongan[2] != ""){ $potongan3=$potongan[2]; } else { $potongan3=0; }
				if ($potongan[3] != ""){ $potongan4=$potongan[3]; } else { $potongan4=0; }
				if ($potongan[4] != ""){ $potongan5=$potongan[4]; } else { $potongan5=0; }
				if ($potongan[5] != ""){ $potongan6=$potongan[5]; } else { $potongan6=0; }
				if ($potongan[6] != ""){ $potongan7=$potongan[6]; } else { $potongan7=0; }
				if ($potongan[7] != ""){ $potongan8=$potongan[7]; } else { $potongan8=0; }
				if ($potongan[8] != ""){ $potongan9=$potongan[8]; } else { $potongan9=0; }
				if ($potongan[9] != ""){ $potongan10=$potongan[9]; } else { $potongan10=0; }
				if ($potongan[10] != ""){ $potongan11=$potongan[10]; } else { $potongan11=0; }
				if ($potongan[11] != ""){ $potongan12=$potongan[11]; } else { $potongan12=0; }
				if ($potongan[12] != ""){ $potongan13=$potongan[12]; } else { $potongan13=0; }
				if ($potongan[13] != ""){ $potongan14=$potongan[13]; } else { $potongan14=0; }
				if ($potongan[14] != ""){ $potongan15=$potongan[14]; } else { $potongan15=0; }
				if ($potongan[15] != ""){ $potongan16=$potongan[15]; } else { $potongan16=0; }
				if ($potongan[16] != ""){ $potongan17=$potongan[16]; } else { $potongan17=0; }
				if ($potongan[17] != ""){ $potongan18=$potongan[17]; } else { $potongan18=0; }
				if ($potongan[18] != ""){ $potongan19=$potongan[18]; } else { $potongan19=0; }
				if ($potongan[19] != ""){ $potongan20=$potongan[19]; } else { $potongan20=0; }

				if (($periode != "") && ($nrp_peg != "")){ 
					$ar_cat = array('petugas'=>$petugas, 'tanggal' => $hariini, 'periode'=>$periode, 'nrp'=>$nrp_peg, 'id_jabatan'=>$id_jabatan, 'id_sekolah'=>$id_sekolah, 'gaji_pokok'=>$gapok, 'tunj_jabatan'=>$tunj_jabatan, 'tunj_istri'=>$tunjangan_si, 'tunj_anak'=>$tunjangan_anak, 'tunj_syari'=>$tunjangan_syari, 'tunj_lamakerja'=>$tunjangan_lamakerja, 'hadir_rapat'=>$tunjangan_hadir_rapat, 'kjm'=>$tunjangan_hadir_kjm, 'kajian_ltq'=>$tunjangan_hadir_kajian_stq, 'tunj_lain'=>$tunjangan_hadir_lain, 'potongan1'=>$potongan1, 'potongan2'=>$potongan2, 'potongan3'=>$potongan3, 'potongan4'=>$potongan4, 'potongan5'=>$potongan5, 'potongan6'=>$potongan6, 'potongan7'=>$potongan7, 'potongan8'=>$potongan8, 'potongan9'=>$potongan9, 'potongan10'=>$potongan10, 'potongan11'=>$potongan11, 'potongan12'=>$potongan12, 'potongan13'=>$potongan13, 'potongan14'=>$potongan14, 'potongan15'=>$potongan15, 'potongan16'=>$potongan16, 'potongan17'=>$potongan17, 'potongan18'=>$potongan18, 'potongan19'=>$potongan19, 'potongan20'=>$potongan20, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Proses', 'ket'=>'Non Sekolah');
						$simpan = $this->m_models->save_data($ar_cat, 'k_gaji');
						//menghitung thp
						$pemasukan=$gapok+$tunj_jabatan+$tunjangan_si+$tunjangan_anak+$tunjangan_syari+$tunjangan_lamakerja+$tunjangan_hadir_rapat+$tunjangan_hadir_kjm+$tunjangan_hadir_kajian_stq+$tunjangan_hadir_lain;
						$potongan=$potongan1+$potongan2+$potongan3+$potongan4+$potongan5+$potongan6+$potongan7+$potongan8+$potongan9+$potongan10+$potongan11+$potongan12+$potongan13+$potongan14+$potongan15+$potongan16+$potongan17+$potongan18+$potongan19+$potongan20;
						$thp=$pemasukan-$potongan;
						$total_thp += $thp;
				}
				/*#simpan ke jurnal
				$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 	
				$nm_divisi=all("sekolah", "id_sekolah", $id_sekolah, "nama");
				$uraian="Beban gaji pegawai ".$nm_divisi;
		   		$no_jurnal=array('tgl' => $hariini, 'no_transaksi' => $no_transaksi, 'akun1' => $akun2, 'uraian1' => $uraian, 'debet1' => $total_thp, 'kredit1' => "0", 'akun2' => $akun1, 'uraian2' => $uraian, 'debet2' => "0", 'kredit2' => $total_thp, 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => "mutasi kas", 'id_tahun'=>$tahun, 'nrp'=> $nrp); 
		       	$simpan_jurnal=$this->m_models->save_data($no_jurnal, "jurnal");*/
			}
		}		
		if ($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/ajuan_penggajian');
	}

	public function simpan_gaji_dapur(){
		$petugas=$this->session->userdata['nrp'];

		$nrp = $this->input->post('nrp', TRUE); 
		$no_peg = $this->input->post('no_peg', TRUE); 
		$no = $this->input->post('no', TRUE); 
		$periode = $this->input->post('periode', TRUE); 
		$akun1 = $this->input->post('akun', TRUE);  
		$hariini=date("Y-m-d");
		for ($i=0; $i <= $no_peg; $i++){ 
			$nrp_peg=$nrp[$i];
			if ($nrp_peg != ""){
				$id_sekolah = $this->input->post('id_sekolah'.$nrp_peg, TRUE); 
				$id_jabatan = $this->input->post('id_jabatan'.$nrp_peg, TRUE); 
				//potongan
				for ($j=0; $j <= $no ; $j++){
					$pot = $this->input->post('potongan', TRUE); 
					if ($pot[$j] != ""){
						$potongan[$j] = $pot[$j];
					} else {
						$potongan[$j] = 0;
					}
				}

				if ($id_sekolah=="7"){
					$akun2 = "5.10.2.01";
				} else {
					$akun2 = "5.21.1.01";
				}
				//tunjangan-tunjangan
				$gapok = $this->input->post('gapok'.$nrp_peg, TRUE); 
				$tunj_jabatan = $this->input->post('tunj_jabatan'.$nrp_peg, TRUE); 
				$tunjangan_si = $this->input->post('tunjangan_si'.$nrp_peg, TRUE); 
				$tunjangan_anak = $this->input->post('tunjangan_anak'.$nrp_peg, TRUE); 
				$tunjangan_dapur = $this->input->post('tunjangan_dapur'.$nrp_peg, TRUE); 
				$tunjangan_lamakerja = $this->input->post('tunjangan_lamakerja'.$nrp_peg, TRUE); 
				$tunjangan_transport = $this->input->post('tunjangan_transport'.$nrp_peg, TRUE); 
				$tunjangan_hadir_lain = $this->input->post('tunjangan_hadir_lain'.$nrp_peg, TRUE); 

				if ($potongan[0] != ""){ $potongan1=$potongan[0]; } else { $potongan1=0; }
				if ($potongan[1] != ""){ $potongan2=$potongan[1]; } else { $potongan2=0; }
				if ($potongan[2] != ""){ $potongan3=$potongan[2]; } else { $potongan3=0; }
				if ($potongan[3] != ""){ $potongan4=$potongan[3]; } else { $potongan4=0; }
				if ($potongan[4] != ""){ $potongan5=$potongan[4]; } else { $potongan5=0; }
				if ($potongan[5] != ""){ $potongan6=$potongan[5]; } else { $potongan6=0; }
				if ($potongan[6] != ""){ $potongan7=$potongan[6]; } else { $potongan7=0; }
				if ($potongan[7] != ""){ $potongan8=$potongan[7]; } else { $potongan8=0; }
				if ($potongan[8] != ""){ $potongan9=$potongan[8]; } else { $potongan9=0; }
				if ($potongan[9] != ""){ $potongan10=$potongan[9]; } else { $potongan10=0; }
				if ($potongan[10] != ""){ $potongan11=$potongan[10]; } else { $potongan11=0; }
				if ($potongan[11] != ""){ $potongan12=$potongan[11]; } else { $potongan12=0; }
				if ($potongan[12] != ""){ $potongan13=$potongan[12]; } else { $potongan13=0; }
				if ($potongan[13] != ""){ $potongan14=$potongan[13]; } else { $potongan14=0; }
				if ($potongan[14] != ""){ $potongan15=$potongan[14]; } else { $potongan15=0; }
				if ($potongan[15] != ""){ $potongan16=$potongan[15]; } else { $potongan16=0; }
				if ($potongan[16] != ""){ $potongan17=$potongan[16]; } else { $potongan17=0; }
				if ($potongan[17] != ""){ $potongan18=$potongan[17]; } else { $potongan18=0; }
				if ($potongan[18] != ""){ $potongan19=$potongan[18]; } else { $potongan19=0; }
				if ($potongan[19] != ""){ $potongan20=$potongan[19]; } else { $potongan20=0; }

				if (($periode != "") && ($nrp_peg != "")){ 
					$ar_cat = array('petugas'=>$petugas, 'tanggal' => $hariini, 'periode'=>$periode, 'nrp'=>$nrp_peg, 'id_jabatan'=>$id_jabatan, 'id_sekolah'=>$id_sekolah, 'gaji_pokok'=>$gapok, 'tunj_jabatan'=>$tunj_jabatan, 'tunj_istri'=>$tunjangan_si, 'tunj_anak'=>$tunjangan_anak, 'tunj_syari'=>$tunjangan_dapur, 'tunj_lamakerja'=>$tunjangan_lamakerja, 'transport'=>$tunjangan_transport, 'tunj_lain'=>$tunjangan_hadir_lain, 'potongan1'=>$potongan1, 'potongan2'=>$potongan2, 'potongan3'=>$potongan3, 'potongan4'=>$potongan4, 'potongan5'=>$potongan5, 'potongan6'=>$potongan6, 'potongan7'=>$potongan7, 'potongan8'=>$potongan8, 'potongan9'=>$potongan9, 'potongan10'=>$potongan10, 'potongan11'=>$potongan11, 'potongan12'=>$potongan12, 'potongan13'=>$potongan13, 'potongan14'=>$potongan14, 'potongan15'=>$potongan15, 'potongan16'=>$potongan16, 'potongan17'=>$potongan17, 'potongan18'=>$potongan18, 'potongan19'=>$potongan19, 'potongan20'=>$potongan20, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Proses', 'ket'=>'Non Sekolah');
						$simpan = $this->m_models->save_data($ar_cat, 'k_gaji');
						//menghitung thp
						$pemasukan=$gapok+$tunj_jabatan+$tunjangan_si+$tunjangan_anak+$tunjangan_dapur+$tunjangan_lamakerja+$tunjangan_transport+$tunjangan_hadir_lain;
						$potongan=$potongan1+$potongan2+$potongan3+$potongan4+$potongan5+$potongan6+$potongan7+$potongan8+$potongan9+$potongan10+$potongan11+$potongan12+$potongan13+$potongan14+$potongan15+$potongan16+$potongan17+$potongan18+$potongan19+$potongan20;
						$thp=$pemasukan-$potongan;
						$total_thp += $thp;
				}
				#simpan ke jurnal
				/*$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 	
				$nm_divisi=all("sekolah", "id_sekolah", $id_sekolah, "nama");
				$uraian="Beban gaji pegawai ".$nm_divisi;
		   		$no_jurnal=array('tgl' => $hariini, 'no_transaksi' => $no_transaksi, 'akun1' => $akun2, 'uraian1' => $uraian, 'debet1' => $total_thp, 'kredit1' => "0", 'akun2' => $akun1, 'uraian2' => $uraian, 'debet2' => "0", 'kredit2' => $total_thp, 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => "mutasi kas", 'id_tahun'=>$tahun, 'nrp'=> $nrp); 
		       	$simpan_jurnal=$this->m_models->save_data($no_jurnal, "jurnal");*/
			}
		}		
		if ($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/ajuan_penggajian');
	}


	# input kehadiran untuk data penggajian
	public function input_kehadiran(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah"); 

		$data['tahun'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_on']=date("Y");

		if (($id_sekolah=="18") or ($id_sekolah=="8")){
	    	$ar_div = array('status_aktif' => "on");
		} else {
			$ar_div = array('status_aktif' => "on", 'id_sekolah'=>$id_sekolah);
		}

		$kategori_sekolah=all("sekolah", "id_sekolah", $id_sekolah, "kategori");

		if ($kategori_sekolah=="Sekolah"){
			$kategori_gaji="Non Pengurus/Divisi";
		} else {
			$kategori_gaji="Pengurus/Divisi";
		}
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");
		$ar=array('id_rumus !=' => "12", 'id_rumus!=' => "13", 'id_rumus != ' => "14", 'kategori'=>$kategori_gaji);
		$data['k_gr'] = $this->m_models->getTabelwhere("*", "k_gaji_rumus", $ar, "keterangan", "asc");

		$bln = $this->input->post('bln', TRUE); 
		$tahun = $this->input->post('tahun', TRUE); 
		$jenjang = $this->input->post('jenjang', TRUE); 
		$data['kirim']="$tahun-$bln-$jenjang";
		if (($bln != "") && ($tahun != "") && ($jenjang != "")){
			$periode = $tahun."-".$bln."-00";

			$as=array('periode =' => $periode, 'id_sekolah'=>$jenjang);
			$data['kehadiran'] = $this->m_models->getTabelwhere("*", "k_tunj_hadir", $as, "nrp", "asc");
			foreach ($data['kehadiran'] as $k){
				$arumus=array('id_rumus' => $k->id_rumus);
				$data['rumus'] = $this->m_models->getTabelwhere("*", "k_gaji_rumus", $arumus, "keterangan", "asc");
				$data['jenis_kehadiran'][$k->id_hadir]=$data['rumus']['0']->keterangan;
			}
		}

		$this->load->view('penggajian/input_kehadiran_tunjangan', $data);
		$this->load->view('template/footer');
	}

	public function cetakkehadiran(){ 
		$id = $this->uri->segment(3); 
		$ex=explode("-", $id);
		$bln=$ex['1'];
		$tahun=$ex['0'];
		$jenjang=$ex['2']; 
		if (($bln != "") && ($tahun != "") && ($jenjang != "")){
			$periode = $tahun."-".$bln."-00";
			$data['periode']=$periode;

			$as=array('periode =' => $periode, 'id_sekolah'=>$jenjang);
			$data['kehadiran'] = $this->m_models->getTabelwhere("*", "k_tunj_hadir", $as, "nrp", "asc");
			foreach ($data['kehadiran'] as $k){
				$arumus=array('id_rumus' => $k->id_rumus);
				$data['rumus'] = $this->m_models->getTabelwhere("*", "k_gaji_rumus", $arumus, "keterangan", "asc");
				$data['jenis_kehadiran'][$k->id_hadir]=$data['rumus']['0']->keterangan;
			}
		}


		$this->load->view('penggajian/cetakkehadiran', $data);
	}



	public function pegawaitunj(){ 
		$id_sekolah = $this->input->get('id_sekolah', TRUE);  

		$as=array('status_aktf =' => 'Aktif', 'id_sekolah'=>$id_sekolah);
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "pegawai", $as, "nama", "asc");

		$this->load->view('penggajian/pegawaitunj', $data);
	}


	public function simpan_hadir_tunj(){ 
		$nrp=$this->session->userdata['nrp'];

		$jenis = $this->input->post('jenis', TRUE); 
		$bln = $this->input->post('bln', TRUE); 
		$tahun = $this->input->post('tahun', TRUE); 
		$id_sekolah = $this->input->post('id_sekolah', TRUE);
		$dt_nrp = $this->input->post('nrp', TRUE);
		$no = $this->input->post('no', TRUE);

		$periode= $tahun."-".$bln."-00";
		$hariini=date("Y-m-d");
		for ($i=0; $i <= $no; $i++){
			$nrp_peg=$dt_nrp[$i];
			$jml = $this->input->post('jml'.$nrp_peg, TRUE);

			if (($jml != "") && ($id_sekolah != "") && ($periode != "") && ($nrp_peg != "") && ($jenis != "")){
				$ar_cat = array('nrp'=>$nrp_peg, 'jml_hadir' => $jml, 'periode'=>$periode, 'id_sekolah'=>$id_sekolah, 'tgl'=>$hariini, 'petugas'=>$nrp, 'id_rumus'=>$jenis);
				$simpan = $this->m_models->save_data($ar_cat, 'k_tunj_hadir');
			}
		}
		if ($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/input_kehadiran');
	}


	# lihat data gaji
	public function data_gaji(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah"); 

		if (($id_sekolah=="18") or ($id_sekolah=="8")){
	    	$ar_div = array('status_aktif' => "on");
		} else {
			$ar_div = array('status_aktif' => "on", 'id_sekolah'=>$id_sekolah);
		}
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");
  		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");

		$data['jenis_potongan'] = $this->m_models->getTabelOrder("*", "k_jenis_potgaji", "jenis_pot", "asc");
		$data['thn_on']=date("Y");
		$data['bln_now']=date("m");

		$bln = $this->input->post('bln', TRUE);  
		$tahun = $this->input->post('tahun', TRUE);  
		$jenjang = $this->input->post('jenjang', TRUE);  
		$periode = $tahun."-".$bln."-00";
		if (($periode != "") && ($jenjang != "")){
			$data['periode']=$tahun."-".$bln;
			$ar_pot=array('periode' => $periode, 'id_sekolah'=>$jenjang);
			$data['pegawai'] = $this->m_models->getTabelwhere("*", "k_gaji", $ar_pot, "idgaji", "asc");

			$ket_sekolah=all("sekolah", "id_sekolah", $jenjang, "kategori");
			if ($ket_sekolah=="Sekolah"){
				$this->load->view('penggajian/data_gaji', $data);
				$this->load->view('penggajian/dt_gaji_sekolah', $data);
			} else if ($ket_sekolah=="Non Sekolah"){ 
				$this->load->view('penggajian/data_gaji', $data);
				$this->load->view('penggajian/dt_gaji_nonsekolah', $data);
			}

		} else {
			$this->load->view('penggajian/data_gaji', $data);
		}
		$this->load->view('template/footer');
	}

	public function printslipgaji(){
		$nrp_petugas=$this->session->userdata['nrp']; 
		$id = $this->uri->segment(3); 

		$ar_pot=array('idgaji' => $id);
		$data['pegawai'] = $this->m_models->getTabelwhere("*", "k_gaji", $ar_pot, "idgaji", "asc");
		$jenjang=$data['pegawai'][0]->id_sekolah;
		$data['ket_sekolah']=all("sekolah", "id_sekolah", $jenjang, "kategori");
		$data['id_jabatan']=all("pegawai", "nrp", $data['pegawai'][0]->nrp, "id_jabatan");
		$data['gaji_eks']=all("k_gaji_eksklusif", "nrp", $data['pegawai'][0]->nrp, "nominal");
		$data['id_sekolah']=$jenjang;

		$data['jenis_potongan'] = $this->m_models->getTabelOrder("*", "k_jenis_potgaji", "jenis_pot", "asc");

		$this->load->library('pdf');
		//$this->pdf->setPaper("A4", 'portrait');
		$customPaper = array(0,0,269.291339,368.503937);
		$this->pdf->setPaper($customPaper, 'potrait');
		$this->pdf->load_view('penggajian/printslipgaji', $data);
		$this->pdf->render();
		$this->pdf->stream("slip_gaji.pdf", array('Attachment'=>0));
	}

	#setting gaji eksklusif
	public function setting_gaji_eks(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah"); 

		if (($id_sekolah=="18") or ($id_sekolah=="8")){
	    	$ar_div = array('status_aktif' => "on");
		} else {
			$ar_div = array('status_aktif' => "on", 'id_sekolah'=>$id_sekolah);
		}
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");

		$data['gaji_eks'] = $this->m_models->getTabelOrder("*", "k_gaji_eksklusif", "tgl_input", "asc");


		$this->load->view('penggajian/set_gaji_eks', $data);
		$this->load->view('penggajian/edit_gaji_eks', $data);  
		$this->load->view('template/footer');
	}

	public function ceknm_peg(){  
		$id_sekolah = $this->input->get('sekolah', TRUE); 

	    $data['pegawai'] = $this->m_models->getAll("pegawai where id_sekolah='$id_sekolah' and status_aktf='Aktif' order by nama");

		$this->load->view('penggajian/ceksekolah', $data);
	}

	public function simpan_set_gaji_eks(){
		$nrp_user=$this->session->userdata['nrp'];
		
		$nrp = $this->input->post('nrp', TRUE); 
		$no_peg = $this->input->post('no_peg', TRUE); 
		for ($i=0; $i <= $no_peg; $i++){ 
			$nrp_peg=$nrp[$i];
			if ($nrp_peg != ""){ 
				$hariini=date("Y-m-d");
				$nominal = nominalIndo($this->input->post('nominal'.$nrp_peg, TRUE)); 
				$ar_cat = array('nrp'=>$nrp_peg, 'nominal' => $nominal, 'user'=>$nrp_user, 'tgl_input'=>$hariini);
				$simpan = $this->m_models->save_data($ar_cat, 'k_gaji_eksklusif');
			}
		}

		if ($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/setting_gaji_eks');
	}

	public function edit_gaji_eks(){ 
		$nrp_petugas=$this->session->userdata['nrp']; 
		$id = $this->input->post('id'); 
		$data['id'] = $this->input->post('id'); 

		$data['golongan'] = $this->m_models->getTabelOrder("*", "golongan", "golongan", "asc");
		$data['tingkat_pendidikan'] = $this->m_models->getTabelOrder("*", "tingkat_pendidikan", "id_tp", "asc");


		$this->load->view('penggajian/edit_gaji_eks', $data);
	}

	public function update_gaji_eksklusif(){
		$nrp_petugas=$this->session->userdata['nrp']; 
		$id_gaji_eks = $this->input->post('id_gaji_eks', TRUE);  
		$nominal = nominalIndo($this->input->post('nominal', TRUE));  

		 if (($id_gaji_eks != "")&&($nominal != "")){
			$hariini=date("Y-m-d");
			$j_off= array('nominal'=>$nominal, 'tgl_input'=>$hariini, 'user'=>$nrp_petugas);
			if ($this->m_models->update_data($id_gaji_eks, "id_gaji_eks", $j_off, "k_gaji_eksklusif") == TRUE){
				$this->session->set_flashdata('sukses', 'Data berhasil diubah');
			}else{
				$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
			}
			redirect('penggajian/setting_gaji_eks'); 
		} 
	}

	#ajuan penggajian eksklusif
	public function ajuan_penggajian_eks(){
		$this->load->view('template/header'); 
		$nrp=$this->session->userdata['nrp'];
		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah"); 

	    $ar=array('status' => "on");
		$data['jenis_potongan'] = $this->m_models->getTabelwhere("*", "k_jenis_potgaji", $ar, "jenis_pot", "asc");

  		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_on']=date("Y");
		$data['bln_now']=date("m");

		$data['akun']=$this->m_models->getAll("akun where (id_akun like '1.1.1.%' or id_akun like '1.1.3.%') and id_akun in (select id_akun from pilihan_akun where id_sekolah='$id_sekolah' and status='on' ) order by nama_akun asc ");

		$bln = $this->input->post('bln', TRUE);  
		$tahun = $this->input->post('tahun', TRUE);
		$periode = $tahun."-".$bln."-00";
		if ($periode != ""){
			$data['periode']=$tahun."-".$bln;
			$data['pegawai'] = $this->m_models->getAll("pegawai where status_aktf='Aktif' and nrp in (select nrp from k_gaji_eksklusif) order by nama asc");

			$arp=array('status' => 'on');
			$data['jenis_pot'] = $this->m_models->getRowsAWhere("*", "k_jenis_potgaji", $arp, "id_jenispot", "asc");
			$data['jenispot'] = $this->m_models->getTabelwhere("*", "k_jenis_potgaji", $arp, "id_jenispot", "asc");

			$ket_sekolah=all("sekolah", "id_sekolah", $jenjang, "kategori");
		}
		
		$this->load->view('penggajian/penggajian_eksklusif', $data);
		$this->load->view('template/footer');
	}

	public function simpan_gaji_eks(){
		$petugas=$this->session->userdata['nrp'];

		$nrp = $this->input->post('nrp', TRUE); 
		$no_peg = $this->input->post('no_peg', TRUE); 
		$no = $this->input->post('no', TRUE); 
		$periode = $this->input->post('periode', TRUE); 
		$akun1 = $this->input->post('akun', TRUE);  
		
		$hariini=date("Y-m-d");
		for ($i=0; $i <= $no_peg; $i++){ 
			$nrp_peg=$nrp[$i];
			if ($nrp_peg != ""){
				$id_sekolah = $this->input->post('id_sekolah'.$nrp_peg, TRUE); 
				$id_jabatan = $this->input->post('id_jabatan'.$nrp_peg, TRUE); 
				//potongan
				for ($j=0; $j <= $no ; $j++){
					$pot = $this->input->post('potongan', TRUE); 
					if ($pot[$j] != ""){
						$potongan[$j] = $pot[$j];
					} else {
						$potongan[$j] = 0;
					}
				}

				if ($id_sekolah=="7"){
					$akun2 = "5.10.2.01";
				} else {
					$akun2 = "5.21.1.01";
				}

				//tunjangan-tunjangan
				$gapok = $this->input->post('gapok'.$nrp_peg, TRUE); 

				if ($potongan[0] != ""){ $potongan1=$potongan[0]; } else { $potongan1=0; }
				if ($potongan[1] != ""){ $potongan2=$potongan[1]; } else { $potongan2=0; }
				if ($potongan[2] != ""){ $potongan3=$potongan[2]; } else { $potongan3=0; }
				if ($potongan[3] != ""){ $potongan4=$potongan[3]; } else { $potongan4=0; }
				if ($potongan[4] != ""){ $potongan5=$potongan[4]; } else { $potongan5=0; }
				if ($potongan[5] != ""){ $potongan6=$potongan[5]; } else { $potongan6=0; }
				if ($potongan[6] != ""){ $potongan7=$potongan[6]; } else { $potongan7=0; }
				if ($potongan[7] != ""){ $potongan8=$potongan[7]; } else { $potongan8=0; }
				if ($potongan[8] != ""){ $potongan9=$potongan[8]; } else { $potongan9=0; }
				if ($potongan[9] != ""){ $potongan10=$potongan[9]; } else { $potongan10=0; }
				if ($potongan[10] != ""){ $potongan11=$potongan[10]; } else { $potongan11=0; }
				if ($potongan[11] != ""){ $potongan12=$potongan[11]; } else { $potongan12=0; }
				if ($potongan[12] != ""){ $potongan13=$potongan[12]; } else { $potongan13=0; }
				if ($potongan[13] != ""){ $potongan14=$potongan[13]; } else { $potongan14=0; }
				if ($potongan[14] != ""){ $potongan15=$potongan[14]; } else { $potongan15=0; }
				if ($potongan[15] != ""){ $potongan16=$potongan[15]; } else { $potongan16=0; }
				if ($potongan[16] != ""){ $potongan17=$potongan[16]; } else { $potongan17=0; }
				if ($potongan[17] != ""){ $potongan18=$potongan[17]; } else { $potongan18=0; }
				if ($potongan[18] != ""){ $potongan19=$potongan[18]; } else { $potongan19=0; }
				if ($potongan[19] != ""){ $potongan20=$potongan[19]; } else { $potongan20=0; }


				if (($periode != "") && ($nrp_peg != "")){
					$ar_cat = array('petugas'=>$petugas, 'tanggal' => $hariini, 'periode'=>$periode, 'nrp'=>$nrp_peg, 'id_jabatan'=>$id_jabatan, 'id_sekolah'=>$id_sekolah, 'gaji_pokok'=>$gapok,'potongan1'=>$potongan1, 'potongan2'=>$potongan2, 'potongan3'=>$potongan3, 'potongan4'=>$potongan4, 'potongan5'=>$potongan5, 'potongan6'=>$potongan6, 'potongan7'=>$potongan7, 'potongan8'=>$potongan8, 'potongan9'=>$potongan9, 'potongan10'=>$potongan10, 'potongan11'=>$potongan11, 'potongan12'=>$potongan12, 'potongan13'=>$potongan13, 'potongan14'=>$potongan14, 'potongan15'=>$potongan15, 'potongan16'=>$potongan16, 'potongan17'=>$potongan17, 'potongan18'=>$potongan18, 'potongan19'=>$potongan19, 'potongan20'=>$potongan20, 'approve1'=>'Approve', 'approve2'=>'Approve', 'approve3'=>'Proses', 'ket'=>'Sekolah');
						$simpan = $this->m_models->save_data($ar_cat, 'k_gaji');

						//menghitung thp
						$pemasukan=$gapok+$tunj_jabatan+$tunjangan_si+$tunjangan_anak+$tunjangan_syari+$tunjangan_lamakerja+$tunjangan_transport+$tunjangan_hadir_rapat+$tunjangan_hadir_kjm+$tunjangan_hadir_tahfidz+$tunjangan_hadir_bahasa+$tunjangan_hadir_piket+$tunjangan_hadir_bljrmlm+$tunjangan_hadir_kajian_ltq+$tunjangan_hadir_temporer+$tunjangan_hadir_lain;
						$potongan=$potongan1+$potongan2+$potongan3+$potongan4+$potongan5+$potongan6+$potongan7+$potongan8+$potongan9+$potongan10+$potongan11+$potongan12+$potongan13+$potongan14+$potongan15+$potongan16+$potongan17+$potongan18+$potongan19+$potongan20;
						$thp=$pemasukan-$potongan;
						$total_thp += $thp;
				}
				/*#simpan ke jurnal
				$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 	
				$nm_divisi=all("sekolah", "id_sekolah", $id_sekolah, "nama");
				$uraian="Beban gaji pegawai ".$nm_divisi;
		   		$no_jurnal=array('tgl' => $hariini, 'no_transaksi' => $no_transaksi, 'akun1' => $akun2, 'uraian1' => $uraian, 'debet1' => $total_thp, 'kredit1' => "0", 'akun2' => $akun1, 'uraian2' => $uraian, 'debet2' => "0", 'kredit2' => $total_thp, 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => "mutasi kas", 'id_tahun'=>$tahun, 'nrp'=> $nrp); 
		       	$simpan_jurnal=$this->m_models->save_data($no_jurnal, "jurnal");*/
			}
		}

		if ($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/ajuan_penggajian_eks');
	}

	#import data master no rekening pegawai
	public function import_norek_pegawai(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$data['no_rekening']=$this->m_models->getTabelOrder("*", "k_no_rekening", "tgl_input", "asc");
		

		$this->load->view('penggajian/import_norek_pegawai',$data);
		$this->load->view('template/footer');
	}

	public function upload_norek(){
		$nrp=$this->session->userdata['nrp']; 
	  	$fileName = $this->input->post('file', TRUE);

	  	$config['upload_path'] = './assets/upload/'; 
		$config['file_name'] = $fileName;
		$config['allowed_types'] = 'xls|xlsx|csv|ods|ots';
		$config['max_size'] = 10000;

	  	$this->load->library('upload', $config);
	  	$this->upload->initialize($config); 
	  
	  	if (!$this->upload->do_upload('file')) {
		   	$error = array('error' => $this->upload->display_errors());
		   	$this->session->set_flashdata('msg','Ada kesalahan dalam upload'); 
			redirect('penggajian/import_norek_pegawai');
	  	} else { 
		   	$media = $this->upload->data();
		   	$inputFileName = 'assets/upload/'.$media['file_name'];
		   
		  	try {
			    $inputFileType = IOFactory::identify($inputFileName);
			    $objReader = IOFactory::createReader($inputFileType);
			    $objPHPExcel = $objReader->load($inputFileName);
		   	} catch(Exception $e) {
		    	die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
	   		}

		    $sheet = $objPHPExcel->getSheet(0);
		   	$highestRow = $sheet->getHighestRow();
		   	$highestColumn = $sheet->getHighestColumn();
		   	$hariini=date("Y-m-d");

	   		for ($row = 2; $row <= $highestRow; $row++){  
		     	$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,
		       	NULL,
		       	TRUE,
		       	FALSE);

			 	$ar_i = array(
			     	"no_rekening"=> $rowData[0][0],
			     	"kd_bank"=> $rowData[0][1],
			     	"atas_nama"=> $rowData[0][2],
			     	"nrp"=> $rowData[0][3],
			     	"tgl_input"=>$hariini, 
			     	"nrp_input"=>$nrp
	    		); 

				 
	    		if (($rowData[0][0] != "") && ($rowData[0][1] != "") && ($rowData[0][2] != "") && ($rowData[0][3] != "") ){
					$jml=$this->m_models->getRowsWhere("*", "k_no_rekening", "nrp", $rowData[0][3], "nrp", "asc");
					if ($jml==0){
						$this->m_models->save_data($ar_i, 'k_no_rekening');
					} else {
						$this->m_models->update_data($rowData[0][0], "nrp", $ar_i, "k_no_rekening");
					}
	    			
	    		}
	   		} 
		   	// delete file
	        unlink($inputFileName);

	   		$this->session->set_flashdata('msg','Berhasil upload ...!!'); 
	   		redirect('penggajian/import_norek_pegawai'); 
	  	}  
	} 

	public function download_file_norek($nm_file, $tipe_file){
		$this->load->view('template/header');
		$this->load->helper('download');
		
		force_download('assets/upload/'.$nm_file.'.'.$tipe_file, NULL);
	}

	public function kode_bank(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$kode_bank = $this->input->post('kode_bank', TRUE);  
		$nm_bank = $this->input->post('nm_bank', TRUE);  
		if (($kode_bank != "") && ($nm_bank != "")){
			$ar_i = array("kd_bank"=> $kode_bank, "nm_bank"=> $nm_bank); 
			$this->m_models->save_data($ar_i, 'k_kode_bank');
			redirect('penggajian/kode_bank');			
		}

		$data['kode_bank']=$this->m_models->getTabelOrder("*", "k_kode_bank", "nm_bank", "asc");

		$this->load->view('penggajian/kode_bank',$data);
		$this->load->view('template/footer');
	}

	#data payroll
	public function data_payroll(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_on']=date("Y");
		$data['bln_now']=date("m");

		$bln = $this->input->post('bln', TRUE);  
		$tahun = $this->input->post('tahun', TRUE); 
		$periode = $tahun."-".$bln."-00"; 
		$data['periode']=$periode;

		if (($bln != "") && ($tahun != "")){ 
			$ar_pot=array('periode' => $periode);
			$data['data_gaji'] = $this->m_models->getJoin1where("*", "k_gaji", "k_no_rekening", "k_no_rekening.nrp=k_gaji.nrp", $ar_pot, "idgaji", "asc");
		}
		$this->load->view('penggajian/data_payroll_bank',$data);
		$this->load->view('template/footer');
	}

	public function download_dt_payroll(){
		$nrp=$this->session->userdata['nrp']; 
		$periode = $this->uri->segment(3); 
		$data['periode']=$periode;

		if (($periode != "")){ 
			$ar_pot=array('periode' => $periode);
			$data['data_gaji'] = $this->m_models->getJoin1where("*", "k_gaji", "k_no_rekening", "k_no_rekening.nrp=k_gaji.nrp", $ar_pot, "idgaji", "asc");
		}
		$this->load->view('penggajian/download_dt_payroll',$data);
	}

	#released penggajian
	public function released_penggajian(){
		$this->load->view('template/header');
		$nrp=$this->session->userdata['nrp']; 

		$id_sekolah = $this->m_models->getSession($nrp, "id_sekolah"); 

		if (($id_sekolah=="18") or ($id_sekolah=="8")){
	    	$ar_div = array('status_aktif' => "on");
		} else {
			$ar_div = array('status_aktif' => "on", 'id_sekolah'=>$id_sekolah);
		}
	    $data['sekolah'] = $this->m_models->getTabelwhere("*", "sekolah", $ar_div, "nama", "asc");

		$arp=array('status' => 'on');
		$data['jenis_pot'] = $this->m_models->getRowsAWhere("*", "k_jenis_potgaji", $arp, "id_jenispot", "asc");
		$data['jenispot'] = $this->m_models->getTabelwhere("*", "k_jenis_potgaji", $arp, "id_jenispot", "asc");

  		$data['thn_akademik'] = $this->m_models->getTabelOrder("*", "tahun_akademik", "tahun2", "desc");
		$data['thn_on']=date("Y");
		$data['bln_now']=date("m");

		$data['akun']=$this->m_models->getAll("akun where (id_akun like '1.1.1.%' or id_akun like '1.1.3.%') and id_akun in (select id_akun from pilihan_akun where id_sekolah='$id_sekolah' and status='on' ) order by nama_akun asc ");

		$bln = $this->input->post('bln', TRUE);  
		$tahun = $this->input->post('tahun', TRUE);  
		$jenjang = $this->input->post('jenjang', TRUE);  
		$periode = $tahun."-".$bln."-00";
		$data['thnbln']=$tahun."-".$bln;
		$data['periode']=$periode;
		if (($periode != "") && ($jenjang != "")){
			$ar_pot=array('periode' => $periode, 'id_sekolah'=>$jenjang, 'approve3'=>'Proses');
			$data['data_gaji'] = $this->m_models->getTabelwhere("*", "k_gaji", $ar_pot, "idgaji", "asc");

			$ket_sekolah=all("sekolah", "id_sekolah", $jenjang, "kategori");
			if ($ket_sekolah=="Sekolah"){
				$this->load->view('penggajian/released_penggajian', $data);
			} else if ($ket_sekolah=="Non Sekolah"){
				//Dapur
				if (($jenjang=="10") or ($jenjang=="11")){
					$this->load->view('penggajian/released_penggajian_dapur', $data);
				} else {
					$this->load->view('penggajian/released_penggajian_nonsekolah', $data);
				}
			}
		} else {
			$this->load->view('penggajian/released_penggajian',$data);
		}
		$this->load->view('template/footer');
	}

	public function simpan_released_gaji(){
		$petugas=$this->session->userdata['nrp'];

		$id_gaji = $this->input->post('idgaji', TRUE); 
		$no_peg = $this->input->post('no_peg', TRUE); 
		$no = $this->input->post('no', TRUE); 
		$periode = $this->input->post('periode', TRUE); 
		$akun1 = $this->input->post('akun', TRUE);  
		$thp = $this->input->post('thp', TRUE);  
		$total_thp = $this->input->post('thp', TRUE);  
		$id_sekolah = $this->input->post('id_sekolah', TRUE); 
		
		$hariini=date("Y-m-d");
		for ($i=0; $i <= $no_peg; $i++){ 
			$idgaji=$id_gaji[$i];
			if ($idgaji != ""){
				if ($id_sekolah=="7"){
					$akun2 = "5.10.2.01";
				} else {
					$akun2 = "5.21.1.01";
				}

				if (($periode != "") && ($idgaji != "")){
					$ar_cat = array('approve3'=>'Approve');
					$simpan = $this->m_models->update_data($idgaji, "idgaji", $ar_cat, 'k_gaji');

				}
			}
		}
		$tahun=ta_berjalan();
		#simpan ke jurnal
				$no_transaksi = $this->m_models->notransaksi_jurnal($id_sekolah); 	
				$nm_divisi=all("sekolah", "id_sekolah", $id_sekolah, "nama");
				$uraian="Beban gaji pegawai ".$nm_divisi;
		   		$no_jurnal=array('tgl' => $hariini, 'no_transaksi' => $no_transaksi, 'akun1' => $akun2, 'uraian1' => $uraian, 'debet1' => $total_thp, 'kredit1' => "0", 'akun2' => $akun1, 'uraian2' => $uraian, 'debet2' => "0", 'kredit2' => $total_thp, 'id_sekolah' => $id_sekolah,'approve1' => "Approve",'approve2' => "Approve",'approve3' => "Approve", 'asal' => "penggajian", 'id_tahun'=>$tahun, 'nrp'=> $petugas); 
		       	$simpan_jurnal=$this->m_models->save_data($no_jurnal, "jurnal");

		if ($simpan == TRUE){
			$this->session->set_flashdata('sukses', 'Data berhasil disimpan');
		}else{
			$this->session->set_flashdata('gagal', 'Silahkan mencoba kembali !!!');
		}
		redirect('penggajian/released_penggajian');
	}



}
